# coding: utf-8

"""
    OpenFEC

    This API allows you to explore the way candidates and committees fund their campaigns.    The FEC API is a RESTful web service supporting full-text and field-specific searches on FEC data. [Bulk downloads](https://www.fec.gov/data/advanced/?tab=bulk-data) are available on the current site. Information is tied to the underlying forms by file ID and image ID. Data is updated nightly.    There is a lot of data, but a good place to start is to use search to find interesting candidates and committees. Then, you can use their IDs to find report or line item details with the other endpoints. If you are interested in individual donors, check out contributor information in schedule_a.    Get an [API key here](https://api.data.gov/signup/). That will enable you to place up to 1,000 calls an hour. Each call is limited to 100 results per page. You can email questions, comments or a request to get a key for 120 calls per minute to [APIinfo@fec.gov](mailto:apiinfo@fec.gov). You can also ask questions and discuss the data in the [FEC data Google Group](https://groups.google.com/forum/#!forum/fec-data). API changes will also be added to this group in advance of the change.    The model definitions and schema are available at [/swagger](/swagger/). This is useful for making wrappers and exploring the data.    A few restrictions limit the way you can use FEC data. For example, you can’t use contributor lists for commercial purposes or to solicit donations. [Learn more here](https://www.fec.gov/updates/sale-or-use-contributor-information/).    [View our source code](https://github.com/fecgov/openFEC). We welcome issues and pull requests!  # noqa: E501

    The version of the OpenAPI document: 1.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from openfec_sdk.configuration import Configuration


class PresidentialSummary(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'candidate_contributions_less_repayments': 'float',
        'candidate_id': 'str',
        'candidate_last_name': 'str',
        'candidate_name': 'str',
        'candidate_party_affiliation': 'str',
        'cash_on_hand_end': 'float',
        'committee_designation': 'str',
        'committee_id': 'str',
        'committee_name': 'str',
        'committee_type': 'str',
        'debts_owed_by_committee': 'float',
        'disbursements_less_offsets': 'float',
        'election_year': 'int',
        'exempt_legal_accounting_disbursement': 'float',
        'federal_funds': 'float',
        'fundraising_disbursements': 'float',
        'individual_contributions_less_refunds': 'float',
        'net_receipts': 'float',
        'offsets_to_operating_expenditures': 'float',
        'operating_expenditures': 'float',
        'other_disbursements': 'float',
        'pac_contributions_less_refunds': 'float',
        'party_contributions_less_refunds': 'float',
        'repayments_loans_made_by_candidate': 'float',
        'repayments_other_loans': 'float',
        'rounded_net_receipts': 'float',
        'total_contribution_refunds': 'float',
        'total_loan_repayments_made': 'float',
        'transfers_from_affiliated_committees': 'float',
        'transfers_to_other_authorized_committees': 'float'
    }

    attribute_map = {
        'candidate_contributions_less_repayments': 'candidate_contributions_less_repayments',
        'candidate_id': 'candidate_id',
        'candidate_last_name': 'candidate_last_name',
        'candidate_name': 'candidate_name',
        'candidate_party_affiliation': 'candidate_party_affiliation',
        'cash_on_hand_end': 'cash_on_hand_end',
        'committee_designation': 'committee_designation',
        'committee_id': 'committee_id',
        'committee_name': 'committee_name',
        'committee_type': 'committee_type',
        'debts_owed_by_committee': 'debts_owed_by_committee',
        'disbursements_less_offsets': 'disbursements_less_offsets',
        'election_year': 'election_year',
        'exempt_legal_accounting_disbursement': 'exempt_legal_accounting_disbursement',
        'federal_funds': 'federal_funds',
        'fundraising_disbursements': 'fundraising_disbursements',
        'individual_contributions_less_refunds': 'individual_contributions_less_refunds',
        'net_receipts': 'net_receipts',
        'offsets_to_operating_expenditures': 'offsets_to_operating_expenditures',
        'operating_expenditures': 'operating_expenditures',
        'other_disbursements': 'other_disbursements',
        'pac_contributions_less_refunds': 'pac_contributions_less_refunds',
        'party_contributions_less_refunds': 'party_contributions_less_refunds',
        'repayments_loans_made_by_candidate': 'repayments_loans_made_by_candidate',
        'repayments_other_loans': 'repayments_other_loans',
        'rounded_net_receipts': 'rounded_net_receipts',
        'total_contribution_refunds': 'total_contribution_refunds',
        'total_loan_repayments_made': 'total_loan_repayments_made',
        'transfers_from_affiliated_committees': 'transfers_from_affiliated_committees',
        'transfers_to_other_authorized_committees': 'transfers_to_other_authorized_committees'
    }

    def __init__(self, candidate_contributions_less_repayments=None, candidate_id=None, candidate_last_name=None, candidate_name=None, candidate_party_affiliation=None, cash_on_hand_end=None, committee_designation=None, committee_id=None, committee_name=None, committee_type=None, debts_owed_by_committee=None, disbursements_less_offsets=None, election_year=None, exempt_legal_accounting_disbursement=None, federal_funds=None, fundraising_disbursements=None, individual_contributions_less_refunds=None, net_receipts=None, offsets_to_operating_expenditures=None, operating_expenditures=None, other_disbursements=None, pac_contributions_less_refunds=None, party_contributions_less_refunds=None, repayments_loans_made_by_candidate=None, repayments_other_loans=None, rounded_net_receipts=None, total_contribution_refunds=None, total_loan_repayments_made=None, transfers_from_affiliated_committees=None, transfers_to_other_authorized_committees=None, local_vars_configuration=None):  # noqa: E501
        """PresidentialSummary - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._candidate_contributions_less_repayments = None
        self._candidate_id = None
        self._candidate_last_name = None
        self._candidate_name = None
        self._candidate_party_affiliation = None
        self._cash_on_hand_end = None
        self._committee_designation = None
        self._committee_id = None
        self._committee_name = None
        self._committee_type = None
        self._debts_owed_by_committee = None
        self._disbursements_less_offsets = None
        self._election_year = None
        self._exempt_legal_accounting_disbursement = None
        self._federal_funds = None
        self._fundraising_disbursements = None
        self._individual_contributions_less_refunds = None
        self._net_receipts = None
        self._offsets_to_operating_expenditures = None
        self._operating_expenditures = None
        self._other_disbursements = None
        self._pac_contributions_less_refunds = None
        self._party_contributions_less_refunds = None
        self._repayments_loans_made_by_candidate = None
        self._repayments_other_loans = None
        self._rounded_net_receipts = None
        self._total_contribution_refunds = None
        self._total_loan_repayments_made = None
        self._transfers_from_affiliated_committees = None
        self._transfers_to_other_authorized_committees = None
        self.discriminator = None

        self.candidate_contributions_less_repayments = candidate_contributions_less_repayments
        self.candidate_id = candidate_id
        self.candidate_last_name = candidate_last_name
        self.candidate_name = candidate_name
        self.candidate_party_affiliation = candidate_party_affiliation
        self.cash_on_hand_end = cash_on_hand_end
        self.committee_designation = committee_designation
        self.committee_id = committee_id
        self.committee_name = committee_name
        self.committee_type = committee_type
        self.debts_owed_by_committee = debts_owed_by_committee
        self.disbursements_less_offsets = disbursements_less_offsets
        self.election_year = election_year
        self.exempt_legal_accounting_disbursement = exempt_legal_accounting_disbursement
        self.federal_funds = federal_funds
        self.fundraising_disbursements = fundraising_disbursements
        self.individual_contributions_less_refunds = individual_contributions_less_refunds
        self.net_receipts = net_receipts
        self.offsets_to_operating_expenditures = offsets_to_operating_expenditures
        self.operating_expenditures = operating_expenditures
        self.other_disbursements = other_disbursements
        self.pac_contributions_less_refunds = pac_contributions_less_refunds
        self.party_contributions_less_refunds = party_contributions_less_refunds
        self.repayments_loans_made_by_candidate = repayments_loans_made_by_candidate
        self.repayments_other_loans = repayments_other_loans
        self.rounded_net_receipts = rounded_net_receipts
        self.total_contribution_refunds = total_contribution_refunds
        self.total_loan_repayments_made = total_loan_repayments_made
        self.transfers_from_affiliated_committees = transfers_from_affiliated_committees
        self.transfers_to_other_authorized_committees = transfers_to_other_authorized_committees

    @property
    def candidate_contributions_less_repayments(self):
        """Gets the candidate_contributions_less_repayments of this PresidentialSummary.  # noqa: E501

         candidate contributions less repayments   # noqa: E501

        :return: The candidate_contributions_less_repayments of this PresidentialSummary.  # noqa: E501
        :rtype: float
        """
        return self._candidate_contributions_less_repayments

    @candidate_contributions_less_repayments.setter
    def candidate_contributions_less_repayments(self, candidate_contributions_less_repayments):
        """Sets the candidate_contributions_less_repayments of this PresidentialSummary.

         candidate contributions less repayments   # noqa: E501

        :param candidate_contributions_less_repayments: The candidate_contributions_less_repayments of this PresidentialSummary.  # noqa: E501
        :type: float
        """

        self._candidate_contributions_less_repayments = candidate_contributions_less_repayments

    @property
    def candidate_id(self):
        """Gets the candidate_id of this PresidentialSummary.  # noqa: E501

         A unique identifier assigned to each candidate registered with the FEC. If a person runs for several offices, that person will have separate candidate IDs for each office.   -P00000001    All candidates   -P00000002    Democrasts   -P00000003    Republicans   # noqa: E501

        :return: The candidate_id of this PresidentialSummary.  # noqa: E501
        :rtype: str
        """
        return self._candidate_id

    @candidate_id.setter
    def candidate_id(self, candidate_id):
        """Sets the candidate_id of this PresidentialSummary.

         A unique identifier assigned to each candidate registered with the FEC. If a person runs for several offices, that person will have separate candidate IDs for each office.   -P00000001    All candidates   -P00000002    Democrasts   -P00000003    Republicans   # noqa: E501

        :param candidate_id: The candidate_id of this PresidentialSummary.  # noqa: E501
        :type: str
        """

        self._candidate_id = candidate_id

    @property
    def candidate_last_name(self):
        """Gets the candidate_last_name of this PresidentialSummary.  # noqa: E501

         Candidate last name   # noqa: E501

        :return: The candidate_last_name of this PresidentialSummary.  # noqa: E501
        :rtype: str
        """
        return self._candidate_last_name

    @candidate_last_name.setter
    def candidate_last_name(self, candidate_last_name):
        """Sets the candidate_last_name of this PresidentialSummary.

         Candidate last name   # noqa: E501

        :param candidate_last_name: The candidate_last_name of this PresidentialSummary.  # noqa: E501
        :type: str
        """

        self._candidate_last_name = candidate_last_name

    @property
    def candidate_name(self):
        """Gets the candidate_name of this PresidentialSummary.  # noqa: E501

        Name of candidate running for office  # noqa: E501

        :return: The candidate_name of this PresidentialSummary.  # noqa: E501
        :rtype: str
        """
        return self._candidate_name

    @candidate_name.setter
    def candidate_name(self, candidate_name):
        """Sets the candidate_name of this PresidentialSummary.

        Name of candidate running for office  # noqa: E501

        :param candidate_name: The candidate_name of this PresidentialSummary.  # noqa: E501
        :type: str
        """

        self._candidate_name = candidate_name

    @property
    def candidate_party_affiliation(self):
        """Gets the candidate_party_affiliation of this PresidentialSummary.  # noqa: E501

        Three-letter code for the party affiliated with a candidate or committee. For example, DEM for Democratic Party and REP for Republican Party.  # noqa: E501

        :return: The candidate_party_affiliation of this PresidentialSummary.  # noqa: E501
        :rtype: str
        """
        return self._candidate_party_affiliation

    @candidate_party_affiliation.setter
    def candidate_party_affiliation(self, candidate_party_affiliation):
        """Sets the candidate_party_affiliation of this PresidentialSummary.

        Three-letter code for the party affiliated with a candidate or committee. For example, DEM for Democratic Party and REP for Republican Party.  # noqa: E501

        :param candidate_party_affiliation: The candidate_party_affiliation of this PresidentialSummary.  # noqa: E501
        :type: str
        """

        self._candidate_party_affiliation = candidate_party_affiliation

    @property
    def cash_on_hand_end(self):
        """Gets the cash_on_hand_end of this PresidentialSummary.  # noqa: E501

        Ending cash balance on the most recent filing  # noqa: E501

        :return: The cash_on_hand_end of this PresidentialSummary.  # noqa: E501
        :rtype: float
        """
        return self._cash_on_hand_end

    @cash_on_hand_end.setter
    def cash_on_hand_end(self, cash_on_hand_end):
        """Sets the cash_on_hand_end of this PresidentialSummary.

        Ending cash balance on the most recent filing  # noqa: E501

        :param cash_on_hand_end: The cash_on_hand_end of this PresidentialSummary.  # noqa: E501
        :type: float
        """

        self._cash_on_hand_end = cash_on_hand_end

    @property
    def committee_designation(self):
        """Gets the committee_designation of this PresidentialSummary.  # noqa: E501

        The one-letter designation code of the organization:          - A authorized by a candidate          - J joint fundraising committee          - P principal campaign committee of a candidate          - U unauthorized          - B lobbyist/registrant PAC          - D leadership PAC   # noqa: E501

        :return: The committee_designation of this PresidentialSummary.  # noqa: E501
        :rtype: str
        """
        return self._committee_designation

    @committee_designation.setter
    def committee_designation(self, committee_designation):
        """Sets the committee_designation of this PresidentialSummary.

        The one-letter designation code of the organization:          - A authorized by a candidate          - J joint fundraising committee          - P principal campaign committee of a candidate          - U unauthorized          - B lobbyist/registrant PAC          - D leadership PAC   # noqa: E501

        :param committee_designation: The committee_designation of this PresidentialSummary.  # noqa: E501
        :type: str
        """

        self._committee_designation = committee_designation

    @property
    def committee_id(self):
        """Gets the committee_id of this PresidentialSummary.  # noqa: E501

         A unique identifier assigned to each candidate registered with the FEC. If a person runs for several offices, that person will have separate candidate IDs for each office.   # noqa: E501

        :return: The committee_id of this PresidentialSummary.  # noqa: E501
        :rtype: str
        """
        return self._committee_id

    @committee_id.setter
    def committee_id(self, committee_id):
        """Sets the committee_id of this PresidentialSummary.

         A unique identifier assigned to each candidate registered with the FEC. If a person runs for several offices, that person will have separate candidate IDs for each office.   # noqa: E501

        :param committee_id: The committee_id of this PresidentialSummary.  # noqa: E501
        :type: str
        """

        self._committee_id = committee_id

    @property
    def committee_name(self):
        """Gets the committee_name of this PresidentialSummary.  # noqa: E501

        The name of the committee. If a committee changes its name,     the most recent name will be shown. Committee names are not unique. Use committee_id     for looking up records.  # noqa: E501

        :return: The committee_name of this PresidentialSummary.  # noqa: E501
        :rtype: str
        """
        return self._committee_name

    @committee_name.setter
    def committee_name(self, committee_name):
        """Sets the committee_name of this PresidentialSummary.

        The name of the committee. If a committee changes its name,     the most recent name will be shown. Committee names are not unique. Use committee_id     for looking up records.  # noqa: E501

        :param committee_name: The committee_name of this PresidentialSummary.  # noqa: E501
        :type: str
        """

        self._committee_name = committee_name

    @property
    def committee_type(self):
        """Gets the committee_type of this PresidentialSummary.  # noqa: E501

        The one-letter type code of the organization:         - C communication cost         - D delegate         - E electioneering communication         - H House         - I independent expenditor (person or group)         - N PAC - nonqualified         - O independent expenditure-only (super PACs)         - P presidential         - Q PAC - qualified         - S Senate         - U single candidate independent expenditure         - V PAC with non-contribution account, nonqualified         - W PAC with non-contribution account, qualified         - X party, nonqualified         - Y party, qualified         - Z national party non-federal account   # noqa: E501

        :return: The committee_type of this PresidentialSummary.  # noqa: E501
        :rtype: str
        """
        return self._committee_type

    @committee_type.setter
    def committee_type(self, committee_type):
        """Sets the committee_type of this PresidentialSummary.

        The one-letter type code of the organization:         - C communication cost         - D delegate         - E electioneering communication         - H House         - I independent expenditor (person or group)         - N PAC - nonqualified         - O independent expenditure-only (super PACs)         - P presidential         - Q PAC - qualified         - S Senate         - U single candidate independent expenditure         - V PAC with non-contribution account, nonqualified         - W PAC with non-contribution account, qualified         - X party, nonqualified         - Y party, qualified         - Z national party non-federal account   # noqa: E501

        :param committee_type: The committee_type of this PresidentialSummary.  # noqa: E501
        :type: str
        """

        self._committee_type = committee_type

    @property
    def debts_owed_by_committee(self):
        """Gets the debts_owed_by_committee of this PresidentialSummary.  # noqa: E501

        Debts owed by the committee  # noqa: E501

        :return: The debts_owed_by_committee of this PresidentialSummary.  # noqa: E501
        :rtype: float
        """
        return self._debts_owed_by_committee

    @debts_owed_by_committee.setter
    def debts_owed_by_committee(self, debts_owed_by_committee):
        """Sets the debts_owed_by_committee of this PresidentialSummary.

        Debts owed by the committee  # noqa: E501

        :param debts_owed_by_committee: The debts_owed_by_committee of this PresidentialSummary.  # noqa: E501
        :type: float
        """

        self._debts_owed_by_committee = debts_owed_by_committee

    @property
    def disbursements_less_offsets(self):
        """Gets the disbursements_less_offsets of this PresidentialSummary.  # noqa: E501

         disbursements less offsets   # noqa: E501

        :return: The disbursements_less_offsets of this PresidentialSummary.  # noqa: E501
        :rtype: float
        """
        return self._disbursements_less_offsets

    @disbursements_less_offsets.setter
    def disbursements_less_offsets(self, disbursements_less_offsets):
        """Sets the disbursements_less_offsets of this PresidentialSummary.

         disbursements less offsets   # noqa: E501

        :param disbursements_less_offsets: The disbursements_less_offsets of this PresidentialSummary.  # noqa: E501
        :type: float
        """

        self._disbursements_less_offsets = disbursements_less_offsets

    @property
    def election_year(self):
        """Gets the election_year of this PresidentialSummary.  # noqa: E501

        Year of election  # noqa: E501

        :return: The election_year of this PresidentialSummary.  # noqa: E501
        :rtype: int
        """
        return self._election_year

    @election_year.setter
    def election_year(self, election_year):
        """Sets the election_year of this PresidentialSummary.

        Year of election  # noqa: E501

        :param election_year: The election_year of this PresidentialSummary.  # noqa: E501
        :type: int
        """

        self._election_year = election_year

    @property
    def exempt_legal_accounting_disbursement(self):
        """Gets the exempt_legal_accounting_disbursement of this PresidentialSummary.  # noqa: E501

         exempt legal accounting disbursement   # noqa: E501

        :return: The exempt_legal_accounting_disbursement of this PresidentialSummary.  # noqa: E501
        :rtype: float
        """
        return self._exempt_legal_accounting_disbursement

    @exempt_legal_accounting_disbursement.setter
    def exempt_legal_accounting_disbursement(self, exempt_legal_accounting_disbursement):
        """Sets the exempt_legal_accounting_disbursement of this PresidentialSummary.

         exempt legal accounting disbursement   # noqa: E501

        :param exempt_legal_accounting_disbursement: The exempt_legal_accounting_disbursement of this PresidentialSummary.  # noqa: E501
        :type: float
        """

        self._exempt_legal_accounting_disbursement = exempt_legal_accounting_disbursement

    @property
    def federal_funds(self):
        """Gets the federal_funds of this PresidentialSummary.  # noqa: E501

        Federal funds: Public funding of presidential elections means that qualified presidential candidates                 receive federal government funds to pay for the valid expenses of their political campaigns                 in both the primary and general elections.  # noqa: E501

        :return: The federal_funds of this PresidentialSummary.  # noqa: E501
        :rtype: float
        """
        return self._federal_funds

    @federal_funds.setter
    def federal_funds(self, federal_funds):
        """Sets the federal_funds of this PresidentialSummary.

        Federal funds: Public funding of presidential elections means that qualified presidential candidates                 receive federal government funds to pay for the valid expenses of their political campaigns                 in both the primary and general elections.  # noqa: E501

        :param federal_funds: The federal_funds of this PresidentialSummary.  # noqa: E501
        :type: float
        """

        self._federal_funds = federal_funds

    @property
    def fundraising_disbursements(self):
        """Gets the fundraising_disbursements of this PresidentialSummary.  # noqa: E501

         fundraising disbursements   # noqa: E501

        :return: The fundraising_disbursements of this PresidentialSummary.  # noqa: E501
        :rtype: float
        """
        return self._fundraising_disbursements

    @fundraising_disbursements.setter
    def fundraising_disbursements(self, fundraising_disbursements):
        """Sets the fundraising_disbursements of this PresidentialSummary.

         fundraising disbursements   # noqa: E501

        :param fundraising_disbursements: The fundraising_disbursements of this PresidentialSummary.  # noqa: E501
        :type: float
        """

        self._fundraising_disbursements = fundraising_disbursements

    @property
    def individual_contributions_less_refunds(self):
        """Gets the individual_contributions_less_refunds of this PresidentialSummary.  # noqa: E501

         individual contributions less refunds   # noqa: E501

        :return: The individual_contributions_less_refunds of this PresidentialSummary.  # noqa: E501
        :rtype: float
        """
        return self._individual_contributions_less_refunds

    @individual_contributions_less_refunds.setter
    def individual_contributions_less_refunds(self, individual_contributions_less_refunds):
        """Sets the individual_contributions_less_refunds of this PresidentialSummary.

         individual contributions less refunds   # noqa: E501

        :param individual_contributions_less_refunds: The individual_contributions_less_refunds of this PresidentialSummary.  # noqa: E501
        :type: float
        """

        self._individual_contributions_less_refunds = individual_contributions_less_refunds

    @property
    def net_receipts(self):
        """Gets the net_receipts of this PresidentialSummary.  # noqa: E501

         Contributions received   # noqa: E501

        :return: The net_receipts of this PresidentialSummary.  # noqa: E501
        :rtype: float
        """
        return self._net_receipts

    @net_receipts.setter
    def net_receipts(self, net_receipts):
        """Sets the net_receipts of this PresidentialSummary.

         Contributions received   # noqa: E501

        :param net_receipts: The net_receipts of this PresidentialSummary.  # noqa: E501
        :type: float
        """

        self._net_receipts = net_receipts

    @property
    def offsets_to_operating_expenditures(self):
        """Gets the offsets_to_operating_expenditures of this PresidentialSummary.  # noqa: E501

        Offsets to operating expenditures  # noqa: E501

        :return: The offsets_to_operating_expenditures of this PresidentialSummary.  # noqa: E501
        :rtype: float
        """
        return self._offsets_to_operating_expenditures

    @offsets_to_operating_expenditures.setter
    def offsets_to_operating_expenditures(self, offsets_to_operating_expenditures):
        """Sets the offsets_to_operating_expenditures of this PresidentialSummary.

        Offsets to operating expenditures  # noqa: E501

        :param offsets_to_operating_expenditures: The offsets_to_operating_expenditures of this PresidentialSummary.  # noqa: E501
        :type: float
        """

        self._offsets_to_operating_expenditures = offsets_to_operating_expenditures

    @property
    def operating_expenditures(self):
        """Gets the operating_expenditures of this PresidentialSummary.  # noqa: E501

        Total operating expenditures  # noqa: E501

        :return: The operating_expenditures of this PresidentialSummary.  # noqa: E501
        :rtype: float
        """
        return self._operating_expenditures

    @operating_expenditures.setter
    def operating_expenditures(self, operating_expenditures):
        """Sets the operating_expenditures of this PresidentialSummary.

        Total operating expenditures  # noqa: E501

        :param operating_expenditures: The operating_expenditures of this PresidentialSummary.  # noqa: E501
        :type: float
        """

        self._operating_expenditures = operating_expenditures

    @property
    def other_disbursements(self):
        """Gets the other_disbursements of this PresidentialSummary.  # noqa: E501

        Other disbursements  # noqa: E501

        :return: The other_disbursements of this PresidentialSummary.  # noqa: E501
        :rtype: float
        """
        return self._other_disbursements

    @other_disbursements.setter
    def other_disbursements(self, other_disbursements):
        """Sets the other_disbursements of this PresidentialSummary.

        Other disbursements  # noqa: E501

        :param other_disbursements: The other_disbursements of this PresidentialSummary.  # noqa: E501
        :type: float
        """

        self._other_disbursements = other_disbursements

    @property
    def pac_contributions_less_refunds(self):
        """Gets the pac_contributions_less_refunds of this PresidentialSummary.  # noqa: E501

         pac contributions less refunds   # noqa: E501

        :return: The pac_contributions_less_refunds of this PresidentialSummary.  # noqa: E501
        :rtype: float
        """
        return self._pac_contributions_less_refunds

    @pac_contributions_less_refunds.setter
    def pac_contributions_less_refunds(self, pac_contributions_less_refunds):
        """Sets the pac_contributions_less_refunds of this PresidentialSummary.

         pac contributions less refunds   # noqa: E501

        :param pac_contributions_less_refunds: The pac_contributions_less_refunds of this PresidentialSummary.  # noqa: E501
        :type: float
        """

        self._pac_contributions_less_refunds = pac_contributions_less_refunds

    @property
    def party_contributions_less_refunds(self):
        """Gets the party_contributions_less_refunds of this PresidentialSummary.  # noqa: E501

         party contributions less refunds   # noqa: E501

        :return: The party_contributions_less_refunds of this PresidentialSummary.  # noqa: E501
        :rtype: float
        """
        return self._party_contributions_less_refunds

    @party_contributions_less_refunds.setter
    def party_contributions_less_refunds(self, party_contributions_less_refunds):
        """Sets the party_contributions_less_refunds of this PresidentialSummary.

         party contributions less refunds   # noqa: E501

        :param party_contributions_less_refunds: The party_contributions_less_refunds of this PresidentialSummary.  # noqa: E501
        :type: float
        """

        self._party_contributions_less_refunds = party_contributions_less_refunds

    @property
    def repayments_loans_made_by_candidate(self):
        """Gets the repayments_loans_made_by_candidate of this PresidentialSummary.  # noqa: E501

         repayments loans made by candidate   # noqa: E501

        :return: The repayments_loans_made_by_candidate of this PresidentialSummary.  # noqa: E501
        :rtype: float
        """
        return self._repayments_loans_made_by_candidate

    @repayments_loans_made_by_candidate.setter
    def repayments_loans_made_by_candidate(self, repayments_loans_made_by_candidate):
        """Sets the repayments_loans_made_by_candidate of this PresidentialSummary.

         repayments loans made by candidate   # noqa: E501

        :param repayments_loans_made_by_candidate: The repayments_loans_made_by_candidate of this PresidentialSummary.  # noqa: E501
        :type: float
        """

        self._repayments_loans_made_by_candidate = repayments_loans_made_by_candidate

    @property
    def repayments_other_loans(self):
        """Gets the repayments_other_loans of this PresidentialSummary.  # noqa: E501

         repayments other loans   # noqa: E501

        :return: The repayments_other_loans of this PresidentialSummary.  # noqa: E501
        :rtype: float
        """
        return self._repayments_other_loans

    @repayments_other_loans.setter
    def repayments_other_loans(self, repayments_other_loans):
        """Sets the repayments_other_loans of this PresidentialSummary.

         repayments other loans   # noqa: E501

        :param repayments_other_loans: The repayments_other_loans of this PresidentialSummary.  # noqa: E501
        :type: float
        """

        self._repayments_other_loans = repayments_other_loans

    @property
    def rounded_net_receipts(self):
        """Gets the rounded_net_receipts of this PresidentialSummary.  # noqa: E501

         Net receipts, in millions   # noqa: E501

        :return: The rounded_net_receipts of this PresidentialSummary.  # noqa: E501
        :rtype: float
        """
        return self._rounded_net_receipts

    @rounded_net_receipts.setter
    def rounded_net_receipts(self, rounded_net_receipts):
        """Sets the rounded_net_receipts of this PresidentialSummary.

         Net receipts, in millions   # noqa: E501

        :param rounded_net_receipts: The rounded_net_receipts of this PresidentialSummary.  # noqa: E501
        :type: float
        """

        self._rounded_net_receipts = rounded_net_receipts

    @property
    def total_contribution_refunds(self):
        """Gets the total_contribution_refunds of this PresidentialSummary.  # noqa: E501

         total contribution refunds   # noqa: E501

        :return: The total_contribution_refunds of this PresidentialSummary.  # noqa: E501
        :rtype: float
        """
        return self._total_contribution_refunds

    @total_contribution_refunds.setter
    def total_contribution_refunds(self, total_contribution_refunds):
        """Sets the total_contribution_refunds of this PresidentialSummary.

         total contribution refunds   # noqa: E501

        :param total_contribution_refunds: The total_contribution_refunds of this PresidentialSummary.  # noqa: E501
        :type: float
        """

        self._total_contribution_refunds = total_contribution_refunds

    @property
    def total_loan_repayments_made(self):
        """Gets the total_loan_repayments_made of this PresidentialSummary.  # noqa: E501

         total loan repayments made   # noqa: E501

        :return: The total_loan_repayments_made of this PresidentialSummary.  # noqa: E501
        :rtype: float
        """
        return self._total_loan_repayments_made

    @total_loan_repayments_made.setter
    def total_loan_repayments_made(self, total_loan_repayments_made):
        """Sets the total_loan_repayments_made of this PresidentialSummary.

         total loan repayments made   # noqa: E501

        :param total_loan_repayments_made: The total_loan_repayments_made of this PresidentialSummary.  # noqa: E501
        :type: float
        """

        self._total_loan_repayments_made = total_loan_repayments_made

    @property
    def transfers_from_affiliated_committees(self):
        """Gets the transfers_from_affiliated_committees of this PresidentialSummary.  # noqa: E501

         transfers from affiliated committees   # noqa: E501

        :return: The transfers_from_affiliated_committees of this PresidentialSummary.  # noqa: E501
        :rtype: float
        """
        return self._transfers_from_affiliated_committees

    @transfers_from_affiliated_committees.setter
    def transfers_from_affiliated_committees(self, transfers_from_affiliated_committees):
        """Sets the transfers_from_affiliated_committees of this PresidentialSummary.

         transfers from affiliated committees   # noqa: E501

        :param transfers_from_affiliated_committees: The transfers_from_affiliated_committees of this PresidentialSummary.  # noqa: E501
        :type: float
        """

        self._transfers_from_affiliated_committees = transfers_from_affiliated_committees

    @property
    def transfers_to_other_authorized_committees(self):
        """Gets the transfers_to_other_authorized_committees of this PresidentialSummary.  # noqa: E501

         transfers to other authorized committees   # noqa: E501

        :return: The transfers_to_other_authorized_committees of this PresidentialSummary.  # noqa: E501
        :rtype: float
        """
        return self._transfers_to_other_authorized_committees

    @transfers_to_other_authorized_committees.setter
    def transfers_to_other_authorized_committees(self, transfers_to_other_authorized_committees):
        """Sets the transfers_to_other_authorized_committees of this PresidentialSummary.

         transfers to other authorized committees   # noqa: E501

        :param transfers_to_other_authorized_committees: The transfers_to_other_authorized_committees of this PresidentialSummary.  # noqa: E501
        :type: float
        """

        self._transfers_to_other_authorized_committees = transfers_to_other_authorized_committees

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, 'to_dict') else x,
                    value
                ))
            elif hasattr(value, 'to_dict'):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], 'to_dict') else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, PresidentialSummary):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, PresidentialSummary):
            return True

        return self.to_dict() != other.to_dict()
