# coding: utf-8

"""
    OpenFEC

    This API allows you to explore the way candidates and committees fund their campaigns.    The FEC API is a RESTful web service supporting full-text and field-specific searches on FEC data. [Bulk downloads](https://www.fec.gov/data/advanced/?tab=bulk-data) are available on the current site. Information is tied to the underlying forms by file ID and image ID. Data is updated nightly.    There is a lot of data, but a good place to start is to use search to find interesting candidates and committees. Then, you can use their IDs to find report or line item details with the other endpoints. If you are interested in individual donors, check out contributor information in schedule_a.    Get an [API key here](https://api.data.gov/signup/). That will enable you to place up to 1,000 calls an hour. Each call is limited to 100 results per page. You can email questions, comments or a request to get a key for 120 calls per minute to [APIinfo@fec.gov](mailto:apiinfo@fec.gov). You can also ask questions and discuss the data in the [FEC data Google Group](https://groups.google.com/forum/#!forum/fec-data). API changes will also be added to this group in advance of the change.    The model definitions and schema are available at [/swagger](/swagger/). This is useful for making wrappers and exploring the data.    A few restrictions limit the way you can use FEC data. For example, you can’t use contributor lists for commercial purposes or to solicit donations. [Learn more here](https://www.fec.gov/updates/sale-or-use-contributor-information/).    [View our source code](https://github.com/fecgov/openFEC). We welcome issues and pull requests!  # noqa: E501

    The version of the OpenAPI document: 1.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from openfec_sdk.configuration import Configuration


class RadAnalyst(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'analyst_id': 'float',
        'analyst_short_id': 'float',
        'assignment_update_date': 'date',
        'committee_id': 'str',
        'committee_name': 'str',
        'email': 'str',
        'first_name': 'str',
        'last_name': 'str',
        'rad_branch': 'str',
        'telephone_ext': 'float',
        'title': 'str'
    }

    attribute_map = {
        'analyst_id': 'analyst_id',
        'analyst_short_id': 'analyst_short_id',
        'assignment_update_date': 'assignment_update_date',
        'committee_id': 'committee_id',
        'committee_name': 'committee_name',
        'email': 'email',
        'first_name': 'first_name',
        'last_name': 'last_name',
        'rad_branch': 'rad_branch',
        'telephone_ext': 'telephone_ext',
        'title': 'title'
    }

    def __init__(self, analyst_id=None, analyst_short_id=None, assignment_update_date=None, committee_id=None, committee_name=None, email=None, first_name=None, last_name=None, rad_branch=None, telephone_ext=None, title=None, local_vars_configuration=None):  # noqa: E501
        """RadAnalyst - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._analyst_id = None
        self._analyst_short_id = None
        self._assignment_update_date = None
        self._committee_id = None
        self._committee_name = None
        self._email = None
        self._first_name = None
        self._last_name = None
        self._rad_branch = None
        self._telephone_ext = None
        self._title = None
        self.discriminator = None

        self.analyst_id = analyst_id
        self.analyst_short_id = analyst_short_id
        self.assignment_update_date = assignment_update_date
        self.committee_id = committee_id
        self.committee_name = committee_name
        self.email = email
        self.first_name = first_name
        self.last_name = last_name
        self.rad_branch = rad_branch
        self.telephone_ext = telephone_ext
        self.title = title

    @property
    def analyst_id(self):
        """Gets the analyst_id of this RadAnalyst.  # noqa: E501

        ID of RAD analyst.  # noqa: E501

        :return: The analyst_id of this RadAnalyst.  # noqa: E501
        :rtype: float
        """
        return self._analyst_id

    @analyst_id.setter
    def analyst_id(self, analyst_id):
        """Sets the analyst_id of this RadAnalyst.

        ID of RAD analyst.  # noqa: E501

        :param analyst_id: The analyst_id of this RadAnalyst.  # noqa: E501
        :type: float
        """

        self._analyst_id = analyst_id

    @property
    def analyst_short_id(self):
        """Gets the analyst_short_id of this RadAnalyst.  # noqa: E501

        Short ID of RAD analyst.  # noqa: E501

        :return: The analyst_short_id of this RadAnalyst.  # noqa: E501
        :rtype: float
        """
        return self._analyst_short_id

    @analyst_short_id.setter
    def analyst_short_id(self, analyst_short_id):
        """Sets the analyst_short_id of this RadAnalyst.

        Short ID of RAD analyst.  # noqa: E501

        :param analyst_short_id: The analyst_short_id of this RadAnalyst.  # noqa: E501
        :type: float
        """

        self._analyst_short_id = analyst_short_id

    @property
    def assignment_update_date(self):
        """Gets the assignment_update_date of this RadAnalyst.  # noqa: E501

        Date of most recent RAD analyst assignment change  # noqa: E501

        :return: The assignment_update_date of this RadAnalyst.  # noqa: E501
        :rtype: date
        """
        return self._assignment_update_date

    @assignment_update_date.setter
    def assignment_update_date(self, assignment_update_date):
        """Sets the assignment_update_date of this RadAnalyst.

        Date of most recent RAD analyst assignment change  # noqa: E501

        :param assignment_update_date: The assignment_update_date of this RadAnalyst.  # noqa: E501
        :type: date
        """

        self._assignment_update_date = assignment_update_date

    @property
    def committee_id(self):
        """Gets the committee_id of this RadAnalyst.  # noqa: E501

         A unique identifier assigned to each committee or filer registered with the FEC. In general committee id's begin with the letter C which is followed by eight digits.   # noqa: E501

        :return: The committee_id of this RadAnalyst.  # noqa: E501
        :rtype: str
        """
        return self._committee_id

    @committee_id.setter
    def committee_id(self, committee_id):
        """Sets the committee_id of this RadAnalyst.

         A unique identifier assigned to each committee or filer registered with the FEC. In general committee id's begin with the letter C which is followed by eight digits.   # noqa: E501

        :param committee_id: The committee_id of this RadAnalyst.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and committee_id is None:  # noqa: E501
            raise ValueError('Invalid value for `committee_id`, must not be `None`')  # noqa: E501

        self._committee_id = committee_id

    @property
    def committee_name(self):
        """Gets the committee_name of this RadAnalyst.  # noqa: E501

        The name of the committee. If a committee changes its name,     the most recent name will be shown. Committee names are not unique. Use committee_id     for looking up records.  # noqa: E501

        :return: The committee_name of this RadAnalyst.  # noqa: E501
        :rtype: str
        """
        return self._committee_name

    @committee_name.setter
    def committee_name(self, committee_name):
        """Sets the committee_name of this RadAnalyst.

        The name of the committee. If a committee changes its name,     the most recent name will be shown. Committee names are not unique. Use committee_id     for looking up records.  # noqa: E501

        :param committee_name: The committee_name of this RadAnalyst.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                committee_name is not None and len(committee_name) > 100):
            raise ValueError('Invalid value for `committee_name`, length must be less than or equal to `100`')  # noqa: E501

        self._committee_name = committee_name

    @property
    def email(self):
        """Gets the email of this RadAnalyst.  # noqa: E501

        Email of RAD analyst  # noqa: E501

        :return: The email of this RadAnalyst.  # noqa: E501
        :rtype: str
        """
        return self._email

    @email.setter
    def email(self, email):
        """Sets the email of this RadAnalyst.

        Email of RAD analyst  # noqa: E501

        :param email: The email of this RadAnalyst.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                email is not None and len(email) > 100):
            raise ValueError('Invalid value for `email`, length must be less than or equal to `100`')  # noqa: E501

        self._email = email

    @property
    def first_name(self):
        """Gets the first_name of this RadAnalyst.  # noqa: E501

        Fist name of RAD analyst  # noqa: E501

        :return: The first_name of this RadAnalyst.  # noqa: E501
        :rtype: str
        """
        return self._first_name

    @first_name.setter
    def first_name(self, first_name):
        """Sets the first_name of this RadAnalyst.

        Fist name of RAD analyst  # noqa: E501

        :param first_name: The first_name of this RadAnalyst.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                first_name is not None and len(first_name) > 255):
            raise ValueError('Invalid value for `first_name`, length must be less than or equal to `255`')  # noqa: E501

        self._first_name = first_name

    @property
    def last_name(self):
        """Gets the last_name of this RadAnalyst.  # noqa: E501

        Last name of RAD analyst  # noqa: E501

        :return: The last_name of this RadAnalyst.  # noqa: E501
        :rtype: str
        """
        return self._last_name

    @last_name.setter
    def last_name(self, last_name):
        """Sets the last_name of this RadAnalyst.

        Last name of RAD analyst  # noqa: E501

        :param last_name: The last_name of this RadAnalyst.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                last_name is not None and len(last_name) > 100):
            raise ValueError('Invalid value for `last_name`, length must be less than or equal to `100`')  # noqa: E501

        self._last_name = last_name

    @property
    def rad_branch(self):
        """Gets the rad_branch of this RadAnalyst.  # noqa: E501

        Branch of RAD analyst  # noqa: E501

        :return: The rad_branch of this RadAnalyst.  # noqa: E501
        :rtype: str
        """
        return self._rad_branch

    @rad_branch.setter
    def rad_branch(self, rad_branch):
        """Sets the rad_branch of this RadAnalyst.

        Branch of RAD analyst  # noqa: E501

        :param rad_branch: The rad_branch of this RadAnalyst.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                rad_branch is not None and len(rad_branch) > 100):
            raise ValueError('Invalid value for `rad_branch`, length must be less than or equal to `100`')  # noqa: E501

        self._rad_branch = rad_branch

    @property
    def telephone_ext(self):
        """Gets the telephone_ext of this RadAnalyst.  # noqa: E501

        Telephone extension of RAD analyst  # noqa: E501

        :return: The telephone_ext of this RadAnalyst.  # noqa: E501
        :rtype: float
        """
        return self._telephone_ext

    @telephone_ext.setter
    def telephone_ext(self, telephone_ext):
        """Sets the telephone_ext of this RadAnalyst.

        Telephone extension of RAD analyst  # noqa: E501

        :param telephone_ext: The telephone_ext of this RadAnalyst.  # noqa: E501
        :type: float
        """

        self._telephone_ext = telephone_ext

    @property
    def title(self):
        """Gets the title of this RadAnalyst.  # noqa: E501

        Title of RAD analyst  # noqa: E501

        :return: The title of this RadAnalyst.  # noqa: E501
        :rtype: str
        """
        return self._title

    @title.setter
    def title(self, title):
        """Sets the title of this RadAnalyst.

        Title of RAD analyst  # noqa: E501

        :param title: The title of this RadAnalyst.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                title is not None and len(title) > 100):
            raise ValueError('Invalid value for `title`, length must be less than or equal to `100`')  # noqa: E501

        self._title = title

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, 'to_dict') else x,
                    value
                ))
            elif hasattr(value, 'to_dict'):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], 'to_dict') else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, RadAnalyst):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, RadAnalyst):
            return True

        return self.to_dict() != other.to_dict()
