# coding: utf-8

"""
    OpenFEC

    This API allows you to explore the way candidates and committees fund their campaigns.    The FEC API is a RESTful web service supporting full-text and field-specific searches on FEC data. [Bulk downloads](https://www.fec.gov/data/advanced/?tab=bulk-data) are available on the current site. Information is tied to the underlying forms by file ID and image ID. Data is updated nightly.    There is a lot of data, but a good place to start is to use search to find interesting candidates and committees. Then, you can use their IDs to find report or line item details with the other endpoints. If you are interested in individual donors, check out contributor information in schedule_a.    Get an [API key here](https://api.data.gov/signup/). That will enable you to place up to 1,000 calls an hour. Each call is limited to 100 results per page. You can email questions, comments or a request to get a key for 120 calls per minute to [APIinfo@fec.gov](mailto:apiinfo@fec.gov). You can also ask questions and discuss the data in the [FEC data Google Group](https://groups.google.com/forum/#!forum/fec-data). API changes will also be added to this group in advance of the change.    The model definitions and schema are available at [/swagger](/swagger/). This is useful for making wrappers and exploring the data.    A few restrictions limit the way you can use FEC data. For example, you can’t use contributor lists for commercial purposes or to solicit donations. [Learn more here](https://www.fec.gov/updates/sale-or-use-contributor-information/).    [View our source code](https://github.com/fecgov/openFEC). We welcome issues and pull requests!  # noqa: E501

    The version of the OpenAPI document: 1.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from openfec_sdk.configuration import Configuration


class ReportDate(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'create_date': 'date',
        'due_date': 'date',
        'report_type': 'str',
        'report_type_full': 'str',
        'report_year': 'int',
        'update_date': 'date'
    }

    attribute_map = {
        'create_date': 'create_date',
        'due_date': 'due_date',
        'report_type': 'report_type',
        'report_type_full': 'report_type_full',
        'report_year': 'report_year',
        'update_date': 'update_date'
    }

    def __init__(self, create_date=None, due_date=None, report_type=None, report_type_full=None, report_year=None, update_date=None, local_vars_configuration=None):  # noqa: E501
        """ReportDate - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._create_date = None
        self._due_date = None
        self._report_type = None
        self._report_type_full = None
        self._report_year = None
        self._update_date = None
        self.discriminator = None

        self.create_date = create_date
        self.due_date = due_date
        if report_type is not None:
            self.report_type = report_type
        if report_type_full is not None:
            self.report_type_full = report_type_full
        self.report_year = report_year
        self.update_date = update_date

    @property
    def create_date(self):
        """Gets the create_date of this ReportDate.  # noqa: E501

        Date the record was created  # noqa: E501

        :return: The create_date of this ReportDate.  # noqa: E501
        :rtype: date
        """
        return self._create_date

    @create_date.setter
    def create_date(self, create_date):
        """Sets the create_date of this ReportDate.

        Date the record was created  # noqa: E501

        :param create_date: The create_date of this ReportDate.  # noqa: E501
        :type: date
        """

        self._create_date = create_date

    @property
    def due_date(self):
        """Gets the due_date of this ReportDate.  # noqa: E501

        Date the report is due  # noqa: E501

        :return: The due_date of this ReportDate.  # noqa: E501
        :rtype: date
        """
        return self._due_date

    @due_date.setter
    def due_date(self, due_date):
        """Sets the due_date of this ReportDate.

        Date the report is due  # noqa: E501

        :param due_date: The due_date of this ReportDate.  # noqa: E501
        :type: date
        """

        self._due_date = due_date

    @property
    def report_type(self):
        """Gets the report_type of this ReportDate.  # noqa: E501


        :return: The report_type of this ReportDate.  # noqa: E501
        :rtype: str
        """
        return self._report_type

    @report_type.setter
    def report_type(self, report_type):
        """Sets the report_type of this ReportDate.


        :param report_type: The report_type of this ReportDate.  # noqa: E501
        :type: str
        """

        self._report_type = report_type

    @property
    def report_type_full(self):
        """Gets the report_type_full of this ReportDate.  # noqa: E501


        :return: The report_type_full of this ReportDate.  # noqa: E501
        :rtype: str
        """
        return self._report_type_full

    @report_type_full.setter
    def report_type_full(self, report_type_full):
        """Sets the report_type_full of this ReportDate.


        :param report_type_full: The report_type_full of this ReportDate.  # noqa: E501
        :type: str
        """

        self._report_type_full = report_type_full

    @property
    def report_year(self):
        """Gets the report_year of this ReportDate.  # noqa: E501

         Forms with coverage date -      year from the coverage ending date. Forms without coverage date -      year from the receipt date.   # noqa: E501

        :return: The report_year of this ReportDate.  # noqa: E501
        :rtype: int
        """
        return self._report_year

    @report_year.setter
    def report_year(self, report_year):
        """Sets the report_year of this ReportDate.

         Forms with coverage date -      year from the coverage ending date. Forms without coverage date -      year from the receipt date.   # noqa: E501

        :param report_year: The report_year of this ReportDate.  # noqa: E501
        :type: int
        """

        self._report_year = report_year

    @property
    def update_date(self):
        """Gets the update_date of this ReportDate.  # noqa: E501

        Date the record was updated  # noqa: E501

        :return: The update_date of this ReportDate.  # noqa: E501
        :rtype: date
        """
        return self._update_date

    @update_date.setter
    def update_date(self, update_date):
        """Sets the update_date of this ReportDate.

        Date the record was updated  # noqa: E501

        :param update_date: The update_date of this ReportDate.  # noqa: E501
        :type: date
        """

        self._update_date = update_date

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, 'to_dict') else x,
                    value
                ))
            elif hasattr(value, 'to_dict'):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], 'to_dict') else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ReportDate):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, ReportDate):
            return True

        return self.to_dict() != other.to_dict()
