# coding: utf-8

"""
    OpenFEC

    This API allows you to explore the way candidates and committees fund their campaigns.    The FEC API is a RESTful web service supporting full-text and field-specific searches on FEC data. [Bulk downloads](https://www.fec.gov/data/advanced/?tab=bulk-data) are available on the current site. Information is tied to the underlying forms by file ID and image ID. Data is updated nightly.    There is a lot of data, but a good place to start is to use search to find interesting candidates and committees. Then, you can use their IDs to find report or line item details with the other endpoints. If you are interested in individual donors, check out contributor information in schedule_a.    Get an [API key here](https://api.data.gov/signup/). That will enable you to place up to 1,000 calls an hour. Each call is limited to 100 results per page. You can email questions, comments or a request to get a key for 120 calls per minute to [APIinfo@fec.gov](mailto:apiinfo@fec.gov). You can also ask questions and discuss the data in the [FEC data Google Group](https://groups.google.com/forum/#!forum/fec-data). API changes will also be added to this group in advance of the change.    The model definitions and schema are available at [/swagger](/swagger/). This is useful for making wrappers and exploring the data.    A few restrictions limit the way you can use FEC data. For example, you can’t use contributor lists for commercial purposes or to solicit donations. [Learn more here](https://www.fec.gov/updates/sale-or-use-contributor-information/).    [View our source code](https://github.com/fecgov/openFEC). We welcome issues and pull requests!  # noqa: E501

    The version of the OpenAPI document: 1.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from openfec_sdk.configuration import Configuration


class ScheduleA(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'amendment_indicator': 'str',
        'amendment_indicator_desc': 'str',
        'back_reference_schedule_name': 'str',
        'back_reference_transaction_id': 'str',
        'candidate_first_name': 'str',
        'candidate_id': 'str',
        'candidate_last_name': 'str',
        'candidate_middle_name': 'str',
        'candidate_name': 'str',
        'candidate_office': 'str',
        'candidate_office_district': 'str',
        'candidate_office_full': 'str',
        'candidate_office_state': 'str',
        'candidate_office_state_full': 'str',
        'candidate_prefix': 'str',
        'candidate_suffix': 'str',
        'committee': 'CommitteeHistory',
        'committee_id': 'str',
        'committee_name': 'str',
        'conduit_committee_city': 'str',
        'conduit_committee_id': 'str',
        'conduit_committee_name': 'str',
        'conduit_committee_state': 'str',
        'conduit_committee_street1': 'str',
        'conduit_committee_street2': 'str',
        'conduit_committee_zip': 'int',
        'contribution_receipt_amount': 'float',
        'contribution_receipt_date': 'date',
        'contributor': 'CommitteeHistory',
        'contributor_aggregate_ytd': 'float',
        'contributor_city': 'str',
        'contributor_employer': 'str',
        'contributor_first_name': 'str',
        'contributor_id': 'str',
        'contributor_last_name': 'str',
        'contributor_middle_name': 'str',
        'contributor_name': 'str',
        'contributor_occupation': 'str',
        'contributor_prefix': 'str',
        'contributor_state': 'str',
        'contributor_street_1': 'str',
        'contributor_street_2': 'str',
        'contributor_suffix': 'str',
        'contributor_zip': 'str',
        'donor_committee_name': 'str',
        'election_type': 'str',
        'election_type_full': 'str',
        'entity_type': 'str',
        'entity_type_desc': 'str',
        'fec_election_type_desc': 'str',
        'fec_election_year': 'str',
        'file_number': 'int',
        'filing_form': 'str',
        'image_number': 'str',
        'increased_limit': 'str',
        'is_individual': 'bool',
        'line_number': 'str',
        'line_number_label': 'str',
        'link_id': 'int',
        'load_date': 'datetime',
        'memo_code': 'str',
        'memo_code_full': 'str',
        'memo_text': 'str',
        'memoed_subtotal': 'bool',
        'national_committee_nonfederal_account': 'str',
        'original_sub_id': 'str',
        'pdf_url': 'str',
        'receipt_type': 'str',
        'receipt_type_desc': 'str',
        'receipt_type_full': 'str',
        'recipient_committee_designation': 'str',
        'recipient_committee_org_type': 'str',
        'recipient_committee_type': 'str',
        'report_type': 'str',
        'report_year': 'int',
        'schedule_type': 'str',
        'schedule_type_full': 'str',
        'sub_id': 'str',
        'transaction_id': 'str',
        'two_year_transaction_period': 'int',
        'unused_contbr_id': 'str'
    }

    attribute_map = {
        'amendment_indicator': 'amendment_indicator',
        'amendment_indicator_desc': 'amendment_indicator_desc',
        'back_reference_schedule_name': 'back_reference_schedule_name',
        'back_reference_transaction_id': 'back_reference_transaction_id',
        'candidate_first_name': 'candidate_first_name',
        'candidate_id': 'candidate_id',
        'candidate_last_name': 'candidate_last_name',
        'candidate_middle_name': 'candidate_middle_name',
        'candidate_name': 'candidate_name',
        'candidate_office': 'candidate_office',
        'candidate_office_district': 'candidate_office_district',
        'candidate_office_full': 'candidate_office_full',
        'candidate_office_state': 'candidate_office_state',
        'candidate_office_state_full': 'candidate_office_state_full',
        'candidate_prefix': 'candidate_prefix',
        'candidate_suffix': 'candidate_suffix',
        'committee': 'committee',
        'committee_id': 'committee_id',
        'committee_name': 'committee_name',
        'conduit_committee_city': 'conduit_committee_city',
        'conduit_committee_id': 'conduit_committee_id',
        'conduit_committee_name': 'conduit_committee_name',
        'conduit_committee_state': 'conduit_committee_state',
        'conduit_committee_street1': 'conduit_committee_street1',
        'conduit_committee_street2': 'conduit_committee_street2',
        'conduit_committee_zip': 'conduit_committee_zip',
        'contribution_receipt_amount': 'contribution_receipt_amount',
        'contribution_receipt_date': 'contribution_receipt_date',
        'contributor': 'contributor',
        'contributor_aggregate_ytd': 'contributor_aggregate_ytd',
        'contributor_city': 'contributor_city',
        'contributor_employer': 'contributor_employer',
        'contributor_first_name': 'contributor_first_name',
        'contributor_id': 'contributor_id',
        'contributor_last_name': 'contributor_last_name',
        'contributor_middle_name': 'contributor_middle_name',
        'contributor_name': 'contributor_name',
        'contributor_occupation': 'contributor_occupation',
        'contributor_prefix': 'contributor_prefix',
        'contributor_state': 'contributor_state',
        'contributor_street_1': 'contributor_street_1',
        'contributor_street_2': 'contributor_street_2',
        'contributor_suffix': 'contributor_suffix',
        'contributor_zip': 'contributor_zip',
        'donor_committee_name': 'donor_committee_name',
        'election_type': 'election_type',
        'election_type_full': 'election_type_full',
        'entity_type': 'entity_type',
        'entity_type_desc': 'entity_type_desc',
        'fec_election_type_desc': 'fec_election_type_desc',
        'fec_election_year': 'fec_election_year',
        'file_number': 'file_number',
        'filing_form': 'filing_form',
        'image_number': 'image_number',
        'increased_limit': 'increased_limit',
        'is_individual': 'is_individual',
        'line_number': 'line_number',
        'line_number_label': 'line_number_label',
        'link_id': 'link_id',
        'load_date': 'load_date',
        'memo_code': 'memo_code',
        'memo_code_full': 'memo_code_full',
        'memo_text': 'memo_text',
        'memoed_subtotal': 'memoed_subtotal',
        'national_committee_nonfederal_account': 'national_committee_nonfederal_account',
        'original_sub_id': 'original_sub_id',
        'pdf_url': 'pdf_url',
        'receipt_type': 'receipt_type',
        'receipt_type_desc': 'receipt_type_desc',
        'receipt_type_full': 'receipt_type_full',
        'recipient_committee_designation': 'recipient_committee_designation',
        'recipient_committee_org_type': 'recipient_committee_org_type',
        'recipient_committee_type': 'recipient_committee_type',
        'report_type': 'report_type',
        'report_year': 'report_year',
        'schedule_type': 'schedule_type',
        'schedule_type_full': 'schedule_type_full',
        'sub_id': 'sub_id',
        'transaction_id': 'transaction_id',
        'two_year_transaction_period': 'two_year_transaction_period',
        'unused_contbr_id': 'unused_contbr_id'
    }

    def __init__(self, amendment_indicator=None, amendment_indicator_desc=None, back_reference_schedule_name=None, back_reference_transaction_id=None, candidate_first_name=None, candidate_id=None, candidate_last_name=None, candidate_middle_name=None, candidate_name=None, candidate_office=None, candidate_office_district=None, candidate_office_full=None, candidate_office_state=None, candidate_office_state_full=None, candidate_prefix=None, candidate_suffix=None, committee=None, committee_id=None, committee_name=None, conduit_committee_city=None, conduit_committee_id=None, conduit_committee_name=None, conduit_committee_state=None, conduit_committee_street1=None, conduit_committee_street2=None, conduit_committee_zip=None, contribution_receipt_amount=None, contribution_receipt_date=None, contributor=None, contributor_aggregate_ytd=None, contributor_city=None, contributor_employer=None, contributor_first_name=None, contributor_id=None, contributor_last_name=None, contributor_middle_name=None, contributor_name=None, contributor_occupation=None, contributor_prefix=None, contributor_state=None, contributor_street_1=None, contributor_street_2=None, contributor_suffix=None, contributor_zip=None, donor_committee_name=None, election_type=None, election_type_full=None, entity_type=None, entity_type_desc=None, fec_election_type_desc=None, fec_election_year=None, file_number=None, filing_form=None, image_number=None, increased_limit=None, is_individual=None, line_number=None, line_number_label=None, link_id=None, load_date=None, memo_code=None, memo_code_full=None, memo_text=None, memoed_subtotal=None, national_committee_nonfederal_account=None, original_sub_id=None, pdf_url=None, receipt_type=None, receipt_type_desc=None, receipt_type_full=None, recipient_committee_designation=None, recipient_committee_org_type=None, recipient_committee_type=None, report_type=None, report_year=None, schedule_type=None, schedule_type_full=None, sub_id=None, transaction_id=None, two_year_transaction_period=None, unused_contbr_id=None, local_vars_configuration=None):  # noqa: E501
        """ScheduleA - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._amendment_indicator = None
        self._amendment_indicator_desc = None
        self._back_reference_schedule_name = None
        self._back_reference_transaction_id = None
        self._candidate_first_name = None
        self._candidate_id = None
        self._candidate_last_name = None
        self._candidate_middle_name = None
        self._candidate_name = None
        self._candidate_office = None
        self._candidate_office_district = None
        self._candidate_office_full = None
        self._candidate_office_state = None
        self._candidate_office_state_full = None
        self._candidate_prefix = None
        self._candidate_suffix = None
        self._committee = None
        self._committee_id = None
        self._committee_name = None
        self._conduit_committee_city = None
        self._conduit_committee_id = None
        self._conduit_committee_name = None
        self._conduit_committee_state = None
        self._conduit_committee_street1 = None
        self._conduit_committee_street2 = None
        self._conduit_committee_zip = None
        self._contribution_receipt_amount = None
        self._contribution_receipt_date = None
        self._contributor = None
        self._contributor_aggregate_ytd = None
        self._contributor_city = None
        self._contributor_employer = None
        self._contributor_first_name = None
        self._contributor_id = None
        self._contributor_last_name = None
        self._contributor_middle_name = None
        self._contributor_name = None
        self._contributor_occupation = None
        self._contributor_prefix = None
        self._contributor_state = None
        self._contributor_street_1 = None
        self._contributor_street_2 = None
        self._contributor_suffix = None
        self._contributor_zip = None
        self._donor_committee_name = None
        self._election_type = None
        self._election_type_full = None
        self._entity_type = None
        self._entity_type_desc = None
        self._fec_election_type_desc = None
        self._fec_election_year = None
        self._file_number = None
        self._filing_form = None
        self._image_number = None
        self._increased_limit = None
        self._is_individual = None
        self._line_number = None
        self._line_number_label = None
        self._link_id = None
        self._load_date = None
        self._memo_code = None
        self._memo_code_full = None
        self._memo_text = None
        self._memoed_subtotal = None
        self._national_committee_nonfederal_account = None
        self._original_sub_id = None
        self._pdf_url = None
        self._receipt_type = None
        self._receipt_type_desc = None
        self._receipt_type_full = None
        self._recipient_committee_designation = None
        self._recipient_committee_org_type = None
        self._recipient_committee_type = None
        self._report_type = None
        self._report_year = None
        self._schedule_type = None
        self._schedule_type_full = None
        self._sub_id = None
        self._transaction_id = None
        self._two_year_transaction_period = None
        self._unused_contbr_id = None
        self.discriminator = None

        self.amendment_indicator = amendment_indicator
        self.amendment_indicator_desc = amendment_indicator_desc
        self.back_reference_schedule_name = back_reference_schedule_name
        self.back_reference_transaction_id = back_reference_transaction_id
        self.candidate_first_name = candidate_first_name
        self.candidate_id = candidate_id
        self.candidate_last_name = candidate_last_name
        self.candidate_middle_name = candidate_middle_name
        self.candidate_name = candidate_name
        self.candidate_office = candidate_office
        self.candidate_office_district = candidate_office_district
        self.candidate_office_full = candidate_office_full
        self.candidate_office_state = candidate_office_state
        self.candidate_office_state_full = candidate_office_state_full
        self.candidate_prefix = candidate_prefix
        self.candidate_suffix = candidate_suffix
        if committee is not None:
            self.committee = committee
        self.committee_id = committee_id
        self.committee_name = committee_name
        self.conduit_committee_city = conduit_committee_city
        self.conduit_committee_id = conduit_committee_id
        self.conduit_committee_name = conduit_committee_name
        self.conduit_committee_state = conduit_committee_state
        self.conduit_committee_street1 = conduit_committee_street1
        self.conduit_committee_street2 = conduit_committee_street2
        self.conduit_committee_zip = conduit_committee_zip
        if contribution_receipt_amount is not None:
            self.contribution_receipt_amount = contribution_receipt_amount
        self.contribution_receipt_date = contribution_receipt_date
        if contributor is not None:
            self.contributor = contributor
        if contributor_aggregate_ytd is not None:
            self.contributor_aggregate_ytd = contributor_aggregate_ytd
        self.contributor_city = contributor_city
        self.contributor_employer = contributor_employer
        self.contributor_first_name = contributor_first_name
        self.contributor_id = contributor_id
        self.contributor_last_name = contributor_last_name
        self.contributor_middle_name = contributor_middle_name
        self.contributor_name = contributor_name
        self.contributor_occupation = contributor_occupation
        self.contributor_prefix = contributor_prefix
        self.contributor_state = contributor_state
        self.contributor_street_1 = contributor_street_1
        self.contributor_street_2 = contributor_street_2
        self.contributor_suffix = contributor_suffix
        self.contributor_zip = contributor_zip
        self.donor_committee_name = donor_committee_name
        self.election_type = election_type
        self.election_type_full = election_type_full
        self.entity_type = entity_type
        self.entity_type_desc = entity_type_desc
        self.fec_election_type_desc = fec_election_type_desc
        self.fec_election_year = fec_election_year
        self.file_number = file_number
        self.filing_form = filing_form
        if image_number is not None:
            self.image_number = image_number
        self.increased_limit = increased_limit
        self.is_individual = is_individual
        self.line_number = line_number
        self.line_number_label = line_number_label
        self.link_id = link_id
        self.load_date = load_date
        self.memo_code = memo_code
        self.memo_code_full = memo_code_full
        self.memo_text = memo_text
        if memoed_subtotal is not None:
            self.memoed_subtotal = memoed_subtotal
        self.national_committee_nonfederal_account = national_committee_nonfederal_account
        if original_sub_id is not None:
            self.original_sub_id = original_sub_id
        self.pdf_url = pdf_url
        self.receipt_type = receipt_type
        self.receipt_type_desc = receipt_type_desc
        self.receipt_type_full = receipt_type_full
        self.recipient_committee_designation = recipient_committee_designation
        self.recipient_committee_org_type = recipient_committee_org_type
        self.recipient_committee_type = recipient_committee_type
        self.report_type = report_type
        self.report_year = report_year
        self.schedule_type = schedule_type
        self.schedule_type_full = schedule_type_full
        if sub_id is not None:
            self.sub_id = sub_id
        self.transaction_id = transaction_id
        self.two_year_transaction_period = two_year_transaction_period
        self.unused_contbr_id = unused_contbr_id

    @property
    def amendment_indicator(self):
        """Gets the amendment_indicator of this ScheduleA.  # noqa: E501


        :return: The amendment_indicator of this ScheduleA.  # noqa: E501
        :rtype: str
        """
        return self._amendment_indicator

    @amendment_indicator.setter
    def amendment_indicator(self, amendment_indicator):
        """Sets the amendment_indicator of this ScheduleA.


        :param amendment_indicator: The amendment_indicator of this ScheduleA.  # noqa: E501
        :type: str
        """

        self._amendment_indicator = amendment_indicator

    @property
    def amendment_indicator_desc(self):
        """Gets the amendment_indicator_desc of this ScheduleA.  # noqa: E501


        :return: The amendment_indicator_desc of this ScheduleA.  # noqa: E501
        :rtype: str
        """
        return self._amendment_indicator_desc

    @amendment_indicator_desc.setter
    def amendment_indicator_desc(self, amendment_indicator_desc):
        """Sets the amendment_indicator_desc of this ScheduleA.


        :param amendment_indicator_desc: The amendment_indicator_desc of this ScheduleA.  # noqa: E501
        :type: str
        """

        self._amendment_indicator_desc = amendment_indicator_desc

    @property
    def back_reference_schedule_name(self):
        """Gets the back_reference_schedule_name of this ScheduleA.  # noqa: E501


        :return: The back_reference_schedule_name of this ScheduleA.  # noqa: E501
        :rtype: str
        """
        return self._back_reference_schedule_name

    @back_reference_schedule_name.setter
    def back_reference_schedule_name(self, back_reference_schedule_name):
        """Sets the back_reference_schedule_name of this ScheduleA.


        :param back_reference_schedule_name: The back_reference_schedule_name of this ScheduleA.  # noqa: E501
        :type: str
        """

        self._back_reference_schedule_name = back_reference_schedule_name

    @property
    def back_reference_transaction_id(self):
        """Gets the back_reference_transaction_id of this ScheduleA.  # noqa: E501


        :return: The back_reference_transaction_id of this ScheduleA.  # noqa: E501
        :rtype: str
        """
        return self._back_reference_transaction_id

    @back_reference_transaction_id.setter
    def back_reference_transaction_id(self, back_reference_transaction_id):
        """Sets the back_reference_transaction_id of this ScheduleA.


        :param back_reference_transaction_id: The back_reference_transaction_id of this ScheduleA.  # noqa: E501
        :type: str
        """

        self._back_reference_transaction_id = back_reference_transaction_id

    @property
    def candidate_first_name(self):
        """Gets the candidate_first_name of this ScheduleA.  # noqa: E501


        :return: The candidate_first_name of this ScheduleA.  # noqa: E501
        :rtype: str
        """
        return self._candidate_first_name

    @candidate_first_name.setter
    def candidate_first_name(self, candidate_first_name):
        """Sets the candidate_first_name of this ScheduleA.


        :param candidate_first_name: The candidate_first_name of this ScheduleA.  # noqa: E501
        :type: str
        """

        self._candidate_first_name = candidate_first_name

    @property
    def candidate_id(self):
        """Gets the candidate_id of this ScheduleA.  # noqa: E501

         A unique identifier assigned to each candidate registered with the FEC. If a person runs for several offices, that person will have separate candidate IDs for each office.   # noqa: E501

        :return: The candidate_id of this ScheduleA.  # noqa: E501
        :rtype: str
        """
        return self._candidate_id

    @candidate_id.setter
    def candidate_id(self, candidate_id):
        """Sets the candidate_id of this ScheduleA.

         A unique identifier assigned to each candidate registered with the FEC. If a person runs for several offices, that person will have separate candidate IDs for each office.   # noqa: E501

        :param candidate_id: The candidate_id of this ScheduleA.  # noqa: E501
        :type: str
        """

        self._candidate_id = candidate_id

    @property
    def candidate_last_name(self):
        """Gets the candidate_last_name of this ScheduleA.  # noqa: E501


        :return: The candidate_last_name of this ScheduleA.  # noqa: E501
        :rtype: str
        """
        return self._candidate_last_name

    @candidate_last_name.setter
    def candidate_last_name(self, candidate_last_name):
        """Sets the candidate_last_name of this ScheduleA.


        :param candidate_last_name: The candidate_last_name of this ScheduleA.  # noqa: E501
        :type: str
        """

        self._candidate_last_name = candidate_last_name

    @property
    def candidate_middle_name(self):
        """Gets the candidate_middle_name of this ScheduleA.  # noqa: E501


        :return: The candidate_middle_name of this ScheduleA.  # noqa: E501
        :rtype: str
        """
        return self._candidate_middle_name

    @candidate_middle_name.setter
    def candidate_middle_name(self, candidate_middle_name):
        """Sets the candidate_middle_name of this ScheduleA.


        :param candidate_middle_name: The candidate_middle_name of this ScheduleA.  # noqa: E501
        :type: str
        """

        self._candidate_middle_name = candidate_middle_name

    @property
    def candidate_name(self):
        """Gets the candidate_name of this ScheduleA.  # noqa: E501

        Name of candidate running for office  # noqa: E501

        :return: The candidate_name of this ScheduleA.  # noqa: E501
        :rtype: str
        """
        return self._candidate_name

    @candidate_name.setter
    def candidate_name(self, candidate_name):
        """Sets the candidate_name of this ScheduleA.

        Name of candidate running for office  # noqa: E501

        :param candidate_name: The candidate_name of this ScheduleA.  # noqa: E501
        :type: str
        """

        self._candidate_name = candidate_name

    @property
    def candidate_office(self):
        """Gets the candidate_office of this ScheduleA.  # noqa: E501


        :return: The candidate_office of this ScheduleA.  # noqa: E501
        :rtype: str
        """
        return self._candidate_office

    @candidate_office.setter
    def candidate_office(self, candidate_office):
        """Sets the candidate_office of this ScheduleA.


        :param candidate_office: The candidate_office of this ScheduleA.  # noqa: E501
        :type: str
        """

        self._candidate_office = candidate_office

    @property
    def candidate_office_district(self):
        """Gets the candidate_office_district of this ScheduleA.  # noqa: E501

        Two-digit US House distirict of the office the candidate is running for. Presidential, Senate and House at-large candidates will have District 00.  # noqa: E501

        :return: The candidate_office_district of this ScheduleA.  # noqa: E501
        :rtype: str
        """
        return self._candidate_office_district

    @candidate_office_district.setter
    def candidate_office_district(self, candidate_office_district):
        """Sets the candidate_office_district of this ScheduleA.

        Two-digit US House distirict of the office the candidate is running for. Presidential, Senate and House at-large candidates will have District 00.  # noqa: E501

        :param candidate_office_district: The candidate_office_district of this ScheduleA.  # noqa: E501
        :type: str
        """

        self._candidate_office_district = candidate_office_district

    @property
    def candidate_office_full(self):
        """Gets the candidate_office_full of this ScheduleA.  # noqa: E501


        :return: The candidate_office_full of this ScheduleA.  # noqa: E501
        :rtype: str
        """
        return self._candidate_office_full

    @candidate_office_full.setter
    def candidate_office_full(self, candidate_office_full):
        """Sets the candidate_office_full of this ScheduleA.


        :param candidate_office_full: The candidate_office_full of this ScheduleA.  # noqa: E501
        :type: str
        """

        self._candidate_office_full = candidate_office_full

    @property
    def candidate_office_state(self):
        """Gets the candidate_office_state of this ScheduleA.  # noqa: E501


        :return: The candidate_office_state of this ScheduleA.  # noqa: E501
        :rtype: str
        """
        return self._candidate_office_state

    @candidate_office_state.setter
    def candidate_office_state(self, candidate_office_state):
        """Sets the candidate_office_state of this ScheduleA.


        :param candidate_office_state: The candidate_office_state of this ScheduleA.  # noqa: E501
        :type: str
        """

        self._candidate_office_state = candidate_office_state

    @property
    def candidate_office_state_full(self):
        """Gets the candidate_office_state_full of this ScheduleA.  # noqa: E501


        :return: The candidate_office_state_full of this ScheduleA.  # noqa: E501
        :rtype: str
        """
        return self._candidate_office_state_full

    @candidate_office_state_full.setter
    def candidate_office_state_full(self, candidate_office_state_full):
        """Sets the candidate_office_state_full of this ScheduleA.


        :param candidate_office_state_full: The candidate_office_state_full of this ScheduleA.  # noqa: E501
        :type: str
        """

        self._candidate_office_state_full = candidate_office_state_full

    @property
    def candidate_prefix(self):
        """Gets the candidate_prefix of this ScheduleA.  # noqa: E501


        :return: The candidate_prefix of this ScheduleA.  # noqa: E501
        :rtype: str
        """
        return self._candidate_prefix

    @candidate_prefix.setter
    def candidate_prefix(self, candidate_prefix):
        """Sets the candidate_prefix of this ScheduleA.


        :param candidate_prefix: The candidate_prefix of this ScheduleA.  # noqa: E501
        :type: str
        """

        self._candidate_prefix = candidate_prefix

    @property
    def candidate_suffix(self):
        """Gets the candidate_suffix of this ScheduleA.  # noqa: E501


        :return: The candidate_suffix of this ScheduleA.  # noqa: E501
        :rtype: str
        """
        return self._candidate_suffix

    @candidate_suffix.setter
    def candidate_suffix(self, candidate_suffix):
        """Sets the candidate_suffix of this ScheduleA.


        :param candidate_suffix: The candidate_suffix of this ScheduleA.  # noqa: E501
        :type: str
        """

        self._candidate_suffix = candidate_suffix

    @property
    def committee(self):
        """Gets the committee of this ScheduleA.  # noqa: E501


        :return: The committee of this ScheduleA.  # noqa: E501
        :rtype: CommitteeHistory
        """
        return self._committee

    @committee.setter
    def committee(self, committee):
        """Sets the committee of this ScheduleA.


        :param committee: The committee of this ScheduleA.  # noqa: E501
        :type: CommitteeHistory
        """

        self._committee = committee

    @property
    def committee_id(self):
        """Gets the committee_id of this ScheduleA.  # noqa: E501

         A unique identifier assigned to each committee or filer registered with the FEC. In general committee id's begin with the letter C which is followed by eight digits.   # noqa: E501

        :return: The committee_id of this ScheduleA.  # noqa: E501
        :rtype: str
        """
        return self._committee_id

    @committee_id.setter
    def committee_id(self, committee_id):
        """Sets the committee_id of this ScheduleA.

         A unique identifier assigned to each committee or filer registered with the FEC. In general committee id's begin with the letter C which is followed by eight digits.   # noqa: E501

        :param committee_id: The committee_id of this ScheduleA.  # noqa: E501
        :type: str
        """

        self._committee_id = committee_id

    @property
    def committee_name(self):
        """Gets the committee_name of this ScheduleA.  # noqa: E501

        The name of the committee. If a committee changes its name,     the most recent name will be shown. Committee names are not unique. Use committee_id     for looking up records.  # noqa: E501

        :return: The committee_name of this ScheduleA.  # noqa: E501
        :rtype: str
        """
        return self._committee_name

    @committee_name.setter
    def committee_name(self, committee_name):
        """Sets the committee_name of this ScheduleA.

        The name of the committee. If a committee changes its name,     the most recent name will be shown. Committee names are not unique. Use committee_id     for looking up records.  # noqa: E501

        :param committee_name: The committee_name of this ScheduleA.  # noqa: E501
        :type: str
        """

        self._committee_name = committee_name

    @property
    def conduit_committee_city(self):
        """Gets the conduit_committee_city of this ScheduleA.  # noqa: E501


        :return: The conduit_committee_city of this ScheduleA.  # noqa: E501
        :rtype: str
        """
        return self._conduit_committee_city

    @conduit_committee_city.setter
    def conduit_committee_city(self, conduit_committee_city):
        """Sets the conduit_committee_city of this ScheduleA.


        :param conduit_committee_city: The conduit_committee_city of this ScheduleA.  # noqa: E501
        :type: str
        """

        self._conduit_committee_city = conduit_committee_city

    @property
    def conduit_committee_id(self):
        """Gets the conduit_committee_id of this ScheduleA.  # noqa: E501


        :return: The conduit_committee_id of this ScheduleA.  # noqa: E501
        :rtype: str
        """
        return self._conduit_committee_id

    @conduit_committee_id.setter
    def conduit_committee_id(self, conduit_committee_id):
        """Sets the conduit_committee_id of this ScheduleA.


        :param conduit_committee_id: The conduit_committee_id of this ScheduleA.  # noqa: E501
        :type: str
        """

        self._conduit_committee_id = conduit_committee_id

    @property
    def conduit_committee_name(self):
        """Gets the conduit_committee_name of this ScheduleA.  # noqa: E501


        :return: The conduit_committee_name of this ScheduleA.  # noqa: E501
        :rtype: str
        """
        return self._conduit_committee_name

    @conduit_committee_name.setter
    def conduit_committee_name(self, conduit_committee_name):
        """Sets the conduit_committee_name of this ScheduleA.


        :param conduit_committee_name: The conduit_committee_name of this ScheduleA.  # noqa: E501
        :type: str
        """

        self._conduit_committee_name = conduit_committee_name

    @property
    def conduit_committee_state(self):
        """Gets the conduit_committee_state of this ScheduleA.  # noqa: E501


        :return: The conduit_committee_state of this ScheduleA.  # noqa: E501
        :rtype: str
        """
        return self._conduit_committee_state

    @conduit_committee_state.setter
    def conduit_committee_state(self, conduit_committee_state):
        """Sets the conduit_committee_state of this ScheduleA.


        :param conduit_committee_state: The conduit_committee_state of this ScheduleA.  # noqa: E501
        :type: str
        """

        self._conduit_committee_state = conduit_committee_state

    @property
    def conduit_committee_street1(self):
        """Gets the conduit_committee_street1 of this ScheduleA.  # noqa: E501


        :return: The conduit_committee_street1 of this ScheduleA.  # noqa: E501
        :rtype: str
        """
        return self._conduit_committee_street1

    @conduit_committee_street1.setter
    def conduit_committee_street1(self, conduit_committee_street1):
        """Sets the conduit_committee_street1 of this ScheduleA.


        :param conduit_committee_street1: The conduit_committee_street1 of this ScheduleA.  # noqa: E501
        :type: str
        """

        self._conduit_committee_street1 = conduit_committee_street1

    @property
    def conduit_committee_street2(self):
        """Gets the conduit_committee_street2 of this ScheduleA.  # noqa: E501


        :return: The conduit_committee_street2 of this ScheduleA.  # noqa: E501
        :rtype: str
        """
        return self._conduit_committee_street2

    @conduit_committee_street2.setter
    def conduit_committee_street2(self, conduit_committee_street2):
        """Sets the conduit_committee_street2 of this ScheduleA.


        :param conduit_committee_street2: The conduit_committee_street2 of this ScheduleA.  # noqa: E501
        :type: str
        """

        self._conduit_committee_street2 = conduit_committee_street2

    @property
    def conduit_committee_zip(self):
        """Gets the conduit_committee_zip of this ScheduleA.  # noqa: E501


        :return: The conduit_committee_zip of this ScheduleA.  # noqa: E501
        :rtype: int
        """
        return self._conduit_committee_zip

    @conduit_committee_zip.setter
    def conduit_committee_zip(self, conduit_committee_zip):
        """Sets the conduit_committee_zip of this ScheduleA.


        :param conduit_committee_zip: The conduit_committee_zip of this ScheduleA.  # noqa: E501
        :type: int
        """

        self._conduit_committee_zip = conduit_committee_zip

    @property
    def contribution_receipt_amount(self):
        """Gets the contribution_receipt_amount of this ScheduleA.  # noqa: E501


        :return: The contribution_receipt_amount of this ScheduleA.  # noqa: E501
        :rtype: float
        """
        return self._contribution_receipt_amount

    @contribution_receipt_amount.setter
    def contribution_receipt_amount(self, contribution_receipt_amount):
        """Sets the contribution_receipt_amount of this ScheduleA.


        :param contribution_receipt_amount: The contribution_receipt_amount of this ScheduleA.  # noqa: E501
        :type: float
        """

        self._contribution_receipt_amount = contribution_receipt_amount

    @property
    def contribution_receipt_date(self):
        """Gets the contribution_receipt_date of this ScheduleA.  # noqa: E501


        :return: The contribution_receipt_date of this ScheduleA.  # noqa: E501
        :rtype: date
        """
        return self._contribution_receipt_date

    @contribution_receipt_date.setter
    def contribution_receipt_date(self, contribution_receipt_date):
        """Sets the contribution_receipt_date of this ScheduleA.


        :param contribution_receipt_date: The contribution_receipt_date of this ScheduleA.  # noqa: E501
        :type: date
        """

        self._contribution_receipt_date = contribution_receipt_date

    @property
    def contributor(self):
        """Gets the contributor of this ScheduleA.  # noqa: E501


        :return: The contributor of this ScheduleA.  # noqa: E501
        :rtype: CommitteeHistory
        """
        return self._contributor

    @contributor.setter
    def contributor(self, contributor):
        """Sets the contributor of this ScheduleA.


        :param contributor: The contributor of this ScheduleA.  # noqa: E501
        :type: CommitteeHistory
        """

        self._contributor = contributor

    @property
    def contributor_aggregate_ytd(self):
        """Gets the contributor_aggregate_ytd of this ScheduleA.  # noqa: E501


        :return: The contributor_aggregate_ytd of this ScheduleA.  # noqa: E501
        :rtype: float
        """
        return self._contributor_aggregate_ytd

    @contributor_aggregate_ytd.setter
    def contributor_aggregate_ytd(self, contributor_aggregate_ytd):
        """Sets the contributor_aggregate_ytd of this ScheduleA.


        :param contributor_aggregate_ytd: The contributor_aggregate_ytd of this ScheduleA.  # noqa: E501
        :type: float
        """

        self._contributor_aggregate_ytd = contributor_aggregate_ytd

    @property
    def contributor_city(self):
        """Gets the contributor_city of this ScheduleA.  # noqa: E501

        City of contributor  # noqa: E501

        :return: The contributor_city of this ScheduleA.  # noqa: E501
        :rtype: str
        """
        return self._contributor_city

    @contributor_city.setter
    def contributor_city(self, contributor_city):
        """Sets the contributor_city of this ScheduleA.

        City of contributor  # noqa: E501

        :param contributor_city: The contributor_city of this ScheduleA.  # noqa: E501
        :type: str
        """

        self._contributor_city = contributor_city

    @property
    def contributor_employer(self):
        """Gets the contributor_employer of this ScheduleA.  # noqa: E501

        Employer of contributor, filers need to make an effort to gather this information  # noqa: E501

        :return: The contributor_employer of this ScheduleA.  # noqa: E501
        :rtype: str
        """
        return self._contributor_employer

    @contributor_employer.setter
    def contributor_employer(self, contributor_employer):
        """Sets the contributor_employer of this ScheduleA.

        Employer of contributor, filers need to make an effort to gather this information  # noqa: E501

        :param contributor_employer: The contributor_employer of this ScheduleA.  # noqa: E501
        :type: str
        """

        self._contributor_employer = contributor_employer

    @property
    def contributor_first_name(self):
        """Gets the contributor_first_name of this ScheduleA.  # noqa: E501


        :return: The contributor_first_name of this ScheduleA.  # noqa: E501
        :rtype: str
        """
        return self._contributor_first_name

    @contributor_first_name.setter
    def contributor_first_name(self, contributor_first_name):
        """Sets the contributor_first_name of this ScheduleA.


        :param contributor_first_name: The contributor_first_name of this ScheduleA.  # noqa: E501
        :type: str
        """

        self._contributor_first_name = contributor_first_name

    @property
    def contributor_id(self):
        """Gets the contributor_id of this ScheduleA.  # noqa: E501

        The FEC identifier should be represented here if the contributor is registered with the FEC.  # noqa: E501

        :return: The contributor_id of this ScheduleA.  # noqa: E501
        :rtype: str
        """
        return self._contributor_id

    @contributor_id.setter
    def contributor_id(self, contributor_id):
        """Sets the contributor_id of this ScheduleA.

        The FEC identifier should be represented here if the contributor is registered with the FEC.  # noqa: E501

        :param contributor_id: The contributor_id of this ScheduleA.  # noqa: E501
        :type: str
        """

        self._contributor_id = contributor_id

    @property
    def contributor_last_name(self):
        """Gets the contributor_last_name of this ScheduleA.  # noqa: E501


        :return: The contributor_last_name of this ScheduleA.  # noqa: E501
        :rtype: str
        """
        return self._contributor_last_name

    @contributor_last_name.setter
    def contributor_last_name(self, contributor_last_name):
        """Sets the contributor_last_name of this ScheduleA.


        :param contributor_last_name: The contributor_last_name of this ScheduleA.  # noqa: E501
        :type: str
        """

        self._contributor_last_name = contributor_last_name

    @property
    def contributor_middle_name(self):
        """Gets the contributor_middle_name of this ScheduleA.  # noqa: E501


        :return: The contributor_middle_name of this ScheduleA.  # noqa: E501
        :rtype: str
        """
        return self._contributor_middle_name

    @contributor_middle_name.setter
    def contributor_middle_name(self, contributor_middle_name):
        """Sets the contributor_middle_name of this ScheduleA.


        :param contributor_middle_name: The contributor_middle_name of this ScheduleA.  # noqa: E501
        :type: str
        """

        self._contributor_middle_name = contributor_middle_name

    @property
    def contributor_name(self):
        """Gets the contributor_name of this ScheduleA.  # noqa: E501

        Name of contributor  # noqa: E501

        :return: The contributor_name of this ScheduleA.  # noqa: E501
        :rtype: str
        """
        return self._contributor_name

    @contributor_name.setter
    def contributor_name(self, contributor_name):
        """Sets the contributor_name of this ScheduleA.

        Name of contributor  # noqa: E501

        :param contributor_name: The contributor_name of this ScheduleA.  # noqa: E501
        :type: str
        """

        self._contributor_name = contributor_name

    @property
    def contributor_occupation(self):
        """Gets the contributor_occupation of this ScheduleA.  # noqa: E501

        Occupation of contributor, filers need to make an effort to gather this information  # noqa: E501

        :return: The contributor_occupation of this ScheduleA.  # noqa: E501
        :rtype: str
        """
        return self._contributor_occupation

    @contributor_occupation.setter
    def contributor_occupation(self, contributor_occupation):
        """Sets the contributor_occupation of this ScheduleA.

        Occupation of contributor, filers need to make an effort to gather this information  # noqa: E501

        :param contributor_occupation: The contributor_occupation of this ScheduleA.  # noqa: E501
        :type: str
        """

        self._contributor_occupation = contributor_occupation

    @property
    def contributor_prefix(self):
        """Gets the contributor_prefix of this ScheduleA.  # noqa: E501


        :return: The contributor_prefix of this ScheduleA.  # noqa: E501
        :rtype: str
        """
        return self._contributor_prefix

    @contributor_prefix.setter
    def contributor_prefix(self, contributor_prefix):
        """Sets the contributor_prefix of this ScheduleA.


        :param contributor_prefix: The contributor_prefix of this ScheduleA.  # noqa: E501
        :type: str
        """

        self._contributor_prefix = contributor_prefix

    @property
    def contributor_state(self):
        """Gets the contributor_state of this ScheduleA.  # noqa: E501

        State of contributor  # noqa: E501

        :return: The contributor_state of this ScheduleA.  # noqa: E501
        :rtype: str
        """
        return self._contributor_state

    @contributor_state.setter
    def contributor_state(self, contributor_state):
        """Sets the contributor_state of this ScheduleA.

        State of contributor  # noqa: E501

        :param contributor_state: The contributor_state of this ScheduleA.  # noqa: E501
        :type: str
        """

        self._contributor_state = contributor_state

    @property
    def contributor_street_1(self):
        """Gets the contributor_street_1 of this ScheduleA.  # noqa: E501


        :return: The contributor_street_1 of this ScheduleA.  # noqa: E501
        :rtype: str
        """
        return self._contributor_street_1

    @contributor_street_1.setter
    def contributor_street_1(self, contributor_street_1):
        """Sets the contributor_street_1 of this ScheduleA.


        :param contributor_street_1: The contributor_street_1 of this ScheduleA.  # noqa: E501
        :type: str
        """

        self._contributor_street_1 = contributor_street_1

    @property
    def contributor_street_2(self):
        """Gets the contributor_street_2 of this ScheduleA.  # noqa: E501


        :return: The contributor_street_2 of this ScheduleA.  # noqa: E501
        :rtype: str
        """
        return self._contributor_street_2

    @contributor_street_2.setter
    def contributor_street_2(self, contributor_street_2):
        """Sets the contributor_street_2 of this ScheduleA.


        :param contributor_street_2: The contributor_street_2 of this ScheduleA.  # noqa: E501
        :type: str
        """

        self._contributor_street_2 = contributor_street_2

    @property
    def contributor_suffix(self):
        """Gets the contributor_suffix of this ScheduleA.  # noqa: E501


        :return: The contributor_suffix of this ScheduleA.  # noqa: E501
        :rtype: str
        """
        return self._contributor_suffix

    @contributor_suffix.setter
    def contributor_suffix(self, contributor_suffix):
        """Sets the contributor_suffix of this ScheduleA.


        :param contributor_suffix: The contributor_suffix of this ScheduleA.  # noqa: E501
        :type: str
        """

        self._contributor_suffix = contributor_suffix

    @property
    def contributor_zip(self):
        """Gets the contributor_zip of this ScheduleA.  # noqa: E501

        Zip code of contributor  # noqa: E501

        :return: The contributor_zip of this ScheduleA.  # noqa: E501
        :rtype: str
        """
        return self._contributor_zip

    @contributor_zip.setter
    def contributor_zip(self, contributor_zip):
        """Sets the contributor_zip of this ScheduleA.

        Zip code of contributor  # noqa: E501

        :param contributor_zip: The contributor_zip of this ScheduleA.  # noqa: E501
        :type: str
        """

        self._contributor_zip = contributor_zip

    @property
    def donor_committee_name(self):
        """Gets the donor_committee_name of this ScheduleA.  # noqa: E501


        :return: The donor_committee_name of this ScheduleA.  # noqa: E501
        :rtype: str
        """
        return self._donor_committee_name

    @donor_committee_name.setter
    def donor_committee_name(self, donor_committee_name):
        """Sets the donor_committee_name of this ScheduleA.


        :param donor_committee_name: The donor_committee_name of this ScheduleA.  # noqa: E501
        :type: str
        """

        self._donor_committee_name = donor_committee_name

    @property
    def election_type(self):
        """Gets the election_type of this ScheduleA.  # noqa: E501


        :return: The election_type of this ScheduleA.  # noqa: E501
        :rtype: str
        """
        return self._election_type

    @election_type.setter
    def election_type(self, election_type):
        """Sets the election_type of this ScheduleA.


        :param election_type: The election_type of this ScheduleA.  # noqa: E501
        :type: str
        """

        self._election_type = election_type

    @property
    def election_type_full(self):
        """Gets the election_type_full of this ScheduleA.  # noqa: E501


        :return: The election_type_full of this ScheduleA.  # noqa: E501
        :rtype: str
        """
        return self._election_type_full

    @election_type_full.setter
    def election_type_full(self, election_type_full):
        """Sets the election_type_full of this ScheduleA.


        :param election_type_full: The election_type_full of this ScheduleA.  # noqa: E501
        :type: str
        """

        self._election_type_full = election_type_full

    @property
    def entity_type(self):
        """Gets the entity_type of this ScheduleA.  # noqa: E501


        :return: The entity_type of this ScheduleA.  # noqa: E501
        :rtype: str
        """
        return self._entity_type

    @entity_type.setter
    def entity_type(self, entity_type):
        """Sets the entity_type of this ScheduleA.


        :param entity_type: The entity_type of this ScheduleA.  # noqa: E501
        :type: str
        """

        self._entity_type = entity_type

    @property
    def entity_type_desc(self):
        """Gets the entity_type_desc of this ScheduleA.  # noqa: E501


        :return: The entity_type_desc of this ScheduleA.  # noqa: E501
        :rtype: str
        """
        return self._entity_type_desc

    @entity_type_desc.setter
    def entity_type_desc(self, entity_type_desc):
        """Sets the entity_type_desc of this ScheduleA.


        :param entity_type_desc: The entity_type_desc of this ScheduleA.  # noqa: E501
        :type: str
        """

        self._entity_type_desc = entity_type_desc

    @property
    def fec_election_type_desc(self):
        """Gets the fec_election_type_desc of this ScheduleA.  # noqa: E501


        :return: The fec_election_type_desc of this ScheduleA.  # noqa: E501
        :rtype: str
        """
        return self._fec_election_type_desc

    @fec_election_type_desc.setter
    def fec_election_type_desc(self, fec_election_type_desc):
        """Sets the fec_election_type_desc of this ScheduleA.


        :param fec_election_type_desc: The fec_election_type_desc of this ScheduleA.  # noqa: E501
        :type: str
        """

        self._fec_election_type_desc = fec_election_type_desc

    @property
    def fec_election_year(self):
        """Gets the fec_election_year of this ScheduleA.  # noqa: E501


        :return: The fec_election_year of this ScheduleA.  # noqa: E501
        :rtype: str
        """
        return self._fec_election_year

    @fec_election_year.setter
    def fec_election_year(self, fec_election_year):
        """Sets the fec_election_year of this ScheduleA.


        :param fec_election_year: The fec_election_year of this ScheduleA.  # noqa: E501
        :type: str
        """

        self._fec_election_year = fec_election_year

    @property
    def file_number(self):
        """Gets the file_number of this ScheduleA.  # noqa: E501


        :return: The file_number of this ScheduleA.  # noqa: E501
        :rtype: int
        """
        return self._file_number

    @file_number.setter
    def file_number(self, file_number):
        """Sets the file_number of this ScheduleA.


        :param file_number: The file_number of this ScheduleA.  # noqa: E501
        :type: int
        """

        self._file_number = file_number

    @property
    def filing_form(self):
        """Gets the filing_form of this ScheduleA.  # noqa: E501


        :return: The filing_form of this ScheduleA.  # noqa: E501
        :rtype: str
        """
        return self._filing_form

    @filing_form.setter
    def filing_form(self, filing_form):
        """Sets the filing_form of this ScheduleA.


        :param filing_form: The filing_form of this ScheduleA.  # noqa: E501
        :type: str
        """

        self._filing_form = filing_form

    @property
    def image_number(self):
        """Gets the image_number of this ScheduleA.  # noqa: E501


        :return: The image_number of this ScheduleA.  # noqa: E501
        :rtype: str
        """
        return self._image_number

    @image_number.setter
    def image_number(self, image_number):
        """Sets the image_number of this ScheduleA.


        :param image_number: The image_number of this ScheduleA.  # noqa: E501
        :type: str
        """

        self._image_number = image_number

    @property
    def increased_limit(self):
        """Gets the increased_limit of this ScheduleA.  # noqa: E501


        :return: The increased_limit of this ScheduleA.  # noqa: E501
        :rtype: str
        """
        return self._increased_limit

    @increased_limit.setter
    def increased_limit(self, increased_limit):
        """Sets the increased_limit of this ScheduleA.


        :param increased_limit: The increased_limit of this ScheduleA.  # noqa: E501
        :type: str
        """

        self._increased_limit = increased_limit

    @property
    def is_individual(self):
        """Gets the is_individual of this ScheduleA.  # noqa: E501


        :return: The is_individual of this ScheduleA.  # noqa: E501
        :rtype: bool
        """
        return self._is_individual

    @is_individual.setter
    def is_individual(self, is_individual):
        """Sets the is_individual of this ScheduleA.


        :param is_individual: The is_individual of this ScheduleA.  # noqa: E501
        :type: bool
        """

        self._is_individual = is_individual

    @property
    def line_number(self):
        """Gets the line_number of this ScheduleA.  # noqa: E501


        :return: The line_number of this ScheduleA.  # noqa: E501
        :rtype: str
        """
        return self._line_number

    @line_number.setter
    def line_number(self, line_number):
        """Sets the line_number of this ScheduleA.


        :param line_number: The line_number of this ScheduleA.  # noqa: E501
        :type: str
        """

        self._line_number = line_number

    @property
    def line_number_label(self):
        """Gets the line_number_label of this ScheduleA.  # noqa: E501


        :return: The line_number_label of this ScheduleA.  # noqa: E501
        :rtype: str
        """
        return self._line_number_label

    @line_number_label.setter
    def line_number_label(self, line_number_label):
        """Sets the line_number_label of this ScheduleA.


        :param line_number_label: The line_number_label of this ScheduleA.  # noqa: E501
        :type: str
        """

        self._line_number_label = line_number_label

    @property
    def link_id(self):
        """Gets the link_id of this ScheduleA.  # noqa: E501


        :return: The link_id of this ScheduleA.  # noqa: E501
        :rtype: int
        """
        return self._link_id

    @link_id.setter
    def link_id(self, link_id):
        """Sets the link_id of this ScheduleA.


        :param link_id: The link_id of this ScheduleA.  # noqa: E501
        :type: int
        """

        self._link_id = link_id

    @property
    def load_date(self):
        """Gets the load_date of this ScheduleA.  # noqa: E501


        :return: The load_date of this ScheduleA.  # noqa: E501
        :rtype: datetime
        """
        return self._load_date

    @load_date.setter
    def load_date(self, load_date):
        """Sets the load_date of this ScheduleA.


        :param load_date: The load_date of this ScheduleA.  # noqa: E501
        :type: datetime
        """

        self._load_date = load_date

    @property
    def memo_code(self):
        """Gets the memo_code of this ScheduleA.  # noqa: E501


        :return: The memo_code of this ScheduleA.  # noqa: E501
        :rtype: str
        """
        return self._memo_code

    @memo_code.setter
    def memo_code(self, memo_code):
        """Sets the memo_code of this ScheduleA.


        :param memo_code: The memo_code of this ScheduleA.  # noqa: E501
        :type: str
        """

        self._memo_code = memo_code

    @property
    def memo_code_full(self):
        """Gets the memo_code_full of this ScheduleA.  # noqa: E501


        :return: The memo_code_full of this ScheduleA.  # noqa: E501
        :rtype: str
        """
        return self._memo_code_full

    @memo_code_full.setter
    def memo_code_full(self, memo_code_full):
        """Sets the memo_code_full of this ScheduleA.


        :param memo_code_full: The memo_code_full of this ScheduleA.  # noqa: E501
        :type: str
        """

        self._memo_code_full = memo_code_full

    @property
    def memo_text(self):
        """Gets the memo_text of this ScheduleA.  # noqa: E501


        :return: The memo_text of this ScheduleA.  # noqa: E501
        :rtype: str
        """
        return self._memo_text

    @memo_text.setter
    def memo_text(self, memo_text):
        """Sets the memo_text of this ScheduleA.


        :param memo_text: The memo_text of this ScheduleA.  # noqa: E501
        :type: str
        """

        self._memo_text = memo_text

    @property
    def memoed_subtotal(self):
        """Gets the memoed_subtotal of this ScheduleA.  # noqa: E501


        :return: The memoed_subtotal of this ScheduleA.  # noqa: E501
        :rtype: bool
        """
        return self._memoed_subtotal

    @memoed_subtotal.setter
    def memoed_subtotal(self, memoed_subtotal):
        """Sets the memoed_subtotal of this ScheduleA.


        :param memoed_subtotal: The memoed_subtotal of this ScheduleA.  # noqa: E501
        :type: bool
        """

        self._memoed_subtotal = memoed_subtotal

    @property
    def national_committee_nonfederal_account(self):
        """Gets the national_committee_nonfederal_account of this ScheduleA.  # noqa: E501


        :return: The national_committee_nonfederal_account of this ScheduleA.  # noqa: E501
        :rtype: str
        """
        return self._national_committee_nonfederal_account

    @national_committee_nonfederal_account.setter
    def national_committee_nonfederal_account(self, national_committee_nonfederal_account):
        """Sets the national_committee_nonfederal_account of this ScheduleA.


        :param national_committee_nonfederal_account: The national_committee_nonfederal_account of this ScheduleA.  # noqa: E501
        :type: str
        """

        self._national_committee_nonfederal_account = national_committee_nonfederal_account

    @property
    def original_sub_id(self):
        """Gets the original_sub_id of this ScheduleA.  # noqa: E501


        :return: The original_sub_id of this ScheduleA.  # noqa: E501
        :rtype: str
        """
        return self._original_sub_id

    @original_sub_id.setter
    def original_sub_id(self, original_sub_id):
        """Sets the original_sub_id of this ScheduleA.


        :param original_sub_id: The original_sub_id of this ScheduleA.  # noqa: E501
        :type: str
        """

        self._original_sub_id = original_sub_id

    @property
    def pdf_url(self):
        """Gets the pdf_url of this ScheduleA.  # noqa: E501


        :return: The pdf_url of this ScheduleA.  # noqa: E501
        :rtype: str
        """
        return self._pdf_url

    @pdf_url.setter
    def pdf_url(self, pdf_url):
        """Sets the pdf_url of this ScheduleA.


        :param pdf_url: The pdf_url of this ScheduleA.  # noqa: E501
        :type: str
        """

        self._pdf_url = pdf_url

    @property
    def receipt_type(self):
        """Gets the receipt_type of this ScheduleA.  # noqa: E501


        :return: The receipt_type of this ScheduleA.  # noqa: E501
        :rtype: str
        """
        return self._receipt_type

    @receipt_type.setter
    def receipt_type(self, receipt_type):
        """Sets the receipt_type of this ScheduleA.


        :param receipt_type: The receipt_type of this ScheduleA.  # noqa: E501
        :type: str
        """

        self._receipt_type = receipt_type

    @property
    def receipt_type_desc(self):
        """Gets the receipt_type_desc of this ScheduleA.  # noqa: E501


        :return: The receipt_type_desc of this ScheduleA.  # noqa: E501
        :rtype: str
        """
        return self._receipt_type_desc

    @receipt_type_desc.setter
    def receipt_type_desc(self, receipt_type_desc):
        """Sets the receipt_type_desc of this ScheduleA.


        :param receipt_type_desc: The receipt_type_desc of this ScheduleA.  # noqa: E501
        :type: str
        """

        self._receipt_type_desc = receipt_type_desc

    @property
    def receipt_type_full(self):
        """Gets the receipt_type_full of this ScheduleA.  # noqa: E501


        :return: The receipt_type_full of this ScheduleA.  # noqa: E501
        :rtype: str
        """
        return self._receipt_type_full

    @receipt_type_full.setter
    def receipt_type_full(self, receipt_type_full):
        """Sets the receipt_type_full of this ScheduleA.


        :param receipt_type_full: The receipt_type_full of this ScheduleA.  # noqa: E501
        :type: str
        """

        self._receipt_type_full = receipt_type_full

    @property
    def recipient_committee_designation(self):
        """Gets the recipient_committee_designation of this ScheduleA.  # noqa: E501


        :return: The recipient_committee_designation of this ScheduleA.  # noqa: E501
        :rtype: str
        """
        return self._recipient_committee_designation

    @recipient_committee_designation.setter
    def recipient_committee_designation(self, recipient_committee_designation):
        """Sets the recipient_committee_designation of this ScheduleA.


        :param recipient_committee_designation: The recipient_committee_designation of this ScheduleA.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                recipient_committee_designation is not None and len(recipient_committee_designation) > 1):
            raise ValueError('Invalid value for `recipient_committee_designation`, length must be less than or equal to `1`')  # noqa: E501

        self._recipient_committee_designation = recipient_committee_designation

    @property
    def recipient_committee_org_type(self):
        """Gets the recipient_committee_org_type of this ScheduleA.  # noqa: E501


        :return: The recipient_committee_org_type of this ScheduleA.  # noqa: E501
        :rtype: str
        """
        return self._recipient_committee_org_type

    @recipient_committee_org_type.setter
    def recipient_committee_org_type(self, recipient_committee_org_type):
        """Sets the recipient_committee_org_type of this ScheduleA.


        :param recipient_committee_org_type: The recipient_committee_org_type of this ScheduleA.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                recipient_committee_org_type is not None and len(recipient_committee_org_type) > 1):
            raise ValueError('Invalid value for `recipient_committee_org_type`, length must be less than or equal to `1`')  # noqa: E501

        self._recipient_committee_org_type = recipient_committee_org_type

    @property
    def recipient_committee_type(self):
        """Gets the recipient_committee_type of this ScheduleA.  # noqa: E501


        :return: The recipient_committee_type of this ScheduleA.  # noqa: E501
        :rtype: str
        """
        return self._recipient_committee_type

    @recipient_committee_type.setter
    def recipient_committee_type(self, recipient_committee_type):
        """Sets the recipient_committee_type of this ScheduleA.


        :param recipient_committee_type: The recipient_committee_type of this ScheduleA.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                recipient_committee_type is not None and len(recipient_committee_type) > 1):
            raise ValueError('Invalid value for `recipient_committee_type`, length must be less than or equal to `1`')  # noqa: E501

        self._recipient_committee_type = recipient_committee_type

    @property
    def report_type(self):
        """Gets the report_type of this ScheduleA.  # noqa: E501

        Name of report where the underlying data comes from:     - 10D Pre-Election     - 10G Pre-General     - 10P Pre-Primary     - 10R Pre-Run-Off     - 10S Pre-Special     - 12C Pre-Convention     - 12G Pre-General     - 12P Pre-Primary     - 12R Pre-Run-Off     - 12S Pre-Special     - 30D Post-Election     - 30G Post-General     - 30P Post-Primary     - 30R Post-Run-Off     - 30S Post-Special     - 60D Post-Convention     - M1  January Monthly     - M10 October Monthly     - M11 November Monthly     - M12 December Monthly     - M2  February Monthly     - M3  March Monthly     - M4  April Monthly     - M5  May Monthly     - M6  June Monthly     - M7  July Monthly     - M8  August Monthly     - M9  September Monthly     - MY  Mid-Year Report     - Q1  April Quarterly     - Q2  July Quarterly     - Q3  October Quarterly     - TER Termination Report     - YE  Year-End     - ADJ COMP ADJUST AMEND     - CA  COMPREHENSIVE AMEND     - 90S Post Inaugural Supplement     - 90D Post Inaugural     - 48  48 Hour Notification     - 24  24 Hour Notification     - M7S July Monthly/Semi-Annual     - MSA Monthly Semi-Annual (MY)     - MYS Monthly Year End/Semi-Annual     - Q2S July Quarterly/Semi-Annual     - QSA Quarterly Semi-Annual (MY)     - QYS Quarterly Year End/Semi-Annual     - QYE Quarterly Semi-Annual (YE)     - QMS Quarterly Mid-Year/ Semi-Annual     - MSY Monthly Semi-Annual (YE)   # noqa: E501

        :return: The report_type of this ScheduleA.  # noqa: E501
        :rtype: str
        """
        return self._report_type

    @report_type.setter
    def report_type(self, report_type):
        """Sets the report_type of this ScheduleA.

        Name of report where the underlying data comes from:     - 10D Pre-Election     - 10G Pre-General     - 10P Pre-Primary     - 10R Pre-Run-Off     - 10S Pre-Special     - 12C Pre-Convention     - 12G Pre-General     - 12P Pre-Primary     - 12R Pre-Run-Off     - 12S Pre-Special     - 30D Post-Election     - 30G Post-General     - 30P Post-Primary     - 30R Post-Run-Off     - 30S Post-Special     - 60D Post-Convention     - M1  January Monthly     - M10 October Monthly     - M11 November Monthly     - M12 December Monthly     - M2  February Monthly     - M3  March Monthly     - M4  April Monthly     - M5  May Monthly     - M6  June Monthly     - M7  July Monthly     - M8  August Monthly     - M9  September Monthly     - MY  Mid-Year Report     - Q1  April Quarterly     - Q2  July Quarterly     - Q3  October Quarterly     - TER Termination Report     - YE  Year-End     - ADJ COMP ADJUST AMEND     - CA  COMPREHENSIVE AMEND     - 90S Post Inaugural Supplement     - 90D Post Inaugural     - 48  48 Hour Notification     - 24  24 Hour Notification     - M7S July Monthly/Semi-Annual     - MSA Monthly Semi-Annual (MY)     - MYS Monthly Year End/Semi-Annual     - Q2S July Quarterly/Semi-Annual     - QSA Quarterly Semi-Annual (MY)     - QYS Quarterly Year End/Semi-Annual     - QYE Quarterly Semi-Annual (YE)     - QMS Quarterly Mid-Year/ Semi-Annual     - MSY Monthly Semi-Annual (YE)   # noqa: E501

        :param report_type: The report_type of this ScheduleA.  # noqa: E501
        :type: str
        """

        self._report_type = report_type

    @property
    def report_year(self):
        """Gets the report_year of this ScheduleA.  # noqa: E501

         Forms with coverage date -      year from the coverage ending date. Forms without coverage date -      year from the receipt date.   # noqa: E501

        :return: The report_year of this ScheduleA.  # noqa: E501
        :rtype: int
        """
        return self._report_year

    @report_year.setter
    def report_year(self, report_year):
        """Sets the report_year of this ScheduleA.

         Forms with coverage date -      year from the coverage ending date. Forms without coverage date -      year from the receipt date.   # noqa: E501

        :param report_year: The report_year of this ScheduleA.  # noqa: E501
        :type: int
        """

        self._report_year = report_year

    @property
    def schedule_type(self):
        """Gets the schedule_type of this ScheduleA.  # noqa: E501


        :return: The schedule_type of this ScheduleA.  # noqa: E501
        :rtype: str
        """
        return self._schedule_type

    @schedule_type.setter
    def schedule_type(self, schedule_type):
        """Sets the schedule_type of this ScheduleA.


        :param schedule_type: The schedule_type of this ScheduleA.  # noqa: E501
        :type: str
        """

        self._schedule_type = schedule_type

    @property
    def schedule_type_full(self):
        """Gets the schedule_type_full of this ScheduleA.  # noqa: E501


        :return: The schedule_type_full of this ScheduleA.  # noqa: E501
        :rtype: str
        """
        return self._schedule_type_full

    @schedule_type_full.setter
    def schedule_type_full(self, schedule_type_full):
        """Sets the schedule_type_full of this ScheduleA.


        :param schedule_type_full: The schedule_type_full of this ScheduleA.  # noqa: E501
        :type: str
        """

        self._schedule_type_full = schedule_type_full

    @property
    def sub_id(self):
        """Gets the sub_id of this ScheduleA.  # noqa: E501


        :return: The sub_id of this ScheduleA.  # noqa: E501
        :rtype: str
        """
        return self._sub_id

    @sub_id.setter
    def sub_id(self, sub_id):
        """Sets the sub_id of this ScheduleA.


        :param sub_id: The sub_id of this ScheduleA.  # noqa: E501
        :type: str
        """

        self._sub_id = sub_id

    @property
    def transaction_id(self):
        """Gets the transaction_id of this ScheduleA.  # noqa: E501


        :return: The transaction_id of this ScheduleA.  # noqa: E501
        :rtype: str
        """
        return self._transaction_id

    @transaction_id.setter
    def transaction_id(self, transaction_id):
        """Sets the transaction_id of this ScheduleA.


        :param transaction_id: The transaction_id of this ScheduleA.  # noqa: E501
        :type: str
        """

        self._transaction_id = transaction_id

    @property
    def two_year_transaction_period(self):
        """Gets the two_year_transaction_period of this ScheduleA.  # noqa: E501

         This is a two-year period that is derived from the year a transaction took place in the Itemized Schedule A and Schedule B tables. In cases where we have the date of the transaction (contribution_receipt_date in schedules/schedule_a, disbursement_date in schedules/schedule_b) the two_year_transaction_period is named after the ending, even-numbered year. If we do not have the date  of the transaction, we fall back to using the report year (report_year in both tables) instead,  making the same cycle adjustment as necessary. If no transaction year is specified, the results default to the most current cycle.   # noqa: E501

        :return: The two_year_transaction_period of this ScheduleA.  # noqa: E501
        :rtype: int
        """
        return self._two_year_transaction_period

    @two_year_transaction_period.setter
    def two_year_transaction_period(self, two_year_transaction_period):
        """Sets the two_year_transaction_period of this ScheduleA.

         This is a two-year period that is derived from the year a transaction took place in the Itemized Schedule A and Schedule B tables. In cases where we have the date of the transaction (contribution_receipt_date in schedules/schedule_a, disbursement_date in schedules/schedule_b) the two_year_transaction_period is named after the ending, even-numbered year. If we do not have the date  of the transaction, we fall back to using the report year (report_year in both tables) instead,  making the same cycle adjustment as necessary. If no transaction year is specified, the results default to the most current cycle.   # noqa: E501

        :param two_year_transaction_period: The two_year_transaction_period of this ScheduleA.  # noqa: E501
        :type: int
        """

        self._two_year_transaction_period = two_year_transaction_period

    @property
    def unused_contbr_id(self):
        """Gets the unused_contbr_id of this ScheduleA.  # noqa: E501


        :return: The unused_contbr_id of this ScheduleA.  # noqa: E501
        :rtype: str
        """
        return self._unused_contbr_id

    @unused_contbr_id.setter
    def unused_contbr_id(self, unused_contbr_id):
        """Sets the unused_contbr_id of this ScheduleA.


        :param unused_contbr_id: The unused_contbr_id of this ScheduleA.  # noqa: E501
        :type: str
        """

        self._unused_contbr_id = unused_contbr_id

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, 'to_dict') else x,
                    value
                ))
            elif hasattr(value, 'to_dict'):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], 'to_dict') else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ScheduleA):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, ScheduleA):
            return True

        return self.to_dict() != other.to_dict()
