# coding: utf-8

"""
    OpenFEC

    This API allows you to explore the way candidates and committees fund their campaigns.    The FEC API is a RESTful web service supporting full-text and field-specific searches on FEC data. [Bulk downloads](https://www.fec.gov/data/advanced/?tab=bulk-data) are available on the current site. Information is tied to the underlying forms by file ID and image ID. Data is updated nightly.    There is a lot of data, but a good place to start is to use search to find interesting candidates and committees. Then, you can use their IDs to find report or line item details with the other endpoints. If you are interested in individual donors, check out contributor information in schedule_a.    Get an [API key here](https://api.data.gov/signup/). That will enable you to place up to 1,000 calls an hour. Each call is limited to 100 results per page. You can email questions, comments or a request to get a key for 120 calls per minute to [APIinfo@fec.gov](mailto:apiinfo@fec.gov). You can also ask questions and discuss the data in the [FEC data Google Group](https://groups.google.com/forum/#!forum/fec-data). API changes will also be added to this group in advance of the change.    The model definitions and schema are available at [/swagger](/swagger/). This is useful for making wrappers and exploring the data.    A few restrictions limit the way you can use FEC data. For example, you can’t use contributor lists for commercial purposes or to solicit donations. [Learn more here](https://www.fec.gov/updates/sale-or-use-contributor-information/).    [View our source code](https://github.com/fecgov/openFEC). We welcome issues and pull requests!  # noqa: E501

    The version of the OpenAPI document: 1.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from openfec_sdk.configuration import Configuration


class ScheduleAEfile(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'amendment_indicator': 'str',
        'back_reference_schedule_name': 'str',
        'back_reference_transaction_id': 'str',
        'beginning_image_number': 'str',
        'committee': 'CommitteeHistory',
        'committee_id': 'str',
        'conduit_committee_city': 'str',
        'conduit_committee_id': 'str',
        'conduit_committee_name': 'str',
        'conduit_committee_state': 'str',
        'conduit_committee_street1': 'str',
        'conduit_committee_street2': 'str',
        'conduit_committee_zip': 'int',
        'contribution_receipt_amount': 'float',
        'contribution_receipt_date': 'date',
        'contributor_aggregate_ytd': 'float',
        'contributor_city': 'str',
        'contributor_employer': 'str',
        'contributor_first_name': 'str',
        'contributor_last_name': 'str',
        'contributor_middle_name': 'str',
        'contributor_name': 'str',
        'contributor_occupation': 'str',
        'contributor_prefix': 'str',
        'contributor_state': 'str',
        'contributor_suffix': 'str',
        'contributor_zip': 'str',
        'csv_url': 'str',
        'cycle': 'int',
        'entity_type': 'str',
        'fec_election_type_desc': 'str',
        'fec_url': 'str',
        'file_number': 'int',
        'filing': 'EFilings',
        'image_number': 'str',
        'line_number': 'str',
        'load_timestamp': 'datetime',
        'memo_code': 'str',
        'memo_text': 'str',
        'pdf_url': 'str',
        'pgo': 'str',
        'related_line_number': 'int',
        'report_type': 'str',
        'transaction_id': 'str'
    }

    attribute_map = {
        'amendment_indicator': 'amendment_indicator',
        'back_reference_schedule_name': 'back_reference_schedule_name',
        'back_reference_transaction_id': 'back_reference_transaction_id',
        'beginning_image_number': 'beginning_image_number',
        'committee': 'committee',
        'committee_id': 'committee_id',
        'conduit_committee_city': 'conduit_committee_city',
        'conduit_committee_id': 'conduit_committee_id',
        'conduit_committee_name': 'conduit_committee_name',
        'conduit_committee_state': 'conduit_committee_state',
        'conduit_committee_street1': 'conduit_committee_street1',
        'conduit_committee_street2': 'conduit_committee_street2',
        'conduit_committee_zip': 'conduit_committee_zip',
        'contribution_receipt_amount': 'contribution_receipt_amount',
        'contribution_receipt_date': 'contribution_receipt_date',
        'contributor_aggregate_ytd': 'contributor_aggregate_ytd',
        'contributor_city': 'contributor_city',
        'contributor_employer': 'contributor_employer',
        'contributor_first_name': 'contributor_first_name',
        'contributor_last_name': 'contributor_last_name',
        'contributor_middle_name': 'contributor_middle_name',
        'contributor_name': 'contributor_name',
        'contributor_occupation': 'contributor_occupation',
        'contributor_prefix': 'contributor_prefix',
        'contributor_state': 'contributor_state',
        'contributor_suffix': 'contributor_suffix',
        'contributor_zip': 'contributor_zip',
        'csv_url': 'csv_url',
        'cycle': 'cycle',
        'entity_type': 'entity_type',
        'fec_election_type_desc': 'fec_election_type_desc',
        'fec_url': 'fec_url',
        'file_number': 'file_number',
        'filing': 'filing',
        'image_number': 'image_number',
        'line_number': 'line_number',
        'load_timestamp': 'load_timestamp',
        'memo_code': 'memo_code',
        'memo_text': 'memo_text',
        'pdf_url': 'pdf_url',
        'pgo': 'pgo',
        'related_line_number': 'related_line_number',
        'report_type': 'report_type',
        'transaction_id': 'transaction_id'
    }

    def __init__(self, amendment_indicator=None, back_reference_schedule_name=None, back_reference_transaction_id=None, beginning_image_number=None, committee=None, committee_id=None, conduit_committee_city=None, conduit_committee_id=None, conduit_committee_name=None, conduit_committee_state=None, conduit_committee_street1=None, conduit_committee_street2=None, conduit_committee_zip=None, contribution_receipt_amount=None, contribution_receipt_date=None, contributor_aggregate_ytd=None, contributor_city=None, contributor_employer=None, contributor_first_name=None, contributor_last_name=None, contributor_middle_name=None, contributor_name=None, contributor_occupation=None, contributor_prefix=None, contributor_state=None, contributor_suffix=None, contributor_zip=None, csv_url=None, cycle=None, entity_type=None, fec_election_type_desc=None, fec_url=None, file_number=None, filing=None, image_number=None, line_number=None, load_timestamp=None, memo_code=None, memo_text=None, pdf_url=None, pgo=None, related_line_number=None, report_type=None, transaction_id=None, local_vars_configuration=None):  # noqa: E501
        """ScheduleAEfile - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._amendment_indicator = None
        self._back_reference_schedule_name = None
        self._back_reference_transaction_id = None
        self._beginning_image_number = None
        self._committee = None
        self._committee_id = None
        self._conduit_committee_city = None
        self._conduit_committee_id = None
        self._conduit_committee_name = None
        self._conduit_committee_state = None
        self._conduit_committee_street1 = None
        self._conduit_committee_street2 = None
        self._conduit_committee_zip = None
        self._contribution_receipt_amount = None
        self._contribution_receipt_date = None
        self._contributor_aggregate_ytd = None
        self._contributor_city = None
        self._contributor_employer = None
        self._contributor_first_name = None
        self._contributor_last_name = None
        self._contributor_middle_name = None
        self._contributor_name = None
        self._contributor_occupation = None
        self._contributor_prefix = None
        self._contributor_state = None
        self._contributor_suffix = None
        self._contributor_zip = None
        self._csv_url = None
        self._cycle = None
        self._entity_type = None
        self._fec_election_type_desc = None
        self._fec_url = None
        self._file_number = None
        self._filing = None
        self._image_number = None
        self._line_number = None
        self._load_timestamp = None
        self._memo_code = None
        self._memo_text = None
        self._pdf_url = None
        self._pgo = None
        self._related_line_number = None
        self._report_type = None
        self._transaction_id = None
        self.discriminator = None

        self.amendment_indicator = amendment_indicator
        self.back_reference_schedule_name = back_reference_schedule_name
        self.back_reference_transaction_id = back_reference_transaction_id
        if beginning_image_number is not None:
            self.beginning_image_number = beginning_image_number
        if committee is not None:
            self.committee = committee
        self.committee_id = committee_id
        self.conduit_committee_city = conduit_committee_city
        self.conduit_committee_id = conduit_committee_id
        self.conduit_committee_name = conduit_committee_name
        self.conduit_committee_state = conduit_committee_state
        self.conduit_committee_street1 = conduit_committee_street1
        self.conduit_committee_street2 = conduit_committee_street2
        self.conduit_committee_zip = conduit_committee_zip
        self.contribution_receipt_amount = contribution_receipt_amount
        self.contribution_receipt_date = contribution_receipt_date
        self.contributor_aggregate_ytd = contributor_aggregate_ytd
        self.contributor_city = contributor_city
        self.contributor_employer = contributor_employer
        self.contributor_first_name = contributor_first_name
        self.contributor_last_name = contributor_last_name
        self.contributor_middle_name = contributor_middle_name
        if contributor_name is not None:
            self.contributor_name = contributor_name
        self.contributor_occupation = contributor_occupation
        self.contributor_prefix = contributor_prefix
        self.contributor_state = contributor_state
        self.contributor_suffix = contributor_suffix
        self.contributor_zip = contributor_zip
        if csv_url is not None:
            self.csv_url = csv_url
        if cycle is not None:
            self.cycle = cycle
        self.entity_type = entity_type
        if fec_election_type_desc is not None:
            self.fec_election_type_desc = fec_election_type_desc
        if fec_url is not None:
            self.fec_url = fec_url
        self.file_number = file_number
        if filing is not None:
            self.filing = filing
        self.image_number = image_number
        self.line_number = line_number
        self.load_timestamp = load_timestamp
        self.memo_code = memo_code
        self.memo_text = memo_text
        if pdf_url is not None:
            self.pdf_url = pdf_url
        self.pgo = pgo
        self.related_line_number = related_line_number
        if report_type is not None:
            self.report_type = report_type
        self.transaction_id = transaction_id

    @property
    def amendment_indicator(self):
        """Gets the amendment_indicator of this ScheduleAEfile.  # noqa: E501


        :return: The amendment_indicator of this ScheduleAEfile.  # noqa: E501
        :rtype: str
        """
        return self._amendment_indicator

    @amendment_indicator.setter
    def amendment_indicator(self, amendment_indicator):
        """Sets the amendment_indicator of this ScheduleAEfile.


        :param amendment_indicator: The amendment_indicator of this ScheduleAEfile.  # noqa: E501
        :type: str
        """

        self._amendment_indicator = amendment_indicator

    @property
    def back_reference_schedule_name(self):
        """Gets the back_reference_schedule_name of this ScheduleAEfile.  # noqa: E501


        :return: The back_reference_schedule_name of this ScheduleAEfile.  # noqa: E501
        :rtype: str
        """
        return self._back_reference_schedule_name

    @back_reference_schedule_name.setter
    def back_reference_schedule_name(self, back_reference_schedule_name):
        """Sets the back_reference_schedule_name of this ScheduleAEfile.


        :param back_reference_schedule_name: The back_reference_schedule_name of this ScheduleAEfile.  # noqa: E501
        :type: str
        """

        self._back_reference_schedule_name = back_reference_schedule_name

    @property
    def back_reference_transaction_id(self):
        """Gets the back_reference_transaction_id of this ScheduleAEfile.  # noqa: E501


        :return: The back_reference_transaction_id of this ScheduleAEfile.  # noqa: E501
        :rtype: str
        """
        return self._back_reference_transaction_id

    @back_reference_transaction_id.setter
    def back_reference_transaction_id(self, back_reference_transaction_id):
        """Sets the back_reference_transaction_id of this ScheduleAEfile.


        :param back_reference_transaction_id: The back_reference_transaction_id of this ScheduleAEfile.  # noqa: E501
        :type: str
        """

        self._back_reference_transaction_id = back_reference_transaction_id

    @property
    def beginning_image_number(self):
        """Gets the beginning_image_number of this ScheduleAEfile.  # noqa: E501


        :return: The beginning_image_number of this ScheduleAEfile.  # noqa: E501
        :rtype: str
        """
        return self._beginning_image_number

    @beginning_image_number.setter
    def beginning_image_number(self, beginning_image_number):
        """Sets the beginning_image_number of this ScheduleAEfile.


        :param beginning_image_number: The beginning_image_number of this ScheduleAEfile.  # noqa: E501
        :type: str
        """

        self._beginning_image_number = beginning_image_number

    @property
    def committee(self):
        """Gets the committee of this ScheduleAEfile.  # noqa: E501


        :return: The committee of this ScheduleAEfile.  # noqa: E501
        :rtype: CommitteeHistory
        """
        return self._committee

    @committee.setter
    def committee(self, committee):
        """Sets the committee of this ScheduleAEfile.


        :param committee: The committee of this ScheduleAEfile.  # noqa: E501
        :type: CommitteeHistory
        """

        self._committee = committee

    @property
    def committee_id(self):
        """Gets the committee_id of this ScheduleAEfile.  # noqa: E501

         A unique identifier assigned to each committee or filer registered with the FEC. In general committee id's begin with the letter C which is followed by eight digits.   # noqa: E501

        :return: The committee_id of this ScheduleAEfile.  # noqa: E501
        :rtype: str
        """
        return self._committee_id

    @committee_id.setter
    def committee_id(self, committee_id):
        """Sets the committee_id of this ScheduleAEfile.

         A unique identifier assigned to each committee or filer registered with the FEC. In general committee id's begin with the letter C which is followed by eight digits.   # noqa: E501

        :param committee_id: The committee_id of this ScheduleAEfile.  # noqa: E501
        :type: str
        """

        self._committee_id = committee_id

    @property
    def conduit_committee_city(self):
        """Gets the conduit_committee_city of this ScheduleAEfile.  # noqa: E501


        :return: The conduit_committee_city of this ScheduleAEfile.  # noqa: E501
        :rtype: str
        """
        return self._conduit_committee_city

    @conduit_committee_city.setter
    def conduit_committee_city(self, conduit_committee_city):
        """Sets the conduit_committee_city of this ScheduleAEfile.


        :param conduit_committee_city: The conduit_committee_city of this ScheduleAEfile.  # noqa: E501
        :type: str
        """

        self._conduit_committee_city = conduit_committee_city

    @property
    def conduit_committee_id(self):
        """Gets the conduit_committee_id of this ScheduleAEfile.  # noqa: E501


        :return: The conduit_committee_id of this ScheduleAEfile.  # noqa: E501
        :rtype: str
        """
        return self._conduit_committee_id

    @conduit_committee_id.setter
    def conduit_committee_id(self, conduit_committee_id):
        """Sets the conduit_committee_id of this ScheduleAEfile.


        :param conduit_committee_id: The conduit_committee_id of this ScheduleAEfile.  # noqa: E501
        :type: str
        """

        self._conduit_committee_id = conduit_committee_id

    @property
    def conduit_committee_name(self):
        """Gets the conduit_committee_name of this ScheduleAEfile.  # noqa: E501


        :return: The conduit_committee_name of this ScheduleAEfile.  # noqa: E501
        :rtype: str
        """
        return self._conduit_committee_name

    @conduit_committee_name.setter
    def conduit_committee_name(self, conduit_committee_name):
        """Sets the conduit_committee_name of this ScheduleAEfile.


        :param conduit_committee_name: The conduit_committee_name of this ScheduleAEfile.  # noqa: E501
        :type: str
        """

        self._conduit_committee_name = conduit_committee_name

    @property
    def conduit_committee_state(self):
        """Gets the conduit_committee_state of this ScheduleAEfile.  # noqa: E501


        :return: The conduit_committee_state of this ScheduleAEfile.  # noqa: E501
        :rtype: str
        """
        return self._conduit_committee_state

    @conduit_committee_state.setter
    def conduit_committee_state(self, conduit_committee_state):
        """Sets the conduit_committee_state of this ScheduleAEfile.


        :param conduit_committee_state: The conduit_committee_state of this ScheduleAEfile.  # noqa: E501
        :type: str
        """

        self._conduit_committee_state = conduit_committee_state

    @property
    def conduit_committee_street1(self):
        """Gets the conduit_committee_street1 of this ScheduleAEfile.  # noqa: E501


        :return: The conduit_committee_street1 of this ScheduleAEfile.  # noqa: E501
        :rtype: str
        """
        return self._conduit_committee_street1

    @conduit_committee_street1.setter
    def conduit_committee_street1(self, conduit_committee_street1):
        """Sets the conduit_committee_street1 of this ScheduleAEfile.


        :param conduit_committee_street1: The conduit_committee_street1 of this ScheduleAEfile.  # noqa: E501
        :type: str
        """

        self._conduit_committee_street1 = conduit_committee_street1

    @property
    def conduit_committee_street2(self):
        """Gets the conduit_committee_street2 of this ScheduleAEfile.  # noqa: E501


        :return: The conduit_committee_street2 of this ScheduleAEfile.  # noqa: E501
        :rtype: str
        """
        return self._conduit_committee_street2

    @conduit_committee_street2.setter
    def conduit_committee_street2(self, conduit_committee_street2):
        """Sets the conduit_committee_street2 of this ScheduleAEfile.


        :param conduit_committee_street2: The conduit_committee_street2 of this ScheduleAEfile.  # noqa: E501
        :type: str
        """

        self._conduit_committee_street2 = conduit_committee_street2

    @property
    def conduit_committee_zip(self):
        """Gets the conduit_committee_zip of this ScheduleAEfile.  # noqa: E501


        :return: The conduit_committee_zip of this ScheduleAEfile.  # noqa: E501
        :rtype: int
        """
        return self._conduit_committee_zip

    @conduit_committee_zip.setter
    def conduit_committee_zip(self, conduit_committee_zip):
        """Sets the conduit_committee_zip of this ScheduleAEfile.


        :param conduit_committee_zip: The conduit_committee_zip of this ScheduleAEfile.  # noqa: E501
        :type: int
        """

        self._conduit_committee_zip = conduit_committee_zip

    @property
    def contribution_receipt_amount(self):
        """Gets the contribution_receipt_amount of this ScheduleAEfile.  # noqa: E501


        :return: The contribution_receipt_amount of this ScheduleAEfile.  # noqa: E501
        :rtype: float
        """
        return self._contribution_receipt_amount

    @contribution_receipt_amount.setter
    def contribution_receipt_amount(self, contribution_receipt_amount):
        """Sets the contribution_receipt_amount of this ScheduleAEfile.


        :param contribution_receipt_amount: The contribution_receipt_amount of this ScheduleAEfile.  # noqa: E501
        :type: float
        """

        self._contribution_receipt_amount = contribution_receipt_amount

    @property
    def contribution_receipt_date(self):
        """Gets the contribution_receipt_date of this ScheduleAEfile.  # noqa: E501


        :return: The contribution_receipt_date of this ScheduleAEfile.  # noqa: E501
        :rtype: date
        """
        return self._contribution_receipt_date

    @contribution_receipt_date.setter
    def contribution_receipt_date(self, contribution_receipt_date):
        """Sets the contribution_receipt_date of this ScheduleAEfile.


        :param contribution_receipt_date: The contribution_receipt_date of this ScheduleAEfile.  # noqa: E501
        :type: date
        """

        self._contribution_receipt_date = contribution_receipt_date

    @property
    def contributor_aggregate_ytd(self):
        """Gets the contributor_aggregate_ytd of this ScheduleAEfile.  # noqa: E501


        :return: The contributor_aggregate_ytd of this ScheduleAEfile.  # noqa: E501
        :rtype: float
        """
        return self._contributor_aggregate_ytd

    @contributor_aggregate_ytd.setter
    def contributor_aggregate_ytd(self, contributor_aggregate_ytd):
        """Sets the contributor_aggregate_ytd of this ScheduleAEfile.


        :param contributor_aggregate_ytd: The contributor_aggregate_ytd of this ScheduleAEfile.  # noqa: E501
        :type: float
        """

        self._contributor_aggregate_ytd = contributor_aggregate_ytd

    @property
    def contributor_city(self):
        """Gets the contributor_city of this ScheduleAEfile.  # noqa: E501

        City of contributor  # noqa: E501

        :return: The contributor_city of this ScheduleAEfile.  # noqa: E501
        :rtype: str
        """
        return self._contributor_city

    @contributor_city.setter
    def contributor_city(self, contributor_city):
        """Sets the contributor_city of this ScheduleAEfile.

        City of contributor  # noqa: E501

        :param contributor_city: The contributor_city of this ScheduleAEfile.  # noqa: E501
        :type: str
        """

        self._contributor_city = contributor_city

    @property
    def contributor_employer(self):
        """Gets the contributor_employer of this ScheduleAEfile.  # noqa: E501

        Employer of contributor, filers need to make an effort to gather this information  # noqa: E501

        :return: The contributor_employer of this ScheduleAEfile.  # noqa: E501
        :rtype: str
        """
        return self._contributor_employer

    @contributor_employer.setter
    def contributor_employer(self, contributor_employer):
        """Sets the contributor_employer of this ScheduleAEfile.

        Employer of contributor, filers need to make an effort to gather this information  # noqa: E501

        :param contributor_employer: The contributor_employer of this ScheduleAEfile.  # noqa: E501
        :type: str
        """

        self._contributor_employer = contributor_employer

    @property
    def contributor_first_name(self):
        """Gets the contributor_first_name of this ScheduleAEfile.  # noqa: E501


        :return: The contributor_first_name of this ScheduleAEfile.  # noqa: E501
        :rtype: str
        """
        return self._contributor_first_name

    @contributor_first_name.setter
    def contributor_first_name(self, contributor_first_name):
        """Sets the contributor_first_name of this ScheduleAEfile.


        :param contributor_first_name: The contributor_first_name of this ScheduleAEfile.  # noqa: E501
        :type: str
        """

        self._contributor_first_name = contributor_first_name

    @property
    def contributor_last_name(self):
        """Gets the contributor_last_name of this ScheduleAEfile.  # noqa: E501


        :return: The contributor_last_name of this ScheduleAEfile.  # noqa: E501
        :rtype: str
        """
        return self._contributor_last_name

    @contributor_last_name.setter
    def contributor_last_name(self, contributor_last_name):
        """Sets the contributor_last_name of this ScheduleAEfile.


        :param contributor_last_name: The contributor_last_name of this ScheduleAEfile.  # noqa: E501
        :type: str
        """

        self._contributor_last_name = contributor_last_name

    @property
    def contributor_middle_name(self):
        """Gets the contributor_middle_name of this ScheduleAEfile.  # noqa: E501


        :return: The contributor_middle_name of this ScheduleAEfile.  # noqa: E501
        :rtype: str
        """
        return self._contributor_middle_name

    @contributor_middle_name.setter
    def contributor_middle_name(self, contributor_middle_name):
        """Sets the contributor_middle_name of this ScheduleAEfile.


        :param contributor_middle_name: The contributor_middle_name of this ScheduleAEfile.  # noqa: E501
        :type: str
        """

        self._contributor_middle_name = contributor_middle_name

    @property
    def contributor_name(self):
        """Gets the contributor_name of this ScheduleAEfile.  # noqa: E501


        :return: The contributor_name of this ScheduleAEfile.  # noqa: E501
        :rtype: str
        """
        return self._contributor_name

    @contributor_name.setter
    def contributor_name(self, contributor_name):
        """Sets the contributor_name of this ScheduleAEfile.


        :param contributor_name: The contributor_name of this ScheduleAEfile.  # noqa: E501
        :type: str
        """

        self._contributor_name = contributor_name

    @property
    def contributor_occupation(self):
        """Gets the contributor_occupation of this ScheduleAEfile.  # noqa: E501

        Occupation of contributor, filers need to make an effort to gather this information  # noqa: E501

        :return: The contributor_occupation of this ScheduleAEfile.  # noqa: E501
        :rtype: str
        """
        return self._contributor_occupation

    @contributor_occupation.setter
    def contributor_occupation(self, contributor_occupation):
        """Sets the contributor_occupation of this ScheduleAEfile.

        Occupation of contributor, filers need to make an effort to gather this information  # noqa: E501

        :param contributor_occupation: The contributor_occupation of this ScheduleAEfile.  # noqa: E501
        :type: str
        """

        self._contributor_occupation = contributor_occupation

    @property
    def contributor_prefix(self):
        """Gets the contributor_prefix of this ScheduleAEfile.  # noqa: E501


        :return: The contributor_prefix of this ScheduleAEfile.  # noqa: E501
        :rtype: str
        """
        return self._contributor_prefix

    @contributor_prefix.setter
    def contributor_prefix(self, contributor_prefix):
        """Sets the contributor_prefix of this ScheduleAEfile.


        :param contributor_prefix: The contributor_prefix of this ScheduleAEfile.  # noqa: E501
        :type: str
        """

        self._contributor_prefix = contributor_prefix

    @property
    def contributor_state(self):
        """Gets the contributor_state of this ScheduleAEfile.  # noqa: E501

        State of contributor  # noqa: E501

        :return: The contributor_state of this ScheduleAEfile.  # noqa: E501
        :rtype: str
        """
        return self._contributor_state

    @contributor_state.setter
    def contributor_state(self, contributor_state):
        """Sets the contributor_state of this ScheduleAEfile.

        State of contributor  # noqa: E501

        :param contributor_state: The contributor_state of this ScheduleAEfile.  # noqa: E501
        :type: str
        """

        self._contributor_state = contributor_state

    @property
    def contributor_suffix(self):
        """Gets the contributor_suffix of this ScheduleAEfile.  # noqa: E501


        :return: The contributor_suffix of this ScheduleAEfile.  # noqa: E501
        :rtype: str
        """
        return self._contributor_suffix

    @contributor_suffix.setter
    def contributor_suffix(self, contributor_suffix):
        """Sets the contributor_suffix of this ScheduleAEfile.


        :param contributor_suffix: The contributor_suffix of this ScheduleAEfile.  # noqa: E501
        :type: str
        """

        self._contributor_suffix = contributor_suffix

    @property
    def contributor_zip(self):
        """Gets the contributor_zip of this ScheduleAEfile.  # noqa: E501

        Zip code of contributor  # noqa: E501

        :return: The contributor_zip of this ScheduleAEfile.  # noqa: E501
        :rtype: str
        """
        return self._contributor_zip

    @contributor_zip.setter
    def contributor_zip(self, contributor_zip):
        """Sets the contributor_zip of this ScheduleAEfile.

        Zip code of contributor  # noqa: E501

        :param contributor_zip: The contributor_zip of this ScheduleAEfile.  # noqa: E501
        :type: str
        """

        self._contributor_zip = contributor_zip

    @property
    def csv_url(self):
        """Gets the csv_url of this ScheduleAEfile.  # noqa: E501


        :return: The csv_url of this ScheduleAEfile.  # noqa: E501
        :rtype: str
        """
        return self._csv_url

    @csv_url.setter
    def csv_url(self, csv_url):
        """Sets the csv_url of this ScheduleAEfile.


        :param csv_url: The csv_url of this ScheduleAEfile.  # noqa: E501
        :type: str
        """

        self._csv_url = csv_url

    @property
    def cycle(self):
        """Gets the cycle of this ScheduleAEfile.  # noqa: E501


        :return: The cycle of this ScheduleAEfile.  # noqa: E501
        :rtype: int
        """
        return self._cycle

    @cycle.setter
    def cycle(self, cycle):
        """Sets the cycle of this ScheduleAEfile.


        :param cycle: The cycle of this ScheduleAEfile.  # noqa: E501
        :type: int
        """

        self._cycle = cycle

    @property
    def entity_type(self):
        """Gets the entity_type of this ScheduleAEfile.  # noqa: E501


        :return: The entity_type of this ScheduleAEfile.  # noqa: E501
        :rtype: str
        """
        return self._entity_type

    @entity_type.setter
    def entity_type(self, entity_type):
        """Sets the entity_type of this ScheduleAEfile.


        :param entity_type: The entity_type of this ScheduleAEfile.  # noqa: E501
        :type: str
        """

        self._entity_type = entity_type

    @property
    def fec_election_type_desc(self):
        """Gets the fec_election_type_desc of this ScheduleAEfile.  # noqa: E501


        :return: The fec_election_type_desc of this ScheduleAEfile.  # noqa: E501
        :rtype: str
        """
        return self._fec_election_type_desc

    @fec_election_type_desc.setter
    def fec_election_type_desc(self, fec_election_type_desc):
        """Sets the fec_election_type_desc of this ScheduleAEfile.


        :param fec_election_type_desc: The fec_election_type_desc of this ScheduleAEfile.  # noqa: E501
        :type: str
        """

        self._fec_election_type_desc = fec_election_type_desc

    @property
    def fec_url(self):
        """Gets the fec_url of this ScheduleAEfile.  # noqa: E501


        :return: The fec_url of this ScheduleAEfile.  # noqa: E501
        :rtype: str
        """
        return self._fec_url

    @fec_url.setter
    def fec_url(self, fec_url):
        """Sets the fec_url of this ScheduleAEfile.


        :param fec_url: The fec_url of this ScheduleAEfile.  # noqa: E501
        :type: str
        """

        self._fec_url = fec_url

    @property
    def file_number(self):
        """Gets the file_number of this ScheduleAEfile.  # noqa: E501


        :return: The file_number of this ScheduleAEfile.  # noqa: E501
        :rtype: int
        """
        return self._file_number

    @file_number.setter
    def file_number(self, file_number):
        """Sets the file_number of this ScheduleAEfile.


        :param file_number: The file_number of this ScheduleAEfile.  # noqa: E501
        :type: int
        """
        if self.local_vars_configuration.client_side_validation and file_number is None:  # noqa: E501
            raise ValueError('Invalid value for `file_number`, must not be `None`')  # noqa: E501

        self._file_number = file_number

    @property
    def filing(self):
        """Gets the filing of this ScheduleAEfile.  # noqa: E501


        :return: The filing of this ScheduleAEfile.  # noqa: E501
        :rtype: EFilings
        """
        return self._filing

    @filing.setter
    def filing(self, filing):
        """Sets the filing of this ScheduleAEfile.


        :param filing: The filing of this ScheduleAEfile.  # noqa: E501
        :type: EFilings
        """

        self._filing = filing

    @property
    def image_number(self):
        """Gets the image_number of this ScheduleAEfile.  # noqa: E501

         An unique identifier for each page where the electronic or paper filing is reported.   # noqa: E501

        :return: The image_number of this ScheduleAEfile.  # noqa: E501
        :rtype: str
        """
        return self._image_number

    @image_number.setter
    def image_number(self, image_number):
        """Sets the image_number of this ScheduleAEfile.

         An unique identifier for each page where the electronic or paper filing is reported.   # noqa: E501

        :param image_number: The image_number of this ScheduleAEfile.  # noqa: E501
        :type: str
        """

        self._image_number = image_number

    @property
    def line_number(self):
        """Gets the line_number of this ScheduleAEfile.  # noqa: E501


        :return: The line_number of this ScheduleAEfile.  # noqa: E501
        :rtype: str
        """
        return self._line_number

    @line_number.setter
    def line_number(self, line_number):
        """Sets the line_number of this ScheduleAEfile.


        :param line_number: The line_number of this ScheduleAEfile.  # noqa: E501
        :type: str
        """

        self._line_number = line_number

    @property
    def load_timestamp(self):
        """Gets the load_timestamp of this ScheduleAEfile.  # noqa: E501


        :return: The load_timestamp of this ScheduleAEfile.  # noqa: E501
        :rtype: datetime
        """
        return self._load_timestamp

    @load_timestamp.setter
    def load_timestamp(self, load_timestamp):
        """Sets the load_timestamp of this ScheduleAEfile.


        :param load_timestamp: The load_timestamp of this ScheduleAEfile.  # noqa: E501
        :type: datetime
        """

        self._load_timestamp = load_timestamp

    @property
    def memo_code(self):
        """Gets the memo_code of this ScheduleAEfile.  # noqa: E501


        :return: The memo_code of this ScheduleAEfile.  # noqa: E501
        :rtype: str
        """
        return self._memo_code

    @memo_code.setter
    def memo_code(self, memo_code):
        """Sets the memo_code of this ScheduleAEfile.


        :param memo_code: The memo_code of this ScheduleAEfile.  # noqa: E501
        :type: str
        """

        self._memo_code = memo_code

    @property
    def memo_text(self):
        """Gets the memo_text of this ScheduleAEfile.  # noqa: E501


        :return: The memo_text of this ScheduleAEfile.  # noqa: E501
        :rtype: str
        """
        return self._memo_text

    @memo_text.setter
    def memo_text(self, memo_text):
        """Sets the memo_text of this ScheduleAEfile.


        :param memo_text: The memo_text of this ScheduleAEfile.  # noqa: E501
        :type: str
        """

        self._memo_text = memo_text

    @property
    def pdf_url(self):
        """Gets the pdf_url of this ScheduleAEfile.  # noqa: E501


        :return: The pdf_url of this ScheduleAEfile.  # noqa: E501
        :rtype: str
        """
        return self._pdf_url

    @pdf_url.setter
    def pdf_url(self, pdf_url):
        """Sets the pdf_url of this ScheduleAEfile.


        :param pdf_url: The pdf_url of this ScheduleAEfile.  # noqa: E501
        :type: str
        """

        self._pdf_url = pdf_url

    @property
    def pgo(self):
        """Gets the pgo of this ScheduleAEfile.  # noqa: E501


        :return: The pgo of this ScheduleAEfile.  # noqa: E501
        :rtype: str
        """
        return self._pgo

    @pgo.setter
    def pgo(self, pgo):
        """Sets the pgo of this ScheduleAEfile.


        :param pgo: The pgo of this ScheduleAEfile.  # noqa: E501
        :type: str
        """

        self._pgo = pgo

    @property
    def related_line_number(self):
        """Gets the related_line_number of this ScheduleAEfile.  # noqa: E501


        :return: The related_line_number of this ScheduleAEfile.  # noqa: E501
        :rtype: int
        """
        return self._related_line_number

    @related_line_number.setter
    def related_line_number(self, related_line_number):
        """Sets the related_line_number of this ScheduleAEfile.


        :param related_line_number: The related_line_number of this ScheduleAEfile.  # noqa: E501
        :type: int
        """
        if self.local_vars_configuration.client_side_validation and related_line_number is None:  # noqa: E501
            raise ValueError('Invalid value for `related_line_number`, must not be `None`')  # noqa: E501

        self._related_line_number = related_line_number

    @property
    def report_type(self):
        """Gets the report_type of this ScheduleAEfile.  # noqa: E501


        :return: The report_type of this ScheduleAEfile.  # noqa: E501
        :rtype: str
        """
        return self._report_type

    @report_type.setter
    def report_type(self, report_type):
        """Sets the report_type of this ScheduleAEfile.


        :param report_type: The report_type of this ScheduleAEfile.  # noqa: E501
        :type: str
        """

        self._report_type = report_type

    @property
    def transaction_id(self):
        """Gets the transaction_id of this ScheduleAEfile.  # noqa: E501


        :return: The transaction_id of this ScheduleAEfile.  # noqa: E501
        :rtype: str
        """
        return self._transaction_id

    @transaction_id.setter
    def transaction_id(self, transaction_id):
        """Sets the transaction_id of this ScheduleAEfile.


        :param transaction_id: The transaction_id of this ScheduleAEfile.  # noqa: E501
        :type: str
        """

        self._transaction_id = transaction_id

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, 'to_dict') else x,
                    value
                ))
            elif hasattr(value, 'to_dict'):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], 'to_dict') else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ScheduleAEfile):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, ScheduleAEfile):
            return True

        return self.to_dict() != other.to_dict()
