# coding: utf-8

"""
    OpenFEC

    This API allows you to explore the way candidates and committees fund their campaigns.    The FEC API is a RESTful web service supporting full-text and field-specific searches on FEC data. [Bulk downloads](https://www.fec.gov/data/advanced/?tab=bulk-data) are available on the current site. Information is tied to the underlying forms by file ID and image ID. Data is updated nightly.    There is a lot of data, but a good place to start is to use search to find interesting candidates and committees. Then, you can use their IDs to find report or line item details with the other endpoints. If you are interested in individual donors, check out contributor information in schedule_a.    Get an [API key here](https://api.data.gov/signup/). That will enable you to place up to 1,000 calls an hour. Each call is limited to 100 results per page. You can email questions, comments or a request to get a key for 120 calls per minute to [APIinfo@fec.gov](mailto:apiinfo@fec.gov). You can also ask questions and discuss the data in the [FEC data Google Group](https://groups.google.com/forum/#!forum/fec-data). API changes will also be added to this group in advance of the change.    The model definitions and schema are available at [/swagger](/swagger/). This is useful for making wrappers and exploring the data.    A few restrictions limit the way you can use FEC data. For example, you can’t use contributor lists for commercial purposes or to solicit donations. [Learn more here](https://www.fec.gov/updates/sale-or-use-contributor-information/).    [View our source code](https://github.com/fecgov/openFEC). We welcome issues and pull requests!  # noqa: E501

    The version of the OpenAPI document: 1.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from openfec_sdk.configuration import Configuration


class ScheduleB(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'amendment_indicator': 'str',
        'amendment_indicator_desc': 'str',
        'back_reference_schedule_id': 'str',
        'back_reference_transaction_id': 'str',
        'beneficiary_committee_name': 'str',
        'candidate_first_name': 'str',
        'candidate_id': 'str',
        'candidate_last_name': 'str',
        'candidate_middle_name': 'str',
        'candidate_name': 'str',
        'candidate_office': 'str',
        'candidate_office_description': 'str',
        'candidate_office_district': 'str',
        'candidate_office_state': 'str',
        'candidate_office_state_full': 'str',
        'candidate_prefix': 'str',
        'candidate_suffix': 'str',
        'category_code': 'str',
        'category_code_full': 'str',
        'comm_dt': 'date',
        'committee': 'CommitteeHistory',
        'committee_id': 'str',
        'conduit_committee_city': 'str',
        'conduit_committee_name': 'str',
        'conduit_committee_state': 'str',
        'conduit_committee_street1': 'str',
        'conduit_committee_street2': 'str',
        'conduit_committee_zip': 'int',
        'disbursement_amount': 'float',
        'disbursement_date': 'date',
        'disbursement_description': 'str',
        'disbursement_purpose_category': 'str',
        'disbursement_type': 'str',
        'disbursement_type_description': 'str',
        'election_type': 'str',
        'election_type_full': 'str',
        'entity_type': 'str',
        'entity_type_desc': 'str',
        'fec_election_type_desc': 'str',
        'fec_election_year': 'str',
        'file_number': 'int',
        'filing_form': 'str',
        'image_number': 'str',
        'line_number': 'str',
        'line_number_label': 'str',
        'link_id': 'int',
        'load_date': 'datetime',
        'memo_code': 'str',
        'memo_code_full': 'str',
        'memo_text': 'str',
        'memoed_subtotal': 'bool',
        'national_committee_nonfederal_account': 'str',
        'original_sub_id': 'str',
        'payee_employer': 'str',
        'payee_first_name': 'str',
        'payee_last_name': 'str',
        'payee_middle_name': 'str',
        'payee_occupation': 'str',
        'payee_prefix': 'str',
        'payee_suffix': 'str',
        'pdf_url': 'str',
        'recipient_city': 'str',
        'recipient_committee': 'CommitteeHistory',
        'recipient_committee_id': 'str',
        'recipient_name': 'str',
        'recipient_state': 'str',
        'recipient_zip': 'str',
        'ref_disp_excess_flg': 'str',
        'report_type': 'str',
        'report_year': 'int',
        'schedule_type': 'str',
        'schedule_type_full': 'str',
        'semi_annual_bundled_refund': 'float',
        'spender_committee_designation': 'str',
        'spender_committee_org_type': 'str',
        'spender_committee_type': 'str',
        'sub_id': 'str',
        'transaction_id': 'str',
        'two_year_transaction_period': 'int',
        'unused_recipient_committee_id': 'str'
    }

    attribute_map = {
        'amendment_indicator': 'amendment_indicator',
        'amendment_indicator_desc': 'amendment_indicator_desc',
        'back_reference_schedule_id': 'back_reference_schedule_id',
        'back_reference_transaction_id': 'back_reference_transaction_id',
        'beneficiary_committee_name': 'beneficiary_committee_name',
        'candidate_first_name': 'candidate_first_name',
        'candidate_id': 'candidate_id',
        'candidate_last_name': 'candidate_last_name',
        'candidate_middle_name': 'candidate_middle_name',
        'candidate_name': 'candidate_name',
        'candidate_office': 'candidate_office',
        'candidate_office_description': 'candidate_office_description',
        'candidate_office_district': 'candidate_office_district',
        'candidate_office_state': 'candidate_office_state',
        'candidate_office_state_full': 'candidate_office_state_full',
        'candidate_prefix': 'candidate_prefix',
        'candidate_suffix': 'candidate_suffix',
        'category_code': 'category_code',
        'category_code_full': 'category_code_full',
        'comm_dt': 'comm_dt',
        'committee': 'committee',
        'committee_id': 'committee_id',
        'conduit_committee_city': 'conduit_committee_city',
        'conduit_committee_name': 'conduit_committee_name',
        'conduit_committee_state': 'conduit_committee_state',
        'conduit_committee_street1': 'conduit_committee_street1',
        'conduit_committee_street2': 'conduit_committee_street2',
        'conduit_committee_zip': 'conduit_committee_zip',
        'disbursement_amount': 'disbursement_amount',
        'disbursement_date': 'disbursement_date',
        'disbursement_description': 'disbursement_description',
        'disbursement_purpose_category': 'disbursement_purpose_category',
        'disbursement_type': 'disbursement_type',
        'disbursement_type_description': 'disbursement_type_description',
        'election_type': 'election_type',
        'election_type_full': 'election_type_full',
        'entity_type': 'entity_type',
        'entity_type_desc': 'entity_type_desc',
        'fec_election_type_desc': 'fec_election_type_desc',
        'fec_election_year': 'fec_election_year',
        'file_number': 'file_number',
        'filing_form': 'filing_form',
        'image_number': 'image_number',
        'line_number': 'line_number',
        'line_number_label': 'line_number_label',
        'link_id': 'link_id',
        'load_date': 'load_date',
        'memo_code': 'memo_code',
        'memo_code_full': 'memo_code_full',
        'memo_text': 'memo_text',
        'memoed_subtotal': 'memoed_subtotal',
        'national_committee_nonfederal_account': 'national_committee_nonfederal_account',
        'original_sub_id': 'original_sub_id',
        'payee_employer': 'payee_employer',
        'payee_first_name': 'payee_first_name',
        'payee_last_name': 'payee_last_name',
        'payee_middle_name': 'payee_middle_name',
        'payee_occupation': 'payee_occupation',
        'payee_prefix': 'payee_prefix',
        'payee_suffix': 'payee_suffix',
        'pdf_url': 'pdf_url',
        'recipient_city': 'recipient_city',
        'recipient_committee': 'recipient_committee',
        'recipient_committee_id': 'recipient_committee_id',
        'recipient_name': 'recipient_name',
        'recipient_state': 'recipient_state',
        'recipient_zip': 'recipient_zip',
        'ref_disp_excess_flg': 'ref_disp_excess_flg',
        'report_type': 'report_type',
        'report_year': 'report_year',
        'schedule_type': 'schedule_type',
        'schedule_type_full': 'schedule_type_full',
        'semi_annual_bundled_refund': 'semi_annual_bundled_refund',
        'spender_committee_designation': 'spender_committee_designation',
        'spender_committee_org_type': 'spender_committee_org_type',
        'spender_committee_type': 'spender_committee_type',
        'sub_id': 'sub_id',
        'transaction_id': 'transaction_id',
        'two_year_transaction_period': 'two_year_transaction_period',
        'unused_recipient_committee_id': 'unused_recipient_committee_id'
    }

    def __init__(self, amendment_indicator=None, amendment_indicator_desc=None, back_reference_schedule_id=None, back_reference_transaction_id=None, beneficiary_committee_name=None, candidate_first_name=None, candidate_id=None, candidate_last_name=None, candidate_middle_name=None, candidate_name=None, candidate_office=None, candidate_office_description=None, candidate_office_district=None, candidate_office_state=None, candidate_office_state_full=None, candidate_prefix=None, candidate_suffix=None, category_code=None, category_code_full=None, comm_dt=None, committee=None, committee_id=None, conduit_committee_city=None, conduit_committee_name=None, conduit_committee_state=None, conduit_committee_street1=None, conduit_committee_street2=None, conduit_committee_zip=None, disbursement_amount=None, disbursement_date=None, disbursement_description=None, disbursement_purpose_category=None, disbursement_type=None, disbursement_type_description=None, election_type=None, election_type_full=None, entity_type=None, entity_type_desc=None, fec_election_type_desc=None, fec_election_year=None, file_number=None, filing_form=None, image_number=None, line_number=None, line_number_label=None, link_id=None, load_date=None, memo_code=None, memo_code_full=None, memo_text=None, memoed_subtotal=None, national_committee_nonfederal_account=None, original_sub_id=None, payee_employer=None, payee_first_name=None, payee_last_name=None, payee_middle_name=None, payee_occupation=None, payee_prefix=None, payee_suffix=None, pdf_url=None, recipient_city=None, recipient_committee=None, recipient_committee_id=None, recipient_name=None, recipient_state=None, recipient_zip=None, ref_disp_excess_flg=None, report_type=None, report_year=None, schedule_type=None, schedule_type_full=None, semi_annual_bundled_refund=None, spender_committee_designation=None, spender_committee_org_type=None, spender_committee_type=None, sub_id=None, transaction_id=None, two_year_transaction_period=None, unused_recipient_committee_id=None, local_vars_configuration=None):  # noqa: E501
        """ScheduleB - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._amendment_indicator = None
        self._amendment_indicator_desc = None
        self._back_reference_schedule_id = None
        self._back_reference_transaction_id = None
        self._beneficiary_committee_name = None
        self._candidate_first_name = None
        self._candidate_id = None
        self._candidate_last_name = None
        self._candidate_middle_name = None
        self._candidate_name = None
        self._candidate_office = None
        self._candidate_office_description = None
        self._candidate_office_district = None
        self._candidate_office_state = None
        self._candidate_office_state_full = None
        self._candidate_prefix = None
        self._candidate_suffix = None
        self._category_code = None
        self._category_code_full = None
        self._comm_dt = None
        self._committee = None
        self._committee_id = None
        self._conduit_committee_city = None
        self._conduit_committee_name = None
        self._conduit_committee_state = None
        self._conduit_committee_street1 = None
        self._conduit_committee_street2 = None
        self._conduit_committee_zip = None
        self._disbursement_amount = None
        self._disbursement_date = None
        self._disbursement_description = None
        self._disbursement_purpose_category = None
        self._disbursement_type = None
        self._disbursement_type_description = None
        self._election_type = None
        self._election_type_full = None
        self._entity_type = None
        self._entity_type_desc = None
        self._fec_election_type_desc = None
        self._fec_election_year = None
        self._file_number = None
        self._filing_form = None
        self._image_number = None
        self._line_number = None
        self._line_number_label = None
        self._link_id = None
        self._load_date = None
        self._memo_code = None
        self._memo_code_full = None
        self._memo_text = None
        self._memoed_subtotal = None
        self._national_committee_nonfederal_account = None
        self._original_sub_id = None
        self._payee_employer = None
        self._payee_first_name = None
        self._payee_last_name = None
        self._payee_middle_name = None
        self._payee_occupation = None
        self._payee_prefix = None
        self._payee_suffix = None
        self._pdf_url = None
        self._recipient_city = None
        self._recipient_committee = None
        self._recipient_committee_id = None
        self._recipient_name = None
        self._recipient_state = None
        self._recipient_zip = None
        self._ref_disp_excess_flg = None
        self._report_type = None
        self._report_year = None
        self._schedule_type = None
        self._schedule_type_full = None
        self._semi_annual_bundled_refund = None
        self._spender_committee_designation = None
        self._spender_committee_org_type = None
        self._spender_committee_type = None
        self._sub_id = None
        self._transaction_id = None
        self._two_year_transaction_period = None
        self._unused_recipient_committee_id = None
        self.discriminator = None

        self.amendment_indicator = amendment_indicator
        self.amendment_indicator_desc = amendment_indicator_desc
        self.back_reference_schedule_id = back_reference_schedule_id
        self.back_reference_transaction_id = back_reference_transaction_id
        self.beneficiary_committee_name = beneficiary_committee_name
        self.candidate_first_name = candidate_first_name
        self.candidate_id = candidate_id
        self.candidate_last_name = candidate_last_name
        self.candidate_middle_name = candidate_middle_name
        self.candidate_name = candidate_name
        self.candidate_office = candidate_office
        self.candidate_office_description = candidate_office_description
        self.candidate_office_district = candidate_office_district
        self.candidate_office_state = candidate_office_state
        self.candidate_office_state_full = candidate_office_state_full
        self.candidate_prefix = candidate_prefix
        self.candidate_suffix = candidate_suffix
        self.category_code = category_code
        self.category_code_full = category_code_full
        self.comm_dt = comm_dt
        if committee is not None:
            self.committee = committee
        self.committee_id = committee_id
        self.conduit_committee_city = conduit_committee_city
        self.conduit_committee_name = conduit_committee_name
        self.conduit_committee_state = conduit_committee_state
        self.conduit_committee_street1 = conduit_committee_street1
        self.conduit_committee_street2 = conduit_committee_street2
        self.conduit_committee_zip = conduit_committee_zip
        self.disbursement_amount = disbursement_amount
        self.disbursement_date = disbursement_date
        self.disbursement_description = disbursement_description
        self.disbursement_purpose_category = disbursement_purpose_category
        self.disbursement_type = disbursement_type
        self.disbursement_type_description = disbursement_type_description
        self.election_type = election_type
        self.election_type_full = election_type_full
        self.entity_type = entity_type
        self.entity_type_desc = entity_type_desc
        self.fec_election_type_desc = fec_election_type_desc
        self.fec_election_year = fec_election_year
        self.file_number = file_number
        self.filing_form = filing_form
        if image_number is not None:
            self.image_number = image_number
        self.line_number = line_number
        self.line_number_label = line_number_label
        self.link_id = link_id
        self.load_date = load_date
        self.memo_code = memo_code
        self.memo_code_full = memo_code_full
        self.memo_text = memo_text
        if memoed_subtotal is not None:
            self.memoed_subtotal = memoed_subtotal
        self.national_committee_nonfederal_account = national_committee_nonfederal_account
        if original_sub_id is not None:
            self.original_sub_id = original_sub_id
        self.payee_employer = payee_employer
        self.payee_first_name = payee_first_name
        self.payee_last_name = payee_last_name
        self.payee_middle_name = payee_middle_name
        self.payee_occupation = payee_occupation
        self.payee_prefix = payee_prefix
        self.payee_suffix = payee_suffix
        self.pdf_url = pdf_url
        self.recipient_city = recipient_city
        if recipient_committee is not None:
            self.recipient_committee = recipient_committee
        self.recipient_committee_id = recipient_committee_id
        self.recipient_name = recipient_name
        self.recipient_state = recipient_state
        self.recipient_zip = recipient_zip
        self.ref_disp_excess_flg = ref_disp_excess_flg
        self.report_type = report_type
        self.report_year = report_year
        self.schedule_type = schedule_type
        self.schedule_type_full = schedule_type_full
        self.semi_annual_bundled_refund = semi_annual_bundled_refund
        self.spender_committee_designation = spender_committee_designation
        self.spender_committee_org_type = spender_committee_org_type
        self.spender_committee_type = spender_committee_type
        if sub_id is not None:
            self.sub_id = sub_id
        self.transaction_id = transaction_id
        self.two_year_transaction_period = two_year_transaction_period
        self.unused_recipient_committee_id = unused_recipient_committee_id

    @property
    def amendment_indicator(self):
        """Gets the amendment_indicator of this ScheduleB.  # noqa: E501


        :return: The amendment_indicator of this ScheduleB.  # noqa: E501
        :rtype: str
        """
        return self._amendment_indicator

    @amendment_indicator.setter
    def amendment_indicator(self, amendment_indicator):
        """Sets the amendment_indicator of this ScheduleB.


        :param amendment_indicator: The amendment_indicator of this ScheduleB.  # noqa: E501
        :type: str
        """

        self._amendment_indicator = amendment_indicator

    @property
    def amendment_indicator_desc(self):
        """Gets the amendment_indicator_desc of this ScheduleB.  # noqa: E501


        :return: The amendment_indicator_desc of this ScheduleB.  # noqa: E501
        :rtype: str
        """
        return self._amendment_indicator_desc

    @amendment_indicator_desc.setter
    def amendment_indicator_desc(self, amendment_indicator_desc):
        """Sets the amendment_indicator_desc of this ScheduleB.


        :param amendment_indicator_desc: The amendment_indicator_desc of this ScheduleB.  # noqa: E501
        :type: str
        """

        self._amendment_indicator_desc = amendment_indicator_desc

    @property
    def back_reference_schedule_id(self):
        """Gets the back_reference_schedule_id of this ScheduleB.  # noqa: E501


        :return: The back_reference_schedule_id of this ScheduleB.  # noqa: E501
        :rtype: str
        """
        return self._back_reference_schedule_id

    @back_reference_schedule_id.setter
    def back_reference_schedule_id(self, back_reference_schedule_id):
        """Sets the back_reference_schedule_id of this ScheduleB.


        :param back_reference_schedule_id: The back_reference_schedule_id of this ScheduleB.  # noqa: E501
        :type: str
        """

        self._back_reference_schedule_id = back_reference_schedule_id

    @property
    def back_reference_transaction_id(self):
        """Gets the back_reference_transaction_id of this ScheduleB.  # noqa: E501


        :return: The back_reference_transaction_id of this ScheduleB.  # noqa: E501
        :rtype: str
        """
        return self._back_reference_transaction_id

    @back_reference_transaction_id.setter
    def back_reference_transaction_id(self, back_reference_transaction_id):
        """Sets the back_reference_transaction_id of this ScheduleB.


        :param back_reference_transaction_id: The back_reference_transaction_id of this ScheduleB.  # noqa: E501
        :type: str
        """

        self._back_reference_transaction_id = back_reference_transaction_id

    @property
    def beneficiary_committee_name(self):
        """Gets the beneficiary_committee_name of this ScheduleB.  # noqa: E501


        :return: The beneficiary_committee_name of this ScheduleB.  # noqa: E501
        :rtype: str
        """
        return self._beneficiary_committee_name

    @beneficiary_committee_name.setter
    def beneficiary_committee_name(self, beneficiary_committee_name):
        """Sets the beneficiary_committee_name of this ScheduleB.


        :param beneficiary_committee_name: The beneficiary_committee_name of this ScheduleB.  # noqa: E501
        :type: str
        """

        self._beneficiary_committee_name = beneficiary_committee_name

    @property
    def candidate_first_name(self):
        """Gets the candidate_first_name of this ScheduleB.  # noqa: E501


        :return: The candidate_first_name of this ScheduleB.  # noqa: E501
        :rtype: str
        """
        return self._candidate_first_name

    @candidate_first_name.setter
    def candidate_first_name(self, candidate_first_name):
        """Sets the candidate_first_name of this ScheduleB.


        :param candidate_first_name: The candidate_first_name of this ScheduleB.  # noqa: E501
        :type: str
        """

        self._candidate_first_name = candidate_first_name

    @property
    def candidate_id(self):
        """Gets the candidate_id of this ScheduleB.  # noqa: E501

         A unique identifier assigned to each candidate registered with the FEC. If a person runs for several offices, that person will have separate candidate IDs for each office.   # noqa: E501

        :return: The candidate_id of this ScheduleB.  # noqa: E501
        :rtype: str
        """
        return self._candidate_id

    @candidate_id.setter
    def candidate_id(self, candidate_id):
        """Sets the candidate_id of this ScheduleB.

         A unique identifier assigned to each candidate registered with the FEC. If a person runs for several offices, that person will have separate candidate IDs for each office.   # noqa: E501

        :param candidate_id: The candidate_id of this ScheduleB.  # noqa: E501
        :type: str
        """

        self._candidate_id = candidate_id

    @property
    def candidate_last_name(self):
        """Gets the candidate_last_name of this ScheduleB.  # noqa: E501


        :return: The candidate_last_name of this ScheduleB.  # noqa: E501
        :rtype: str
        """
        return self._candidate_last_name

    @candidate_last_name.setter
    def candidate_last_name(self, candidate_last_name):
        """Sets the candidate_last_name of this ScheduleB.


        :param candidate_last_name: The candidate_last_name of this ScheduleB.  # noqa: E501
        :type: str
        """

        self._candidate_last_name = candidate_last_name

    @property
    def candidate_middle_name(self):
        """Gets the candidate_middle_name of this ScheduleB.  # noqa: E501


        :return: The candidate_middle_name of this ScheduleB.  # noqa: E501
        :rtype: str
        """
        return self._candidate_middle_name

    @candidate_middle_name.setter
    def candidate_middle_name(self, candidate_middle_name):
        """Sets the candidate_middle_name of this ScheduleB.


        :param candidate_middle_name: The candidate_middle_name of this ScheduleB.  # noqa: E501
        :type: str
        """

        self._candidate_middle_name = candidate_middle_name

    @property
    def candidate_name(self):
        """Gets the candidate_name of this ScheduleB.  # noqa: E501

        Name of candidate running for office  # noqa: E501

        :return: The candidate_name of this ScheduleB.  # noqa: E501
        :rtype: str
        """
        return self._candidate_name

    @candidate_name.setter
    def candidate_name(self, candidate_name):
        """Sets the candidate_name of this ScheduleB.

        Name of candidate running for office  # noqa: E501

        :param candidate_name: The candidate_name of this ScheduleB.  # noqa: E501
        :type: str
        """

        self._candidate_name = candidate_name

    @property
    def candidate_office(self):
        """Gets the candidate_office of this ScheduleB.  # noqa: E501


        :return: The candidate_office of this ScheduleB.  # noqa: E501
        :rtype: str
        """
        return self._candidate_office

    @candidate_office.setter
    def candidate_office(self, candidate_office):
        """Sets the candidate_office of this ScheduleB.


        :param candidate_office: The candidate_office of this ScheduleB.  # noqa: E501
        :type: str
        """

        self._candidate_office = candidate_office

    @property
    def candidate_office_description(self):
        """Gets the candidate_office_description of this ScheduleB.  # noqa: E501


        :return: The candidate_office_description of this ScheduleB.  # noqa: E501
        :rtype: str
        """
        return self._candidate_office_description

    @candidate_office_description.setter
    def candidate_office_description(self, candidate_office_description):
        """Sets the candidate_office_description of this ScheduleB.


        :param candidate_office_description: The candidate_office_description of this ScheduleB.  # noqa: E501
        :type: str
        """

        self._candidate_office_description = candidate_office_description

    @property
    def candidate_office_district(self):
        """Gets the candidate_office_district of this ScheduleB.  # noqa: E501


        :return: The candidate_office_district of this ScheduleB.  # noqa: E501
        :rtype: str
        """
        return self._candidate_office_district

    @candidate_office_district.setter
    def candidate_office_district(self, candidate_office_district):
        """Sets the candidate_office_district of this ScheduleB.


        :param candidate_office_district: The candidate_office_district of this ScheduleB.  # noqa: E501
        :type: str
        """

        self._candidate_office_district = candidate_office_district

    @property
    def candidate_office_state(self):
        """Gets the candidate_office_state of this ScheduleB.  # noqa: E501


        :return: The candidate_office_state of this ScheduleB.  # noqa: E501
        :rtype: str
        """
        return self._candidate_office_state

    @candidate_office_state.setter
    def candidate_office_state(self, candidate_office_state):
        """Sets the candidate_office_state of this ScheduleB.


        :param candidate_office_state: The candidate_office_state of this ScheduleB.  # noqa: E501
        :type: str
        """

        self._candidate_office_state = candidate_office_state

    @property
    def candidate_office_state_full(self):
        """Gets the candidate_office_state_full of this ScheduleB.  # noqa: E501


        :return: The candidate_office_state_full of this ScheduleB.  # noqa: E501
        :rtype: str
        """
        return self._candidate_office_state_full

    @candidate_office_state_full.setter
    def candidate_office_state_full(self, candidate_office_state_full):
        """Sets the candidate_office_state_full of this ScheduleB.


        :param candidate_office_state_full: The candidate_office_state_full of this ScheduleB.  # noqa: E501
        :type: str
        """

        self._candidate_office_state_full = candidate_office_state_full

    @property
    def candidate_prefix(self):
        """Gets the candidate_prefix of this ScheduleB.  # noqa: E501


        :return: The candidate_prefix of this ScheduleB.  # noqa: E501
        :rtype: str
        """
        return self._candidate_prefix

    @candidate_prefix.setter
    def candidate_prefix(self, candidate_prefix):
        """Sets the candidate_prefix of this ScheduleB.


        :param candidate_prefix: The candidate_prefix of this ScheduleB.  # noqa: E501
        :type: str
        """

        self._candidate_prefix = candidate_prefix

    @property
    def candidate_suffix(self):
        """Gets the candidate_suffix of this ScheduleB.  # noqa: E501


        :return: The candidate_suffix of this ScheduleB.  # noqa: E501
        :rtype: str
        """
        return self._candidate_suffix

    @candidate_suffix.setter
    def candidate_suffix(self, candidate_suffix):
        """Sets the candidate_suffix of this ScheduleB.


        :param candidate_suffix: The candidate_suffix of this ScheduleB.  # noqa: E501
        :type: str
        """

        self._candidate_suffix = candidate_suffix

    @property
    def category_code(self):
        """Gets the category_code of this ScheduleB.  # noqa: E501


        :return: The category_code of this ScheduleB.  # noqa: E501
        :rtype: str
        """
        return self._category_code

    @category_code.setter
    def category_code(self, category_code):
        """Sets the category_code of this ScheduleB.


        :param category_code: The category_code of this ScheduleB.  # noqa: E501
        :type: str
        """

        self._category_code = category_code

    @property
    def category_code_full(self):
        """Gets the category_code_full of this ScheduleB.  # noqa: E501


        :return: The category_code_full of this ScheduleB.  # noqa: E501
        :rtype: str
        """
        return self._category_code_full

    @category_code_full.setter
    def category_code_full(self, category_code_full):
        """Sets the category_code_full of this ScheduleB.


        :param category_code_full: The category_code_full of this ScheduleB.  # noqa: E501
        :type: str
        """

        self._category_code_full = category_code_full

    @property
    def comm_dt(self):
        """Gets the comm_dt of this ScheduleB.  # noqa: E501


        :return: The comm_dt of this ScheduleB.  # noqa: E501
        :rtype: date
        """
        return self._comm_dt

    @comm_dt.setter
    def comm_dt(self, comm_dt):
        """Sets the comm_dt of this ScheduleB.


        :param comm_dt: The comm_dt of this ScheduleB.  # noqa: E501
        :type: date
        """

        self._comm_dt = comm_dt

    @property
    def committee(self):
        """Gets the committee of this ScheduleB.  # noqa: E501


        :return: The committee of this ScheduleB.  # noqa: E501
        :rtype: CommitteeHistory
        """
        return self._committee

    @committee.setter
    def committee(self, committee):
        """Sets the committee of this ScheduleB.


        :param committee: The committee of this ScheduleB.  # noqa: E501
        :type: CommitteeHistory
        """

        self._committee = committee

    @property
    def committee_id(self):
        """Gets the committee_id of this ScheduleB.  # noqa: E501

         A unique identifier assigned to each committee or filer registered with the FEC. In general committee id's begin with the letter C which is followed by eight digits.   # noqa: E501

        :return: The committee_id of this ScheduleB.  # noqa: E501
        :rtype: str
        """
        return self._committee_id

    @committee_id.setter
    def committee_id(self, committee_id):
        """Sets the committee_id of this ScheduleB.

         A unique identifier assigned to each committee or filer registered with the FEC. In general committee id's begin with the letter C which is followed by eight digits.   # noqa: E501

        :param committee_id: The committee_id of this ScheduleB.  # noqa: E501
        :type: str
        """

        self._committee_id = committee_id

    @property
    def conduit_committee_city(self):
        """Gets the conduit_committee_city of this ScheduleB.  # noqa: E501


        :return: The conduit_committee_city of this ScheduleB.  # noqa: E501
        :rtype: str
        """
        return self._conduit_committee_city

    @conduit_committee_city.setter
    def conduit_committee_city(self, conduit_committee_city):
        """Sets the conduit_committee_city of this ScheduleB.


        :param conduit_committee_city: The conduit_committee_city of this ScheduleB.  # noqa: E501
        :type: str
        """

        self._conduit_committee_city = conduit_committee_city

    @property
    def conduit_committee_name(self):
        """Gets the conduit_committee_name of this ScheduleB.  # noqa: E501


        :return: The conduit_committee_name of this ScheduleB.  # noqa: E501
        :rtype: str
        """
        return self._conduit_committee_name

    @conduit_committee_name.setter
    def conduit_committee_name(self, conduit_committee_name):
        """Sets the conduit_committee_name of this ScheduleB.


        :param conduit_committee_name: The conduit_committee_name of this ScheduleB.  # noqa: E501
        :type: str
        """

        self._conduit_committee_name = conduit_committee_name

    @property
    def conduit_committee_state(self):
        """Gets the conduit_committee_state of this ScheduleB.  # noqa: E501


        :return: The conduit_committee_state of this ScheduleB.  # noqa: E501
        :rtype: str
        """
        return self._conduit_committee_state

    @conduit_committee_state.setter
    def conduit_committee_state(self, conduit_committee_state):
        """Sets the conduit_committee_state of this ScheduleB.


        :param conduit_committee_state: The conduit_committee_state of this ScheduleB.  # noqa: E501
        :type: str
        """

        self._conduit_committee_state = conduit_committee_state

    @property
    def conduit_committee_street1(self):
        """Gets the conduit_committee_street1 of this ScheduleB.  # noqa: E501


        :return: The conduit_committee_street1 of this ScheduleB.  # noqa: E501
        :rtype: str
        """
        return self._conduit_committee_street1

    @conduit_committee_street1.setter
    def conduit_committee_street1(self, conduit_committee_street1):
        """Sets the conduit_committee_street1 of this ScheduleB.


        :param conduit_committee_street1: The conduit_committee_street1 of this ScheduleB.  # noqa: E501
        :type: str
        """

        self._conduit_committee_street1 = conduit_committee_street1

    @property
    def conduit_committee_street2(self):
        """Gets the conduit_committee_street2 of this ScheduleB.  # noqa: E501


        :return: The conduit_committee_street2 of this ScheduleB.  # noqa: E501
        :rtype: str
        """
        return self._conduit_committee_street2

    @conduit_committee_street2.setter
    def conduit_committee_street2(self, conduit_committee_street2):
        """Sets the conduit_committee_street2 of this ScheduleB.


        :param conduit_committee_street2: The conduit_committee_street2 of this ScheduleB.  # noqa: E501
        :type: str
        """

        self._conduit_committee_street2 = conduit_committee_street2

    @property
    def conduit_committee_zip(self):
        """Gets the conduit_committee_zip of this ScheduleB.  # noqa: E501


        :return: The conduit_committee_zip of this ScheduleB.  # noqa: E501
        :rtype: int
        """
        return self._conduit_committee_zip

    @conduit_committee_zip.setter
    def conduit_committee_zip(self, conduit_committee_zip):
        """Sets the conduit_committee_zip of this ScheduleB.


        :param conduit_committee_zip: The conduit_committee_zip of this ScheduleB.  # noqa: E501
        :type: int
        """

        self._conduit_committee_zip = conduit_committee_zip

    @property
    def disbursement_amount(self):
        """Gets the disbursement_amount of this ScheduleB.  # noqa: E501


        :return: The disbursement_amount of this ScheduleB.  # noqa: E501
        :rtype: float
        """
        return self._disbursement_amount

    @disbursement_amount.setter
    def disbursement_amount(self, disbursement_amount):
        """Sets the disbursement_amount of this ScheduleB.


        :param disbursement_amount: The disbursement_amount of this ScheduleB.  # noqa: E501
        :type: float
        """

        self._disbursement_amount = disbursement_amount

    @property
    def disbursement_date(self):
        """Gets the disbursement_date of this ScheduleB.  # noqa: E501


        :return: The disbursement_date of this ScheduleB.  # noqa: E501
        :rtype: date
        """
        return self._disbursement_date

    @disbursement_date.setter
    def disbursement_date(self, disbursement_date):
        """Sets the disbursement_date of this ScheduleB.


        :param disbursement_date: The disbursement_date of this ScheduleB.  # noqa: E501
        :type: date
        """

        self._disbursement_date = disbursement_date

    @property
    def disbursement_description(self):
        """Gets the disbursement_description of this ScheduleB.  # noqa: E501


        :return: The disbursement_description of this ScheduleB.  # noqa: E501
        :rtype: str
        """
        return self._disbursement_description

    @disbursement_description.setter
    def disbursement_description(self, disbursement_description):
        """Sets the disbursement_description of this ScheduleB.


        :param disbursement_description: The disbursement_description of this ScheduleB.  # noqa: E501
        :type: str
        """

        self._disbursement_description = disbursement_description

    @property
    def disbursement_purpose_category(self):
        """Gets the disbursement_purpose_category of this ScheduleB.  # noqa: E501


        :return: The disbursement_purpose_category of this ScheduleB.  # noqa: E501
        :rtype: str
        """
        return self._disbursement_purpose_category

    @disbursement_purpose_category.setter
    def disbursement_purpose_category(self, disbursement_purpose_category):
        """Sets the disbursement_purpose_category of this ScheduleB.


        :param disbursement_purpose_category: The disbursement_purpose_category of this ScheduleB.  # noqa: E501
        :type: str
        """

        self._disbursement_purpose_category = disbursement_purpose_category

    @property
    def disbursement_type(self):
        """Gets the disbursement_type of this ScheduleB.  # noqa: E501


        :return: The disbursement_type of this ScheduleB.  # noqa: E501
        :rtype: str
        """
        return self._disbursement_type

    @disbursement_type.setter
    def disbursement_type(self, disbursement_type):
        """Sets the disbursement_type of this ScheduleB.


        :param disbursement_type: The disbursement_type of this ScheduleB.  # noqa: E501
        :type: str
        """

        self._disbursement_type = disbursement_type

    @property
    def disbursement_type_description(self):
        """Gets the disbursement_type_description of this ScheduleB.  # noqa: E501


        :return: The disbursement_type_description of this ScheduleB.  # noqa: E501
        :rtype: str
        """
        return self._disbursement_type_description

    @disbursement_type_description.setter
    def disbursement_type_description(self, disbursement_type_description):
        """Sets the disbursement_type_description of this ScheduleB.


        :param disbursement_type_description: The disbursement_type_description of this ScheduleB.  # noqa: E501
        :type: str
        """

        self._disbursement_type_description = disbursement_type_description

    @property
    def election_type(self):
        """Gets the election_type of this ScheduleB.  # noqa: E501


        :return: The election_type of this ScheduleB.  # noqa: E501
        :rtype: str
        """
        return self._election_type

    @election_type.setter
    def election_type(self, election_type):
        """Sets the election_type of this ScheduleB.


        :param election_type: The election_type of this ScheduleB.  # noqa: E501
        :type: str
        """

        self._election_type = election_type

    @property
    def election_type_full(self):
        """Gets the election_type_full of this ScheduleB.  # noqa: E501


        :return: The election_type_full of this ScheduleB.  # noqa: E501
        :rtype: str
        """
        return self._election_type_full

    @election_type_full.setter
    def election_type_full(self, election_type_full):
        """Sets the election_type_full of this ScheduleB.


        :param election_type_full: The election_type_full of this ScheduleB.  # noqa: E501
        :type: str
        """

        self._election_type_full = election_type_full

    @property
    def entity_type(self):
        """Gets the entity_type of this ScheduleB.  # noqa: E501


        :return: The entity_type of this ScheduleB.  # noqa: E501
        :rtype: str
        """
        return self._entity_type

    @entity_type.setter
    def entity_type(self, entity_type):
        """Sets the entity_type of this ScheduleB.


        :param entity_type: The entity_type of this ScheduleB.  # noqa: E501
        :type: str
        """

        self._entity_type = entity_type

    @property
    def entity_type_desc(self):
        """Gets the entity_type_desc of this ScheduleB.  # noqa: E501


        :return: The entity_type_desc of this ScheduleB.  # noqa: E501
        :rtype: str
        """
        return self._entity_type_desc

    @entity_type_desc.setter
    def entity_type_desc(self, entity_type_desc):
        """Sets the entity_type_desc of this ScheduleB.


        :param entity_type_desc: The entity_type_desc of this ScheduleB.  # noqa: E501
        :type: str
        """

        self._entity_type_desc = entity_type_desc

    @property
    def fec_election_type_desc(self):
        """Gets the fec_election_type_desc of this ScheduleB.  # noqa: E501


        :return: The fec_election_type_desc of this ScheduleB.  # noqa: E501
        :rtype: str
        """
        return self._fec_election_type_desc

    @fec_election_type_desc.setter
    def fec_election_type_desc(self, fec_election_type_desc):
        """Sets the fec_election_type_desc of this ScheduleB.


        :param fec_election_type_desc: The fec_election_type_desc of this ScheduleB.  # noqa: E501
        :type: str
        """

        self._fec_election_type_desc = fec_election_type_desc

    @property
    def fec_election_year(self):
        """Gets the fec_election_year of this ScheduleB.  # noqa: E501


        :return: The fec_election_year of this ScheduleB.  # noqa: E501
        :rtype: str
        """
        return self._fec_election_year

    @fec_election_year.setter
    def fec_election_year(self, fec_election_year):
        """Sets the fec_election_year of this ScheduleB.


        :param fec_election_year: The fec_election_year of this ScheduleB.  # noqa: E501
        :type: str
        """

        self._fec_election_year = fec_election_year

    @property
    def file_number(self):
        """Gets the file_number of this ScheduleB.  # noqa: E501


        :return: The file_number of this ScheduleB.  # noqa: E501
        :rtype: int
        """
        return self._file_number

    @file_number.setter
    def file_number(self, file_number):
        """Sets the file_number of this ScheduleB.


        :param file_number: The file_number of this ScheduleB.  # noqa: E501
        :type: int
        """

        self._file_number = file_number

    @property
    def filing_form(self):
        """Gets the filing_form of this ScheduleB.  # noqa: E501


        :return: The filing_form of this ScheduleB.  # noqa: E501
        :rtype: str
        """
        return self._filing_form

    @filing_form.setter
    def filing_form(self, filing_form):
        """Sets the filing_form of this ScheduleB.


        :param filing_form: The filing_form of this ScheduleB.  # noqa: E501
        :type: str
        """

        self._filing_form = filing_form

    @property
    def image_number(self):
        """Gets the image_number of this ScheduleB.  # noqa: E501


        :return: The image_number of this ScheduleB.  # noqa: E501
        :rtype: str
        """
        return self._image_number

    @image_number.setter
    def image_number(self, image_number):
        """Sets the image_number of this ScheduleB.


        :param image_number: The image_number of this ScheduleB.  # noqa: E501
        :type: str
        """

        self._image_number = image_number

    @property
    def line_number(self):
        """Gets the line_number of this ScheduleB.  # noqa: E501


        :return: The line_number of this ScheduleB.  # noqa: E501
        :rtype: str
        """
        return self._line_number

    @line_number.setter
    def line_number(self, line_number):
        """Sets the line_number of this ScheduleB.


        :param line_number: The line_number of this ScheduleB.  # noqa: E501
        :type: str
        """

        self._line_number = line_number

    @property
    def line_number_label(self):
        """Gets the line_number_label of this ScheduleB.  # noqa: E501


        :return: The line_number_label of this ScheduleB.  # noqa: E501
        :rtype: str
        """
        return self._line_number_label

    @line_number_label.setter
    def line_number_label(self, line_number_label):
        """Sets the line_number_label of this ScheduleB.


        :param line_number_label: The line_number_label of this ScheduleB.  # noqa: E501
        :type: str
        """

        self._line_number_label = line_number_label

    @property
    def link_id(self):
        """Gets the link_id of this ScheduleB.  # noqa: E501


        :return: The link_id of this ScheduleB.  # noqa: E501
        :rtype: int
        """
        return self._link_id

    @link_id.setter
    def link_id(self, link_id):
        """Sets the link_id of this ScheduleB.


        :param link_id: The link_id of this ScheduleB.  # noqa: E501
        :type: int
        """

        self._link_id = link_id

    @property
    def load_date(self):
        """Gets the load_date of this ScheduleB.  # noqa: E501


        :return: The load_date of this ScheduleB.  # noqa: E501
        :rtype: datetime
        """
        return self._load_date

    @load_date.setter
    def load_date(self, load_date):
        """Sets the load_date of this ScheduleB.


        :param load_date: The load_date of this ScheduleB.  # noqa: E501
        :type: datetime
        """

        self._load_date = load_date

    @property
    def memo_code(self):
        """Gets the memo_code of this ScheduleB.  # noqa: E501


        :return: The memo_code of this ScheduleB.  # noqa: E501
        :rtype: str
        """
        return self._memo_code

    @memo_code.setter
    def memo_code(self, memo_code):
        """Sets the memo_code of this ScheduleB.


        :param memo_code: The memo_code of this ScheduleB.  # noqa: E501
        :type: str
        """

        self._memo_code = memo_code

    @property
    def memo_code_full(self):
        """Gets the memo_code_full of this ScheduleB.  # noqa: E501


        :return: The memo_code_full of this ScheduleB.  # noqa: E501
        :rtype: str
        """
        return self._memo_code_full

    @memo_code_full.setter
    def memo_code_full(self, memo_code_full):
        """Sets the memo_code_full of this ScheduleB.


        :param memo_code_full: The memo_code_full of this ScheduleB.  # noqa: E501
        :type: str
        """

        self._memo_code_full = memo_code_full

    @property
    def memo_text(self):
        """Gets the memo_text of this ScheduleB.  # noqa: E501


        :return: The memo_text of this ScheduleB.  # noqa: E501
        :rtype: str
        """
        return self._memo_text

    @memo_text.setter
    def memo_text(self, memo_text):
        """Sets the memo_text of this ScheduleB.


        :param memo_text: The memo_text of this ScheduleB.  # noqa: E501
        :type: str
        """

        self._memo_text = memo_text

    @property
    def memoed_subtotal(self):
        """Gets the memoed_subtotal of this ScheduleB.  # noqa: E501


        :return: The memoed_subtotal of this ScheduleB.  # noqa: E501
        :rtype: bool
        """
        return self._memoed_subtotal

    @memoed_subtotal.setter
    def memoed_subtotal(self, memoed_subtotal):
        """Sets the memoed_subtotal of this ScheduleB.


        :param memoed_subtotal: The memoed_subtotal of this ScheduleB.  # noqa: E501
        :type: bool
        """

        self._memoed_subtotal = memoed_subtotal

    @property
    def national_committee_nonfederal_account(self):
        """Gets the national_committee_nonfederal_account of this ScheduleB.  # noqa: E501


        :return: The national_committee_nonfederal_account of this ScheduleB.  # noqa: E501
        :rtype: str
        """
        return self._national_committee_nonfederal_account

    @national_committee_nonfederal_account.setter
    def national_committee_nonfederal_account(self, national_committee_nonfederal_account):
        """Sets the national_committee_nonfederal_account of this ScheduleB.


        :param national_committee_nonfederal_account: The national_committee_nonfederal_account of this ScheduleB.  # noqa: E501
        :type: str
        """

        self._national_committee_nonfederal_account = national_committee_nonfederal_account

    @property
    def original_sub_id(self):
        """Gets the original_sub_id of this ScheduleB.  # noqa: E501


        :return: The original_sub_id of this ScheduleB.  # noqa: E501
        :rtype: str
        """
        return self._original_sub_id

    @original_sub_id.setter
    def original_sub_id(self, original_sub_id):
        """Sets the original_sub_id of this ScheduleB.


        :param original_sub_id: The original_sub_id of this ScheduleB.  # noqa: E501
        :type: str
        """

        self._original_sub_id = original_sub_id

    @property
    def payee_employer(self):
        """Gets the payee_employer of this ScheduleB.  # noqa: E501


        :return: The payee_employer of this ScheduleB.  # noqa: E501
        :rtype: str
        """
        return self._payee_employer

    @payee_employer.setter
    def payee_employer(self, payee_employer):
        """Sets the payee_employer of this ScheduleB.


        :param payee_employer: The payee_employer of this ScheduleB.  # noqa: E501
        :type: str
        """

        self._payee_employer = payee_employer

    @property
    def payee_first_name(self):
        """Gets the payee_first_name of this ScheduleB.  # noqa: E501


        :return: The payee_first_name of this ScheduleB.  # noqa: E501
        :rtype: str
        """
        return self._payee_first_name

    @payee_first_name.setter
    def payee_first_name(self, payee_first_name):
        """Sets the payee_first_name of this ScheduleB.


        :param payee_first_name: The payee_first_name of this ScheduleB.  # noqa: E501
        :type: str
        """

        self._payee_first_name = payee_first_name

    @property
    def payee_last_name(self):
        """Gets the payee_last_name of this ScheduleB.  # noqa: E501


        :return: The payee_last_name of this ScheduleB.  # noqa: E501
        :rtype: str
        """
        return self._payee_last_name

    @payee_last_name.setter
    def payee_last_name(self, payee_last_name):
        """Sets the payee_last_name of this ScheduleB.


        :param payee_last_name: The payee_last_name of this ScheduleB.  # noqa: E501
        :type: str
        """

        self._payee_last_name = payee_last_name

    @property
    def payee_middle_name(self):
        """Gets the payee_middle_name of this ScheduleB.  # noqa: E501


        :return: The payee_middle_name of this ScheduleB.  # noqa: E501
        :rtype: str
        """
        return self._payee_middle_name

    @payee_middle_name.setter
    def payee_middle_name(self, payee_middle_name):
        """Sets the payee_middle_name of this ScheduleB.


        :param payee_middle_name: The payee_middle_name of this ScheduleB.  # noqa: E501
        :type: str
        """

        self._payee_middle_name = payee_middle_name

    @property
    def payee_occupation(self):
        """Gets the payee_occupation of this ScheduleB.  # noqa: E501


        :return: The payee_occupation of this ScheduleB.  # noqa: E501
        :rtype: str
        """
        return self._payee_occupation

    @payee_occupation.setter
    def payee_occupation(self, payee_occupation):
        """Sets the payee_occupation of this ScheduleB.


        :param payee_occupation: The payee_occupation of this ScheduleB.  # noqa: E501
        :type: str
        """

        self._payee_occupation = payee_occupation

    @property
    def payee_prefix(self):
        """Gets the payee_prefix of this ScheduleB.  # noqa: E501


        :return: The payee_prefix of this ScheduleB.  # noqa: E501
        :rtype: str
        """
        return self._payee_prefix

    @payee_prefix.setter
    def payee_prefix(self, payee_prefix):
        """Sets the payee_prefix of this ScheduleB.


        :param payee_prefix: The payee_prefix of this ScheduleB.  # noqa: E501
        :type: str
        """

        self._payee_prefix = payee_prefix

    @property
    def payee_suffix(self):
        """Gets the payee_suffix of this ScheduleB.  # noqa: E501


        :return: The payee_suffix of this ScheduleB.  # noqa: E501
        :rtype: str
        """
        return self._payee_suffix

    @payee_suffix.setter
    def payee_suffix(self, payee_suffix):
        """Sets the payee_suffix of this ScheduleB.


        :param payee_suffix: The payee_suffix of this ScheduleB.  # noqa: E501
        :type: str
        """

        self._payee_suffix = payee_suffix

    @property
    def pdf_url(self):
        """Gets the pdf_url of this ScheduleB.  # noqa: E501


        :return: The pdf_url of this ScheduleB.  # noqa: E501
        :rtype: str
        """
        return self._pdf_url

    @pdf_url.setter
    def pdf_url(self, pdf_url):
        """Sets the pdf_url of this ScheduleB.


        :param pdf_url: The pdf_url of this ScheduleB.  # noqa: E501
        :type: str
        """

        self._pdf_url = pdf_url

    @property
    def recipient_city(self):
        """Gets the recipient_city of this ScheduleB.  # noqa: E501


        :return: The recipient_city of this ScheduleB.  # noqa: E501
        :rtype: str
        """
        return self._recipient_city

    @recipient_city.setter
    def recipient_city(self, recipient_city):
        """Sets the recipient_city of this ScheduleB.


        :param recipient_city: The recipient_city of this ScheduleB.  # noqa: E501
        :type: str
        """

        self._recipient_city = recipient_city

    @property
    def recipient_committee(self):
        """Gets the recipient_committee of this ScheduleB.  # noqa: E501


        :return: The recipient_committee of this ScheduleB.  # noqa: E501
        :rtype: CommitteeHistory
        """
        return self._recipient_committee

    @recipient_committee.setter
    def recipient_committee(self, recipient_committee):
        """Sets the recipient_committee of this ScheduleB.


        :param recipient_committee: The recipient_committee of this ScheduleB.  # noqa: E501
        :type: CommitteeHistory
        """

        self._recipient_committee = recipient_committee

    @property
    def recipient_committee_id(self):
        """Gets the recipient_committee_id of this ScheduleB.  # noqa: E501


        :return: The recipient_committee_id of this ScheduleB.  # noqa: E501
        :rtype: str
        """
        return self._recipient_committee_id

    @recipient_committee_id.setter
    def recipient_committee_id(self, recipient_committee_id):
        """Sets the recipient_committee_id of this ScheduleB.


        :param recipient_committee_id: The recipient_committee_id of this ScheduleB.  # noqa: E501
        :type: str
        """

        self._recipient_committee_id = recipient_committee_id

    @property
    def recipient_name(self):
        """Gets the recipient_name of this ScheduleB.  # noqa: E501


        :return: The recipient_name of this ScheduleB.  # noqa: E501
        :rtype: str
        """
        return self._recipient_name

    @recipient_name.setter
    def recipient_name(self, recipient_name):
        """Sets the recipient_name of this ScheduleB.


        :param recipient_name: The recipient_name of this ScheduleB.  # noqa: E501
        :type: str
        """

        self._recipient_name = recipient_name

    @property
    def recipient_state(self):
        """Gets the recipient_state of this ScheduleB.  # noqa: E501


        :return: The recipient_state of this ScheduleB.  # noqa: E501
        :rtype: str
        """
        return self._recipient_state

    @recipient_state.setter
    def recipient_state(self, recipient_state):
        """Sets the recipient_state of this ScheduleB.


        :param recipient_state: The recipient_state of this ScheduleB.  # noqa: E501
        :type: str
        """

        self._recipient_state = recipient_state

    @property
    def recipient_zip(self):
        """Gets the recipient_zip of this ScheduleB.  # noqa: E501


        :return: The recipient_zip of this ScheduleB.  # noqa: E501
        :rtype: str
        """
        return self._recipient_zip

    @recipient_zip.setter
    def recipient_zip(self, recipient_zip):
        """Sets the recipient_zip of this ScheduleB.


        :param recipient_zip: The recipient_zip of this ScheduleB.  # noqa: E501
        :type: str
        """

        self._recipient_zip = recipient_zip

    @property
    def ref_disp_excess_flg(self):
        """Gets the ref_disp_excess_flg of this ScheduleB.  # noqa: E501


        :return: The ref_disp_excess_flg of this ScheduleB.  # noqa: E501
        :rtype: str
        """
        return self._ref_disp_excess_flg

    @ref_disp_excess_flg.setter
    def ref_disp_excess_flg(self, ref_disp_excess_flg):
        """Sets the ref_disp_excess_flg of this ScheduleB.


        :param ref_disp_excess_flg: The ref_disp_excess_flg of this ScheduleB.  # noqa: E501
        :type: str
        """

        self._ref_disp_excess_flg = ref_disp_excess_flg

    @property
    def report_type(self):
        """Gets the report_type of this ScheduleB.  # noqa: E501

        Name of report where the underlying data comes from:     - 10D Pre-Election     - 10G Pre-General     - 10P Pre-Primary     - 10R Pre-Run-Off     - 10S Pre-Special     - 12C Pre-Convention     - 12G Pre-General     - 12P Pre-Primary     - 12R Pre-Run-Off     - 12S Pre-Special     - 30D Post-Election     - 30G Post-General     - 30P Post-Primary     - 30R Post-Run-Off     - 30S Post-Special     - 60D Post-Convention     - M1  January Monthly     - M10 October Monthly     - M11 November Monthly     - M12 December Monthly     - M2  February Monthly     - M3  March Monthly     - M4  April Monthly     - M5  May Monthly     - M6  June Monthly     - M7  July Monthly     - M8  August Monthly     - M9  September Monthly     - MY  Mid-Year Report     - Q1  April Quarterly     - Q2  July Quarterly     - Q3  October Quarterly     - TER Termination Report     - YE  Year-End     - ADJ COMP ADJUST AMEND     - CA  COMPREHENSIVE AMEND     - 90S Post Inaugural Supplement     - 90D Post Inaugural     - 48  48 Hour Notification     - 24  24 Hour Notification     - M7S July Monthly/Semi-Annual     - MSA Monthly Semi-Annual (MY)     - MYS Monthly Year End/Semi-Annual     - Q2S July Quarterly/Semi-Annual     - QSA Quarterly Semi-Annual (MY)     - QYS Quarterly Year End/Semi-Annual     - QYE Quarterly Semi-Annual (YE)     - QMS Quarterly Mid-Year/ Semi-Annual     - MSY Monthly Semi-Annual (YE)   # noqa: E501

        :return: The report_type of this ScheduleB.  # noqa: E501
        :rtype: str
        """
        return self._report_type

    @report_type.setter
    def report_type(self, report_type):
        """Sets the report_type of this ScheduleB.

        Name of report where the underlying data comes from:     - 10D Pre-Election     - 10G Pre-General     - 10P Pre-Primary     - 10R Pre-Run-Off     - 10S Pre-Special     - 12C Pre-Convention     - 12G Pre-General     - 12P Pre-Primary     - 12R Pre-Run-Off     - 12S Pre-Special     - 30D Post-Election     - 30G Post-General     - 30P Post-Primary     - 30R Post-Run-Off     - 30S Post-Special     - 60D Post-Convention     - M1  January Monthly     - M10 October Monthly     - M11 November Monthly     - M12 December Monthly     - M2  February Monthly     - M3  March Monthly     - M4  April Monthly     - M5  May Monthly     - M6  June Monthly     - M7  July Monthly     - M8  August Monthly     - M9  September Monthly     - MY  Mid-Year Report     - Q1  April Quarterly     - Q2  July Quarterly     - Q3  October Quarterly     - TER Termination Report     - YE  Year-End     - ADJ COMP ADJUST AMEND     - CA  COMPREHENSIVE AMEND     - 90S Post Inaugural Supplement     - 90D Post Inaugural     - 48  48 Hour Notification     - 24  24 Hour Notification     - M7S July Monthly/Semi-Annual     - MSA Monthly Semi-Annual (MY)     - MYS Monthly Year End/Semi-Annual     - Q2S July Quarterly/Semi-Annual     - QSA Quarterly Semi-Annual (MY)     - QYS Quarterly Year End/Semi-Annual     - QYE Quarterly Semi-Annual (YE)     - QMS Quarterly Mid-Year/ Semi-Annual     - MSY Monthly Semi-Annual (YE)   # noqa: E501

        :param report_type: The report_type of this ScheduleB.  # noqa: E501
        :type: str
        """

        self._report_type = report_type

    @property
    def report_year(self):
        """Gets the report_year of this ScheduleB.  # noqa: E501

         Forms with coverage date -      year from the coverage ending date. Forms without coverage date -      year from the receipt date.   # noqa: E501

        :return: The report_year of this ScheduleB.  # noqa: E501
        :rtype: int
        """
        return self._report_year

    @report_year.setter
    def report_year(self, report_year):
        """Sets the report_year of this ScheduleB.

         Forms with coverage date -      year from the coverage ending date. Forms without coverage date -      year from the receipt date.   # noqa: E501

        :param report_year: The report_year of this ScheduleB.  # noqa: E501
        :type: int
        """

        self._report_year = report_year

    @property
    def schedule_type(self):
        """Gets the schedule_type of this ScheduleB.  # noqa: E501


        :return: The schedule_type of this ScheduleB.  # noqa: E501
        :rtype: str
        """
        return self._schedule_type

    @schedule_type.setter
    def schedule_type(self, schedule_type):
        """Sets the schedule_type of this ScheduleB.


        :param schedule_type: The schedule_type of this ScheduleB.  # noqa: E501
        :type: str
        """

        self._schedule_type = schedule_type

    @property
    def schedule_type_full(self):
        """Gets the schedule_type_full of this ScheduleB.  # noqa: E501


        :return: The schedule_type_full of this ScheduleB.  # noqa: E501
        :rtype: str
        """
        return self._schedule_type_full

    @schedule_type_full.setter
    def schedule_type_full(self, schedule_type_full):
        """Sets the schedule_type_full of this ScheduleB.


        :param schedule_type_full: The schedule_type_full of this ScheduleB.  # noqa: E501
        :type: str
        """

        self._schedule_type_full = schedule_type_full

    @property
    def semi_annual_bundled_refund(self):
        """Gets the semi_annual_bundled_refund of this ScheduleB.  # noqa: E501


        :return: The semi_annual_bundled_refund of this ScheduleB.  # noqa: E501
        :rtype: float
        """
        return self._semi_annual_bundled_refund

    @semi_annual_bundled_refund.setter
    def semi_annual_bundled_refund(self, semi_annual_bundled_refund):
        """Sets the semi_annual_bundled_refund of this ScheduleB.


        :param semi_annual_bundled_refund: The semi_annual_bundled_refund of this ScheduleB.  # noqa: E501
        :type: float
        """

        self._semi_annual_bundled_refund = semi_annual_bundled_refund

    @property
    def spender_committee_designation(self):
        """Gets the spender_committee_designation of this ScheduleB.  # noqa: E501


        :return: The spender_committee_designation of this ScheduleB.  # noqa: E501
        :rtype: str
        """
        return self._spender_committee_designation

    @spender_committee_designation.setter
    def spender_committee_designation(self, spender_committee_designation):
        """Sets the spender_committee_designation of this ScheduleB.


        :param spender_committee_designation: The spender_committee_designation of this ScheduleB.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                spender_committee_designation is not None and len(spender_committee_designation) > 1):
            raise ValueError('Invalid value for `spender_committee_designation`, length must be less than or equal to `1`')  # noqa: E501

        self._spender_committee_designation = spender_committee_designation

    @property
    def spender_committee_org_type(self):
        """Gets the spender_committee_org_type of this ScheduleB.  # noqa: E501


        :return: The spender_committee_org_type of this ScheduleB.  # noqa: E501
        :rtype: str
        """
        return self._spender_committee_org_type

    @spender_committee_org_type.setter
    def spender_committee_org_type(self, spender_committee_org_type):
        """Sets the spender_committee_org_type of this ScheduleB.


        :param spender_committee_org_type: The spender_committee_org_type of this ScheduleB.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                spender_committee_org_type is not None and len(spender_committee_org_type) > 1):
            raise ValueError('Invalid value for `spender_committee_org_type`, length must be less than or equal to `1`')  # noqa: E501

        self._spender_committee_org_type = spender_committee_org_type

    @property
    def spender_committee_type(self):
        """Gets the spender_committee_type of this ScheduleB.  # noqa: E501


        :return: The spender_committee_type of this ScheduleB.  # noqa: E501
        :rtype: str
        """
        return self._spender_committee_type

    @spender_committee_type.setter
    def spender_committee_type(self, spender_committee_type):
        """Sets the spender_committee_type of this ScheduleB.


        :param spender_committee_type: The spender_committee_type of this ScheduleB.  # noqa: E501
        :type: str
        """
        if (self.local_vars_configuration.client_side_validation and
                spender_committee_type is not None and len(spender_committee_type) > 1):
            raise ValueError('Invalid value for `spender_committee_type`, length must be less than or equal to `1`')  # noqa: E501

        self._spender_committee_type = spender_committee_type

    @property
    def sub_id(self):
        """Gets the sub_id of this ScheduleB.  # noqa: E501


        :return: The sub_id of this ScheduleB.  # noqa: E501
        :rtype: str
        """
        return self._sub_id

    @sub_id.setter
    def sub_id(self, sub_id):
        """Sets the sub_id of this ScheduleB.


        :param sub_id: The sub_id of this ScheduleB.  # noqa: E501
        :type: str
        """

        self._sub_id = sub_id

    @property
    def transaction_id(self):
        """Gets the transaction_id of this ScheduleB.  # noqa: E501


        :return: The transaction_id of this ScheduleB.  # noqa: E501
        :rtype: str
        """
        return self._transaction_id

    @transaction_id.setter
    def transaction_id(self, transaction_id):
        """Sets the transaction_id of this ScheduleB.


        :param transaction_id: The transaction_id of this ScheduleB.  # noqa: E501
        :type: str
        """

        self._transaction_id = transaction_id

    @property
    def two_year_transaction_period(self):
        """Gets the two_year_transaction_period of this ScheduleB.  # noqa: E501

         This is a two-year period that is derived from the year a transaction took place in the Itemized Schedule A and Schedule B tables. In cases where we have the date of the transaction (contribution_receipt_date in schedules/schedule_a, disbursement_date in schedules/schedule_b) the two_year_transaction_period is named after the ending, even-numbered year. If we do not have the date  of the transaction, we fall back to using the report year (report_year in both tables) instead,  making the same cycle adjustment as necessary. If no transaction year is specified, the results default to the most current cycle.   # noqa: E501

        :return: The two_year_transaction_period of this ScheduleB.  # noqa: E501
        :rtype: int
        """
        return self._two_year_transaction_period

    @two_year_transaction_period.setter
    def two_year_transaction_period(self, two_year_transaction_period):
        """Sets the two_year_transaction_period of this ScheduleB.

         This is a two-year period that is derived from the year a transaction took place in the Itemized Schedule A and Schedule B tables. In cases where we have the date of the transaction (contribution_receipt_date in schedules/schedule_a, disbursement_date in schedules/schedule_b) the two_year_transaction_period is named after the ending, even-numbered year. If we do not have the date  of the transaction, we fall back to using the report year (report_year in both tables) instead,  making the same cycle adjustment as necessary. If no transaction year is specified, the results default to the most current cycle.   # noqa: E501

        :param two_year_transaction_period: The two_year_transaction_period of this ScheduleB.  # noqa: E501
        :type: int
        """

        self._two_year_transaction_period = two_year_transaction_period

    @property
    def unused_recipient_committee_id(self):
        """Gets the unused_recipient_committee_id of this ScheduleB.  # noqa: E501


        :return: The unused_recipient_committee_id of this ScheduleB.  # noqa: E501
        :rtype: str
        """
        return self._unused_recipient_committee_id

    @unused_recipient_committee_id.setter
    def unused_recipient_committee_id(self, unused_recipient_committee_id):
        """Sets the unused_recipient_committee_id of this ScheduleB.


        :param unused_recipient_committee_id: The unused_recipient_committee_id of this ScheduleB.  # noqa: E501
        :type: str
        """

        self._unused_recipient_committee_id = unused_recipient_committee_id

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, 'to_dict') else x,
                    value
                ))
            elif hasattr(value, 'to_dict'):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], 'to_dict') else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ScheduleB):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, ScheduleB):
            return True

        return self.to_dict() != other.to_dict()
