# coding: utf-8

"""
    OpenFEC

    This API allows you to explore the way candidates and committees fund their campaigns.    The FEC API is a RESTful web service supporting full-text and field-specific searches on FEC data. [Bulk downloads](https://www.fec.gov/data/advanced/?tab=bulk-data) are available on the current site. Information is tied to the underlying forms by file ID and image ID. Data is updated nightly.    There is a lot of data, but a good place to start is to use search to find interesting candidates and committees. Then, you can use their IDs to find report or line item details with the other endpoints. If you are interested in individual donors, check out contributor information in schedule_a.    Get an [API key here](https://api.data.gov/signup/). That will enable you to place up to 1,000 calls an hour. Each call is limited to 100 results per page. You can email questions, comments or a request to get a key for 120 calls per minute to [APIinfo@fec.gov](mailto:apiinfo@fec.gov). You can also ask questions and discuss the data in the [FEC data Google Group](https://groups.google.com/forum/#!forum/fec-data). API changes will also be added to this group in advance of the change.    The model definitions and schema are available at [/swagger](/swagger/). This is useful for making wrappers and exploring the data.    A few restrictions limit the way you can use FEC data. For example, you can’t use contributor lists for commercial purposes or to solicit donations. [Learn more here](https://www.fec.gov/updates/sale-or-use-contributor-information/).    [View our source code](https://github.com/fecgov/openFEC). We welcome issues and pull requests!  # noqa: E501

    The version of the OpenAPI document: 1.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from openfec_sdk.configuration import Configuration


class ScheduleE(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'action_code': 'str',
        'action_code_full': 'str',
        'amendment_indicator': 'str',
        'amendment_number': 'int',
        'back_reference_schedule_name': 'str',
        'back_reference_transaction_id': 'str',
        'candidate': 'str',
        'candidate_first_name': 'str',
        'candidate_id': 'str',
        'candidate_last_name': 'str',
        'candidate_middle_name': 'str',
        'candidate_name': 'str',
        'candidate_office': 'str',
        'candidate_office_district': 'str',
        'candidate_office_state': 'str',
        'candidate_party': 'str',
        'candidate_prefix': 'str',
        'candidate_suffix': 'str',
        'category_code': 'str',
        'category_code_full': 'str',
        'committee': 'CommitteeHistory',
        'committee_id': 'str',
        'conduit_committee_city': 'str',
        'conduit_committee_id': 'str',
        'conduit_committee_name': 'str',
        'conduit_committee_state': 'str',
        'conduit_committee_street1': 'str',
        'conduit_committee_street2': 'str',
        'conduit_committee_zip': 'int',
        'dissemination_date': 'date',
        'election_type': 'str',
        'election_type_full': 'str',
        'expenditure_amount': 'float',
        'expenditure_date': 'date',
        'expenditure_description': 'str',
        'file_number': 'int',
        'filer_first_name': 'str',
        'filer_last_name': 'str',
        'filer_middle_name': 'str',
        'filer_prefix': 'str',
        'filer_suffix': 'str',
        'filing_date': 'date',
        'filing_form': 'str',
        'image_number': 'str',
        'independent_sign_date': 'date',
        'independent_sign_name': 'str',
        'is_notice': 'bool',
        'line_number': 'str',
        'link_id': 'int',
        'memo_code': 'str',
        'memo_code_full': 'str',
        'memo_text': 'str',
        'memoed_subtotal': 'bool',
        'most_recent': 'bool',
        'notary_commission_expiration_date': 'date',
        'notary_sign_date': 'date',
        'notary_sign_name': 'str',
        'office_total_ytd': 'float',
        'original_sub_id': 'str',
        'payee_city': 'str',
        'payee_first_name': 'str',
        'payee_last_name': 'str',
        'payee_middle_name': 'str',
        'payee_name': 'str',
        'payee_prefix': 'str',
        'payee_state': 'str',
        'payee_street_1': 'str',
        'payee_street_2': 'str',
        'payee_suffix': 'str',
        'payee_zip': 'str',
        'pdf_url': 'str',
        'previous_file_number': 'int',
        'report_type': 'str',
        'report_year': 'int',
        'schedule_type': 'str',
        'schedule_type_full': 'str',
        'sub_id': 'str',
        'support_oppose_indicator': 'str',
        'transaction_id': 'str'
    }

    attribute_map = {
        'action_code': 'action_code',
        'action_code_full': 'action_code_full',
        'amendment_indicator': 'amendment_indicator',
        'amendment_number': 'amendment_number',
        'back_reference_schedule_name': 'back_reference_schedule_name',
        'back_reference_transaction_id': 'back_reference_transaction_id',
        'candidate': 'candidate',
        'candidate_first_name': 'candidate_first_name',
        'candidate_id': 'candidate_id',
        'candidate_last_name': 'candidate_last_name',
        'candidate_middle_name': 'candidate_middle_name',
        'candidate_name': 'candidate_name',
        'candidate_office': 'candidate_office',
        'candidate_office_district': 'candidate_office_district',
        'candidate_office_state': 'candidate_office_state',
        'candidate_party': 'candidate_party',
        'candidate_prefix': 'candidate_prefix',
        'candidate_suffix': 'candidate_suffix',
        'category_code': 'category_code',
        'category_code_full': 'category_code_full',
        'committee': 'committee',
        'committee_id': 'committee_id',
        'conduit_committee_city': 'conduit_committee_city',
        'conduit_committee_id': 'conduit_committee_id',
        'conduit_committee_name': 'conduit_committee_name',
        'conduit_committee_state': 'conduit_committee_state',
        'conduit_committee_street1': 'conduit_committee_street1',
        'conduit_committee_street2': 'conduit_committee_street2',
        'conduit_committee_zip': 'conduit_committee_zip',
        'dissemination_date': 'dissemination_date',
        'election_type': 'election_type',
        'election_type_full': 'election_type_full',
        'expenditure_amount': 'expenditure_amount',
        'expenditure_date': 'expenditure_date',
        'expenditure_description': 'expenditure_description',
        'file_number': 'file_number',
        'filer_first_name': 'filer_first_name',
        'filer_last_name': 'filer_last_name',
        'filer_middle_name': 'filer_middle_name',
        'filer_prefix': 'filer_prefix',
        'filer_suffix': 'filer_suffix',
        'filing_date': 'filing_date',
        'filing_form': 'filing_form',
        'image_number': 'image_number',
        'independent_sign_date': 'independent_sign_date',
        'independent_sign_name': 'independent_sign_name',
        'is_notice': 'is_notice',
        'line_number': 'line_number',
        'link_id': 'link_id',
        'memo_code': 'memo_code',
        'memo_code_full': 'memo_code_full',
        'memo_text': 'memo_text',
        'memoed_subtotal': 'memoed_subtotal',
        'most_recent': 'most_recent',
        'notary_commission_expiration_date': 'notary_commission_expiration_date',
        'notary_sign_date': 'notary_sign_date',
        'notary_sign_name': 'notary_sign_name',
        'office_total_ytd': 'office_total_ytd',
        'original_sub_id': 'original_sub_id',
        'payee_city': 'payee_city',
        'payee_first_name': 'payee_first_name',
        'payee_last_name': 'payee_last_name',
        'payee_middle_name': 'payee_middle_name',
        'payee_name': 'payee_name',
        'payee_prefix': 'payee_prefix',
        'payee_state': 'payee_state',
        'payee_street_1': 'payee_street_1',
        'payee_street_2': 'payee_street_2',
        'payee_suffix': 'payee_suffix',
        'payee_zip': 'payee_zip',
        'pdf_url': 'pdf_url',
        'previous_file_number': 'previous_file_number',
        'report_type': 'report_type',
        'report_year': 'report_year',
        'schedule_type': 'schedule_type',
        'schedule_type_full': 'schedule_type_full',
        'sub_id': 'sub_id',
        'support_oppose_indicator': 'support_oppose_indicator',
        'transaction_id': 'transaction_id'
    }

    def __init__(self, action_code=None, action_code_full=None, amendment_indicator=None, amendment_number=None, back_reference_schedule_name=None, back_reference_transaction_id=None, candidate=None, candidate_first_name=None, candidate_id=None, candidate_last_name=None, candidate_middle_name=None, candidate_name=None, candidate_office=None, candidate_office_district=None, candidate_office_state=None, candidate_party=None, candidate_prefix=None, candidate_suffix=None, category_code=None, category_code_full=None, committee=None, committee_id=None, conduit_committee_city=None, conduit_committee_id=None, conduit_committee_name=None, conduit_committee_state=None, conduit_committee_street1=None, conduit_committee_street2=None, conduit_committee_zip=None, dissemination_date=None, election_type=None, election_type_full=None, expenditure_amount=None, expenditure_date=None, expenditure_description=None, file_number=None, filer_first_name=None, filer_last_name=None, filer_middle_name=None, filer_prefix=None, filer_suffix=None, filing_date=None, filing_form=None, image_number=None, independent_sign_date=None, independent_sign_name=None, is_notice=None, line_number=None, link_id=None, memo_code=None, memo_code_full=None, memo_text=None, memoed_subtotal=None, most_recent=None, notary_commission_expiration_date=None, notary_sign_date=None, notary_sign_name=None, office_total_ytd=None, original_sub_id=None, payee_city=None, payee_first_name=None, payee_last_name=None, payee_middle_name=None, payee_name=None, payee_prefix=None, payee_state=None, payee_street_1=None, payee_street_2=None, payee_suffix=None, payee_zip=None, pdf_url=None, previous_file_number=None, report_type=None, report_year=None, schedule_type=None, schedule_type_full=None, sub_id=None, support_oppose_indicator=None, transaction_id=None, local_vars_configuration=None):  # noqa: E501
        """ScheduleE - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._action_code = None
        self._action_code_full = None
        self._amendment_indicator = None
        self._amendment_number = None
        self._back_reference_schedule_name = None
        self._back_reference_transaction_id = None
        self._candidate = None
        self._candidate_first_name = None
        self._candidate_id = None
        self._candidate_last_name = None
        self._candidate_middle_name = None
        self._candidate_name = None
        self._candidate_office = None
        self._candidate_office_district = None
        self._candidate_office_state = None
        self._candidate_party = None
        self._candidate_prefix = None
        self._candidate_suffix = None
        self._category_code = None
        self._category_code_full = None
        self._committee = None
        self._committee_id = None
        self._conduit_committee_city = None
        self._conduit_committee_id = None
        self._conduit_committee_name = None
        self._conduit_committee_state = None
        self._conduit_committee_street1 = None
        self._conduit_committee_street2 = None
        self._conduit_committee_zip = None
        self._dissemination_date = None
        self._election_type = None
        self._election_type_full = None
        self._expenditure_amount = None
        self._expenditure_date = None
        self._expenditure_description = None
        self._file_number = None
        self._filer_first_name = None
        self._filer_last_name = None
        self._filer_middle_name = None
        self._filer_prefix = None
        self._filer_suffix = None
        self._filing_date = None
        self._filing_form = None
        self._image_number = None
        self._independent_sign_date = None
        self._independent_sign_name = None
        self._is_notice = None
        self._line_number = None
        self._link_id = None
        self._memo_code = None
        self._memo_code_full = None
        self._memo_text = None
        self._memoed_subtotal = None
        self._most_recent = None
        self._notary_commission_expiration_date = None
        self._notary_sign_date = None
        self._notary_sign_name = None
        self._office_total_ytd = None
        self._original_sub_id = None
        self._payee_city = None
        self._payee_first_name = None
        self._payee_last_name = None
        self._payee_middle_name = None
        self._payee_name = None
        self._payee_prefix = None
        self._payee_state = None
        self._payee_street_1 = None
        self._payee_street_2 = None
        self._payee_suffix = None
        self._payee_zip = None
        self._pdf_url = None
        self._previous_file_number = None
        self._report_type = None
        self._report_year = None
        self._schedule_type = None
        self._schedule_type_full = None
        self._sub_id = None
        self._support_oppose_indicator = None
        self._transaction_id = None
        self.discriminator = None

        self.action_code = action_code
        self.action_code_full = action_code_full
        self.amendment_indicator = amendment_indicator
        self.amendment_number = amendment_number
        self.back_reference_schedule_name = back_reference_schedule_name
        self.back_reference_transaction_id = back_reference_transaction_id
        self.candidate = candidate
        self.candidate_first_name = candidate_first_name
        self.candidate_id = candidate_id
        self.candidate_last_name = candidate_last_name
        self.candidate_middle_name = candidate_middle_name
        self.candidate_name = candidate_name
        self.candidate_office = candidate_office
        self.candidate_office_district = candidate_office_district
        self.candidate_office_state = candidate_office_state
        self.candidate_party = candidate_party
        self.candidate_prefix = candidate_prefix
        self.candidate_suffix = candidate_suffix
        self.category_code = category_code
        self.category_code_full = category_code_full
        if committee is not None:
            self.committee = committee
        self.committee_id = committee_id
        self.conduit_committee_city = conduit_committee_city
        self.conduit_committee_id = conduit_committee_id
        self.conduit_committee_name = conduit_committee_name
        self.conduit_committee_state = conduit_committee_state
        self.conduit_committee_street1 = conduit_committee_street1
        self.conduit_committee_street2 = conduit_committee_street2
        self.conduit_committee_zip = conduit_committee_zip
        self.dissemination_date = dissemination_date
        self.election_type = election_type
        self.election_type_full = election_type_full
        if expenditure_amount is not None:
            self.expenditure_amount = expenditure_amount
        self.expenditure_date = expenditure_date
        self.expenditure_description = expenditure_description
        self.file_number = file_number
        self.filer_first_name = filer_first_name
        self.filer_last_name = filer_last_name
        self.filer_middle_name = filer_middle_name
        self.filer_prefix = filer_prefix
        self.filer_suffix = filer_suffix
        self.filing_date = filing_date
        self.filing_form = filing_form
        if image_number is not None:
            self.image_number = image_number
        self.independent_sign_date = independent_sign_date
        self.independent_sign_name = independent_sign_name
        self.is_notice = is_notice
        self.line_number = line_number
        self.link_id = link_id
        self.memo_code = memo_code
        self.memo_code_full = memo_code_full
        self.memo_text = memo_text
        if memoed_subtotal is not None:
            self.memoed_subtotal = memoed_subtotal
        self.most_recent = most_recent
        self.notary_commission_expiration_date = notary_commission_expiration_date
        self.notary_sign_date = notary_sign_date
        self.notary_sign_name = notary_sign_name
        if office_total_ytd is not None:
            self.office_total_ytd = office_total_ytd
        if original_sub_id is not None:
            self.original_sub_id = original_sub_id
        self.payee_city = payee_city
        self.payee_first_name = payee_first_name
        self.payee_last_name = payee_last_name
        self.payee_middle_name = payee_middle_name
        self.payee_name = payee_name
        self.payee_prefix = payee_prefix
        self.payee_state = payee_state
        self.payee_street_1 = payee_street_1
        self.payee_street_2 = payee_street_2
        self.payee_suffix = payee_suffix
        self.payee_zip = payee_zip
        self.pdf_url = pdf_url
        self.previous_file_number = previous_file_number
        self.report_type = report_type
        self.report_year = report_year
        self.schedule_type = schedule_type
        self.schedule_type_full = schedule_type_full
        if sub_id is not None:
            self.sub_id = sub_id
        self.support_oppose_indicator = support_oppose_indicator
        self.transaction_id = transaction_id

    @property
    def action_code(self):
        """Gets the action_code of this ScheduleE.  # noqa: E501


        :return: The action_code of this ScheduleE.  # noqa: E501
        :rtype: str
        """
        return self._action_code

    @action_code.setter
    def action_code(self, action_code):
        """Sets the action_code of this ScheduleE.


        :param action_code: The action_code of this ScheduleE.  # noqa: E501
        :type: str
        """

        self._action_code = action_code

    @property
    def action_code_full(self):
        """Gets the action_code_full of this ScheduleE.  # noqa: E501


        :return: The action_code_full of this ScheduleE.  # noqa: E501
        :rtype: str
        """
        return self._action_code_full

    @action_code_full.setter
    def action_code_full(self, action_code_full):
        """Sets the action_code_full of this ScheduleE.


        :param action_code_full: The action_code_full of this ScheduleE.  # noqa: E501
        :type: str
        """

        self._action_code_full = action_code_full

    @property
    def amendment_indicator(self):
        """Gets the amendment_indicator of this ScheduleE.  # noqa: E501

        Amendent types:     -N   new     -A   amendment     -T   terminated     -C   consolidated     -M   multi-candidate     -S   secondary  NULL might be new or amendment. If amendment indicator is null and the filings is the first or first in a chain treat it as if it was a new. If it is not the first or first in a chain then treat the filing as an amendment.   # noqa: E501

        :return: The amendment_indicator of this ScheduleE.  # noqa: E501
        :rtype: str
        """
        return self._amendment_indicator

    @amendment_indicator.setter
    def amendment_indicator(self, amendment_indicator):
        """Sets the amendment_indicator of this ScheduleE.

        Amendent types:     -N   new     -A   amendment     -T   terminated     -C   consolidated     -M   multi-candidate     -S   secondary  NULL might be new or amendment. If amendment indicator is null and the filings is the first or first in a chain treat it as if it was a new. If it is not the first or first in a chain then treat the filing as an amendment.   # noqa: E501

        :param amendment_indicator: The amendment_indicator of this ScheduleE.  # noqa: E501
        :type: str
        """

        self._amendment_indicator = amendment_indicator

    @property
    def amendment_number(self):
        """Gets the amendment_number of this ScheduleE.  # noqa: E501

         Number of times the report has been amended.   # noqa: E501

        :return: The amendment_number of this ScheduleE.  # noqa: E501
        :rtype: int
        """
        return self._amendment_number

    @amendment_number.setter
    def amendment_number(self, amendment_number):
        """Sets the amendment_number of this ScheduleE.

         Number of times the report has been amended.   # noqa: E501

        :param amendment_number: The amendment_number of this ScheduleE.  # noqa: E501
        :type: int
        """

        self._amendment_number = amendment_number

    @property
    def back_reference_schedule_name(self):
        """Gets the back_reference_schedule_name of this ScheduleE.  # noqa: E501


        :return: The back_reference_schedule_name of this ScheduleE.  # noqa: E501
        :rtype: str
        """
        return self._back_reference_schedule_name

    @back_reference_schedule_name.setter
    def back_reference_schedule_name(self, back_reference_schedule_name):
        """Sets the back_reference_schedule_name of this ScheduleE.


        :param back_reference_schedule_name: The back_reference_schedule_name of this ScheduleE.  # noqa: E501
        :type: str
        """

        self._back_reference_schedule_name = back_reference_schedule_name

    @property
    def back_reference_transaction_id(self):
        """Gets the back_reference_transaction_id of this ScheduleE.  # noqa: E501


        :return: The back_reference_transaction_id of this ScheduleE.  # noqa: E501
        :rtype: str
        """
        return self._back_reference_transaction_id

    @back_reference_transaction_id.setter
    def back_reference_transaction_id(self, back_reference_transaction_id):
        """Sets the back_reference_transaction_id of this ScheduleE.


        :param back_reference_transaction_id: The back_reference_transaction_id of this ScheduleE.  # noqa: E501
        :type: str
        """

        self._back_reference_transaction_id = back_reference_transaction_id

    @property
    def candidate(self):
        """Gets the candidate of this ScheduleE.  # noqa: E501


        :return: The candidate of this ScheduleE.  # noqa: E501
        :rtype: str
        """
        return self._candidate

    @candidate.setter
    def candidate(self, candidate):
        """Sets the candidate of this ScheduleE.


        :param candidate: The candidate of this ScheduleE.  # noqa: E501
        :type: str
        """

        self._candidate = candidate

    @property
    def candidate_first_name(self):
        """Gets the candidate_first_name of this ScheduleE.  # noqa: E501


        :return: The candidate_first_name of this ScheduleE.  # noqa: E501
        :rtype: str
        """
        return self._candidate_first_name

    @candidate_first_name.setter
    def candidate_first_name(self, candidate_first_name):
        """Sets the candidate_first_name of this ScheduleE.


        :param candidate_first_name: The candidate_first_name of this ScheduleE.  # noqa: E501
        :type: str
        """

        self._candidate_first_name = candidate_first_name

    @property
    def candidate_id(self):
        """Gets the candidate_id of this ScheduleE.  # noqa: E501


        :return: The candidate_id of this ScheduleE.  # noqa: E501
        :rtype: str
        """
        return self._candidate_id

    @candidate_id.setter
    def candidate_id(self, candidate_id):
        """Sets the candidate_id of this ScheduleE.


        :param candidate_id: The candidate_id of this ScheduleE.  # noqa: E501
        :type: str
        """

        self._candidate_id = candidate_id

    @property
    def candidate_last_name(self):
        """Gets the candidate_last_name of this ScheduleE.  # noqa: E501


        :return: The candidate_last_name of this ScheduleE.  # noqa: E501
        :rtype: str
        """
        return self._candidate_last_name

    @candidate_last_name.setter
    def candidate_last_name(self, candidate_last_name):
        """Sets the candidate_last_name of this ScheduleE.


        :param candidate_last_name: The candidate_last_name of this ScheduleE.  # noqa: E501
        :type: str
        """

        self._candidate_last_name = candidate_last_name

    @property
    def candidate_middle_name(self):
        """Gets the candidate_middle_name of this ScheduleE.  # noqa: E501


        :return: The candidate_middle_name of this ScheduleE.  # noqa: E501
        :rtype: str
        """
        return self._candidate_middle_name

    @candidate_middle_name.setter
    def candidate_middle_name(self, candidate_middle_name):
        """Sets the candidate_middle_name of this ScheduleE.


        :param candidate_middle_name: The candidate_middle_name of this ScheduleE.  # noqa: E501
        :type: str
        """

        self._candidate_middle_name = candidate_middle_name

    @property
    def candidate_name(self):
        """Gets the candidate_name of this ScheduleE.  # noqa: E501

        Name of candidate running for office  # noqa: E501

        :return: The candidate_name of this ScheduleE.  # noqa: E501
        :rtype: str
        """
        return self._candidate_name

    @candidate_name.setter
    def candidate_name(self, candidate_name):
        """Sets the candidate_name of this ScheduleE.

        Name of candidate running for office  # noqa: E501

        :param candidate_name: The candidate_name of this ScheduleE.  # noqa: E501
        :type: str
        """

        self._candidate_name = candidate_name

    @property
    def candidate_office(self):
        """Gets the candidate_office of this ScheduleE.  # noqa: E501

        Federal office candidate runs for: H, S or P  # noqa: E501

        :return: The candidate_office of this ScheduleE.  # noqa: E501
        :rtype: str
        """
        return self._candidate_office

    @candidate_office.setter
    def candidate_office(self, candidate_office):
        """Sets the candidate_office of this ScheduleE.

        Federal office candidate runs for: H, S or P  # noqa: E501

        :param candidate_office: The candidate_office of this ScheduleE.  # noqa: E501
        :type: str
        """

        self._candidate_office = candidate_office

    @property
    def candidate_office_district(self):
        """Gets the candidate_office_district of this ScheduleE.  # noqa: E501

        Two-digit US House distirict of the office the candidate is running for. Presidential, Senate and House at-large candidates will have District 00.  # noqa: E501

        :return: The candidate_office_district of this ScheduleE.  # noqa: E501
        :rtype: str
        """
        return self._candidate_office_district

    @candidate_office_district.setter
    def candidate_office_district(self, candidate_office_district):
        """Sets the candidate_office_district of this ScheduleE.

        Two-digit US House distirict of the office the candidate is running for. Presidential, Senate and House at-large candidates will have District 00.  # noqa: E501

        :param candidate_office_district: The candidate_office_district of this ScheduleE.  # noqa: E501
        :type: str
        """

        self._candidate_office_district = candidate_office_district

    @property
    def candidate_office_state(self):
        """Gets the candidate_office_state of this ScheduleE.  # noqa: E501

        US state or territory  # noqa: E501

        :return: The candidate_office_state of this ScheduleE.  # noqa: E501
        :rtype: str
        """
        return self._candidate_office_state

    @candidate_office_state.setter
    def candidate_office_state(self, candidate_office_state):
        """Sets the candidate_office_state of this ScheduleE.

        US state or territory  # noqa: E501

        :param candidate_office_state: The candidate_office_state of this ScheduleE.  # noqa: E501
        :type: str
        """

        self._candidate_office_state = candidate_office_state

    @property
    def candidate_party(self):
        """Gets the candidate_party of this ScheduleE.  # noqa: E501

        Three-letter code for the party affiliated with a candidate or committee. For example, DEM for Democratic Party and REP for Republican Party.  # noqa: E501

        :return: The candidate_party of this ScheduleE.  # noqa: E501
        :rtype: str
        """
        return self._candidate_party

    @candidate_party.setter
    def candidate_party(self, candidate_party):
        """Sets the candidate_party of this ScheduleE.

        Three-letter code for the party affiliated with a candidate or committee. For example, DEM for Democratic Party and REP for Republican Party.  # noqa: E501

        :param candidate_party: The candidate_party of this ScheduleE.  # noqa: E501
        :type: str
        """

        self._candidate_party = candidate_party

    @property
    def candidate_prefix(self):
        """Gets the candidate_prefix of this ScheduleE.  # noqa: E501


        :return: The candidate_prefix of this ScheduleE.  # noqa: E501
        :rtype: str
        """
        return self._candidate_prefix

    @candidate_prefix.setter
    def candidate_prefix(self, candidate_prefix):
        """Sets the candidate_prefix of this ScheduleE.


        :param candidate_prefix: The candidate_prefix of this ScheduleE.  # noqa: E501
        :type: str
        """

        self._candidate_prefix = candidate_prefix

    @property
    def candidate_suffix(self):
        """Gets the candidate_suffix of this ScheduleE.  # noqa: E501


        :return: The candidate_suffix of this ScheduleE.  # noqa: E501
        :rtype: str
        """
        return self._candidate_suffix

    @candidate_suffix.setter
    def candidate_suffix(self, candidate_suffix):
        """Sets the candidate_suffix of this ScheduleE.


        :param candidate_suffix: The candidate_suffix of this ScheduleE.  # noqa: E501
        :type: str
        """

        self._candidate_suffix = candidate_suffix

    @property
    def category_code(self):
        """Gets the category_code of this ScheduleE.  # noqa: E501


        :return: The category_code of this ScheduleE.  # noqa: E501
        :rtype: str
        """
        return self._category_code

    @category_code.setter
    def category_code(self, category_code):
        """Sets the category_code of this ScheduleE.


        :param category_code: The category_code of this ScheduleE.  # noqa: E501
        :type: str
        """

        self._category_code = category_code

    @property
    def category_code_full(self):
        """Gets the category_code_full of this ScheduleE.  # noqa: E501


        :return: The category_code_full of this ScheduleE.  # noqa: E501
        :rtype: str
        """
        return self._category_code_full

    @category_code_full.setter
    def category_code_full(self, category_code_full):
        """Sets the category_code_full of this ScheduleE.


        :param category_code_full: The category_code_full of this ScheduleE.  # noqa: E501
        :type: str
        """

        self._category_code_full = category_code_full

    @property
    def committee(self):
        """Gets the committee of this ScheduleE.  # noqa: E501


        :return: The committee of this ScheduleE.  # noqa: E501
        :rtype: CommitteeHistory
        """
        return self._committee

    @committee.setter
    def committee(self, committee):
        """Sets the committee of this ScheduleE.


        :param committee: The committee of this ScheduleE.  # noqa: E501
        :type: CommitteeHistory
        """

        self._committee = committee

    @property
    def committee_id(self):
        """Gets the committee_id of this ScheduleE.  # noqa: E501

         A unique identifier assigned to each committee or filer registered with the FEC. In general committee id's begin with the letter C which is followed by eight digits.   # noqa: E501

        :return: The committee_id of this ScheduleE.  # noqa: E501
        :rtype: str
        """
        return self._committee_id

    @committee_id.setter
    def committee_id(self, committee_id):
        """Sets the committee_id of this ScheduleE.

         A unique identifier assigned to each committee or filer registered with the FEC. In general committee id's begin with the letter C which is followed by eight digits.   # noqa: E501

        :param committee_id: The committee_id of this ScheduleE.  # noqa: E501
        :type: str
        """

        self._committee_id = committee_id

    @property
    def conduit_committee_city(self):
        """Gets the conduit_committee_city of this ScheduleE.  # noqa: E501


        :return: The conduit_committee_city of this ScheduleE.  # noqa: E501
        :rtype: str
        """
        return self._conduit_committee_city

    @conduit_committee_city.setter
    def conduit_committee_city(self, conduit_committee_city):
        """Sets the conduit_committee_city of this ScheduleE.


        :param conduit_committee_city: The conduit_committee_city of this ScheduleE.  # noqa: E501
        :type: str
        """

        self._conduit_committee_city = conduit_committee_city

    @property
    def conduit_committee_id(self):
        """Gets the conduit_committee_id of this ScheduleE.  # noqa: E501


        :return: The conduit_committee_id of this ScheduleE.  # noqa: E501
        :rtype: str
        """
        return self._conduit_committee_id

    @conduit_committee_id.setter
    def conduit_committee_id(self, conduit_committee_id):
        """Sets the conduit_committee_id of this ScheduleE.


        :param conduit_committee_id: The conduit_committee_id of this ScheduleE.  # noqa: E501
        :type: str
        """

        self._conduit_committee_id = conduit_committee_id

    @property
    def conduit_committee_name(self):
        """Gets the conduit_committee_name of this ScheduleE.  # noqa: E501


        :return: The conduit_committee_name of this ScheduleE.  # noqa: E501
        :rtype: str
        """
        return self._conduit_committee_name

    @conduit_committee_name.setter
    def conduit_committee_name(self, conduit_committee_name):
        """Sets the conduit_committee_name of this ScheduleE.


        :param conduit_committee_name: The conduit_committee_name of this ScheduleE.  # noqa: E501
        :type: str
        """

        self._conduit_committee_name = conduit_committee_name

    @property
    def conduit_committee_state(self):
        """Gets the conduit_committee_state of this ScheduleE.  # noqa: E501


        :return: The conduit_committee_state of this ScheduleE.  # noqa: E501
        :rtype: str
        """
        return self._conduit_committee_state

    @conduit_committee_state.setter
    def conduit_committee_state(self, conduit_committee_state):
        """Sets the conduit_committee_state of this ScheduleE.


        :param conduit_committee_state: The conduit_committee_state of this ScheduleE.  # noqa: E501
        :type: str
        """

        self._conduit_committee_state = conduit_committee_state

    @property
    def conduit_committee_street1(self):
        """Gets the conduit_committee_street1 of this ScheduleE.  # noqa: E501


        :return: The conduit_committee_street1 of this ScheduleE.  # noqa: E501
        :rtype: str
        """
        return self._conduit_committee_street1

    @conduit_committee_street1.setter
    def conduit_committee_street1(self, conduit_committee_street1):
        """Sets the conduit_committee_street1 of this ScheduleE.


        :param conduit_committee_street1: The conduit_committee_street1 of this ScheduleE.  # noqa: E501
        :type: str
        """

        self._conduit_committee_street1 = conduit_committee_street1

    @property
    def conduit_committee_street2(self):
        """Gets the conduit_committee_street2 of this ScheduleE.  # noqa: E501


        :return: The conduit_committee_street2 of this ScheduleE.  # noqa: E501
        :rtype: str
        """
        return self._conduit_committee_street2

    @conduit_committee_street2.setter
    def conduit_committee_street2(self, conduit_committee_street2):
        """Sets the conduit_committee_street2 of this ScheduleE.


        :param conduit_committee_street2: The conduit_committee_street2 of this ScheduleE.  # noqa: E501
        :type: str
        """

        self._conduit_committee_street2 = conduit_committee_street2

    @property
    def conduit_committee_zip(self):
        """Gets the conduit_committee_zip of this ScheduleE.  # noqa: E501


        :return: The conduit_committee_zip of this ScheduleE.  # noqa: E501
        :rtype: int
        """
        return self._conduit_committee_zip

    @conduit_committee_zip.setter
    def conduit_committee_zip(self, conduit_committee_zip):
        """Sets the conduit_committee_zip of this ScheduleE.


        :param conduit_committee_zip: The conduit_committee_zip of this ScheduleE.  # noqa: E501
        :type: int
        """

        self._conduit_committee_zip = conduit_committee_zip

    @property
    def dissemination_date(self):
        """Gets the dissemination_date of this ScheduleE.  # noqa: E501


        :return: The dissemination_date of this ScheduleE.  # noqa: E501
        :rtype: date
        """
        return self._dissemination_date

    @dissemination_date.setter
    def dissemination_date(self, dissemination_date):
        """Sets the dissemination_date of this ScheduleE.


        :param dissemination_date: The dissemination_date of this ScheduleE.  # noqa: E501
        :type: date
        """

        self._dissemination_date = dissemination_date

    @property
    def election_type(self):
        """Gets the election_type of this ScheduleE.  # noqa: E501

        Election type  Convention, Primary, General, Special, Runoff etc.   # noqa: E501

        :return: The election_type of this ScheduleE.  # noqa: E501
        :rtype: str
        """
        return self._election_type

    @election_type.setter
    def election_type(self, election_type):
        """Sets the election_type of this ScheduleE.

        Election type  Convention, Primary, General, Special, Runoff etc.   # noqa: E501

        :param election_type: The election_type of this ScheduleE.  # noqa: E501
        :type: str
        """

        self._election_type = election_type

    @property
    def election_type_full(self):
        """Gets the election_type_full of this ScheduleE.  # noqa: E501

        Election type  Convention, Primary, General, Special, Runoff etc.   # noqa: E501

        :return: The election_type_full of this ScheduleE.  # noqa: E501
        :rtype: str
        """
        return self._election_type_full

    @election_type_full.setter
    def election_type_full(self, election_type_full):
        """Sets the election_type_full of this ScheduleE.

        Election type  Convention, Primary, General, Special, Runoff etc.   # noqa: E501

        :param election_type_full: The election_type_full of this ScheduleE.  # noqa: E501
        :type: str
        """

        self._election_type_full = election_type_full

    @property
    def expenditure_amount(self):
        """Gets the expenditure_amount of this ScheduleE.  # noqa: E501


        :return: The expenditure_amount of this ScheduleE.  # noqa: E501
        :rtype: float
        """
        return self._expenditure_amount

    @expenditure_amount.setter
    def expenditure_amount(self, expenditure_amount):
        """Sets the expenditure_amount of this ScheduleE.


        :param expenditure_amount: The expenditure_amount of this ScheduleE.  # noqa: E501
        :type: float
        """

        self._expenditure_amount = expenditure_amount

    @property
    def expenditure_date(self):
        """Gets the expenditure_date of this ScheduleE.  # noqa: E501


        :return: The expenditure_date of this ScheduleE.  # noqa: E501
        :rtype: date
        """
        return self._expenditure_date

    @expenditure_date.setter
    def expenditure_date(self, expenditure_date):
        """Sets the expenditure_date of this ScheduleE.


        :param expenditure_date: The expenditure_date of this ScheduleE.  # noqa: E501
        :type: date
        """

        self._expenditure_date = expenditure_date

    @property
    def expenditure_description(self):
        """Gets the expenditure_description of this ScheduleE.  # noqa: E501


        :return: The expenditure_description of this ScheduleE.  # noqa: E501
        :rtype: str
        """
        return self._expenditure_description

    @expenditure_description.setter
    def expenditure_description(self, expenditure_description):
        """Sets the expenditure_description of this ScheduleE.


        :param expenditure_description: The expenditure_description of this ScheduleE.  # noqa: E501
        :type: str
        """

        self._expenditure_description = expenditure_description

    @property
    def file_number(self):
        """Gets the file_number of this ScheduleE.  # noqa: E501


        :return: The file_number of this ScheduleE.  # noqa: E501
        :rtype: int
        """
        return self._file_number

    @file_number.setter
    def file_number(self, file_number):
        """Sets the file_number of this ScheduleE.


        :param file_number: The file_number of this ScheduleE.  # noqa: E501
        :type: int
        """

        self._file_number = file_number

    @property
    def filer_first_name(self):
        """Gets the filer_first_name of this ScheduleE.  # noqa: E501


        :return: The filer_first_name of this ScheduleE.  # noqa: E501
        :rtype: str
        """
        return self._filer_first_name

    @filer_first_name.setter
    def filer_first_name(self, filer_first_name):
        """Sets the filer_first_name of this ScheduleE.


        :param filer_first_name: The filer_first_name of this ScheduleE.  # noqa: E501
        :type: str
        """

        self._filer_first_name = filer_first_name

    @property
    def filer_last_name(self):
        """Gets the filer_last_name of this ScheduleE.  # noqa: E501


        :return: The filer_last_name of this ScheduleE.  # noqa: E501
        :rtype: str
        """
        return self._filer_last_name

    @filer_last_name.setter
    def filer_last_name(self, filer_last_name):
        """Sets the filer_last_name of this ScheduleE.


        :param filer_last_name: The filer_last_name of this ScheduleE.  # noqa: E501
        :type: str
        """

        self._filer_last_name = filer_last_name

    @property
    def filer_middle_name(self):
        """Gets the filer_middle_name of this ScheduleE.  # noqa: E501


        :return: The filer_middle_name of this ScheduleE.  # noqa: E501
        :rtype: str
        """
        return self._filer_middle_name

    @filer_middle_name.setter
    def filer_middle_name(self, filer_middle_name):
        """Sets the filer_middle_name of this ScheduleE.


        :param filer_middle_name: The filer_middle_name of this ScheduleE.  # noqa: E501
        :type: str
        """

        self._filer_middle_name = filer_middle_name

    @property
    def filer_prefix(self):
        """Gets the filer_prefix of this ScheduleE.  # noqa: E501


        :return: The filer_prefix of this ScheduleE.  # noqa: E501
        :rtype: str
        """
        return self._filer_prefix

    @filer_prefix.setter
    def filer_prefix(self, filer_prefix):
        """Sets the filer_prefix of this ScheduleE.


        :param filer_prefix: The filer_prefix of this ScheduleE.  # noqa: E501
        :type: str
        """

        self._filer_prefix = filer_prefix

    @property
    def filer_suffix(self):
        """Gets the filer_suffix of this ScheduleE.  # noqa: E501


        :return: The filer_suffix of this ScheduleE.  # noqa: E501
        :rtype: str
        """
        return self._filer_suffix

    @filer_suffix.setter
    def filer_suffix(self, filer_suffix):
        """Sets the filer_suffix of this ScheduleE.


        :param filer_suffix: The filer_suffix of this ScheduleE.  # noqa: E501
        :type: str
        """

        self._filer_suffix = filer_suffix

    @property
    def filing_date(self):
        """Gets the filing_date of this ScheduleE.  # noqa: E501


        :return: The filing_date of this ScheduleE.  # noqa: E501
        :rtype: date
        """
        return self._filing_date

    @filing_date.setter
    def filing_date(self, filing_date):
        """Sets the filing_date of this ScheduleE.


        :param filing_date: The filing_date of this ScheduleE.  # noqa: E501
        :type: date
        """

        self._filing_date = filing_date

    @property
    def filing_form(self):
        """Gets the filing_form of this ScheduleE.  # noqa: E501


        :return: The filing_form of this ScheduleE.  # noqa: E501
        :rtype: str
        """
        return self._filing_form

    @filing_form.setter
    def filing_form(self, filing_form):
        """Sets the filing_form of this ScheduleE.


        :param filing_form: The filing_form of this ScheduleE.  # noqa: E501
        :type: str
        """

        self._filing_form = filing_form

    @property
    def image_number(self):
        """Gets the image_number of this ScheduleE.  # noqa: E501


        :return: The image_number of this ScheduleE.  # noqa: E501
        :rtype: str
        """
        return self._image_number

    @image_number.setter
    def image_number(self, image_number):
        """Sets the image_number of this ScheduleE.


        :param image_number: The image_number of this ScheduleE.  # noqa: E501
        :type: str
        """

        self._image_number = image_number

    @property
    def independent_sign_date(self):
        """Gets the independent_sign_date of this ScheduleE.  # noqa: E501


        :return: The independent_sign_date of this ScheduleE.  # noqa: E501
        :rtype: date
        """
        return self._independent_sign_date

    @independent_sign_date.setter
    def independent_sign_date(self, independent_sign_date):
        """Sets the independent_sign_date of this ScheduleE.


        :param independent_sign_date: The independent_sign_date of this ScheduleE.  # noqa: E501
        :type: date
        """

        self._independent_sign_date = independent_sign_date

    @property
    def independent_sign_name(self):
        """Gets the independent_sign_name of this ScheduleE.  # noqa: E501


        :return: The independent_sign_name of this ScheduleE.  # noqa: E501
        :rtype: str
        """
        return self._independent_sign_name

    @independent_sign_name.setter
    def independent_sign_name(self, independent_sign_name):
        """Sets the independent_sign_name of this ScheduleE.


        :param independent_sign_name: The independent_sign_name of this ScheduleE.  # noqa: E501
        :type: str
        """

        self._independent_sign_name = independent_sign_name

    @property
    def is_notice(self):
        """Gets the is_notice of this ScheduleE.  # noqa: E501


        :return: The is_notice of this ScheduleE.  # noqa: E501
        :rtype: bool
        """
        return self._is_notice

    @is_notice.setter
    def is_notice(self, is_notice):
        """Sets the is_notice of this ScheduleE.


        :param is_notice: The is_notice of this ScheduleE.  # noqa: E501
        :type: bool
        """

        self._is_notice = is_notice

    @property
    def line_number(self):
        """Gets the line_number of this ScheduleE.  # noqa: E501


        :return: The line_number of this ScheduleE.  # noqa: E501
        :rtype: str
        """
        return self._line_number

    @line_number.setter
    def line_number(self, line_number):
        """Sets the line_number of this ScheduleE.


        :param line_number: The line_number of this ScheduleE.  # noqa: E501
        :type: str
        """

        self._line_number = line_number

    @property
    def link_id(self):
        """Gets the link_id of this ScheduleE.  # noqa: E501


        :return: The link_id of this ScheduleE.  # noqa: E501
        :rtype: int
        """
        return self._link_id

    @link_id.setter
    def link_id(self, link_id):
        """Sets the link_id of this ScheduleE.


        :param link_id: The link_id of this ScheduleE.  # noqa: E501
        :type: int
        """

        self._link_id = link_id

    @property
    def memo_code(self):
        """Gets the memo_code of this ScheduleE.  # noqa: E501


        :return: The memo_code of this ScheduleE.  # noqa: E501
        :rtype: str
        """
        return self._memo_code

    @memo_code.setter
    def memo_code(self, memo_code):
        """Sets the memo_code of this ScheduleE.


        :param memo_code: The memo_code of this ScheduleE.  # noqa: E501
        :type: str
        """

        self._memo_code = memo_code

    @property
    def memo_code_full(self):
        """Gets the memo_code_full of this ScheduleE.  # noqa: E501


        :return: The memo_code_full of this ScheduleE.  # noqa: E501
        :rtype: str
        """
        return self._memo_code_full

    @memo_code_full.setter
    def memo_code_full(self, memo_code_full):
        """Sets the memo_code_full of this ScheduleE.


        :param memo_code_full: The memo_code_full of this ScheduleE.  # noqa: E501
        :type: str
        """

        self._memo_code_full = memo_code_full

    @property
    def memo_text(self):
        """Gets the memo_text of this ScheduleE.  # noqa: E501


        :return: The memo_text of this ScheduleE.  # noqa: E501
        :rtype: str
        """
        return self._memo_text

    @memo_text.setter
    def memo_text(self, memo_text):
        """Sets the memo_text of this ScheduleE.


        :param memo_text: The memo_text of this ScheduleE.  # noqa: E501
        :type: str
        """

        self._memo_text = memo_text

    @property
    def memoed_subtotal(self):
        """Gets the memoed_subtotal of this ScheduleE.  # noqa: E501


        :return: The memoed_subtotal of this ScheduleE.  # noqa: E501
        :rtype: bool
        """
        return self._memoed_subtotal

    @memoed_subtotal.setter
    def memoed_subtotal(self, memoed_subtotal):
        """Sets the memoed_subtotal of this ScheduleE.


        :param memoed_subtotal: The memoed_subtotal of this ScheduleE.  # noqa: E501
        :type: bool
        """

        self._memoed_subtotal = memoed_subtotal

    @property
    def most_recent(self):
        """Gets the most_recent of this ScheduleE.  # noqa: E501

         Report is either new or is the most-recently filed amendment   # noqa: E501

        :return: The most_recent of this ScheduleE.  # noqa: E501
        :rtype: bool
        """
        return self._most_recent

    @most_recent.setter
    def most_recent(self, most_recent):
        """Sets the most_recent of this ScheduleE.

         Report is either new or is the most-recently filed amendment   # noqa: E501

        :param most_recent: The most_recent of this ScheduleE.  # noqa: E501
        :type: bool
        """

        self._most_recent = most_recent

    @property
    def notary_commission_expiration_date(self):
        """Gets the notary_commission_expiration_date of this ScheduleE.  # noqa: E501


        :return: The notary_commission_expiration_date of this ScheduleE.  # noqa: E501
        :rtype: date
        """
        return self._notary_commission_expiration_date

    @notary_commission_expiration_date.setter
    def notary_commission_expiration_date(self, notary_commission_expiration_date):
        """Sets the notary_commission_expiration_date of this ScheduleE.


        :param notary_commission_expiration_date: The notary_commission_expiration_date of this ScheduleE.  # noqa: E501
        :type: date
        """

        self._notary_commission_expiration_date = notary_commission_expiration_date

    @property
    def notary_sign_date(self):
        """Gets the notary_sign_date of this ScheduleE.  # noqa: E501


        :return: The notary_sign_date of this ScheduleE.  # noqa: E501
        :rtype: date
        """
        return self._notary_sign_date

    @notary_sign_date.setter
    def notary_sign_date(self, notary_sign_date):
        """Sets the notary_sign_date of this ScheduleE.


        :param notary_sign_date: The notary_sign_date of this ScheduleE.  # noqa: E501
        :type: date
        """

        self._notary_sign_date = notary_sign_date

    @property
    def notary_sign_name(self):
        """Gets the notary_sign_name of this ScheduleE.  # noqa: E501


        :return: The notary_sign_name of this ScheduleE.  # noqa: E501
        :rtype: str
        """
        return self._notary_sign_name

    @notary_sign_name.setter
    def notary_sign_name(self, notary_sign_name):
        """Sets the notary_sign_name of this ScheduleE.


        :param notary_sign_name: The notary_sign_name of this ScheduleE.  # noqa: E501
        :type: str
        """

        self._notary_sign_name = notary_sign_name

    @property
    def office_total_ytd(self):
        """Gets the office_total_ytd of this ScheduleE.  # noqa: E501


        :return: The office_total_ytd of this ScheduleE.  # noqa: E501
        :rtype: float
        """
        return self._office_total_ytd

    @office_total_ytd.setter
    def office_total_ytd(self, office_total_ytd):
        """Sets the office_total_ytd of this ScheduleE.


        :param office_total_ytd: The office_total_ytd of this ScheduleE.  # noqa: E501
        :type: float
        """

        self._office_total_ytd = office_total_ytd

    @property
    def original_sub_id(self):
        """Gets the original_sub_id of this ScheduleE.  # noqa: E501


        :return: The original_sub_id of this ScheduleE.  # noqa: E501
        :rtype: str
        """
        return self._original_sub_id

    @original_sub_id.setter
    def original_sub_id(self, original_sub_id):
        """Sets the original_sub_id of this ScheduleE.


        :param original_sub_id: The original_sub_id of this ScheduleE.  # noqa: E501
        :type: str
        """

        self._original_sub_id = original_sub_id

    @property
    def payee_city(self):
        """Gets the payee_city of this ScheduleE.  # noqa: E501


        :return: The payee_city of this ScheduleE.  # noqa: E501
        :rtype: str
        """
        return self._payee_city

    @payee_city.setter
    def payee_city(self, payee_city):
        """Sets the payee_city of this ScheduleE.


        :param payee_city: The payee_city of this ScheduleE.  # noqa: E501
        :type: str
        """

        self._payee_city = payee_city

    @property
    def payee_first_name(self):
        """Gets the payee_first_name of this ScheduleE.  # noqa: E501


        :return: The payee_first_name of this ScheduleE.  # noqa: E501
        :rtype: str
        """
        return self._payee_first_name

    @payee_first_name.setter
    def payee_first_name(self, payee_first_name):
        """Sets the payee_first_name of this ScheduleE.


        :param payee_first_name: The payee_first_name of this ScheduleE.  # noqa: E501
        :type: str
        """

        self._payee_first_name = payee_first_name

    @property
    def payee_last_name(self):
        """Gets the payee_last_name of this ScheduleE.  # noqa: E501


        :return: The payee_last_name of this ScheduleE.  # noqa: E501
        :rtype: str
        """
        return self._payee_last_name

    @payee_last_name.setter
    def payee_last_name(self, payee_last_name):
        """Sets the payee_last_name of this ScheduleE.


        :param payee_last_name: The payee_last_name of this ScheduleE.  # noqa: E501
        :type: str
        """

        self._payee_last_name = payee_last_name

    @property
    def payee_middle_name(self):
        """Gets the payee_middle_name of this ScheduleE.  # noqa: E501


        :return: The payee_middle_name of this ScheduleE.  # noqa: E501
        :rtype: str
        """
        return self._payee_middle_name

    @payee_middle_name.setter
    def payee_middle_name(self, payee_middle_name):
        """Sets the payee_middle_name of this ScheduleE.


        :param payee_middle_name: The payee_middle_name of this ScheduleE.  # noqa: E501
        :type: str
        """

        self._payee_middle_name = payee_middle_name

    @property
    def payee_name(self):
        """Gets the payee_name of this ScheduleE.  # noqa: E501


        :return: The payee_name of this ScheduleE.  # noqa: E501
        :rtype: str
        """
        return self._payee_name

    @payee_name.setter
    def payee_name(self, payee_name):
        """Sets the payee_name of this ScheduleE.


        :param payee_name: The payee_name of this ScheduleE.  # noqa: E501
        :type: str
        """

        self._payee_name = payee_name

    @property
    def payee_prefix(self):
        """Gets the payee_prefix of this ScheduleE.  # noqa: E501


        :return: The payee_prefix of this ScheduleE.  # noqa: E501
        :rtype: str
        """
        return self._payee_prefix

    @payee_prefix.setter
    def payee_prefix(self, payee_prefix):
        """Sets the payee_prefix of this ScheduleE.


        :param payee_prefix: The payee_prefix of this ScheduleE.  # noqa: E501
        :type: str
        """

        self._payee_prefix = payee_prefix

    @property
    def payee_state(self):
        """Gets the payee_state of this ScheduleE.  # noqa: E501


        :return: The payee_state of this ScheduleE.  # noqa: E501
        :rtype: str
        """
        return self._payee_state

    @payee_state.setter
    def payee_state(self, payee_state):
        """Sets the payee_state of this ScheduleE.


        :param payee_state: The payee_state of this ScheduleE.  # noqa: E501
        :type: str
        """

        self._payee_state = payee_state

    @property
    def payee_street_1(self):
        """Gets the payee_street_1 of this ScheduleE.  # noqa: E501


        :return: The payee_street_1 of this ScheduleE.  # noqa: E501
        :rtype: str
        """
        return self._payee_street_1

    @payee_street_1.setter
    def payee_street_1(self, payee_street_1):
        """Sets the payee_street_1 of this ScheduleE.


        :param payee_street_1: The payee_street_1 of this ScheduleE.  # noqa: E501
        :type: str
        """

        self._payee_street_1 = payee_street_1

    @property
    def payee_street_2(self):
        """Gets the payee_street_2 of this ScheduleE.  # noqa: E501


        :return: The payee_street_2 of this ScheduleE.  # noqa: E501
        :rtype: str
        """
        return self._payee_street_2

    @payee_street_2.setter
    def payee_street_2(self, payee_street_2):
        """Sets the payee_street_2 of this ScheduleE.


        :param payee_street_2: The payee_street_2 of this ScheduleE.  # noqa: E501
        :type: str
        """

        self._payee_street_2 = payee_street_2

    @property
    def payee_suffix(self):
        """Gets the payee_suffix of this ScheduleE.  # noqa: E501


        :return: The payee_suffix of this ScheduleE.  # noqa: E501
        :rtype: str
        """
        return self._payee_suffix

    @payee_suffix.setter
    def payee_suffix(self, payee_suffix):
        """Sets the payee_suffix of this ScheduleE.


        :param payee_suffix: The payee_suffix of this ScheduleE.  # noqa: E501
        :type: str
        """

        self._payee_suffix = payee_suffix

    @property
    def payee_zip(self):
        """Gets the payee_zip of this ScheduleE.  # noqa: E501


        :return: The payee_zip of this ScheduleE.  # noqa: E501
        :rtype: str
        """
        return self._payee_zip

    @payee_zip.setter
    def payee_zip(self, payee_zip):
        """Sets the payee_zip of this ScheduleE.


        :param payee_zip: The payee_zip of this ScheduleE.  # noqa: E501
        :type: str
        """

        self._payee_zip = payee_zip

    @property
    def pdf_url(self):
        """Gets the pdf_url of this ScheduleE.  # noqa: E501


        :return: The pdf_url of this ScheduleE.  # noqa: E501
        :rtype: str
        """
        return self._pdf_url

    @pdf_url.setter
    def pdf_url(self, pdf_url):
        """Sets the pdf_url of this ScheduleE.


        :param pdf_url: The pdf_url of this ScheduleE.  # noqa: E501
        :type: str
        """

        self._pdf_url = pdf_url

    @property
    def previous_file_number(self):
        """Gets the previous_file_number of this ScheduleE.  # noqa: E501


        :return: The previous_file_number of this ScheduleE.  # noqa: E501
        :rtype: int
        """
        return self._previous_file_number

    @previous_file_number.setter
    def previous_file_number(self, previous_file_number):
        """Sets the previous_file_number of this ScheduleE.


        :param previous_file_number: The previous_file_number of this ScheduleE.  # noqa: E501
        :type: int
        """

        self._previous_file_number = previous_file_number

    @property
    def report_type(self):
        """Gets the report_type of this ScheduleE.  # noqa: E501

        Name of report where the underlying data comes from:     - 10D Pre-Election     - 10G Pre-General     - 10P Pre-Primary     - 10R Pre-Run-Off     - 10S Pre-Special     - 12C Pre-Convention     - 12G Pre-General     - 12P Pre-Primary     - 12R Pre-Run-Off     - 12S Pre-Special     - 30D Post-Election     - 30G Post-General     - 30P Post-Primary     - 30R Post-Run-Off     - 30S Post-Special     - 60D Post-Convention     - M1  January Monthly     - M10 October Monthly     - M11 November Monthly     - M12 December Monthly     - M2  February Monthly     - M3  March Monthly     - M4  April Monthly     - M5  May Monthly     - M6  June Monthly     - M7  July Monthly     - M8  August Monthly     - M9  September Monthly     - MY  Mid-Year Report     - Q1  April Quarterly     - Q2  July Quarterly     - Q3  October Quarterly     - TER Termination Report     - YE  Year-End     - ADJ COMP ADJUST AMEND     - CA  COMPREHENSIVE AMEND     - 90S Post Inaugural Supplement     - 90D Post Inaugural     - 48  48 Hour Notification     - 24  24 Hour Notification     - M7S July Monthly/Semi-Annual     - MSA Monthly Semi-Annual (MY)     - MYS Monthly Year End/Semi-Annual     - Q2S July Quarterly/Semi-Annual     - QSA Quarterly Semi-Annual (MY)     - QYS Quarterly Year End/Semi-Annual     - QYE Quarterly Semi-Annual (YE)     - QMS Quarterly Mid-Year/ Semi-Annual     - MSY Monthly Semi-Annual (YE)   # noqa: E501

        :return: The report_type of this ScheduleE.  # noqa: E501
        :rtype: str
        """
        return self._report_type

    @report_type.setter
    def report_type(self, report_type):
        """Sets the report_type of this ScheduleE.

        Name of report where the underlying data comes from:     - 10D Pre-Election     - 10G Pre-General     - 10P Pre-Primary     - 10R Pre-Run-Off     - 10S Pre-Special     - 12C Pre-Convention     - 12G Pre-General     - 12P Pre-Primary     - 12R Pre-Run-Off     - 12S Pre-Special     - 30D Post-Election     - 30G Post-General     - 30P Post-Primary     - 30R Post-Run-Off     - 30S Post-Special     - 60D Post-Convention     - M1  January Monthly     - M10 October Monthly     - M11 November Monthly     - M12 December Monthly     - M2  February Monthly     - M3  March Monthly     - M4  April Monthly     - M5  May Monthly     - M6  June Monthly     - M7  July Monthly     - M8  August Monthly     - M9  September Monthly     - MY  Mid-Year Report     - Q1  April Quarterly     - Q2  July Quarterly     - Q3  October Quarterly     - TER Termination Report     - YE  Year-End     - ADJ COMP ADJUST AMEND     - CA  COMPREHENSIVE AMEND     - 90S Post Inaugural Supplement     - 90D Post Inaugural     - 48  48 Hour Notification     - 24  24 Hour Notification     - M7S July Monthly/Semi-Annual     - MSA Monthly Semi-Annual (MY)     - MYS Monthly Year End/Semi-Annual     - Q2S July Quarterly/Semi-Annual     - QSA Quarterly Semi-Annual (MY)     - QYS Quarterly Year End/Semi-Annual     - QYE Quarterly Semi-Annual (YE)     - QMS Quarterly Mid-Year/ Semi-Annual     - MSY Monthly Semi-Annual (YE)   # noqa: E501

        :param report_type: The report_type of this ScheduleE.  # noqa: E501
        :type: str
        """

        self._report_type = report_type

    @property
    def report_year(self):
        """Gets the report_year of this ScheduleE.  # noqa: E501

         Forms with coverage date -      year from the coverage ending date. Forms without coverage date -      year from the receipt date.   # noqa: E501

        :return: The report_year of this ScheduleE.  # noqa: E501
        :rtype: int
        """
        return self._report_year

    @report_year.setter
    def report_year(self, report_year):
        """Sets the report_year of this ScheduleE.

         Forms with coverage date -      year from the coverage ending date. Forms without coverage date -      year from the receipt date.   # noqa: E501

        :param report_year: The report_year of this ScheduleE.  # noqa: E501
        :type: int
        """

        self._report_year = report_year

    @property
    def schedule_type(self):
        """Gets the schedule_type of this ScheduleE.  # noqa: E501


        :return: The schedule_type of this ScheduleE.  # noqa: E501
        :rtype: str
        """
        return self._schedule_type

    @schedule_type.setter
    def schedule_type(self, schedule_type):
        """Sets the schedule_type of this ScheduleE.


        :param schedule_type: The schedule_type of this ScheduleE.  # noqa: E501
        :type: str
        """

        self._schedule_type = schedule_type

    @property
    def schedule_type_full(self):
        """Gets the schedule_type_full of this ScheduleE.  # noqa: E501


        :return: The schedule_type_full of this ScheduleE.  # noqa: E501
        :rtype: str
        """
        return self._schedule_type_full

    @schedule_type_full.setter
    def schedule_type_full(self, schedule_type_full):
        """Sets the schedule_type_full of this ScheduleE.


        :param schedule_type_full: The schedule_type_full of this ScheduleE.  # noqa: E501
        :type: str
        """

        self._schedule_type_full = schedule_type_full

    @property
    def sub_id(self):
        """Gets the sub_id of this ScheduleE.  # noqa: E501


        :return: The sub_id of this ScheduleE.  # noqa: E501
        :rtype: str
        """
        return self._sub_id

    @sub_id.setter
    def sub_id(self, sub_id):
        """Sets the sub_id of this ScheduleE.


        :param sub_id: The sub_id of this ScheduleE.  # noqa: E501
        :type: str
        """

        self._sub_id = sub_id

    @property
    def support_oppose_indicator(self):
        """Gets the support_oppose_indicator of this ScheduleE.  # noqa: E501


        :return: The support_oppose_indicator of this ScheduleE.  # noqa: E501
        :rtype: str
        """
        return self._support_oppose_indicator

    @support_oppose_indicator.setter
    def support_oppose_indicator(self, support_oppose_indicator):
        """Sets the support_oppose_indicator of this ScheduleE.


        :param support_oppose_indicator: The support_oppose_indicator of this ScheduleE.  # noqa: E501
        :type: str
        """

        self._support_oppose_indicator = support_oppose_indicator

    @property
    def transaction_id(self):
        """Gets the transaction_id of this ScheduleE.  # noqa: E501


        :return: The transaction_id of this ScheduleE.  # noqa: E501
        :rtype: str
        """
        return self._transaction_id

    @transaction_id.setter
    def transaction_id(self, transaction_id):
        """Sets the transaction_id of this ScheduleE.


        :param transaction_id: The transaction_id of this ScheduleE.  # noqa: E501
        :type: str
        """

        self._transaction_id = transaction_id

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, 'to_dict') else x,
                    value
                ))
            elif hasattr(value, 'to_dict'):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], 'to_dict') else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ScheduleE):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, ScheduleE):
            return True

        return self.to_dict() != other.to_dict()
