# coding: utf-8

"""
    OpenFEC

    This API allows you to explore the way candidates and committees fund their campaigns.    The FEC API is a RESTful web service supporting full-text and field-specific searches on FEC data. [Bulk downloads](https://www.fec.gov/data/advanced/?tab=bulk-data) are available on the current site. Information is tied to the underlying forms by file ID and image ID. Data is updated nightly.    There is a lot of data, but a good place to start is to use search to find interesting candidates and committees. Then, you can use their IDs to find report or line item details with the other endpoints. If you are interested in individual donors, check out contributor information in schedule_a.    Get an [API key here](https://api.data.gov/signup/). That will enable you to place up to 1,000 calls an hour. Each call is limited to 100 results per page. You can email questions, comments or a request to get a key for 120 calls per minute to [APIinfo@fec.gov](mailto:apiinfo@fec.gov). You can also ask questions and discuss the data in the [FEC data Google Group](https://groups.google.com/forum/#!forum/fec-data). API changes will also be added to this group in advance of the change.    The model definitions and schema are available at [/swagger](/swagger/). This is useful for making wrappers and exploring the data.    A few restrictions limit the way you can use FEC data. For example, you can’t use contributor lists for commercial purposes or to solicit donations. [Learn more here](https://www.fec.gov/updates/sale-or-use-contributor-information/).    [View our source code](https://github.com/fecgov/openFEC). We welcome issues and pull requests!  # noqa: E501

    The version of the OpenAPI document: 1.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from openfec_sdk.configuration import Configuration


class ScheduleEEfile(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'amendment_indicator': 'str',
        'back_reference_schedule_name': 'str',
        'back_reference_transaction_id': 'str',
        'beginning_image_number': 'str',
        'candidate_first_name': 'str',
        'candidate_id': 'str',
        'candidate_middle_name': 'str',
        'candidate_name': 'str',
        'candidate_office': 'str',
        'candidate_office_district': 'str',
        'candidate_office_state': 'str',
        'candidate_party': 'str',
        'candidate_prefix': 'str',
        'candidate_suffix': 'str',
        'category_code': 'str',
        'committee': 'CommitteeHistory',
        'committee_id': 'str',
        'csv_url': 'str',
        'dissemination_date': 'date',
        'entity_type': 'str',
        'expenditure_amount': 'int',
        'expenditure_date': 'date',
        'expenditure_description': 'str',
        'fec_url': 'str',
        'file_number': 'int',
        'filer_first_name': 'str',
        'filer_last_name': 'str',
        'filer_middle_name': 'str',
        'filer_prefix': 'str',
        'filer_suffix': 'str',
        'filing': 'EFilings',
        'filing_form': 'str',
        'image_number': 'str',
        'is_notice': 'bool',
        'line_number': 'str',
        'load_timestamp': 'datetime',
        'memo_code': 'str',
        'memo_text': 'str',
        'most_recent': 'bool',
        'notary_sign_date': 'date',
        'office_total_ytd': 'float',
        'payee_city': 'str',
        'payee_first_name': 'str',
        'payee_last_name': 'str',
        'payee_middle_name': 'str',
        'payee_name': 'str',
        'payee_prefix': 'str',
        'payee_state': 'str',
        'payee_street_1': 'str',
        'payee_street_2': 'str',
        'payee_suffix': 'str',
        'payee_zip': 'str',
        'pdf_url': 'str',
        'related_line_number': 'int',
        'report_type': 'str',
        'support_oppose_indicator': 'str',
        'transaction_id': 'str'
    }

    attribute_map = {
        'amendment_indicator': 'amendment_indicator',
        'back_reference_schedule_name': 'back_reference_schedule_name',
        'back_reference_transaction_id': 'back_reference_transaction_id',
        'beginning_image_number': 'beginning_image_number',
        'candidate_first_name': 'candidate_first_name',
        'candidate_id': 'candidate_id',
        'candidate_middle_name': 'candidate_middle_name',
        'candidate_name': 'candidate_name',
        'candidate_office': 'candidate_office',
        'candidate_office_district': 'candidate_office_district',
        'candidate_office_state': 'candidate_office_state',
        'candidate_party': 'candidate_party',
        'candidate_prefix': 'candidate_prefix',
        'candidate_suffix': 'candidate_suffix',
        'category_code': 'category_code',
        'committee': 'committee',
        'committee_id': 'committee_id',
        'csv_url': 'csv_url',
        'dissemination_date': 'dissemination_date',
        'entity_type': 'entity_type',
        'expenditure_amount': 'expenditure_amount',
        'expenditure_date': 'expenditure_date',
        'expenditure_description': 'expenditure_description',
        'fec_url': 'fec_url',
        'file_number': 'file_number',
        'filer_first_name': 'filer_first_name',
        'filer_last_name': 'filer_last_name',
        'filer_middle_name': 'filer_middle_name',
        'filer_prefix': 'filer_prefix',
        'filer_suffix': 'filer_suffix',
        'filing': 'filing',
        'filing_form': 'filing_form',
        'image_number': 'image_number',
        'is_notice': 'is_notice',
        'line_number': 'line_number',
        'load_timestamp': 'load_timestamp',
        'memo_code': 'memo_code',
        'memo_text': 'memo_text',
        'most_recent': 'most_recent',
        'notary_sign_date': 'notary_sign_date',
        'office_total_ytd': 'office_total_ytd',
        'payee_city': 'payee_city',
        'payee_first_name': 'payee_first_name',
        'payee_last_name': 'payee_last_name',
        'payee_middle_name': 'payee_middle_name',
        'payee_name': 'payee_name',
        'payee_prefix': 'payee_prefix',
        'payee_state': 'payee_state',
        'payee_street_1': 'payee_street_1',
        'payee_street_2': 'payee_street_2',
        'payee_suffix': 'payee_suffix',
        'payee_zip': 'payee_zip',
        'pdf_url': 'pdf_url',
        'related_line_number': 'related_line_number',
        'report_type': 'report_type',
        'support_oppose_indicator': 'support_oppose_indicator',
        'transaction_id': 'transaction_id'
    }

    def __init__(self, amendment_indicator=None, back_reference_schedule_name=None, back_reference_transaction_id=None, beginning_image_number=None, candidate_first_name=None, candidate_id=None, candidate_middle_name=None, candidate_name=None, candidate_office=None, candidate_office_district=None, candidate_office_state=None, candidate_party=None, candidate_prefix=None, candidate_suffix=None, category_code=None, committee=None, committee_id=None, csv_url=None, dissemination_date=None, entity_type=None, expenditure_amount=None, expenditure_date=None, expenditure_description=None, fec_url=None, file_number=None, filer_first_name=None, filer_last_name=None, filer_middle_name=None, filer_prefix=None, filer_suffix=None, filing=None, filing_form=None, image_number=None, is_notice=None, line_number=None, load_timestamp=None, memo_code=None, memo_text=None, most_recent=None, notary_sign_date=None, office_total_ytd=None, payee_city=None, payee_first_name=None, payee_last_name=None, payee_middle_name=None, payee_name=None, payee_prefix=None, payee_state=None, payee_street_1=None, payee_street_2=None, payee_suffix=None, payee_zip=None, pdf_url=None, related_line_number=None, report_type=None, support_oppose_indicator=None, transaction_id=None, local_vars_configuration=None):  # noqa: E501
        """ScheduleEEfile - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._amendment_indicator = None
        self._back_reference_schedule_name = None
        self._back_reference_transaction_id = None
        self._beginning_image_number = None
        self._candidate_first_name = None
        self._candidate_id = None
        self._candidate_middle_name = None
        self._candidate_name = None
        self._candidate_office = None
        self._candidate_office_district = None
        self._candidate_office_state = None
        self._candidate_party = None
        self._candidate_prefix = None
        self._candidate_suffix = None
        self._category_code = None
        self._committee = None
        self._committee_id = None
        self._csv_url = None
        self._dissemination_date = None
        self._entity_type = None
        self._expenditure_amount = None
        self._expenditure_date = None
        self._expenditure_description = None
        self._fec_url = None
        self._file_number = None
        self._filer_first_name = None
        self._filer_last_name = None
        self._filer_middle_name = None
        self._filer_prefix = None
        self._filer_suffix = None
        self._filing = None
        self._filing_form = None
        self._image_number = None
        self._is_notice = None
        self._line_number = None
        self._load_timestamp = None
        self._memo_code = None
        self._memo_text = None
        self._most_recent = None
        self._notary_sign_date = None
        self._office_total_ytd = None
        self._payee_city = None
        self._payee_first_name = None
        self._payee_last_name = None
        self._payee_middle_name = None
        self._payee_name = None
        self._payee_prefix = None
        self._payee_state = None
        self._payee_street_1 = None
        self._payee_street_2 = None
        self._payee_suffix = None
        self._payee_zip = None
        self._pdf_url = None
        self._related_line_number = None
        self._report_type = None
        self._support_oppose_indicator = None
        self._transaction_id = None
        self.discriminator = None

        self.amendment_indicator = amendment_indicator
        self.back_reference_schedule_name = back_reference_schedule_name
        self.back_reference_transaction_id = back_reference_transaction_id
        if beginning_image_number is not None:
            self.beginning_image_number = beginning_image_number
        self.candidate_first_name = candidate_first_name
        self.candidate_id = candidate_id
        self.candidate_middle_name = candidate_middle_name
        self.candidate_name = candidate_name
        self.candidate_office = candidate_office
        self.candidate_office_district = candidate_office_district
        self.candidate_office_state = candidate_office_state
        self.candidate_party = candidate_party
        self.candidate_prefix = candidate_prefix
        self.candidate_suffix = candidate_suffix
        self.category_code = category_code
        if committee is not None:
            self.committee = committee
        self.committee_id = committee_id
        if csv_url is not None:
            self.csv_url = csv_url
        self.dissemination_date = dissemination_date
        self.entity_type = entity_type
        self.expenditure_amount = expenditure_amount
        self.expenditure_date = expenditure_date
        self.expenditure_description = expenditure_description
        if fec_url is not None:
            self.fec_url = fec_url
        self.file_number = file_number
        self.filer_first_name = filer_first_name
        self.filer_last_name = filer_last_name
        self.filer_middle_name = filer_middle_name
        self.filer_prefix = filer_prefix
        self.filer_suffix = filer_suffix
        if filing is not None:
            self.filing = filing
        self.filing_form = filing_form
        self.image_number = image_number
        if is_notice is not None:
            self.is_notice = is_notice
        self.line_number = line_number
        self.load_timestamp = load_timestamp
        self.memo_code = memo_code
        self.memo_text = memo_text
        self.most_recent = most_recent
        self.notary_sign_date = notary_sign_date
        self.office_total_ytd = office_total_ytd
        self.payee_city = payee_city
        self.payee_first_name = payee_first_name
        self.payee_last_name = payee_last_name
        self.payee_middle_name = payee_middle_name
        if payee_name is not None:
            self.payee_name = payee_name
        self.payee_prefix = payee_prefix
        self.payee_state = payee_state
        self.payee_street_1 = payee_street_1
        self.payee_street_2 = payee_street_2
        self.payee_suffix = payee_suffix
        self.payee_zip = payee_zip
        if pdf_url is not None:
            self.pdf_url = pdf_url
        self.related_line_number = related_line_number
        if report_type is not None:
            self.report_type = report_type
        self.support_oppose_indicator = support_oppose_indicator
        self.transaction_id = transaction_id

    @property
    def amendment_indicator(self):
        """Gets the amendment_indicator of this ScheduleEEfile.  # noqa: E501


        :return: The amendment_indicator of this ScheduleEEfile.  # noqa: E501
        :rtype: str
        """
        return self._amendment_indicator

    @amendment_indicator.setter
    def amendment_indicator(self, amendment_indicator):
        """Sets the amendment_indicator of this ScheduleEEfile.


        :param amendment_indicator: The amendment_indicator of this ScheduleEEfile.  # noqa: E501
        :type: str
        """

        self._amendment_indicator = amendment_indicator

    @property
    def back_reference_schedule_name(self):
        """Gets the back_reference_schedule_name of this ScheduleEEfile.  # noqa: E501


        :return: The back_reference_schedule_name of this ScheduleEEfile.  # noqa: E501
        :rtype: str
        """
        return self._back_reference_schedule_name

    @back_reference_schedule_name.setter
    def back_reference_schedule_name(self, back_reference_schedule_name):
        """Sets the back_reference_schedule_name of this ScheduleEEfile.


        :param back_reference_schedule_name: The back_reference_schedule_name of this ScheduleEEfile.  # noqa: E501
        :type: str
        """

        self._back_reference_schedule_name = back_reference_schedule_name

    @property
    def back_reference_transaction_id(self):
        """Gets the back_reference_transaction_id of this ScheduleEEfile.  # noqa: E501


        :return: The back_reference_transaction_id of this ScheduleEEfile.  # noqa: E501
        :rtype: str
        """
        return self._back_reference_transaction_id

    @back_reference_transaction_id.setter
    def back_reference_transaction_id(self, back_reference_transaction_id):
        """Sets the back_reference_transaction_id of this ScheduleEEfile.


        :param back_reference_transaction_id: The back_reference_transaction_id of this ScheduleEEfile.  # noqa: E501
        :type: str
        """

        self._back_reference_transaction_id = back_reference_transaction_id

    @property
    def beginning_image_number(self):
        """Gets the beginning_image_number of this ScheduleEEfile.  # noqa: E501


        :return: The beginning_image_number of this ScheduleEEfile.  # noqa: E501
        :rtype: str
        """
        return self._beginning_image_number

    @beginning_image_number.setter
    def beginning_image_number(self, beginning_image_number):
        """Sets the beginning_image_number of this ScheduleEEfile.


        :param beginning_image_number: The beginning_image_number of this ScheduleEEfile.  # noqa: E501
        :type: str
        """

        self._beginning_image_number = beginning_image_number

    @property
    def candidate_first_name(self):
        """Gets the candidate_first_name of this ScheduleEEfile.  # noqa: E501


        :return: The candidate_first_name of this ScheduleEEfile.  # noqa: E501
        :rtype: str
        """
        return self._candidate_first_name

    @candidate_first_name.setter
    def candidate_first_name(self, candidate_first_name):
        """Sets the candidate_first_name of this ScheduleEEfile.


        :param candidate_first_name: The candidate_first_name of this ScheduleEEfile.  # noqa: E501
        :type: str
        """

        self._candidate_first_name = candidate_first_name

    @property
    def candidate_id(self):
        """Gets the candidate_id of this ScheduleEEfile.  # noqa: E501


        :return: The candidate_id of this ScheduleEEfile.  # noqa: E501
        :rtype: str
        """
        return self._candidate_id

    @candidate_id.setter
    def candidate_id(self, candidate_id):
        """Sets the candidate_id of this ScheduleEEfile.


        :param candidate_id: The candidate_id of this ScheduleEEfile.  # noqa: E501
        :type: str
        """

        self._candidate_id = candidate_id

    @property
    def candidate_middle_name(self):
        """Gets the candidate_middle_name of this ScheduleEEfile.  # noqa: E501


        :return: The candidate_middle_name of this ScheduleEEfile.  # noqa: E501
        :rtype: str
        """
        return self._candidate_middle_name

    @candidate_middle_name.setter
    def candidate_middle_name(self, candidate_middle_name):
        """Sets the candidate_middle_name of this ScheduleEEfile.


        :param candidate_middle_name: The candidate_middle_name of this ScheduleEEfile.  # noqa: E501
        :type: str
        """

        self._candidate_middle_name = candidate_middle_name

    @property
    def candidate_name(self):
        """Gets the candidate_name of this ScheduleEEfile.  # noqa: E501

        Name of candidate running for office  # noqa: E501

        :return: The candidate_name of this ScheduleEEfile.  # noqa: E501
        :rtype: str
        """
        return self._candidate_name

    @candidate_name.setter
    def candidate_name(self, candidate_name):
        """Sets the candidate_name of this ScheduleEEfile.

        Name of candidate running for office  # noqa: E501

        :param candidate_name: The candidate_name of this ScheduleEEfile.  # noqa: E501
        :type: str
        """

        self._candidate_name = candidate_name

    @property
    def candidate_office(self):
        """Gets the candidate_office of this ScheduleEEfile.  # noqa: E501

        Federal office candidate runs for: H, S or P  # noqa: E501

        :return: The candidate_office of this ScheduleEEfile.  # noqa: E501
        :rtype: str
        """
        return self._candidate_office

    @candidate_office.setter
    def candidate_office(self, candidate_office):
        """Sets the candidate_office of this ScheduleEEfile.

        Federal office candidate runs for: H, S or P  # noqa: E501

        :param candidate_office: The candidate_office of this ScheduleEEfile.  # noqa: E501
        :type: str
        """

        self._candidate_office = candidate_office

    @property
    def candidate_office_district(self):
        """Gets the candidate_office_district of this ScheduleEEfile.  # noqa: E501

        Two-digit US House distirict of the office the candidate is running for. Presidential, Senate and House at-large candidates will have District 00.  # noqa: E501

        :return: The candidate_office_district of this ScheduleEEfile.  # noqa: E501
        :rtype: str
        """
        return self._candidate_office_district

    @candidate_office_district.setter
    def candidate_office_district(self, candidate_office_district):
        """Sets the candidate_office_district of this ScheduleEEfile.

        Two-digit US House distirict of the office the candidate is running for. Presidential, Senate and House at-large candidates will have District 00.  # noqa: E501

        :param candidate_office_district: The candidate_office_district of this ScheduleEEfile.  # noqa: E501
        :type: str
        """

        self._candidate_office_district = candidate_office_district

    @property
    def candidate_office_state(self):
        """Gets the candidate_office_state of this ScheduleEEfile.  # noqa: E501

        US state or territory  # noqa: E501

        :return: The candidate_office_state of this ScheduleEEfile.  # noqa: E501
        :rtype: str
        """
        return self._candidate_office_state

    @candidate_office_state.setter
    def candidate_office_state(self, candidate_office_state):
        """Sets the candidate_office_state of this ScheduleEEfile.

        US state or territory  # noqa: E501

        :param candidate_office_state: The candidate_office_state of this ScheduleEEfile.  # noqa: E501
        :type: str
        """

        self._candidate_office_state = candidate_office_state

    @property
    def candidate_party(self):
        """Gets the candidate_party of this ScheduleEEfile.  # noqa: E501

        Three-letter code for the party affiliated with a candidate or committee. For example, DEM for Democratic Party and REP for Republican Party.  # noqa: E501

        :return: The candidate_party of this ScheduleEEfile.  # noqa: E501
        :rtype: str
        """
        return self._candidate_party

    @candidate_party.setter
    def candidate_party(self, candidate_party):
        """Sets the candidate_party of this ScheduleEEfile.

        Three-letter code for the party affiliated with a candidate or committee. For example, DEM for Democratic Party and REP for Republican Party.  # noqa: E501

        :param candidate_party: The candidate_party of this ScheduleEEfile.  # noqa: E501
        :type: str
        """

        self._candidate_party = candidate_party

    @property
    def candidate_prefix(self):
        """Gets the candidate_prefix of this ScheduleEEfile.  # noqa: E501


        :return: The candidate_prefix of this ScheduleEEfile.  # noqa: E501
        :rtype: str
        """
        return self._candidate_prefix

    @candidate_prefix.setter
    def candidate_prefix(self, candidate_prefix):
        """Sets the candidate_prefix of this ScheduleEEfile.


        :param candidate_prefix: The candidate_prefix of this ScheduleEEfile.  # noqa: E501
        :type: str
        """

        self._candidate_prefix = candidate_prefix

    @property
    def candidate_suffix(self):
        """Gets the candidate_suffix of this ScheduleEEfile.  # noqa: E501


        :return: The candidate_suffix of this ScheduleEEfile.  # noqa: E501
        :rtype: str
        """
        return self._candidate_suffix

    @candidate_suffix.setter
    def candidate_suffix(self, candidate_suffix):
        """Sets the candidate_suffix of this ScheduleEEfile.


        :param candidate_suffix: The candidate_suffix of this ScheduleEEfile.  # noqa: E501
        :type: str
        """

        self._candidate_suffix = candidate_suffix

    @property
    def category_code(self):
        """Gets the category_code of this ScheduleEEfile.  # noqa: E501


        :return: The category_code of this ScheduleEEfile.  # noqa: E501
        :rtype: str
        """
        return self._category_code

    @category_code.setter
    def category_code(self, category_code):
        """Sets the category_code of this ScheduleEEfile.


        :param category_code: The category_code of this ScheduleEEfile.  # noqa: E501
        :type: str
        """

        self._category_code = category_code

    @property
    def committee(self):
        """Gets the committee of this ScheduleEEfile.  # noqa: E501


        :return: The committee of this ScheduleEEfile.  # noqa: E501
        :rtype: CommitteeHistory
        """
        return self._committee

    @committee.setter
    def committee(self, committee):
        """Sets the committee of this ScheduleEEfile.


        :param committee: The committee of this ScheduleEEfile.  # noqa: E501
        :type: CommitteeHistory
        """

        self._committee = committee

    @property
    def committee_id(self):
        """Gets the committee_id of this ScheduleEEfile.  # noqa: E501

         A unique identifier assigned to each committee or filer registered with the FEC. In general committee id's begin with the letter C which is followed by eight digits.   # noqa: E501

        :return: The committee_id of this ScheduleEEfile.  # noqa: E501
        :rtype: str
        """
        return self._committee_id

    @committee_id.setter
    def committee_id(self, committee_id):
        """Sets the committee_id of this ScheduleEEfile.

         A unique identifier assigned to each committee or filer registered with the FEC. In general committee id's begin with the letter C which is followed by eight digits.   # noqa: E501

        :param committee_id: The committee_id of this ScheduleEEfile.  # noqa: E501
        :type: str
        """

        self._committee_id = committee_id

    @property
    def csv_url(self):
        """Gets the csv_url of this ScheduleEEfile.  # noqa: E501


        :return: The csv_url of this ScheduleEEfile.  # noqa: E501
        :rtype: str
        """
        return self._csv_url

    @csv_url.setter
    def csv_url(self, csv_url):
        """Sets the csv_url of this ScheduleEEfile.


        :param csv_url: The csv_url of this ScheduleEEfile.  # noqa: E501
        :type: str
        """

        self._csv_url = csv_url

    @property
    def dissemination_date(self):
        """Gets the dissemination_date of this ScheduleEEfile.  # noqa: E501

         Date when a PAC distrubutes or disseminates an independent expenditure and pays for it in the same reporting period   # noqa: E501

        :return: The dissemination_date of this ScheduleEEfile.  # noqa: E501
        :rtype: date
        """
        return self._dissemination_date

    @dissemination_date.setter
    def dissemination_date(self, dissemination_date):
        """Sets the dissemination_date of this ScheduleEEfile.

         Date when a PAC distrubutes or disseminates an independent expenditure and pays for it in the same reporting period   # noqa: E501

        :param dissemination_date: The dissemination_date of this ScheduleEEfile.  # noqa: E501
        :type: date
        """

        self._dissemination_date = dissemination_date

    @property
    def entity_type(self):
        """Gets the entity_type of this ScheduleEEfile.  # noqa: E501


        :return: The entity_type of this ScheduleEEfile.  # noqa: E501
        :rtype: str
        """
        return self._entity_type

    @entity_type.setter
    def entity_type(self, entity_type):
        """Sets the entity_type of this ScheduleEEfile.


        :param entity_type: The entity_type of this ScheduleEEfile.  # noqa: E501
        :type: str
        """

        self._entity_type = entity_type

    @property
    def expenditure_amount(self):
        """Gets the expenditure_amount of this ScheduleEEfile.  # noqa: E501


        :return: The expenditure_amount of this ScheduleEEfile.  # noqa: E501
        :rtype: int
        """
        return self._expenditure_amount

    @expenditure_amount.setter
    def expenditure_amount(self, expenditure_amount):
        """Sets the expenditure_amount of this ScheduleEEfile.


        :param expenditure_amount: The expenditure_amount of this ScheduleEEfile.  # noqa: E501
        :type: int
        """

        self._expenditure_amount = expenditure_amount

    @property
    def expenditure_date(self):
        """Gets the expenditure_date of this ScheduleEEfile.  # noqa: E501


        :return: The expenditure_date of this ScheduleEEfile.  # noqa: E501
        :rtype: date
        """
        return self._expenditure_date

    @expenditure_date.setter
    def expenditure_date(self, expenditure_date):
        """Sets the expenditure_date of this ScheduleEEfile.


        :param expenditure_date: The expenditure_date of this ScheduleEEfile.  # noqa: E501
        :type: date
        """

        self._expenditure_date = expenditure_date

    @property
    def expenditure_description(self):
        """Gets the expenditure_description of this ScheduleEEfile.  # noqa: E501


        :return: The expenditure_description of this ScheduleEEfile.  # noqa: E501
        :rtype: str
        """
        return self._expenditure_description

    @expenditure_description.setter
    def expenditure_description(self, expenditure_description):
        """Sets the expenditure_description of this ScheduleEEfile.


        :param expenditure_description: The expenditure_description of this ScheduleEEfile.  # noqa: E501
        :type: str
        """

        self._expenditure_description = expenditure_description

    @property
    def fec_url(self):
        """Gets the fec_url of this ScheduleEEfile.  # noqa: E501


        :return: The fec_url of this ScheduleEEfile.  # noqa: E501
        :rtype: str
        """
        return self._fec_url

    @fec_url.setter
    def fec_url(self, fec_url):
        """Sets the fec_url of this ScheduleEEfile.


        :param fec_url: The fec_url of this ScheduleEEfile.  # noqa: E501
        :type: str
        """

        self._fec_url = fec_url

    @property
    def file_number(self):
        """Gets the file_number of this ScheduleEEfile.  # noqa: E501


        :return: The file_number of this ScheduleEEfile.  # noqa: E501
        :rtype: int
        """
        return self._file_number

    @file_number.setter
    def file_number(self, file_number):
        """Sets the file_number of this ScheduleEEfile.


        :param file_number: The file_number of this ScheduleEEfile.  # noqa: E501
        :type: int
        """
        if self.local_vars_configuration.client_side_validation and file_number is None:  # noqa: E501
            raise ValueError('Invalid value for `file_number`, must not be `None`')  # noqa: E501

        self._file_number = file_number

    @property
    def filer_first_name(self):
        """Gets the filer_first_name of this ScheduleEEfile.  # noqa: E501


        :return: The filer_first_name of this ScheduleEEfile.  # noqa: E501
        :rtype: str
        """
        return self._filer_first_name

    @filer_first_name.setter
    def filer_first_name(self, filer_first_name):
        """Sets the filer_first_name of this ScheduleEEfile.


        :param filer_first_name: The filer_first_name of this ScheduleEEfile.  # noqa: E501
        :type: str
        """

        self._filer_first_name = filer_first_name

    @property
    def filer_last_name(self):
        """Gets the filer_last_name of this ScheduleEEfile.  # noqa: E501


        :return: The filer_last_name of this ScheduleEEfile.  # noqa: E501
        :rtype: str
        """
        return self._filer_last_name

    @filer_last_name.setter
    def filer_last_name(self, filer_last_name):
        """Sets the filer_last_name of this ScheduleEEfile.


        :param filer_last_name: The filer_last_name of this ScheduleEEfile.  # noqa: E501
        :type: str
        """

        self._filer_last_name = filer_last_name

    @property
    def filer_middle_name(self):
        """Gets the filer_middle_name of this ScheduleEEfile.  # noqa: E501


        :return: The filer_middle_name of this ScheduleEEfile.  # noqa: E501
        :rtype: str
        """
        return self._filer_middle_name

    @filer_middle_name.setter
    def filer_middle_name(self, filer_middle_name):
        """Sets the filer_middle_name of this ScheduleEEfile.


        :param filer_middle_name: The filer_middle_name of this ScheduleEEfile.  # noqa: E501
        :type: str
        """

        self._filer_middle_name = filer_middle_name

    @property
    def filer_prefix(self):
        """Gets the filer_prefix of this ScheduleEEfile.  # noqa: E501


        :return: The filer_prefix of this ScheduleEEfile.  # noqa: E501
        :rtype: str
        """
        return self._filer_prefix

    @filer_prefix.setter
    def filer_prefix(self, filer_prefix):
        """Sets the filer_prefix of this ScheduleEEfile.


        :param filer_prefix: The filer_prefix of this ScheduleEEfile.  # noqa: E501
        :type: str
        """

        self._filer_prefix = filer_prefix

    @property
    def filer_suffix(self):
        """Gets the filer_suffix of this ScheduleEEfile.  # noqa: E501


        :return: The filer_suffix of this ScheduleEEfile.  # noqa: E501
        :rtype: str
        """
        return self._filer_suffix

    @filer_suffix.setter
    def filer_suffix(self, filer_suffix):
        """Sets the filer_suffix of this ScheduleEEfile.


        :param filer_suffix: The filer_suffix of this ScheduleEEfile.  # noqa: E501
        :type: str
        """

        self._filer_suffix = filer_suffix

    @property
    def filing(self):
        """Gets the filing of this ScheduleEEfile.  # noqa: E501


        :return: The filing of this ScheduleEEfile.  # noqa: E501
        :rtype: EFilings
        """
        return self._filing

    @filing.setter
    def filing(self, filing):
        """Sets the filing of this ScheduleEEfile.


        :param filing: The filing of this ScheduleEEfile.  # noqa: E501
        :type: EFilings
        """

        self._filing = filing

    @property
    def filing_form(self):
        """Gets the filing_form of this ScheduleEEfile.  # noqa: E501


        :return: The filing_form of this ScheduleEEfile.  # noqa: E501
        :rtype: str
        """
        return self._filing_form

    @filing_form.setter
    def filing_form(self, filing_form):
        """Sets the filing_form of this ScheduleEEfile.


        :param filing_form: The filing_form of this ScheduleEEfile.  # noqa: E501
        :type: str
        """

        self._filing_form = filing_form

    @property
    def image_number(self):
        """Gets the image_number of this ScheduleEEfile.  # noqa: E501

         An unique identifier for each page where the electronic or paper filing is reported.   # noqa: E501

        :return: The image_number of this ScheduleEEfile.  # noqa: E501
        :rtype: str
        """
        return self._image_number

    @image_number.setter
    def image_number(self, image_number):
        """Sets the image_number of this ScheduleEEfile.

         An unique identifier for each page where the electronic or paper filing is reported.   # noqa: E501

        :param image_number: The image_number of this ScheduleEEfile.  # noqa: E501
        :type: str
        """

        self._image_number = image_number

    @property
    def is_notice(self):
        """Gets the is_notice of this ScheduleEEfile.  # noqa: E501


        :return: The is_notice of this ScheduleEEfile.  # noqa: E501
        :rtype: bool
        """
        return self._is_notice

    @is_notice.setter
    def is_notice(self, is_notice):
        """Sets the is_notice of this ScheduleEEfile.


        :param is_notice: The is_notice of this ScheduleEEfile.  # noqa: E501
        :type: bool
        """

        self._is_notice = is_notice

    @property
    def line_number(self):
        """Gets the line_number of this ScheduleEEfile.  # noqa: E501


        :return: The line_number of this ScheduleEEfile.  # noqa: E501
        :rtype: str
        """
        return self._line_number

    @line_number.setter
    def line_number(self, line_number):
        """Sets the line_number of this ScheduleEEfile.


        :param line_number: The line_number of this ScheduleEEfile.  # noqa: E501
        :type: str
        """

        self._line_number = line_number

    @property
    def load_timestamp(self):
        """Gets the load_timestamp of this ScheduleEEfile.  # noqa: E501


        :return: The load_timestamp of this ScheduleEEfile.  # noqa: E501
        :rtype: datetime
        """
        return self._load_timestamp

    @load_timestamp.setter
    def load_timestamp(self, load_timestamp):
        """Sets the load_timestamp of this ScheduleEEfile.


        :param load_timestamp: The load_timestamp of this ScheduleEEfile.  # noqa: E501
        :type: datetime
        """

        self._load_timestamp = load_timestamp

    @property
    def memo_code(self):
        """Gets the memo_code of this ScheduleEEfile.  # noqa: E501


        :return: The memo_code of this ScheduleEEfile.  # noqa: E501
        :rtype: str
        """
        return self._memo_code

    @memo_code.setter
    def memo_code(self, memo_code):
        """Sets the memo_code of this ScheduleEEfile.


        :param memo_code: The memo_code of this ScheduleEEfile.  # noqa: E501
        :type: str
        """

        self._memo_code = memo_code

    @property
    def memo_text(self):
        """Gets the memo_text of this ScheduleEEfile.  # noqa: E501


        :return: The memo_text of this ScheduleEEfile.  # noqa: E501
        :rtype: str
        """
        return self._memo_text

    @memo_text.setter
    def memo_text(self, memo_text):
        """Sets the memo_text of this ScheduleEEfile.


        :param memo_text: The memo_text of this ScheduleEEfile.  # noqa: E501
        :type: str
        """

        self._memo_text = memo_text

    @property
    def most_recent(self):
        """Gets the most_recent of this ScheduleEEfile.  # noqa: E501

         Report is either new or is the most-recently filed amendment   # noqa: E501

        :return: The most_recent of this ScheduleEEfile.  # noqa: E501
        :rtype: bool
        """
        return self._most_recent

    @most_recent.setter
    def most_recent(self, most_recent):
        """Sets the most_recent of this ScheduleEEfile.

         Report is either new or is the most-recently filed amendment   # noqa: E501

        :param most_recent: The most_recent of this ScheduleEEfile.  # noqa: E501
        :type: bool
        """

        self._most_recent = most_recent

    @property
    def notary_sign_date(self):
        """Gets the notary_sign_date of this ScheduleEEfile.  # noqa: E501


        :return: The notary_sign_date of this ScheduleEEfile.  # noqa: E501
        :rtype: date
        """
        return self._notary_sign_date

    @notary_sign_date.setter
    def notary_sign_date(self, notary_sign_date):
        """Sets the notary_sign_date of this ScheduleEEfile.


        :param notary_sign_date: The notary_sign_date of this ScheduleEEfile.  # noqa: E501
        :type: date
        """

        self._notary_sign_date = notary_sign_date

    @property
    def office_total_ytd(self):
        """Gets the office_total_ytd of this ScheduleEEfile.  # noqa: E501


        :return: The office_total_ytd of this ScheduleEEfile.  # noqa: E501
        :rtype: float
        """
        return self._office_total_ytd

    @office_total_ytd.setter
    def office_total_ytd(self, office_total_ytd):
        """Sets the office_total_ytd of this ScheduleEEfile.


        :param office_total_ytd: The office_total_ytd of this ScheduleEEfile.  # noqa: E501
        :type: float
        """

        self._office_total_ytd = office_total_ytd

    @property
    def payee_city(self):
        """Gets the payee_city of this ScheduleEEfile.  # noqa: E501


        :return: The payee_city of this ScheduleEEfile.  # noqa: E501
        :rtype: str
        """
        return self._payee_city

    @payee_city.setter
    def payee_city(self, payee_city):
        """Sets the payee_city of this ScheduleEEfile.


        :param payee_city: The payee_city of this ScheduleEEfile.  # noqa: E501
        :type: str
        """

        self._payee_city = payee_city

    @property
    def payee_first_name(self):
        """Gets the payee_first_name of this ScheduleEEfile.  # noqa: E501


        :return: The payee_first_name of this ScheduleEEfile.  # noqa: E501
        :rtype: str
        """
        return self._payee_first_name

    @payee_first_name.setter
    def payee_first_name(self, payee_first_name):
        """Sets the payee_first_name of this ScheduleEEfile.


        :param payee_first_name: The payee_first_name of this ScheduleEEfile.  # noqa: E501
        :type: str
        """

        self._payee_first_name = payee_first_name

    @property
    def payee_last_name(self):
        """Gets the payee_last_name of this ScheduleEEfile.  # noqa: E501


        :return: The payee_last_name of this ScheduleEEfile.  # noqa: E501
        :rtype: str
        """
        return self._payee_last_name

    @payee_last_name.setter
    def payee_last_name(self, payee_last_name):
        """Sets the payee_last_name of this ScheduleEEfile.


        :param payee_last_name: The payee_last_name of this ScheduleEEfile.  # noqa: E501
        :type: str
        """

        self._payee_last_name = payee_last_name

    @property
    def payee_middle_name(self):
        """Gets the payee_middle_name of this ScheduleEEfile.  # noqa: E501


        :return: The payee_middle_name of this ScheduleEEfile.  # noqa: E501
        :rtype: str
        """
        return self._payee_middle_name

    @payee_middle_name.setter
    def payee_middle_name(self, payee_middle_name):
        """Sets the payee_middle_name of this ScheduleEEfile.


        :param payee_middle_name: The payee_middle_name of this ScheduleEEfile.  # noqa: E501
        :type: str
        """

        self._payee_middle_name = payee_middle_name

    @property
    def payee_name(self):
        """Gets the payee_name of this ScheduleEEfile.  # noqa: E501


        :return: The payee_name of this ScheduleEEfile.  # noqa: E501
        :rtype: str
        """
        return self._payee_name

    @payee_name.setter
    def payee_name(self, payee_name):
        """Sets the payee_name of this ScheduleEEfile.


        :param payee_name: The payee_name of this ScheduleEEfile.  # noqa: E501
        :type: str
        """

        self._payee_name = payee_name

    @property
    def payee_prefix(self):
        """Gets the payee_prefix of this ScheduleEEfile.  # noqa: E501


        :return: The payee_prefix of this ScheduleEEfile.  # noqa: E501
        :rtype: str
        """
        return self._payee_prefix

    @payee_prefix.setter
    def payee_prefix(self, payee_prefix):
        """Sets the payee_prefix of this ScheduleEEfile.


        :param payee_prefix: The payee_prefix of this ScheduleEEfile.  # noqa: E501
        :type: str
        """

        self._payee_prefix = payee_prefix

    @property
    def payee_state(self):
        """Gets the payee_state of this ScheduleEEfile.  # noqa: E501


        :return: The payee_state of this ScheduleEEfile.  # noqa: E501
        :rtype: str
        """
        return self._payee_state

    @payee_state.setter
    def payee_state(self, payee_state):
        """Sets the payee_state of this ScheduleEEfile.


        :param payee_state: The payee_state of this ScheduleEEfile.  # noqa: E501
        :type: str
        """

        self._payee_state = payee_state

    @property
    def payee_street_1(self):
        """Gets the payee_street_1 of this ScheduleEEfile.  # noqa: E501


        :return: The payee_street_1 of this ScheduleEEfile.  # noqa: E501
        :rtype: str
        """
        return self._payee_street_1

    @payee_street_1.setter
    def payee_street_1(self, payee_street_1):
        """Sets the payee_street_1 of this ScheduleEEfile.


        :param payee_street_1: The payee_street_1 of this ScheduleEEfile.  # noqa: E501
        :type: str
        """

        self._payee_street_1 = payee_street_1

    @property
    def payee_street_2(self):
        """Gets the payee_street_2 of this ScheduleEEfile.  # noqa: E501


        :return: The payee_street_2 of this ScheduleEEfile.  # noqa: E501
        :rtype: str
        """
        return self._payee_street_2

    @payee_street_2.setter
    def payee_street_2(self, payee_street_2):
        """Sets the payee_street_2 of this ScheduleEEfile.


        :param payee_street_2: The payee_street_2 of this ScheduleEEfile.  # noqa: E501
        :type: str
        """

        self._payee_street_2 = payee_street_2

    @property
    def payee_suffix(self):
        """Gets the payee_suffix of this ScheduleEEfile.  # noqa: E501


        :return: The payee_suffix of this ScheduleEEfile.  # noqa: E501
        :rtype: str
        """
        return self._payee_suffix

    @payee_suffix.setter
    def payee_suffix(self, payee_suffix):
        """Sets the payee_suffix of this ScheduleEEfile.


        :param payee_suffix: The payee_suffix of this ScheduleEEfile.  # noqa: E501
        :type: str
        """

        self._payee_suffix = payee_suffix

    @property
    def payee_zip(self):
        """Gets the payee_zip of this ScheduleEEfile.  # noqa: E501


        :return: The payee_zip of this ScheduleEEfile.  # noqa: E501
        :rtype: str
        """
        return self._payee_zip

    @payee_zip.setter
    def payee_zip(self, payee_zip):
        """Sets the payee_zip of this ScheduleEEfile.


        :param payee_zip: The payee_zip of this ScheduleEEfile.  # noqa: E501
        :type: str
        """

        self._payee_zip = payee_zip

    @property
    def pdf_url(self):
        """Gets the pdf_url of this ScheduleEEfile.  # noqa: E501


        :return: The pdf_url of this ScheduleEEfile.  # noqa: E501
        :rtype: str
        """
        return self._pdf_url

    @pdf_url.setter
    def pdf_url(self, pdf_url):
        """Sets the pdf_url of this ScheduleEEfile.


        :param pdf_url: The pdf_url of this ScheduleEEfile.  # noqa: E501
        :type: str
        """

        self._pdf_url = pdf_url

    @property
    def related_line_number(self):
        """Gets the related_line_number of this ScheduleEEfile.  # noqa: E501


        :return: The related_line_number of this ScheduleEEfile.  # noqa: E501
        :rtype: int
        """
        return self._related_line_number

    @related_line_number.setter
    def related_line_number(self, related_line_number):
        """Sets the related_line_number of this ScheduleEEfile.


        :param related_line_number: The related_line_number of this ScheduleEEfile.  # noqa: E501
        :type: int
        """
        if self.local_vars_configuration.client_side_validation and related_line_number is None:  # noqa: E501
            raise ValueError('Invalid value for `related_line_number`, must not be `None`')  # noqa: E501

        self._related_line_number = related_line_number

    @property
    def report_type(self):
        """Gets the report_type of this ScheduleEEfile.  # noqa: E501


        :return: The report_type of this ScheduleEEfile.  # noqa: E501
        :rtype: str
        """
        return self._report_type

    @report_type.setter
    def report_type(self, report_type):
        """Sets the report_type of this ScheduleEEfile.


        :param report_type: The report_type of this ScheduleEEfile.  # noqa: E501
        :type: str
        """

        self._report_type = report_type

    @property
    def support_oppose_indicator(self):
        """Gets the support_oppose_indicator of this ScheduleEEfile.  # noqa: E501

        Explains if the money was spent in order to support or oppose a candidate or candidates. (Coded S or O for support or oppose.) This indicator applies to independent expenditures and communication costs.  # noqa: E501

        :return: The support_oppose_indicator of this ScheduleEEfile.  # noqa: E501
        :rtype: str
        """
        return self._support_oppose_indicator

    @support_oppose_indicator.setter
    def support_oppose_indicator(self, support_oppose_indicator):
        """Sets the support_oppose_indicator of this ScheduleEEfile.

        Explains if the money was spent in order to support or oppose a candidate or candidates. (Coded S or O for support or oppose.) This indicator applies to independent expenditures and communication costs.  # noqa: E501

        :param support_oppose_indicator: The support_oppose_indicator of this ScheduleEEfile.  # noqa: E501
        :type: str
        """

        self._support_oppose_indicator = support_oppose_indicator

    @property
    def transaction_id(self):
        """Gets the transaction_id of this ScheduleEEfile.  # noqa: E501


        :return: The transaction_id of this ScheduleEEfile.  # noqa: E501
        :rtype: str
        """
        return self._transaction_id

    @transaction_id.setter
    def transaction_id(self, transaction_id):
        """Sets the transaction_id of this ScheduleEEfile.


        :param transaction_id: The transaction_id of this ScheduleEEfile.  # noqa: E501
        :type: str
        """

        self._transaction_id = transaction_id

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, 'to_dict') else x,
                    value
                ))
            elif hasattr(value, 'to_dict'):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], 'to_dict') else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ScheduleEEfile):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, ScheduleEEfile):
            return True

        return self.to_dict() != other.to_dict()
