# coding: utf-8

"""
    OpenFEC

    This API allows you to explore the way candidates and committees fund their campaigns.    The FEC API is a RESTful web service supporting full-text and field-specific searches on FEC data. [Bulk downloads](https://www.fec.gov/data/advanced/?tab=bulk-data) are available on the current site. Information is tied to the underlying forms by file ID and image ID. Data is updated nightly.    There is a lot of data, but a good place to start is to use search to find interesting candidates and committees. Then, you can use their IDs to find report or line item details with the other endpoints. If you are interested in individual donors, check out contributor information in schedule_a.    Get an [API key here](https://api.data.gov/signup/). That will enable you to place up to 1,000 calls an hour. Each call is limited to 100 results per page. You can email questions, comments or a request to get a key for 120 calls per minute to [APIinfo@fec.gov](mailto:apiinfo@fec.gov). You can also ask questions and discuss the data in the [FEC data Google Group](https://groups.google.com/forum/#!forum/fec-data). API changes will also be added to this group in advance of the change.    The model definitions and schema are available at [/swagger](/swagger/). This is useful for making wrappers and exploring the data.    A few restrictions limit the way you can use FEC data. For example, you can’t use contributor lists for commercial purposes or to solicit donations. [Learn more here](https://www.fec.gov/updates/sale-or-use-contributor-information/).    [View our source code](https://github.com/fecgov/openFEC). We welcome issues and pull requests!  # noqa: E501

    The version of the OpenAPI document: 1.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from openfec_sdk.configuration import Configuration


class ScheduleH4(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'additional_description': 'str',
        'administrative_activity_inidcator': 'str',
        'administrative_voter_drive_activity_indicator': 'str',
        'amendment_indicator': 'str',
        'amendment_indicator_desc': 'str',
        'back_reference_schedule_id': 'str',
        'back_reference_transaction_id': 'str',
        'candidate_first_name': 'str',
        'candidate_id': 'str',
        'candidate_last_name': 'str',
        'candidate_name': 'str',
        'candidate_office': 'str',
        'candidate_office_description': 'str',
        'candidate_office_district': 'str',
        'candidate_office_state': 'str',
        'candidate_office_state_full': 'str',
        'category_code': 'str',
        'category_code_full': 'str',
        'committee': 'CommitteeHistory',
        'committee_id': 'str',
        'conduit_committee_city': 'str',
        'conduit_committee_id': 'str',
        'conduit_committee_name': 'str',
        'conduit_committee_state': 'str',
        'conduit_committee_street1': 'str',
        'conduit_committee_street2': 'str',
        'conduit_committee_zip': 'int',
        'cycle': 'float',
        'direct_candidate_support_activity_indicator': 'str',
        'disbursement_amount': 'float',
        'disbursement_type': 'str',
        'disbursement_type_full': 'str',
        'entity_type': 'str',
        'entity_type_desc': 'str',
        'event_amount_year_to_date': 'float',
        'event_purpose_category_type': 'str',
        'event_purpose_category_type_full': 'str',
        'event_purpose_date': 'date',
        'event_purpose_description': 'str',
        'event_purpose_name': 'str',
        'exempt_activity_indicator': 'str',
        'federal_share': 'float',
        'file_number': 'int',
        'filer_committee_name': 'str',
        'filing_form': 'str',
        'fundraising_activity_indicator': 'str',
        'general_voter_drive_activity_indicator': 'str',
        'image_number': 'str',
        'line_number': 'str',
        'link_id': 'int',
        'load_date': 'datetime',
        'memo_code': 'str',
        'memo_code_description': 'str',
        'memo_text': 'str',
        'nonfederal_share': 'float',
        'original_sub_id': 'str',
        'payee_city': 'str',
        'payee_first_name': 'str',
        'payee_last_name': 'str',
        'payee_middle_name': 'str',
        'payee_name': 'str',
        'payee_prefix': 'str',
        'payee_state': 'str',
        'payee_suffix': 'str',
        'payee_zip': 'str',
        'published_committee_reference_parity_check': 'str',
        'report_type': 'str',
        'report_year': 'float',
        'schedule_type': 'str',
        'schedule_type_full': 'str',
        'sub_id': 'str',
        'transaction_id': 'str'
    }

    attribute_map = {
        'additional_description': 'additional_description',
        'administrative_activity_inidcator': 'administrative_activity_inidcator',
        'administrative_voter_drive_activity_indicator': 'administrative_voter_drive_activity_indicator',
        'amendment_indicator': 'amendment_indicator',
        'amendment_indicator_desc': 'amendment_indicator_desc',
        'back_reference_schedule_id': 'back_reference_schedule_id',
        'back_reference_transaction_id': 'back_reference_transaction_id',
        'candidate_first_name': 'candidate_first_name',
        'candidate_id': 'candidate_id',
        'candidate_last_name': 'candidate_last_name',
        'candidate_name': 'candidate_name',
        'candidate_office': 'candidate_office',
        'candidate_office_description': 'candidate_office_description',
        'candidate_office_district': 'candidate_office_district',
        'candidate_office_state': 'candidate_office_state',
        'candidate_office_state_full': 'candidate_office_state_full',
        'category_code': 'category_code',
        'category_code_full': 'category_code_full',
        'committee': 'committee',
        'committee_id': 'committee_id',
        'conduit_committee_city': 'conduit_committee_city',
        'conduit_committee_id': 'conduit_committee_id',
        'conduit_committee_name': 'conduit_committee_name',
        'conduit_committee_state': 'conduit_committee_state',
        'conduit_committee_street1': 'conduit_committee_street1',
        'conduit_committee_street2': 'conduit_committee_street2',
        'conduit_committee_zip': 'conduit_committee_zip',
        'cycle': 'cycle',
        'direct_candidate_support_activity_indicator': 'direct_candidate_support_activity_indicator',
        'disbursement_amount': 'disbursement_amount',
        'disbursement_type': 'disbursement_type',
        'disbursement_type_full': 'disbursement_type_full',
        'entity_type': 'entity_type',
        'entity_type_desc': 'entity_type_desc',
        'event_amount_year_to_date': 'event_amount_year_to_date',
        'event_purpose_category_type': 'event_purpose_category_type',
        'event_purpose_category_type_full': 'event_purpose_category_type_full',
        'event_purpose_date': 'event_purpose_date',
        'event_purpose_description': 'event_purpose_description',
        'event_purpose_name': 'event_purpose_name',
        'exempt_activity_indicator': 'exempt_activity_indicator',
        'federal_share': 'federal_share',
        'file_number': 'file_number',
        'filer_committee_name': 'filer_committee_name',
        'filing_form': 'filing_form',
        'fundraising_activity_indicator': 'fundraising_activity_indicator',
        'general_voter_drive_activity_indicator': 'general_voter_drive_activity_indicator',
        'image_number': 'image_number',
        'line_number': 'line_number',
        'link_id': 'link_id',
        'load_date': 'load_date',
        'memo_code': 'memo_code',
        'memo_code_description': 'memo_code_description',
        'memo_text': 'memo_text',
        'nonfederal_share': 'nonfederal_share',
        'original_sub_id': 'original_sub_id',
        'payee_city': 'payee_city',
        'payee_first_name': 'payee_first_name',
        'payee_last_name': 'payee_last_name',
        'payee_middle_name': 'payee_middle_name',
        'payee_name': 'payee_name',
        'payee_prefix': 'payee_prefix',
        'payee_state': 'payee_state',
        'payee_suffix': 'payee_suffix',
        'payee_zip': 'payee_zip',
        'published_committee_reference_parity_check': 'published_committee_reference_parity_check',
        'report_type': 'report_type',
        'report_year': 'report_year',
        'schedule_type': 'schedule_type',
        'schedule_type_full': 'schedule_type_full',
        'sub_id': 'sub_id',
        'transaction_id': 'transaction_id'
    }

    def __init__(self, additional_description=None, administrative_activity_inidcator=None, administrative_voter_drive_activity_indicator=None, amendment_indicator=None, amendment_indicator_desc=None, back_reference_schedule_id=None, back_reference_transaction_id=None, candidate_first_name=None, candidate_id=None, candidate_last_name=None, candidate_name=None, candidate_office=None, candidate_office_description=None, candidate_office_district=None, candidate_office_state=None, candidate_office_state_full=None, category_code=None, category_code_full=None, committee=None, committee_id=None, conduit_committee_city=None, conduit_committee_id=None, conduit_committee_name=None, conduit_committee_state=None, conduit_committee_street1=None, conduit_committee_street2=None, conduit_committee_zip=None, cycle=None, direct_candidate_support_activity_indicator=None, disbursement_amount=None, disbursement_type=None, disbursement_type_full=None, entity_type=None, entity_type_desc=None, event_amount_year_to_date=None, event_purpose_category_type=None, event_purpose_category_type_full=None, event_purpose_date=None, event_purpose_description=None, event_purpose_name=None, exempt_activity_indicator=None, federal_share=None, file_number=None, filer_committee_name=None, filing_form=None, fundraising_activity_indicator=None, general_voter_drive_activity_indicator=None, image_number=None, line_number=None, link_id=None, load_date=None, memo_code=None, memo_code_description=None, memo_text=None, nonfederal_share=None, original_sub_id=None, payee_city=None, payee_first_name=None, payee_last_name=None, payee_middle_name=None, payee_name=None, payee_prefix=None, payee_state=None, payee_suffix=None, payee_zip=None, published_committee_reference_parity_check=None, report_type=None, report_year=None, schedule_type=None, schedule_type_full=None, sub_id=None, transaction_id=None, local_vars_configuration=None):  # noqa: E501
        """ScheduleH4 - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._additional_description = None
        self._administrative_activity_inidcator = None
        self._administrative_voter_drive_activity_indicator = None
        self._amendment_indicator = None
        self._amendment_indicator_desc = None
        self._back_reference_schedule_id = None
        self._back_reference_transaction_id = None
        self._candidate_first_name = None
        self._candidate_id = None
        self._candidate_last_name = None
        self._candidate_name = None
        self._candidate_office = None
        self._candidate_office_description = None
        self._candidate_office_district = None
        self._candidate_office_state = None
        self._candidate_office_state_full = None
        self._category_code = None
        self._category_code_full = None
        self._committee = None
        self._committee_id = None
        self._conduit_committee_city = None
        self._conduit_committee_id = None
        self._conduit_committee_name = None
        self._conduit_committee_state = None
        self._conduit_committee_street1 = None
        self._conduit_committee_street2 = None
        self._conduit_committee_zip = None
        self._cycle = None
        self._direct_candidate_support_activity_indicator = None
        self._disbursement_amount = None
        self._disbursement_type = None
        self._disbursement_type_full = None
        self._entity_type = None
        self._entity_type_desc = None
        self._event_amount_year_to_date = None
        self._event_purpose_category_type = None
        self._event_purpose_category_type_full = None
        self._event_purpose_date = None
        self._event_purpose_description = None
        self._event_purpose_name = None
        self._exempt_activity_indicator = None
        self._federal_share = None
        self._file_number = None
        self._filer_committee_name = None
        self._filing_form = None
        self._fundraising_activity_indicator = None
        self._general_voter_drive_activity_indicator = None
        self._image_number = None
        self._line_number = None
        self._link_id = None
        self._load_date = None
        self._memo_code = None
        self._memo_code_description = None
        self._memo_text = None
        self._nonfederal_share = None
        self._original_sub_id = None
        self._payee_city = None
        self._payee_first_name = None
        self._payee_last_name = None
        self._payee_middle_name = None
        self._payee_name = None
        self._payee_prefix = None
        self._payee_state = None
        self._payee_suffix = None
        self._payee_zip = None
        self._published_committee_reference_parity_check = None
        self._report_type = None
        self._report_year = None
        self._schedule_type = None
        self._schedule_type_full = None
        self._sub_id = None
        self._transaction_id = None
        self.discriminator = None

        self.additional_description = additional_description
        self.administrative_activity_inidcator = administrative_activity_inidcator
        self.administrative_voter_drive_activity_indicator = administrative_voter_drive_activity_indicator
        self.amendment_indicator = amendment_indicator
        self.amendment_indicator_desc = amendment_indicator_desc
        self.back_reference_schedule_id = back_reference_schedule_id
        self.back_reference_transaction_id = back_reference_transaction_id
        self.candidate_first_name = candidate_first_name
        self.candidate_id = candidate_id
        self.candidate_last_name = candidate_last_name
        self.candidate_name = candidate_name
        self.candidate_office = candidate_office
        self.candidate_office_description = candidate_office_description
        self.candidate_office_district = candidate_office_district
        self.candidate_office_state = candidate_office_state
        self.candidate_office_state_full = candidate_office_state_full
        self.category_code = category_code
        self.category_code_full = category_code_full
        if committee is not None:
            self.committee = committee
        self.committee_id = committee_id
        self.conduit_committee_city = conduit_committee_city
        self.conduit_committee_id = conduit_committee_id
        self.conduit_committee_name = conduit_committee_name
        self.conduit_committee_state = conduit_committee_state
        self.conduit_committee_street1 = conduit_committee_street1
        self.conduit_committee_street2 = conduit_committee_street2
        self.conduit_committee_zip = conduit_committee_zip
        self.cycle = cycle
        self.direct_candidate_support_activity_indicator = direct_candidate_support_activity_indicator
        self.disbursement_amount = disbursement_amount
        self.disbursement_type = disbursement_type
        self.disbursement_type_full = disbursement_type_full
        self.entity_type = entity_type
        self.entity_type_desc = entity_type_desc
        self.event_amount_year_to_date = event_amount_year_to_date
        self.event_purpose_category_type = event_purpose_category_type
        self.event_purpose_category_type_full = event_purpose_category_type_full
        self.event_purpose_date = event_purpose_date
        self.event_purpose_description = event_purpose_description
        self.event_purpose_name = event_purpose_name
        self.exempt_activity_indicator = exempt_activity_indicator
        self.federal_share = federal_share
        self.file_number = file_number
        self.filer_committee_name = filer_committee_name
        self.filing_form = filing_form
        self.fundraising_activity_indicator = fundraising_activity_indicator
        self.general_voter_drive_activity_indicator = general_voter_drive_activity_indicator
        if image_number is not None:
            self.image_number = image_number
        self.line_number = line_number
        self.link_id = link_id
        self.load_date = load_date
        self.memo_code = memo_code
        self.memo_code_description = memo_code_description
        self.memo_text = memo_text
        self.nonfederal_share = nonfederal_share
        if original_sub_id is not None:
            self.original_sub_id = original_sub_id
        self.payee_city = payee_city
        self.payee_first_name = payee_first_name
        self.payee_last_name = payee_last_name
        self.payee_middle_name = payee_middle_name
        self.payee_name = payee_name
        self.payee_prefix = payee_prefix
        self.payee_state = payee_state
        self.payee_suffix = payee_suffix
        self.payee_zip = payee_zip
        self.published_committee_reference_parity_check = published_committee_reference_parity_check
        self.report_type = report_type
        self.report_year = report_year
        self.schedule_type = schedule_type
        self.schedule_type_full = schedule_type_full
        if sub_id is not None:
            self.sub_id = sub_id
        self.transaction_id = transaction_id

    @property
    def additional_description(self):
        """Gets the additional_description of this ScheduleH4.  # noqa: E501


        :return: The additional_description of this ScheduleH4.  # noqa: E501
        :rtype: str
        """
        return self._additional_description

    @additional_description.setter
    def additional_description(self, additional_description):
        """Sets the additional_description of this ScheduleH4.


        :param additional_description: The additional_description of this ScheduleH4.  # noqa: E501
        :type: str
        """

        self._additional_description = additional_description

    @property
    def administrative_activity_inidcator(self):
        """Gets the administrative_activity_inidcator of this ScheduleH4.  # noqa: E501


        :return: The administrative_activity_inidcator of this ScheduleH4.  # noqa: E501
        :rtype: str
        """
        return self._administrative_activity_inidcator

    @administrative_activity_inidcator.setter
    def administrative_activity_inidcator(self, administrative_activity_inidcator):
        """Sets the administrative_activity_inidcator of this ScheduleH4.


        :param administrative_activity_inidcator: The administrative_activity_inidcator of this ScheduleH4.  # noqa: E501
        :type: str
        """

        self._administrative_activity_inidcator = administrative_activity_inidcator

    @property
    def administrative_voter_drive_activity_indicator(self):
        """Gets the administrative_voter_drive_activity_indicator of this ScheduleH4.  # noqa: E501


        :return: The administrative_voter_drive_activity_indicator of this ScheduleH4.  # noqa: E501
        :rtype: str
        """
        return self._administrative_voter_drive_activity_indicator

    @administrative_voter_drive_activity_indicator.setter
    def administrative_voter_drive_activity_indicator(self, administrative_voter_drive_activity_indicator):
        """Sets the administrative_voter_drive_activity_indicator of this ScheduleH4.


        :param administrative_voter_drive_activity_indicator: The administrative_voter_drive_activity_indicator of this ScheduleH4.  # noqa: E501
        :type: str
        """

        self._administrative_voter_drive_activity_indicator = administrative_voter_drive_activity_indicator

    @property
    def amendment_indicator(self):
        """Gets the amendment_indicator of this ScheduleH4.  # noqa: E501


        :return: The amendment_indicator of this ScheduleH4.  # noqa: E501
        :rtype: str
        """
        return self._amendment_indicator

    @amendment_indicator.setter
    def amendment_indicator(self, amendment_indicator):
        """Sets the amendment_indicator of this ScheduleH4.


        :param amendment_indicator: The amendment_indicator of this ScheduleH4.  # noqa: E501
        :type: str
        """

        self._amendment_indicator = amendment_indicator

    @property
    def amendment_indicator_desc(self):
        """Gets the amendment_indicator_desc of this ScheduleH4.  # noqa: E501


        :return: The amendment_indicator_desc of this ScheduleH4.  # noqa: E501
        :rtype: str
        """
        return self._amendment_indicator_desc

    @amendment_indicator_desc.setter
    def amendment_indicator_desc(self, amendment_indicator_desc):
        """Sets the amendment_indicator_desc of this ScheduleH4.


        :param amendment_indicator_desc: The amendment_indicator_desc of this ScheduleH4.  # noqa: E501
        :type: str
        """

        self._amendment_indicator_desc = amendment_indicator_desc

    @property
    def back_reference_schedule_id(self):
        """Gets the back_reference_schedule_id of this ScheduleH4.  # noqa: E501


        :return: The back_reference_schedule_id of this ScheduleH4.  # noqa: E501
        :rtype: str
        """
        return self._back_reference_schedule_id

    @back_reference_schedule_id.setter
    def back_reference_schedule_id(self, back_reference_schedule_id):
        """Sets the back_reference_schedule_id of this ScheduleH4.


        :param back_reference_schedule_id: The back_reference_schedule_id of this ScheduleH4.  # noqa: E501
        :type: str
        """

        self._back_reference_schedule_id = back_reference_schedule_id

    @property
    def back_reference_transaction_id(self):
        """Gets the back_reference_transaction_id of this ScheduleH4.  # noqa: E501


        :return: The back_reference_transaction_id of this ScheduleH4.  # noqa: E501
        :rtype: str
        """
        return self._back_reference_transaction_id

    @back_reference_transaction_id.setter
    def back_reference_transaction_id(self, back_reference_transaction_id):
        """Sets the back_reference_transaction_id of this ScheduleH4.


        :param back_reference_transaction_id: The back_reference_transaction_id of this ScheduleH4.  # noqa: E501
        :type: str
        """

        self._back_reference_transaction_id = back_reference_transaction_id

    @property
    def candidate_first_name(self):
        """Gets the candidate_first_name of this ScheduleH4.  # noqa: E501


        :return: The candidate_first_name of this ScheduleH4.  # noqa: E501
        :rtype: str
        """
        return self._candidate_first_name

    @candidate_first_name.setter
    def candidate_first_name(self, candidate_first_name):
        """Sets the candidate_first_name of this ScheduleH4.


        :param candidate_first_name: The candidate_first_name of this ScheduleH4.  # noqa: E501
        :type: str
        """

        self._candidate_first_name = candidate_first_name

    @property
    def candidate_id(self):
        """Gets the candidate_id of this ScheduleH4.  # noqa: E501

         A unique identifier assigned to each candidate registered with the FEC. If a person runs for several offices, that person will have separate candidate IDs for each office.   # noqa: E501

        :return: The candidate_id of this ScheduleH4.  # noqa: E501
        :rtype: str
        """
        return self._candidate_id

    @candidate_id.setter
    def candidate_id(self, candidate_id):
        """Sets the candidate_id of this ScheduleH4.

         A unique identifier assigned to each candidate registered with the FEC. If a person runs for several offices, that person will have separate candidate IDs for each office.   # noqa: E501

        :param candidate_id: The candidate_id of this ScheduleH4.  # noqa: E501
        :type: str
        """

        self._candidate_id = candidate_id

    @property
    def candidate_last_name(self):
        """Gets the candidate_last_name of this ScheduleH4.  # noqa: E501


        :return: The candidate_last_name of this ScheduleH4.  # noqa: E501
        :rtype: str
        """
        return self._candidate_last_name

    @candidate_last_name.setter
    def candidate_last_name(self, candidate_last_name):
        """Sets the candidate_last_name of this ScheduleH4.


        :param candidate_last_name: The candidate_last_name of this ScheduleH4.  # noqa: E501
        :type: str
        """

        self._candidate_last_name = candidate_last_name

    @property
    def candidate_name(self):
        """Gets the candidate_name of this ScheduleH4.  # noqa: E501

        Name of candidate running for office  # noqa: E501

        :return: The candidate_name of this ScheduleH4.  # noqa: E501
        :rtype: str
        """
        return self._candidate_name

    @candidate_name.setter
    def candidate_name(self, candidate_name):
        """Sets the candidate_name of this ScheduleH4.

        Name of candidate running for office  # noqa: E501

        :param candidate_name: The candidate_name of this ScheduleH4.  # noqa: E501
        :type: str
        """

        self._candidate_name = candidate_name

    @property
    def candidate_office(self):
        """Gets the candidate_office of this ScheduleH4.  # noqa: E501


        :return: The candidate_office of this ScheduleH4.  # noqa: E501
        :rtype: str
        """
        return self._candidate_office

    @candidate_office.setter
    def candidate_office(self, candidate_office):
        """Sets the candidate_office of this ScheduleH4.


        :param candidate_office: The candidate_office of this ScheduleH4.  # noqa: E501
        :type: str
        """

        self._candidate_office = candidate_office

    @property
    def candidate_office_description(self):
        """Gets the candidate_office_description of this ScheduleH4.  # noqa: E501


        :return: The candidate_office_description of this ScheduleH4.  # noqa: E501
        :rtype: str
        """
        return self._candidate_office_description

    @candidate_office_description.setter
    def candidate_office_description(self, candidate_office_description):
        """Sets the candidate_office_description of this ScheduleH4.


        :param candidate_office_description: The candidate_office_description of this ScheduleH4.  # noqa: E501
        :type: str
        """

        self._candidate_office_description = candidate_office_description

    @property
    def candidate_office_district(self):
        """Gets the candidate_office_district of this ScheduleH4.  # noqa: E501


        :return: The candidate_office_district of this ScheduleH4.  # noqa: E501
        :rtype: str
        """
        return self._candidate_office_district

    @candidate_office_district.setter
    def candidate_office_district(self, candidate_office_district):
        """Sets the candidate_office_district of this ScheduleH4.


        :param candidate_office_district: The candidate_office_district of this ScheduleH4.  # noqa: E501
        :type: str
        """

        self._candidate_office_district = candidate_office_district

    @property
    def candidate_office_state(self):
        """Gets the candidate_office_state of this ScheduleH4.  # noqa: E501


        :return: The candidate_office_state of this ScheduleH4.  # noqa: E501
        :rtype: str
        """
        return self._candidate_office_state

    @candidate_office_state.setter
    def candidate_office_state(self, candidate_office_state):
        """Sets the candidate_office_state of this ScheduleH4.


        :param candidate_office_state: The candidate_office_state of this ScheduleH4.  # noqa: E501
        :type: str
        """

        self._candidate_office_state = candidate_office_state

    @property
    def candidate_office_state_full(self):
        """Gets the candidate_office_state_full of this ScheduleH4.  # noqa: E501


        :return: The candidate_office_state_full of this ScheduleH4.  # noqa: E501
        :rtype: str
        """
        return self._candidate_office_state_full

    @candidate_office_state_full.setter
    def candidate_office_state_full(self, candidate_office_state_full):
        """Sets the candidate_office_state_full of this ScheduleH4.


        :param candidate_office_state_full: The candidate_office_state_full of this ScheduleH4.  # noqa: E501
        :type: str
        """

        self._candidate_office_state_full = candidate_office_state_full

    @property
    def category_code(self):
        """Gets the category_code of this ScheduleH4.  # noqa: E501


        :return: The category_code of this ScheduleH4.  # noqa: E501
        :rtype: str
        """
        return self._category_code

    @category_code.setter
    def category_code(self, category_code):
        """Sets the category_code of this ScheduleH4.


        :param category_code: The category_code of this ScheduleH4.  # noqa: E501
        :type: str
        """

        self._category_code = category_code

    @property
    def category_code_full(self):
        """Gets the category_code_full of this ScheduleH4.  # noqa: E501


        :return: The category_code_full of this ScheduleH4.  # noqa: E501
        :rtype: str
        """
        return self._category_code_full

    @category_code_full.setter
    def category_code_full(self, category_code_full):
        """Sets the category_code_full of this ScheduleH4.


        :param category_code_full: The category_code_full of this ScheduleH4.  # noqa: E501
        :type: str
        """

        self._category_code_full = category_code_full

    @property
    def committee(self):
        """Gets the committee of this ScheduleH4.  # noqa: E501


        :return: The committee of this ScheduleH4.  # noqa: E501
        :rtype: CommitteeHistory
        """
        return self._committee

    @committee.setter
    def committee(self, committee):
        """Sets the committee of this ScheduleH4.


        :param committee: The committee of this ScheduleH4.  # noqa: E501
        :type: CommitteeHistory
        """

        self._committee = committee

    @property
    def committee_id(self):
        """Gets the committee_id of this ScheduleH4.  # noqa: E501


        :return: The committee_id of this ScheduleH4.  # noqa: E501
        :rtype: str
        """
        return self._committee_id

    @committee_id.setter
    def committee_id(self, committee_id):
        """Sets the committee_id of this ScheduleH4.


        :param committee_id: The committee_id of this ScheduleH4.  # noqa: E501
        :type: str
        """

        self._committee_id = committee_id

    @property
    def conduit_committee_city(self):
        """Gets the conduit_committee_city of this ScheduleH4.  # noqa: E501


        :return: The conduit_committee_city of this ScheduleH4.  # noqa: E501
        :rtype: str
        """
        return self._conduit_committee_city

    @conduit_committee_city.setter
    def conduit_committee_city(self, conduit_committee_city):
        """Sets the conduit_committee_city of this ScheduleH4.


        :param conduit_committee_city: The conduit_committee_city of this ScheduleH4.  # noqa: E501
        :type: str
        """

        self._conduit_committee_city = conduit_committee_city

    @property
    def conduit_committee_id(self):
        """Gets the conduit_committee_id of this ScheduleH4.  # noqa: E501


        :return: The conduit_committee_id of this ScheduleH4.  # noqa: E501
        :rtype: str
        """
        return self._conduit_committee_id

    @conduit_committee_id.setter
    def conduit_committee_id(self, conduit_committee_id):
        """Sets the conduit_committee_id of this ScheduleH4.


        :param conduit_committee_id: The conduit_committee_id of this ScheduleH4.  # noqa: E501
        :type: str
        """

        self._conduit_committee_id = conduit_committee_id

    @property
    def conduit_committee_name(self):
        """Gets the conduit_committee_name of this ScheduleH4.  # noqa: E501


        :return: The conduit_committee_name of this ScheduleH4.  # noqa: E501
        :rtype: str
        """
        return self._conduit_committee_name

    @conduit_committee_name.setter
    def conduit_committee_name(self, conduit_committee_name):
        """Sets the conduit_committee_name of this ScheduleH4.


        :param conduit_committee_name: The conduit_committee_name of this ScheduleH4.  # noqa: E501
        :type: str
        """

        self._conduit_committee_name = conduit_committee_name

    @property
    def conduit_committee_state(self):
        """Gets the conduit_committee_state of this ScheduleH4.  # noqa: E501


        :return: The conduit_committee_state of this ScheduleH4.  # noqa: E501
        :rtype: str
        """
        return self._conduit_committee_state

    @conduit_committee_state.setter
    def conduit_committee_state(self, conduit_committee_state):
        """Sets the conduit_committee_state of this ScheduleH4.


        :param conduit_committee_state: The conduit_committee_state of this ScheduleH4.  # noqa: E501
        :type: str
        """

        self._conduit_committee_state = conduit_committee_state

    @property
    def conduit_committee_street1(self):
        """Gets the conduit_committee_street1 of this ScheduleH4.  # noqa: E501


        :return: The conduit_committee_street1 of this ScheduleH4.  # noqa: E501
        :rtype: str
        """
        return self._conduit_committee_street1

    @conduit_committee_street1.setter
    def conduit_committee_street1(self, conduit_committee_street1):
        """Sets the conduit_committee_street1 of this ScheduleH4.


        :param conduit_committee_street1: The conduit_committee_street1 of this ScheduleH4.  # noqa: E501
        :type: str
        """

        self._conduit_committee_street1 = conduit_committee_street1

    @property
    def conduit_committee_street2(self):
        """Gets the conduit_committee_street2 of this ScheduleH4.  # noqa: E501


        :return: The conduit_committee_street2 of this ScheduleH4.  # noqa: E501
        :rtype: str
        """
        return self._conduit_committee_street2

    @conduit_committee_street2.setter
    def conduit_committee_street2(self, conduit_committee_street2):
        """Sets the conduit_committee_street2 of this ScheduleH4.


        :param conduit_committee_street2: The conduit_committee_street2 of this ScheduleH4.  # noqa: E501
        :type: str
        """

        self._conduit_committee_street2 = conduit_committee_street2

    @property
    def conduit_committee_zip(self):
        """Gets the conduit_committee_zip of this ScheduleH4.  # noqa: E501


        :return: The conduit_committee_zip of this ScheduleH4.  # noqa: E501
        :rtype: int
        """
        return self._conduit_committee_zip

    @conduit_committee_zip.setter
    def conduit_committee_zip(self, conduit_committee_zip):
        """Sets the conduit_committee_zip of this ScheduleH4.


        :param conduit_committee_zip: The conduit_committee_zip of this ScheduleH4.  # noqa: E501
        :type: int
        """

        self._conduit_committee_zip = conduit_committee_zip

    @property
    def cycle(self):
        """Gets the cycle of this ScheduleH4.  # noqa: E501


        :return: The cycle of this ScheduleH4.  # noqa: E501
        :rtype: float
        """
        return self._cycle

    @cycle.setter
    def cycle(self, cycle):
        """Sets the cycle of this ScheduleH4.


        :param cycle: The cycle of this ScheduleH4.  # noqa: E501
        :type: float
        """

        self._cycle = cycle

    @property
    def direct_candidate_support_activity_indicator(self):
        """Gets the direct_candidate_support_activity_indicator of this ScheduleH4.  # noqa: E501


        :return: The direct_candidate_support_activity_indicator of this ScheduleH4.  # noqa: E501
        :rtype: str
        """
        return self._direct_candidate_support_activity_indicator

    @direct_candidate_support_activity_indicator.setter
    def direct_candidate_support_activity_indicator(self, direct_candidate_support_activity_indicator):
        """Sets the direct_candidate_support_activity_indicator of this ScheduleH4.


        :param direct_candidate_support_activity_indicator: The direct_candidate_support_activity_indicator of this ScheduleH4.  # noqa: E501
        :type: str
        """

        self._direct_candidate_support_activity_indicator = direct_candidate_support_activity_indicator

    @property
    def disbursement_amount(self):
        """Gets the disbursement_amount of this ScheduleH4.  # noqa: E501


        :return: The disbursement_amount of this ScheduleH4.  # noqa: E501
        :rtype: float
        """
        return self._disbursement_amount

    @disbursement_amount.setter
    def disbursement_amount(self, disbursement_amount):
        """Sets the disbursement_amount of this ScheduleH4.


        :param disbursement_amount: The disbursement_amount of this ScheduleH4.  # noqa: E501
        :type: float
        """

        self._disbursement_amount = disbursement_amount

    @property
    def disbursement_type(self):
        """Gets the disbursement_type of this ScheduleH4.  # noqa: E501


        :return: The disbursement_type of this ScheduleH4.  # noqa: E501
        :rtype: str
        """
        return self._disbursement_type

    @disbursement_type.setter
    def disbursement_type(self, disbursement_type):
        """Sets the disbursement_type of this ScheduleH4.


        :param disbursement_type: The disbursement_type of this ScheduleH4.  # noqa: E501
        :type: str
        """

        self._disbursement_type = disbursement_type

    @property
    def disbursement_type_full(self):
        """Gets the disbursement_type_full of this ScheduleH4.  # noqa: E501


        :return: The disbursement_type_full of this ScheduleH4.  # noqa: E501
        :rtype: str
        """
        return self._disbursement_type_full

    @disbursement_type_full.setter
    def disbursement_type_full(self, disbursement_type_full):
        """Sets the disbursement_type_full of this ScheduleH4.


        :param disbursement_type_full: The disbursement_type_full of this ScheduleH4.  # noqa: E501
        :type: str
        """

        self._disbursement_type_full = disbursement_type_full

    @property
    def entity_type(self):
        """Gets the entity_type of this ScheduleH4.  # noqa: E501


        :return: The entity_type of this ScheduleH4.  # noqa: E501
        :rtype: str
        """
        return self._entity_type

    @entity_type.setter
    def entity_type(self, entity_type):
        """Sets the entity_type of this ScheduleH4.


        :param entity_type: The entity_type of this ScheduleH4.  # noqa: E501
        :type: str
        """

        self._entity_type = entity_type

    @property
    def entity_type_desc(self):
        """Gets the entity_type_desc of this ScheduleH4.  # noqa: E501


        :return: The entity_type_desc of this ScheduleH4.  # noqa: E501
        :rtype: str
        """
        return self._entity_type_desc

    @entity_type_desc.setter
    def entity_type_desc(self, entity_type_desc):
        """Sets the entity_type_desc of this ScheduleH4.


        :param entity_type_desc: The entity_type_desc of this ScheduleH4.  # noqa: E501
        :type: str
        """

        self._entity_type_desc = entity_type_desc

    @property
    def event_amount_year_to_date(self):
        """Gets the event_amount_year_to_date of this ScheduleH4.  # noqa: E501


        :return: The event_amount_year_to_date of this ScheduleH4.  # noqa: E501
        :rtype: float
        """
        return self._event_amount_year_to_date

    @event_amount_year_to_date.setter
    def event_amount_year_to_date(self, event_amount_year_to_date):
        """Sets the event_amount_year_to_date of this ScheduleH4.


        :param event_amount_year_to_date: The event_amount_year_to_date of this ScheduleH4.  # noqa: E501
        :type: float
        """

        self._event_amount_year_to_date = event_amount_year_to_date

    @property
    def event_purpose_category_type(self):
        """Gets the event_purpose_category_type of this ScheduleH4.  # noqa: E501


        :return: The event_purpose_category_type of this ScheduleH4.  # noqa: E501
        :rtype: str
        """
        return self._event_purpose_category_type

    @event_purpose_category_type.setter
    def event_purpose_category_type(self, event_purpose_category_type):
        """Sets the event_purpose_category_type of this ScheduleH4.


        :param event_purpose_category_type: The event_purpose_category_type of this ScheduleH4.  # noqa: E501
        :type: str
        """

        self._event_purpose_category_type = event_purpose_category_type

    @property
    def event_purpose_category_type_full(self):
        """Gets the event_purpose_category_type_full of this ScheduleH4.  # noqa: E501


        :return: The event_purpose_category_type_full of this ScheduleH4.  # noqa: E501
        :rtype: str
        """
        return self._event_purpose_category_type_full

    @event_purpose_category_type_full.setter
    def event_purpose_category_type_full(self, event_purpose_category_type_full):
        """Sets the event_purpose_category_type_full of this ScheduleH4.


        :param event_purpose_category_type_full: The event_purpose_category_type_full of this ScheduleH4.  # noqa: E501
        :type: str
        """

        self._event_purpose_category_type_full = event_purpose_category_type_full

    @property
    def event_purpose_date(self):
        """Gets the event_purpose_date of this ScheduleH4.  # noqa: E501


        :return: The event_purpose_date of this ScheduleH4.  # noqa: E501
        :rtype: date
        """
        return self._event_purpose_date

    @event_purpose_date.setter
    def event_purpose_date(self, event_purpose_date):
        """Sets the event_purpose_date of this ScheduleH4.


        :param event_purpose_date: The event_purpose_date of this ScheduleH4.  # noqa: E501
        :type: date
        """

        self._event_purpose_date = event_purpose_date

    @property
    def event_purpose_description(self):
        """Gets the event_purpose_description of this ScheduleH4.  # noqa: E501


        :return: The event_purpose_description of this ScheduleH4.  # noqa: E501
        :rtype: str
        """
        return self._event_purpose_description

    @event_purpose_description.setter
    def event_purpose_description(self, event_purpose_description):
        """Sets the event_purpose_description of this ScheduleH4.


        :param event_purpose_description: The event_purpose_description of this ScheduleH4.  # noqa: E501
        :type: str
        """

        self._event_purpose_description = event_purpose_description

    @property
    def event_purpose_name(self):
        """Gets the event_purpose_name of this ScheduleH4.  # noqa: E501


        :return: The event_purpose_name of this ScheduleH4.  # noqa: E501
        :rtype: str
        """
        return self._event_purpose_name

    @event_purpose_name.setter
    def event_purpose_name(self, event_purpose_name):
        """Sets the event_purpose_name of this ScheduleH4.


        :param event_purpose_name: The event_purpose_name of this ScheduleH4.  # noqa: E501
        :type: str
        """

        self._event_purpose_name = event_purpose_name

    @property
    def exempt_activity_indicator(self):
        """Gets the exempt_activity_indicator of this ScheduleH4.  # noqa: E501


        :return: The exempt_activity_indicator of this ScheduleH4.  # noqa: E501
        :rtype: str
        """
        return self._exempt_activity_indicator

    @exempt_activity_indicator.setter
    def exempt_activity_indicator(self, exempt_activity_indicator):
        """Sets the exempt_activity_indicator of this ScheduleH4.


        :param exempt_activity_indicator: The exempt_activity_indicator of this ScheduleH4.  # noqa: E501
        :type: str
        """

        self._exempt_activity_indicator = exempt_activity_indicator

    @property
    def federal_share(self):
        """Gets the federal_share of this ScheduleH4.  # noqa: E501


        :return: The federal_share of this ScheduleH4.  # noqa: E501
        :rtype: float
        """
        return self._federal_share

    @federal_share.setter
    def federal_share(self, federal_share):
        """Sets the federal_share of this ScheduleH4.


        :param federal_share: The federal_share of this ScheduleH4.  # noqa: E501
        :type: float
        """

        self._federal_share = federal_share

    @property
    def file_number(self):
        """Gets the file_number of this ScheduleH4.  # noqa: E501


        :return: The file_number of this ScheduleH4.  # noqa: E501
        :rtype: int
        """
        return self._file_number

    @file_number.setter
    def file_number(self, file_number):
        """Sets the file_number of this ScheduleH4.


        :param file_number: The file_number of this ScheduleH4.  # noqa: E501
        :type: int
        """

        self._file_number = file_number

    @property
    def filer_committee_name(self):
        """Gets the filer_committee_name of this ScheduleH4.  # noqa: E501


        :return: The filer_committee_name of this ScheduleH4.  # noqa: E501
        :rtype: str
        """
        return self._filer_committee_name

    @filer_committee_name.setter
    def filer_committee_name(self, filer_committee_name):
        """Sets the filer_committee_name of this ScheduleH4.


        :param filer_committee_name: The filer_committee_name of this ScheduleH4.  # noqa: E501
        :type: str
        """

        self._filer_committee_name = filer_committee_name

    @property
    def filing_form(self):
        """Gets the filing_form of this ScheduleH4.  # noqa: E501


        :return: The filing_form of this ScheduleH4.  # noqa: E501
        :rtype: str
        """
        return self._filing_form

    @filing_form.setter
    def filing_form(self, filing_form):
        """Sets the filing_form of this ScheduleH4.


        :param filing_form: The filing_form of this ScheduleH4.  # noqa: E501
        :type: str
        """

        self._filing_form = filing_form

    @property
    def fundraising_activity_indicator(self):
        """Gets the fundraising_activity_indicator of this ScheduleH4.  # noqa: E501


        :return: The fundraising_activity_indicator of this ScheduleH4.  # noqa: E501
        :rtype: str
        """
        return self._fundraising_activity_indicator

    @fundraising_activity_indicator.setter
    def fundraising_activity_indicator(self, fundraising_activity_indicator):
        """Sets the fundraising_activity_indicator of this ScheduleH4.


        :param fundraising_activity_indicator: The fundraising_activity_indicator of this ScheduleH4.  # noqa: E501
        :type: str
        """

        self._fundraising_activity_indicator = fundraising_activity_indicator

    @property
    def general_voter_drive_activity_indicator(self):
        """Gets the general_voter_drive_activity_indicator of this ScheduleH4.  # noqa: E501


        :return: The general_voter_drive_activity_indicator of this ScheduleH4.  # noqa: E501
        :rtype: str
        """
        return self._general_voter_drive_activity_indicator

    @general_voter_drive_activity_indicator.setter
    def general_voter_drive_activity_indicator(self, general_voter_drive_activity_indicator):
        """Sets the general_voter_drive_activity_indicator of this ScheduleH4.


        :param general_voter_drive_activity_indicator: The general_voter_drive_activity_indicator of this ScheduleH4.  # noqa: E501
        :type: str
        """

        self._general_voter_drive_activity_indicator = general_voter_drive_activity_indicator

    @property
    def image_number(self):
        """Gets the image_number of this ScheduleH4.  # noqa: E501


        :return: The image_number of this ScheduleH4.  # noqa: E501
        :rtype: str
        """
        return self._image_number

    @image_number.setter
    def image_number(self, image_number):
        """Sets the image_number of this ScheduleH4.


        :param image_number: The image_number of this ScheduleH4.  # noqa: E501
        :type: str
        """

        self._image_number = image_number

    @property
    def line_number(self):
        """Gets the line_number of this ScheduleH4.  # noqa: E501


        :return: The line_number of this ScheduleH4.  # noqa: E501
        :rtype: str
        """
        return self._line_number

    @line_number.setter
    def line_number(self, line_number):
        """Sets the line_number of this ScheduleH4.


        :param line_number: The line_number of this ScheduleH4.  # noqa: E501
        :type: str
        """

        self._line_number = line_number

    @property
    def link_id(self):
        """Gets the link_id of this ScheduleH4.  # noqa: E501


        :return: The link_id of this ScheduleH4.  # noqa: E501
        :rtype: int
        """
        return self._link_id

    @link_id.setter
    def link_id(self, link_id):
        """Sets the link_id of this ScheduleH4.


        :param link_id: The link_id of this ScheduleH4.  # noqa: E501
        :type: int
        """

        self._link_id = link_id

    @property
    def load_date(self):
        """Gets the load_date of this ScheduleH4.  # noqa: E501


        :return: The load_date of this ScheduleH4.  # noqa: E501
        :rtype: datetime
        """
        return self._load_date

    @load_date.setter
    def load_date(self, load_date):
        """Sets the load_date of this ScheduleH4.


        :param load_date: The load_date of this ScheduleH4.  # noqa: E501
        :type: datetime
        """

        self._load_date = load_date

    @property
    def memo_code(self):
        """Gets the memo_code of this ScheduleH4.  # noqa: E501


        :return: The memo_code of this ScheduleH4.  # noqa: E501
        :rtype: str
        """
        return self._memo_code

    @memo_code.setter
    def memo_code(self, memo_code):
        """Sets the memo_code of this ScheduleH4.


        :param memo_code: The memo_code of this ScheduleH4.  # noqa: E501
        :type: str
        """

        self._memo_code = memo_code

    @property
    def memo_code_description(self):
        """Gets the memo_code_description of this ScheduleH4.  # noqa: E501


        :return: The memo_code_description of this ScheduleH4.  # noqa: E501
        :rtype: str
        """
        return self._memo_code_description

    @memo_code_description.setter
    def memo_code_description(self, memo_code_description):
        """Sets the memo_code_description of this ScheduleH4.


        :param memo_code_description: The memo_code_description of this ScheduleH4.  # noqa: E501
        :type: str
        """

        self._memo_code_description = memo_code_description

    @property
    def memo_text(self):
        """Gets the memo_text of this ScheduleH4.  # noqa: E501


        :return: The memo_text of this ScheduleH4.  # noqa: E501
        :rtype: str
        """
        return self._memo_text

    @memo_text.setter
    def memo_text(self, memo_text):
        """Sets the memo_text of this ScheduleH4.


        :param memo_text: The memo_text of this ScheduleH4.  # noqa: E501
        :type: str
        """

        self._memo_text = memo_text

    @property
    def nonfederal_share(self):
        """Gets the nonfederal_share of this ScheduleH4.  # noqa: E501


        :return: The nonfederal_share of this ScheduleH4.  # noqa: E501
        :rtype: float
        """
        return self._nonfederal_share

    @nonfederal_share.setter
    def nonfederal_share(self, nonfederal_share):
        """Sets the nonfederal_share of this ScheduleH4.


        :param nonfederal_share: The nonfederal_share of this ScheduleH4.  # noqa: E501
        :type: float
        """

        self._nonfederal_share = nonfederal_share

    @property
    def original_sub_id(self):
        """Gets the original_sub_id of this ScheduleH4.  # noqa: E501


        :return: The original_sub_id of this ScheduleH4.  # noqa: E501
        :rtype: str
        """
        return self._original_sub_id

    @original_sub_id.setter
    def original_sub_id(self, original_sub_id):
        """Sets the original_sub_id of this ScheduleH4.


        :param original_sub_id: The original_sub_id of this ScheduleH4.  # noqa: E501
        :type: str
        """

        self._original_sub_id = original_sub_id

    @property
    def payee_city(self):
        """Gets the payee_city of this ScheduleH4.  # noqa: E501


        :return: The payee_city of this ScheduleH4.  # noqa: E501
        :rtype: str
        """
        return self._payee_city

    @payee_city.setter
    def payee_city(self, payee_city):
        """Sets the payee_city of this ScheduleH4.


        :param payee_city: The payee_city of this ScheduleH4.  # noqa: E501
        :type: str
        """

        self._payee_city = payee_city

    @property
    def payee_first_name(self):
        """Gets the payee_first_name of this ScheduleH4.  # noqa: E501


        :return: The payee_first_name of this ScheduleH4.  # noqa: E501
        :rtype: str
        """
        return self._payee_first_name

    @payee_first_name.setter
    def payee_first_name(self, payee_first_name):
        """Sets the payee_first_name of this ScheduleH4.


        :param payee_first_name: The payee_first_name of this ScheduleH4.  # noqa: E501
        :type: str
        """

        self._payee_first_name = payee_first_name

    @property
    def payee_last_name(self):
        """Gets the payee_last_name of this ScheduleH4.  # noqa: E501


        :return: The payee_last_name of this ScheduleH4.  # noqa: E501
        :rtype: str
        """
        return self._payee_last_name

    @payee_last_name.setter
    def payee_last_name(self, payee_last_name):
        """Sets the payee_last_name of this ScheduleH4.


        :param payee_last_name: The payee_last_name of this ScheduleH4.  # noqa: E501
        :type: str
        """

        self._payee_last_name = payee_last_name

    @property
    def payee_middle_name(self):
        """Gets the payee_middle_name of this ScheduleH4.  # noqa: E501


        :return: The payee_middle_name of this ScheduleH4.  # noqa: E501
        :rtype: str
        """
        return self._payee_middle_name

    @payee_middle_name.setter
    def payee_middle_name(self, payee_middle_name):
        """Sets the payee_middle_name of this ScheduleH4.


        :param payee_middle_name: The payee_middle_name of this ScheduleH4.  # noqa: E501
        :type: str
        """

        self._payee_middle_name = payee_middle_name

    @property
    def payee_name(self):
        """Gets the payee_name of this ScheduleH4.  # noqa: E501


        :return: The payee_name of this ScheduleH4.  # noqa: E501
        :rtype: str
        """
        return self._payee_name

    @payee_name.setter
    def payee_name(self, payee_name):
        """Sets the payee_name of this ScheduleH4.


        :param payee_name: The payee_name of this ScheduleH4.  # noqa: E501
        :type: str
        """

        self._payee_name = payee_name

    @property
    def payee_prefix(self):
        """Gets the payee_prefix of this ScheduleH4.  # noqa: E501


        :return: The payee_prefix of this ScheduleH4.  # noqa: E501
        :rtype: str
        """
        return self._payee_prefix

    @payee_prefix.setter
    def payee_prefix(self, payee_prefix):
        """Sets the payee_prefix of this ScheduleH4.


        :param payee_prefix: The payee_prefix of this ScheduleH4.  # noqa: E501
        :type: str
        """

        self._payee_prefix = payee_prefix

    @property
    def payee_state(self):
        """Gets the payee_state of this ScheduleH4.  # noqa: E501


        :return: The payee_state of this ScheduleH4.  # noqa: E501
        :rtype: str
        """
        return self._payee_state

    @payee_state.setter
    def payee_state(self, payee_state):
        """Sets the payee_state of this ScheduleH4.


        :param payee_state: The payee_state of this ScheduleH4.  # noqa: E501
        :type: str
        """

        self._payee_state = payee_state

    @property
    def payee_suffix(self):
        """Gets the payee_suffix of this ScheduleH4.  # noqa: E501


        :return: The payee_suffix of this ScheduleH4.  # noqa: E501
        :rtype: str
        """
        return self._payee_suffix

    @payee_suffix.setter
    def payee_suffix(self, payee_suffix):
        """Sets the payee_suffix of this ScheduleH4.


        :param payee_suffix: The payee_suffix of this ScheduleH4.  # noqa: E501
        :type: str
        """

        self._payee_suffix = payee_suffix

    @property
    def payee_zip(self):
        """Gets the payee_zip of this ScheduleH4.  # noqa: E501


        :return: The payee_zip of this ScheduleH4.  # noqa: E501
        :rtype: str
        """
        return self._payee_zip

    @payee_zip.setter
    def payee_zip(self, payee_zip):
        """Sets the payee_zip of this ScheduleH4.


        :param payee_zip: The payee_zip of this ScheduleH4.  # noqa: E501
        :type: str
        """

        self._payee_zip = payee_zip

    @property
    def published_committee_reference_parity_check(self):
        """Gets the published_committee_reference_parity_check of this ScheduleH4.  # noqa: E501


        :return: The published_committee_reference_parity_check of this ScheduleH4.  # noqa: E501
        :rtype: str
        """
        return self._published_committee_reference_parity_check

    @published_committee_reference_parity_check.setter
    def published_committee_reference_parity_check(self, published_committee_reference_parity_check):
        """Sets the published_committee_reference_parity_check of this ScheduleH4.


        :param published_committee_reference_parity_check: The published_committee_reference_parity_check of this ScheduleH4.  # noqa: E501
        :type: str
        """

        self._published_committee_reference_parity_check = published_committee_reference_parity_check

    @property
    def report_type(self):
        """Gets the report_type of this ScheduleH4.  # noqa: E501


        :return: The report_type of this ScheduleH4.  # noqa: E501
        :rtype: str
        """
        return self._report_type

    @report_type.setter
    def report_type(self, report_type):
        """Sets the report_type of this ScheduleH4.


        :param report_type: The report_type of this ScheduleH4.  # noqa: E501
        :type: str
        """

        self._report_type = report_type

    @property
    def report_year(self):
        """Gets the report_year of this ScheduleH4.  # noqa: E501


        :return: The report_year of this ScheduleH4.  # noqa: E501
        :rtype: float
        """
        return self._report_year

    @report_year.setter
    def report_year(self, report_year):
        """Sets the report_year of this ScheduleH4.


        :param report_year: The report_year of this ScheduleH4.  # noqa: E501
        :type: float
        """

        self._report_year = report_year

    @property
    def schedule_type(self):
        """Gets the schedule_type of this ScheduleH4.  # noqa: E501


        :return: The schedule_type of this ScheduleH4.  # noqa: E501
        :rtype: str
        """
        return self._schedule_type

    @schedule_type.setter
    def schedule_type(self, schedule_type):
        """Sets the schedule_type of this ScheduleH4.


        :param schedule_type: The schedule_type of this ScheduleH4.  # noqa: E501
        :type: str
        """

        self._schedule_type = schedule_type

    @property
    def schedule_type_full(self):
        """Gets the schedule_type_full of this ScheduleH4.  # noqa: E501


        :return: The schedule_type_full of this ScheduleH4.  # noqa: E501
        :rtype: str
        """
        return self._schedule_type_full

    @schedule_type_full.setter
    def schedule_type_full(self, schedule_type_full):
        """Sets the schedule_type_full of this ScheduleH4.


        :param schedule_type_full: The schedule_type_full of this ScheduleH4.  # noqa: E501
        :type: str
        """

        self._schedule_type_full = schedule_type_full

    @property
    def sub_id(self):
        """Gets the sub_id of this ScheduleH4.  # noqa: E501


        :return: The sub_id of this ScheduleH4.  # noqa: E501
        :rtype: str
        """
        return self._sub_id

    @sub_id.setter
    def sub_id(self, sub_id):
        """Sets the sub_id of this ScheduleH4.


        :param sub_id: The sub_id of this ScheduleH4.  # noqa: E501
        :type: str
        """

        self._sub_id = sub_id

    @property
    def transaction_id(self):
        """Gets the transaction_id of this ScheduleH4.  # noqa: E501


        :return: The transaction_id of this ScheduleH4.  # noqa: E501
        :rtype: str
        """
        return self._transaction_id

    @transaction_id.setter
    def transaction_id(self, transaction_id):
        """Sets the transaction_id of this ScheduleH4.


        :param transaction_id: The transaction_id of this ScheduleH4.  # noqa: E501
        :type: str
        """

        self._transaction_id = transaction_id

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, 'to_dict') else x,
                    value
                ))
            elif hasattr(value, 'to_dict'):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], 'to_dict') else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ScheduleH4):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, ScheduleH4):
            return True

        return self.to_dict() != other.to_dict()
