# coding: utf-8

"""
    OpenFEC

    This API allows you to explore the way candidates and committees fund their campaigns.    The FEC API is a RESTful web service supporting full-text and field-specific searches on FEC data. [Bulk downloads](https://www.fec.gov/data/advanced/?tab=bulk-data) are available on the current site. Information is tied to the underlying forms by file ID and image ID. Data is updated nightly.    There is a lot of data, but a good place to start is to use search to find interesting candidates and committees. Then, you can use their IDs to find report or line item details with the other endpoints. If you are interested in individual donors, check out contributor information in schedule_a.    Get an [API key here](https://api.data.gov/signup/). That will enable you to place up to 1,000 calls an hour. Each call is limited to 100 results per page. You can email questions, comments or a request to get a key for 120 calls per minute to [APIinfo@fec.gov](mailto:apiinfo@fec.gov). You can also ask questions and discuss the data in the [FEC data Google Group](https://groups.google.com/forum/#!forum/fec-data). API changes will also be added to this group in advance of the change.    The model definitions and schema are available at [/swagger](/swagger/). This is useful for making wrappers and exploring the data.    A few restrictions limit the way you can use FEC data. For example, you can’t use contributor lists for commercial purposes or to solicit donations. [Learn more here](https://www.fec.gov/updates/sale-or-use-contributor-information/).    [View our source code](https://github.com/fecgov/openFEC). We welcome issues and pull requests!  # noqa: E501

    The version of the OpenAPI document: 1.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from openfec_sdk.configuration import Configuration


class StateElectionOfficeInfo(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'address_line1': 'str',
        'address_line2': 'str',
        'city': 'str',
        'email': 'str',
        'fax_number': 'str',
        'mailing_address1': 'str',
        'mailing_address2': 'str',
        'mailing_city': 'str',
        'mailing_state': 'str',
        'mailing_zipcode': 'str',
        'office_name': 'str',
        'office_type': 'str',
        'primary_phone_number': 'str',
        'secondary_phone_number': 'str',
        'state': 'str',
        'state_full_name': 'str',
        'website_url1': 'str',
        'website_url2': 'str',
        'zip_code': 'str'
    }

    attribute_map = {
        'address_line1': 'address_line1',
        'address_line2': 'address_line2',
        'city': 'city',
        'email': 'email',
        'fax_number': 'fax_number',
        'mailing_address1': 'mailing_address1',
        'mailing_address2': 'mailing_address2',
        'mailing_city': 'mailing_city',
        'mailing_state': 'mailing_state',
        'mailing_zipcode': 'mailing_zipcode',
        'office_name': 'office_name',
        'office_type': 'office_type',
        'primary_phone_number': 'primary_phone_number',
        'secondary_phone_number': 'secondary_phone_number',
        'state': 'state',
        'state_full_name': 'state_full_name',
        'website_url1': 'website_url1',
        'website_url2': 'website_url2',
        'zip_code': 'zip_code'
    }

    def __init__(self, address_line1=None, address_line2=None, city=None, email=None, fax_number=None, mailing_address1=None, mailing_address2=None, mailing_city=None, mailing_state=None, mailing_zipcode=None, office_name=None, office_type=None, primary_phone_number=None, secondary_phone_number=None, state=None, state_full_name=None, website_url1=None, website_url2=None, zip_code=None, local_vars_configuration=None):  # noqa: E501
        """StateElectionOfficeInfo - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._address_line1 = None
        self._address_line2 = None
        self._city = None
        self._email = None
        self._fax_number = None
        self._mailing_address1 = None
        self._mailing_address2 = None
        self._mailing_city = None
        self._mailing_state = None
        self._mailing_zipcode = None
        self._office_name = None
        self._office_type = None
        self._primary_phone_number = None
        self._secondary_phone_number = None
        self._state = None
        self._state_full_name = None
        self._website_url1 = None
        self._website_url2 = None
        self._zip_code = None
        self.discriminator = None

        self.address_line1 = address_line1
        self.address_line2 = address_line2
        self.city = city
        self.email = email
        self.fax_number = fax_number
        self.mailing_address1 = mailing_address1
        self.mailing_address2 = mailing_address2
        self.mailing_city = mailing_city
        self.mailing_state = mailing_state
        self.mailing_zipcode = mailing_zipcode
        self.office_name = office_name
        self.office_type = office_type
        self.primary_phone_number = primary_phone_number
        self.secondary_phone_number = secondary_phone_number
        self.state = state
        self.state_full_name = state_full_name
        self.website_url1 = website_url1
        self.website_url2 = website_url2
        self.zip_code = zip_code

    @property
    def address_line1(self):
        """Gets the address_line1 of this StateElectionOfficeInfo.  # noqa: E501


        :return: The address_line1 of this StateElectionOfficeInfo.  # noqa: E501
        :rtype: str
        """
        return self._address_line1

    @address_line1.setter
    def address_line1(self, address_line1):
        """Sets the address_line1 of this StateElectionOfficeInfo.


        :param address_line1: The address_line1 of this StateElectionOfficeInfo.  # noqa: E501
        :type: str
        """

        self._address_line1 = address_line1

    @property
    def address_line2(self):
        """Gets the address_line2 of this StateElectionOfficeInfo.  # noqa: E501


        :return: The address_line2 of this StateElectionOfficeInfo.  # noqa: E501
        :rtype: str
        """
        return self._address_line2

    @address_line2.setter
    def address_line2(self, address_line2):
        """Sets the address_line2 of this StateElectionOfficeInfo.


        :param address_line2: The address_line2 of this StateElectionOfficeInfo.  # noqa: E501
        :type: str
        """

        self._address_line2 = address_line2

    @property
    def city(self):
        """Gets the city of this StateElectionOfficeInfo.  # noqa: E501


        :return: The city of this StateElectionOfficeInfo.  # noqa: E501
        :rtype: str
        """
        return self._city

    @city.setter
    def city(self, city):
        """Sets the city of this StateElectionOfficeInfo.


        :param city: The city of this StateElectionOfficeInfo.  # noqa: E501
        :type: str
        """

        self._city = city

    @property
    def email(self):
        """Gets the email of this StateElectionOfficeInfo.  # noqa: E501


        :return: The email of this StateElectionOfficeInfo.  # noqa: E501
        :rtype: str
        """
        return self._email

    @email.setter
    def email(self, email):
        """Sets the email of this StateElectionOfficeInfo.


        :param email: The email of this StateElectionOfficeInfo.  # noqa: E501
        :type: str
        """

        self._email = email

    @property
    def fax_number(self):
        """Gets the fax_number of this StateElectionOfficeInfo.  # noqa: E501


        :return: The fax_number of this StateElectionOfficeInfo.  # noqa: E501
        :rtype: str
        """
        return self._fax_number

    @fax_number.setter
    def fax_number(self, fax_number):
        """Sets the fax_number of this StateElectionOfficeInfo.


        :param fax_number: The fax_number of this StateElectionOfficeInfo.  # noqa: E501
        :type: str
        """

        self._fax_number = fax_number

    @property
    def mailing_address1(self):
        """Gets the mailing_address1 of this StateElectionOfficeInfo.  # noqa: E501


        :return: The mailing_address1 of this StateElectionOfficeInfo.  # noqa: E501
        :rtype: str
        """
        return self._mailing_address1

    @mailing_address1.setter
    def mailing_address1(self, mailing_address1):
        """Sets the mailing_address1 of this StateElectionOfficeInfo.


        :param mailing_address1: The mailing_address1 of this StateElectionOfficeInfo.  # noqa: E501
        :type: str
        """

        self._mailing_address1 = mailing_address1

    @property
    def mailing_address2(self):
        """Gets the mailing_address2 of this StateElectionOfficeInfo.  # noqa: E501


        :return: The mailing_address2 of this StateElectionOfficeInfo.  # noqa: E501
        :rtype: str
        """
        return self._mailing_address2

    @mailing_address2.setter
    def mailing_address2(self, mailing_address2):
        """Sets the mailing_address2 of this StateElectionOfficeInfo.


        :param mailing_address2: The mailing_address2 of this StateElectionOfficeInfo.  # noqa: E501
        :type: str
        """

        self._mailing_address2 = mailing_address2

    @property
    def mailing_city(self):
        """Gets the mailing_city of this StateElectionOfficeInfo.  # noqa: E501


        :return: The mailing_city of this StateElectionOfficeInfo.  # noqa: E501
        :rtype: str
        """
        return self._mailing_city

    @mailing_city.setter
    def mailing_city(self, mailing_city):
        """Sets the mailing_city of this StateElectionOfficeInfo.


        :param mailing_city: The mailing_city of this StateElectionOfficeInfo.  # noqa: E501
        :type: str
        """

        self._mailing_city = mailing_city

    @property
    def mailing_state(self):
        """Gets the mailing_state of this StateElectionOfficeInfo.  # noqa: E501


        :return: The mailing_state of this StateElectionOfficeInfo.  # noqa: E501
        :rtype: str
        """
        return self._mailing_state

    @mailing_state.setter
    def mailing_state(self, mailing_state):
        """Sets the mailing_state of this StateElectionOfficeInfo.


        :param mailing_state: The mailing_state of this StateElectionOfficeInfo.  # noqa: E501
        :type: str
        """

        self._mailing_state = mailing_state

    @property
    def mailing_zipcode(self):
        """Gets the mailing_zipcode of this StateElectionOfficeInfo.  # noqa: E501


        :return: The mailing_zipcode of this StateElectionOfficeInfo.  # noqa: E501
        :rtype: str
        """
        return self._mailing_zipcode

    @mailing_zipcode.setter
    def mailing_zipcode(self, mailing_zipcode):
        """Sets the mailing_zipcode of this StateElectionOfficeInfo.


        :param mailing_zipcode: The mailing_zipcode of this StateElectionOfficeInfo.  # noqa: E501
        :type: str
        """

        self._mailing_zipcode = mailing_zipcode

    @property
    def office_name(self):
        """Gets the office_name of this StateElectionOfficeInfo.  # noqa: E501


        :return: The office_name of this StateElectionOfficeInfo.  # noqa: E501
        :rtype: str
        """
        return self._office_name

    @office_name.setter
    def office_name(self, office_name):
        """Sets the office_name of this StateElectionOfficeInfo.


        :param office_name: The office_name of this StateElectionOfficeInfo.  # noqa: E501
        :type: str
        """

        self._office_name = office_name

    @property
    def office_type(self):
        """Gets the office_type of this StateElectionOfficeInfo.  # noqa: E501


        :return: The office_type of this StateElectionOfficeInfo.  # noqa: E501
        :rtype: str
        """
        return self._office_type

    @office_type.setter
    def office_type(self, office_type):
        """Sets the office_type of this StateElectionOfficeInfo.


        :param office_type: The office_type of this StateElectionOfficeInfo.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and office_type is None:  # noqa: E501
            raise ValueError('Invalid value for `office_type`, must not be `None`')  # noqa: E501

        self._office_type = office_type

    @property
    def primary_phone_number(self):
        """Gets the primary_phone_number of this StateElectionOfficeInfo.  # noqa: E501


        :return: The primary_phone_number of this StateElectionOfficeInfo.  # noqa: E501
        :rtype: str
        """
        return self._primary_phone_number

    @primary_phone_number.setter
    def primary_phone_number(self, primary_phone_number):
        """Sets the primary_phone_number of this StateElectionOfficeInfo.


        :param primary_phone_number: The primary_phone_number of this StateElectionOfficeInfo.  # noqa: E501
        :type: str
        """

        self._primary_phone_number = primary_phone_number

    @property
    def secondary_phone_number(self):
        """Gets the secondary_phone_number of this StateElectionOfficeInfo.  # noqa: E501


        :return: The secondary_phone_number of this StateElectionOfficeInfo.  # noqa: E501
        :rtype: str
        """
        return self._secondary_phone_number

    @secondary_phone_number.setter
    def secondary_phone_number(self, secondary_phone_number):
        """Sets the secondary_phone_number of this StateElectionOfficeInfo.


        :param secondary_phone_number: The secondary_phone_number of this StateElectionOfficeInfo.  # noqa: E501
        :type: str
        """

        self._secondary_phone_number = secondary_phone_number

    @property
    def state(self):
        """Gets the state of this StateElectionOfficeInfo.  # noqa: E501


        :return: The state of this StateElectionOfficeInfo.  # noqa: E501
        :rtype: str
        """
        return self._state

    @state.setter
    def state(self, state):
        """Sets the state of this StateElectionOfficeInfo.


        :param state: The state of this StateElectionOfficeInfo.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and state is None:  # noqa: E501
            raise ValueError('Invalid value for `state`, must not be `None`')  # noqa: E501

        self._state = state

    @property
    def state_full_name(self):
        """Gets the state_full_name of this StateElectionOfficeInfo.  # noqa: E501


        :return: The state_full_name of this StateElectionOfficeInfo.  # noqa: E501
        :rtype: str
        """
        return self._state_full_name

    @state_full_name.setter
    def state_full_name(self, state_full_name):
        """Sets the state_full_name of this StateElectionOfficeInfo.


        :param state_full_name: The state_full_name of this StateElectionOfficeInfo.  # noqa: E501
        :type: str
        """

        self._state_full_name = state_full_name

    @property
    def website_url1(self):
        """Gets the website_url1 of this StateElectionOfficeInfo.  # noqa: E501


        :return: The website_url1 of this StateElectionOfficeInfo.  # noqa: E501
        :rtype: str
        """
        return self._website_url1

    @website_url1.setter
    def website_url1(self, website_url1):
        """Sets the website_url1 of this StateElectionOfficeInfo.


        :param website_url1: The website_url1 of this StateElectionOfficeInfo.  # noqa: E501
        :type: str
        """

        self._website_url1 = website_url1

    @property
    def website_url2(self):
        """Gets the website_url2 of this StateElectionOfficeInfo.  # noqa: E501


        :return: The website_url2 of this StateElectionOfficeInfo.  # noqa: E501
        :rtype: str
        """
        return self._website_url2

    @website_url2.setter
    def website_url2(self, website_url2):
        """Sets the website_url2 of this StateElectionOfficeInfo.


        :param website_url2: The website_url2 of this StateElectionOfficeInfo.  # noqa: E501
        :type: str
        """

        self._website_url2 = website_url2

    @property
    def zip_code(self):
        """Gets the zip_code of this StateElectionOfficeInfo.  # noqa: E501


        :return: The zip_code of this StateElectionOfficeInfo.  # noqa: E501
        :rtype: str
        """
        return self._zip_code

    @zip_code.setter
    def zip_code(self, zip_code):
        """Sets the zip_code of this StateElectionOfficeInfo.


        :param zip_code: The zip_code of this StateElectionOfficeInfo.  # noqa: E501
        :type: str
        """

        self._zip_code = zip_code

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, 'to_dict') else x,
                    value
                ))
            elif hasattr(value, 'to_dict'):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], 'to_dict') else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, StateElectionOfficeInfo):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, StateElectionOfficeInfo):
            return True

        return self.to_dict() != other.to_dict()
