# coding: utf-8

"""
    OpenFEC

    This API allows you to explore the way candidates and committees fund their campaigns.    The FEC API is a RESTful web service supporting full-text and field-specific searches on FEC data. [Bulk downloads](https://www.fec.gov/data/advanced/?tab=bulk-data) are available on the current site. Information is tied to the underlying forms by file ID and image ID. Data is updated nightly.    There is a lot of data, but a good place to start is to use search to find interesting candidates and committees. Then, you can use their IDs to find report or line item details with the other endpoints. If you are interested in individual donors, check out contributor information in schedule_a.    Get an [API key here](https://api.data.gov/signup/). That will enable you to place up to 1,000 calls an hour. Each call is limited to 100 results per page. You can email questions, comments or a request to get a key for 120 calls per minute to [APIinfo@fec.gov](mailto:apiinfo@fec.gov). You can also ask questions and discuss the data in the [FEC data Google Group](https://groups.google.com/forum/#!forum/fec-data). API changes will also be added to this group in advance of the change.    The model definitions and schema are available at [/swagger](/swagger/). This is useful for making wrappers and exploring the data.    A few restrictions limit the way you can use FEC data. For example, you can’t use contributor lists for commercial purposes or to solicit donations. [Learn more here](https://www.fec.gov/updates/sale-or-use-contributor-information/).    [View our source code](https://github.com/fecgov/openFEC). We welcome issues and pull requests!  # noqa: E501

    The version of the OpenAPI document: 1.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from openfec_sdk.api_client import ApiClient
from openfec_sdk.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class CommitteeApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def candidate_candidate_id_committees_get(self, api_key, candidate_id, **kwargs):  # noqa: E501
        """candidate_candidate_id_committees_get  # noqa: E501

         This endpoint is useful for finding detailed information about a particular committee or filer. Use the `committee_id` to find the most recent information about the committee.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.candidate_candidate_id_committees_get(api_key, candidate_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param str candidate_id:  A unique identifier assigned to each candidate registered with the FEC. If a person runs for several offices, that person will have separate candidate IDs for each office.  (required)
        :param list[int] year: A year that the committee was active— (after original registration date     or filing but before expiration date)
        :param list[str] filing_frequency: The one-letter      code of the filing frequency:          - A Administratively terminated          - D Debt          - M Monthly filer          - Q Quarterly filer          - T Terminated          - W Waived
        :param str sort: Provide a field to sort by. Use `-` for descending order.
        :param bool sort_hide_null: Hide null values on sorted column(s).
        :param int per_page: The number of results returned per page. Defaults to 20.
        :param list[str] designation: The one-letter designation code of the organization:          - A authorized by a candidate          - J joint fundraising committee          - P principal campaign committee of a candidate          - U unauthorized          - B lobbyist/registrant PAC          - D leadership PAC
        :param list[str] committee_type: The one-letter type code of the organization:         - C communication cost         - D delegate         - E electioneering communication         - H House         - I independent expenditor (person or group)         - N PAC - nonqualified         - O independent expenditure-only (super PACs)         - P presidential         - Q PAC - qualified         - S Senate         - U single candidate independent expenditure         - V PAC with non-contribution account, nonqualified         - W PAC with non-contribution account, qualified         - X party, nonqualified         - Y party, qualified         - Z national party non-federal account
        :param bool sort_nulls_last: Toggle that sorts null values last
        :param list[int] cycle:  A two year election cycle that the committee was active- (after original registration date but before expiration date in FEC Form 1s) The cycle begins with an odd year and is named for its ending, even year.
        :param int page: For paginating through results, starting at page 1
        :param list[str] organization_type: The one-letter code for the kind for organization:         - C corporation         - L labor organization         - M membership organization         - T trade association         - V cooperative         - W corporation without capital stock
        :param bool sort_null_only: Toggle that filters out all rows having sort column that is non-null
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: CommitteeDetailPage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.candidate_candidate_id_committees_get_with_http_info(api_key, candidate_id, **kwargs)  # noqa: E501

    def candidate_candidate_id_committees_get_with_http_info(self, api_key, candidate_id, **kwargs):  # noqa: E501
        """candidate_candidate_id_committees_get  # noqa: E501

         This endpoint is useful for finding detailed information about a particular committee or filer. Use the `committee_id` to find the most recent information about the committee.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.candidate_candidate_id_committees_get_with_http_info(api_key, candidate_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param str candidate_id:  A unique identifier assigned to each candidate registered with the FEC. If a person runs for several offices, that person will have separate candidate IDs for each office.  (required)
        :param list[int] year: A year that the committee was active— (after original registration date     or filing but before expiration date)
        :param list[str] filing_frequency: The one-letter      code of the filing frequency:          - A Administratively terminated          - D Debt          - M Monthly filer          - Q Quarterly filer          - T Terminated          - W Waived
        :param str sort: Provide a field to sort by. Use `-` for descending order.
        :param bool sort_hide_null: Hide null values on sorted column(s).
        :param int per_page: The number of results returned per page. Defaults to 20.
        :param list[str] designation: The one-letter designation code of the organization:          - A authorized by a candidate          - J joint fundraising committee          - P principal campaign committee of a candidate          - U unauthorized          - B lobbyist/registrant PAC          - D leadership PAC
        :param list[str] committee_type: The one-letter type code of the organization:         - C communication cost         - D delegate         - E electioneering communication         - H House         - I independent expenditor (person or group)         - N PAC - nonqualified         - O independent expenditure-only (super PACs)         - P presidential         - Q PAC - qualified         - S Senate         - U single candidate independent expenditure         - V PAC with non-contribution account, nonqualified         - W PAC with non-contribution account, qualified         - X party, nonqualified         - Y party, qualified         - Z national party non-federal account
        :param bool sort_nulls_last: Toggle that sorts null values last
        :param list[int] cycle:  A two year election cycle that the committee was active- (after original registration date but before expiration date in FEC Form 1s) The cycle begins with an odd year and is named for its ending, even year.
        :param int page: For paginating through results, starting at page 1
        :param list[str] organization_type: The one-letter code for the kind for organization:         - C corporation         - L labor organization         - M membership organization         - T trade association         - V cooperative         - W corporation without capital stock
        :param bool sort_null_only: Toggle that filters out all rows having sort column that is non-null
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(CommitteeDetailPage, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'api_key',
            'candidate_id',
            'year',
            'filing_frequency',
            'sort',
            'sort_hide_null',
            'per_page',
            'designation',
            'committee_type',
            'sort_nulls_last',
            'cycle',
            'page',
            'organization_type',
            'sort_null_only'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    ' to method candidate_candidate_id_committees_get' % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'api_key' is set
        if self.api_client.client_side_validation and ('api_key' not in local_var_params or  # noqa: E501
                                                        local_var_params['api_key'] is None):  # noqa: E501
            raise ApiValueError('Missing the required parameter `api_key` when calling `candidate_candidate_id_committees_get`')  # noqa: E501
        # verify the required parameter 'candidate_id' is set
        if self.api_client.client_side_validation and ('candidate_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['candidate_id'] is None):  # noqa: E501
            raise ApiValueError('Missing the required parameter `candidate_id` when calling `candidate_candidate_id_committees_get`')  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'candidate_id' in local_var_params:
            path_params['candidate_id'] = local_var_params['candidate_id']  # noqa: E501

        query_params = []
        if 'year' in local_var_params and local_var_params['year'] is not None:  # noqa: E501
            query_params.append(('year', local_var_params['year']))  # noqa: E501
            collection_formats['year'] = 'multi'  # noqa: E501
        if 'api_key' in local_var_params and local_var_params['api_key'] is not None:  # noqa: E501
            query_params.append(('api_key', local_var_params['api_key']))  # noqa: E501
        if 'filing_frequency' in local_var_params and local_var_params['filing_frequency'] is not None:  # noqa: E501
            query_params.append(('filing_frequency', local_var_params['filing_frequency']))  # noqa: E501
            collection_formats['filing_frequency'] = 'multi'  # noqa: E501
        if 'sort' in local_var_params and local_var_params['sort'] is not None:  # noqa: E501
            query_params.append(('sort', local_var_params['sort']))  # noqa: E501
        if 'sort_hide_null' in local_var_params and local_var_params['sort_hide_null'] is not None:  # noqa: E501
            query_params.append(('sort_hide_null', local_var_params['sort_hide_null']))  # noqa: E501
        if 'per_page' in local_var_params and local_var_params['per_page'] is not None:  # noqa: E501
            query_params.append(('per_page', local_var_params['per_page']))  # noqa: E501
        if 'designation' in local_var_params and local_var_params['designation'] is not None:  # noqa: E501
            query_params.append(('designation', local_var_params['designation']))  # noqa: E501
            collection_formats['designation'] = 'multi'  # noqa: E501
        if 'committee_type' in local_var_params and local_var_params['committee_type'] is not None:  # noqa: E501
            query_params.append(('committee_type', local_var_params['committee_type']))  # noqa: E501
            collection_formats['committee_type'] = 'multi'  # noqa: E501
        if 'sort_nulls_last' in local_var_params and local_var_params['sort_nulls_last'] is not None:  # noqa: E501
            query_params.append(('sort_nulls_last', local_var_params['sort_nulls_last']))  # noqa: E501
        if 'cycle' in local_var_params and local_var_params['cycle'] is not None:  # noqa: E501
            query_params.append(('cycle', local_var_params['cycle']))  # noqa: E501
            collection_formats['cycle'] = 'multi'  # noqa: E501
        if 'page' in local_var_params and local_var_params['page'] is not None:  # noqa: E501
            query_params.append(('page', local_var_params['page']))  # noqa: E501
        if 'organization_type' in local_var_params and local_var_params['organization_type'] is not None:  # noqa: E501
            query_params.append(('organization_type', local_var_params['organization_type']))  # noqa: E501
            collection_formats['organization_type'] = 'multi'  # noqa: E501
        if 'sort_null_only' in local_var_params and local_var_params['sort_null_only'] is not None:  # noqa: E501
            query_params.append(('sort_null_only', local_var_params['sort_null_only']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyHeaderAuth', 'ApiKeyQueryAuth', 'apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/candidate/{candidate_id}/committees/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CommitteeDetailPage',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def candidate_candidate_id_committees_history_cycle_get(self, api_key, cycle, candidate_id, **kwargs):  # noqa: E501
        """candidate_candidate_id_committees_history_cycle_get  # noqa: E501

         Explore a filer's characteristics over time. This can be particularly useful if the committees change treasurers, designation, or `committee_type`.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.candidate_candidate_id_committees_history_cycle_get(api_key, cycle, candidate_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param int cycle:  A two year election cycle that the committee was active- (after original registration date but before expiration date in FEC Form 1s) The cycle begins with an odd year and is named for its ending, even year.  (required)
        :param str candidate_id:  A unique identifier assigned to each candidate registered with the FEC. If a person runs for several offices, that person will have separate candidate IDs for each office.  (required)
        :param bool election_full: `True` indicates that full election period of a candidate. `False` indicates that two year election cycle.
        :param str sort: Provide a field to sort by. Use `-` for descending order.
        :param bool sort_hide_null: Hide null values on sorted column(s).
        :param int per_page: The number of results returned per page. Defaults to 20.
        :param list[str] designation: The one-letter designation code of the organization:          - A authorized by a candidate          - J joint fundraising committee          - P principal campaign committee of a candidate          - U unauthorized          - B lobbyist/registrant PAC          - D leadership PAC
        :param bool sort_nulls_last: Toggle that sorts null values last
        :param int page: For paginating through results, starting at page 1
        :param bool sort_null_only: Toggle that filters out all rows having sort column that is non-null
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: CommitteeHistoryPage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.candidate_candidate_id_committees_history_cycle_get_with_http_info(api_key, cycle, candidate_id, **kwargs)  # noqa: E501

    def candidate_candidate_id_committees_history_cycle_get_with_http_info(self, api_key, cycle, candidate_id, **kwargs):  # noqa: E501
        """candidate_candidate_id_committees_history_cycle_get  # noqa: E501

         Explore a filer's characteristics over time. This can be particularly useful if the committees change treasurers, designation, or `committee_type`.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.candidate_candidate_id_committees_history_cycle_get_with_http_info(api_key, cycle, candidate_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param int cycle:  A two year election cycle that the committee was active- (after original registration date but before expiration date in FEC Form 1s) The cycle begins with an odd year and is named for its ending, even year.  (required)
        :param str candidate_id:  A unique identifier assigned to each candidate registered with the FEC. If a person runs for several offices, that person will have separate candidate IDs for each office.  (required)
        :param bool election_full: `True` indicates that full election period of a candidate. `False` indicates that two year election cycle.
        :param str sort: Provide a field to sort by. Use `-` for descending order.
        :param bool sort_hide_null: Hide null values on sorted column(s).
        :param int per_page: The number of results returned per page. Defaults to 20.
        :param list[str] designation: The one-letter designation code of the organization:          - A authorized by a candidate          - J joint fundraising committee          - P principal campaign committee of a candidate          - U unauthorized          - B lobbyist/registrant PAC          - D leadership PAC
        :param bool sort_nulls_last: Toggle that sorts null values last
        :param int page: For paginating through results, starting at page 1
        :param bool sort_null_only: Toggle that filters out all rows having sort column that is non-null
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(CommitteeHistoryPage, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'api_key',
            'cycle',
            'candidate_id',
            'election_full',
            'sort',
            'sort_hide_null',
            'per_page',
            'designation',
            'sort_nulls_last',
            'page',
            'sort_null_only'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    ' to method candidate_candidate_id_committees_history_cycle_get' % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'api_key' is set
        if self.api_client.client_side_validation and ('api_key' not in local_var_params or  # noqa: E501
                                                        local_var_params['api_key'] is None):  # noqa: E501
            raise ApiValueError('Missing the required parameter `api_key` when calling `candidate_candidate_id_committees_history_cycle_get`')  # noqa: E501
        # verify the required parameter 'cycle' is set
        if self.api_client.client_side_validation and ('cycle' not in local_var_params or  # noqa: E501
                                                        local_var_params['cycle'] is None):  # noqa: E501
            raise ApiValueError('Missing the required parameter `cycle` when calling `candidate_candidate_id_committees_history_cycle_get`')  # noqa: E501
        # verify the required parameter 'candidate_id' is set
        if self.api_client.client_side_validation and ('candidate_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['candidate_id'] is None):  # noqa: E501
            raise ApiValueError('Missing the required parameter `candidate_id` when calling `candidate_candidate_id_committees_history_cycle_get`')  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cycle' in local_var_params:
            path_params['cycle'] = local_var_params['cycle']  # noqa: E501
        if 'candidate_id' in local_var_params:
            path_params['candidate_id'] = local_var_params['candidate_id']  # noqa: E501

        query_params = []
        if 'election_full' in local_var_params and local_var_params['election_full'] is not None:  # noqa: E501
            query_params.append(('election_full', local_var_params['election_full']))  # noqa: E501
        if 'api_key' in local_var_params and local_var_params['api_key'] is not None:  # noqa: E501
            query_params.append(('api_key', local_var_params['api_key']))  # noqa: E501
        if 'sort' in local_var_params and local_var_params['sort'] is not None:  # noqa: E501
            query_params.append(('sort', local_var_params['sort']))  # noqa: E501
        if 'sort_hide_null' in local_var_params and local_var_params['sort_hide_null'] is not None:  # noqa: E501
            query_params.append(('sort_hide_null', local_var_params['sort_hide_null']))  # noqa: E501
        if 'per_page' in local_var_params and local_var_params['per_page'] is not None:  # noqa: E501
            query_params.append(('per_page', local_var_params['per_page']))  # noqa: E501
        if 'designation' in local_var_params and local_var_params['designation'] is not None:  # noqa: E501
            query_params.append(('designation', local_var_params['designation']))  # noqa: E501
            collection_formats['designation'] = 'multi'  # noqa: E501
        if 'sort_nulls_last' in local_var_params and local_var_params['sort_nulls_last'] is not None:  # noqa: E501
            query_params.append(('sort_nulls_last', local_var_params['sort_nulls_last']))  # noqa: E501
        if 'page' in local_var_params and local_var_params['page'] is not None:  # noqa: E501
            query_params.append(('page', local_var_params['page']))  # noqa: E501
        if 'sort_null_only' in local_var_params and local_var_params['sort_null_only'] is not None:  # noqa: E501
            query_params.append(('sort_null_only', local_var_params['sort_null_only']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyHeaderAuth', 'ApiKeyQueryAuth', 'apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/candidate/{candidate_id}/committees/history/{cycle}/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CommitteeHistoryPage',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def candidate_candidate_id_committees_history_get(self, api_key, candidate_id, **kwargs):  # noqa: E501
        """candidate_candidate_id_committees_history_get  # noqa: E501

         Explore a filer's characteristics over time. This can be particularly useful if the committees change treasurers, designation, or `committee_type`.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.candidate_candidate_id_committees_history_get(api_key, candidate_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param str candidate_id:  A unique identifier assigned to each candidate registered with the FEC. If a person runs for several offices, that person will have separate candidate IDs for each office.  (required)
        :param bool election_full: `True` indicates that full election period of a candidate. `False` indicates that two year election cycle.
        :param str sort: Provide a field to sort by. Use `-` for descending order.
        :param bool sort_hide_null: Hide null values on sorted column(s).
        :param int per_page: The number of results returned per page. Defaults to 20.
        :param list[str] designation: The one-letter designation code of the organization:          - A authorized by a candidate          - J joint fundraising committee          - P principal campaign committee of a candidate          - U unauthorized          - B lobbyist/registrant PAC          - D leadership PAC
        :param bool sort_nulls_last: Toggle that sorts null values last
        :param int page: For paginating through results, starting at page 1
        :param bool sort_null_only: Toggle that filters out all rows having sort column that is non-null
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: CommitteeHistoryPage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.candidate_candidate_id_committees_history_get_with_http_info(api_key, candidate_id, **kwargs)  # noqa: E501

    def candidate_candidate_id_committees_history_get_with_http_info(self, api_key, candidate_id, **kwargs):  # noqa: E501
        """candidate_candidate_id_committees_history_get  # noqa: E501

         Explore a filer's characteristics over time. This can be particularly useful if the committees change treasurers, designation, or `committee_type`.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.candidate_candidate_id_committees_history_get_with_http_info(api_key, candidate_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param str candidate_id:  A unique identifier assigned to each candidate registered with the FEC. If a person runs for several offices, that person will have separate candidate IDs for each office.  (required)
        :param bool election_full: `True` indicates that full election period of a candidate. `False` indicates that two year election cycle.
        :param str sort: Provide a field to sort by. Use `-` for descending order.
        :param bool sort_hide_null: Hide null values on sorted column(s).
        :param int per_page: The number of results returned per page. Defaults to 20.
        :param list[str] designation: The one-letter designation code of the organization:          - A authorized by a candidate          - J joint fundraising committee          - P principal campaign committee of a candidate          - U unauthorized          - B lobbyist/registrant PAC          - D leadership PAC
        :param bool sort_nulls_last: Toggle that sorts null values last
        :param int page: For paginating through results, starting at page 1
        :param bool sort_null_only: Toggle that filters out all rows having sort column that is non-null
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(CommitteeHistoryPage, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'api_key',
            'candidate_id',
            'election_full',
            'sort',
            'sort_hide_null',
            'per_page',
            'designation',
            'sort_nulls_last',
            'page',
            'sort_null_only'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    ' to method candidate_candidate_id_committees_history_get' % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'api_key' is set
        if self.api_client.client_side_validation and ('api_key' not in local_var_params or  # noqa: E501
                                                        local_var_params['api_key'] is None):  # noqa: E501
            raise ApiValueError('Missing the required parameter `api_key` when calling `candidate_candidate_id_committees_history_get`')  # noqa: E501
        # verify the required parameter 'candidate_id' is set
        if self.api_client.client_side_validation and ('candidate_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['candidate_id'] is None):  # noqa: E501
            raise ApiValueError('Missing the required parameter `candidate_id` when calling `candidate_candidate_id_committees_history_get`')  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'candidate_id' in local_var_params:
            path_params['candidate_id'] = local_var_params['candidate_id']  # noqa: E501

        query_params = []
        if 'election_full' in local_var_params and local_var_params['election_full'] is not None:  # noqa: E501
            query_params.append(('election_full', local_var_params['election_full']))  # noqa: E501
        if 'api_key' in local_var_params and local_var_params['api_key'] is not None:  # noqa: E501
            query_params.append(('api_key', local_var_params['api_key']))  # noqa: E501
        if 'sort' in local_var_params and local_var_params['sort'] is not None:  # noqa: E501
            query_params.append(('sort', local_var_params['sort']))  # noqa: E501
        if 'sort_hide_null' in local_var_params and local_var_params['sort_hide_null'] is not None:  # noqa: E501
            query_params.append(('sort_hide_null', local_var_params['sort_hide_null']))  # noqa: E501
        if 'per_page' in local_var_params and local_var_params['per_page'] is not None:  # noqa: E501
            query_params.append(('per_page', local_var_params['per_page']))  # noqa: E501
        if 'designation' in local_var_params and local_var_params['designation'] is not None:  # noqa: E501
            query_params.append(('designation', local_var_params['designation']))  # noqa: E501
            collection_formats['designation'] = 'multi'  # noqa: E501
        if 'sort_nulls_last' in local_var_params and local_var_params['sort_nulls_last'] is not None:  # noqa: E501
            query_params.append(('sort_nulls_last', local_var_params['sort_nulls_last']))  # noqa: E501
        if 'page' in local_var_params and local_var_params['page'] is not None:  # noqa: E501
            query_params.append(('page', local_var_params['page']))  # noqa: E501
        if 'sort_null_only' in local_var_params and local_var_params['sort_null_only'] is not None:  # noqa: E501
            query_params.append(('sort_null_only', local_var_params['sort_null_only']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyHeaderAuth', 'ApiKeyQueryAuth', 'apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/candidate/{candidate_id}/committees/history/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CommitteeHistoryPage',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def committee_committee_id_get(self, api_key, committee_id, **kwargs):  # noqa: E501
        """committee_committee_id_get  # noqa: E501

         This endpoint is useful for finding detailed information about a particular committee or filer. Use the `committee_id` to find the most recent information about the committee.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.committee_committee_id_get(api_key, committee_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param str committee_id:  A unique identifier assigned to each committee or filer registered with the FEC. In general committee id's begin with the letter C which is followed by eight digits.  (required)
        :param list[int] year: A year that the committee was active— (after original registration date     or filing but before expiration date)
        :param list[str] filing_frequency: The one-letter      code of the filing frequency:          - A Administratively terminated          - D Debt          - M Monthly filer          - Q Quarterly filer          - T Terminated          - W Waived
        :param str sort: Provide a field to sort by. Use `-` for descending order.
        :param bool sort_hide_null: Hide null values on sorted column(s).
        :param int per_page: The number of results returned per page. Defaults to 20.
        :param list[str] designation: The one-letter designation code of the organization:          - A authorized by a candidate          - J joint fundraising committee          - P principal campaign committee of a candidate          - U unauthorized          - B lobbyist/registrant PAC          - D leadership PAC
        :param list[str] committee_type: The one-letter type code of the organization:         - C communication cost         - D delegate         - E electioneering communication         - H House         - I independent expenditor (person or group)         - N PAC - nonqualified         - O independent expenditure-only (super PACs)         - P presidential         - Q PAC - qualified         - S Senate         - U single candidate independent expenditure         - V PAC with non-contribution account, nonqualified         - W PAC with non-contribution account, qualified         - X party, nonqualified         - Y party, qualified         - Z national party non-federal account
        :param bool sort_nulls_last: Toggle that sorts null values last
        :param list[int] cycle:  A two year election cycle that the committee was active- (after original registration date but before expiration date in FEC Form 1s) The cycle begins with an odd year and is named for its ending, even year.
        :param int page: For paginating through results, starting at page 1
        :param list[str] organization_type: The one-letter code for the kind for organization:         - C corporation         - L labor organization         - M membership organization         - T trade association         - V cooperative         - W corporation without capital stock
        :param bool sort_null_only: Toggle that filters out all rows having sort column that is non-null
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: CommitteeDetailPage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.committee_committee_id_get_with_http_info(api_key, committee_id, **kwargs)  # noqa: E501

    def committee_committee_id_get_with_http_info(self, api_key, committee_id, **kwargs):  # noqa: E501
        """committee_committee_id_get  # noqa: E501

         This endpoint is useful for finding detailed information about a particular committee or filer. Use the `committee_id` to find the most recent information about the committee.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.committee_committee_id_get_with_http_info(api_key, committee_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param str committee_id:  A unique identifier assigned to each committee or filer registered with the FEC. In general committee id's begin with the letter C which is followed by eight digits.  (required)
        :param list[int] year: A year that the committee was active— (after original registration date     or filing but before expiration date)
        :param list[str] filing_frequency: The one-letter      code of the filing frequency:          - A Administratively terminated          - D Debt          - M Monthly filer          - Q Quarterly filer          - T Terminated          - W Waived
        :param str sort: Provide a field to sort by. Use `-` for descending order.
        :param bool sort_hide_null: Hide null values on sorted column(s).
        :param int per_page: The number of results returned per page. Defaults to 20.
        :param list[str] designation: The one-letter designation code of the organization:          - A authorized by a candidate          - J joint fundraising committee          - P principal campaign committee of a candidate          - U unauthorized          - B lobbyist/registrant PAC          - D leadership PAC
        :param list[str] committee_type: The one-letter type code of the organization:         - C communication cost         - D delegate         - E electioneering communication         - H House         - I independent expenditor (person or group)         - N PAC - nonqualified         - O independent expenditure-only (super PACs)         - P presidential         - Q PAC - qualified         - S Senate         - U single candidate independent expenditure         - V PAC with non-contribution account, nonqualified         - W PAC with non-contribution account, qualified         - X party, nonqualified         - Y party, qualified         - Z national party non-federal account
        :param bool sort_nulls_last: Toggle that sorts null values last
        :param list[int] cycle:  A two year election cycle that the committee was active- (after original registration date but before expiration date in FEC Form 1s) The cycle begins with an odd year and is named for its ending, even year.
        :param int page: For paginating through results, starting at page 1
        :param list[str] organization_type: The one-letter code for the kind for organization:         - C corporation         - L labor organization         - M membership organization         - T trade association         - V cooperative         - W corporation without capital stock
        :param bool sort_null_only: Toggle that filters out all rows having sort column that is non-null
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(CommitteeDetailPage, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'api_key',
            'committee_id',
            'year',
            'filing_frequency',
            'sort',
            'sort_hide_null',
            'per_page',
            'designation',
            'committee_type',
            'sort_nulls_last',
            'cycle',
            'page',
            'organization_type',
            'sort_null_only'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    ' to method committee_committee_id_get' % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'api_key' is set
        if self.api_client.client_side_validation and ('api_key' not in local_var_params or  # noqa: E501
                                                        local_var_params['api_key'] is None):  # noqa: E501
            raise ApiValueError('Missing the required parameter `api_key` when calling `committee_committee_id_get`')  # noqa: E501
        # verify the required parameter 'committee_id' is set
        if self.api_client.client_side_validation and ('committee_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['committee_id'] is None):  # noqa: E501
            raise ApiValueError('Missing the required parameter `committee_id` when calling `committee_committee_id_get`')  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'committee_id' in local_var_params:
            path_params['committee_id'] = local_var_params['committee_id']  # noqa: E501

        query_params = []
        if 'year' in local_var_params and local_var_params['year'] is not None:  # noqa: E501
            query_params.append(('year', local_var_params['year']))  # noqa: E501
            collection_formats['year'] = 'multi'  # noqa: E501
        if 'api_key' in local_var_params and local_var_params['api_key'] is not None:  # noqa: E501
            query_params.append(('api_key', local_var_params['api_key']))  # noqa: E501
        if 'filing_frequency' in local_var_params and local_var_params['filing_frequency'] is not None:  # noqa: E501
            query_params.append(('filing_frequency', local_var_params['filing_frequency']))  # noqa: E501
            collection_formats['filing_frequency'] = 'multi'  # noqa: E501
        if 'sort' in local_var_params and local_var_params['sort'] is not None:  # noqa: E501
            query_params.append(('sort', local_var_params['sort']))  # noqa: E501
        if 'sort_hide_null' in local_var_params and local_var_params['sort_hide_null'] is not None:  # noqa: E501
            query_params.append(('sort_hide_null', local_var_params['sort_hide_null']))  # noqa: E501
        if 'per_page' in local_var_params and local_var_params['per_page'] is not None:  # noqa: E501
            query_params.append(('per_page', local_var_params['per_page']))  # noqa: E501
        if 'designation' in local_var_params and local_var_params['designation'] is not None:  # noqa: E501
            query_params.append(('designation', local_var_params['designation']))  # noqa: E501
            collection_formats['designation'] = 'multi'  # noqa: E501
        if 'committee_type' in local_var_params and local_var_params['committee_type'] is not None:  # noqa: E501
            query_params.append(('committee_type', local_var_params['committee_type']))  # noqa: E501
            collection_formats['committee_type'] = 'multi'  # noqa: E501
        if 'sort_nulls_last' in local_var_params and local_var_params['sort_nulls_last'] is not None:  # noqa: E501
            query_params.append(('sort_nulls_last', local_var_params['sort_nulls_last']))  # noqa: E501
        if 'cycle' in local_var_params and local_var_params['cycle'] is not None:  # noqa: E501
            query_params.append(('cycle', local_var_params['cycle']))  # noqa: E501
            collection_formats['cycle'] = 'multi'  # noqa: E501
        if 'page' in local_var_params and local_var_params['page'] is not None:  # noqa: E501
            query_params.append(('page', local_var_params['page']))  # noqa: E501
        if 'organization_type' in local_var_params and local_var_params['organization_type'] is not None:  # noqa: E501
            query_params.append(('organization_type', local_var_params['organization_type']))  # noqa: E501
            collection_formats['organization_type'] = 'multi'  # noqa: E501
        if 'sort_null_only' in local_var_params and local_var_params['sort_null_only'] is not None:  # noqa: E501
            query_params.append(('sort_null_only', local_var_params['sort_null_only']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyHeaderAuth', 'ApiKeyQueryAuth', 'apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/committee/{committee_id}/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CommitteeDetailPage',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def committee_committee_id_history_cycle_get(self, api_key, committee_id, cycle, **kwargs):  # noqa: E501
        """committee_committee_id_history_cycle_get  # noqa: E501

         Explore a filer's characteristics over time. This can be particularly useful if the committees change treasurers, designation, or `committee_type`.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.committee_committee_id_history_cycle_get(api_key, committee_id, cycle, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param str committee_id:  A unique identifier assigned to each committee or filer registered with the FEC. In general committee id's begin with the letter C which is followed by eight digits.  (required)
        :param int cycle:  A two year election cycle that the committee was active- (after original registration date but before expiration date in FEC Form 1s) The cycle begins with an odd year and is named for its ending, even year.  (required)
        :param bool election_full: `True` indicates that full election period of a candidate. `False` indicates that two year election cycle.
        :param str sort: Provide a field to sort by. Use `-` for descending order.
        :param bool sort_hide_null: Hide null values on sorted column(s).
        :param int per_page: The number of results returned per page. Defaults to 20.
        :param list[str] designation: The one-letter designation code of the organization:          - A authorized by a candidate          - J joint fundraising committee          - P principal campaign committee of a candidate          - U unauthorized          - B lobbyist/registrant PAC          - D leadership PAC
        :param bool sort_nulls_last: Toggle that sorts null values last
        :param int page: For paginating through results, starting at page 1
        :param bool sort_null_only: Toggle that filters out all rows having sort column that is non-null
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: CommitteeHistoryPage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.committee_committee_id_history_cycle_get_with_http_info(api_key, committee_id, cycle, **kwargs)  # noqa: E501

    def committee_committee_id_history_cycle_get_with_http_info(self, api_key, committee_id, cycle, **kwargs):  # noqa: E501
        """committee_committee_id_history_cycle_get  # noqa: E501

         Explore a filer's characteristics over time. This can be particularly useful if the committees change treasurers, designation, or `committee_type`.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.committee_committee_id_history_cycle_get_with_http_info(api_key, committee_id, cycle, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param str committee_id:  A unique identifier assigned to each committee or filer registered with the FEC. In general committee id's begin with the letter C which is followed by eight digits.  (required)
        :param int cycle:  A two year election cycle that the committee was active- (after original registration date but before expiration date in FEC Form 1s) The cycle begins with an odd year and is named for its ending, even year.  (required)
        :param bool election_full: `True` indicates that full election period of a candidate. `False` indicates that two year election cycle.
        :param str sort: Provide a field to sort by. Use `-` for descending order.
        :param bool sort_hide_null: Hide null values on sorted column(s).
        :param int per_page: The number of results returned per page. Defaults to 20.
        :param list[str] designation: The one-letter designation code of the organization:          - A authorized by a candidate          - J joint fundraising committee          - P principal campaign committee of a candidate          - U unauthorized          - B lobbyist/registrant PAC          - D leadership PAC
        :param bool sort_nulls_last: Toggle that sorts null values last
        :param int page: For paginating through results, starting at page 1
        :param bool sort_null_only: Toggle that filters out all rows having sort column that is non-null
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(CommitteeHistoryPage, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'api_key',
            'committee_id',
            'cycle',
            'election_full',
            'sort',
            'sort_hide_null',
            'per_page',
            'designation',
            'sort_nulls_last',
            'page',
            'sort_null_only'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    ' to method committee_committee_id_history_cycle_get' % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'api_key' is set
        if self.api_client.client_side_validation and ('api_key' not in local_var_params or  # noqa: E501
                                                        local_var_params['api_key'] is None):  # noqa: E501
            raise ApiValueError('Missing the required parameter `api_key` when calling `committee_committee_id_history_cycle_get`')  # noqa: E501
        # verify the required parameter 'committee_id' is set
        if self.api_client.client_side_validation and ('committee_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['committee_id'] is None):  # noqa: E501
            raise ApiValueError('Missing the required parameter `committee_id` when calling `committee_committee_id_history_cycle_get`')  # noqa: E501
        # verify the required parameter 'cycle' is set
        if self.api_client.client_side_validation and ('cycle' not in local_var_params or  # noqa: E501
                                                        local_var_params['cycle'] is None):  # noqa: E501
            raise ApiValueError('Missing the required parameter `cycle` when calling `committee_committee_id_history_cycle_get`')  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'committee_id' in local_var_params:
            path_params['committee_id'] = local_var_params['committee_id']  # noqa: E501
        if 'cycle' in local_var_params:
            path_params['cycle'] = local_var_params['cycle']  # noqa: E501

        query_params = []
        if 'election_full' in local_var_params and local_var_params['election_full'] is not None:  # noqa: E501
            query_params.append(('election_full', local_var_params['election_full']))  # noqa: E501
        if 'api_key' in local_var_params and local_var_params['api_key'] is not None:  # noqa: E501
            query_params.append(('api_key', local_var_params['api_key']))  # noqa: E501
        if 'sort' in local_var_params and local_var_params['sort'] is not None:  # noqa: E501
            query_params.append(('sort', local_var_params['sort']))  # noqa: E501
        if 'sort_hide_null' in local_var_params and local_var_params['sort_hide_null'] is not None:  # noqa: E501
            query_params.append(('sort_hide_null', local_var_params['sort_hide_null']))  # noqa: E501
        if 'per_page' in local_var_params and local_var_params['per_page'] is not None:  # noqa: E501
            query_params.append(('per_page', local_var_params['per_page']))  # noqa: E501
        if 'designation' in local_var_params and local_var_params['designation'] is not None:  # noqa: E501
            query_params.append(('designation', local_var_params['designation']))  # noqa: E501
            collection_formats['designation'] = 'multi'  # noqa: E501
        if 'sort_nulls_last' in local_var_params and local_var_params['sort_nulls_last'] is not None:  # noqa: E501
            query_params.append(('sort_nulls_last', local_var_params['sort_nulls_last']))  # noqa: E501
        if 'page' in local_var_params and local_var_params['page'] is not None:  # noqa: E501
            query_params.append(('page', local_var_params['page']))  # noqa: E501
        if 'sort_null_only' in local_var_params and local_var_params['sort_null_only'] is not None:  # noqa: E501
            query_params.append(('sort_null_only', local_var_params['sort_null_only']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyHeaderAuth', 'ApiKeyQueryAuth', 'apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/committee/{committee_id}/history/{cycle}/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CommitteeHistoryPage',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def committee_committee_id_history_get(self, api_key, committee_id, **kwargs):  # noqa: E501
        """committee_committee_id_history_get  # noqa: E501

         Explore a filer's characteristics over time. This can be particularly useful if the committees change treasurers, designation, or `committee_type`.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.committee_committee_id_history_get(api_key, committee_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param str committee_id:  A unique identifier assigned to each committee or filer registered with the FEC. In general committee id's begin with the letter C which is followed by eight digits.  (required)
        :param bool election_full: `True` indicates that full election period of a candidate. `False` indicates that two year election cycle.
        :param str sort: Provide a field to sort by. Use `-` for descending order.
        :param bool sort_hide_null: Hide null values on sorted column(s).
        :param int per_page: The number of results returned per page. Defaults to 20.
        :param list[str] designation: The one-letter designation code of the organization:          - A authorized by a candidate          - J joint fundraising committee          - P principal campaign committee of a candidate          - U unauthorized          - B lobbyist/registrant PAC          - D leadership PAC
        :param bool sort_nulls_last: Toggle that sorts null values last
        :param int page: For paginating through results, starting at page 1
        :param bool sort_null_only: Toggle that filters out all rows having sort column that is non-null
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: CommitteeHistoryPage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.committee_committee_id_history_get_with_http_info(api_key, committee_id, **kwargs)  # noqa: E501

    def committee_committee_id_history_get_with_http_info(self, api_key, committee_id, **kwargs):  # noqa: E501
        """committee_committee_id_history_get  # noqa: E501

         Explore a filer's characteristics over time. This can be particularly useful if the committees change treasurers, designation, or `committee_type`.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.committee_committee_id_history_get_with_http_info(api_key, committee_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param str committee_id:  A unique identifier assigned to each committee or filer registered with the FEC. In general committee id's begin with the letter C which is followed by eight digits.  (required)
        :param bool election_full: `True` indicates that full election period of a candidate. `False` indicates that two year election cycle.
        :param str sort: Provide a field to sort by. Use `-` for descending order.
        :param bool sort_hide_null: Hide null values on sorted column(s).
        :param int per_page: The number of results returned per page. Defaults to 20.
        :param list[str] designation: The one-letter designation code of the organization:          - A authorized by a candidate          - J joint fundraising committee          - P principal campaign committee of a candidate          - U unauthorized          - B lobbyist/registrant PAC          - D leadership PAC
        :param bool sort_nulls_last: Toggle that sorts null values last
        :param int page: For paginating through results, starting at page 1
        :param bool sort_null_only: Toggle that filters out all rows having sort column that is non-null
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(CommitteeHistoryPage, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'api_key',
            'committee_id',
            'election_full',
            'sort',
            'sort_hide_null',
            'per_page',
            'designation',
            'sort_nulls_last',
            'page',
            'sort_null_only'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    ' to method committee_committee_id_history_get' % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'api_key' is set
        if self.api_client.client_side_validation and ('api_key' not in local_var_params or  # noqa: E501
                                                        local_var_params['api_key'] is None):  # noqa: E501
            raise ApiValueError('Missing the required parameter `api_key` when calling `committee_committee_id_history_get`')  # noqa: E501
        # verify the required parameter 'committee_id' is set
        if self.api_client.client_side_validation and ('committee_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['committee_id'] is None):  # noqa: E501
            raise ApiValueError('Missing the required parameter `committee_id` when calling `committee_committee_id_history_get`')  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'committee_id' in local_var_params:
            path_params['committee_id'] = local_var_params['committee_id']  # noqa: E501

        query_params = []
        if 'election_full' in local_var_params and local_var_params['election_full'] is not None:  # noqa: E501
            query_params.append(('election_full', local_var_params['election_full']))  # noqa: E501
        if 'api_key' in local_var_params and local_var_params['api_key'] is not None:  # noqa: E501
            query_params.append(('api_key', local_var_params['api_key']))  # noqa: E501
        if 'sort' in local_var_params and local_var_params['sort'] is not None:  # noqa: E501
            query_params.append(('sort', local_var_params['sort']))  # noqa: E501
        if 'sort_hide_null' in local_var_params and local_var_params['sort_hide_null'] is not None:  # noqa: E501
            query_params.append(('sort_hide_null', local_var_params['sort_hide_null']))  # noqa: E501
        if 'per_page' in local_var_params and local_var_params['per_page'] is not None:  # noqa: E501
            query_params.append(('per_page', local_var_params['per_page']))  # noqa: E501
        if 'designation' in local_var_params and local_var_params['designation'] is not None:  # noqa: E501
            query_params.append(('designation', local_var_params['designation']))  # noqa: E501
            collection_formats['designation'] = 'multi'  # noqa: E501
        if 'sort_nulls_last' in local_var_params and local_var_params['sort_nulls_last'] is not None:  # noqa: E501
            query_params.append(('sort_nulls_last', local_var_params['sort_nulls_last']))  # noqa: E501
        if 'page' in local_var_params and local_var_params['page'] is not None:  # noqa: E501
            query_params.append(('page', local_var_params['page']))  # noqa: E501
        if 'sort_null_only' in local_var_params and local_var_params['sort_null_only'] is not None:  # noqa: E501
            query_params.append(('sort_null_only', local_var_params['sort_null_only']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyHeaderAuth', 'ApiKeyQueryAuth', 'apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/committee/{committee_id}/history/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CommitteeHistoryPage',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def committees_get(self, api_key, **kwargs):  # noqa: E501
        """committees_get  # noqa: E501

         Fetch basic information about committees and filers. Use parameters to filter for particular characteristics.    # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.committees_get(api_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param list[int] year: A year that the committee was active— (after original registration date     or filing but before expiration date)
        :param date max_first_file_date: Filter for committees whose first filing was received on or before this date.
        :param str sort: Provide a field to sort by. Use `-` for descending order.
        :param list[str] candidate_id:  A unique identifier assigned to each candidate registered with the FEC. If a person runs for several offices, that person will have separate candidate IDs for each office.
        :param list[str] q: The name of the committee. If a committee changes its name,     the most recent name will be shown. Committee names are not unique. Use committee_id     for looking up records.
        :param list[str] designation: The one-letter designation code of the organization:          - A authorized by a candidate          - J joint fundraising committee          - P principal campaign committee of a candidate          - U unauthorized          - B lobbyist/registrant PAC          - D leadership PAC
        :param list[str] committee_type: The one-letter type code of the organization:         - C communication cost         - D delegate         - E electioneering communication         - H House         - I independent expenditor (person or group)         - N PAC - nonqualified         - O independent expenditure-only (super PACs)         - P presidential         - Q PAC - qualified         - S Senate         - U single candidate independent expenditure         - V PAC with non-contribution account, nonqualified         - W PAC with non-contribution account, qualified         - X party, nonqualified         - Y party, qualified         - Z national party non-federal account
        :param bool sort_nulls_last: Toggle that sorts null values last
        :param list[str] organization_type: The one-letter code for the kind for organization:         - C corporation         - L labor organization         - M membership organization         - T trade association         - V cooperative         - W corporation without capital stock
        :param bool sort_null_only: Toggle that filters out all rows having sort column that is non-null
        :param list[str] filing_frequency: The one-letter      code of the filing frequency:          - A Administratively terminated          - D Debt          - M Monthly filer          - Q Quarterly filer          - T Terminated          - W Waived
        :param list[str] state: US state or territory
        :param date max_last_f1_date: Filter for committees whose latest Form 1 was received on or before this date.
        :param bool sort_hide_null: Hide null values on sorted column(s).
        :param int per_page: The number of results returned per page. Defaults to 20.
        :param list[str] party: Three-letter code for the party affiliated with a candidate or committee. For example, DEM for Democratic Party and REP for Republican Party.
        :param date min_last_f1_date: Filter for committees whose latest Form 1 was received on or after this date.
        :param list[str] committee_id:  A unique identifier assigned to each committee or filer registered with the FEC. In general committee id's begin with the letter C which is followed by eight digits.
        :param int page: For paginating through results, starting at page 1
        :param list[int] cycle:  A two year election cycle that the committee was active- (after original registration date but before expiration date in FEC Form 1s) The cycle begins with an odd year and is named for its ending, even year.
        :param date min_first_file_date: Filter for committees whose first filing was received on or after this date.
        :param list[str] treasurer_name: Name of the Committee's treasurer. If multiple treasurers for the committee, the most recent treasurer will be shown.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: CommitteePage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.committees_get_with_http_info(api_key, **kwargs)  # noqa: E501

    def committees_get_with_http_info(self, api_key, **kwargs):  # noqa: E501
        """committees_get  # noqa: E501

         Fetch basic information about committees and filers. Use parameters to filter for particular characteristics.    # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.committees_get_with_http_info(api_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param list[int] year: A year that the committee was active— (after original registration date     or filing but before expiration date)
        :param date max_first_file_date: Filter for committees whose first filing was received on or before this date.
        :param str sort: Provide a field to sort by. Use `-` for descending order.
        :param list[str] candidate_id:  A unique identifier assigned to each candidate registered with the FEC. If a person runs for several offices, that person will have separate candidate IDs for each office.
        :param list[str] q: The name of the committee. If a committee changes its name,     the most recent name will be shown. Committee names are not unique. Use committee_id     for looking up records.
        :param list[str] designation: The one-letter designation code of the organization:          - A authorized by a candidate          - J joint fundraising committee          - P principal campaign committee of a candidate          - U unauthorized          - B lobbyist/registrant PAC          - D leadership PAC
        :param list[str] committee_type: The one-letter type code of the organization:         - C communication cost         - D delegate         - E electioneering communication         - H House         - I independent expenditor (person or group)         - N PAC - nonqualified         - O independent expenditure-only (super PACs)         - P presidential         - Q PAC - qualified         - S Senate         - U single candidate independent expenditure         - V PAC with non-contribution account, nonqualified         - W PAC with non-contribution account, qualified         - X party, nonqualified         - Y party, qualified         - Z national party non-federal account
        :param bool sort_nulls_last: Toggle that sorts null values last
        :param list[str] organization_type: The one-letter code for the kind for organization:         - C corporation         - L labor organization         - M membership organization         - T trade association         - V cooperative         - W corporation without capital stock
        :param bool sort_null_only: Toggle that filters out all rows having sort column that is non-null
        :param list[str] filing_frequency: The one-letter      code of the filing frequency:          - A Administratively terminated          - D Debt          - M Monthly filer          - Q Quarterly filer          - T Terminated          - W Waived
        :param list[str] state: US state or territory
        :param date max_last_f1_date: Filter for committees whose latest Form 1 was received on or before this date.
        :param bool sort_hide_null: Hide null values on sorted column(s).
        :param int per_page: The number of results returned per page. Defaults to 20.
        :param list[str] party: Three-letter code for the party affiliated with a candidate or committee. For example, DEM for Democratic Party and REP for Republican Party.
        :param date min_last_f1_date: Filter for committees whose latest Form 1 was received on or after this date.
        :param list[str] committee_id:  A unique identifier assigned to each committee or filer registered with the FEC. In general committee id's begin with the letter C which is followed by eight digits.
        :param int page: For paginating through results, starting at page 1
        :param list[int] cycle:  A two year election cycle that the committee was active- (after original registration date but before expiration date in FEC Form 1s) The cycle begins with an odd year and is named for its ending, even year.
        :param date min_first_file_date: Filter for committees whose first filing was received on or after this date.
        :param list[str] treasurer_name: Name of the Committee's treasurer. If multiple treasurers for the committee, the most recent treasurer will be shown.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(CommitteePage, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'api_key',
            'year',
            'max_first_file_date',
            'sort',
            'candidate_id',
            'q',
            'designation',
            'committee_type',
            'sort_nulls_last',
            'organization_type',
            'sort_null_only',
            'filing_frequency',
            'state',
            'max_last_f1_date',
            'sort_hide_null',
            'per_page',
            'party',
            'min_last_f1_date',
            'committee_id',
            'page',
            'cycle',
            'min_first_file_date',
            'treasurer_name'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    ' to method committees_get' % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'api_key' is set
        if self.api_client.client_side_validation and ('api_key' not in local_var_params or  # noqa: E501
                                                        local_var_params['api_key'] is None):  # noqa: E501
            raise ApiValueError('Missing the required parameter `api_key` when calling `committees_get`')  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'year' in local_var_params and local_var_params['year'] is not None:  # noqa: E501
            query_params.append(('year', local_var_params['year']))  # noqa: E501
            collection_formats['year'] = 'multi'  # noqa: E501
        if 'max_first_file_date' in local_var_params and local_var_params['max_first_file_date'] is not None:  # noqa: E501
            query_params.append(('max_first_file_date', local_var_params['max_first_file_date']))  # noqa: E501
        if 'api_key' in local_var_params and local_var_params['api_key'] is not None:  # noqa: E501
            query_params.append(('api_key', local_var_params['api_key']))  # noqa: E501
        if 'sort' in local_var_params and local_var_params['sort'] is not None:  # noqa: E501
            query_params.append(('sort', local_var_params['sort']))  # noqa: E501
        if 'candidate_id' in local_var_params and local_var_params['candidate_id'] is not None:  # noqa: E501
            query_params.append(('candidate_id', local_var_params['candidate_id']))  # noqa: E501
            collection_formats['candidate_id'] = 'multi'  # noqa: E501
        if 'q' in local_var_params and local_var_params['q'] is not None:  # noqa: E501
            query_params.append(('q', local_var_params['q']))  # noqa: E501
            collection_formats['q'] = 'multi'  # noqa: E501
        if 'designation' in local_var_params and local_var_params['designation'] is not None:  # noqa: E501
            query_params.append(('designation', local_var_params['designation']))  # noqa: E501
            collection_formats['designation'] = 'multi'  # noqa: E501
        if 'committee_type' in local_var_params and local_var_params['committee_type'] is not None:  # noqa: E501
            query_params.append(('committee_type', local_var_params['committee_type']))  # noqa: E501
            collection_formats['committee_type'] = 'multi'  # noqa: E501
        if 'sort_nulls_last' in local_var_params and local_var_params['sort_nulls_last'] is not None:  # noqa: E501
            query_params.append(('sort_nulls_last', local_var_params['sort_nulls_last']))  # noqa: E501
        if 'organization_type' in local_var_params and local_var_params['organization_type'] is not None:  # noqa: E501
            query_params.append(('organization_type', local_var_params['organization_type']))  # noqa: E501
            collection_formats['organization_type'] = 'multi'  # noqa: E501
        if 'sort_null_only' in local_var_params and local_var_params['sort_null_only'] is not None:  # noqa: E501
            query_params.append(('sort_null_only', local_var_params['sort_null_only']))  # noqa: E501
        if 'filing_frequency' in local_var_params and local_var_params['filing_frequency'] is not None:  # noqa: E501
            query_params.append(('filing_frequency', local_var_params['filing_frequency']))  # noqa: E501
            collection_formats['filing_frequency'] = 'multi'  # noqa: E501
        if 'state' in local_var_params and local_var_params['state'] is not None:  # noqa: E501
            query_params.append(('state', local_var_params['state']))  # noqa: E501
            collection_formats['state'] = 'multi'  # noqa: E501
        if 'max_last_f1_date' in local_var_params and local_var_params['max_last_f1_date'] is not None:  # noqa: E501
            query_params.append(('max_last_f1_date', local_var_params['max_last_f1_date']))  # noqa: E501
        if 'sort_hide_null' in local_var_params and local_var_params['sort_hide_null'] is not None:  # noqa: E501
            query_params.append(('sort_hide_null', local_var_params['sort_hide_null']))  # noqa: E501
        if 'per_page' in local_var_params and local_var_params['per_page'] is not None:  # noqa: E501
            query_params.append(('per_page', local_var_params['per_page']))  # noqa: E501
        if 'party' in local_var_params and local_var_params['party'] is not None:  # noqa: E501
            query_params.append(('party', local_var_params['party']))  # noqa: E501
            collection_formats['party'] = 'multi'  # noqa: E501
        if 'min_last_f1_date' in local_var_params and local_var_params['min_last_f1_date'] is not None:  # noqa: E501
            query_params.append(('min_last_f1_date', local_var_params['min_last_f1_date']))  # noqa: E501
        if 'committee_id' in local_var_params and local_var_params['committee_id'] is not None:  # noqa: E501
            query_params.append(('committee_id', local_var_params['committee_id']))  # noqa: E501
            collection_formats['committee_id'] = 'multi'  # noqa: E501
        if 'page' in local_var_params and local_var_params['page'] is not None:  # noqa: E501
            query_params.append(('page', local_var_params['page']))  # noqa: E501
        if 'cycle' in local_var_params and local_var_params['cycle'] is not None:  # noqa: E501
            query_params.append(('cycle', local_var_params['cycle']))  # noqa: E501
            collection_formats['cycle'] = 'multi'  # noqa: E501
        if 'min_first_file_date' in local_var_params and local_var_params['min_first_file_date'] is not None:  # noqa: E501
            query_params.append(('min_first_file_date', local_var_params['min_first_file_date']))  # noqa: E501
        if 'treasurer_name' in local_var_params and local_var_params['treasurer_name'] is not None:  # noqa: E501
            query_params.append(('treasurer_name', local_var_params['treasurer_name']))  # noqa: E501
            collection_formats['treasurer_name'] = 'multi'  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyHeaderAuth', 'ApiKeyQueryAuth', 'apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/committees/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CommitteePage',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
