# coding: utf-8

"""
    OpenFEC

    This API allows you to explore the way candidates and committees fund their campaigns.    The FEC API is a RESTful web service supporting full-text and field-specific searches on FEC data. [Bulk downloads](https://www.fec.gov/data/advanced/?tab=bulk-data) are available on the current site. Information is tied to the underlying forms by file ID and image ID. Data is updated nightly.    There is a lot of data, but a good place to start is to use search to find interesting candidates and committees. Then, you can use their IDs to find report or line item details with the other endpoints. If you are interested in individual donors, check out contributor information in schedule_a.    Get an [API key here](https://api.data.gov/signup/). That will enable you to place up to 1,000 calls an hour. Each call is limited to 100 results per page. You can email questions, comments or a request to get a key for 120 calls per minute to [APIinfo@fec.gov](mailto:apiinfo@fec.gov). You can also ask questions and discuss the data in the [FEC data Google Group](https://groups.google.com/forum/#!forum/fec-data). API changes will also be added to this group in advance of the change.    The model definitions and schema are available at [/swagger](/swagger/). This is useful for making wrappers and exploring the data.    A few restrictions limit the way you can use FEC data. For example, you can’t use contributor lists for commercial purposes or to solicit donations. [Learn more here](https://www.fec.gov/updates/sale-or-use-contributor-information/).    [View our source code](https://github.com/fecgov/openFEC). We welcome issues and pull requests!  # noqa: E501

    The version of the OpenAPI document: 1.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from openfec_sdk.api_client import ApiClient
from openfec_sdk.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class DatesApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def calendar_dates_export_get(self, api_key, **kwargs):  # noqa: E501
        """calendar_dates_export_get  # noqa: E501

         Returns CSV or ICS for downloading directly into calendar applications like Google, Outlook or other applications.  Combines the election and reporting dates with Commission meetings, conferences, outreach, Advisory Opinions, rules, litigation dates and other events into one calendar.  State filtering now applies to elections, reports and reporting periods.  Presidential pre-primary report due dates are not shown on even years. Filers generally opt to file monthly rather than submit over 50 pre-primary election reports. All reporting deadlines are available at /reporting-dates/ for reference.  This is [the sql function](https://github.com/fecgov/openFEC/blob/develop/data/migrations/V40__omnibus_dates.sql) that creates the calendar.    # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.calendar_dates_export_get(api_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param list[str] summary: Longer description of event
        :param str sort: Provide a field to sort by. Use `-` for descending order.
        :param list[str] description: Brief description of event
        :param int event_id: An unique ID for an event. Useful for downloading a single event to your calendar. This ID is not a permanent, persistent ID.
        :param int per_page: The number of results returned per page. Defaults to 20.
        :param bool sort_hide_null: Hide null values on sorted column(s).
        :param bool sort_nulls_last: Toggle that sorts null values last
        :param date max_start_date:  The maximum start date.(MM/DD/YYYY or YYYY-MM-DD)
        :param list[int] calendar_category_id:  Each type of event has a calendar category with an integer id. Options are: Open Meetings: 32, Executive Sessions: 39, Public Hearings: 40, Conferences: 33, Roundtables: 34, Election Dates: 36, Federal Holidays: 37, FEA Periods: 38, Commission Meetings: 20, Reporting Deadlines: 21, Conferences and Outreach: 22, AOs and Rules: 23, Other: 24, Quarterly: 25, Monthly: 26, Pre and Post-Elections: 27, EC Periods:28, and IE Periods: 29
        :param int page: For paginating through results, starting at page 1
        :param bool sort_null_only: Toggle that filters out all rows having sort column that is non-null
        :param date min_end_date:  The minimum end date.(MM/DD/YYYY or YYYY-MM-DD)
        :param date min_start_date:  The minimum start date.(MM/DD/YYYY or YYYY-MM-DD)
        :param date max_end_date:  The maximum end date.(MM/DD/YYYY or YYYY-MM-DD)
        :param str renderer:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: CalendarDatePage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.calendar_dates_export_get_with_http_info(api_key, **kwargs)  # noqa: E501

    def calendar_dates_export_get_with_http_info(self, api_key, **kwargs):  # noqa: E501
        """calendar_dates_export_get  # noqa: E501

         Returns CSV or ICS for downloading directly into calendar applications like Google, Outlook or other applications.  Combines the election and reporting dates with Commission meetings, conferences, outreach, Advisory Opinions, rules, litigation dates and other events into one calendar.  State filtering now applies to elections, reports and reporting periods.  Presidential pre-primary report due dates are not shown on even years. Filers generally opt to file monthly rather than submit over 50 pre-primary election reports. All reporting deadlines are available at /reporting-dates/ for reference.  This is [the sql function](https://github.com/fecgov/openFEC/blob/develop/data/migrations/V40__omnibus_dates.sql) that creates the calendar.    # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.calendar_dates_export_get_with_http_info(api_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param list[str] summary: Longer description of event
        :param str sort: Provide a field to sort by. Use `-` for descending order.
        :param list[str] description: Brief description of event
        :param int event_id: An unique ID for an event. Useful for downloading a single event to your calendar. This ID is not a permanent, persistent ID.
        :param int per_page: The number of results returned per page. Defaults to 20.
        :param bool sort_hide_null: Hide null values on sorted column(s).
        :param bool sort_nulls_last: Toggle that sorts null values last
        :param date max_start_date:  The maximum start date.(MM/DD/YYYY or YYYY-MM-DD)
        :param list[int] calendar_category_id:  Each type of event has a calendar category with an integer id. Options are: Open Meetings: 32, Executive Sessions: 39, Public Hearings: 40, Conferences: 33, Roundtables: 34, Election Dates: 36, Federal Holidays: 37, FEA Periods: 38, Commission Meetings: 20, Reporting Deadlines: 21, Conferences and Outreach: 22, AOs and Rules: 23, Other: 24, Quarterly: 25, Monthly: 26, Pre and Post-Elections: 27, EC Periods:28, and IE Periods: 29
        :param int page: For paginating through results, starting at page 1
        :param bool sort_null_only: Toggle that filters out all rows having sort column that is non-null
        :param date min_end_date:  The minimum end date.(MM/DD/YYYY or YYYY-MM-DD)
        :param date min_start_date:  The minimum start date.(MM/DD/YYYY or YYYY-MM-DD)
        :param date max_end_date:  The maximum end date.(MM/DD/YYYY or YYYY-MM-DD)
        :param str renderer:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(CalendarDatePage, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'api_key',
            'summary',
            'sort',
            'description',
            'event_id',
            'per_page',
            'sort_hide_null',
            'sort_nulls_last',
            'max_start_date',
            'calendar_category_id',
            'page',
            'sort_null_only',
            'min_end_date',
            'min_start_date',
            'max_end_date',
            'renderer'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    ' to method calendar_dates_export_get' % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'api_key' is set
        if self.api_client.client_side_validation and ('api_key' not in local_var_params or  # noqa: E501
                                                        local_var_params['api_key'] is None):  # noqa: E501
            raise ApiValueError('Missing the required parameter `api_key` when calling `calendar_dates_export_get`')  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'api_key' in local_var_params and local_var_params['api_key'] is not None:  # noqa: E501
            query_params.append(('api_key', local_var_params['api_key']))  # noqa: E501
        if 'summary' in local_var_params and local_var_params['summary'] is not None:  # noqa: E501
            query_params.append(('summary', local_var_params['summary']))  # noqa: E501
            collection_formats['summary'] = 'multi'  # noqa: E501
        if 'sort' in local_var_params and local_var_params['sort'] is not None:  # noqa: E501
            query_params.append(('sort', local_var_params['sort']))  # noqa: E501
        if 'description' in local_var_params and local_var_params['description'] is not None:  # noqa: E501
            query_params.append(('description', local_var_params['description']))  # noqa: E501
            collection_formats['description'] = 'multi'  # noqa: E501
        if 'event_id' in local_var_params and local_var_params['event_id'] is not None:  # noqa: E501
            query_params.append(('event_id', local_var_params['event_id']))  # noqa: E501
        if 'per_page' in local_var_params and local_var_params['per_page'] is not None:  # noqa: E501
            query_params.append(('per_page', local_var_params['per_page']))  # noqa: E501
        if 'sort_hide_null' in local_var_params and local_var_params['sort_hide_null'] is not None:  # noqa: E501
            query_params.append(('sort_hide_null', local_var_params['sort_hide_null']))  # noqa: E501
        if 'sort_nulls_last' in local_var_params and local_var_params['sort_nulls_last'] is not None:  # noqa: E501
            query_params.append(('sort_nulls_last', local_var_params['sort_nulls_last']))  # noqa: E501
        if 'max_start_date' in local_var_params and local_var_params['max_start_date'] is not None:  # noqa: E501
            query_params.append(('max_start_date', local_var_params['max_start_date']))  # noqa: E501
        if 'calendar_category_id' in local_var_params and local_var_params['calendar_category_id'] is not None:  # noqa: E501
            query_params.append(('calendar_category_id', local_var_params['calendar_category_id']))  # noqa: E501
            collection_formats['calendar_category_id'] = 'multi'  # noqa: E501
        if 'page' in local_var_params and local_var_params['page'] is not None:  # noqa: E501
            query_params.append(('page', local_var_params['page']))  # noqa: E501
        if 'sort_null_only' in local_var_params and local_var_params['sort_null_only'] is not None:  # noqa: E501
            query_params.append(('sort_null_only', local_var_params['sort_null_only']))  # noqa: E501
        if 'min_end_date' in local_var_params and local_var_params['min_end_date'] is not None:  # noqa: E501
            query_params.append(('min_end_date', local_var_params['min_end_date']))  # noqa: E501
        if 'min_start_date' in local_var_params and local_var_params['min_start_date'] is not None:  # noqa: E501
            query_params.append(('min_start_date', local_var_params['min_start_date']))  # noqa: E501
        if 'max_end_date' in local_var_params and local_var_params['max_end_date'] is not None:  # noqa: E501
            query_params.append(('max_end_date', local_var_params['max_end_date']))  # noqa: E501
        if 'renderer' in local_var_params and local_var_params['renderer'] is not None:  # noqa: E501
            query_params.append(('renderer', local_var_params['renderer']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyHeaderAuth', 'ApiKeyQueryAuth', 'apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/calendar-dates/export/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CalendarDatePage',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def calendar_dates_get(self, api_key, **kwargs):  # noqa: E501
        """calendar_dates_get  # noqa: E501

         Combines the election and reporting dates with Commission meetings, conferences, outreach, Advisory Opinions, rules, litigation dates and other events into one calendar.  State and report type filtering is no longer available.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.calendar_dates_get(api_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param list[str] summary: Longer description of event
        :param str sort: Provide a field to sort by. Use `-` for descending order.
        :param list[str] description: Brief description of event
        :param int event_id: An unique ID for an event. Useful for downloading a single event to your calendar. This ID is not a permanent, persistent ID.
        :param int per_page: The number of results returned per page. Defaults to 20.
        :param bool sort_hide_null: Hide null values on sorted column(s).
        :param bool sort_nulls_last: Toggle that sorts null values last
        :param date max_start_date:  The maximum start date.(MM/DD/YYYY or YYYY-MM-DD)
        :param int page: For paginating through results, starting at page 1
        :param list[int] calendar_category_id:  Each type of event has a calendar category with an integer id. Options are: Open Meetings: 32, Executive Sessions: 39, Public Hearings: 40, Conferences: 33, Roundtables: 34, Election Dates: 36, Federal Holidays: 37, FEA Periods: 38, Commission Meetings: 20, Reporting Deadlines: 21, Conferences and Outreach: 22, AOs and Rules: 23, Other: 24, Quarterly: 25, Monthly: 26, Pre and Post-Elections: 27, EC Periods:28, and IE Periods: 29
        :param bool sort_null_only: Toggle that filters out all rows having sort column that is non-null
        :param date min_end_date:  The minimum end date.(MM/DD/YYYY or YYYY-MM-DD)
        :param date min_start_date:  The minimum start date.(MM/DD/YYYY or YYYY-MM-DD)
        :param date max_end_date:  The maximum end date.(MM/DD/YYYY or YYYY-MM-DD)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: CalendarDatePage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.calendar_dates_get_with_http_info(api_key, **kwargs)  # noqa: E501

    def calendar_dates_get_with_http_info(self, api_key, **kwargs):  # noqa: E501
        """calendar_dates_get  # noqa: E501

         Combines the election and reporting dates with Commission meetings, conferences, outreach, Advisory Opinions, rules, litigation dates and other events into one calendar.  State and report type filtering is no longer available.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.calendar_dates_get_with_http_info(api_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param list[str] summary: Longer description of event
        :param str sort: Provide a field to sort by. Use `-` for descending order.
        :param list[str] description: Brief description of event
        :param int event_id: An unique ID for an event. Useful for downloading a single event to your calendar. This ID is not a permanent, persistent ID.
        :param int per_page: The number of results returned per page. Defaults to 20.
        :param bool sort_hide_null: Hide null values on sorted column(s).
        :param bool sort_nulls_last: Toggle that sorts null values last
        :param date max_start_date:  The maximum start date.(MM/DD/YYYY or YYYY-MM-DD)
        :param int page: For paginating through results, starting at page 1
        :param list[int] calendar_category_id:  Each type of event has a calendar category with an integer id. Options are: Open Meetings: 32, Executive Sessions: 39, Public Hearings: 40, Conferences: 33, Roundtables: 34, Election Dates: 36, Federal Holidays: 37, FEA Periods: 38, Commission Meetings: 20, Reporting Deadlines: 21, Conferences and Outreach: 22, AOs and Rules: 23, Other: 24, Quarterly: 25, Monthly: 26, Pre and Post-Elections: 27, EC Periods:28, and IE Periods: 29
        :param bool sort_null_only: Toggle that filters out all rows having sort column that is non-null
        :param date min_end_date:  The minimum end date.(MM/DD/YYYY or YYYY-MM-DD)
        :param date min_start_date:  The minimum start date.(MM/DD/YYYY or YYYY-MM-DD)
        :param date max_end_date:  The maximum end date.(MM/DD/YYYY or YYYY-MM-DD)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(CalendarDatePage, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'api_key',
            'summary',
            'sort',
            'description',
            'event_id',
            'per_page',
            'sort_hide_null',
            'sort_nulls_last',
            'max_start_date',
            'page',
            'calendar_category_id',
            'sort_null_only',
            'min_end_date',
            'min_start_date',
            'max_end_date'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    ' to method calendar_dates_get' % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'api_key' is set
        if self.api_client.client_side_validation and ('api_key' not in local_var_params or  # noqa: E501
                                                        local_var_params['api_key'] is None):  # noqa: E501
            raise ApiValueError('Missing the required parameter `api_key` when calling `calendar_dates_get`')  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'api_key' in local_var_params and local_var_params['api_key'] is not None:  # noqa: E501
            query_params.append(('api_key', local_var_params['api_key']))  # noqa: E501
        if 'summary' in local_var_params and local_var_params['summary'] is not None:  # noqa: E501
            query_params.append(('summary', local_var_params['summary']))  # noqa: E501
            collection_formats['summary'] = 'multi'  # noqa: E501
        if 'sort' in local_var_params and local_var_params['sort'] is not None:  # noqa: E501
            query_params.append(('sort', local_var_params['sort']))  # noqa: E501
        if 'description' in local_var_params and local_var_params['description'] is not None:  # noqa: E501
            query_params.append(('description', local_var_params['description']))  # noqa: E501
            collection_formats['description'] = 'multi'  # noqa: E501
        if 'event_id' in local_var_params and local_var_params['event_id'] is not None:  # noqa: E501
            query_params.append(('event_id', local_var_params['event_id']))  # noqa: E501
        if 'per_page' in local_var_params and local_var_params['per_page'] is not None:  # noqa: E501
            query_params.append(('per_page', local_var_params['per_page']))  # noqa: E501
        if 'sort_hide_null' in local_var_params and local_var_params['sort_hide_null'] is not None:  # noqa: E501
            query_params.append(('sort_hide_null', local_var_params['sort_hide_null']))  # noqa: E501
        if 'sort_nulls_last' in local_var_params and local_var_params['sort_nulls_last'] is not None:  # noqa: E501
            query_params.append(('sort_nulls_last', local_var_params['sort_nulls_last']))  # noqa: E501
        if 'max_start_date' in local_var_params and local_var_params['max_start_date'] is not None:  # noqa: E501
            query_params.append(('max_start_date', local_var_params['max_start_date']))  # noqa: E501
        if 'page' in local_var_params and local_var_params['page'] is not None:  # noqa: E501
            query_params.append(('page', local_var_params['page']))  # noqa: E501
        if 'calendar_category_id' in local_var_params and local_var_params['calendar_category_id'] is not None:  # noqa: E501
            query_params.append(('calendar_category_id', local_var_params['calendar_category_id']))  # noqa: E501
            collection_formats['calendar_category_id'] = 'multi'  # noqa: E501
        if 'sort_null_only' in local_var_params and local_var_params['sort_null_only'] is not None:  # noqa: E501
            query_params.append(('sort_null_only', local_var_params['sort_null_only']))  # noqa: E501
        if 'min_end_date' in local_var_params and local_var_params['min_end_date'] is not None:  # noqa: E501
            query_params.append(('min_end_date', local_var_params['min_end_date']))  # noqa: E501
        if 'min_start_date' in local_var_params and local_var_params['min_start_date'] is not None:  # noqa: E501
            query_params.append(('min_start_date', local_var_params['min_start_date']))  # noqa: E501
        if 'max_end_date' in local_var_params and local_var_params['max_end_date'] is not None:  # noqa: E501
            query_params.append(('max_end_date', local_var_params['max_end_date']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyHeaderAuth', 'ApiKeyQueryAuth', 'apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/calendar-dates/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CalendarDatePage',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def election_dates_get(self, api_key, **kwargs):  # noqa: E501
        """election_dates_get  # noqa: E501

         FEC election dates since 1995.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.election_dates_get(api_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param list[str] election_state:  State or territory of the office sought.
        :param date min_election_date:  The minimum date of election.
        :param list[str] office_sought:  House, Senate or presidential office.
        :param str sort: Provide a field to sort by. Use `-` for descending order.
        :param date max_create_date:  The maximum date this record was added to the system.(MM/DD/YYYY or YYYY-MM-DD)
        :param date max_election_date:  The maximum date of election.
        :param bool sort_nulls_last: Toggle that sorts null values last
        :param bool sort_null_only: Toggle that filters out all rows having sort column that is non-null
        :param date max_update_date:  The maximum date this record was last updated.(MM/DD/YYYY or YYYY-MM-DD)
        :param list[str] election_type_id:  Election type id
        :param list[str] election_party:  Party, if applicable.
        :param list[str] election_year: Year of election
        :param bool sort_hide_null: Hide null values on sorted column(s).
        :param int per_page: The number of results returned per page. Defaults to 20.
        :param list[str] election_district:  House district of the office sought, if applicable.
        :param date min_primary_general_date:  The minimum date of primary or general election.(MM/DD/YYYY or YYYY-MM-DD)
        :param int page: For paginating through results, starting at page 1
        :param date max_primary_general_date:  The maximum date of primary or general election.(MM/DD/YYYY or YYYY-MM-DD)
        :param date min_create_date:  The minimum date this record was added to the system.(MM/DD/YYYY or YYYY-MM-DD)
        :param date min_update_date:  The minimum date this record was last updated.(MM/DD/YYYY or YYYY-MM-DD)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: InlineResponseDefault
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.election_dates_get_with_http_info(api_key, **kwargs)  # noqa: E501

    def election_dates_get_with_http_info(self, api_key, **kwargs):  # noqa: E501
        """election_dates_get  # noqa: E501

         FEC election dates since 1995.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.election_dates_get_with_http_info(api_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param list[str] election_state:  State or territory of the office sought.
        :param date min_election_date:  The minimum date of election.
        :param list[str] office_sought:  House, Senate or presidential office.
        :param str sort: Provide a field to sort by. Use `-` for descending order.
        :param date max_create_date:  The maximum date this record was added to the system.(MM/DD/YYYY or YYYY-MM-DD)
        :param date max_election_date:  The maximum date of election.
        :param bool sort_nulls_last: Toggle that sorts null values last
        :param bool sort_null_only: Toggle that filters out all rows having sort column that is non-null
        :param date max_update_date:  The maximum date this record was last updated.(MM/DD/YYYY or YYYY-MM-DD)
        :param list[str] election_type_id:  Election type id
        :param list[str] election_party:  Party, if applicable.
        :param list[str] election_year: Year of election
        :param bool sort_hide_null: Hide null values on sorted column(s).
        :param int per_page: The number of results returned per page. Defaults to 20.
        :param list[str] election_district:  House district of the office sought, if applicable.
        :param date min_primary_general_date:  The minimum date of primary or general election.(MM/DD/YYYY or YYYY-MM-DD)
        :param int page: For paginating through results, starting at page 1
        :param date max_primary_general_date:  The maximum date of primary or general election.(MM/DD/YYYY or YYYY-MM-DD)
        :param date min_create_date:  The minimum date this record was added to the system.(MM/DD/YYYY or YYYY-MM-DD)
        :param date min_update_date:  The minimum date this record was last updated.(MM/DD/YYYY or YYYY-MM-DD)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(InlineResponseDefault, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'api_key',
            'election_state',
            'min_election_date',
            'office_sought',
            'sort',
            'max_create_date',
            'max_election_date',
            'sort_nulls_last',
            'sort_null_only',
            'max_update_date',
            'election_type_id',
            'election_party',
            'election_year',
            'sort_hide_null',
            'per_page',
            'election_district',
            'min_primary_general_date',
            'page',
            'max_primary_general_date',
            'min_create_date',
            'min_update_date'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    ' to method election_dates_get' % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'api_key' is set
        if self.api_client.client_side_validation and ('api_key' not in local_var_params or  # noqa: E501
                                                        local_var_params['api_key'] is None):  # noqa: E501
            raise ApiValueError('Missing the required parameter `api_key` when calling `election_dates_get`')  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'election_state' in local_var_params and local_var_params['election_state'] is not None:  # noqa: E501
            query_params.append(('election_state', local_var_params['election_state']))  # noqa: E501
            collection_formats['election_state'] = 'multi'  # noqa: E501
        if 'min_election_date' in local_var_params and local_var_params['min_election_date'] is not None:  # noqa: E501
            query_params.append(('min_election_date', local_var_params['min_election_date']))  # noqa: E501
        if 'office_sought' in local_var_params and local_var_params['office_sought'] is not None:  # noqa: E501
            query_params.append(('office_sought', local_var_params['office_sought']))  # noqa: E501
            collection_formats['office_sought'] = 'multi'  # noqa: E501
        if 'sort' in local_var_params and local_var_params['sort'] is not None:  # noqa: E501
            query_params.append(('sort', local_var_params['sort']))  # noqa: E501
        if 'api_key' in local_var_params and local_var_params['api_key'] is not None:  # noqa: E501
            query_params.append(('api_key', local_var_params['api_key']))  # noqa: E501
        if 'max_create_date' in local_var_params and local_var_params['max_create_date'] is not None:  # noqa: E501
            query_params.append(('max_create_date', local_var_params['max_create_date']))  # noqa: E501
        if 'max_election_date' in local_var_params and local_var_params['max_election_date'] is not None:  # noqa: E501
            query_params.append(('max_election_date', local_var_params['max_election_date']))  # noqa: E501
        if 'sort_nulls_last' in local_var_params and local_var_params['sort_nulls_last'] is not None:  # noqa: E501
            query_params.append(('sort_nulls_last', local_var_params['sort_nulls_last']))  # noqa: E501
        if 'sort_null_only' in local_var_params and local_var_params['sort_null_only'] is not None:  # noqa: E501
            query_params.append(('sort_null_only', local_var_params['sort_null_only']))  # noqa: E501
        if 'max_update_date' in local_var_params and local_var_params['max_update_date'] is not None:  # noqa: E501
            query_params.append(('max_update_date', local_var_params['max_update_date']))  # noqa: E501
        if 'election_type_id' in local_var_params and local_var_params['election_type_id'] is not None:  # noqa: E501
            query_params.append(('election_type_id', local_var_params['election_type_id']))  # noqa: E501
            collection_formats['election_type_id'] = 'multi'  # noqa: E501
        if 'election_party' in local_var_params and local_var_params['election_party'] is not None:  # noqa: E501
            query_params.append(('election_party', local_var_params['election_party']))  # noqa: E501
            collection_formats['election_party'] = 'multi'  # noqa: E501
        if 'election_year' in local_var_params and local_var_params['election_year'] is not None:  # noqa: E501
            query_params.append(('election_year', local_var_params['election_year']))  # noqa: E501
            collection_formats['election_year'] = 'multi'  # noqa: E501
        if 'sort_hide_null' in local_var_params and local_var_params['sort_hide_null'] is not None:  # noqa: E501
            query_params.append(('sort_hide_null', local_var_params['sort_hide_null']))  # noqa: E501
        if 'per_page' in local_var_params and local_var_params['per_page'] is not None:  # noqa: E501
            query_params.append(('per_page', local_var_params['per_page']))  # noqa: E501
        if 'election_district' in local_var_params and local_var_params['election_district'] is not None:  # noqa: E501
            query_params.append(('election_district', local_var_params['election_district']))  # noqa: E501
            collection_formats['election_district'] = 'multi'  # noqa: E501
        if 'min_primary_general_date' in local_var_params and local_var_params['min_primary_general_date'] is not None:  # noqa: E501
            query_params.append(('min_primary_general_date', local_var_params['min_primary_general_date']))  # noqa: E501
        if 'page' in local_var_params and local_var_params['page'] is not None:  # noqa: E501
            query_params.append(('page', local_var_params['page']))  # noqa: E501
        if 'max_primary_general_date' in local_var_params and local_var_params['max_primary_general_date'] is not None:  # noqa: E501
            query_params.append(('max_primary_general_date', local_var_params['max_primary_general_date']))  # noqa: E501
        if 'min_create_date' in local_var_params and local_var_params['min_create_date'] is not None:  # noqa: E501
            query_params.append(('min_create_date', local_var_params['min_create_date']))  # noqa: E501
        if 'min_update_date' in local_var_params and local_var_params['min_update_date'] is not None:  # noqa: E501
            query_params.append(('min_update_date', local_var_params['min_update_date']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyHeaderAuth', 'ApiKeyQueryAuth', 'apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/election-dates/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InlineResponseDefault',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def reporting_dates_get(self, api_key, **kwargs):  # noqa: E501
        """reporting_dates_get  # noqa: E501

         FEC election dates since 1995.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.reporting_dates_get(api_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param list[int] report_year:  Forms with coverage date -      year from the coverage ending date. Forms without coverage date -      year from the receipt date.
        :param str sort: Provide a field to sort by. Use `-` for descending order.
        :param date max_due_date:  The maximum date the report is due.(MM/DD/YYYY or YYYY-MM-DD)
        :param bool sort_hide_null: Hide null values on sorted column(s).
        :param date min_due_date:  The minimum date the report is due.(MM/DD/YYYY or YYYY-MM-DD)
        :param int per_page: The number of results returned per page. Defaults to 20.
        :param date max_create_date:  The maximum date this record was added to the system.(MM/DD/YYYY or YYYY-MM-DD)
        :param date min_update_date:  The minimum date this record was last updated.(MM/DD/YYYY or YYYY-MM-DD)
        :param bool sort_nulls_last: Toggle that sorts null values last
        :param int page: For paginating through results, starting at page 1
        :param bool sort_null_only: Toggle that filters out all rows having sort column that is non-null
        :param date min_create_date:  The minimum date this record was added to the system.(MM/DD/YYYY or YYYY-MM-DD)
        :param date max_update_date:  The maximum date this record was last updated.(MM/DD/YYYY or YYYY-MM-DD)
        :param list[str] report_type: Name of report where the underlying data comes from:     - 10D Pre-Election     - 10G Pre-General     - 10P Pre-Primary     - 10R Pre-Run-Off     - 10S Pre-Special     - 12C Pre-Convention     - 12G Pre-General     - 12P Pre-Primary     - 12R Pre-Run-Off     - 12S Pre-Special     - 30D Post-Election     - 30G Post-General     - 30P Post-Primary     - 30R Post-Run-Off     - 30S Post-Special     - 60D Post-Convention     - M1  January Monthly     - M10 October Monthly     - M11 November Monthly     - M12 December Monthly     - M2  February Monthly     - M3  March Monthly     - M4  April Monthly     - M5  May Monthly     - M6  June Monthly     - M7  July Monthly     - M8  August Monthly     - M9  September Monthly     - MY  Mid-Year Report     - Q1  April Quarterly     - Q2  July Quarterly     - Q3  October Quarterly     - TER Termination Report     - YE  Year-End     - ADJ COMP ADJUST AMEND     - CA  COMPREHENSIVE AMEND     - 90S Post Inaugural Supplement     - 90D Post Inaugural     - 48  48 Hour Notification     - 24  24 Hour Notification     - M7S July Monthly/Semi-Annual     - MSA Monthly Semi-Annual (MY)     - MYS Monthly Year End/Semi-Annual     - Q2S July Quarterly/Semi-Annual     - QSA Quarterly Semi-Annual (MY)     - QYS Quarterly Year End/Semi-Annual     - QYE Quarterly Semi-Annual (YE)     - QMS Quarterly Mid-Year/ Semi-Annual     - MSY Monthly Semi-Annual (YE)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: InlineResponseDefault2
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.reporting_dates_get_with_http_info(api_key, **kwargs)  # noqa: E501

    def reporting_dates_get_with_http_info(self, api_key, **kwargs):  # noqa: E501
        """reporting_dates_get  # noqa: E501

         FEC election dates since 1995.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.reporting_dates_get_with_http_info(api_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param list[int] report_year:  Forms with coverage date -      year from the coverage ending date. Forms without coverage date -      year from the receipt date.
        :param str sort: Provide a field to sort by. Use `-` for descending order.
        :param date max_due_date:  The maximum date the report is due.(MM/DD/YYYY or YYYY-MM-DD)
        :param bool sort_hide_null: Hide null values on sorted column(s).
        :param date min_due_date:  The minimum date the report is due.(MM/DD/YYYY or YYYY-MM-DD)
        :param int per_page: The number of results returned per page. Defaults to 20.
        :param date max_create_date:  The maximum date this record was added to the system.(MM/DD/YYYY or YYYY-MM-DD)
        :param date min_update_date:  The minimum date this record was last updated.(MM/DD/YYYY or YYYY-MM-DD)
        :param bool sort_nulls_last: Toggle that sorts null values last
        :param int page: For paginating through results, starting at page 1
        :param bool sort_null_only: Toggle that filters out all rows having sort column that is non-null
        :param date min_create_date:  The minimum date this record was added to the system.(MM/DD/YYYY or YYYY-MM-DD)
        :param date max_update_date:  The maximum date this record was last updated.(MM/DD/YYYY or YYYY-MM-DD)
        :param list[str] report_type: Name of report where the underlying data comes from:     - 10D Pre-Election     - 10G Pre-General     - 10P Pre-Primary     - 10R Pre-Run-Off     - 10S Pre-Special     - 12C Pre-Convention     - 12G Pre-General     - 12P Pre-Primary     - 12R Pre-Run-Off     - 12S Pre-Special     - 30D Post-Election     - 30G Post-General     - 30P Post-Primary     - 30R Post-Run-Off     - 30S Post-Special     - 60D Post-Convention     - M1  January Monthly     - M10 October Monthly     - M11 November Monthly     - M12 December Monthly     - M2  February Monthly     - M3  March Monthly     - M4  April Monthly     - M5  May Monthly     - M6  June Monthly     - M7  July Monthly     - M8  August Monthly     - M9  September Monthly     - MY  Mid-Year Report     - Q1  April Quarterly     - Q2  July Quarterly     - Q3  October Quarterly     - TER Termination Report     - YE  Year-End     - ADJ COMP ADJUST AMEND     - CA  COMPREHENSIVE AMEND     - 90S Post Inaugural Supplement     - 90D Post Inaugural     - 48  48 Hour Notification     - 24  24 Hour Notification     - M7S July Monthly/Semi-Annual     - MSA Monthly Semi-Annual (MY)     - MYS Monthly Year End/Semi-Annual     - Q2S July Quarterly/Semi-Annual     - QSA Quarterly Semi-Annual (MY)     - QYS Quarterly Year End/Semi-Annual     - QYE Quarterly Semi-Annual (YE)     - QMS Quarterly Mid-Year/ Semi-Annual     - MSY Monthly Semi-Annual (YE)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(InlineResponseDefault2, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'api_key',
            'report_year',
            'sort',
            'max_due_date',
            'sort_hide_null',
            'min_due_date',
            'per_page',
            'max_create_date',
            'min_update_date',
            'sort_nulls_last',
            'page',
            'sort_null_only',
            'min_create_date',
            'max_update_date',
            'report_type'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    ' to method reporting_dates_get' % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'api_key' is set
        if self.api_client.client_side_validation and ('api_key' not in local_var_params or  # noqa: E501
                                                        local_var_params['api_key'] is None):  # noqa: E501
            raise ApiValueError('Missing the required parameter `api_key` when calling `reporting_dates_get`')  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'report_year' in local_var_params and local_var_params['report_year'] is not None:  # noqa: E501
            query_params.append(('report_year', local_var_params['report_year']))  # noqa: E501
            collection_formats['report_year'] = 'multi'  # noqa: E501
        if 'api_key' in local_var_params and local_var_params['api_key'] is not None:  # noqa: E501
            query_params.append(('api_key', local_var_params['api_key']))  # noqa: E501
        if 'sort' in local_var_params and local_var_params['sort'] is not None:  # noqa: E501
            query_params.append(('sort', local_var_params['sort']))  # noqa: E501
        if 'max_due_date' in local_var_params and local_var_params['max_due_date'] is not None:  # noqa: E501
            query_params.append(('max_due_date', local_var_params['max_due_date']))  # noqa: E501
        if 'sort_hide_null' in local_var_params and local_var_params['sort_hide_null'] is not None:  # noqa: E501
            query_params.append(('sort_hide_null', local_var_params['sort_hide_null']))  # noqa: E501
        if 'min_due_date' in local_var_params and local_var_params['min_due_date'] is not None:  # noqa: E501
            query_params.append(('min_due_date', local_var_params['min_due_date']))  # noqa: E501
        if 'per_page' in local_var_params and local_var_params['per_page'] is not None:  # noqa: E501
            query_params.append(('per_page', local_var_params['per_page']))  # noqa: E501
        if 'max_create_date' in local_var_params and local_var_params['max_create_date'] is not None:  # noqa: E501
            query_params.append(('max_create_date', local_var_params['max_create_date']))  # noqa: E501
        if 'min_update_date' in local_var_params and local_var_params['min_update_date'] is not None:  # noqa: E501
            query_params.append(('min_update_date', local_var_params['min_update_date']))  # noqa: E501
        if 'sort_nulls_last' in local_var_params and local_var_params['sort_nulls_last'] is not None:  # noqa: E501
            query_params.append(('sort_nulls_last', local_var_params['sort_nulls_last']))  # noqa: E501
        if 'page' in local_var_params and local_var_params['page'] is not None:  # noqa: E501
            query_params.append(('page', local_var_params['page']))  # noqa: E501
        if 'sort_null_only' in local_var_params and local_var_params['sort_null_only'] is not None:  # noqa: E501
            query_params.append(('sort_null_only', local_var_params['sort_null_only']))  # noqa: E501
        if 'min_create_date' in local_var_params and local_var_params['min_create_date'] is not None:  # noqa: E501
            query_params.append(('min_create_date', local_var_params['min_create_date']))  # noqa: E501
        if 'max_update_date' in local_var_params and local_var_params['max_update_date'] is not None:  # noqa: E501
            query_params.append(('max_update_date', local_var_params['max_update_date']))  # noqa: E501
        if 'report_type' in local_var_params and local_var_params['report_type'] is not None:  # noqa: E501
            query_params.append(('report_type', local_var_params['report_type']))  # noqa: E501
            collection_formats['report_type'] = 'multi'  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyHeaderAuth', 'ApiKeyQueryAuth', 'apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/reporting-dates/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InlineResponseDefault2',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
