# coding: utf-8

"""
    OpenFEC

    This API allows you to explore the way candidates and committees fund their campaigns.    The FEC API is a RESTful web service supporting full-text and field-specific searches on FEC data. [Bulk downloads](https://www.fec.gov/data/advanced/?tab=bulk-data) are available on the current site. Information is tied to the underlying forms by file ID and image ID. Data is updated nightly.    There is a lot of data, but a good place to start is to use search to find interesting candidates and committees. Then, you can use their IDs to find report or line item details with the other endpoints. If you are interested in individual donors, check out contributor information in schedule_a.    Get an [API key here](https://api.data.gov/signup/). That will enable you to place up to 1,000 calls an hour. Each call is limited to 100 results per page. You can email questions, comments or a request to get a key for 120 calls per minute to [APIinfo@fec.gov](mailto:apiinfo@fec.gov). You can also ask questions and discuss the data in the [FEC data Google Group](https://groups.google.com/forum/#!forum/fec-data). API changes will also be added to this group in advance of the change.    The model definitions and schema are available at [/swagger](/swagger/). This is useful for making wrappers and exploring the data.    A few restrictions limit the way you can use FEC data. For example, you can’t use contributor lists for commercial purposes or to solicit donations. [Learn more here](https://www.fec.gov/updates/sale-or-use-contributor-information/).    [View our source code](https://github.com/fecgov/openFEC). We welcome issues and pull requests!  # noqa: E501

    The version of the OpenAPI document: 1.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from openfec_sdk.api_client import ApiClient
from openfec_sdk.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class ElectioneeringApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def committee_committee_id_electioneering_by_candidate_get(self, api_key, committee_id, **kwargs):  # noqa: E501
        """committee_committee_id_electioneering_by_candidate_get  # noqa: E501

        Electioneering costs aggregated by candidate  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.committee_committee_id_electioneering_by_candidate_get(api_key, committee_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param str committee_id: (required)
        :param bool election_full: `True` indicates that full election period of a candidate. `False` indicates that two year election cycle.
        :param str sort: Provide a field to sort by. Use `-` for descending order.
        :param list[str] candidate_id:  A unique identifier assigned to each candidate registered with the FEC. If a person runs for several offices, that person will have separate candidate IDs for each office.
        :param str state: US state or territory where a candidate runs for office
        :param bool sort_hide_null: Hide null values on sorted column(s).
        :param int per_page: The number of results returned per page. Defaults to 20.
        :param str district: Two-digit US House distirict of the office the candidate is running for. Presidential, Senate and House at-large candidates will have District 00.
        :param bool sort_nulls_last: Toggle that sorts null values last
        :param list[int] cycle:  Filter records to only those that were applicable to a given two-year period.The cycle begins with an odd year and is named for its ending, even year.
        :param int page: For paginating through results, starting at page 1
        :param bool sort_null_only: Toggle that filters out all rows having sort column that is non-null
        :param str office: Federal office candidate runs for: H, S or P
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ElectioneeringByCandidatePage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.committee_committee_id_electioneering_by_candidate_get_with_http_info(api_key, committee_id, **kwargs)  # noqa: E501

    def committee_committee_id_electioneering_by_candidate_get_with_http_info(self, api_key, committee_id, **kwargs):  # noqa: E501
        """committee_committee_id_electioneering_by_candidate_get  # noqa: E501

        Electioneering costs aggregated by candidate  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.committee_committee_id_electioneering_by_candidate_get_with_http_info(api_key, committee_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param str committee_id: (required)
        :param bool election_full: `True` indicates that full election period of a candidate. `False` indicates that two year election cycle.
        :param str sort: Provide a field to sort by. Use `-` for descending order.
        :param list[str] candidate_id:  A unique identifier assigned to each candidate registered with the FEC. If a person runs for several offices, that person will have separate candidate IDs for each office.
        :param str state: US state or territory where a candidate runs for office
        :param bool sort_hide_null: Hide null values on sorted column(s).
        :param int per_page: The number of results returned per page. Defaults to 20.
        :param str district: Two-digit US House distirict of the office the candidate is running for. Presidential, Senate and House at-large candidates will have District 00.
        :param bool sort_nulls_last: Toggle that sorts null values last
        :param list[int] cycle:  Filter records to only those that were applicable to a given two-year period.The cycle begins with an odd year and is named for its ending, even year.
        :param int page: For paginating through results, starting at page 1
        :param bool sort_null_only: Toggle that filters out all rows having sort column that is non-null
        :param str office: Federal office candidate runs for: H, S or P
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ElectioneeringByCandidatePage, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'api_key',
            'committee_id',
            'election_full',
            'sort',
            'candidate_id',
            'state',
            'sort_hide_null',
            'per_page',
            'district',
            'sort_nulls_last',
            'cycle',
            'page',
            'sort_null_only',
            'office'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    ' to method committee_committee_id_electioneering_by_candidate_get' % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'api_key' is set
        if self.api_client.client_side_validation and ('api_key' not in local_var_params or  # noqa: E501
                                                        local_var_params['api_key'] is None):  # noqa: E501
            raise ApiValueError('Missing the required parameter `api_key` when calling `committee_committee_id_electioneering_by_candidate_get`')  # noqa: E501
        # verify the required parameter 'committee_id' is set
        if self.api_client.client_side_validation and ('committee_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['committee_id'] is None):  # noqa: E501
            raise ApiValueError('Missing the required parameter `committee_id` when calling `committee_committee_id_electioneering_by_candidate_get`')  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'committee_id' in local_var_params:
            path_params['committee_id'] = local_var_params['committee_id']  # noqa: E501

        query_params = []
        if 'election_full' in local_var_params and local_var_params['election_full'] is not None:  # noqa: E501
            query_params.append(('election_full', local_var_params['election_full']))  # noqa: E501
        if 'api_key' in local_var_params and local_var_params['api_key'] is not None:  # noqa: E501
            query_params.append(('api_key', local_var_params['api_key']))  # noqa: E501
        if 'sort' in local_var_params and local_var_params['sort'] is not None:  # noqa: E501
            query_params.append(('sort', local_var_params['sort']))  # noqa: E501
        if 'candidate_id' in local_var_params and local_var_params['candidate_id'] is not None:  # noqa: E501
            query_params.append(('candidate_id', local_var_params['candidate_id']))  # noqa: E501
            collection_formats['candidate_id'] = 'multi'  # noqa: E501
        if 'state' in local_var_params and local_var_params['state'] is not None:  # noqa: E501
            query_params.append(('state', local_var_params['state']))  # noqa: E501
        if 'sort_hide_null' in local_var_params and local_var_params['sort_hide_null'] is not None:  # noqa: E501
            query_params.append(('sort_hide_null', local_var_params['sort_hide_null']))  # noqa: E501
        if 'per_page' in local_var_params and local_var_params['per_page'] is not None:  # noqa: E501
            query_params.append(('per_page', local_var_params['per_page']))  # noqa: E501
        if 'district' in local_var_params and local_var_params['district'] is not None:  # noqa: E501
            query_params.append(('district', local_var_params['district']))  # noqa: E501
        if 'sort_nulls_last' in local_var_params and local_var_params['sort_nulls_last'] is not None:  # noqa: E501
            query_params.append(('sort_nulls_last', local_var_params['sort_nulls_last']))  # noqa: E501
        if 'cycle' in local_var_params and local_var_params['cycle'] is not None:  # noqa: E501
            query_params.append(('cycle', local_var_params['cycle']))  # noqa: E501
            collection_formats['cycle'] = 'multi'  # noqa: E501
        if 'page' in local_var_params and local_var_params['page'] is not None:  # noqa: E501
            query_params.append(('page', local_var_params['page']))  # noqa: E501
        if 'sort_null_only' in local_var_params and local_var_params['sort_null_only'] is not None:  # noqa: E501
            query_params.append(('sort_null_only', local_var_params['sort_null_only']))  # noqa: E501
        if 'office' in local_var_params and local_var_params['office'] is not None:  # noqa: E501
            query_params.append(('office', local_var_params['office']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyHeaderAuth', 'ApiKeyQueryAuth', 'apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/committee/{committee_id}/electioneering/by_candidate/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ElectioneeringByCandidatePage',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def electioneering_aggregates_get(self, api_key, **kwargs):  # noqa: E501
        """electioneering_aggregates_get  # noqa: E501

        Electioneering communications costs aggregates  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.electioneering_aggregates_get(api_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param str sort: Provide a field to sort by. Use `-` for descending order.
        :param list[str] candidate_id:  A unique identifier assigned to each candidate registered with the FEC. If a person runs for several offices, that person will have separate candidate IDs for each office.
        :param bool sort_hide_null: Hide null values on sorted column(s).
        :param int per_page: The number of results returned per page. Defaults to 20.
        :param bool sort_nulls_last: Toggle that sorts null values last
        :param list[str] committee_id:  A unique identifier assigned to each committee or filer registered with the FEC. In general committee id's begin with the letter C which is followed by eight digits.
        :param list[int] cycle:  Filter records to only those that were applicable to a given two-year period.The cycle begins with an odd year and is named for its ending, even year.
        :param int page: For paginating through results, starting at page 1
        :param bool sort_null_only: Toggle that filters out all rows having sort column that is non-null
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ElectioneeringByCandidatePage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.electioneering_aggregates_get_with_http_info(api_key, **kwargs)  # noqa: E501

    def electioneering_aggregates_get_with_http_info(self, api_key, **kwargs):  # noqa: E501
        """electioneering_aggregates_get  # noqa: E501

        Electioneering communications costs aggregates  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.electioneering_aggregates_get_with_http_info(api_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param str sort: Provide a field to sort by. Use `-` for descending order.
        :param list[str] candidate_id:  A unique identifier assigned to each candidate registered with the FEC. If a person runs for several offices, that person will have separate candidate IDs for each office.
        :param bool sort_hide_null: Hide null values on sorted column(s).
        :param int per_page: The number of results returned per page. Defaults to 20.
        :param bool sort_nulls_last: Toggle that sorts null values last
        :param list[str] committee_id:  A unique identifier assigned to each committee or filer registered with the FEC. In general committee id's begin with the letter C which is followed by eight digits.
        :param list[int] cycle:  Filter records to only those that were applicable to a given two-year period.The cycle begins with an odd year and is named for its ending, even year.
        :param int page: For paginating through results, starting at page 1
        :param bool sort_null_only: Toggle that filters out all rows having sort column that is non-null
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ElectioneeringByCandidatePage, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'api_key',
            'sort',
            'candidate_id',
            'sort_hide_null',
            'per_page',
            'sort_nulls_last',
            'committee_id',
            'cycle',
            'page',
            'sort_null_only'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    ' to method electioneering_aggregates_get' % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'api_key' is set
        if self.api_client.client_side_validation and ('api_key' not in local_var_params or  # noqa: E501
                                                        local_var_params['api_key'] is None):  # noqa: E501
            raise ApiValueError('Missing the required parameter `api_key` when calling `electioneering_aggregates_get`')  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'api_key' in local_var_params and local_var_params['api_key'] is not None:  # noqa: E501
            query_params.append(('api_key', local_var_params['api_key']))  # noqa: E501
        if 'sort' in local_var_params and local_var_params['sort'] is not None:  # noqa: E501
            query_params.append(('sort', local_var_params['sort']))  # noqa: E501
        if 'candidate_id' in local_var_params and local_var_params['candidate_id'] is not None:  # noqa: E501
            query_params.append(('candidate_id', local_var_params['candidate_id']))  # noqa: E501
            collection_formats['candidate_id'] = 'multi'  # noqa: E501
        if 'sort_hide_null' in local_var_params and local_var_params['sort_hide_null'] is not None:  # noqa: E501
            query_params.append(('sort_hide_null', local_var_params['sort_hide_null']))  # noqa: E501
        if 'per_page' in local_var_params and local_var_params['per_page'] is not None:  # noqa: E501
            query_params.append(('per_page', local_var_params['per_page']))  # noqa: E501
        if 'sort_nulls_last' in local_var_params and local_var_params['sort_nulls_last'] is not None:  # noqa: E501
            query_params.append(('sort_nulls_last', local_var_params['sort_nulls_last']))  # noqa: E501
        if 'committee_id' in local_var_params and local_var_params['committee_id'] is not None:  # noqa: E501
            query_params.append(('committee_id', local_var_params['committee_id']))  # noqa: E501
            collection_formats['committee_id'] = 'multi'  # noqa: E501
        if 'cycle' in local_var_params and local_var_params['cycle'] is not None:  # noqa: E501
            query_params.append(('cycle', local_var_params['cycle']))  # noqa: E501
            collection_formats['cycle'] = 'multi'  # noqa: E501
        if 'page' in local_var_params and local_var_params['page'] is not None:  # noqa: E501
            query_params.append(('page', local_var_params['page']))  # noqa: E501
        if 'sort_null_only' in local_var_params and local_var_params['sort_null_only'] is not None:  # noqa: E501
            query_params.append(('sort_null_only', local_var_params['sort_null_only']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyHeaderAuth', 'ApiKeyQueryAuth', 'apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/electioneering/aggregates/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ElectioneeringByCandidatePage',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def electioneering_by_candidate_get(self, api_key, **kwargs):  # noqa: E501
        """electioneering_by_candidate_get  # noqa: E501

        Electioneering costs aggregated by candidate  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.electioneering_by_candidate_get(api_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param bool election_full: `True` indicates that full election period of a candidate. `False` indicates that two year election cycle.
        :param str sort: Provide a field to sort by. Use `-` for descending order.
        :param list[str] candidate_id:  A unique identifier assigned to each candidate registered with the FEC. If a person runs for several offices, that person will have separate candidate IDs for each office.
        :param str state: US state or territory where a candidate runs for office
        :param bool sort_hide_null: Hide null values on sorted column(s).
        :param int per_page: The number of results returned per page. Defaults to 20.
        :param str district: Two-digit US House distirict of the office the candidate is running for. Presidential, Senate and House at-large candidates will have District 00.
        :param bool sort_nulls_last: Toggle that sorts null values last
        :param list[int] cycle:  Filter records to only those that were applicable to a given two-year period.The cycle begins with an odd year and is named for its ending, even year.
        :param int page: For paginating through results, starting at page 1
        :param bool sort_null_only: Toggle that filters out all rows having sort column that is non-null
        :param str office: Federal office candidate runs for: H, S or P
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ElectioneeringByCandidatePage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.electioneering_by_candidate_get_with_http_info(api_key, **kwargs)  # noqa: E501

    def electioneering_by_candidate_get_with_http_info(self, api_key, **kwargs):  # noqa: E501
        """electioneering_by_candidate_get  # noqa: E501

        Electioneering costs aggregated by candidate  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.electioneering_by_candidate_get_with_http_info(api_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param bool election_full: `True` indicates that full election period of a candidate. `False` indicates that two year election cycle.
        :param str sort: Provide a field to sort by. Use `-` for descending order.
        :param list[str] candidate_id:  A unique identifier assigned to each candidate registered with the FEC. If a person runs for several offices, that person will have separate candidate IDs for each office.
        :param str state: US state or territory where a candidate runs for office
        :param bool sort_hide_null: Hide null values on sorted column(s).
        :param int per_page: The number of results returned per page. Defaults to 20.
        :param str district: Two-digit US House distirict of the office the candidate is running for. Presidential, Senate and House at-large candidates will have District 00.
        :param bool sort_nulls_last: Toggle that sorts null values last
        :param list[int] cycle:  Filter records to only those that were applicable to a given two-year period.The cycle begins with an odd year and is named for its ending, even year.
        :param int page: For paginating through results, starting at page 1
        :param bool sort_null_only: Toggle that filters out all rows having sort column that is non-null
        :param str office: Federal office candidate runs for: H, S or P
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ElectioneeringByCandidatePage, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'api_key',
            'election_full',
            'sort',
            'candidate_id',
            'state',
            'sort_hide_null',
            'per_page',
            'district',
            'sort_nulls_last',
            'cycle',
            'page',
            'sort_null_only',
            'office'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    ' to method electioneering_by_candidate_get' % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'api_key' is set
        if self.api_client.client_side_validation and ('api_key' not in local_var_params or  # noqa: E501
                                                        local_var_params['api_key'] is None):  # noqa: E501
            raise ApiValueError('Missing the required parameter `api_key` when calling `electioneering_by_candidate_get`')  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'election_full' in local_var_params and local_var_params['election_full'] is not None:  # noqa: E501
            query_params.append(('election_full', local_var_params['election_full']))  # noqa: E501
        if 'api_key' in local_var_params and local_var_params['api_key'] is not None:  # noqa: E501
            query_params.append(('api_key', local_var_params['api_key']))  # noqa: E501
        if 'sort' in local_var_params and local_var_params['sort'] is not None:  # noqa: E501
            query_params.append(('sort', local_var_params['sort']))  # noqa: E501
        if 'candidate_id' in local_var_params and local_var_params['candidate_id'] is not None:  # noqa: E501
            query_params.append(('candidate_id', local_var_params['candidate_id']))  # noqa: E501
            collection_formats['candidate_id'] = 'multi'  # noqa: E501
        if 'state' in local_var_params and local_var_params['state'] is not None:  # noqa: E501
            query_params.append(('state', local_var_params['state']))  # noqa: E501
        if 'sort_hide_null' in local_var_params and local_var_params['sort_hide_null'] is not None:  # noqa: E501
            query_params.append(('sort_hide_null', local_var_params['sort_hide_null']))  # noqa: E501
        if 'per_page' in local_var_params and local_var_params['per_page'] is not None:  # noqa: E501
            query_params.append(('per_page', local_var_params['per_page']))  # noqa: E501
        if 'district' in local_var_params and local_var_params['district'] is not None:  # noqa: E501
            query_params.append(('district', local_var_params['district']))  # noqa: E501
        if 'sort_nulls_last' in local_var_params and local_var_params['sort_nulls_last'] is not None:  # noqa: E501
            query_params.append(('sort_nulls_last', local_var_params['sort_nulls_last']))  # noqa: E501
        if 'cycle' in local_var_params and local_var_params['cycle'] is not None:  # noqa: E501
            query_params.append(('cycle', local_var_params['cycle']))  # noqa: E501
            collection_formats['cycle'] = 'multi'  # noqa: E501
        if 'page' in local_var_params and local_var_params['page'] is not None:  # noqa: E501
            query_params.append(('page', local_var_params['page']))  # noqa: E501
        if 'sort_null_only' in local_var_params and local_var_params['sort_null_only'] is not None:  # noqa: E501
            query_params.append(('sort_null_only', local_var_params['sort_null_only']))  # noqa: E501
        if 'office' in local_var_params and local_var_params['office'] is not None:  # noqa: E501
            query_params.append(('office', local_var_params['office']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyHeaderAuth', 'ApiKeyQueryAuth', 'apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/electioneering/by_candidate/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ElectioneeringByCandidatePage',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def electioneering_get(self, api_key, **kwargs):  # noqa: E501
        """electioneering_get  # noqa: E501

         An electioneering communication is any broadcast, cable or satellite communication that fulfills each of the following conditions:  _The communication refers to a clearly identified federal candidate._  _The communication is publicly distributed by a television station, radio station, cable television system or satellite system for a fee._  _The communication is distributed within 60 days prior to a general election or 30 days prior to a primary election to federal office._   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.electioneering_get(api_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param list[int] report_year:  Forms with coverage date -      year from the coverage ending date. Forms without coverage date -      year from the receipt date.
        :param str sort: Provide a field to sort by. Use `-` for descending order.
        :param list[str] candidate_id:  A unique identifier assigned to each candidate registered with the FEC. If a person runs for several offices, that person will have separate candidate IDs for each office.
        :param str description:
        :param date min_date: Minimum disbursement date
        :param int per_page: The number of results returned per page. Defaults to 20.
        :param bool sort_hide_null: Hide null values on sorted column(s).
        :param bool sort_nulls_last: Toggle that sorts null values last
        :param list[str] committee_id:  A unique identifier assigned to each committee or filer registered with the FEC. In general committee id's begin with the letter C which is followed by eight digits.
        :param int page: For paginating through results, starting at page 1
        :param str min_amount: Filter for all amounts greater than a value.
        :param str max_amount: Filter for all amounts less than a value.
        :param int last_index: Index of last result from previous page
        :param bool sort_null_only: Toggle that filters out all rows having sort column that is non-null
        :param date max_date: Maximum disbursement date
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ElectioneeringPage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.electioneering_get_with_http_info(api_key, **kwargs)  # noqa: E501

    def electioneering_get_with_http_info(self, api_key, **kwargs):  # noqa: E501
        """electioneering_get  # noqa: E501

         An electioneering communication is any broadcast, cable or satellite communication that fulfills each of the following conditions:  _The communication refers to a clearly identified federal candidate._  _The communication is publicly distributed by a television station, radio station, cable television system or satellite system for a fee._  _The communication is distributed within 60 days prior to a general election or 30 days prior to a primary election to federal office._   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.electioneering_get_with_http_info(api_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param list[int] report_year:  Forms with coverage date -      year from the coverage ending date. Forms without coverage date -      year from the receipt date.
        :param str sort: Provide a field to sort by. Use `-` for descending order.
        :param list[str] candidate_id:  A unique identifier assigned to each candidate registered with the FEC. If a person runs for several offices, that person will have separate candidate IDs for each office.
        :param str description:
        :param date min_date: Minimum disbursement date
        :param int per_page: The number of results returned per page. Defaults to 20.
        :param bool sort_hide_null: Hide null values on sorted column(s).
        :param bool sort_nulls_last: Toggle that sorts null values last
        :param list[str] committee_id:  A unique identifier assigned to each committee or filer registered with the FEC. In general committee id's begin with the letter C which is followed by eight digits.
        :param int page: For paginating through results, starting at page 1
        :param str min_amount: Filter for all amounts greater than a value.
        :param str max_amount: Filter for all amounts less than a value.
        :param int last_index: Index of last result from previous page
        :param bool sort_null_only: Toggle that filters out all rows having sort column that is non-null
        :param date max_date: Maximum disbursement date
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ElectioneeringPage, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'api_key',
            'report_year',
            'sort',
            'candidate_id',
            'description',
            'min_date',
            'per_page',
            'sort_hide_null',
            'sort_nulls_last',
            'committee_id',
            'page',
            'min_amount',
            'max_amount',
            'last_index',
            'sort_null_only',
            'max_date'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    ' to method electioneering_get' % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'api_key' is set
        if self.api_client.client_side_validation and ('api_key' not in local_var_params or  # noqa: E501
                                                        local_var_params['api_key'] is None):  # noqa: E501
            raise ApiValueError('Missing the required parameter `api_key` when calling `electioneering_get`')  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'report_year' in local_var_params and local_var_params['report_year'] is not None:  # noqa: E501
            query_params.append(('report_year', local_var_params['report_year']))  # noqa: E501
            collection_formats['report_year'] = 'multi'  # noqa: E501
        if 'api_key' in local_var_params and local_var_params['api_key'] is not None:  # noqa: E501
            query_params.append(('api_key', local_var_params['api_key']))  # noqa: E501
        if 'sort' in local_var_params and local_var_params['sort'] is not None:  # noqa: E501
            query_params.append(('sort', local_var_params['sort']))  # noqa: E501
        if 'candidate_id' in local_var_params and local_var_params['candidate_id'] is not None:  # noqa: E501
            query_params.append(('candidate_id', local_var_params['candidate_id']))  # noqa: E501
            collection_formats['candidate_id'] = 'multi'  # noqa: E501
        if 'description' in local_var_params and local_var_params['description'] is not None:  # noqa: E501
            query_params.append(('description', local_var_params['description']))  # noqa: E501
        if 'min_date' in local_var_params and local_var_params['min_date'] is not None:  # noqa: E501
            query_params.append(('min_date', local_var_params['min_date']))  # noqa: E501
        if 'per_page' in local_var_params and local_var_params['per_page'] is not None:  # noqa: E501
            query_params.append(('per_page', local_var_params['per_page']))  # noqa: E501
        if 'sort_hide_null' in local_var_params and local_var_params['sort_hide_null'] is not None:  # noqa: E501
            query_params.append(('sort_hide_null', local_var_params['sort_hide_null']))  # noqa: E501
        if 'sort_nulls_last' in local_var_params and local_var_params['sort_nulls_last'] is not None:  # noqa: E501
            query_params.append(('sort_nulls_last', local_var_params['sort_nulls_last']))  # noqa: E501
        if 'committee_id' in local_var_params and local_var_params['committee_id'] is not None:  # noqa: E501
            query_params.append(('committee_id', local_var_params['committee_id']))  # noqa: E501
            collection_formats['committee_id'] = 'multi'  # noqa: E501
        if 'page' in local_var_params and local_var_params['page'] is not None:  # noqa: E501
            query_params.append(('page', local_var_params['page']))  # noqa: E501
        if 'min_amount' in local_var_params and local_var_params['min_amount'] is not None:  # noqa: E501
            query_params.append(('min_amount', local_var_params['min_amount']))  # noqa: E501
        if 'max_amount' in local_var_params and local_var_params['max_amount'] is not None:  # noqa: E501
            query_params.append(('max_amount', local_var_params['max_amount']))  # noqa: E501
        if 'last_index' in local_var_params and local_var_params['last_index'] is not None:  # noqa: E501
            query_params.append(('last_index', local_var_params['last_index']))  # noqa: E501
        if 'sort_null_only' in local_var_params and local_var_params['sort_null_only'] is not None:  # noqa: E501
            query_params.append(('sort_null_only', local_var_params['sort_null_only']))  # noqa: E501
        if 'max_date' in local_var_params and local_var_params['max_date'] is not None:  # noqa: E501
            query_params.append(('max_date', local_var_params['max_date']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyHeaderAuth', 'ApiKeyQueryAuth', 'apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/electioneering/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ElectioneeringPage',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def electioneering_totals_by_candidate_get(self, api_key, **kwargs):  # noqa: E501
        """electioneering_totals_by_candidate_get  # noqa: E501

         Total electioneering communications spent on candidates by cycle or candidate election year   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.electioneering_totals_by_candidate_get(api_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param bool election_full: `True` indicates that full election period of a candidate. `False` indicates that two year election cycle.
        :param str sort: Provide a field to sort by. Use `-` for descending order.
        :param list[str] candidate_id:  A unique identifier assigned to each candidate registered with the FEC. If a person runs for several offices, that person will have separate candidate IDs for each office.
        :param bool sort_hide_null: Hide null values on sorted column(s).
        :param int per_page: The number of results returned per page. Defaults to 20.
        :param bool sort_nulls_last: Toggle that sorts null values last
        :param list[int] cycle:  Filter records to only those that were applicable to a given two-year period.The cycle begins with an odd year and is named for its ending, even year.
        :param int page: For paginating through results, starting at page 1
        :param bool sort_null_only: Toggle that filters out all rows having sort column that is non-null
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ECTotalsByCandidatePage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.electioneering_totals_by_candidate_get_with_http_info(api_key, **kwargs)  # noqa: E501

    def electioneering_totals_by_candidate_get_with_http_info(self, api_key, **kwargs):  # noqa: E501
        """electioneering_totals_by_candidate_get  # noqa: E501

         Total electioneering communications spent on candidates by cycle or candidate election year   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.electioneering_totals_by_candidate_get_with_http_info(api_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param bool election_full: `True` indicates that full election period of a candidate. `False` indicates that two year election cycle.
        :param str sort: Provide a field to sort by. Use `-` for descending order.
        :param list[str] candidate_id:  A unique identifier assigned to each candidate registered with the FEC. If a person runs for several offices, that person will have separate candidate IDs for each office.
        :param bool sort_hide_null: Hide null values on sorted column(s).
        :param int per_page: The number of results returned per page. Defaults to 20.
        :param bool sort_nulls_last: Toggle that sorts null values last
        :param list[int] cycle:  Filter records to only those that were applicable to a given two-year period.The cycle begins with an odd year and is named for its ending, even year.
        :param int page: For paginating through results, starting at page 1
        :param bool sort_null_only: Toggle that filters out all rows having sort column that is non-null
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ECTotalsByCandidatePage, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'api_key',
            'election_full',
            'sort',
            'candidate_id',
            'sort_hide_null',
            'per_page',
            'sort_nulls_last',
            'cycle',
            'page',
            'sort_null_only'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    ' to method electioneering_totals_by_candidate_get' % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'api_key' is set
        if self.api_client.client_side_validation and ('api_key' not in local_var_params or  # noqa: E501
                                                        local_var_params['api_key'] is None):  # noqa: E501
            raise ApiValueError('Missing the required parameter `api_key` when calling `electioneering_totals_by_candidate_get`')  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'election_full' in local_var_params and local_var_params['election_full'] is not None:  # noqa: E501
            query_params.append(('election_full', local_var_params['election_full']))  # noqa: E501
        if 'api_key' in local_var_params and local_var_params['api_key'] is not None:  # noqa: E501
            query_params.append(('api_key', local_var_params['api_key']))  # noqa: E501
        if 'sort' in local_var_params and local_var_params['sort'] is not None:  # noqa: E501
            query_params.append(('sort', local_var_params['sort']))  # noqa: E501
        if 'candidate_id' in local_var_params and local_var_params['candidate_id'] is not None:  # noqa: E501
            query_params.append(('candidate_id', local_var_params['candidate_id']))  # noqa: E501
            collection_formats['candidate_id'] = 'multi'  # noqa: E501
        if 'sort_hide_null' in local_var_params and local_var_params['sort_hide_null'] is not None:  # noqa: E501
            query_params.append(('sort_hide_null', local_var_params['sort_hide_null']))  # noqa: E501
        if 'per_page' in local_var_params and local_var_params['per_page'] is not None:  # noqa: E501
            query_params.append(('per_page', local_var_params['per_page']))  # noqa: E501
        if 'sort_nulls_last' in local_var_params and local_var_params['sort_nulls_last'] is not None:  # noqa: E501
            query_params.append(('sort_nulls_last', local_var_params['sort_nulls_last']))  # noqa: E501
        if 'cycle' in local_var_params and local_var_params['cycle'] is not None:  # noqa: E501
            query_params.append(('cycle', local_var_params['cycle']))  # noqa: E501
            collection_formats['cycle'] = 'multi'  # noqa: E501
        if 'page' in local_var_params and local_var_params['page'] is not None:  # noqa: E501
            query_params.append(('page', local_var_params['page']))  # noqa: E501
        if 'sort_null_only' in local_var_params and local_var_params['sort_null_only'] is not None:  # noqa: E501
            query_params.append(('sort_null_only', local_var_params['sort_null_only']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyHeaderAuth', 'ApiKeyQueryAuth', 'apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/electioneering/totals/by_candidate/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ECTotalsByCandidatePage',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
