# coding: utf-8

"""
    OpenFEC

    This API allows you to explore the way candidates and committees fund their campaigns.    The FEC API is a RESTful web service supporting full-text and field-specific searches on FEC data. [Bulk downloads](https://www.fec.gov/data/advanced/?tab=bulk-data) are available on the current site. Information is tied to the underlying forms by file ID and image ID. Data is updated nightly.    There is a lot of data, but a good place to start is to use search to find interesting candidates and committees. Then, you can use their IDs to find report or line item details with the other endpoints. If you are interested in individual donors, check out contributor information in schedule_a.    Get an [API key here](https://api.data.gov/signup/). That will enable you to place up to 1,000 calls an hour. Each call is limited to 100 results per page. You can email questions, comments or a request to get a key for 120 calls per minute to [APIinfo@fec.gov](mailto:apiinfo@fec.gov). You can also ask questions and discuss the data in the [FEC data Google Group](https://groups.google.com/forum/#!forum/fec-data). API changes will also be added to this group in advance of the change.    The model definitions and schema are available at [/swagger](/swagger/). This is useful for making wrappers and exploring the data.    A few restrictions limit the way you can use FEC data. For example, you can’t use contributor lists for commercial purposes or to solicit donations. [Learn more here](https://www.fec.gov/updates/sale-or-use-contributor-information/).    [View our source code](https://github.com/fecgov/openFEC). We welcome issues and pull requests!  # noqa: E501

    The version of the OpenAPI document: 1.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from openfec_sdk.api_client import ApiClient
from openfec_sdk.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class FilerResourcesApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def rad_analyst_get(self, api_key, **kwargs):  # noqa: E501
        """rad_analyst_get  # noqa: E501

         Use this endpoint to look up the RAD Analyst for a committee.  The mission of the Reports Analysis Division (RAD) is to ensure that campaigns and political committees file timely and accurate reports that fully disclose their financial activities.  RAD is responsible for reviewing statements and financial reports filed by political committees participating in federal elections, providing assistance and guidance to the committees to properly file their reports, and for taking appropriate action to ensure compliance with the Federal Election Campaign Act (FECA).   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.rad_analyst_get(api_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param str sort: Provide a field to sort by. Use `-` for descending order.
        :param date min_assignment_update_date: Filter results for assignment updates made after this date
        :param list[str] name: Name of RAD analyst
        :param int per_page: The number of results returned per page. Defaults to 20.
        :param list[int] analyst_short_id: Short ID of RAD analyst
        :param bool sort_hide_null: Hide null values on sorted column(s).
        :param list[int] telephone_ext: Telephone extension of RAD analyst
        :param list[str] title: Title of RAD analyst
        :param bool sort_nulls_last: Toggle that sorts null values last
        :param list[str] committee_id:  A unique identifier assigned to each committee or filer registered with the FEC. In general committee id's begin with the letter C which is followed by eight digits.
        :param int page: For paginating through results, starting at page 1
        :param date max_assignment_update_date: Filter results for assignment updates made before this date
        :param list[str] email: Email of RAD analyst
        :param bool sort_null_only: Toggle that filters out all rows having sort column that is non-null
        :param list[int] analyst_id: ID of RAD analyst
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: RadAnalystPage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.rad_analyst_get_with_http_info(api_key, **kwargs)  # noqa: E501

    def rad_analyst_get_with_http_info(self, api_key, **kwargs):  # noqa: E501
        """rad_analyst_get  # noqa: E501

         Use this endpoint to look up the RAD Analyst for a committee.  The mission of the Reports Analysis Division (RAD) is to ensure that campaigns and political committees file timely and accurate reports that fully disclose their financial activities.  RAD is responsible for reviewing statements and financial reports filed by political committees participating in federal elections, providing assistance and guidance to the committees to properly file their reports, and for taking appropriate action to ensure compliance with the Federal Election Campaign Act (FECA).   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.rad_analyst_get_with_http_info(api_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param str sort: Provide a field to sort by. Use `-` for descending order.
        :param date min_assignment_update_date: Filter results for assignment updates made after this date
        :param list[str] name: Name of RAD analyst
        :param int per_page: The number of results returned per page. Defaults to 20.
        :param list[int] analyst_short_id: Short ID of RAD analyst
        :param bool sort_hide_null: Hide null values on sorted column(s).
        :param list[int] telephone_ext: Telephone extension of RAD analyst
        :param list[str] title: Title of RAD analyst
        :param bool sort_nulls_last: Toggle that sorts null values last
        :param list[str] committee_id:  A unique identifier assigned to each committee or filer registered with the FEC. In general committee id's begin with the letter C which is followed by eight digits.
        :param int page: For paginating through results, starting at page 1
        :param date max_assignment_update_date: Filter results for assignment updates made before this date
        :param list[str] email: Email of RAD analyst
        :param bool sort_null_only: Toggle that filters out all rows having sort column that is non-null
        :param list[int] analyst_id: ID of RAD analyst
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(RadAnalystPage, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'api_key',
            'sort',
            'min_assignment_update_date',
            'name',
            'per_page',
            'analyst_short_id',
            'sort_hide_null',
            'telephone_ext',
            'title',
            'sort_nulls_last',
            'committee_id',
            'page',
            'max_assignment_update_date',
            'email',
            'sort_null_only',
            'analyst_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    ' to method rad_analyst_get' % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'api_key' is set
        if self.api_client.client_side_validation and ('api_key' not in local_var_params or  # noqa: E501
                                                        local_var_params['api_key'] is None):  # noqa: E501
            raise ApiValueError('Missing the required parameter `api_key` when calling `rad_analyst_get`')  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'api_key' in local_var_params and local_var_params['api_key'] is not None:  # noqa: E501
            query_params.append(('api_key', local_var_params['api_key']))  # noqa: E501
        if 'sort' in local_var_params and local_var_params['sort'] is not None:  # noqa: E501
            query_params.append(('sort', local_var_params['sort']))  # noqa: E501
        if 'min_assignment_update_date' in local_var_params and local_var_params['min_assignment_update_date'] is not None:  # noqa: E501
            query_params.append(('min_assignment_update_date', local_var_params['min_assignment_update_date']))  # noqa: E501
        if 'name' in local_var_params and local_var_params['name'] is not None:  # noqa: E501
            query_params.append(('name', local_var_params['name']))  # noqa: E501
            collection_formats['name'] = 'multi'  # noqa: E501
        if 'per_page' in local_var_params and local_var_params['per_page'] is not None:  # noqa: E501
            query_params.append(('per_page', local_var_params['per_page']))  # noqa: E501
        if 'analyst_short_id' in local_var_params and local_var_params['analyst_short_id'] is not None:  # noqa: E501
            query_params.append(('analyst_short_id', local_var_params['analyst_short_id']))  # noqa: E501
            collection_formats['analyst_short_id'] = 'multi'  # noqa: E501
        if 'sort_hide_null' in local_var_params and local_var_params['sort_hide_null'] is not None:  # noqa: E501
            query_params.append(('sort_hide_null', local_var_params['sort_hide_null']))  # noqa: E501
        if 'telephone_ext' in local_var_params and local_var_params['telephone_ext'] is not None:  # noqa: E501
            query_params.append(('telephone_ext', local_var_params['telephone_ext']))  # noqa: E501
            collection_formats['telephone_ext'] = 'multi'  # noqa: E501
        if 'title' in local_var_params and local_var_params['title'] is not None:  # noqa: E501
            query_params.append(('title', local_var_params['title']))  # noqa: E501
            collection_formats['title'] = 'multi'  # noqa: E501
        if 'sort_nulls_last' in local_var_params and local_var_params['sort_nulls_last'] is not None:  # noqa: E501
            query_params.append(('sort_nulls_last', local_var_params['sort_nulls_last']))  # noqa: E501
        if 'committee_id' in local_var_params and local_var_params['committee_id'] is not None:  # noqa: E501
            query_params.append(('committee_id', local_var_params['committee_id']))  # noqa: E501
            collection_formats['committee_id'] = 'multi'  # noqa: E501
        if 'page' in local_var_params and local_var_params['page'] is not None:  # noqa: E501
            query_params.append(('page', local_var_params['page']))  # noqa: E501
        if 'max_assignment_update_date' in local_var_params and local_var_params['max_assignment_update_date'] is not None:  # noqa: E501
            query_params.append(('max_assignment_update_date', local_var_params['max_assignment_update_date']))  # noqa: E501
        if 'email' in local_var_params and local_var_params['email'] is not None:  # noqa: E501
            query_params.append(('email', local_var_params['email']))  # noqa: E501
            collection_formats['email'] = 'multi'  # noqa: E501
        if 'sort_null_only' in local_var_params and local_var_params['sort_null_only'] is not None:  # noqa: E501
            query_params.append(('sort_null_only', local_var_params['sort_null_only']))  # noqa: E501
        if 'analyst_id' in local_var_params and local_var_params['analyst_id'] is not None:  # noqa: E501
            query_params.append(('analyst_id', local_var_params['analyst_id']))  # noqa: E501
            collection_formats['analyst_id'] = 'multi'  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyHeaderAuth', 'ApiKeyQueryAuth', 'apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/rad-analyst/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RadAnalystPage',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def state_election_office_get(self, api_key, state, **kwargs):  # noqa: E501
        """state_election_office_get  # noqa: E501

         State laws and procedures govern elections for state or local offices as well as how candidates appear on election ballots. Contact the appropriate state election office for more information.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.state_election_office_get(api_key, state, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param str state:  Enter a state (Ex: AK, TX, VA etc..) to find the local election offices contact information.   (required)
        :param bool sort_nulls_last: Toggle that sorts null values last
        :param int page: For paginating through results, starting at page 1
        :param str sort: Provide a field to sort by. Use `-` for descending order.
        :param bool sort_hide_null: Hide null values on sorted column(s).
        :param int per_page: The number of results returned per page. Defaults to 20.
        :param bool sort_null_only: Toggle that filters out all rows having sort column that is non-null
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: StateElectionOfficeInfoPage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.state_election_office_get_with_http_info(api_key, state, **kwargs)  # noqa: E501

    def state_election_office_get_with_http_info(self, api_key, state, **kwargs):  # noqa: E501
        """state_election_office_get  # noqa: E501

         State laws and procedures govern elections for state or local offices as well as how candidates appear on election ballots. Contact the appropriate state election office for more information.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.state_election_office_get_with_http_info(api_key, state, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param str state:  Enter a state (Ex: AK, TX, VA etc..) to find the local election offices contact information.   (required)
        :param bool sort_nulls_last: Toggle that sorts null values last
        :param int page: For paginating through results, starting at page 1
        :param str sort: Provide a field to sort by. Use `-` for descending order.
        :param bool sort_hide_null: Hide null values on sorted column(s).
        :param int per_page: The number of results returned per page. Defaults to 20.
        :param bool sort_null_only: Toggle that filters out all rows having sort column that is non-null
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(StateElectionOfficeInfoPage, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'api_key',
            'state',
            'sort_nulls_last',
            'page',
            'sort',
            'sort_hide_null',
            'per_page',
            'sort_null_only'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    ' to method state_election_office_get' % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'api_key' is set
        if self.api_client.client_side_validation and ('api_key' not in local_var_params or  # noqa: E501
                                                        local_var_params['api_key'] is None):  # noqa: E501
            raise ApiValueError('Missing the required parameter `api_key` when calling `state_election_office_get`')  # noqa: E501
        # verify the required parameter 'state' is set
        if self.api_client.client_side_validation and ('state' not in local_var_params or  # noqa: E501
                                                        local_var_params['state'] is None):  # noqa: E501
            raise ApiValueError('Missing the required parameter `state` when calling `state_election_office_get`')  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'sort_nulls_last' in local_var_params and local_var_params['sort_nulls_last'] is not None:  # noqa: E501
            query_params.append(('sort_nulls_last', local_var_params['sort_nulls_last']))  # noqa: E501
        if 'page' in local_var_params and local_var_params['page'] is not None:  # noqa: E501
            query_params.append(('page', local_var_params['page']))  # noqa: E501
        if 'api_key' in local_var_params and local_var_params['api_key'] is not None:  # noqa: E501
            query_params.append(('api_key', local_var_params['api_key']))  # noqa: E501
        if 'sort' in local_var_params and local_var_params['sort'] is not None:  # noqa: E501
            query_params.append(('sort', local_var_params['sort']))  # noqa: E501
        if 'state' in local_var_params and local_var_params['state'] is not None:  # noqa: E501
            query_params.append(('state', local_var_params['state']))  # noqa: E501
        if 'sort_hide_null' in local_var_params and local_var_params['sort_hide_null'] is not None:  # noqa: E501
            query_params.append(('sort_hide_null', local_var_params['sort_hide_null']))  # noqa: E501
        if 'per_page' in local_var_params and local_var_params['per_page'] is not None:  # noqa: E501
            query_params.append(('per_page', local_var_params['per_page']))  # noqa: E501
        if 'sort_null_only' in local_var_params and local_var_params['sort_null_only'] is not None:  # noqa: E501
            query_params.append(('sort_null_only', local_var_params['sort_null_only']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyHeaderAuth', 'ApiKeyQueryAuth', 'apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/state-election-office/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='StateElectionOfficeInfoPage',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
