# coding: utf-8

"""
    OpenFEC

    This API allows you to explore the way candidates and committees fund their campaigns.    The FEC API is a RESTful web service supporting full-text and field-specific searches on FEC data. [Bulk downloads](https://www.fec.gov/data/advanced/?tab=bulk-data) are available on the current site. Information is tied to the underlying forms by file ID and image ID. Data is updated nightly.    There is a lot of data, but a good place to start is to use search to find interesting candidates and committees. Then, you can use their IDs to find report or line item details with the other endpoints. If you are interested in individual donors, check out contributor information in schedule_a.    Get an [API key here](https://api.data.gov/signup/). That will enable you to place up to 1,000 calls an hour. Each call is limited to 100 results per page. You can email questions, comments or a request to get a key for 120 calls per minute to [APIinfo@fec.gov](mailto:apiinfo@fec.gov). You can also ask questions and discuss the data in the [FEC data Google Group](https://groups.google.com/forum/#!forum/fec-data). API changes will also be added to this group in advance of the change.    The model definitions and schema are available at [/swagger](/swagger/). This is useful for making wrappers and exploring the data.    A few restrictions limit the way you can use FEC data. For example, you can’t use contributor lists for commercial purposes or to solicit donations. [Learn more here](https://www.fec.gov/updates/sale-or-use-contributor-information/).    [View our source code](https://github.com/fecgov/openFEC). We welcome issues and pull requests!  # noqa: E501

    The version of the OpenAPI document: 1.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from openfec_sdk.api_client import ApiClient
from openfec_sdk.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class FinancialApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def committee_committee_id_reports_get(self, api_key, committee_id, **kwargs):  # noqa: E501
        """committee_committee_id_reports_get  # noqa: E501

         Each report represents the summary information from FEC Form 3, Form 3X and Form 3P. These reports have key statistics that illuminate the financial status of a given committee. Things like cash on hand, debts owed by committee, total receipts, and total disbursements are especially helpful for understanding a committee's financial dealings.  By default, this endpoint includes both amended and final versions of each report. To restrict to only the final versions of each report, use `is_amended=false`; to view only reports that have been amended, use `is_amended=true`.  Several different reporting structures exist, depending on the type of organization that submits financial information. To see an example of these reporting requirements, look at the summary and detailed summary pages of FEC Form 3, Form 3X, and Form 3P.  DISCLAIMER: The field labels contained within this resource are subject to change.  We are attempting to succinctly label these fields while conveying clear meaning to ensure accessibility for all users.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.committee_committee_id_reports_get(api_key, committee_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param str committee_id:  A unique identifier assigned to each committee or filer registered with the FEC. In general committee id's begin with the letter C which is followed by eight digits.  (required)
        :param str min_cash_on_hand_end_period_amount:  Filter for all amounts greater than a value.
        :param list[str] beginning_image_number:  Unique identifier for the electronic or paper report. This number is used to construct PDF URLs to the original document.
        :param str min_debts_owed_amount:  Filter for all amounts greater than a value.
        :param list[int] year:  Forms with coverage date -      year from the coverage ending date. Forms without coverage date -      year from the receipt date.
        :param str min_disbursements_amount:  Filter for all amounts greater than a value.
        :param list[str] sort: Provide a field to sort by. Use - for descending order.
        :param str candidate_id:  A unique identifier assigned to each candidate registered with the FEC. If a person runs for several offices, that person will have separate candidate IDs for each office.
        :param str max_receipts_amount:  Filter for all amounts less than a value.
        :param str min_receipts_amount:  Filter for all amounts greater than a value.
        :param bool sort_nulls_last: Toggle that sorts null values last
        :param bool sort_null_only: Toggle that filters out all rows having sort column that is non-null
        :param str max_disbursements_amount:  Filter for all amounts less than a value.
        :param str min_independent_expenditures:  Filter for all amounts greater than a value.
        :param str max_independent_expenditures:  Filter for all amounts less than a value.
        :param str min_total_contributions:  Filter for all amounts greater than a value.
        :param list[str] report_type: Report type; prefix with \"-\" to exclude. Name of report where the underlying data comes from:     - 10D Pre-Election     - 10G Pre-General     - 10P Pre-Primary     - 10R Pre-Run-Off     - 10S Pre-Special     - 12C Pre-Convention     - 12G Pre-General     - 12P Pre-Primary     - 12R Pre-Run-Off     - 12S Pre-Special     - 30D Post-Election     - 30G Post-General     - 30P Post-Primary     - 30R Post-Run-Off     - 30S Post-Special     - 60D Post-Convention     - M1  January Monthly     - M10 October Monthly     - M11 November Monthly     - M12 December Monthly     - M2  February Monthly     - M3  March Monthly     - M4  April Monthly     - M5  May Monthly     - M6  June Monthly     - M7  July Monthly     - M8  August Monthly     - M9  September Monthly     - MY  Mid-Year Report     - Q1  April Quarterly     - Q2  July Quarterly     - Q3  October Quarterly     - TER Termination Report     - YE  Year-End     - ADJ COMP ADJUST AMEND     - CA  COMPREHENSIVE AMEND
        :param list[str] type: The one-letter type code of the organization:         - C communication cost         - D delegate         - E electioneering communication         - H House         - I independent expenditor (person or group)         - N PAC - nonqualified         - O independent expenditure-only (super PACs)         - P presidential         - Q PAC - qualified         - S Senate         - U single candidate independent expenditure         - V PAC with non-contribution account, nonqualified         - W PAC with non-contribution account, qualified         - X party, nonqualified         - Y party, qualified         - Z national party non-federal account
        :param bool sort_hide_null: Hide null values on sorted column(s).
        :param int per_page: The number of results returned per page. Defaults to 20.
        :param str max_debts_owed_expenditures:  Filter for all amounts less than a value.
        :param str max_total_contributions:  Filter for all amounts less than a value.
        :param str min_party_coordinated_expenditures:  Filter for all amounts greater than a value.
        :param int page: For paginating through results, starting at page 1
        :param list[int] cycle:  Filter records to only those that were applicable to a given two-year period.The cycle begins with an odd year and is named for its ending, even year.
        :param bool is_amended:  False indicates that a report is the most recent. True indicates that the report has been superseded by an amendment.
        :param str max_cash_on_hand_end_period_amount:  Filter for all amounts less than a value.
        :param str max_party_coordinated_expenditures:  Filter for all amounts less than a value.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: CommitteeReportsPage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.committee_committee_id_reports_get_with_http_info(api_key, committee_id, **kwargs)  # noqa: E501

    def committee_committee_id_reports_get_with_http_info(self, api_key, committee_id, **kwargs):  # noqa: E501
        """committee_committee_id_reports_get  # noqa: E501

         Each report represents the summary information from FEC Form 3, Form 3X and Form 3P. These reports have key statistics that illuminate the financial status of a given committee. Things like cash on hand, debts owed by committee, total receipts, and total disbursements are especially helpful for understanding a committee's financial dealings.  By default, this endpoint includes both amended and final versions of each report. To restrict to only the final versions of each report, use `is_amended=false`; to view only reports that have been amended, use `is_amended=true`.  Several different reporting structures exist, depending on the type of organization that submits financial information. To see an example of these reporting requirements, look at the summary and detailed summary pages of FEC Form 3, Form 3X, and Form 3P.  DISCLAIMER: The field labels contained within this resource are subject to change.  We are attempting to succinctly label these fields while conveying clear meaning to ensure accessibility for all users.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.committee_committee_id_reports_get_with_http_info(api_key, committee_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param str committee_id:  A unique identifier assigned to each committee or filer registered with the FEC. In general committee id's begin with the letter C which is followed by eight digits.  (required)
        :param str min_cash_on_hand_end_period_amount:  Filter for all amounts greater than a value.
        :param list[str] beginning_image_number:  Unique identifier for the electronic or paper report. This number is used to construct PDF URLs to the original document.
        :param str min_debts_owed_amount:  Filter for all amounts greater than a value.
        :param list[int] year:  Forms with coverage date -      year from the coverage ending date. Forms without coverage date -      year from the receipt date.
        :param str min_disbursements_amount:  Filter for all amounts greater than a value.
        :param list[str] sort: Provide a field to sort by. Use - for descending order.
        :param str candidate_id:  A unique identifier assigned to each candidate registered with the FEC. If a person runs for several offices, that person will have separate candidate IDs for each office.
        :param str max_receipts_amount:  Filter for all amounts less than a value.
        :param str min_receipts_amount:  Filter for all amounts greater than a value.
        :param bool sort_nulls_last: Toggle that sorts null values last
        :param bool sort_null_only: Toggle that filters out all rows having sort column that is non-null
        :param str max_disbursements_amount:  Filter for all amounts less than a value.
        :param str min_independent_expenditures:  Filter for all amounts greater than a value.
        :param str max_independent_expenditures:  Filter for all amounts less than a value.
        :param str min_total_contributions:  Filter for all amounts greater than a value.
        :param list[str] report_type: Report type; prefix with \"-\" to exclude. Name of report where the underlying data comes from:     - 10D Pre-Election     - 10G Pre-General     - 10P Pre-Primary     - 10R Pre-Run-Off     - 10S Pre-Special     - 12C Pre-Convention     - 12G Pre-General     - 12P Pre-Primary     - 12R Pre-Run-Off     - 12S Pre-Special     - 30D Post-Election     - 30G Post-General     - 30P Post-Primary     - 30R Post-Run-Off     - 30S Post-Special     - 60D Post-Convention     - M1  January Monthly     - M10 October Monthly     - M11 November Monthly     - M12 December Monthly     - M2  February Monthly     - M3  March Monthly     - M4  April Monthly     - M5  May Monthly     - M6  June Monthly     - M7  July Monthly     - M8  August Monthly     - M9  September Monthly     - MY  Mid-Year Report     - Q1  April Quarterly     - Q2  July Quarterly     - Q3  October Quarterly     - TER Termination Report     - YE  Year-End     - ADJ COMP ADJUST AMEND     - CA  COMPREHENSIVE AMEND
        :param list[str] type: The one-letter type code of the organization:         - C communication cost         - D delegate         - E electioneering communication         - H House         - I independent expenditor (person or group)         - N PAC - nonqualified         - O independent expenditure-only (super PACs)         - P presidential         - Q PAC - qualified         - S Senate         - U single candidate independent expenditure         - V PAC with non-contribution account, nonqualified         - W PAC with non-contribution account, qualified         - X party, nonqualified         - Y party, qualified         - Z national party non-federal account
        :param bool sort_hide_null: Hide null values on sorted column(s).
        :param int per_page: The number of results returned per page. Defaults to 20.
        :param str max_debts_owed_expenditures:  Filter for all amounts less than a value.
        :param str max_total_contributions:  Filter for all amounts less than a value.
        :param str min_party_coordinated_expenditures:  Filter for all amounts greater than a value.
        :param int page: For paginating through results, starting at page 1
        :param list[int] cycle:  Filter records to only those that were applicable to a given two-year period.The cycle begins with an odd year and is named for its ending, even year.
        :param bool is_amended:  False indicates that a report is the most recent. True indicates that the report has been superseded by an amendment.
        :param str max_cash_on_hand_end_period_amount:  Filter for all amounts less than a value.
        :param str max_party_coordinated_expenditures:  Filter for all amounts less than a value.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(CommitteeReportsPage, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'api_key',
            'committee_id',
            'min_cash_on_hand_end_period_amount',
            'beginning_image_number',
            'min_debts_owed_amount',
            'year',
            'min_disbursements_amount',
            'sort',
            'candidate_id',
            'max_receipts_amount',
            'min_receipts_amount',
            'sort_nulls_last',
            'sort_null_only',
            'max_disbursements_amount',
            'min_independent_expenditures',
            'max_independent_expenditures',
            'min_total_contributions',
            'report_type',
            'type',
            'sort_hide_null',
            'per_page',
            'max_debts_owed_expenditures',
            'max_total_contributions',
            'min_party_coordinated_expenditures',
            'page',
            'cycle',
            'is_amended',
            'max_cash_on_hand_end_period_amount',
            'max_party_coordinated_expenditures'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    ' to method committee_committee_id_reports_get' % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'api_key' is set
        if self.api_client.client_side_validation and ('api_key' not in local_var_params or  # noqa: E501
                                                        local_var_params['api_key'] is None):  # noqa: E501
            raise ApiValueError('Missing the required parameter `api_key` when calling `committee_committee_id_reports_get`')  # noqa: E501
        # verify the required parameter 'committee_id' is set
        if self.api_client.client_side_validation and ('committee_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['committee_id'] is None):  # noqa: E501
            raise ApiValueError('Missing the required parameter `committee_id` when calling `committee_committee_id_reports_get`')  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'committee_id' in local_var_params:
            path_params['committee_id'] = local_var_params['committee_id']  # noqa: E501

        query_params = []
        if 'min_cash_on_hand_end_period_amount' in local_var_params and local_var_params['min_cash_on_hand_end_period_amount'] is not None:  # noqa: E501
            query_params.append(('min_cash_on_hand_end_period_amount', local_var_params['min_cash_on_hand_end_period_amount']))  # noqa: E501
        if 'beginning_image_number' in local_var_params and local_var_params['beginning_image_number'] is not None:  # noqa: E501
            query_params.append(('beginning_image_number', local_var_params['beginning_image_number']))  # noqa: E501
            collection_formats['beginning_image_number'] = 'multi'  # noqa: E501
        if 'min_debts_owed_amount' in local_var_params and local_var_params['min_debts_owed_amount'] is not None:  # noqa: E501
            query_params.append(('min_debts_owed_amount', local_var_params['min_debts_owed_amount']))  # noqa: E501
        if 'year' in local_var_params and local_var_params['year'] is not None:  # noqa: E501
            query_params.append(('year', local_var_params['year']))  # noqa: E501
            collection_formats['year'] = 'multi'  # noqa: E501
        if 'min_disbursements_amount' in local_var_params and local_var_params['min_disbursements_amount'] is not None:  # noqa: E501
            query_params.append(('min_disbursements_amount', local_var_params['min_disbursements_amount']))  # noqa: E501
        if 'sort' in local_var_params and local_var_params['sort'] is not None:  # noqa: E501
            query_params.append(('sort', local_var_params['sort']))  # noqa: E501
            collection_formats['sort'] = 'multi'  # noqa: E501
        if 'candidate_id' in local_var_params and local_var_params['candidate_id'] is not None:  # noqa: E501
            query_params.append(('candidate_id', local_var_params['candidate_id']))  # noqa: E501
        if 'max_receipts_amount' in local_var_params and local_var_params['max_receipts_amount'] is not None:  # noqa: E501
            query_params.append(('max_receipts_amount', local_var_params['max_receipts_amount']))  # noqa: E501
        if 'api_key' in local_var_params and local_var_params['api_key'] is not None:  # noqa: E501
            query_params.append(('api_key', local_var_params['api_key']))  # noqa: E501
        if 'min_receipts_amount' in local_var_params and local_var_params['min_receipts_amount'] is not None:  # noqa: E501
            query_params.append(('min_receipts_amount', local_var_params['min_receipts_amount']))  # noqa: E501
        if 'sort_nulls_last' in local_var_params and local_var_params['sort_nulls_last'] is not None:  # noqa: E501
            query_params.append(('sort_nulls_last', local_var_params['sort_nulls_last']))  # noqa: E501
        if 'sort_null_only' in local_var_params and local_var_params['sort_null_only'] is not None:  # noqa: E501
            query_params.append(('sort_null_only', local_var_params['sort_null_only']))  # noqa: E501
        if 'max_disbursements_amount' in local_var_params and local_var_params['max_disbursements_amount'] is not None:  # noqa: E501
            query_params.append(('max_disbursements_amount', local_var_params['max_disbursements_amount']))  # noqa: E501
        if 'min_independent_expenditures' in local_var_params and local_var_params['min_independent_expenditures'] is not None:  # noqa: E501
            query_params.append(('min_independent_expenditures', local_var_params['min_independent_expenditures']))  # noqa: E501
        if 'max_independent_expenditures' in local_var_params and local_var_params['max_independent_expenditures'] is not None:  # noqa: E501
            query_params.append(('max_independent_expenditures', local_var_params['max_independent_expenditures']))  # noqa: E501
        if 'min_total_contributions' in local_var_params and local_var_params['min_total_contributions'] is not None:  # noqa: E501
            query_params.append(('min_total_contributions', local_var_params['min_total_contributions']))  # noqa: E501
        if 'report_type' in local_var_params and local_var_params['report_type'] is not None:  # noqa: E501
            query_params.append(('report_type', local_var_params['report_type']))  # noqa: E501
            collection_formats['report_type'] = 'multi'  # noqa: E501
        if 'type' in local_var_params and local_var_params['type'] is not None:  # noqa: E501
            query_params.append(('type', local_var_params['type']))  # noqa: E501
            collection_formats['type'] = 'multi'  # noqa: E501
        if 'sort_hide_null' in local_var_params and local_var_params['sort_hide_null'] is not None:  # noqa: E501
            query_params.append(('sort_hide_null', local_var_params['sort_hide_null']))  # noqa: E501
        if 'per_page' in local_var_params and local_var_params['per_page'] is not None:  # noqa: E501
            query_params.append(('per_page', local_var_params['per_page']))  # noqa: E501
        if 'max_debts_owed_expenditures' in local_var_params and local_var_params['max_debts_owed_expenditures'] is not None:  # noqa: E501
            query_params.append(('max_debts_owed_expenditures', local_var_params['max_debts_owed_expenditures']))  # noqa: E501
        if 'max_total_contributions' in local_var_params and local_var_params['max_total_contributions'] is not None:  # noqa: E501
            query_params.append(('max_total_contributions', local_var_params['max_total_contributions']))  # noqa: E501
        if 'min_party_coordinated_expenditures' in local_var_params and local_var_params['min_party_coordinated_expenditures'] is not None:  # noqa: E501
            query_params.append(('min_party_coordinated_expenditures', local_var_params['min_party_coordinated_expenditures']))  # noqa: E501
        if 'page' in local_var_params and local_var_params['page'] is not None:  # noqa: E501
            query_params.append(('page', local_var_params['page']))  # noqa: E501
        if 'cycle' in local_var_params and local_var_params['cycle'] is not None:  # noqa: E501
            query_params.append(('cycle', local_var_params['cycle']))  # noqa: E501
            collection_formats['cycle'] = 'multi'  # noqa: E501
        if 'is_amended' in local_var_params and local_var_params['is_amended'] is not None:  # noqa: E501
            query_params.append(('is_amended', local_var_params['is_amended']))  # noqa: E501
        if 'max_cash_on_hand_end_period_amount' in local_var_params and local_var_params['max_cash_on_hand_end_period_amount'] is not None:  # noqa: E501
            query_params.append(('max_cash_on_hand_end_period_amount', local_var_params['max_cash_on_hand_end_period_amount']))  # noqa: E501
        if 'max_party_coordinated_expenditures' in local_var_params and local_var_params['max_party_coordinated_expenditures'] is not None:  # noqa: E501
            query_params.append(('max_party_coordinated_expenditures', local_var_params['max_party_coordinated_expenditures']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyHeaderAuth', 'ApiKeyQueryAuth', 'apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/committee/{committee_id}/reports/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CommitteeReportsPage',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def committee_committee_id_totals_get(self, api_key, committee_id, **kwargs):  # noqa: E501
        """committee_committee_id_totals_get  # noqa: E501

         This endpoint provides information about a committee's Form 3, Form 3X, or Form 3P financial reports, which are aggregated by two-year period. We refer to two-year periods as a `cycle`.  The cycle is named after the even-numbered year and includes the year before it. To see totals from 2013 and 2014, you would use 2014. In odd-numbered years, the current cycle is the next year — for example, in 2015, the current cycle is 2016.  For presidential and Senate candidates, multiple two-year cycles exist between elections.  Parameter `full_election` is replaced by `election_full`. Please use `election_full` instead.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.committee_committee_id_totals_get(api_key, committee_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param str committee_id:  A unique identifier assigned to each committee or filer registered with the FEC. In general committee id's begin with the letter C which is followed by eight digits.  (required)
        :param str sort: Provide a field to sort by. Use `-` for descending order.
        :param str type: The one-letter type code of the organization:         - C communication cost         - D delegate         - E electioneering communication         - H House         - I independent expenditor (person or group)         - N PAC - nonqualified         - O independent expenditure-only (super PACs)         - P presidential         - Q PAC - qualified         - S Senate         - U single candidate independent expenditure         - V PAC with non-contribution account, nonqualified         - W PAC with non-contribution account, qualified         - X party, nonqualified         - Y party, qualified         - Z national party non-federal account
        :param bool sort_hide_null: Hide null values on sorted column(s).
        :param int per_page: The number of results returned per page. Defaults to 20.
        :param str designation: The one-letter designation code of the organization:          - A authorized by a candidate          - J joint fundraising committee          - P principal campaign committee of a candidate          - U unauthorized          - B lobbyist/registrant PAC          - D leadership PAC
        :param bool sort_nulls_last: Toggle that sorts null values last
        :param list[int] cycle:  Filter records to only those that were applicable to a given two-year period.The cycle begins with an odd year and is named for its ending, even year.
        :param int page: For paginating through results, starting at page 1
        :param bool sort_null_only: Toggle that filters out all rows having sort column that is non-null
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: CommitteeTotalsPage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.committee_committee_id_totals_get_with_http_info(api_key, committee_id, **kwargs)  # noqa: E501

    def committee_committee_id_totals_get_with_http_info(self, api_key, committee_id, **kwargs):  # noqa: E501
        """committee_committee_id_totals_get  # noqa: E501

         This endpoint provides information about a committee's Form 3, Form 3X, or Form 3P financial reports, which are aggregated by two-year period. We refer to two-year periods as a `cycle`.  The cycle is named after the even-numbered year and includes the year before it. To see totals from 2013 and 2014, you would use 2014. In odd-numbered years, the current cycle is the next year — for example, in 2015, the current cycle is 2016.  For presidential and Senate candidates, multiple two-year cycles exist between elections.  Parameter `full_election` is replaced by `election_full`. Please use `election_full` instead.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.committee_committee_id_totals_get_with_http_info(api_key, committee_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param str committee_id:  A unique identifier assigned to each committee or filer registered with the FEC. In general committee id's begin with the letter C which is followed by eight digits.  (required)
        :param str sort: Provide a field to sort by. Use `-` for descending order.
        :param str type: The one-letter type code of the organization:         - C communication cost         - D delegate         - E electioneering communication         - H House         - I independent expenditor (person or group)         - N PAC - nonqualified         - O independent expenditure-only (super PACs)         - P presidential         - Q PAC - qualified         - S Senate         - U single candidate independent expenditure         - V PAC with non-contribution account, nonqualified         - W PAC with non-contribution account, qualified         - X party, nonqualified         - Y party, qualified         - Z national party non-federal account
        :param bool sort_hide_null: Hide null values on sorted column(s).
        :param int per_page: The number of results returned per page. Defaults to 20.
        :param str designation: The one-letter designation code of the organization:          - A authorized by a candidate          - J joint fundraising committee          - P principal campaign committee of a candidate          - U unauthorized          - B lobbyist/registrant PAC          - D leadership PAC
        :param bool sort_nulls_last: Toggle that sorts null values last
        :param list[int] cycle:  Filter records to only those that were applicable to a given two-year period.The cycle begins with an odd year and is named for its ending, even year.
        :param int page: For paginating through results, starting at page 1
        :param bool sort_null_only: Toggle that filters out all rows having sort column that is non-null
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(CommitteeTotalsPage, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'api_key',
            'committee_id',
            'sort',
            'type',
            'sort_hide_null',
            'per_page',
            'designation',
            'sort_nulls_last',
            'cycle',
            'page',
            'sort_null_only'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    ' to method committee_committee_id_totals_get' % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'api_key' is set
        if self.api_client.client_side_validation and ('api_key' not in local_var_params or  # noqa: E501
                                                        local_var_params['api_key'] is None):  # noqa: E501
            raise ApiValueError('Missing the required parameter `api_key` when calling `committee_committee_id_totals_get`')  # noqa: E501
        # verify the required parameter 'committee_id' is set
        if self.api_client.client_side_validation and ('committee_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['committee_id'] is None):  # noqa: E501
            raise ApiValueError('Missing the required parameter `committee_id` when calling `committee_committee_id_totals_get`')  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'committee_id' in local_var_params:
            path_params['committee_id'] = local_var_params['committee_id']  # noqa: E501

        query_params = []
        if 'api_key' in local_var_params and local_var_params['api_key'] is not None:  # noqa: E501
            query_params.append(('api_key', local_var_params['api_key']))  # noqa: E501
        if 'sort' in local_var_params and local_var_params['sort'] is not None:  # noqa: E501
            query_params.append(('sort', local_var_params['sort']))  # noqa: E501
        if 'type' in local_var_params and local_var_params['type'] is not None:  # noqa: E501
            query_params.append(('type', local_var_params['type']))  # noqa: E501
        if 'sort_hide_null' in local_var_params and local_var_params['sort_hide_null'] is not None:  # noqa: E501
            query_params.append(('sort_hide_null', local_var_params['sort_hide_null']))  # noqa: E501
        if 'per_page' in local_var_params and local_var_params['per_page'] is not None:  # noqa: E501
            query_params.append(('per_page', local_var_params['per_page']))  # noqa: E501
        if 'designation' in local_var_params and local_var_params['designation'] is not None:  # noqa: E501
            query_params.append(('designation', local_var_params['designation']))  # noqa: E501
        if 'sort_nulls_last' in local_var_params and local_var_params['sort_nulls_last'] is not None:  # noqa: E501
            query_params.append(('sort_nulls_last', local_var_params['sort_nulls_last']))  # noqa: E501
        if 'cycle' in local_var_params and local_var_params['cycle'] is not None:  # noqa: E501
            query_params.append(('cycle', local_var_params['cycle']))  # noqa: E501
            collection_formats['cycle'] = 'multi'  # noqa: E501
        if 'page' in local_var_params and local_var_params['page'] is not None:  # noqa: E501
            query_params.append(('page', local_var_params['page']))  # noqa: E501
        if 'sort_null_only' in local_var_params and local_var_params['sort_null_only'] is not None:  # noqa: E501
            query_params.append(('sort_null_only', local_var_params['sort_null_only']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyHeaderAuth', 'ApiKeyQueryAuth', 'apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/committee/{committee_id}/totals/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CommitteeTotalsPage',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def elections_get(self, api_key, cycle, office, **kwargs):  # noqa: E501
        """elections_get  # noqa: E501

         Look at the top-level financial information for all candidates running for the same office.  Choose a 2-year cycle, and `house`, `senate` or `presidential`.  If you are looking for a Senate seat, you will need to select the state using a two-letter abbreviation.  House races require state and a two-digit district number.  Since this endpoint reflects financial information, it will only have candidates once they file financial reporting forms. Query the `/candidates` endpoint to see an up to date list of all the candidates that filed to run for a particular seat.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.elections_get(api_key, cycle, office, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param int cycle:  Two-year election cycle in which a candidate runs for office. Calculated from FEC Form 2. The cycle begins with an odd year and is named for its ending, even year. This cycle follows the traditional house election cycle and subdivides the presidential and Senate elections into comparable two-year blocks. To see data for the entire four years of a presidential term or six years of a senatorial term, you will need the `election_full` flag.  (required)
        :param str office: Federal office candidate runs for: H, S or P (required)
        :param bool election_full: `True` indicates that full election period of a candidate. `False` indicates that two year election cycle.
        :param str sort: Provide a field to sort by. Use `-` for descending order.
        :param str state: US state or territory where a candidate runs for office
        :param bool sort_hide_null: Hide null values on sorted column(s).
        :param int per_page: The number of results returned per page. Defaults to 20.
        :param str district: Two-digit US House distirict of the office the candidate is running for. Presidential, Senate and House at-large candidates will have District 00.
        :param bool sort_nulls_last: Toggle that sorts null values last
        :param int page: For paginating through results, starting at page 1
        :param bool sort_null_only: Toggle that filters out all rows having sort column that is non-null
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ElectionPage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.elections_get_with_http_info(api_key, cycle, office, **kwargs)  # noqa: E501

    def elections_get_with_http_info(self, api_key, cycle, office, **kwargs):  # noqa: E501
        """elections_get  # noqa: E501

         Look at the top-level financial information for all candidates running for the same office.  Choose a 2-year cycle, and `house`, `senate` or `presidential`.  If you are looking for a Senate seat, you will need to select the state using a two-letter abbreviation.  House races require state and a two-digit district number.  Since this endpoint reflects financial information, it will only have candidates once they file financial reporting forms. Query the `/candidates` endpoint to see an up to date list of all the candidates that filed to run for a particular seat.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.elections_get_with_http_info(api_key, cycle, office, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param int cycle:  Two-year election cycle in which a candidate runs for office. Calculated from FEC Form 2. The cycle begins with an odd year and is named for its ending, even year. This cycle follows the traditional house election cycle and subdivides the presidential and Senate elections into comparable two-year blocks. To see data for the entire four years of a presidential term or six years of a senatorial term, you will need the `election_full` flag.  (required)
        :param str office: Federal office candidate runs for: H, S or P (required)
        :param bool election_full: `True` indicates that full election period of a candidate. `False` indicates that two year election cycle.
        :param str sort: Provide a field to sort by. Use `-` for descending order.
        :param str state: US state or territory where a candidate runs for office
        :param bool sort_hide_null: Hide null values on sorted column(s).
        :param int per_page: The number of results returned per page. Defaults to 20.
        :param str district: Two-digit US House distirict of the office the candidate is running for. Presidential, Senate and House at-large candidates will have District 00.
        :param bool sort_nulls_last: Toggle that sorts null values last
        :param int page: For paginating through results, starting at page 1
        :param bool sort_null_only: Toggle that filters out all rows having sort column that is non-null
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ElectionPage, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'api_key',
            'cycle',
            'office',
            'election_full',
            'sort',
            'state',
            'sort_hide_null',
            'per_page',
            'district',
            'sort_nulls_last',
            'page',
            'sort_null_only'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    ' to method elections_get' % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'api_key' is set
        if self.api_client.client_side_validation and ('api_key' not in local_var_params or  # noqa: E501
                                                        local_var_params['api_key'] is None):  # noqa: E501
            raise ApiValueError('Missing the required parameter `api_key` when calling `elections_get`')  # noqa: E501
        # verify the required parameter 'cycle' is set
        if self.api_client.client_side_validation and ('cycle' not in local_var_params or  # noqa: E501
                                                        local_var_params['cycle'] is None):  # noqa: E501
            raise ApiValueError('Missing the required parameter `cycle` when calling `elections_get`')  # noqa: E501
        # verify the required parameter 'office' is set
        if self.api_client.client_side_validation and ('office' not in local_var_params or  # noqa: E501
                                                        local_var_params['office'] is None):  # noqa: E501
            raise ApiValueError('Missing the required parameter `office` when calling `elections_get`')  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'election_full' in local_var_params and local_var_params['election_full'] is not None:  # noqa: E501
            query_params.append(('election_full', local_var_params['election_full']))  # noqa: E501
        if 'api_key' in local_var_params and local_var_params['api_key'] is not None:  # noqa: E501
            query_params.append(('api_key', local_var_params['api_key']))  # noqa: E501
        if 'sort' in local_var_params and local_var_params['sort'] is not None:  # noqa: E501
            query_params.append(('sort', local_var_params['sort']))  # noqa: E501
        if 'state' in local_var_params and local_var_params['state'] is not None:  # noqa: E501
            query_params.append(('state', local_var_params['state']))  # noqa: E501
        if 'sort_hide_null' in local_var_params and local_var_params['sort_hide_null'] is not None:  # noqa: E501
            query_params.append(('sort_hide_null', local_var_params['sort_hide_null']))  # noqa: E501
        if 'per_page' in local_var_params and local_var_params['per_page'] is not None:  # noqa: E501
            query_params.append(('per_page', local_var_params['per_page']))  # noqa: E501
        if 'district' in local_var_params and local_var_params['district'] is not None:  # noqa: E501
            query_params.append(('district', local_var_params['district']))  # noqa: E501
        if 'sort_nulls_last' in local_var_params and local_var_params['sort_nulls_last'] is not None:  # noqa: E501
            query_params.append(('sort_nulls_last', local_var_params['sort_nulls_last']))  # noqa: E501
        if 'cycle' in local_var_params and local_var_params['cycle'] is not None:  # noqa: E501
            query_params.append(('cycle', local_var_params['cycle']))  # noqa: E501
        if 'page' in local_var_params and local_var_params['page'] is not None:  # noqa: E501
            query_params.append(('page', local_var_params['page']))  # noqa: E501
        if 'sort_null_only' in local_var_params and local_var_params['sort_null_only'] is not None:  # noqa: E501
            query_params.append(('sort_null_only', local_var_params['sort_null_only']))  # noqa: E501
        if 'office' in local_var_params and local_var_params['office'] is not None:  # noqa: E501
            query_params.append(('office', local_var_params['office']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyHeaderAuth', 'ApiKeyQueryAuth', 'apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/elections/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ElectionPage',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def elections_search_get(self, api_key, **kwargs):  # noqa: E501
        """elections_search_get  # noqa: E501

         List elections by cycle, office, state, and district.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.elections_search_get(api_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param list[int] zip: Zip code
        :param list[str] sort: Provide a field to sort by. Use - for descending order.
        :param list[str] state: US state or territory where a candidate runs for office
        :param bool sort_hide_null: Hide null values on sorted column(s).
        :param int per_page: The number of results returned per page. Defaults to 20.
        :param bool sort_nulls_last: Toggle that sorts null values last
        :param list[str] district: Two-digit US House distirict of the office the candidate is running for. Presidential, Senate and House at-large candidates will have District 00.
        :param list[int] cycle:  Two-year election cycle in which a candidate runs for office. Calculated from FEC Form 2. The cycle begins with an odd year and is named for its ending, even year. This cycle follows the traditional house election cycle and subdivides the presidential and Senate elections into comparable two-year blocks. To see data for the entire four years of a presidential term or six years of a senatorial term, you will need the `election_full` flag.
        :param int page: For paginating through results, starting at page 1
        :param bool sort_null_only: Toggle that filters out all rows having sort column that is non-null
        :param list[str] office:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ElectionsListPage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.elections_search_get_with_http_info(api_key, **kwargs)  # noqa: E501

    def elections_search_get_with_http_info(self, api_key, **kwargs):  # noqa: E501
        """elections_search_get  # noqa: E501

         List elections by cycle, office, state, and district.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.elections_search_get_with_http_info(api_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param list[int] zip: Zip code
        :param list[str] sort: Provide a field to sort by. Use - for descending order.
        :param list[str] state: US state or territory where a candidate runs for office
        :param bool sort_hide_null: Hide null values on sorted column(s).
        :param int per_page: The number of results returned per page. Defaults to 20.
        :param bool sort_nulls_last: Toggle that sorts null values last
        :param list[str] district: Two-digit US House distirict of the office the candidate is running for. Presidential, Senate and House at-large candidates will have District 00.
        :param list[int] cycle:  Two-year election cycle in which a candidate runs for office. Calculated from FEC Form 2. The cycle begins with an odd year and is named for its ending, even year. This cycle follows the traditional house election cycle and subdivides the presidential and Senate elections into comparable two-year blocks. To see data for the entire four years of a presidential term or six years of a senatorial term, you will need the `election_full` flag.
        :param int page: For paginating through results, starting at page 1
        :param bool sort_null_only: Toggle that filters out all rows having sort column that is non-null
        :param list[str] office:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ElectionsListPage, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'api_key',
            'zip',
            'sort',
            'state',
            'sort_hide_null',
            'per_page',
            'sort_nulls_last',
            'district',
            'cycle',
            'page',
            'sort_null_only',
            'office'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    ' to method elections_search_get' % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'api_key' is set
        if self.api_client.client_side_validation and ('api_key' not in local_var_params or  # noqa: E501
                                                        local_var_params['api_key'] is None):  # noqa: E501
            raise ApiValueError('Missing the required parameter `api_key` when calling `elections_search_get`')  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'zip' in local_var_params and local_var_params['zip'] is not None:  # noqa: E501
            query_params.append(('zip', local_var_params['zip']))  # noqa: E501
            collection_formats['zip'] = 'multi'  # noqa: E501
        if 'api_key' in local_var_params and local_var_params['api_key'] is not None:  # noqa: E501
            query_params.append(('api_key', local_var_params['api_key']))  # noqa: E501
        if 'sort' in local_var_params and local_var_params['sort'] is not None:  # noqa: E501
            query_params.append(('sort', local_var_params['sort']))  # noqa: E501
            collection_formats['sort'] = 'multi'  # noqa: E501
        if 'state' in local_var_params and local_var_params['state'] is not None:  # noqa: E501
            query_params.append(('state', local_var_params['state']))  # noqa: E501
            collection_formats['state'] = 'multi'  # noqa: E501
        if 'sort_hide_null' in local_var_params and local_var_params['sort_hide_null'] is not None:  # noqa: E501
            query_params.append(('sort_hide_null', local_var_params['sort_hide_null']))  # noqa: E501
        if 'per_page' in local_var_params and local_var_params['per_page'] is not None:  # noqa: E501
            query_params.append(('per_page', local_var_params['per_page']))  # noqa: E501
        if 'sort_nulls_last' in local_var_params and local_var_params['sort_nulls_last'] is not None:  # noqa: E501
            query_params.append(('sort_nulls_last', local_var_params['sort_nulls_last']))  # noqa: E501
        if 'district' in local_var_params and local_var_params['district'] is not None:  # noqa: E501
            query_params.append(('district', local_var_params['district']))  # noqa: E501
            collection_formats['district'] = 'multi'  # noqa: E501
        if 'cycle' in local_var_params and local_var_params['cycle'] is not None:  # noqa: E501
            query_params.append(('cycle', local_var_params['cycle']))  # noqa: E501
            collection_formats['cycle'] = 'multi'  # noqa: E501
        if 'page' in local_var_params and local_var_params['page'] is not None:  # noqa: E501
            query_params.append(('page', local_var_params['page']))  # noqa: E501
        if 'sort_null_only' in local_var_params and local_var_params['sort_null_only'] is not None:  # noqa: E501
            query_params.append(('sort_null_only', local_var_params['sort_null_only']))  # noqa: E501
        if 'office' in local_var_params and local_var_params['office'] is not None:  # noqa: E501
            query_params.append(('office', local_var_params['office']))  # noqa: E501
            collection_formats['office'] = 'multi'  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyHeaderAuth', 'ApiKeyQueryAuth', 'apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/elections/search/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ElectionsListPage',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def elections_summary_get(self, cycle, api_key, office, **kwargs):  # noqa: E501
        """elections_summary_get  # noqa: E501

         List elections by cycle, office, state, and district.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.elections_summary_get(cycle, api_key, office, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int cycle:  Two-year election cycle in which a candidate runs for office. Calculated from FEC Form 2. The cycle begins with an odd year and is named for its ending, even year. This cycle follows the traditional house election cycle and subdivides the presidential and Senate elections into comparable two-year blocks. To see data for the entire four years of a presidential term or six years of a senatorial term, you will need the `election_full` flag.  (required)
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param str office: Federal office candidate runs for: H, S or P (required)
        :param str district: Two-digit US House distirict of the office the candidate is running for. Presidential, Senate and House at-large candidates will have District 00.
        :param bool election_full: `True` indicates that full election period of a candidate. `False` indicates that two year election cycle.
        :param str state: US state or territory where a candidate runs for office
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ElectionSummary
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.elections_summary_get_with_http_info(cycle, api_key, office, **kwargs)  # noqa: E501

    def elections_summary_get_with_http_info(self, cycle, api_key, office, **kwargs):  # noqa: E501
        """elections_summary_get  # noqa: E501

         List elections by cycle, office, state, and district.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.elections_summary_get_with_http_info(cycle, api_key, office, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int cycle:  Two-year election cycle in which a candidate runs for office. Calculated from FEC Form 2. The cycle begins with an odd year and is named for its ending, even year. This cycle follows the traditional house election cycle and subdivides the presidential and Senate elections into comparable two-year blocks. To see data for the entire four years of a presidential term or six years of a senatorial term, you will need the `election_full` flag.  (required)
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param str office: Federal office candidate runs for: H, S or P (required)
        :param str district: Two-digit US House distirict of the office the candidate is running for. Presidential, Senate and House at-large candidates will have District 00.
        :param bool election_full: `True` indicates that full election period of a candidate. `False` indicates that two year election cycle.
        :param str state: US state or territory where a candidate runs for office
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ElectionSummary, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'cycle',
            'api_key',
            'office',
            'district',
            'election_full',
            'state'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    ' to method elections_summary_get' % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'cycle' is set
        if self.api_client.client_side_validation and ('cycle' not in local_var_params or  # noqa: E501
                                                        local_var_params['cycle'] is None):  # noqa: E501
            raise ApiValueError('Missing the required parameter `cycle` when calling `elections_summary_get`')  # noqa: E501
        # verify the required parameter 'api_key' is set
        if self.api_client.client_side_validation and ('api_key' not in local_var_params or  # noqa: E501
                                                        local_var_params['api_key'] is None):  # noqa: E501
            raise ApiValueError('Missing the required parameter `api_key` when calling `elections_summary_get`')  # noqa: E501
        # verify the required parameter 'office' is set
        if self.api_client.client_side_validation and ('office' not in local_var_params or  # noqa: E501
                                                        local_var_params['office'] is None):  # noqa: E501
            raise ApiValueError('Missing the required parameter `office` when calling `elections_summary_get`')  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'district' in local_var_params and local_var_params['district'] is not None:  # noqa: E501
            query_params.append(('district', local_var_params['district']))  # noqa: E501
        if 'election_full' in local_var_params and local_var_params['election_full'] is not None:  # noqa: E501
            query_params.append(('election_full', local_var_params['election_full']))  # noqa: E501
        if 'cycle' in local_var_params and local_var_params['cycle'] is not None:  # noqa: E501
            query_params.append(('cycle', local_var_params['cycle']))  # noqa: E501
        if 'api_key' in local_var_params and local_var_params['api_key'] is not None:  # noqa: E501
            query_params.append(('api_key', local_var_params['api_key']))  # noqa: E501
        if 'state' in local_var_params and local_var_params['state'] is not None:  # noqa: E501
            query_params.append(('state', local_var_params['state']))  # noqa: E501
        if 'office' in local_var_params and local_var_params['office'] is not None:  # noqa: E501
            query_params.append(('office', local_var_params['office']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyHeaderAuth', 'ApiKeyQueryAuth', 'apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/elections/summary/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ElectionSummary',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def reports_committee_type_get(self, api_key, committee_type, **kwargs):  # noqa: E501
        """reports_committee_type_get  # noqa: E501

         Each report represents the summary information from FEC Form 3, Form 3X and Form 3P. These reports have key statistics that illuminate the financial status of a given committee. Things like cash on hand, debts owed by committee, total receipts, and total disbursements are especially helpful for understanding a committee's financial dealings.  By default, this endpoint includes both amended and final versions of each report. To restrict to only the final versions of each report, use `is_amended=false`; to view only reports that have been amended, use `is_amended=true`.  Several different reporting structures exist, depending on the type of organization that submits financial information. To see an example of these reporting requirements, look at the summary and detailed summary pages of FEC Form 3, Form 3X, and Form 3P.  DISCLAIMER: The field labels contained within this resource are subject to change.  We are attempting to succinctly label these fields while conveying clear meaning to ensure accessibility for all users.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.reports_committee_type_get(api_key, committee_type, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param str committee_type: House, Senate, presidential, independent expenditure only (required)
        :param str min_cash_on_hand_end_period_amount:  Filter for all amounts greater than a value.
        :param list[str] beginning_image_number:  Unique identifier for the electronic or paper report. This number is used to construct PDF URLs to the original document.
        :param str min_debts_owed_amount:  Filter for all amounts greater than a value.
        :param list[str] sort: Provide a field to sort by. Use - for descending order.
        :param str candidate_id:  A unique identifier assigned to each candidate registered with the FEC. If a person runs for several offices, that person will have separate candidate IDs for each office.
        :param str max_receipts_amount:  Filter for all amounts less than a value.
        :param str max_party_coordinated_expenditures:  Filter for all amounts less than a value.
        :param str filer_type: The method used to file with the FEC, either electronic or on paper.
        :param str max_disbursements_amount:  Filter for all amounts less than a value.
        :param str max_independent_expenditures:  Filter for all amounts less than a value.
        :param bool most_recent:  Report is either new or is the most-recently filed amendment
        :param date max_receipt_date:  Selects all items received by FEC before this date(MM/DD/YYYY or YYYY-MM-DD)
        :param date min_receipt_date:  Selects all items received by FEC after this date(MM/DD/YYYY or YYYY-MM-DD)
        :param str max_debts_owed_expenditures:  Filter for all amounts less than a value.
        :param str max_total_contributions:  Filter for all amounts less than a value.
        :param str min_party_coordinated_expenditures:  Filter for all amounts greater than a value.
        :param int page: For paginating through results, starting at page 1
        :param list[str] committee_id:  A unique identifier assigned to each committee or filer registered with the FEC. In general committee id's begin with the letter C which is followed by eight digits.
        :param str max_cash_on_hand_end_period_amount:  Filter for all amounts less than a value.
        :param list[int] year:  Forms with coverage date -      year from the coverage ending date. Forms without coverage date -      year from the receipt date.
        :param str min_disbursements_amount:  Filter for all amounts greater than a value.
        :param list[str] amendment_indicator: Amendent types:     -N   new     -A   amendment     -T   terminated     -C   consolidated     -M   multi-candidate     -S   secondary  NULL might be new or amendment. If amendment indicator is null and the filings is the first or first in a chain treat it as if it was a new. If it is not the first or first in a chain then treat the filing as an amendment.
        :param str min_receipts_amount:  Filter for all amounts greater than a value.
        :param bool sort_nulls_last: Toggle that sorts null values last
        :param bool sort_null_only: Toggle that filters out all rows having sort column that is non-null
        :param str min_independent_expenditures:  Filter for all amounts greater than a value.
        :param str min_total_contributions:  Filter for all amounts greater than a value.
        :param list[str] type: The one-letter type code of the organization:         - C communication cost         - D delegate         - E electioneering communication         - H House         - I independent expenditor (person or group)         - N PAC - nonqualified         - O independent expenditure-only (super PACs)         - P presidential         - Q PAC - qualified         - S Senate         - U single candidate independent expenditure         - V PAC with non-contribution account, nonqualified         - W PAC with non-contribution account, qualified         - X party, nonqualified         - Y party, qualified         - Z national party non-federal account
        :param bool sort_hide_null: Hide null values on sorted column(s).
        :param int per_page: The number of results returned per page. Defaults to 20.
        :param list[int] cycle:  Filter records to only those that were applicable to a given two-year period.The cycle begins with an odd year and is named for its ending, even year.
        :param bool is_amended:  False indicates that a report is the most recent. True indicates that the report has been superseded by an amendment.
        :param list[str] report_type: Report type; prefix with \"-\" to exclude. Name of report where the underlying data comes from:     - 10D Pre-Election     - 10G Pre-General     - 10P Pre-Primary     - 10R Pre-Run-Off     - 10S Pre-Special     - 12C Pre-Convention     - 12G Pre-General     - 12P Pre-Primary     - 12R Pre-Run-Off     - 12S Pre-Special     - 30D Post-Election     - 30G Post-General     - 30P Post-Primary     - 30R Post-Run-Off     - 30S Post-Special     - 60D Post-Convention     - M1  January Monthly     - M10 October Monthly     - M11 November Monthly     - M12 December Monthly     - M2  February Monthly     - M3  March Monthly     - M4  April Monthly     - M5  May Monthly     - M6  June Monthly     - M7  July Monthly     - M8  August Monthly     - M9  September Monthly     - MY  Mid-Year Report     - Q1  April Quarterly     - Q2  July Quarterly     - Q3  October Quarterly     - TER Termination Report     - YE  Year-End     - ADJ COMP ADJUST AMEND     - CA  COMPREHENSIVE AMEND
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: CommitteeReportsPage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.reports_committee_type_get_with_http_info(api_key, committee_type, **kwargs)  # noqa: E501

    def reports_committee_type_get_with_http_info(self, api_key, committee_type, **kwargs):  # noqa: E501
        """reports_committee_type_get  # noqa: E501

         Each report represents the summary information from FEC Form 3, Form 3X and Form 3P. These reports have key statistics that illuminate the financial status of a given committee. Things like cash on hand, debts owed by committee, total receipts, and total disbursements are especially helpful for understanding a committee's financial dealings.  By default, this endpoint includes both amended and final versions of each report. To restrict to only the final versions of each report, use `is_amended=false`; to view only reports that have been amended, use `is_amended=true`.  Several different reporting structures exist, depending on the type of organization that submits financial information. To see an example of these reporting requirements, look at the summary and detailed summary pages of FEC Form 3, Form 3X, and Form 3P.  DISCLAIMER: The field labels contained within this resource are subject to change.  We are attempting to succinctly label these fields while conveying clear meaning to ensure accessibility for all users.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.reports_committee_type_get_with_http_info(api_key, committee_type, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param str committee_type: House, Senate, presidential, independent expenditure only (required)
        :param str min_cash_on_hand_end_period_amount:  Filter for all amounts greater than a value.
        :param list[str] beginning_image_number:  Unique identifier for the electronic or paper report. This number is used to construct PDF URLs to the original document.
        :param str min_debts_owed_amount:  Filter for all amounts greater than a value.
        :param list[str] sort: Provide a field to sort by. Use - for descending order.
        :param str candidate_id:  A unique identifier assigned to each candidate registered with the FEC. If a person runs for several offices, that person will have separate candidate IDs for each office.
        :param str max_receipts_amount:  Filter for all amounts less than a value.
        :param str max_party_coordinated_expenditures:  Filter for all amounts less than a value.
        :param str filer_type: The method used to file with the FEC, either electronic or on paper.
        :param str max_disbursements_amount:  Filter for all amounts less than a value.
        :param str max_independent_expenditures:  Filter for all amounts less than a value.
        :param bool most_recent:  Report is either new or is the most-recently filed amendment
        :param date max_receipt_date:  Selects all items received by FEC before this date(MM/DD/YYYY or YYYY-MM-DD)
        :param date min_receipt_date:  Selects all items received by FEC after this date(MM/DD/YYYY or YYYY-MM-DD)
        :param str max_debts_owed_expenditures:  Filter for all amounts less than a value.
        :param str max_total_contributions:  Filter for all amounts less than a value.
        :param str min_party_coordinated_expenditures:  Filter for all amounts greater than a value.
        :param int page: For paginating through results, starting at page 1
        :param list[str] committee_id:  A unique identifier assigned to each committee or filer registered with the FEC. In general committee id's begin with the letter C which is followed by eight digits.
        :param str max_cash_on_hand_end_period_amount:  Filter for all amounts less than a value.
        :param list[int] year:  Forms with coverage date -      year from the coverage ending date. Forms without coverage date -      year from the receipt date.
        :param str min_disbursements_amount:  Filter for all amounts greater than a value.
        :param list[str] amendment_indicator: Amendent types:     -N   new     -A   amendment     -T   terminated     -C   consolidated     -M   multi-candidate     -S   secondary  NULL might be new or amendment. If amendment indicator is null and the filings is the first or first in a chain treat it as if it was a new. If it is not the first or first in a chain then treat the filing as an amendment.
        :param str min_receipts_amount:  Filter for all amounts greater than a value.
        :param bool sort_nulls_last: Toggle that sorts null values last
        :param bool sort_null_only: Toggle that filters out all rows having sort column that is non-null
        :param str min_independent_expenditures:  Filter for all amounts greater than a value.
        :param str min_total_contributions:  Filter for all amounts greater than a value.
        :param list[str] type: The one-letter type code of the organization:         - C communication cost         - D delegate         - E electioneering communication         - H House         - I independent expenditor (person or group)         - N PAC - nonqualified         - O independent expenditure-only (super PACs)         - P presidential         - Q PAC - qualified         - S Senate         - U single candidate independent expenditure         - V PAC with non-contribution account, nonqualified         - W PAC with non-contribution account, qualified         - X party, nonqualified         - Y party, qualified         - Z national party non-federal account
        :param bool sort_hide_null: Hide null values on sorted column(s).
        :param int per_page: The number of results returned per page. Defaults to 20.
        :param list[int] cycle:  Filter records to only those that were applicable to a given two-year period.The cycle begins with an odd year and is named for its ending, even year.
        :param bool is_amended:  False indicates that a report is the most recent. True indicates that the report has been superseded by an amendment.
        :param list[str] report_type: Report type; prefix with \"-\" to exclude. Name of report where the underlying data comes from:     - 10D Pre-Election     - 10G Pre-General     - 10P Pre-Primary     - 10R Pre-Run-Off     - 10S Pre-Special     - 12C Pre-Convention     - 12G Pre-General     - 12P Pre-Primary     - 12R Pre-Run-Off     - 12S Pre-Special     - 30D Post-Election     - 30G Post-General     - 30P Post-Primary     - 30R Post-Run-Off     - 30S Post-Special     - 60D Post-Convention     - M1  January Monthly     - M10 October Monthly     - M11 November Monthly     - M12 December Monthly     - M2  February Monthly     - M3  March Monthly     - M4  April Monthly     - M5  May Monthly     - M6  June Monthly     - M7  July Monthly     - M8  August Monthly     - M9  September Monthly     - MY  Mid-Year Report     - Q1  April Quarterly     - Q2  July Quarterly     - Q3  October Quarterly     - TER Termination Report     - YE  Year-End     - ADJ COMP ADJUST AMEND     - CA  COMPREHENSIVE AMEND
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(CommitteeReportsPage, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'api_key',
            'committee_type',
            'min_cash_on_hand_end_period_amount',
            'beginning_image_number',
            'min_debts_owed_amount',
            'sort',
            'candidate_id',
            'max_receipts_amount',
            'max_party_coordinated_expenditures',
            'filer_type',
            'max_disbursements_amount',
            'max_independent_expenditures',
            'most_recent',
            'max_receipt_date',
            'min_receipt_date',
            'max_debts_owed_expenditures',
            'max_total_contributions',
            'min_party_coordinated_expenditures',
            'page',
            'committee_id',
            'max_cash_on_hand_end_period_amount',
            'year',
            'min_disbursements_amount',
            'amendment_indicator',
            'min_receipts_amount',
            'sort_nulls_last',
            'sort_null_only',
            'min_independent_expenditures',
            'min_total_contributions',
            'type',
            'sort_hide_null',
            'per_page',
            'cycle',
            'is_amended',
            'report_type'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    ' to method reports_committee_type_get' % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'api_key' is set
        if self.api_client.client_side_validation and ('api_key' not in local_var_params or  # noqa: E501
                                                        local_var_params['api_key'] is None):  # noqa: E501
            raise ApiValueError('Missing the required parameter `api_key` when calling `reports_committee_type_get`')  # noqa: E501
        # verify the required parameter 'committee_type' is set
        if self.api_client.client_side_validation and ('committee_type' not in local_var_params or  # noqa: E501
                                                        local_var_params['committee_type'] is None):  # noqa: E501
            raise ApiValueError('Missing the required parameter `committee_type` when calling `reports_committee_type_get`')  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'committee_type' in local_var_params:
            path_params['committee_type'] = local_var_params['committee_type']  # noqa: E501

        query_params = []
        if 'min_cash_on_hand_end_period_amount' in local_var_params and local_var_params['min_cash_on_hand_end_period_amount'] is not None:  # noqa: E501
            query_params.append(('min_cash_on_hand_end_period_amount', local_var_params['min_cash_on_hand_end_period_amount']))  # noqa: E501
        if 'beginning_image_number' in local_var_params and local_var_params['beginning_image_number'] is not None:  # noqa: E501
            query_params.append(('beginning_image_number', local_var_params['beginning_image_number']))  # noqa: E501
            collection_formats['beginning_image_number'] = 'multi'  # noqa: E501
        if 'min_debts_owed_amount' in local_var_params and local_var_params['min_debts_owed_amount'] is not None:  # noqa: E501
            query_params.append(('min_debts_owed_amount', local_var_params['min_debts_owed_amount']))  # noqa: E501
        if 'sort' in local_var_params and local_var_params['sort'] is not None:  # noqa: E501
            query_params.append(('sort', local_var_params['sort']))  # noqa: E501
            collection_formats['sort'] = 'multi'  # noqa: E501
        if 'candidate_id' in local_var_params and local_var_params['candidate_id'] is not None:  # noqa: E501
            query_params.append(('candidate_id', local_var_params['candidate_id']))  # noqa: E501
        if 'max_receipts_amount' in local_var_params and local_var_params['max_receipts_amount'] is not None:  # noqa: E501
            query_params.append(('max_receipts_amount', local_var_params['max_receipts_amount']))  # noqa: E501
        if 'max_party_coordinated_expenditures' in local_var_params and local_var_params['max_party_coordinated_expenditures'] is not None:  # noqa: E501
            query_params.append(('max_party_coordinated_expenditures', local_var_params['max_party_coordinated_expenditures']))  # noqa: E501
        if 'filer_type' in local_var_params and local_var_params['filer_type'] is not None:  # noqa: E501
            query_params.append(('filer_type', local_var_params['filer_type']))  # noqa: E501
        if 'max_disbursements_amount' in local_var_params and local_var_params['max_disbursements_amount'] is not None:  # noqa: E501
            query_params.append(('max_disbursements_amount', local_var_params['max_disbursements_amount']))  # noqa: E501
        if 'max_independent_expenditures' in local_var_params and local_var_params['max_independent_expenditures'] is not None:  # noqa: E501
            query_params.append(('max_independent_expenditures', local_var_params['max_independent_expenditures']))  # noqa: E501
        if 'most_recent' in local_var_params and local_var_params['most_recent'] is not None:  # noqa: E501
            query_params.append(('most_recent', local_var_params['most_recent']))  # noqa: E501
        if 'max_receipt_date' in local_var_params and local_var_params['max_receipt_date'] is not None:  # noqa: E501
            query_params.append(('max_receipt_date', local_var_params['max_receipt_date']))  # noqa: E501
        if 'min_receipt_date' in local_var_params and local_var_params['min_receipt_date'] is not None:  # noqa: E501
            query_params.append(('min_receipt_date', local_var_params['min_receipt_date']))  # noqa: E501
        if 'max_debts_owed_expenditures' in local_var_params and local_var_params['max_debts_owed_expenditures'] is not None:  # noqa: E501
            query_params.append(('max_debts_owed_expenditures', local_var_params['max_debts_owed_expenditures']))  # noqa: E501
        if 'max_total_contributions' in local_var_params and local_var_params['max_total_contributions'] is not None:  # noqa: E501
            query_params.append(('max_total_contributions', local_var_params['max_total_contributions']))  # noqa: E501
        if 'min_party_coordinated_expenditures' in local_var_params and local_var_params['min_party_coordinated_expenditures'] is not None:  # noqa: E501
            query_params.append(('min_party_coordinated_expenditures', local_var_params['min_party_coordinated_expenditures']))  # noqa: E501
        if 'page' in local_var_params and local_var_params['page'] is not None:  # noqa: E501
            query_params.append(('page', local_var_params['page']))  # noqa: E501
        if 'committee_id' in local_var_params and local_var_params['committee_id'] is not None:  # noqa: E501
            query_params.append(('committee_id', local_var_params['committee_id']))  # noqa: E501
            collection_formats['committee_id'] = 'multi'  # noqa: E501
        if 'max_cash_on_hand_end_period_amount' in local_var_params and local_var_params['max_cash_on_hand_end_period_amount'] is not None:  # noqa: E501
            query_params.append(('max_cash_on_hand_end_period_amount', local_var_params['max_cash_on_hand_end_period_amount']))  # noqa: E501
        if 'year' in local_var_params and local_var_params['year'] is not None:  # noqa: E501
            query_params.append(('year', local_var_params['year']))  # noqa: E501
            collection_formats['year'] = 'multi'  # noqa: E501
        if 'min_disbursements_amount' in local_var_params and local_var_params['min_disbursements_amount'] is not None:  # noqa: E501
            query_params.append(('min_disbursements_amount', local_var_params['min_disbursements_amount']))  # noqa: E501
        if 'api_key' in local_var_params and local_var_params['api_key'] is not None:  # noqa: E501
            query_params.append(('api_key', local_var_params['api_key']))  # noqa: E501
        if 'amendment_indicator' in local_var_params and local_var_params['amendment_indicator'] is not None:  # noqa: E501
            query_params.append(('amendment_indicator', local_var_params['amendment_indicator']))  # noqa: E501
            collection_formats['amendment_indicator'] = 'multi'  # noqa: E501
        if 'min_receipts_amount' in local_var_params and local_var_params['min_receipts_amount'] is not None:  # noqa: E501
            query_params.append(('min_receipts_amount', local_var_params['min_receipts_amount']))  # noqa: E501
        if 'sort_nulls_last' in local_var_params and local_var_params['sort_nulls_last'] is not None:  # noqa: E501
            query_params.append(('sort_nulls_last', local_var_params['sort_nulls_last']))  # noqa: E501
        if 'sort_null_only' in local_var_params and local_var_params['sort_null_only'] is not None:  # noqa: E501
            query_params.append(('sort_null_only', local_var_params['sort_null_only']))  # noqa: E501
        if 'min_independent_expenditures' in local_var_params and local_var_params['min_independent_expenditures'] is not None:  # noqa: E501
            query_params.append(('min_independent_expenditures', local_var_params['min_independent_expenditures']))  # noqa: E501
        if 'min_total_contributions' in local_var_params and local_var_params['min_total_contributions'] is not None:  # noqa: E501
            query_params.append(('min_total_contributions', local_var_params['min_total_contributions']))  # noqa: E501
        if 'type' in local_var_params and local_var_params['type'] is not None:  # noqa: E501
            query_params.append(('type', local_var_params['type']))  # noqa: E501
            collection_formats['type'] = 'multi'  # noqa: E501
        if 'sort_hide_null' in local_var_params and local_var_params['sort_hide_null'] is not None:  # noqa: E501
            query_params.append(('sort_hide_null', local_var_params['sort_hide_null']))  # noqa: E501
        if 'per_page' in local_var_params and local_var_params['per_page'] is not None:  # noqa: E501
            query_params.append(('per_page', local_var_params['per_page']))  # noqa: E501
        if 'cycle' in local_var_params and local_var_params['cycle'] is not None:  # noqa: E501
            query_params.append(('cycle', local_var_params['cycle']))  # noqa: E501
            collection_formats['cycle'] = 'multi'  # noqa: E501
        if 'is_amended' in local_var_params and local_var_params['is_amended'] is not None:  # noqa: E501
            query_params.append(('is_amended', local_var_params['is_amended']))  # noqa: E501
        if 'report_type' in local_var_params and local_var_params['report_type'] is not None:  # noqa: E501
            query_params.append(('report_type', local_var_params['report_type']))  # noqa: E501
            collection_formats['report_type'] = 'multi'  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyHeaderAuth', 'ApiKeyQueryAuth', 'apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/reports/{committee_type}/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CommitteeReportsPage',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def totals_by_entity_get(self, cycle, api_key, **kwargs):  # noqa: E501
        """totals_by_entity_get  # noqa: E501

         Provides cumulative receipt totals by entity type, over a two year cycle. Totals are adjusted to avoid double counting.  This is [the sql](https://github.com/fecgov/openFEC/blob/develop/data/migrations/V41__large_aggregates.sql) that creates these calculations.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.totals_by_entity_get(cycle, api_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int cycle:  Filter records to only those that were applicable to a given two-year period.The cycle begins with an odd year and is named for its ending, even year.  (required)
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param bool sort_nulls_last: Toggle that sorts null values last
        :param int page: For paginating through results, starting at page 1
        :param str sort: Provide a field to sort by. Use `-` for descending order.
        :param bool sort_null_only: Toggle that filters out all rows having sort column that is non-null
        :param bool sort_hide_null: Hide null values on sorted column(s).
        :param int per_page: The number of results returned per page. Defaults to 20.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: EntityReceiptDisbursementTotalsPage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.totals_by_entity_get_with_http_info(cycle, api_key, **kwargs)  # noqa: E501

    def totals_by_entity_get_with_http_info(self, cycle, api_key, **kwargs):  # noqa: E501
        """totals_by_entity_get  # noqa: E501

         Provides cumulative receipt totals by entity type, over a two year cycle. Totals are adjusted to avoid double counting.  This is [the sql](https://github.com/fecgov/openFEC/blob/develop/data/migrations/V41__large_aggregates.sql) that creates these calculations.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.totals_by_entity_get_with_http_info(cycle, api_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int cycle:  Filter records to only those that were applicable to a given two-year period.The cycle begins with an odd year and is named for its ending, even year.  (required)
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param bool sort_nulls_last: Toggle that sorts null values last
        :param int page: For paginating through results, starting at page 1
        :param str sort: Provide a field to sort by. Use `-` for descending order.
        :param bool sort_null_only: Toggle that filters out all rows having sort column that is non-null
        :param bool sort_hide_null: Hide null values on sorted column(s).
        :param int per_page: The number of results returned per page. Defaults to 20.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(EntityReceiptDisbursementTotalsPage, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'cycle',
            'api_key',
            'sort_nulls_last',
            'page',
            'sort',
            'sort_null_only',
            'sort_hide_null',
            'per_page'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    ' to method totals_by_entity_get' % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'cycle' is set
        if self.api_client.client_side_validation and ('cycle' not in local_var_params or  # noqa: E501
                                                        local_var_params['cycle'] is None):  # noqa: E501
            raise ApiValueError('Missing the required parameter `cycle` when calling `totals_by_entity_get`')  # noqa: E501
        # verify the required parameter 'api_key' is set
        if self.api_client.client_side_validation and ('api_key' not in local_var_params or  # noqa: E501
                                                        local_var_params['api_key'] is None):  # noqa: E501
            raise ApiValueError('Missing the required parameter `api_key` when calling `totals_by_entity_get`')  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'sort_nulls_last' in local_var_params and local_var_params['sort_nulls_last'] is not None:  # noqa: E501
            query_params.append(('sort_nulls_last', local_var_params['sort_nulls_last']))  # noqa: E501
        if 'cycle' in local_var_params and local_var_params['cycle'] is not None:  # noqa: E501
            query_params.append(('cycle', local_var_params['cycle']))  # noqa: E501
        if 'page' in local_var_params and local_var_params['page'] is not None:  # noqa: E501
            query_params.append(('page', local_var_params['page']))  # noqa: E501
        if 'api_key' in local_var_params and local_var_params['api_key'] is not None:  # noqa: E501
            query_params.append(('api_key', local_var_params['api_key']))  # noqa: E501
        if 'sort' in local_var_params and local_var_params['sort'] is not None:  # noqa: E501
            query_params.append(('sort', local_var_params['sort']))  # noqa: E501
        if 'sort_null_only' in local_var_params and local_var_params['sort_null_only'] is not None:  # noqa: E501
            query_params.append(('sort_null_only', local_var_params['sort_null_only']))  # noqa: E501
        if 'sort_hide_null' in local_var_params and local_var_params['sort_hide_null'] is not None:  # noqa: E501
            query_params.append(('sort_hide_null', local_var_params['sort_hide_null']))  # noqa: E501
        if 'per_page' in local_var_params and local_var_params['per_page'] is not None:  # noqa: E501
            query_params.append(('per_page', local_var_params['per_page']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyHeaderAuth', 'ApiKeyQueryAuth', 'apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/totals/by_entity/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='EntityReceiptDisbursementTotalsPage',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def totals_committee_type_get(self, api_key, committee_type, **kwargs):  # noqa: E501
        """totals_committee_type_get  # noqa: E501

         This endpoint provides information about a committee's Form 3, Form 3X, or Form 3P financial reports, which are aggregated by two-year period. We refer to two-year periods as a `cycle`.  The cycle is named after the even-numbered year and includes the year before it. To see totals from 2013 and 2014, you would use 2014. In odd-numbered years, the current cycle is the next year — for example, in 2015, the current cycle is 2016.  For presidential and Senate candidates, multiple two-year cycles exist between elections.  Parameter `full_election` is replaced by `election_full`. Please use `election_full` instead.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.totals_committee_type_get(api_key, committee_type, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param str committee_type: House, Senate, presidential, independent expenditure only (required)
        :param str sort: Provide a field to sort by. Use `-` for descending order.
        :param bool sort_hide_null: Hide null values on sorted column(s).
        :param int per_page: The number of results returned per page. Defaults to 20.
        :param str committee_designation_full: The one-letter designation code of the organization:          - A authorized by a candidate          - J joint fundraising committee          - P principal campaign committee of a candidate          - U unauthorized          - B lobbyist/registrant PAC          - D leadership PAC
        :param bool sort_nulls_last: Toggle that sorts null values last
        :param str committee_id:  A unique identifier assigned to each committee or filer registered with the FEC. In general committee id's begin with the letter C which is followed by eight digits.
        :param int page: For paginating through results, starting at page 1
        :param list[int] cycle:  Filter records to only those that were applicable to a given two-year period.The cycle begins with an odd year and is named for its ending, even year.
        :param str committee_type_full: The one-letter type code of the organization:         - C communication cost         - D delegate         - E electioneering communication         - H House         - I independent expenditor (person or group)         - N PAC - nonqualified         - O independent expenditure-only (super PACs)         - P presidential         - Q PAC - qualified         - S Senate         - U single candidate independent expenditure         - V PAC with non-contribution account, nonqualified         - W PAC with non-contribution account, qualified         - X party, nonqualified         - Y party, qualified         - Z national party non-federal account
        :param bool sort_null_only: Toggle that filters out all rows having sort column that is non-null
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: CommitteeTotalsPage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.totals_committee_type_get_with_http_info(api_key, committee_type, **kwargs)  # noqa: E501

    def totals_committee_type_get_with_http_info(self, api_key, committee_type, **kwargs):  # noqa: E501
        """totals_committee_type_get  # noqa: E501

         This endpoint provides information about a committee's Form 3, Form 3X, or Form 3P financial reports, which are aggregated by two-year period. We refer to two-year periods as a `cycle`.  The cycle is named after the even-numbered year and includes the year before it. To see totals from 2013 and 2014, you would use 2014. In odd-numbered years, the current cycle is the next year — for example, in 2015, the current cycle is 2016.  For presidential and Senate candidates, multiple two-year cycles exist between elections.  Parameter `full_election` is replaced by `election_full`. Please use `election_full` instead.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.totals_committee_type_get_with_http_info(api_key, committee_type, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param str committee_type: House, Senate, presidential, independent expenditure only (required)
        :param str sort: Provide a field to sort by. Use `-` for descending order.
        :param bool sort_hide_null: Hide null values on sorted column(s).
        :param int per_page: The number of results returned per page. Defaults to 20.
        :param str committee_designation_full: The one-letter designation code of the organization:          - A authorized by a candidate          - J joint fundraising committee          - P principal campaign committee of a candidate          - U unauthorized          - B lobbyist/registrant PAC          - D leadership PAC
        :param bool sort_nulls_last: Toggle that sorts null values last
        :param str committee_id:  A unique identifier assigned to each committee or filer registered with the FEC. In general committee id's begin with the letter C which is followed by eight digits.
        :param int page: For paginating through results, starting at page 1
        :param list[int] cycle:  Filter records to only those that were applicable to a given two-year period.The cycle begins with an odd year and is named for its ending, even year.
        :param str committee_type_full: The one-letter type code of the organization:         - C communication cost         - D delegate         - E electioneering communication         - H House         - I independent expenditor (person or group)         - N PAC - nonqualified         - O independent expenditure-only (super PACs)         - P presidential         - Q PAC - qualified         - S Senate         - U single candidate independent expenditure         - V PAC with non-contribution account, nonqualified         - W PAC with non-contribution account, qualified         - X party, nonqualified         - Y party, qualified         - Z national party non-federal account
        :param bool sort_null_only: Toggle that filters out all rows having sort column that is non-null
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(CommitteeTotalsPage, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'api_key',
            'committee_type',
            'sort',
            'sort_hide_null',
            'per_page',
            'committee_designation_full',
            'sort_nulls_last',
            'committee_id',
            'page',
            'cycle',
            'committee_type_full',
            'sort_null_only'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    ' to method totals_committee_type_get' % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'api_key' is set
        if self.api_client.client_side_validation and ('api_key' not in local_var_params or  # noqa: E501
                                                        local_var_params['api_key'] is None):  # noqa: E501
            raise ApiValueError('Missing the required parameter `api_key` when calling `totals_committee_type_get`')  # noqa: E501
        # verify the required parameter 'committee_type' is set
        if self.api_client.client_side_validation and ('committee_type' not in local_var_params or  # noqa: E501
                                                        local_var_params['committee_type'] is None):  # noqa: E501
            raise ApiValueError('Missing the required parameter `committee_type` when calling `totals_committee_type_get`')  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'committee_type' in local_var_params:
            path_params['committee_type'] = local_var_params['committee_type']  # noqa: E501

        query_params = []
        if 'api_key' in local_var_params and local_var_params['api_key'] is not None:  # noqa: E501
            query_params.append(('api_key', local_var_params['api_key']))  # noqa: E501
        if 'sort' in local_var_params and local_var_params['sort'] is not None:  # noqa: E501
            query_params.append(('sort', local_var_params['sort']))  # noqa: E501
        if 'sort_hide_null' in local_var_params and local_var_params['sort_hide_null'] is not None:  # noqa: E501
            query_params.append(('sort_hide_null', local_var_params['sort_hide_null']))  # noqa: E501
        if 'per_page' in local_var_params and local_var_params['per_page'] is not None:  # noqa: E501
            query_params.append(('per_page', local_var_params['per_page']))  # noqa: E501
        if 'committee_designation_full' in local_var_params and local_var_params['committee_designation_full'] is not None:  # noqa: E501
            query_params.append(('committee_designation_full', local_var_params['committee_designation_full']))  # noqa: E501
        if 'sort_nulls_last' in local_var_params and local_var_params['sort_nulls_last'] is not None:  # noqa: E501
            query_params.append(('sort_nulls_last', local_var_params['sort_nulls_last']))  # noqa: E501
        if 'committee_id' in local_var_params and local_var_params['committee_id'] is not None:  # noqa: E501
            query_params.append(('committee_id', local_var_params['committee_id']))  # noqa: E501
        if 'page' in local_var_params and local_var_params['page'] is not None:  # noqa: E501
            query_params.append(('page', local_var_params['page']))  # noqa: E501
        if 'cycle' in local_var_params and local_var_params['cycle'] is not None:  # noqa: E501
            query_params.append(('cycle', local_var_params['cycle']))  # noqa: E501
            collection_formats['cycle'] = 'multi'  # noqa: E501
        if 'committee_type_full' in local_var_params and local_var_params['committee_type_full'] is not None:  # noqa: E501
            query_params.append(('committee_type_full', local_var_params['committee_type_full']))  # noqa: E501
        if 'sort_null_only' in local_var_params and local_var_params['sort_null_only'] is not None:  # noqa: E501
            query_params.append(('sort_null_only', local_var_params['sort_null_only']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyHeaderAuth', 'ApiKeyQueryAuth', 'apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/totals/{committee_type}/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CommitteeTotalsPage',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
