# coding: utf-8

"""
    OpenFEC

    This API allows you to explore the way candidates and committees fund their campaigns.    The FEC API is a RESTful web service supporting full-text and field-specific searches on FEC data. [Bulk downloads](https://www.fec.gov/data/advanced/?tab=bulk-data) are available on the current site. Information is tied to the underlying forms by file ID and image ID. Data is updated nightly.    There is a lot of data, but a good place to start is to use search to find interesting candidates and committees. Then, you can use their IDs to find report or line item details with the other endpoints. If you are interested in individual donors, check out contributor information in schedule_a.    Get an [API key here](https://api.data.gov/signup/). That will enable you to place up to 1,000 calls an hour. Each call is limited to 100 results per page. You can email questions, comments or a request to get a key for 120 calls per minute to [APIinfo@fec.gov](mailto:apiinfo@fec.gov). You can also ask questions and discuss the data in the [FEC data Google Group](https://groups.google.com/forum/#!forum/fec-data). API changes will also be added to this group in advance of the change.    The model definitions and schema are available at [/swagger](/swagger/). This is useful for making wrappers and exploring the data.    A few restrictions limit the way you can use FEC data. For example, you can’t use contributor lists for commercial purposes or to solicit donations. [Learn more here](https://www.fec.gov/updates/sale-or-use-contributor-information/).    [View our source code](https://github.com/fecgov/openFEC). We welcome issues and pull requests!  # noqa: E501

    The version of the OpenAPI document: 1.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from openfec_sdk.api_client import ApiClient
from openfec_sdk.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class IndependentExpendituresApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def schedules_schedule_e_by_candidate_get(self, api_key, **kwargs):  # noqa: E501
        """schedules_schedule_e_by_candidate_get  # noqa: E501

         Schedule E receipts aggregated by recipient candidate. To avoid double counting, memoed items are not included.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.schedules_schedule_e_by_candidate_get(api_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param bool election_full: `True` indicates that full election period of a candidate. `False` indicates that two year election cycle.
        :param str sort: Provide a field to sort by. Use `-` for descending order.
        :param list[str] candidate_id:  A unique identifier assigned to each candidate registered with the FEC. If a person runs for several offices, that person will have separate candidate IDs for each office.
        :param str state: US state or territory where a candidate runs for office
        :param bool sort_hide_null: Hide null values on sorted column(s).
        :param int per_page: The number of results returned per page. Defaults to 20.
        :param str district: Two-digit US House distirict of the office the candidate is running for. Presidential, Senate and House at-large candidates will have District 00.
        :param bool sort_nulls_last: Toggle that sorts null values last
        :param list[int] cycle:  Filter records to only those that were applicable to a given two-year period.The cycle begins with an odd year and is named for its ending, even year.
        :param int page: For paginating through results, starting at page 1
        :param list[str] committee_id:  A unique identifier assigned to each committee or filer registered with the FEC. In general committee id's begin with the letter C which is followed by eight digits.
        :param str support_oppose: Support or opposition
        :param bool sort_null_only: Toggle that filters out all rows having sort column that is non-null
        :param str office: Federal office candidate runs for: H, S or P
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ScheduleEByCandidatePage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.schedules_schedule_e_by_candidate_get_with_http_info(api_key, **kwargs)  # noqa: E501

    def schedules_schedule_e_by_candidate_get_with_http_info(self, api_key, **kwargs):  # noqa: E501
        """schedules_schedule_e_by_candidate_get  # noqa: E501

         Schedule E receipts aggregated by recipient candidate. To avoid double counting, memoed items are not included.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.schedules_schedule_e_by_candidate_get_with_http_info(api_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param bool election_full: `True` indicates that full election period of a candidate. `False` indicates that two year election cycle.
        :param str sort: Provide a field to sort by. Use `-` for descending order.
        :param list[str] candidate_id:  A unique identifier assigned to each candidate registered with the FEC. If a person runs for several offices, that person will have separate candidate IDs for each office.
        :param str state: US state or territory where a candidate runs for office
        :param bool sort_hide_null: Hide null values on sorted column(s).
        :param int per_page: The number of results returned per page. Defaults to 20.
        :param str district: Two-digit US House distirict of the office the candidate is running for. Presidential, Senate and House at-large candidates will have District 00.
        :param bool sort_nulls_last: Toggle that sorts null values last
        :param list[int] cycle:  Filter records to only those that were applicable to a given two-year period.The cycle begins with an odd year and is named for its ending, even year.
        :param int page: For paginating through results, starting at page 1
        :param list[str] committee_id:  A unique identifier assigned to each committee or filer registered with the FEC. In general committee id's begin with the letter C which is followed by eight digits.
        :param str support_oppose: Support or opposition
        :param bool sort_null_only: Toggle that filters out all rows having sort column that is non-null
        :param str office: Federal office candidate runs for: H, S or P
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ScheduleEByCandidatePage, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'api_key',
            'election_full',
            'sort',
            'candidate_id',
            'state',
            'sort_hide_null',
            'per_page',
            'district',
            'sort_nulls_last',
            'cycle',
            'page',
            'committee_id',
            'support_oppose',
            'sort_null_only',
            'office'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    ' to method schedules_schedule_e_by_candidate_get' % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'api_key' is set
        if self.api_client.client_side_validation and ('api_key' not in local_var_params or  # noqa: E501
                                                        local_var_params['api_key'] is None):  # noqa: E501
            raise ApiValueError('Missing the required parameter `api_key` when calling `schedules_schedule_e_by_candidate_get`')  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'election_full' in local_var_params and local_var_params['election_full'] is not None:  # noqa: E501
            query_params.append(('election_full', local_var_params['election_full']))  # noqa: E501
        if 'api_key' in local_var_params and local_var_params['api_key'] is not None:  # noqa: E501
            query_params.append(('api_key', local_var_params['api_key']))  # noqa: E501
        if 'sort' in local_var_params and local_var_params['sort'] is not None:  # noqa: E501
            query_params.append(('sort', local_var_params['sort']))  # noqa: E501
        if 'candidate_id' in local_var_params and local_var_params['candidate_id'] is not None:  # noqa: E501
            query_params.append(('candidate_id', local_var_params['candidate_id']))  # noqa: E501
            collection_formats['candidate_id'] = 'multi'  # noqa: E501
        if 'state' in local_var_params and local_var_params['state'] is not None:  # noqa: E501
            query_params.append(('state', local_var_params['state']))  # noqa: E501
        if 'sort_hide_null' in local_var_params and local_var_params['sort_hide_null'] is not None:  # noqa: E501
            query_params.append(('sort_hide_null', local_var_params['sort_hide_null']))  # noqa: E501
        if 'per_page' in local_var_params and local_var_params['per_page'] is not None:  # noqa: E501
            query_params.append(('per_page', local_var_params['per_page']))  # noqa: E501
        if 'district' in local_var_params and local_var_params['district'] is not None:  # noqa: E501
            query_params.append(('district', local_var_params['district']))  # noqa: E501
        if 'sort_nulls_last' in local_var_params and local_var_params['sort_nulls_last'] is not None:  # noqa: E501
            query_params.append(('sort_nulls_last', local_var_params['sort_nulls_last']))  # noqa: E501
        if 'cycle' in local_var_params and local_var_params['cycle'] is not None:  # noqa: E501
            query_params.append(('cycle', local_var_params['cycle']))  # noqa: E501
            collection_formats['cycle'] = 'multi'  # noqa: E501
        if 'page' in local_var_params and local_var_params['page'] is not None:  # noqa: E501
            query_params.append(('page', local_var_params['page']))  # noqa: E501
        if 'committee_id' in local_var_params and local_var_params['committee_id'] is not None:  # noqa: E501
            query_params.append(('committee_id', local_var_params['committee_id']))  # noqa: E501
            collection_formats['committee_id'] = 'multi'  # noqa: E501
        if 'support_oppose' in local_var_params and local_var_params['support_oppose'] is not None:  # noqa: E501
            query_params.append(('support_oppose', local_var_params['support_oppose']))  # noqa: E501
        if 'sort_null_only' in local_var_params and local_var_params['sort_null_only'] is not None:  # noqa: E501
            query_params.append(('sort_null_only', local_var_params['sort_null_only']))  # noqa: E501
        if 'office' in local_var_params and local_var_params['office'] is not None:  # noqa: E501
            query_params.append(('office', local_var_params['office']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyHeaderAuth', 'ApiKeyQueryAuth', 'apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/schedules/schedule_e/by_candidate/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ScheduleEByCandidatePage',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def schedules_schedule_e_efile_get(self, api_key, **kwargs):  # noqa: E501
        """schedules_schedule_e_efile_get  # noqa: E501

         Efiling endpoints provide real-time campaign finance data received from electronic filers. Efiling endpoints only contain the most recent four months of data and don't contain the processed and coded data that you can find on other endpoints.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.schedules_schedule_e_efile_get(api_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param list[str] candidate_search:  Search for candidates by candiate id or candidate first or last name
        :param date min_expenditure_date: Selects all items expended by this committee after this date
        :param str sort: Provide a field to sort by. Use `-` for descending order.
        :param list[str] candidate_id:  A unique identifier assigned to each candidate registered with the FEC. If a person runs for several offices, that person will have separate candidate IDs for each office.
        :param list[str] candidate_office_state: US state or territory where a candidate runs for office
        :param date min_dissemination_date: Selects all items distributed by this committee after this date
        :param bool sort_nulls_last: Toggle that sorts null values last
        :param date max_filed_date: Timestamp of electronic or paper record that FEC received
        :param bool is_notice:  Record filed as 24- or 48-hour notice.
        :param date max_dissemination_date: Selects all items distributed by this committee before this date
        :param list[str] candidate_party: Three-letter code for the party affiliated with a candidate or committee. For example, DEM for Democratic Party and REP for Republican Party.
        :param bool sort_null_only: Toggle that filters out all rows having sort column that is non-null
        :param int max_expenditure_amount: Selects all items expended by this committee less than this amount
        :param list[str] filing_form: The form where the underlying data comes from, for example, Form 1 would appear as F1:     - F1   Statement of Organization     - F1M  Notification of Multicandidate Status     - F2   Statement of Candidacy     - F3   Report of Receipts and Disbursements for an Authorized Committee     - F3P  Report of Receipts and Disbursements by an Authorized Committee of a Candidate for     The Office of President or Vice President     - F3L  Report of Contributions Bundled by Lobbyists/Registrants and Lobbyist/Registrant PACs     - F3X  Report of Receipts and Disbursements for other than an Authorized Committee     - F4   Report of Receipts and Disbursements for a Committee or Organization Supporting a Nomination Convention     - F5   Report of Independent Expenditures Made and Contributions Received     - F6   48 Hour Notice of Contributions/Loans Received     - F7   Report of Communication Costs by Corporations and Membership Organizations     - F8   Debt Settlement Plan     - F9   24 Hour Notice of Disbursements for Electioneering Communications     - F13  Report of Donations Accepted for Inaugural Committee     - F99  Miscellaneous Text     - FRQ  Request for Additional Information
        :param date max_expenditure_date: Selects all items expended by this committee before this date
        :param int min_expenditure_amount: Selects all items expended by this committee greater than this amount
        :param list[str] spender_name: The name of the committee. If a committee changes its name,     the most recent name will be shown. Committee names are not unique. Use committee_id     for looking up records.
        :param bool most_recent:  The report associated with the transaction is either new or is the most-recently filed amendment. Undetermined version (`null`) is always included.
        :param list[str] candidate_office_district: Two-digit US House distirict of the office the candidate is running for. Presidential, Senate and House at-large candidates will have District 00.
        :param int per_page: The number of results returned per page. Defaults to 20.
        :param bool sort_hide_null: Hide null values on sorted column(s).
        :param list[str] image_number:  An unique identifier for each page where the electronic or paper filing is reported.
        :param list[str] committee_id:  A unique identifier assigned to each committee or filer registered with the FEC. In general committee id's begin with the letter C which is followed by eight digits.
        :param int page: For paginating through results, starting at page 1
        :param list[str] payee_name:  Name of the entity that received the payment.
        :param date min_filed_date: Timestamp of electronic or paper record that FEC received
        :param list[str] support_oppose_indicator: Explains if the money was spent in order to support or oppose a candidate or candidates. (Coded S or O for support or oppose.) This indicator applies to independent expenditures and communication costs.
        :param str candidate_office: Federal office candidate runs for: H, S or P
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ScheduleEEfilePage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.schedules_schedule_e_efile_get_with_http_info(api_key, **kwargs)  # noqa: E501

    def schedules_schedule_e_efile_get_with_http_info(self, api_key, **kwargs):  # noqa: E501
        """schedules_schedule_e_efile_get  # noqa: E501

         Efiling endpoints provide real-time campaign finance data received from electronic filers. Efiling endpoints only contain the most recent four months of data and don't contain the processed and coded data that you can find on other endpoints.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.schedules_schedule_e_efile_get_with_http_info(api_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param list[str] candidate_search:  Search for candidates by candiate id or candidate first or last name
        :param date min_expenditure_date: Selects all items expended by this committee after this date
        :param str sort: Provide a field to sort by. Use `-` for descending order.
        :param list[str] candidate_id:  A unique identifier assigned to each candidate registered with the FEC. If a person runs for several offices, that person will have separate candidate IDs for each office.
        :param list[str] candidate_office_state: US state or territory where a candidate runs for office
        :param date min_dissemination_date: Selects all items distributed by this committee after this date
        :param bool sort_nulls_last: Toggle that sorts null values last
        :param date max_filed_date: Timestamp of electronic or paper record that FEC received
        :param bool is_notice:  Record filed as 24- or 48-hour notice.
        :param date max_dissemination_date: Selects all items distributed by this committee before this date
        :param list[str] candidate_party: Three-letter code for the party affiliated with a candidate or committee. For example, DEM for Democratic Party and REP for Republican Party.
        :param bool sort_null_only: Toggle that filters out all rows having sort column that is non-null
        :param int max_expenditure_amount: Selects all items expended by this committee less than this amount
        :param list[str] filing_form: The form where the underlying data comes from, for example, Form 1 would appear as F1:     - F1   Statement of Organization     - F1M  Notification of Multicandidate Status     - F2   Statement of Candidacy     - F3   Report of Receipts and Disbursements for an Authorized Committee     - F3P  Report of Receipts and Disbursements by an Authorized Committee of a Candidate for     The Office of President or Vice President     - F3L  Report of Contributions Bundled by Lobbyists/Registrants and Lobbyist/Registrant PACs     - F3X  Report of Receipts and Disbursements for other than an Authorized Committee     - F4   Report of Receipts and Disbursements for a Committee or Organization Supporting a Nomination Convention     - F5   Report of Independent Expenditures Made and Contributions Received     - F6   48 Hour Notice of Contributions/Loans Received     - F7   Report of Communication Costs by Corporations and Membership Organizations     - F8   Debt Settlement Plan     - F9   24 Hour Notice of Disbursements for Electioneering Communications     - F13  Report of Donations Accepted for Inaugural Committee     - F99  Miscellaneous Text     - FRQ  Request for Additional Information
        :param date max_expenditure_date: Selects all items expended by this committee before this date
        :param int min_expenditure_amount: Selects all items expended by this committee greater than this amount
        :param list[str] spender_name: The name of the committee. If a committee changes its name,     the most recent name will be shown. Committee names are not unique. Use committee_id     for looking up records.
        :param bool most_recent:  The report associated with the transaction is either new or is the most-recently filed amendment. Undetermined version (`null`) is always included.
        :param list[str] candidate_office_district: Two-digit US House distirict of the office the candidate is running for. Presidential, Senate and House at-large candidates will have District 00.
        :param int per_page: The number of results returned per page. Defaults to 20.
        :param bool sort_hide_null: Hide null values on sorted column(s).
        :param list[str] image_number:  An unique identifier for each page where the electronic or paper filing is reported.
        :param list[str] committee_id:  A unique identifier assigned to each committee or filer registered with the FEC. In general committee id's begin with the letter C which is followed by eight digits.
        :param int page: For paginating through results, starting at page 1
        :param list[str] payee_name:  Name of the entity that received the payment.
        :param date min_filed_date: Timestamp of electronic or paper record that FEC received
        :param list[str] support_oppose_indicator: Explains if the money was spent in order to support or oppose a candidate or candidates. (Coded S or O for support or oppose.) This indicator applies to independent expenditures and communication costs.
        :param str candidate_office: Federal office candidate runs for: H, S or P
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ScheduleEEfilePage, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'api_key',
            'candidate_search',
            'min_expenditure_date',
            'sort',
            'candidate_id',
            'candidate_office_state',
            'min_dissemination_date',
            'sort_nulls_last',
            'max_filed_date',
            'is_notice',
            'max_dissemination_date',
            'candidate_party',
            'sort_null_only',
            'max_expenditure_amount',
            'filing_form',
            'max_expenditure_date',
            'min_expenditure_amount',
            'spender_name',
            'most_recent',
            'candidate_office_district',
            'per_page',
            'sort_hide_null',
            'image_number',
            'committee_id',
            'page',
            'payee_name',
            'min_filed_date',
            'support_oppose_indicator',
            'candidate_office'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    ' to method schedules_schedule_e_efile_get' % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'api_key' is set
        if self.api_client.client_side_validation and ('api_key' not in local_var_params or  # noqa: E501
                                                        local_var_params['api_key'] is None):  # noqa: E501
            raise ApiValueError('Missing the required parameter `api_key` when calling `schedules_schedule_e_efile_get`')  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'candidate_search' in local_var_params and local_var_params['candidate_search'] is not None:  # noqa: E501
            query_params.append(('candidate_search', local_var_params['candidate_search']))  # noqa: E501
            collection_formats['candidate_search'] = 'multi'  # noqa: E501
        if 'min_expenditure_date' in local_var_params and local_var_params['min_expenditure_date'] is not None:  # noqa: E501
            query_params.append(('min_expenditure_date', local_var_params['min_expenditure_date']))  # noqa: E501
        if 'api_key' in local_var_params and local_var_params['api_key'] is not None:  # noqa: E501
            query_params.append(('api_key', local_var_params['api_key']))  # noqa: E501
        if 'sort' in local_var_params and local_var_params['sort'] is not None:  # noqa: E501
            query_params.append(('sort', local_var_params['sort']))  # noqa: E501
        if 'candidate_id' in local_var_params and local_var_params['candidate_id'] is not None:  # noqa: E501
            query_params.append(('candidate_id', local_var_params['candidate_id']))  # noqa: E501
            collection_formats['candidate_id'] = 'multi'  # noqa: E501
        if 'candidate_office_state' in local_var_params and local_var_params['candidate_office_state'] is not None:  # noqa: E501
            query_params.append(('candidate_office_state', local_var_params['candidate_office_state']))  # noqa: E501
            collection_formats['candidate_office_state'] = 'multi'  # noqa: E501
        if 'min_dissemination_date' in local_var_params and local_var_params['min_dissemination_date'] is not None:  # noqa: E501
            query_params.append(('min_dissemination_date', local_var_params['min_dissemination_date']))  # noqa: E501
        if 'sort_nulls_last' in local_var_params and local_var_params['sort_nulls_last'] is not None:  # noqa: E501
            query_params.append(('sort_nulls_last', local_var_params['sort_nulls_last']))  # noqa: E501
        if 'max_filed_date' in local_var_params and local_var_params['max_filed_date'] is not None:  # noqa: E501
            query_params.append(('max_filed_date', local_var_params['max_filed_date']))  # noqa: E501
        if 'is_notice' in local_var_params and local_var_params['is_notice'] is not None:  # noqa: E501
            query_params.append(('is_notice', local_var_params['is_notice']))  # noqa: E501
        if 'max_dissemination_date' in local_var_params and local_var_params['max_dissemination_date'] is not None:  # noqa: E501
            query_params.append(('max_dissemination_date', local_var_params['max_dissemination_date']))  # noqa: E501
        if 'candidate_party' in local_var_params and local_var_params['candidate_party'] is not None:  # noqa: E501
            query_params.append(('candidate_party', local_var_params['candidate_party']))  # noqa: E501
            collection_formats['candidate_party'] = 'multi'  # noqa: E501
        if 'sort_null_only' in local_var_params and local_var_params['sort_null_only'] is not None:  # noqa: E501
            query_params.append(('sort_null_only', local_var_params['sort_null_only']))  # noqa: E501
        if 'max_expenditure_amount' in local_var_params and local_var_params['max_expenditure_amount'] is not None:  # noqa: E501
            query_params.append(('max_expenditure_amount', local_var_params['max_expenditure_amount']))  # noqa: E501
        if 'filing_form' in local_var_params and local_var_params['filing_form'] is not None:  # noqa: E501
            query_params.append(('filing_form', local_var_params['filing_form']))  # noqa: E501
            collection_formats['filing_form'] = 'multi'  # noqa: E501
        if 'max_expenditure_date' in local_var_params and local_var_params['max_expenditure_date'] is not None:  # noqa: E501
            query_params.append(('max_expenditure_date', local_var_params['max_expenditure_date']))  # noqa: E501
        if 'min_expenditure_amount' in local_var_params and local_var_params['min_expenditure_amount'] is not None:  # noqa: E501
            query_params.append(('min_expenditure_amount', local_var_params['min_expenditure_amount']))  # noqa: E501
        if 'spender_name' in local_var_params and local_var_params['spender_name'] is not None:  # noqa: E501
            query_params.append(('spender_name', local_var_params['spender_name']))  # noqa: E501
            collection_formats['spender_name'] = 'multi'  # noqa: E501
        if 'most_recent' in local_var_params and local_var_params['most_recent'] is not None:  # noqa: E501
            query_params.append(('most_recent', local_var_params['most_recent']))  # noqa: E501
        if 'candidate_office_district' in local_var_params and local_var_params['candidate_office_district'] is not None:  # noqa: E501
            query_params.append(('candidate_office_district', local_var_params['candidate_office_district']))  # noqa: E501
            collection_formats['candidate_office_district'] = 'multi'  # noqa: E501
        if 'per_page' in local_var_params and local_var_params['per_page'] is not None:  # noqa: E501
            query_params.append(('per_page', local_var_params['per_page']))  # noqa: E501
        if 'sort_hide_null' in local_var_params and local_var_params['sort_hide_null'] is not None:  # noqa: E501
            query_params.append(('sort_hide_null', local_var_params['sort_hide_null']))  # noqa: E501
        if 'image_number' in local_var_params and local_var_params['image_number'] is not None:  # noqa: E501
            query_params.append(('image_number', local_var_params['image_number']))  # noqa: E501
            collection_formats['image_number'] = 'multi'  # noqa: E501
        if 'committee_id' in local_var_params and local_var_params['committee_id'] is not None:  # noqa: E501
            query_params.append(('committee_id', local_var_params['committee_id']))  # noqa: E501
            collection_formats['committee_id'] = 'multi'  # noqa: E501
        if 'page' in local_var_params and local_var_params['page'] is not None:  # noqa: E501
            query_params.append(('page', local_var_params['page']))  # noqa: E501
        if 'payee_name' in local_var_params and local_var_params['payee_name'] is not None:  # noqa: E501
            query_params.append(('payee_name', local_var_params['payee_name']))  # noqa: E501
            collection_formats['payee_name'] = 'multi'  # noqa: E501
        if 'min_filed_date' in local_var_params and local_var_params['min_filed_date'] is not None:  # noqa: E501
            query_params.append(('min_filed_date', local_var_params['min_filed_date']))  # noqa: E501
        if 'support_oppose_indicator' in local_var_params and local_var_params['support_oppose_indicator'] is not None:  # noqa: E501
            query_params.append(('support_oppose_indicator', local_var_params['support_oppose_indicator']))  # noqa: E501
            collection_formats['support_oppose_indicator'] = 'multi'  # noqa: E501
        if 'candidate_office' in local_var_params and local_var_params['candidate_office'] is not None:  # noqa: E501
            query_params.append(('candidate_office', local_var_params['candidate_office']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyHeaderAuth', 'ApiKeyQueryAuth', 'apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/schedules/schedule_e/efile/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ScheduleEEfilePage',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def schedules_schedule_e_get(self, api_key, **kwargs):  # noqa: E501
        """schedules_schedule_e_get  # noqa: E501

         Schedule E covers the line item expenditures for independent expenditures. For example, if a super PAC bought ads on TV to oppose a federal candidate, each ad purchase would be recorded here with the expenditure amount, name and id of the candidate, and whether the ad supported or opposed the candidate.  An independent expenditure is an expenditure for a communication \"expressly advocating the election or defeat of a clearly identified candidate that is not made in cooperation, consultation, or concert with, or at the request or suggestion of, a candidate, a candidate’s authorized committee, or their agents, or a political party or its agents.\"  Aggregates by candidate do not include 24 and 48 hour reports. This ensures we don't double count expenditures and the totals are more accurate. You can still find the information from 24 and 48 hour reports in `/schedule/schedule_e/`.  Due to the large quantity of Schedule E filings, this endpoint is not paginated by page number. Instead, you can request the next page of results by adding the values in the `last_indexes` object from `pagination` to the URL of your last request. For example, when sorting by `expenditure_amount`, you might receive a page of results with the following pagination information:  ```  \"pagination\": {     \"count\": 152623,     \"last_indexes\": {       \"last_index\": \"3023037\",       \"last_expenditure_amount\": -17348.5     },     \"per_page\": 20,     \"pages\": 7632   } } ```  To fetch the next page of sorted results, append `last_index=3023037` and `last_expenditure_amount=` to the URL.  We strongly advise paging through these results by using the sort indices (defaults to sort by disbursement date, e.g. `last_disbursement_date`), otherwise some resources may be unintentionally filtered out.  This resource uses keyset pagination to improve query performance and these indices are required to properly page through this large dataset.  Note: because the Schedule E data includes many records, counts for large result sets are approximate; you will want to page through the records until no records are returned.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.schedules_schedule_e_get(api_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param str min_image_number:
        :param str sort: Provide a field to sort by. Use `-` for descending order.
        :param list[str] candidate_id:  A unique identifier assigned to each candidate registered with the FEC. If a person runs for several offices, that person will have separate candidate IDs for each office.
        :param int last_index: Index of last result from previous page
        :param date max_date: Maximum date
        :param list[str] filing_form: The form where the underlying data comes from, for example, Form 1 would appear as F1:     - F1   Statement of Organization     - F1M  Notification of Multicandidate Status     - F2   Statement of Candidacy     - F3   Report of Receipts and Disbursements for an Authorized Committee     - F3P  Report of Receipts and Disbursements by an Authorized Committee of a Candidate for     The Office of President or Vice President     - F3L  Report of Contributions Bundled by Lobbyists/Registrants and Lobbyist/Registrant PACs     - F3X  Report of Receipts and Disbursements for other than an Authorized Committee     - F4   Report of Receipts and Disbursements for a Committee or Organization Supporting a Nomination Convention     - F5   Report of Independent Expenditures Made and Contributions Received     - F6   48 Hour Notice of Contributions/Loans Received     - F7   Report of Communication Costs by Corporations and Membership Organizations     - F8   Debt Settlement Plan     - F9   24 Hour Notice of Disbursements for Electioneering Communications     - F13  Report of Donations Accepted for Inaugural Committee     - F99  Miscellaneous Text     - FRQ  Request for Additional Information
        :param bool most_recent:  The report associated with the transaction is either new or is the most-recently filed amendment. Undetermined version (`null`) is always included.
        :param date min_date: Minimum date
        :param str last_support_oppose_indicator:  When sorting by `support_oppose_indicator`, this is populated with the `support_oppose_indicator` of the last result. However, you will need to pass the index of that last result to `last_index` to get the next page.'
        :param list[str] image_number: The image number of the page where the schedule item is reported
        :param list[str] committee_id:  A unique identifier assigned to each committee or filer registered with the FEC. In general committee id's begin with the letter C which is followed by eight digits.
        :param str max_image_number:
        :param float last_office_total_ytd:  When sorting by `office_total_ytd`, this is populated with the `office_total_ytd` of the last result. However, you will need to pass the index of that last result to `last_index` to get the next page.'
        :param str line_number: Filter for form and line number using the following format: `FORM-LINENUMBER`.  For example an argument such as `F3X-16` would filter down to all entries from form `F3X` line number `16`.
        :param list[str] support_oppose_indicator: Explains if the money was spent in order to support or oppose a candidate or candidates. (Coded S or O for support or oppose.) This indicator applies to independent expenditures and communication costs.
        :param list[str] candidate_office: Federal office candidate runs for: H, S or P
        :param date last_expenditure_date:  When sorting by `expenditure_date`, this is populated with the `expenditure_date` of the last result. However, you will need to pass the index of that last result to `last_index` to get the next page.
        :param list[str] candidate_office_state: US state or territory
        :param float last_expenditure_amount:  When sorting by `expenditure_amount`, this is populated with the `expenditure_amount` of the last result. However, you will need to pass the index of that last result to `last_index` to get the next page.
        :param date min_filing_date:  Selects all filings received after this date
        :param date min_dissemination_date: Selects all items distributed by this committee after this date
        :param bool sort_nulls_last: Toggle that sorts null values last
        :param str min_amount: Filter for all amounts greater than a value.
        :param str max_amount: Filter for all amounts less than a value.
        :param list[bool] is_notice:  Record filed as 24- or 48-hour notice.
        :param date max_dissemination_date: Selects all items distributed by this committee before this date
        :param list[str] candidate_party: Three-letter code for the party affiliated with a candidate or committee. For example, DEM for Democratic Party and REP for Republican Party.
        :param bool sort_null_only: Toggle that filters out all rows having sort column that is non-null
        :param list[str] candidate_office_district: Two-digit US House distirict of the office the candidate is running for. Presidential, Senate and House at-large candidates will have District 00.
        :param int per_page: The number of results returned per page. Defaults to 20.
        :param bool sort_hide_null: Hide null values on sorted column(s).
        :param date max_filing_date:  Selects all filings received before this date
        :param list[int] cycle:  Filter records to only those that were applicable to a given two-year period.The cycle begins with an odd year and is named for its ending, even year.
        :param list[str] payee_name:  Name of the entity that received the payment.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: ScheduleEPage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.schedules_schedule_e_get_with_http_info(api_key, **kwargs)  # noqa: E501

    def schedules_schedule_e_get_with_http_info(self, api_key, **kwargs):  # noqa: E501
        """schedules_schedule_e_get  # noqa: E501

         Schedule E covers the line item expenditures for independent expenditures. For example, if a super PAC bought ads on TV to oppose a federal candidate, each ad purchase would be recorded here with the expenditure amount, name and id of the candidate, and whether the ad supported or opposed the candidate.  An independent expenditure is an expenditure for a communication \"expressly advocating the election or defeat of a clearly identified candidate that is not made in cooperation, consultation, or concert with, or at the request or suggestion of, a candidate, a candidate’s authorized committee, or their agents, or a political party or its agents.\"  Aggregates by candidate do not include 24 and 48 hour reports. This ensures we don't double count expenditures and the totals are more accurate. You can still find the information from 24 and 48 hour reports in `/schedule/schedule_e/`.  Due to the large quantity of Schedule E filings, this endpoint is not paginated by page number. Instead, you can request the next page of results by adding the values in the `last_indexes` object from `pagination` to the URL of your last request. For example, when sorting by `expenditure_amount`, you might receive a page of results with the following pagination information:  ```  \"pagination\": {     \"count\": 152623,     \"last_indexes\": {       \"last_index\": \"3023037\",       \"last_expenditure_amount\": -17348.5     },     \"per_page\": 20,     \"pages\": 7632   } } ```  To fetch the next page of sorted results, append `last_index=3023037` and `last_expenditure_amount=` to the URL.  We strongly advise paging through these results by using the sort indices (defaults to sort by disbursement date, e.g. `last_disbursement_date`), otherwise some resources may be unintentionally filtered out.  This resource uses keyset pagination to improve query performance and these indices are required to properly page through this large dataset.  Note: because the Schedule E data includes many records, counts for large result sets are approximate; you will want to page through the records until no records are returned.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.schedules_schedule_e_get_with_http_info(api_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param str min_image_number:
        :param str sort: Provide a field to sort by. Use `-` for descending order.
        :param list[str] candidate_id:  A unique identifier assigned to each candidate registered with the FEC. If a person runs for several offices, that person will have separate candidate IDs for each office.
        :param int last_index: Index of last result from previous page
        :param date max_date: Maximum date
        :param list[str] filing_form: The form where the underlying data comes from, for example, Form 1 would appear as F1:     - F1   Statement of Organization     - F1M  Notification of Multicandidate Status     - F2   Statement of Candidacy     - F3   Report of Receipts and Disbursements for an Authorized Committee     - F3P  Report of Receipts and Disbursements by an Authorized Committee of a Candidate for     The Office of President or Vice President     - F3L  Report of Contributions Bundled by Lobbyists/Registrants and Lobbyist/Registrant PACs     - F3X  Report of Receipts and Disbursements for other than an Authorized Committee     - F4   Report of Receipts and Disbursements for a Committee or Organization Supporting a Nomination Convention     - F5   Report of Independent Expenditures Made and Contributions Received     - F6   48 Hour Notice of Contributions/Loans Received     - F7   Report of Communication Costs by Corporations and Membership Organizations     - F8   Debt Settlement Plan     - F9   24 Hour Notice of Disbursements for Electioneering Communications     - F13  Report of Donations Accepted for Inaugural Committee     - F99  Miscellaneous Text     - FRQ  Request for Additional Information
        :param bool most_recent:  The report associated with the transaction is either new or is the most-recently filed amendment. Undetermined version (`null`) is always included.
        :param date min_date: Minimum date
        :param str last_support_oppose_indicator:  When sorting by `support_oppose_indicator`, this is populated with the `support_oppose_indicator` of the last result. However, you will need to pass the index of that last result to `last_index` to get the next page.'
        :param list[str] image_number: The image number of the page where the schedule item is reported
        :param list[str] committee_id:  A unique identifier assigned to each committee or filer registered with the FEC. In general committee id's begin with the letter C which is followed by eight digits.
        :param str max_image_number:
        :param float last_office_total_ytd:  When sorting by `office_total_ytd`, this is populated with the `office_total_ytd` of the last result. However, you will need to pass the index of that last result to `last_index` to get the next page.'
        :param str line_number: Filter for form and line number using the following format: `FORM-LINENUMBER`.  For example an argument such as `F3X-16` would filter down to all entries from form `F3X` line number `16`.
        :param list[str] support_oppose_indicator: Explains if the money was spent in order to support or oppose a candidate or candidates. (Coded S or O for support or oppose.) This indicator applies to independent expenditures and communication costs.
        :param list[str] candidate_office: Federal office candidate runs for: H, S or P
        :param date last_expenditure_date:  When sorting by `expenditure_date`, this is populated with the `expenditure_date` of the last result. However, you will need to pass the index of that last result to `last_index` to get the next page.
        :param list[str] candidate_office_state: US state or territory
        :param float last_expenditure_amount:  When sorting by `expenditure_amount`, this is populated with the `expenditure_amount` of the last result. However, you will need to pass the index of that last result to `last_index` to get the next page.
        :param date min_filing_date:  Selects all filings received after this date
        :param date min_dissemination_date: Selects all items distributed by this committee after this date
        :param bool sort_nulls_last: Toggle that sorts null values last
        :param str min_amount: Filter for all amounts greater than a value.
        :param str max_amount: Filter for all amounts less than a value.
        :param list[bool] is_notice:  Record filed as 24- or 48-hour notice.
        :param date max_dissemination_date: Selects all items distributed by this committee before this date
        :param list[str] candidate_party: Three-letter code for the party affiliated with a candidate or committee. For example, DEM for Democratic Party and REP for Republican Party.
        :param bool sort_null_only: Toggle that filters out all rows having sort column that is non-null
        :param list[str] candidate_office_district: Two-digit US House distirict of the office the candidate is running for. Presidential, Senate and House at-large candidates will have District 00.
        :param int per_page: The number of results returned per page. Defaults to 20.
        :param bool sort_hide_null: Hide null values on sorted column(s).
        :param date max_filing_date:  Selects all filings received before this date
        :param list[int] cycle:  Filter records to only those that were applicable to a given two-year period.The cycle begins with an odd year and is named for its ending, even year.
        :param list[str] payee_name:  Name of the entity that received the payment.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(ScheduleEPage, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'api_key',
            'min_image_number',
            'sort',
            'candidate_id',
            'last_index',
            'max_date',
            'filing_form',
            'most_recent',
            'min_date',
            'last_support_oppose_indicator',
            'image_number',
            'committee_id',
            'max_image_number',
            'last_office_total_ytd',
            'line_number',
            'support_oppose_indicator',
            'candidate_office',
            'last_expenditure_date',
            'candidate_office_state',
            'last_expenditure_amount',
            'min_filing_date',
            'min_dissemination_date',
            'sort_nulls_last',
            'min_amount',
            'max_amount',
            'is_notice',
            'max_dissemination_date',
            'candidate_party',
            'sort_null_only',
            'candidate_office_district',
            'per_page',
            'sort_hide_null',
            'max_filing_date',
            'cycle',
            'payee_name'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    ' to method schedules_schedule_e_get' % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'api_key' is set
        if self.api_client.client_side_validation and ('api_key' not in local_var_params or  # noqa: E501
                                                        local_var_params['api_key'] is None):  # noqa: E501
            raise ApiValueError('Missing the required parameter `api_key` when calling `schedules_schedule_e_get`')  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'min_image_number' in local_var_params and local_var_params['min_image_number'] is not None:  # noqa: E501
            query_params.append(('min_image_number', local_var_params['min_image_number']))  # noqa: E501
        if 'sort' in local_var_params and local_var_params['sort'] is not None:  # noqa: E501
            query_params.append(('sort', local_var_params['sort']))  # noqa: E501
        if 'candidate_id' in local_var_params and local_var_params['candidate_id'] is not None:  # noqa: E501
            query_params.append(('candidate_id', local_var_params['candidate_id']))  # noqa: E501
            collection_formats['candidate_id'] = 'multi'  # noqa: E501
        if 'last_index' in local_var_params and local_var_params['last_index'] is not None:  # noqa: E501
            query_params.append(('last_index', local_var_params['last_index']))  # noqa: E501
        if 'max_date' in local_var_params and local_var_params['max_date'] is not None:  # noqa: E501
            query_params.append(('max_date', local_var_params['max_date']))  # noqa: E501
        if 'filing_form' in local_var_params and local_var_params['filing_form'] is not None:  # noqa: E501
            query_params.append(('filing_form', local_var_params['filing_form']))  # noqa: E501
            collection_formats['filing_form'] = 'multi'  # noqa: E501
        if 'most_recent' in local_var_params and local_var_params['most_recent'] is not None:  # noqa: E501
            query_params.append(('most_recent', local_var_params['most_recent']))  # noqa: E501
        if 'min_date' in local_var_params and local_var_params['min_date'] is not None:  # noqa: E501
            query_params.append(('min_date', local_var_params['min_date']))  # noqa: E501
        if 'last_support_oppose_indicator' in local_var_params and local_var_params['last_support_oppose_indicator'] is not None:  # noqa: E501
            query_params.append(('last_support_oppose_indicator', local_var_params['last_support_oppose_indicator']))  # noqa: E501
        if 'image_number' in local_var_params and local_var_params['image_number'] is not None:  # noqa: E501
            query_params.append(('image_number', local_var_params['image_number']))  # noqa: E501
            collection_formats['image_number'] = 'multi'  # noqa: E501
        if 'committee_id' in local_var_params and local_var_params['committee_id'] is not None:  # noqa: E501
            query_params.append(('committee_id', local_var_params['committee_id']))  # noqa: E501
            collection_formats['committee_id'] = 'multi'  # noqa: E501
        if 'max_image_number' in local_var_params and local_var_params['max_image_number'] is not None:  # noqa: E501
            query_params.append(('max_image_number', local_var_params['max_image_number']))  # noqa: E501
        if 'last_office_total_ytd' in local_var_params and local_var_params['last_office_total_ytd'] is not None:  # noqa: E501
            query_params.append(('last_office_total_ytd', local_var_params['last_office_total_ytd']))  # noqa: E501
        if 'line_number' in local_var_params and local_var_params['line_number'] is not None:  # noqa: E501
            query_params.append(('line_number', local_var_params['line_number']))  # noqa: E501
        if 'support_oppose_indicator' in local_var_params and local_var_params['support_oppose_indicator'] is not None:  # noqa: E501
            query_params.append(('support_oppose_indicator', local_var_params['support_oppose_indicator']))  # noqa: E501
            collection_formats['support_oppose_indicator'] = 'multi'  # noqa: E501
        if 'candidate_office' in local_var_params and local_var_params['candidate_office'] is not None:  # noqa: E501
            query_params.append(('candidate_office', local_var_params['candidate_office']))  # noqa: E501
            collection_formats['candidate_office'] = 'multi'  # noqa: E501
        if 'last_expenditure_date' in local_var_params and local_var_params['last_expenditure_date'] is not None:  # noqa: E501
            query_params.append(('last_expenditure_date', local_var_params['last_expenditure_date']))  # noqa: E501
        if 'api_key' in local_var_params and local_var_params['api_key'] is not None:  # noqa: E501
            query_params.append(('api_key', local_var_params['api_key']))  # noqa: E501
        if 'candidate_office_state' in local_var_params and local_var_params['candidate_office_state'] is not None:  # noqa: E501
            query_params.append(('candidate_office_state', local_var_params['candidate_office_state']))  # noqa: E501
            collection_formats['candidate_office_state'] = 'multi'  # noqa: E501
        if 'last_expenditure_amount' in local_var_params and local_var_params['last_expenditure_amount'] is not None:  # noqa: E501
            query_params.append(('last_expenditure_amount', local_var_params['last_expenditure_amount']))  # noqa: E501
        if 'min_filing_date' in local_var_params and local_var_params['min_filing_date'] is not None:  # noqa: E501
            query_params.append(('min_filing_date', local_var_params['min_filing_date']))  # noqa: E501
        if 'min_dissemination_date' in local_var_params and local_var_params['min_dissemination_date'] is not None:  # noqa: E501
            query_params.append(('min_dissemination_date', local_var_params['min_dissemination_date']))  # noqa: E501
        if 'sort_nulls_last' in local_var_params and local_var_params['sort_nulls_last'] is not None:  # noqa: E501
            query_params.append(('sort_nulls_last', local_var_params['sort_nulls_last']))  # noqa: E501
        if 'min_amount' in local_var_params and local_var_params['min_amount'] is not None:  # noqa: E501
            query_params.append(('min_amount', local_var_params['min_amount']))  # noqa: E501
        if 'max_amount' in local_var_params and local_var_params['max_amount'] is not None:  # noqa: E501
            query_params.append(('max_amount', local_var_params['max_amount']))  # noqa: E501
        if 'is_notice' in local_var_params and local_var_params['is_notice'] is not None:  # noqa: E501
            query_params.append(('is_notice', local_var_params['is_notice']))  # noqa: E501
            collection_formats['is_notice'] = 'multi'  # noqa: E501
        if 'max_dissemination_date' in local_var_params and local_var_params['max_dissemination_date'] is not None:  # noqa: E501
            query_params.append(('max_dissemination_date', local_var_params['max_dissemination_date']))  # noqa: E501
        if 'candidate_party' in local_var_params and local_var_params['candidate_party'] is not None:  # noqa: E501
            query_params.append(('candidate_party', local_var_params['candidate_party']))  # noqa: E501
            collection_formats['candidate_party'] = 'multi'  # noqa: E501
        if 'sort_null_only' in local_var_params and local_var_params['sort_null_only'] is not None:  # noqa: E501
            query_params.append(('sort_null_only', local_var_params['sort_null_only']))  # noqa: E501
        if 'candidate_office_district' in local_var_params and local_var_params['candidate_office_district'] is not None:  # noqa: E501
            query_params.append(('candidate_office_district', local_var_params['candidate_office_district']))  # noqa: E501
            collection_formats['candidate_office_district'] = 'multi'  # noqa: E501
        if 'per_page' in local_var_params and local_var_params['per_page'] is not None:  # noqa: E501
            query_params.append(('per_page', local_var_params['per_page']))  # noqa: E501
        if 'sort_hide_null' in local_var_params and local_var_params['sort_hide_null'] is not None:  # noqa: E501
            query_params.append(('sort_hide_null', local_var_params['sort_hide_null']))  # noqa: E501
        if 'max_filing_date' in local_var_params and local_var_params['max_filing_date'] is not None:  # noqa: E501
            query_params.append(('max_filing_date', local_var_params['max_filing_date']))  # noqa: E501
        if 'cycle' in local_var_params and local_var_params['cycle'] is not None:  # noqa: E501
            query_params.append(('cycle', local_var_params['cycle']))  # noqa: E501
            collection_formats['cycle'] = 'multi'  # noqa: E501
        if 'payee_name' in local_var_params and local_var_params['payee_name'] is not None:  # noqa: E501
            query_params.append(('payee_name', local_var_params['payee_name']))  # noqa: E501
            collection_formats['payee_name'] = 'multi'  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyHeaderAuth', 'ApiKeyQueryAuth', 'apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/schedules/schedule_e/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ScheduleEPage',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def schedules_schedule_e_totals_by_candidate_get(self, api_key, **kwargs):  # noqa: E501
        """schedules_schedule_e_totals_by_candidate_get  # noqa: E501

         Total independent expenditure on supported or opposed candidates by cycle or candidate election year.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.schedules_schedule_e_totals_by_candidate_get(api_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param bool election_full: `True` indicates that full election period of a candidate. `False` indicates that two year election cycle.
        :param str sort: Provide a field to sort by. Use `-` for descending order.
        :param list[str] candidate_id:  A unique identifier assigned to each candidate registered with the FEC. If a person runs for several offices, that person will have separate candidate IDs for each office.
        :param bool sort_hide_null: Hide null values on sorted column(s).
        :param int per_page: The number of results returned per page. Defaults to 20.
        :param bool sort_nulls_last: Toggle that sorts null values last
        :param list[int] cycle:  Filter records to only those that were applicable to a given two-year period.The cycle begins with an odd year and is named for its ending, even year.
        :param int page: For paginating through results, starting at page 1
        :param bool sort_null_only: Toggle that filters out all rows having sort column that is non-null
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: IETotalsByCandidatePage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.schedules_schedule_e_totals_by_candidate_get_with_http_info(api_key, **kwargs)  # noqa: E501

    def schedules_schedule_e_totals_by_candidate_get_with_http_info(self, api_key, **kwargs):  # noqa: E501
        """schedules_schedule_e_totals_by_candidate_get  # noqa: E501

         Total independent expenditure on supported or opposed candidates by cycle or candidate election year.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.schedules_schedule_e_totals_by_candidate_get_with_http_info(api_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param bool election_full: `True` indicates that full election period of a candidate. `False` indicates that two year election cycle.
        :param str sort: Provide a field to sort by. Use `-` for descending order.
        :param list[str] candidate_id:  A unique identifier assigned to each candidate registered with the FEC. If a person runs for several offices, that person will have separate candidate IDs for each office.
        :param bool sort_hide_null: Hide null values on sorted column(s).
        :param int per_page: The number of results returned per page. Defaults to 20.
        :param bool sort_nulls_last: Toggle that sorts null values last
        :param list[int] cycle:  Filter records to only those that were applicable to a given two-year period.The cycle begins with an odd year and is named for its ending, even year.
        :param int page: For paginating through results, starting at page 1
        :param bool sort_null_only: Toggle that filters out all rows having sort column that is non-null
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(IETotalsByCandidatePage, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'api_key',
            'election_full',
            'sort',
            'candidate_id',
            'sort_hide_null',
            'per_page',
            'sort_nulls_last',
            'cycle',
            'page',
            'sort_null_only'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    ' to method schedules_schedule_e_totals_by_candidate_get' % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'api_key' is set
        if self.api_client.client_side_validation and ('api_key' not in local_var_params or  # noqa: E501
                                                        local_var_params['api_key'] is None):  # noqa: E501
            raise ApiValueError('Missing the required parameter `api_key` when calling `schedules_schedule_e_totals_by_candidate_get`')  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'election_full' in local_var_params and local_var_params['election_full'] is not None:  # noqa: E501
            query_params.append(('election_full', local_var_params['election_full']))  # noqa: E501
        if 'api_key' in local_var_params and local_var_params['api_key'] is not None:  # noqa: E501
            query_params.append(('api_key', local_var_params['api_key']))  # noqa: E501
        if 'sort' in local_var_params and local_var_params['sort'] is not None:  # noqa: E501
            query_params.append(('sort', local_var_params['sort']))  # noqa: E501
        if 'candidate_id' in local_var_params and local_var_params['candidate_id'] is not None:  # noqa: E501
            query_params.append(('candidate_id', local_var_params['candidate_id']))  # noqa: E501
            collection_formats['candidate_id'] = 'multi'  # noqa: E501
        if 'sort_hide_null' in local_var_params and local_var_params['sort_hide_null'] is not None:  # noqa: E501
            query_params.append(('sort_hide_null', local_var_params['sort_hide_null']))  # noqa: E501
        if 'per_page' in local_var_params and local_var_params['per_page'] is not None:  # noqa: E501
            query_params.append(('per_page', local_var_params['per_page']))  # noqa: E501
        if 'sort_nulls_last' in local_var_params and local_var_params['sort_nulls_last'] is not None:  # noqa: E501
            query_params.append(('sort_nulls_last', local_var_params['sort_nulls_last']))  # noqa: E501
        if 'cycle' in local_var_params and local_var_params['cycle'] is not None:  # noqa: E501
            query_params.append(('cycle', local_var_params['cycle']))  # noqa: E501
            collection_formats['cycle'] = 'multi'  # noqa: E501
        if 'page' in local_var_params and local_var_params['page'] is not None:  # noqa: E501
            query_params.append(('page', local_var_params['page']))  # noqa: E501
        if 'sort_null_only' in local_var_params and local_var_params['sort_null_only'] is not None:  # noqa: E501
            query_params.append(('sort_null_only', local_var_params['sort_null_only']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyHeaderAuth', 'ApiKeyQueryAuth', 'apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/schedules/schedule_e/totals/by_candidate/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='IETotalsByCandidatePage',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
