# coding: utf-8

"""
    OpenFEC

    This API allows you to explore the way candidates and committees fund their campaigns.    The FEC API is a RESTful web service supporting full-text and field-specific searches on FEC data. [Bulk downloads](https://www.fec.gov/data/advanced/?tab=bulk-data) are available on the current site. Information is tied to the underlying forms by file ID and image ID. Data is updated nightly.    There is a lot of data, but a good place to start is to use search to find interesting candidates and committees. Then, you can use their IDs to find report or line item details with the other endpoints. If you are interested in individual donors, check out contributor information in schedule_a.    Get an [API key here](https://api.data.gov/signup/). That will enable you to place up to 1,000 calls an hour. Each call is limited to 100 results per page. You can email questions, comments or a request to get a key for 120 calls per minute to [APIinfo@fec.gov](mailto:apiinfo@fec.gov). You can also ask questions and discuss the data in the [FEC data Google Group](https://groups.google.com/forum/#!forum/fec-data). API changes will also be added to this group in advance of the change.    The model definitions and schema are available at [/swagger](/swagger/). This is useful for making wrappers and exploring the data.    A few restrictions limit the way you can use FEC data. For example, you can’t use contributor lists for commercial purposes or to solicit donations. [Learn more here](https://www.fec.gov/updates/sale-or-use-contributor-information/).    [View our source code](https://github.com/fecgov/openFEC). We welcome issues and pull requests!  # noqa: E501

    The version of the OpenAPI document: 1.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from openfec_sdk.api_client import ApiClient
from openfec_sdk.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class LegalApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def legal_search_get(self, api_key, **kwargs):  # noqa: E501
        """legal_search_get  # noqa: E501

         Search legal documents by type, or across all document types using keywords, parameter values and ranges.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.legal_search_get(api_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param str af_committee_id: Admin fine committee ID
        :param str ao_status: Status of AO (pending, withdrawn, or final)
        :param list[int] ao_requestor_type: Code of the advisory opinion requestor type.
        :param str q: Text to search legal documents for.
        :param date case_max_open_date: Filter cases by latest date opened
        :param date ao_min_issue_date: Earliest issue date of advisory opinion
        :param list[str] ao_no: Force advisory opinion number
        :param int hits_returned: Number of results to return (max 10).
        :param list[str] case_document_category: Filter cases by category of associated documents
        :param int af_fd_fine_amount: Filter cases by Final Determination fine amount
        :param list[str] case_no: Enforcement matter case number
        :param int case_election_cycles: Filter cases by election cycles
        :param bool ao_is_pending: AO is pending
        :param str ao_requestor: The requestor of the advisory opinion
        :param date case_max_close_date: Filter cases by latest date closed
        :param str case_respondents: Filter cases by respondents
        :param list[str] ao_statutory_citation: Search for statutory citations
        :param int from_hit: Get results starting from this index.
        :param date af_min_rtb_date: Filter cases by earliest Reason to Believe date
        :param date ao_max_request_date: Latest request date of advisory opinion
        :param date af_max_rtb_date: Filter cases by latest Reason to Believe date
        :param bool ao_citation_require_all: Require all citations to be in document (default behavior is any)
        :param date ao_min_request_date: Earliest request date of advisory opinion
        :param list[str] af_name: Admin fine committee name
        :param list[str] ao_category: Category of the document
        :param date af_min_fd_date: Filter cases by earliest Final Determination date
        :param list[str] ao_entity_name: Search by name of commenter or representative
        :param str af_report_year: Admin fine report year
        :param str type: Document type to refine search by
        :param date af_max_fd_date: Filter cases by latest Final Determination date
        :param list[str] ao_regulatory_citation: Search for regulatory citations
        :param date case_min_open_date: Filter cases by earliest date opened
        :param int af_rtb_fine_amount: Filter cases by Reason to Believe fine amount
        :param list[str] ao_name: Force advisory opinion name
        :param date case_min_close_date: Filter cases by earliest date closed
        :param list[str] case_dispositions: Filter cases by dispositions
        :param date ao_max_issue_date: Latest issue date of advisory opinion
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: InlineResponseDefault1
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.legal_search_get_with_http_info(api_key, **kwargs)  # noqa: E501

    def legal_search_get_with_http_info(self, api_key, **kwargs):  # noqa: E501
        """legal_search_get  # noqa: E501

         Search legal documents by type, or across all document types using keywords, parameter values and ranges.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.legal_search_get_with_http_info(api_key, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str api_key:  API key for https://api.data.gov. Get one at https://api.data.gov/signup.  (required)
        :param str af_committee_id: Admin fine committee ID
        :param str ao_status: Status of AO (pending, withdrawn, or final)
        :param list[int] ao_requestor_type: Code of the advisory opinion requestor type.
        :param str q: Text to search legal documents for.
        :param date case_max_open_date: Filter cases by latest date opened
        :param date ao_min_issue_date: Earliest issue date of advisory opinion
        :param list[str] ao_no: Force advisory opinion number
        :param int hits_returned: Number of results to return (max 10).
        :param list[str] case_document_category: Filter cases by category of associated documents
        :param int af_fd_fine_amount: Filter cases by Final Determination fine amount
        :param list[str] case_no: Enforcement matter case number
        :param int case_election_cycles: Filter cases by election cycles
        :param bool ao_is_pending: AO is pending
        :param str ao_requestor: The requestor of the advisory opinion
        :param date case_max_close_date: Filter cases by latest date closed
        :param str case_respondents: Filter cases by respondents
        :param list[str] ao_statutory_citation: Search for statutory citations
        :param int from_hit: Get results starting from this index.
        :param date af_min_rtb_date: Filter cases by earliest Reason to Believe date
        :param date ao_max_request_date: Latest request date of advisory opinion
        :param date af_max_rtb_date: Filter cases by latest Reason to Believe date
        :param bool ao_citation_require_all: Require all citations to be in document (default behavior is any)
        :param date ao_min_request_date: Earliest request date of advisory opinion
        :param list[str] af_name: Admin fine committee name
        :param list[str] ao_category: Category of the document
        :param date af_min_fd_date: Filter cases by earliest Final Determination date
        :param list[str] ao_entity_name: Search by name of commenter or representative
        :param str af_report_year: Admin fine report year
        :param str type: Document type to refine search by
        :param date af_max_fd_date: Filter cases by latest Final Determination date
        :param list[str] ao_regulatory_citation: Search for regulatory citations
        :param date case_min_open_date: Filter cases by earliest date opened
        :param int af_rtb_fine_amount: Filter cases by Reason to Believe fine amount
        :param list[str] ao_name: Force advisory opinion name
        :param date case_min_close_date: Filter cases by earliest date closed
        :param list[str] case_dispositions: Filter cases by dispositions
        :param date ao_max_issue_date: Latest issue date of advisory opinion
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(InlineResponseDefault1, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'api_key',
            'af_committee_id',
            'ao_status',
            'ao_requestor_type',
            'q',
            'case_max_open_date',
            'ao_min_issue_date',
            'ao_no',
            'hits_returned',
            'case_document_category',
            'af_fd_fine_amount',
            'case_no',
            'case_election_cycles',
            'ao_is_pending',
            'ao_requestor',
            'case_max_close_date',
            'case_respondents',
            'ao_statutory_citation',
            'from_hit',
            'af_min_rtb_date',
            'ao_max_request_date',
            'af_max_rtb_date',
            'ao_citation_require_all',
            'ao_min_request_date',
            'af_name',
            'ao_category',
            'af_min_fd_date',
            'ao_entity_name',
            'af_report_year',
            'type',
            'af_max_fd_date',
            'ao_regulatory_citation',
            'case_min_open_date',
            'af_rtb_fine_amount',
            'ao_name',
            'case_min_close_date',
            'case_dispositions',
            'ao_max_issue_date'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    ' to method legal_search_get' % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'api_key' is set
        if self.api_client.client_side_validation and ('api_key' not in local_var_params or  # noqa: E501
                                                        local_var_params['api_key'] is None):  # noqa: E501
            raise ApiValueError('Missing the required parameter `api_key` when calling `legal_search_get`')  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'af_committee_id' in local_var_params and local_var_params['af_committee_id'] is not None:  # noqa: E501
            query_params.append(('af_committee_id', local_var_params['af_committee_id']))  # noqa: E501
        if 'ao_status' in local_var_params and local_var_params['ao_status'] is not None:  # noqa: E501
            query_params.append(('ao_status', local_var_params['ao_status']))  # noqa: E501
        if 'ao_requestor_type' in local_var_params and local_var_params['ao_requestor_type'] is not None:  # noqa: E501
            query_params.append(('ao_requestor_type', local_var_params['ao_requestor_type']))  # noqa: E501
            collection_formats['ao_requestor_type'] = 'multi'  # noqa: E501
        if 'q' in local_var_params and local_var_params['q'] is not None:  # noqa: E501
            query_params.append(('q', local_var_params['q']))  # noqa: E501
        if 'case_max_open_date' in local_var_params and local_var_params['case_max_open_date'] is not None:  # noqa: E501
            query_params.append(('case_max_open_date', local_var_params['case_max_open_date']))  # noqa: E501
        if 'ao_min_issue_date' in local_var_params and local_var_params['ao_min_issue_date'] is not None:  # noqa: E501
            query_params.append(('ao_min_issue_date', local_var_params['ao_min_issue_date']))  # noqa: E501
        if 'ao_no' in local_var_params and local_var_params['ao_no'] is not None:  # noqa: E501
            query_params.append(('ao_no', local_var_params['ao_no']))  # noqa: E501
            collection_formats['ao_no'] = 'multi'  # noqa: E501
        if 'hits_returned' in local_var_params and local_var_params['hits_returned'] is not None:  # noqa: E501
            query_params.append(('hits_returned', local_var_params['hits_returned']))  # noqa: E501
        if 'case_document_category' in local_var_params and local_var_params['case_document_category'] is not None:  # noqa: E501
            query_params.append(('case_document_category', local_var_params['case_document_category']))  # noqa: E501
            collection_formats['case_document_category'] = 'multi'  # noqa: E501
        if 'af_fd_fine_amount' in local_var_params and local_var_params['af_fd_fine_amount'] is not None:  # noqa: E501
            query_params.append(('af_fd_fine_amount', local_var_params['af_fd_fine_amount']))  # noqa: E501
        if 'case_no' in local_var_params and local_var_params['case_no'] is not None:  # noqa: E501
            query_params.append(('case_no', local_var_params['case_no']))  # noqa: E501
            collection_formats['case_no'] = 'multi'  # noqa: E501
        if 'case_election_cycles' in local_var_params and local_var_params['case_election_cycles'] is not None:  # noqa: E501
            query_params.append(('case_election_cycles', local_var_params['case_election_cycles']))  # noqa: E501
        if 'ao_is_pending' in local_var_params and local_var_params['ao_is_pending'] is not None:  # noqa: E501
            query_params.append(('ao_is_pending', local_var_params['ao_is_pending']))  # noqa: E501
        if 'ao_requestor' in local_var_params and local_var_params['ao_requestor'] is not None:  # noqa: E501
            query_params.append(('ao_requestor', local_var_params['ao_requestor']))  # noqa: E501
        if 'case_max_close_date' in local_var_params and local_var_params['case_max_close_date'] is not None:  # noqa: E501
            query_params.append(('case_max_close_date', local_var_params['case_max_close_date']))  # noqa: E501
        if 'case_respondents' in local_var_params and local_var_params['case_respondents'] is not None:  # noqa: E501
            query_params.append(('case_respondents', local_var_params['case_respondents']))  # noqa: E501
        if 'ao_statutory_citation' in local_var_params and local_var_params['ao_statutory_citation'] is not None:  # noqa: E501
            query_params.append(('ao_statutory_citation', local_var_params['ao_statutory_citation']))  # noqa: E501
            collection_formats['ao_statutory_citation'] = 'multi'  # noqa: E501
        if 'from_hit' in local_var_params and local_var_params['from_hit'] is not None:  # noqa: E501
            query_params.append(('from_hit', local_var_params['from_hit']))  # noqa: E501
        if 'af_min_rtb_date' in local_var_params and local_var_params['af_min_rtb_date'] is not None:  # noqa: E501
            query_params.append(('af_min_rtb_date', local_var_params['af_min_rtb_date']))  # noqa: E501
        if 'ao_max_request_date' in local_var_params and local_var_params['ao_max_request_date'] is not None:  # noqa: E501
            query_params.append(('ao_max_request_date', local_var_params['ao_max_request_date']))  # noqa: E501
        if 'api_key' in local_var_params and local_var_params['api_key'] is not None:  # noqa: E501
            query_params.append(('api_key', local_var_params['api_key']))  # noqa: E501
        if 'af_max_rtb_date' in local_var_params and local_var_params['af_max_rtb_date'] is not None:  # noqa: E501
            query_params.append(('af_max_rtb_date', local_var_params['af_max_rtb_date']))  # noqa: E501
        if 'ao_citation_require_all' in local_var_params and local_var_params['ao_citation_require_all'] is not None:  # noqa: E501
            query_params.append(('ao_citation_require_all', local_var_params['ao_citation_require_all']))  # noqa: E501
        if 'ao_min_request_date' in local_var_params and local_var_params['ao_min_request_date'] is not None:  # noqa: E501
            query_params.append(('ao_min_request_date', local_var_params['ao_min_request_date']))  # noqa: E501
        if 'af_name' in local_var_params and local_var_params['af_name'] is not None:  # noqa: E501
            query_params.append(('af_name', local_var_params['af_name']))  # noqa: E501
            collection_formats['af_name'] = 'multi'  # noqa: E501
        if 'ao_category' in local_var_params and local_var_params['ao_category'] is not None:  # noqa: E501
            query_params.append(('ao_category', local_var_params['ao_category']))  # noqa: E501
            collection_formats['ao_category'] = 'multi'  # noqa: E501
        if 'af_min_fd_date' in local_var_params and local_var_params['af_min_fd_date'] is not None:  # noqa: E501
            query_params.append(('af_min_fd_date', local_var_params['af_min_fd_date']))  # noqa: E501
        if 'ao_entity_name' in local_var_params and local_var_params['ao_entity_name'] is not None:  # noqa: E501
            query_params.append(('ao_entity_name', local_var_params['ao_entity_name']))  # noqa: E501
            collection_formats['ao_entity_name'] = 'multi'  # noqa: E501
        if 'af_report_year' in local_var_params and local_var_params['af_report_year'] is not None:  # noqa: E501
            query_params.append(('af_report_year', local_var_params['af_report_year']))  # noqa: E501
        if 'type' in local_var_params and local_var_params['type'] is not None:  # noqa: E501
            query_params.append(('type', local_var_params['type']))  # noqa: E501
        if 'af_max_fd_date' in local_var_params and local_var_params['af_max_fd_date'] is not None:  # noqa: E501
            query_params.append(('af_max_fd_date', local_var_params['af_max_fd_date']))  # noqa: E501
        if 'ao_regulatory_citation' in local_var_params and local_var_params['ao_regulatory_citation'] is not None:  # noqa: E501
            query_params.append(('ao_regulatory_citation', local_var_params['ao_regulatory_citation']))  # noqa: E501
            collection_formats['ao_regulatory_citation'] = 'multi'  # noqa: E501
        if 'case_min_open_date' in local_var_params and local_var_params['case_min_open_date'] is not None:  # noqa: E501
            query_params.append(('case_min_open_date', local_var_params['case_min_open_date']))  # noqa: E501
        if 'af_rtb_fine_amount' in local_var_params and local_var_params['af_rtb_fine_amount'] is not None:  # noqa: E501
            query_params.append(('af_rtb_fine_amount', local_var_params['af_rtb_fine_amount']))  # noqa: E501
        if 'ao_name' in local_var_params and local_var_params['ao_name'] is not None:  # noqa: E501
            query_params.append(('ao_name', local_var_params['ao_name']))  # noqa: E501
            collection_formats['ao_name'] = 'multi'  # noqa: E501
        if 'case_min_close_date' in local_var_params and local_var_params['case_min_close_date'] is not None:  # noqa: E501
            query_params.append(('case_min_close_date', local_var_params['case_min_close_date']))  # noqa: E501
        if 'case_dispositions' in local_var_params and local_var_params['case_dispositions'] is not None:  # noqa: E501
            query_params.append(('case_dispositions', local_var_params['case_dispositions']))  # noqa: E501
            collection_formats['case_dispositions'] = 'multi'  # noqa: E501
        if 'ao_max_issue_date' in local_var_params and local_var_params['ao_max_issue_date'] is not None:  # noqa: E501
            query_params.append(('ao_max_issue_date', local_var_params['ao_max_issue_date']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['ApiKeyHeaderAuth', 'ApiKeyQueryAuth', 'apiKey']  # noqa: E501

        return self.api_client.call_api(
            '/legal/search/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InlineResponseDefault1',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
