# EmbyAPI
Explore the Emby Server API

This Python package is automatically generated by the [Swagger Codegen](https://github.com/swagger-api/swagger-codegen) project:

- API version: 4.1.1.0
- Package version: 4.1.1.0
- Build package: io.swagger.codegen.v3.generators.python.PythonClientCodegen
For more information, please visit [https://emby.media/community/index.php?/forum/47-developer-api](https://emby.media/community/index.php?/forum/47-developer-api)

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on Github, you can install directly from Github

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import embyapi 
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import embyapi
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function
import time
import embyapi
from embyapi.rest import ApiException
from pprint import pprint

# Configure API key authorization: apikeyauth
configuration = embyapi.Configuration()
configuration.api_key['api_key'] = 'YOUR_API_KEY'
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['api_key'] = 'Bearer'

# create an instance of the API class
api_instance = embyapi.ActivityLogServiceApi(embyapi.ApiClient(configuration))
start_index = 56 # int | Optional. The record index to start at. All items with a lower index will be dropped from the results. (optional)
limit = 56 # int | Optional. The maximum number of records to return (optional)
min_date = 'min_date_example' # str | Optional. The minimum date. Format = ISO (optional)

try:
    # Gets activity log entries
    api_response = api_instance.get_system_activitylog_entries(start_index=start_index, limit=limit, min_date=min_date)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling ActivityLogServiceApi->get_system_activitylog_entries: %s\n" % e)
```

## Documentation for API Endpoints

All URIs are relative to *https://home.ourflix.de:32865/emby*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*ActivityLogServiceApi* | [**get_system_activitylog_entries**](docs/ActivityLogServiceApi.md#get_system_activitylog_entries) | **GET** /System/ActivityLog/Entries | Gets activity log entries
*ArtistsServiceApi* | [**get_artists**](docs/ArtistsServiceApi.md#get_artists) | **GET** /Artists | Gets all artists from a given item, folder, or the entire library
*ArtistsServiceApi* | [**get_artists_albumartists**](docs/ArtistsServiceApi.md#get_artists_albumartists) | **GET** /Artists/AlbumArtists | Gets all album artists from a given item, folder, or the entire library
*ArtistsServiceApi* | [**get_artists_by_name**](docs/ArtistsServiceApi.md#get_artists_by_name) | **GET** /Artists/{Name} | Gets an artist, by name
*AudioServiceApi* | [**get_audio_by_id_by_container**](docs/AudioServiceApi.md#get_audio_by_id_by_container) | **GET** /Audio/{Id}/stream.{Container} | Gets an audio stream
*AudioServiceApi* | [**get_audio_by_id_stream**](docs/AudioServiceApi.md#get_audio_by_id_stream) | **GET** /Audio/{Id}/stream | Gets an audio stream
*AudioServiceApi* | [**head_audio_by_id_by_container**](docs/AudioServiceApi.md#head_audio_by_id_by_container) | **HEAD** /Audio/{Id}/stream.{Container} | Gets an audio stream
*AudioServiceApi* | [**head_audio_by_id_stream**](docs/AudioServiceApi.md#head_audio_by_id_stream) | **HEAD** /Audio/{Id}/stream | Gets an audio stream
*BifServiceApi* | [**get_items_by_id_thumbnailset**](docs/BifServiceApi.md#get_items_by_id_thumbnailset) | **GET** /Items/{Id}/ThumbnailSet | 
*BifServiceApi* | [**get_videos_by_id_index_bif**](docs/BifServiceApi.md#get_videos_by_id_index_bif) | **GET** /Videos/{Id}/index.bif | 
*BrandingServiceApi* | [**get_branding_configuration**](docs/BrandingServiceApi.md#get_branding_configuration) | **GET** /Branding/Configuration | Gets branding configuration
*BrandingServiceApi* | [**get_branding_css**](docs/BrandingServiceApi.md#get_branding_css) | **GET** /Branding/Css | Gets custom css
*BrandingServiceApi* | [**get_branding_css_css**](docs/BrandingServiceApi.md#get_branding_css_css) | **GET** /Branding/Css.css | Gets custom css
*ChannelServiceApi* | [**get_channels**](docs/ChannelServiceApi.md#get_channels) | **GET** /Channels | Gets available channels
*ChannelServiceApi* | [**get_channels_by_id_items**](docs/ChannelServiceApi.md#get_channels_by_id_items) | **GET** /Channels/{Id}/Items | Gets channel items
*ChannelServiceApi* | [**get_channels_items_latest**](docs/ChannelServiceApi.md#get_channels_items_latest) | **GET** /Channels/Items/Latest | Gets channel items
*CollectionServiceApi* | [**delete_collections_by_id_items**](docs/CollectionServiceApi.md#delete_collections_by_id_items) | **DELETE** /Collections/{Id}/Items | Removes items from a collection
*CollectionServiceApi* | [**post_collections**](docs/CollectionServiceApi.md#post_collections) | **POST** /Collections | Creates a new collection
*CollectionServiceApi* | [**post_collections_by_id_items**](docs/CollectionServiceApi.md#post_collections_by_id_items) | **POST** /Collections/{Id}/Items | Adds items to a collection
*ConfigurationServiceApi* | [**get_system_configuration**](docs/ConfigurationServiceApi.md#get_system_configuration) | **GET** /System/Configuration | Gets application configuration
*ConfigurationServiceApi* | [**get_system_configuration_by_key**](docs/ConfigurationServiceApi.md#get_system_configuration_by_key) | **GET** /System/Configuration/{Key} | Gets a named configuration
*ConfigurationServiceApi* | [**post_system_configuration**](docs/ConfigurationServiceApi.md#post_system_configuration) | **POST** /System/Configuration | Updates application configuration
*ConfigurationServiceApi* | [**post_system_configuration_by_key**](docs/ConfigurationServiceApi.md#post_system_configuration_by_key) | **POST** /System/Configuration/{Key} | Updates named configuration
*ConnectServiceApi* | [**delete_users_by_id_connect_link**](docs/ConnectServiceApi.md#delete_users_by_id_connect_link) | **DELETE** /Users/{Id}/Connect/Link | Removes a Connect link for a user
*ConnectServiceApi* | [**get_connect_exchange**](docs/ConnectServiceApi.md#get_connect_exchange) | **GET** /Connect/Exchange | Gets the corresponding local user from a connect user id
*ConnectServiceApi* | [**get_connect_pending**](docs/ConnectServiceApi.md#get_connect_pending) | **GET** /Connect/Pending | Creates a Connect link for a user
*ConnectServiceApi* | [**post_users_by_id_connect_link**](docs/ConnectServiceApi.md#post_users_by_id_connect_link) | **POST** /Users/{Id}/Connect/Link | Creates a Connect link for a user
*DashboardServiceApi* | [**get_web_configurationpage**](docs/DashboardServiceApi.md#get_web_configurationpage) | **GET** /web/ConfigurationPage | 
*DashboardServiceApi* | [**get_web_configurationpages**](docs/DashboardServiceApi.md#get_web_configurationpages) | **GET** /web/ConfigurationPages | 
*DeviceServiceApi* | [**delete_devices**](docs/DeviceServiceApi.md#delete_devices) | **DELETE** /Devices | Deletes a device
*DeviceServiceApi* | [**get_devices**](docs/DeviceServiceApi.md#get_devices) | **GET** /Devices | Gets all devices
*DeviceServiceApi* | [**get_devices_camerauploads**](docs/DeviceServiceApi.md#get_devices_camerauploads) | **GET** /Devices/CameraUploads | Gets camera upload history for a device
*DeviceServiceApi* | [**get_devices_info**](docs/DeviceServiceApi.md#get_devices_info) | **GET** /Devices/Info | Gets info for a device
*DeviceServiceApi* | [**get_devices_options**](docs/DeviceServiceApi.md#get_devices_options) | **GET** /Devices/Options | Gets options for a device
*DeviceServiceApi* | [**post_devices_camerauploads**](docs/DeviceServiceApi.md#post_devices_camerauploads) | **POST** /Devices/CameraUploads | Uploads content
*DeviceServiceApi* | [**post_devices_options**](docs/DeviceServiceApi.md#post_devices_options) | **POST** /Devices/Options | Updates device options
*DisplayPreferencesServiceApi* | [**get_displaypreferences_by_id**](docs/DisplayPreferencesServiceApi.md#get_displaypreferences_by_id) | **GET** /DisplayPreferences/{Id} | Gets a user&#x27;s display preferences for an item
*DisplayPreferencesServiceApi* | [**post_displaypreferences_by_displaypreferencesid**](docs/DisplayPreferencesServiceApi.md#post_displaypreferences_by_displaypreferencesid) | **POST** /DisplayPreferences/{DisplayPreferencesId} | Updates a user&#x27;s display preferences for an item
*DlnaServerServiceApi* | [**get_dlna_by_uuid_connectionmanager_connectionmanager**](docs/DlnaServerServiceApi.md#get_dlna_by_uuid_connectionmanager_connectionmanager) | **GET** /Dlna/{UuId}/connectionmanager/connectionmanager | Gets dlna connection manager xml
*DlnaServerServiceApi* | [**get_dlna_by_uuid_connectionmanager_connectionmanager_xml**](docs/DlnaServerServiceApi.md#get_dlna_by_uuid_connectionmanager_connectionmanager_xml) | **GET** /Dlna/{UuId}/connectionmanager/connectionmanager.xml | Gets dlna connection manager xml
*DlnaServerServiceApi* | [**get_dlna_by_uuid_contentdirectory_contentdirectory**](docs/DlnaServerServiceApi.md#get_dlna_by_uuid_contentdirectory_contentdirectory) | **GET** /Dlna/{UuId}/contentdirectory/contentdirectory | Gets dlna content directory xml
*DlnaServerServiceApi* | [**get_dlna_by_uuid_contentdirectory_contentdirectory_xml**](docs/DlnaServerServiceApi.md#get_dlna_by_uuid_contentdirectory_contentdirectory_xml) | **GET** /Dlna/{UuId}/contentdirectory/contentdirectory.xml | Gets dlna content directory xml
*DlnaServerServiceApi* | [**get_dlna_by_uuid_description**](docs/DlnaServerServiceApi.md#get_dlna_by_uuid_description) | **GET** /Dlna/{UuId}/description | Gets dlna server info
*DlnaServerServiceApi* | [**get_dlna_by_uuid_description_xml**](docs/DlnaServerServiceApi.md#get_dlna_by_uuid_description_xml) | **GET** /Dlna/{UuId}/description.xml | Gets dlna server info
*DlnaServerServiceApi* | [**get_dlna_by_uuid_icons_by_filename**](docs/DlnaServerServiceApi.md#get_dlna_by_uuid_icons_by_filename) | **GET** /Dlna/{UuId}/icons/{Filename} | Gets a server icon
*DlnaServerServiceApi* | [**get_dlna_icons_by_filename**](docs/DlnaServerServiceApi.md#get_dlna_icons_by_filename) | **GET** /Dlna/icons/{Filename} | Gets a server icon
*DlnaServerServiceApi* | [**post_dlna_by_uuid_connectionmanager_control**](docs/DlnaServerServiceApi.md#post_dlna_by_uuid_connectionmanager_control) | **POST** /Dlna/{UuId}/connectionmanager/control | Processes a control request
*DlnaServerServiceApi* | [**post_dlna_by_uuid_contentdirectory_control**](docs/DlnaServerServiceApi.md#post_dlna_by_uuid_contentdirectory_control) | **POST** /Dlna/{UuId}/contentdirectory/control | Processes a control request
*DlnaServiceApi* | [**delete_dlna_profiles_by_id**](docs/DlnaServiceApi.md#delete_dlna_profiles_by_id) | **DELETE** /Dlna/Profiles/{Id} | Deletes a profile
*DlnaServiceApi* | [**get_dlna_profileinfos**](docs/DlnaServiceApi.md#get_dlna_profileinfos) | **GET** /Dlna/ProfileInfos | Gets a list of profiles
*DlnaServiceApi* | [**get_dlna_profiles_by_id**](docs/DlnaServiceApi.md#get_dlna_profiles_by_id) | **GET** /Dlna/Profiles/{Id} | Gets a single profile
*DlnaServiceApi* | [**get_dlna_profiles_default**](docs/DlnaServiceApi.md#get_dlna_profiles_default) | **GET** /Dlna/Profiles/Default | Gets the default profile
*DlnaServiceApi* | [**post_dlna_profiles**](docs/DlnaServiceApi.md#post_dlna_profiles) | **POST** /Dlna/Profiles | Creates a profile
*DlnaServiceApi* | [**post_dlna_profiles_by_id**](docs/DlnaServiceApi.md#post_dlna_profiles_by_id) | **POST** /Dlna/Profiles/{Id} | Updates a profile
*DynamicHlsServiceApi* | [**get_audio_by_id_hls1_by_playlistid_by_segmentid_by_segmentcontainer**](docs/DynamicHlsServiceApi.md#get_audio_by_id_hls1_by_playlistid_by_segmentid_by_segmentcontainer) | **GET** /Audio/{Id}/hls1/{PlaylistId}/{SegmentId}.{SegmentContainer} | 
*DynamicHlsServiceApi* | [**get_audio_by_id_main_m3u8**](docs/DynamicHlsServiceApi.md#get_audio_by_id_main_m3u8) | **GET** /Audio/{Id}/main.m3u8 | Gets an audio stream using HTTP live streaming.
*DynamicHlsServiceApi* | [**get_audio_by_id_master_m3u8**](docs/DynamicHlsServiceApi.md#get_audio_by_id_master_m3u8) | **GET** /Audio/{Id}/master.m3u8 | Gets an audio stream using HTTP live streaming.
*DynamicHlsServiceApi* | [**get_videos_by_id_hls1_by_playlistid_by_segmentid_by_segmentcontainer**](docs/DynamicHlsServiceApi.md#get_videos_by_id_hls1_by_playlistid_by_segmentid_by_segmentcontainer) | **GET** /Videos/{Id}/hls1/{PlaylistId}/{SegmentId}.{SegmentContainer} | 
*DynamicHlsServiceApi* | [**get_videos_by_id_main_m3u8**](docs/DynamicHlsServiceApi.md#get_videos_by_id_main_m3u8) | **GET** /Videos/{Id}/main.m3u8 | Gets a video stream using HTTP live streaming.
*DynamicHlsServiceApi* | [**get_videos_by_id_master_m3u8**](docs/DynamicHlsServiceApi.md#get_videos_by_id_master_m3u8) | **GET** /Videos/{Id}/master.m3u8 | Gets a video stream using HTTP live streaming.
*DynamicHlsServiceApi* | [**get_videos_by_id_subtitles_m3u8**](docs/DynamicHlsServiceApi.md#get_videos_by_id_subtitles_m3u8) | **GET** /Videos/{Id}/subtitles.m3u8 | Gets an HLS subtitle playlist.
*DynamicHlsServiceApi* | [**head_audio_by_id_hls1_by_playlistid_by_segmentid_by_segmentcontainer**](docs/DynamicHlsServiceApi.md#head_audio_by_id_hls1_by_playlistid_by_segmentid_by_segmentcontainer) | **HEAD** /Audio/{Id}/hls1/{PlaylistId}/{SegmentId}.{SegmentContainer} | 
*DynamicHlsServiceApi* | [**head_audio_by_id_master_m3u8**](docs/DynamicHlsServiceApi.md#head_audio_by_id_master_m3u8) | **HEAD** /Audio/{Id}/master.m3u8 | Gets an audio stream using HTTP live streaming.
*DynamicHlsServiceApi* | [**head_videos_by_id_hls1_by_playlistid_by_segmentid_by_segmentcontainer**](docs/DynamicHlsServiceApi.md#head_videos_by_id_hls1_by_playlistid_by_segmentid_by_segmentcontainer) | **HEAD** /Videos/{Id}/hls1/{PlaylistId}/{SegmentId}.{SegmentContainer} | 
*DynamicHlsServiceApi* | [**head_videos_by_id_master_m3u8**](docs/DynamicHlsServiceApi.md#head_videos_by_id_master_m3u8) | **HEAD** /Videos/{Id}/master.m3u8 | Gets a video stream using HTTP live streaming.
*EncodingInfoServiceApi* | [**get_encoding_codecconfiguration_defaults**](docs/EncodingInfoServiceApi.md#get_encoding_codecconfiguration_defaults) | **GET** /Encoding/CodecConfiguration/Defaults | Gets default codec configurations
*EncodingInfoServiceApi* | [**get_encoding_codecinformation_video**](docs/EncodingInfoServiceApi.md#get_encoding_codecinformation_video) | **GET** /Encoding/CodecInformation/Video | Gets details about available video encoders and decoders
*EnvironmentServiceApi* | [**get_environment_defaultdirectorybrowser**](docs/EnvironmentServiceApi.md#get_environment_defaultdirectorybrowser) | **GET** /Environment/DefaultDirectoryBrowser | Gets the parent path of a given path
*EnvironmentServiceApi* | [**get_environment_directorycontents**](docs/EnvironmentServiceApi.md#get_environment_directorycontents) | **GET** /Environment/DirectoryContents | Gets the contents of a given directory in the file system
*EnvironmentServiceApi* | [**get_environment_drives**](docs/EnvironmentServiceApi.md#get_environment_drives) | **GET** /Environment/Drives | Gets available drives from the server&#x27;s file system
*EnvironmentServiceApi* | [**get_environment_networkdevices**](docs/EnvironmentServiceApi.md#get_environment_networkdevices) | **GET** /Environment/NetworkDevices | Gets a list of devices on the network
*EnvironmentServiceApi* | [**get_environment_networkshares**](docs/EnvironmentServiceApi.md#get_environment_networkshares) | **GET** /Environment/NetworkShares | Gets shares from a network device
*EnvironmentServiceApi* | [**get_environment_parentpath**](docs/EnvironmentServiceApi.md#get_environment_parentpath) | **GET** /Environment/ParentPath | Gets the parent path of a given path
*EnvironmentServiceApi* | [**post_environment_validatepath**](docs/EnvironmentServiceApi.md#post_environment_validatepath) | **POST** /Environment/ValidatePath | Gets the contents of a given directory in the file system
*FilterServiceApi* | [**get_items_filters**](docs/FilterServiceApi.md#get_items_filters) | **GET** /Items/Filters | Gets branding configuration
*FilterServiceApi* | [**get_items_filters2**](docs/FilterServiceApi.md#get_items_filters2) | **GET** /Items/Filters2 | Gets branding configuration
*GameGenresServiceApi* | [**get_gamegenres**](docs/GameGenresServiceApi.md#get_gamegenres) | **GET** /GameGenres | Gets all Game genres from a given item, folder, or the entire library
*GameGenresServiceApi* | [**get_gamegenres_by_name**](docs/GameGenresServiceApi.md#get_gamegenres_by_name) | **GET** /GameGenres/{Name} | Gets a Game genre, by name
*GamesServiceApi* | [**get_games_systemsummaries**](docs/GamesServiceApi.md#get_games_systemsummaries) | **GET** /Games/SystemSummaries | Finds games similar to a given game.
*GenresServiceApi* | [**get_genres**](docs/GenresServiceApi.md#get_genres) | **GET** /Genres | Gets all genres from a given item, folder, or the entire library
*GenresServiceApi* | [**get_genres_by_name**](docs/GenresServiceApi.md#get_genres_by_name) | **GET** /Genres/{Name} | Gets a genre, by name
*HlsSegmentServiceApi* | [**delete_videos_activeencodings**](docs/HlsSegmentServiceApi.md#delete_videos_activeencodings) | **DELETE** /Videos/ActiveEncodings | 
*HlsSegmentServiceApi* | [**get_videos_by_id_hls_by_playlistid_by_segmentid_by_segmentcontainer**](docs/HlsSegmentServiceApi.md#get_videos_by_id_hls_by_playlistid_by_segmentid_by_segmentcontainer) | **GET** /Videos/{Id}/hls/{PlaylistId}/{SegmentId}.{SegmentContainer} | 
*ImageByNameServiceApi* | [**get_images_general**](docs/ImageByNameServiceApi.md#get_images_general) | **GET** /Images/General | Gets all general images by name
*ImageByNameServiceApi* | [**get_images_general_by_name_by_type**](docs/ImageByNameServiceApi.md#get_images_general_by_name_by_type) | **GET** /Images/General/{Name}/{Type} | Gets a general image by name
*ImageByNameServiceApi* | [**get_images_mediainfo**](docs/ImageByNameServiceApi.md#get_images_mediainfo) | **GET** /Images/MediaInfo | Gets all media info image by name
*ImageByNameServiceApi* | [**get_images_mediainfo_by_theme_by_name**](docs/ImageByNameServiceApi.md#get_images_mediainfo_by_theme_by_name) | **GET** /Images/MediaInfo/{Theme}/{Name} | Gets a media info image by name
*ImageByNameServiceApi* | [**get_images_ratings**](docs/ImageByNameServiceApi.md#get_images_ratings) | **GET** /Images/Ratings | Gets all rating images by name
*ImageByNameServiceApi* | [**get_images_ratings_by_theme_by_name**](docs/ImageByNameServiceApi.md#get_images_ratings_by_theme_by_name) | **GET** /Images/Ratings/{Theme}/{Name} | Gets a rating image by name
*ImageServiceApi* | [**delete_items_by_id_images_by_type**](docs/ImageServiceApi.md#delete_items_by_id_images_by_type) | **DELETE** /Items/{Id}/Images/{Type} | 
*ImageServiceApi* | [**delete_items_by_id_images_by_type_by_index**](docs/ImageServiceApi.md#delete_items_by_id_images_by_type_by_index) | **DELETE** /Items/{Id}/Images/{Type}/{Index} | 
*ImageServiceApi* | [**delete_users_by_id_images_by_type**](docs/ImageServiceApi.md#delete_users_by_id_images_by_type) | **DELETE** /Users/{Id}/Images/{Type} | 
*ImageServiceApi* | [**delete_users_by_id_images_by_type_by_index**](docs/ImageServiceApi.md#delete_users_by_id_images_by_type_by_index) | **DELETE** /Users/{Id}/Images/{Type}/{Index} | 
*ImageServiceApi* | [**get_artists_by_name_images_by_type**](docs/ImageServiceApi.md#get_artists_by_name_images_by_type) | **GET** /Artists/{Name}/Images/{Type} | 
*ImageServiceApi* | [**get_artists_by_name_images_by_type_by_index**](docs/ImageServiceApi.md#get_artists_by_name_images_by_type_by_index) | **GET** /Artists/{Name}/Images/{Type}/{Index} | 
*ImageServiceApi* | [**get_gamegenres_by_name_images_by_type**](docs/ImageServiceApi.md#get_gamegenres_by_name_images_by_type) | **GET** /GameGenres/{Name}/Images/{Type} | 
*ImageServiceApi* | [**get_gamegenres_by_name_images_by_type_by_index**](docs/ImageServiceApi.md#get_gamegenres_by_name_images_by_type_by_index) | **GET** /GameGenres/{Name}/Images/{Type}/{Index} | 
*ImageServiceApi* | [**get_genres_by_name_images_by_type**](docs/ImageServiceApi.md#get_genres_by_name_images_by_type) | **GET** /Genres/{Name}/Images/{Type} | 
*ImageServiceApi* | [**get_genres_by_name_images_by_type_by_index**](docs/ImageServiceApi.md#get_genres_by_name_images_by_type_by_index) | **GET** /Genres/{Name}/Images/{Type}/{Index} | 
*ImageServiceApi* | [**get_items_by_id_images**](docs/ImageServiceApi.md#get_items_by_id_images) | **GET** /Items/{Id}/Images | Gets information about an item&#x27;s images
*ImageServiceApi* | [**get_items_by_id_images_by_type**](docs/ImageServiceApi.md#get_items_by_id_images_by_type) | **GET** /Items/{Id}/Images/{Type} | 
*ImageServiceApi* | [**get_items_by_id_images_by_type_by_index**](docs/ImageServiceApi.md#get_items_by_id_images_by_type_by_index) | **GET** /Items/{Id}/Images/{Type}/{Index} | 
*ImageServiceApi* | [**get_items_by_id_images_by_type_by_index_by_tag_by_format_by_maxwidth_by_maxheight_by_percentplayed_by_unplayedcount**](docs/ImageServiceApi.md#get_items_by_id_images_by_type_by_index_by_tag_by_format_by_maxwidth_by_maxheight_by_percentplayed_by_unplayedcount) | **GET** /Items/{Id}/Images/{Type}/{Index}/{Tag}/{Format}/{MaxWidth}/{MaxHeight}/{PercentPlayed}/{UnplayedCount} | 
*ImageServiceApi* | [**get_musicgenres_by_name_images_by_type**](docs/ImageServiceApi.md#get_musicgenres_by_name_images_by_type) | **GET** /MusicGenres/{Name}/Images/{Type} | 
*ImageServiceApi* | [**get_musicgenres_by_name_images_by_type_by_index**](docs/ImageServiceApi.md#get_musicgenres_by_name_images_by_type_by_index) | **GET** /MusicGenres/{Name}/Images/{Type}/{Index} | 
*ImageServiceApi* | [**get_persons_by_name_images_by_type**](docs/ImageServiceApi.md#get_persons_by_name_images_by_type) | **GET** /Persons/{Name}/Images/{Type} | 
*ImageServiceApi* | [**get_persons_by_name_images_by_type_by_index**](docs/ImageServiceApi.md#get_persons_by_name_images_by_type_by_index) | **GET** /Persons/{Name}/Images/{Type}/{Index} | 
*ImageServiceApi* | [**get_studios_by_name_images_by_type**](docs/ImageServiceApi.md#get_studios_by_name_images_by_type) | **GET** /Studios/{Name}/Images/{Type} | 
*ImageServiceApi* | [**get_studios_by_name_images_by_type_by_index**](docs/ImageServiceApi.md#get_studios_by_name_images_by_type_by_index) | **GET** /Studios/{Name}/Images/{Type}/{Index} | 
*ImageServiceApi* | [**get_users_by_id_images_by_type**](docs/ImageServiceApi.md#get_users_by_id_images_by_type) | **GET** /Users/{Id}/Images/{Type} | 
*ImageServiceApi* | [**get_users_by_id_images_by_type_by_index**](docs/ImageServiceApi.md#get_users_by_id_images_by_type_by_index) | **GET** /Users/{Id}/Images/{Type}/{Index} | 
*ImageServiceApi* | [**head_artists_by_name_images_by_type**](docs/ImageServiceApi.md#head_artists_by_name_images_by_type) | **HEAD** /Artists/{Name}/Images/{Type} | 
*ImageServiceApi* | [**head_artists_by_name_images_by_type_by_index**](docs/ImageServiceApi.md#head_artists_by_name_images_by_type_by_index) | **HEAD** /Artists/{Name}/Images/{Type}/{Index} | 
*ImageServiceApi* | [**head_gamegenres_by_name_images_by_type**](docs/ImageServiceApi.md#head_gamegenres_by_name_images_by_type) | **HEAD** /GameGenres/{Name}/Images/{Type} | 
*ImageServiceApi* | [**head_gamegenres_by_name_images_by_type_by_index**](docs/ImageServiceApi.md#head_gamegenres_by_name_images_by_type_by_index) | **HEAD** /GameGenres/{Name}/Images/{Type}/{Index} | 
*ImageServiceApi* | [**head_genres_by_name_images_by_type**](docs/ImageServiceApi.md#head_genres_by_name_images_by_type) | **HEAD** /Genres/{Name}/Images/{Type} | 
*ImageServiceApi* | [**head_genres_by_name_images_by_type_by_index**](docs/ImageServiceApi.md#head_genres_by_name_images_by_type_by_index) | **HEAD** /Genres/{Name}/Images/{Type}/{Index} | 
*ImageServiceApi* | [**head_items_by_id_images_by_type**](docs/ImageServiceApi.md#head_items_by_id_images_by_type) | **HEAD** /Items/{Id}/Images/{Type} | 
*ImageServiceApi* | [**head_items_by_id_images_by_type_by_index**](docs/ImageServiceApi.md#head_items_by_id_images_by_type_by_index) | **HEAD** /Items/{Id}/Images/{Type}/{Index} | 
*ImageServiceApi* | [**head_items_by_id_images_by_type_by_index_by_tag_by_format_by_maxwidth_by_maxheight_by_percentplayed_by_unplayedcount**](docs/ImageServiceApi.md#head_items_by_id_images_by_type_by_index_by_tag_by_format_by_maxwidth_by_maxheight_by_percentplayed_by_unplayedcount) | **HEAD** /Items/{Id}/Images/{Type}/{Index}/{Tag}/{Format}/{MaxWidth}/{MaxHeight}/{PercentPlayed}/{UnplayedCount} | 
*ImageServiceApi* | [**head_musicgenres_by_name_images_by_type**](docs/ImageServiceApi.md#head_musicgenres_by_name_images_by_type) | **HEAD** /MusicGenres/{Name}/Images/{Type} | 
*ImageServiceApi* | [**head_musicgenres_by_name_images_by_type_by_index**](docs/ImageServiceApi.md#head_musicgenres_by_name_images_by_type_by_index) | **HEAD** /MusicGenres/{Name}/Images/{Type}/{Index} | 
*ImageServiceApi* | [**head_persons_by_name_images_by_type**](docs/ImageServiceApi.md#head_persons_by_name_images_by_type) | **HEAD** /Persons/{Name}/Images/{Type} | 
*ImageServiceApi* | [**head_persons_by_name_images_by_type_by_index**](docs/ImageServiceApi.md#head_persons_by_name_images_by_type_by_index) | **HEAD** /Persons/{Name}/Images/{Type}/{Index} | 
*ImageServiceApi* | [**head_studios_by_name_images_by_type**](docs/ImageServiceApi.md#head_studios_by_name_images_by_type) | **HEAD** /Studios/{Name}/Images/{Type} | 
*ImageServiceApi* | [**head_studios_by_name_images_by_type_by_index**](docs/ImageServiceApi.md#head_studios_by_name_images_by_type_by_index) | **HEAD** /Studios/{Name}/Images/{Type}/{Index} | 
*ImageServiceApi* | [**head_users_by_id_images_by_type**](docs/ImageServiceApi.md#head_users_by_id_images_by_type) | **HEAD** /Users/{Id}/Images/{Type} | 
*ImageServiceApi* | [**head_users_by_id_images_by_type_by_index**](docs/ImageServiceApi.md#head_users_by_id_images_by_type_by_index) | **HEAD** /Users/{Id}/Images/{Type}/{Index} | 
*ImageServiceApi* | [**post_items_by_id_images_by_type**](docs/ImageServiceApi.md#post_items_by_id_images_by_type) | **POST** /Items/{Id}/Images/{Type} | 
*ImageServiceApi* | [**post_items_by_id_images_by_type_by_index**](docs/ImageServiceApi.md#post_items_by_id_images_by_type_by_index) | **POST** /Items/{Id}/Images/{Type}/{Index} | 
*ImageServiceApi* | [**post_items_by_id_images_by_type_by_index_index**](docs/ImageServiceApi.md#post_items_by_id_images_by_type_by_index_index) | **POST** /Items/{Id}/Images/{Type}/{Index}/Index | Updates the index for an item image
*ImageServiceApi* | [**post_users_by_id_images_by_type**](docs/ImageServiceApi.md#post_users_by_id_images_by_type) | **POST** /Users/{Id}/Images/{Type} | 
*ImageServiceApi* | [**post_users_by_id_images_by_type_by_index**](docs/ImageServiceApi.md#post_users_by_id_images_by_type_by_index) | **POST** /Users/{Id}/Images/{Type}/{Index} | 
*InstantMixServiceApi* | [**get_albums_by_id_instantmix**](docs/InstantMixServiceApi.md#get_albums_by_id_instantmix) | **GET** /Albums/{Id}/InstantMix | Creates an instant playlist based on a given album
*InstantMixServiceApi* | [**get_artists_instantmix**](docs/InstantMixServiceApi.md#get_artists_instantmix) | **GET** /Artists/InstantMix | Creates an instant playlist based on a given artist
*InstantMixServiceApi* | [**get_items_by_id_instantmix**](docs/InstantMixServiceApi.md#get_items_by_id_instantmix) | **GET** /Items/{Id}/InstantMix | Creates an instant playlist based on a given item
*InstantMixServiceApi* | [**get_musicgenres_by_name_instantmix**](docs/InstantMixServiceApi.md#get_musicgenres_by_name_instantmix) | **GET** /MusicGenres/{Name}/InstantMix | Creates an instant playlist based on a music genre
*InstantMixServiceApi* | [**get_musicgenres_instantmix**](docs/InstantMixServiceApi.md#get_musicgenres_instantmix) | **GET** /MusicGenres/InstantMix | Creates an instant playlist based on a music genre
*InstantMixServiceApi* | [**get_playlists_by_id_instantmix**](docs/InstantMixServiceApi.md#get_playlists_by_id_instantmix) | **GET** /Playlists/{Id}/InstantMix | Creates an instant playlist based on a given playlist
*InstantMixServiceApi* | [**get_songs_by_id_instantmix**](docs/InstantMixServiceApi.md#get_songs_by_id_instantmix) | **GET** /Songs/{Id}/InstantMix | Creates an instant playlist based on a given song
*ItemLookupServiceApi* | [**get_items_by_id_externalidinfos**](docs/ItemLookupServiceApi.md#get_items_by_id_externalidinfos) | **GET** /Items/{Id}/ExternalIdInfos | Gets external id infos for an item
*ItemLookupServiceApi* | [**get_items_remotesearch_image**](docs/ItemLookupServiceApi.md#get_items_remotesearch_image) | **GET** /Items/RemoteSearch/Image | Gets a remote image
*ItemLookupServiceApi* | [**post_items_remotesearch_apply_by_id**](docs/ItemLookupServiceApi.md#post_items_remotesearch_apply_by_id) | **POST** /Items/RemoteSearch/Apply/{Id} | Applies search criteria to an item and refreshes metadata
*ItemLookupServiceApi* | [**post_items_remotesearch_book**](docs/ItemLookupServiceApi.md#post_items_remotesearch_book) | **POST** /Items/RemoteSearch/Book | 
*ItemLookupServiceApi* | [**post_items_remotesearch_boxset**](docs/ItemLookupServiceApi.md#post_items_remotesearch_boxset) | **POST** /Items/RemoteSearch/BoxSet | 
*ItemLookupServiceApi* | [**post_items_remotesearch_game**](docs/ItemLookupServiceApi.md#post_items_remotesearch_game) | **POST** /Items/RemoteSearch/Game | 
*ItemLookupServiceApi* | [**post_items_remotesearch_movie**](docs/ItemLookupServiceApi.md#post_items_remotesearch_movie) | **POST** /Items/RemoteSearch/Movie | 
*ItemLookupServiceApi* | [**post_items_remotesearch_musicalbum**](docs/ItemLookupServiceApi.md#post_items_remotesearch_musicalbum) | **POST** /Items/RemoteSearch/MusicAlbum | 
*ItemLookupServiceApi* | [**post_items_remotesearch_musicartist**](docs/ItemLookupServiceApi.md#post_items_remotesearch_musicartist) | **POST** /Items/RemoteSearch/MusicArtist | 
*ItemLookupServiceApi* | [**post_items_remotesearch_musicvideo**](docs/ItemLookupServiceApi.md#post_items_remotesearch_musicvideo) | **POST** /Items/RemoteSearch/MusicVideo | 
*ItemLookupServiceApi* | [**post_items_remotesearch_person**](docs/ItemLookupServiceApi.md#post_items_remotesearch_person) | **POST** /Items/RemoteSearch/Person | 
*ItemLookupServiceApi* | [**post_items_remotesearch_series**](docs/ItemLookupServiceApi.md#post_items_remotesearch_series) | **POST** /Items/RemoteSearch/Series | 
*ItemLookupServiceApi* | [**post_items_remotesearch_trailer**](docs/ItemLookupServiceApi.md#post_items_remotesearch_trailer) | **POST** /Items/RemoteSearch/Trailer | 
*ItemRefreshServiceApi* | [**post_items_by_id_refresh**](docs/ItemRefreshServiceApi.md#post_items_by_id_refresh) | **POST** /Items/{Id}/Refresh | Refreshes metadata for an item
*ItemUpdateServiceApi* | [**get_items_by_itemid_metadataeditor**](docs/ItemUpdateServiceApi.md#get_items_by_itemid_metadataeditor) | **GET** /Items/{ItemId}/MetadataEditor | Gets metadata editor info for an item
*ItemUpdateServiceApi* | [**post_items_by_itemid**](docs/ItemUpdateServiceApi.md#post_items_by_itemid) | **POST** /Items/{ItemId} | Updates an item
*ItemsServiceApi* | [**get_items**](docs/ItemsServiceApi.md#get_items) | **GET** /Items | Gets items based on a query.
*ItemsServiceApi* | [**get_users_by_userid_items**](docs/ItemsServiceApi.md#get_users_by_userid_items) | **GET** /Users/{UserId}/Items | Gets items based on a query.
*ItemsServiceApi* | [**get_users_by_userid_items_resume**](docs/ItemsServiceApi.md#get_users_by_userid_items_resume) | **GET** /Users/{UserId}/Items/Resume | Gets items based on a query.
*LibraryServiceApi* | [**delete_items**](docs/LibraryServiceApi.md#delete_items) | **DELETE** /Items | Deletes an item from the library and file system
*LibraryServiceApi* | [**delete_items_by_id**](docs/LibraryServiceApi.md#delete_items_by_id) | **DELETE** /Items/{Id} | Deletes an item from the library and file system
*LibraryServiceApi* | [**get_albums_by_id_similar**](docs/LibraryServiceApi.md#get_albums_by_id_similar) | **GET** /Albums/{Id}/Similar | Finds albums similar to a given album.
*LibraryServiceApi* | [**get_artists_by_id_similar**](docs/LibraryServiceApi.md#get_artists_by_id_similar) | **GET** /Artists/{Id}/Similar | Finds albums similar to a given album.
*LibraryServiceApi* | [**get_games_by_id_similar**](docs/LibraryServiceApi.md#get_games_by_id_similar) | **GET** /Games/{Id}/Similar | Finds games similar to a given game.
*LibraryServiceApi* | [**get_items_by_id_ancestors**](docs/LibraryServiceApi.md#get_items_by_id_ancestors) | **GET** /Items/{Id}/Ancestors | Gets all parents of an item
*LibraryServiceApi* | [**get_items_by_id_criticreviews**](docs/LibraryServiceApi.md#get_items_by_id_criticreviews) | **GET** /Items/{Id}/CriticReviews | Gets critic reviews for an item
*LibraryServiceApi* | [**get_items_by_id_deleteinfo**](docs/LibraryServiceApi.md#get_items_by_id_deleteinfo) | **GET** /Items/{Id}/DeleteInfo | Gets delete info for an item
*LibraryServiceApi* | [**get_items_by_id_download**](docs/LibraryServiceApi.md#get_items_by_id_download) | **GET** /Items/{Id}/Download | Downloads item media
*LibraryServiceApi* | [**get_items_by_id_file**](docs/LibraryServiceApi.md#get_items_by_id_file) | **GET** /Items/{Id}/File | Gets the original file of an item
*LibraryServiceApi* | [**get_items_by_id_similar**](docs/LibraryServiceApi.md#get_items_by_id_similar) | **GET** /Items/{Id}/Similar | Gets similar items
*LibraryServiceApi* | [**get_items_by_id_thememedia**](docs/LibraryServiceApi.md#get_items_by_id_thememedia) | **GET** /Items/{Id}/ThemeMedia | Gets theme videos and songs for an item
*LibraryServiceApi* | [**get_items_by_id_themesongs**](docs/LibraryServiceApi.md#get_items_by_id_themesongs) | **GET** /Items/{Id}/ThemeSongs | Gets theme songs for an item
*LibraryServiceApi* | [**get_items_by_id_themevideos**](docs/LibraryServiceApi.md#get_items_by_id_themevideos) | **GET** /Items/{Id}/ThemeVideos | Gets theme videos for an item
*LibraryServiceApi* | [**get_items_counts**](docs/LibraryServiceApi.md#get_items_counts) | **GET** /Items/Counts | 
*LibraryServiceApi* | [**get_libraries_availableoptions**](docs/LibraryServiceApi.md#get_libraries_availableoptions) | **GET** /Libraries/AvailableOptions | 
*LibraryServiceApi* | [**get_library_mediafolders**](docs/LibraryServiceApi.md#get_library_mediafolders) | **GET** /Library/MediaFolders | Gets all user media folders.
*LibraryServiceApi* | [**get_library_physicalpaths**](docs/LibraryServiceApi.md#get_library_physicalpaths) | **GET** /Library/PhysicalPaths | Gets a list of physical paths from virtual folders
*LibraryServiceApi* | [**get_library_selectablemediafolders**](docs/LibraryServiceApi.md#get_library_selectablemediafolders) | **GET** /Library/SelectableMediaFolders | Gets all user media folders.
*LibraryServiceApi* | [**get_movies_by_id_similar**](docs/LibraryServiceApi.md#get_movies_by_id_similar) | **GET** /Movies/{Id}/Similar | Finds movies and trailers similar to a given movie.
*LibraryServiceApi* | [**get_shows_by_id_similar**](docs/LibraryServiceApi.md#get_shows_by_id_similar) | **GET** /Shows/{Id}/Similar | Finds tv shows similar to a given one.
*LibraryServiceApi* | [**get_trailers_by_id_similar**](docs/LibraryServiceApi.md#get_trailers_by_id_similar) | **GET** /Trailers/{Id}/Similar | Finds movies and trailers similar to a given trailer.
*LibraryServiceApi* | [**post_library_media_updated**](docs/LibraryServiceApi.md#post_library_media_updated) | **POST** /Library/Media/Updated | Reports that new movies have been added by an external source
*LibraryServiceApi* | [**post_library_movies_added**](docs/LibraryServiceApi.md#post_library_movies_added) | **POST** /Library/Movies/Added | Deprecated. Use /Library/Media/Updated
*LibraryServiceApi* | [**post_library_movies_updated**](docs/LibraryServiceApi.md#post_library_movies_updated) | **POST** /Library/Movies/Updated | Deprecated. Use /Library/Media/Updated
*LibraryServiceApi* | [**post_library_refresh**](docs/LibraryServiceApi.md#post_library_refresh) | **POST** /Library/Refresh | Starts a library scan
*LibraryServiceApi* | [**post_library_series_added**](docs/LibraryServiceApi.md#post_library_series_added) | **POST** /Library/Series/Added | Deprecated. Use /Library/Media/Updated
*LibraryServiceApi* | [**post_library_series_updated**](docs/LibraryServiceApi.md#post_library_series_updated) | **POST** /Library/Series/Updated | Deprecated. Use /Library/Media/Updated
*LibraryStructureServiceApi* | [**delete_library_virtualfolders**](docs/LibraryStructureServiceApi.md#delete_library_virtualfolders) | **DELETE** /Library/VirtualFolders | 
*LibraryStructureServiceApi* | [**delete_library_virtualfolders_paths**](docs/LibraryStructureServiceApi.md#delete_library_virtualfolders_paths) | **DELETE** /Library/VirtualFolders/Paths | 
*LibraryStructureServiceApi* | [**get_library_virtualfolders**](docs/LibraryStructureServiceApi.md#get_library_virtualfolders) | **GET** /Library/VirtualFolders | 
*LibraryStructureServiceApi* | [**post_library_virtualfolders**](docs/LibraryStructureServiceApi.md#post_library_virtualfolders) | **POST** /Library/VirtualFolders | 
*LibraryStructureServiceApi* | [**post_library_virtualfolders_libraryoptions**](docs/LibraryStructureServiceApi.md#post_library_virtualfolders_libraryoptions) | **POST** /Library/VirtualFolders/LibraryOptions | 
*LibraryStructureServiceApi* | [**post_library_virtualfolders_name**](docs/LibraryStructureServiceApi.md#post_library_virtualfolders_name) | **POST** /Library/VirtualFolders/Name | 
*LibraryStructureServiceApi* | [**post_library_virtualfolders_paths**](docs/LibraryStructureServiceApi.md#post_library_virtualfolders_paths) | **POST** /Library/VirtualFolders/Paths | 
*LibraryStructureServiceApi* | [**post_library_virtualfolders_paths_update**](docs/LibraryStructureServiceApi.md#post_library_virtualfolders_paths_update) | **POST** /Library/VirtualFolders/Paths/Update | 
*LiveTvServiceApi* | [**delete_livetv_channelmappingoptions**](docs/LiveTvServiceApi.md#delete_livetv_channelmappingoptions) | **DELETE** /LiveTv/ChannelMappingOptions | 
*LiveTvServiceApi* | [**delete_livetv_channelmappings**](docs/LiveTvServiceApi.md#delete_livetv_channelmappings) | **DELETE** /LiveTv/ChannelMappings | 
*LiveTvServiceApi* | [**delete_livetv_listingproviders**](docs/LiveTvServiceApi.md#delete_livetv_listingproviders) | **DELETE** /LiveTv/ListingProviders | Deletes a listing provider
*LiveTvServiceApi* | [**delete_livetv_recordings_by_id**](docs/LiveTvServiceApi.md#delete_livetv_recordings_by_id) | **DELETE** /LiveTv/Recordings/{Id} | Deletes a live tv recording
*LiveTvServiceApi* | [**delete_livetv_seriestimers_by_id**](docs/LiveTvServiceApi.md#delete_livetv_seriestimers_by_id) | **DELETE** /LiveTv/SeriesTimers/{Id} | Cancels a live tv series timer
*LiveTvServiceApi* | [**delete_livetv_timers_by_id**](docs/LiveTvServiceApi.md#delete_livetv_timers_by_id) | **DELETE** /LiveTv/Timers/{Id} | Cancels a live tv timer
*LiveTvServiceApi* | [**delete_livetv_tunerhosts**](docs/LiveTvServiceApi.md#delete_livetv_tunerhosts) | **DELETE** /LiveTv/TunerHosts | Deletes a tuner host
*LiveTvServiceApi* | [**get_livetv_channelmappingoptions**](docs/LiveTvServiceApi.md#get_livetv_channelmappingoptions) | **GET** /LiveTv/ChannelMappingOptions | 
*LiveTvServiceApi* | [**get_livetv_channelmappings**](docs/LiveTvServiceApi.md#get_livetv_channelmappings) | **GET** /LiveTv/ChannelMappings | 
*LiveTvServiceApi* | [**get_livetv_channels**](docs/LiveTvServiceApi.md#get_livetv_channels) | **GET** /LiveTv/Channels | Gets available live tv channels.
*LiveTvServiceApi* | [**get_livetv_channels_by_id**](docs/LiveTvServiceApi.md#get_livetv_channels_by_id) | **GET** /LiveTv/Channels/{Id} | Gets a live tv channel
*LiveTvServiceApi* | [**get_livetv_guideinfo**](docs/LiveTvServiceApi.md#get_livetv_guideinfo) | **GET** /LiveTv/GuideInfo | Gets guide info
*LiveTvServiceApi* | [**get_livetv_info**](docs/LiveTvServiceApi.md#get_livetv_info) | **GET** /LiveTv/Info | Gets available live tv services.
*LiveTvServiceApi* | [**get_livetv_listingproviders**](docs/LiveTvServiceApi.md#get_livetv_listingproviders) | **GET** /LiveTv/ListingProviders | Gets current listing providers
*LiveTvServiceApi* | [**get_livetv_listingproviders_available**](docs/LiveTvServiceApi.md#get_livetv_listingproviders_available) | **GET** /LiveTv/ListingProviders/Available | Gets listing provider
*LiveTvServiceApi* | [**get_livetv_listingproviders_default**](docs/LiveTvServiceApi.md#get_livetv_listingproviders_default) | **GET** /LiveTv/ListingProviders/Default | 
*LiveTvServiceApi* | [**get_livetv_listingproviders_lineups**](docs/LiveTvServiceApi.md#get_livetv_listingproviders_lineups) | **GET** /LiveTv/ListingProviders/Lineups | Gets available lineups
*LiveTvServiceApi* | [**get_livetv_listingproviders_schedulesdirect_countries**](docs/LiveTvServiceApi.md#get_livetv_listingproviders_schedulesdirect_countries) | **GET** /LiveTv/ListingProviders/SchedulesDirect/Countries | Gets available lineups
*LiveTvServiceApi* | [**get_livetv_liverecordings_by_id_stream**](docs/LiveTvServiceApi.md#get_livetv_liverecordings_by_id_stream) | **GET** /LiveTv/LiveRecordings/{Id}/stream | Gets a live tv channel
*LiveTvServiceApi* | [**get_livetv_livestreamfiles_by_id_by_container**](docs/LiveTvServiceApi.md#get_livetv_livestreamfiles_by_id_by_container) | **GET** /LiveTv/LiveStreamFiles/{Id}/stream.{Container} | Gets a live tv channel
*LiveTvServiceApi* | [**get_livetv_programs**](docs/LiveTvServiceApi.md#get_livetv_programs) | **GET** /LiveTv/Programs | Gets available live tv epgs..
*LiveTvServiceApi* | [**get_livetv_programs_recommended**](docs/LiveTvServiceApi.md#get_livetv_programs_recommended) | **GET** /LiveTv/Programs/Recommended | Gets available live tv epgs..
*LiveTvServiceApi* | [**get_livetv_recordings**](docs/LiveTvServiceApi.md#get_livetv_recordings) | **GET** /LiveTv/Recordings | Gets live tv recordings
*LiveTvServiceApi* | [**get_livetv_recordings_by_id**](docs/LiveTvServiceApi.md#get_livetv_recordings_by_id) | **GET** /LiveTv/Recordings/{Id} | Gets a live tv recording
*LiveTvServiceApi* | [**get_livetv_recordings_folders**](docs/LiveTvServiceApi.md#get_livetv_recordings_folders) | **GET** /LiveTv/Recordings/Folders | Gets recording folders
*LiveTvServiceApi* | [**get_livetv_recordings_groups**](docs/LiveTvServiceApi.md#get_livetv_recordings_groups) | **GET** /LiveTv/Recordings/Groups | Gets live tv recording groups
*LiveTvServiceApi* | [**get_livetv_recordings_groups_by_id**](docs/LiveTvServiceApi.md#get_livetv_recordings_groups_by_id) | **GET** /LiveTv/Recordings/Groups/{Id} | Gets a recording group
*LiveTvServiceApi* | [**get_livetv_recordings_series**](docs/LiveTvServiceApi.md#get_livetv_recordings_series) | **GET** /LiveTv/Recordings/Series | Gets live tv recordings
*LiveTvServiceApi* | [**get_livetv_seriestimers**](docs/LiveTvServiceApi.md#get_livetv_seriestimers) | **GET** /LiveTv/SeriesTimers | Gets live tv series timers
*LiveTvServiceApi* | [**get_livetv_seriestimers_by_id**](docs/LiveTvServiceApi.md#get_livetv_seriestimers_by_id) | **GET** /LiveTv/SeriesTimers/{Id} | Gets a live tv series timer
*LiveTvServiceApi* | [**get_livetv_timers**](docs/LiveTvServiceApi.md#get_livetv_timers) | **GET** /LiveTv/Timers | Gets live tv timers
*LiveTvServiceApi* | [**get_livetv_timers_by_id**](docs/LiveTvServiceApi.md#get_livetv_timers_by_id) | **GET** /LiveTv/Timers/{Id} | Gets a live tv timer
*LiveTvServiceApi* | [**get_livetv_timers_defaults**](docs/LiveTvServiceApi.md#get_livetv_timers_defaults) | **GET** /LiveTv/Timers/Defaults | Gets default values for a new timer
*LiveTvServiceApi* | [**get_livetv_tunerhosts**](docs/LiveTvServiceApi.md#get_livetv_tunerhosts) | **GET** /LiveTv/TunerHosts | Gets tuner hosts
*LiveTvServiceApi* | [**get_livetv_tunerhosts_types**](docs/LiveTvServiceApi.md#get_livetv_tunerhosts_types) | **GET** /LiveTv/TunerHosts/Types | 
*LiveTvServiceApi* | [**get_livetv_tuners_discvover**](docs/LiveTvServiceApi.md#get_livetv_tuners_discvover) | **GET** /LiveTv/Tuners/Discvover | 
*LiveTvServiceApi* | [**head_livetv_channelmappingoptions**](docs/LiveTvServiceApi.md#head_livetv_channelmappingoptions) | **HEAD** /LiveTv/ChannelMappingOptions | 
*LiveTvServiceApi* | [**head_livetv_channelmappings**](docs/LiveTvServiceApi.md#head_livetv_channelmappings) | **HEAD** /LiveTv/ChannelMappings | 
*LiveTvServiceApi* | [**options_livetv_channelmappingoptions**](docs/LiveTvServiceApi.md#options_livetv_channelmappingoptions) | **OPTIONS** /LiveTv/ChannelMappingOptions | 
*LiveTvServiceApi* | [**options_livetv_channelmappings**](docs/LiveTvServiceApi.md#options_livetv_channelmappings) | **OPTIONS** /LiveTv/ChannelMappings | 
*LiveTvServiceApi* | [**patch_livetv_channelmappingoptions**](docs/LiveTvServiceApi.md#patch_livetv_channelmappingoptions) | **PATCH** /LiveTv/ChannelMappingOptions | 
*LiveTvServiceApi* | [**patch_livetv_channelmappings**](docs/LiveTvServiceApi.md#patch_livetv_channelmappings) | **PATCH** /LiveTv/ChannelMappings | 
*LiveTvServiceApi* | [**post_livetv_channelmappingoptions**](docs/LiveTvServiceApi.md#post_livetv_channelmappingoptions) | **POST** /LiveTv/ChannelMappingOptions | 
*LiveTvServiceApi* | [**post_livetv_channelmappings**](docs/LiveTvServiceApi.md#post_livetv_channelmappings) | **POST** /LiveTv/ChannelMappings | 
*LiveTvServiceApi* | [**post_livetv_listingproviders**](docs/LiveTvServiceApi.md#post_livetv_listingproviders) | **POST** /LiveTv/ListingProviders | Adds a listing provider
*LiveTvServiceApi* | [**post_livetv_programs**](docs/LiveTvServiceApi.md#post_livetv_programs) | **POST** /LiveTv/Programs | Gets available live tv epgs..
*LiveTvServiceApi* | [**post_livetv_seriestimers**](docs/LiveTvServiceApi.md#post_livetv_seriestimers) | **POST** /LiveTv/SeriesTimers | Creates a live tv series timer
*LiveTvServiceApi* | [**post_livetv_seriestimers_by_id**](docs/LiveTvServiceApi.md#post_livetv_seriestimers_by_id) | **POST** /LiveTv/SeriesTimers/{Id} | Updates a live tv series timer
*LiveTvServiceApi* | [**post_livetv_timers**](docs/LiveTvServiceApi.md#post_livetv_timers) | **POST** /LiveTv/Timers | Creates a live tv timer
*LiveTvServiceApi* | [**post_livetv_timers_by_id**](docs/LiveTvServiceApi.md#post_livetv_timers_by_id) | **POST** /LiveTv/Timers/{Id} | Updates a live tv timer
*LiveTvServiceApi* | [**post_livetv_tunerhosts**](docs/LiveTvServiceApi.md#post_livetv_tunerhosts) | **POST** /LiveTv/TunerHosts | Adds a tuner host
*LiveTvServiceApi* | [**post_livetv_tuners_by_id_reset**](docs/LiveTvServiceApi.md#post_livetv_tuners_by_id_reset) | **POST** /LiveTv/Tuners/{Id}/Reset | Resets a tv tuner
*LiveTvServiceApi* | [**put_livetv_channelmappingoptions**](docs/LiveTvServiceApi.md#put_livetv_channelmappingoptions) | **PUT** /LiveTv/ChannelMappingOptions | 
*LiveTvServiceApi* | [**put_livetv_channelmappings**](docs/LiveTvServiceApi.md#put_livetv_channelmappings) | **PUT** /LiveTv/ChannelMappings | 
*LocalizationServiceApi* | [**get_localization_countries**](docs/LocalizationServiceApi.md#get_localization_countries) | **GET** /Localization/Countries | Gets known countries
*LocalizationServiceApi* | [**get_localization_cultures**](docs/LocalizationServiceApi.md#get_localization_cultures) | **GET** /Localization/Cultures | Gets known cultures
*LocalizationServiceApi* | [**get_localization_options**](docs/LocalizationServiceApi.md#get_localization_options) | **GET** /Localization/Options | Gets localization options
*LocalizationServiceApi* | [**get_localization_parentalratings**](docs/LocalizationServiceApi.md#get_localization_parentalratings) | **GET** /Localization/ParentalRatings | Gets known parental ratings
*MediaInfoServiceApi* | [**get_items_by_id_playbackinfo**](docs/MediaInfoServiceApi.md#get_items_by_id_playbackinfo) | **GET** /Items/{Id}/PlaybackInfo | Gets live playback media info for an item
*MediaInfoServiceApi* | [**get_playback_bitratetest**](docs/MediaInfoServiceApi.md#get_playback_bitratetest) | **GET** /Playback/BitrateTest | 
*MediaInfoServiceApi* | [**post_items_by_id_playbackinfo**](docs/MediaInfoServiceApi.md#post_items_by_id_playbackinfo) | **POST** /Items/{Id}/PlaybackInfo | Gets live playback media info for an item
*MediaInfoServiceApi* | [**post_livestreams_close**](docs/MediaInfoServiceApi.md#post_livestreams_close) | **POST** /LiveStreams/Close | Closes a media source
*MediaInfoServiceApi* | [**post_livestreams_mediainfo**](docs/MediaInfoServiceApi.md#post_livestreams_mediainfo) | **POST** /LiveStreams/MediaInfo | Closes a media source
*MediaInfoServiceApi* | [**post_livestreams_open**](docs/MediaInfoServiceApi.md#post_livestreams_open) | **POST** /LiveStreams/Open | Opens a media source
*MoviesServiceApi* | [**get_movies_recommendations**](docs/MoviesServiceApi.md#get_movies_recommendations) | **GET** /Movies/Recommendations | Gets movie recommendations
*MusicGenresServiceApi* | [**get_musicgenres**](docs/MusicGenresServiceApi.md#get_musicgenres) | **GET** /MusicGenres | Gets all music genres from a given item, folder, or the entire library
*MusicGenresServiceApi* | [**get_musicgenres_by_name**](docs/MusicGenresServiceApi.md#get_musicgenres_by_name) | **GET** /MusicGenres/{Name} | Gets a music genre, by name
*NewsServiceApi* | [**get_news_product**](docs/NewsServiceApi.md#get_news_product) | **GET** /News/Product | Gets the latest product news.
*NotificationsServiceApi* | [**get_notifications_by_userid**](docs/NotificationsServiceApi.md#get_notifications_by_userid) | **GET** /Notifications/{UserId} | Gets notifications
*NotificationsServiceApi* | [**get_notifications_by_userid_summary**](docs/NotificationsServiceApi.md#get_notifications_by_userid_summary) | **GET** /Notifications/{UserId}/Summary | Gets a notification summary for a user
*NotificationsServiceApi* | [**get_notifications_services**](docs/NotificationsServiceApi.md#get_notifications_services) | **GET** /Notifications/Services | Gets notification types
*NotificationsServiceApi* | [**get_notifications_types**](docs/NotificationsServiceApi.md#get_notifications_types) | **GET** /Notifications/Types | Gets notification types
*NotificationsServiceApi* | [**post_notifications_admin**](docs/NotificationsServiceApi.md#post_notifications_admin) | **POST** /Notifications/Admin | Sends a notification to all admin users
*NotificationsServiceApi* | [**post_notifications_by_userid_read**](docs/NotificationsServiceApi.md#post_notifications_by_userid_read) | **POST** /Notifications/{UserId}/Read | Marks notifications as read
*NotificationsServiceApi* | [**post_notifications_by_userid_unread**](docs/NotificationsServiceApi.md#post_notifications_by_userid_unread) | **POST** /Notifications/{UserId}/Unread | Marks notifications as unread
*OfficialRatingServiceApi* | [**get_officialratings**](docs/OfficialRatingServiceApi.md#get_officialratings) | **GET** /OfficialRatings | Gets items based on a query.
*OpenApiServiceApi* | [**get_openapi**](docs/OpenApiServiceApi.md#get_openapi) | **GET** /openapi | Gets the OpenAPI 3 specifications
*OpenApiServiceApi* | [**get_openapi_json**](docs/OpenApiServiceApi.md#get_openapi_json) | **GET** /openapi.json | Gets OpenAPI 3 specifications
*OpenApiServiceApi* | [**get_swagger**](docs/OpenApiServiceApi.md#get_swagger) | **GET** /swagger | Gets the swagger specifications
*OpenApiServiceApi* | [**get_swagger_json**](docs/OpenApiServiceApi.md#get_swagger_json) | **GET** /swagger.json | Gets the swagger specifications
*PackageServiceApi* | [**delete_packages_installing_by_id**](docs/PackageServiceApi.md#delete_packages_installing_by_id) | **DELETE** /Packages/Installing/{Id} | Cancels a package installation
*PackageServiceApi* | [**get_packages**](docs/PackageServiceApi.md#get_packages) | **GET** /Packages | Gets available packages
*PackageServiceApi* | [**get_packages_by_name**](docs/PackageServiceApi.md#get_packages_by_name) | **GET** /Packages/{Name} | Gets a package, by name or assembly guid
*PackageServiceApi* | [**get_packages_updates**](docs/PackageServiceApi.md#get_packages_updates) | **GET** /Packages/Updates | Gets available package updates for currently installed packages
*PackageServiceApi* | [**post_packages_installed_by_name**](docs/PackageServiceApi.md#post_packages_installed_by_name) | **POST** /Packages/Installed/{Name} | Installs a package
*PersonsServiceApi* | [**get_persons**](docs/PersonsServiceApi.md#get_persons) | **GET** /Persons | Gets all persons from a given item, folder, or the entire library
*PersonsServiceApi* | [**get_persons_by_name**](docs/PersonsServiceApi.md#get_persons_by_name) | **GET** /Persons/{Name} | Gets a person, by name
*PlaylistServiceApi* | [**delete_playlists_by_id_items**](docs/PlaylistServiceApi.md#delete_playlists_by_id_items) | **DELETE** /Playlists/{Id}/Items | Removes items from a playlist
*PlaylistServiceApi* | [**get_playlists_by_id_items**](docs/PlaylistServiceApi.md#get_playlists_by_id_items) | **GET** /Playlists/{Id}/Items | Gets the original items of a playlist
*PlaylistServiceApi* | [**post_playlists**](docs/PlaylistServiceApi.md#post_playlists) | **POST** /Playlists | Creates a new playlist
*PlaylistServiceApi* | [**post_playlists_by_id_items**](docs/PlaylistServiceApi.md#post_playlists_by_id_items) | **POST** /Playlists/{Id}/Items | Adds items to a playlist
*PlaylistServiceApi* | [**post_playlists_by_id_items_by_itemid_move_by_newindex**](docs/PlaylistServiceApi.md#post_playlists_by_id_items_by_itemid_move_by_newindex) | **POST** /Playlists/{Id}/Items/{ItemId}/Move/{NewIndex} | Moves a playlist item
*PlaystateServiceApi* | [**delete_users_by_userid_playeditems_by_id**](docs/PlaystateServiceApi.md#delete_users_by_userid_playeditems_by_id) | **DELETE** /Users/{UserId}/PlayedItems/{Id} | Marks an item as unplayed
*PlaystateServiceApi* | [**delete_users_by_userid_playingitems_by_id**](docs/PlaystateServiceApi.md#delete_users_by_userid_playingitems_by_id) | **DELETE** /Users/{UserId}/PlayingItems/{Id} | Reports that a user has stopped playing an item
*PlaystateServiceApi* | [**post_sessions_playing**](docs/PlaystateServiceApi.md#post_sessions_playing) | **POST** /Sessions/Playing | Reports playback has started within a session
*PlaystateServiceApi* | [**post_sessions_playing_ping**](docs/PlaystateServiceApi.md#post_sessions_playing_ping) | **POST** /Sessions/Playing/Ping | Pings a playback session
*PlaystateServiceApi* | [**post_sessions_playing_progress**](docs/PlaystateServiceApi.md#post_sessions_playing_progress) | **POST** /Sessions/Playing/Progress | Reports playback progress within a session
*PlaystateServiceApi* | [**post_sessions_playing_stopped**](docs/PlaystateServiceApi.md#post_sessions_playing_stopped) | **POST** /Sessions/Playing/Stopped | Reports playback has stopped within a session
*PlaystateServiceApi* | [**post_users_by_userid_playeditems_by_id**](docs/PlaystateServiceApi.md#post_users_by_userid_playeditems_by_id) | **POST** /Users/{UserId}/PlayedItems/{Id} | Marks an item as played
*PlaystateServiceApi* | [**post_users_by_userid_playingitems_by_id**](docs/PlaystateServiceApi.md#post_users_by_userid_playingitems_by_id) | **POST** /Users/{UserId}/PlayingItems/{Id} | Reports that a user has begun playing an item
*PlaystateServiceApi* | [**post_users_by_userid_playingitems_by_id_progress**](docs/PlaystateServiceApi.md#post_users_by_userid_playingitems_by_id_progress) | **POST** /Users/{UserId}/PlayingItems/{Id}/Progress | Reports a user&#x27;s playback progress
*PluginServiceApi* | [**delete_plugins_by_id**](docs/PluginServiceApi.md#delete_plugins_by_id) | **DELETE** /Plugins/{Id} | Uninstalls a plugin
*PluginServiceApi* | [**get_plugins**](docs/PluginServiceApi.md#get_plugins) | **GET** /Plugins | Gets a list of currently installed plugins
*PluginServiceApi* | [**get_plugins_by_id_configuration**](docs/PluginServiceApi.md#get_plugins_by_id_configuration) | **GET** /Plugins/{Id}/Configuration | Gets a plugin&#x27;s configuration
*PluginServiceApi* | [**get_plugins_by_id_thumb**](docs/PluginServiceApi.md#get_plugins_by_id_thumb) | **GET** /Plugins/{Id}/Thumb | Gets a plugin thumb image
*PluginServiceApi* | [**post_plugins_by_id_configuration**](docs/PluginServiceApi.md#post_plugins_by_id_configuration) | **POST** /Plugins/{Id}/Configuration | Updates a plugin&#x27;s configuration
*RemoteImageServiceApi* | [**get_images_remote**](docs/RemoteImageServiceApi.md#get_images_remote) | **GET** /Images/Remote | Gets a remote image
*RemoteImageServiceApi* | [**get_items_by_id_remoteimages**](docs/RemoteImageServiceApi.md#get_items_by_id_remoteimages) | **GET** /Items/{Id}/RemoteImages | Gets available remote images for an item
*RemoteImageServiceApi* | [**get_items_by_id_remoteimages_providers**](docs/RemoteImageServiceApi.md#get_items_by_id_remoteimages_providers) | **GET** /Items/{Id}/RemoteImages/Providers | Gets available remote image providers for an item
*RemoteImageServiceApi* | [**post_items_by_id_remoteimages_download**](docs/RemoteImageServiceApi.md#post_items_by_id_remoteimages_download) | **POST** /Items/{Id}/RemoteImages/Download | Downloads a remote image for an item
*ReportsServiceApi* | [**get_reports_activities**](docs/ReportsServiceApi.md#get_reports_activities) | **GET** /Reports/Activities | Gets activities entries
*ReportsServiceApi* | [**get_reports_headers**](docs/ReportsServiceApi.md#get_reports_headers) | **GET** /Reports/Headers | Gets reports headers based on library items
*ReportsServiceApi* | [**get_reports_items**](docs/ReportsServiceApi.md#get_reports_items) | **GET** /Reports/Items | Gets reports based on library items
*ReportsServiceApi* | [**get_reports_items_download**](docs/ReportsServiceApi.md#get_reports_items_download) | **GET** /Reports/Items/Download | Downloads report
*ScheduledTaskServiceApi* | [**delete_scheduledtasks_running_by_id**](docs/ScheduledTaskServiceApi.md#delete_scheduledtasks_running_by_id) | **DELETE** /ScheduledTasks/Running/{Id} | Stops a scheduled task
*ScheduledTaskServiceApi* | [**get_scheduledtasks**](docs/ScheduledTaskServiceApi.md#get_scheduledtasks) | **GET** /ScheduledTasks | Gets scheduled tasks
*ScheduledTaskServiceApi* | [**get_scheduledtasks_by_id**](docs/ScheduledTaskServiceApi.md#get_scheduledtasks_by_id) | **GET** /ScheduledTasks/{Id} | Gets a scheduled task, by Id
*ScheduledTaskServiceApi* | [**post_scheduledtasks_by_id_triggers**](docs/ScheduledTaskServiceApi.md#post_scheduledtasks_by_id_triggers) | **POST** /ScheduledTasks/{Id}/Triggers | Updates the triggers for a scheduled task
*ScheduledTaskServiceApi* | [**post_scheduledtasks_running_by_id**](docs/ScheduledTaskServiceApi.md#post_scheduledtasks_running_by_id) | **POST** /ScheduledTasks/Running/{Id} | Starts a scheduled task
*SearchServiceApi* | [**get_search_hints**](docs/SearchServiceApi.md#get_search_hints) | **GET** /Search/Hints | Gets search hints based on a search term
*ServerApiEndpointsApi* | [**post_notification_smtp_test_by_userid**](docs/ServerApiEndpointsApi.md#post_notification_smtp_test_by_userid) | **POST** /Notification/SMTP/Test/{UserID} | Tests SMTP
*SessionsServiceApi* | [**delete_auth_keys_by_key**](docs/SessionsServiceApi.md#delete_auth_keys_by_key) | **DELETE** /Auth/Keys/{Key} | 
*SessionsServiceApi* | [**delete_sessions_by_id_users_by_userid**](docs/SessionsServiceApi.md#delete_sessions_by_id_users_by_userid) | **DELETE** /Sessions/{Id}/Users/{UserId} | Removes an additional user from a session
*SessionsServiceApi* | [**get_auth_keys**](docs/SessionsServiceApi.md#get_auth_keys) | **GET** /Auth/Keys | 
*SessionsServiceApi* | [**get_auth_providers**](docs/SessionsServiceApi.md#get_auth_providers) | **GET** /Auth/Providers | 
*SessionsServiceApi* | [**get_sessions**](docs/SessionsServiceApi.md#get_sessions) | **GET** /Sessions | Gets a list of sessions
*SessionsServiceApi* | [**post_auth_keys**](docs/SessionsServiceApi.md#post_auth_keys) | **POST** /Auth/Keys | 
*SessionsServiceApi* | [**post_sessions_by_id_command**](docs/SessionsServiceApi.md#post_sessions_by_id_command) | **POST** /Sessions/{Id}/Command | Issues a system command to a client
*SessionsServiceApi* | [**post_sessions_by_id_command_by_command**](docs/SessionsServiceApi.md#post_sessions_by_id_command_by_command) | **POST** /Sessions/{Id}/Command/{Command} | Issues a system command to a client
*SessionsServiceApi* | [**post_sessions_by_id_message**](docs/SessionsServiceApi.md#post_sessions_by_id_message) | **POST** /Sessions/{Id}/Message | Issues a command to a client to display a message to the user
*SessionsServiceApi* | [**post_sessions_by_id_playing**](docs/SessionsServiceApi.md#post_sessions_by_id_playing) | **POST** /Sessions/{Id}/Playing | Instructs a session to play an item
*SessionsServiceApi* | [**post_sessions_by_id_playing_by_command**](docs/SessionsServiceApi.md#post_sessions_by_id_playing_by_command) | **POST** /Sessions/{Id}/Playing/{Command} | Issues a playstate command to a client
*SessionsServiceApi* | [**post_sessions_by_id_system_by_command**](docs/SessionsServiceApi.md#post_sessions_by_id_system_by_command) | **POST** /Sessions/{Id}/System/{Command} | Issues a system command to a client
*SessionsServiceApi* | [**post_sessions_by_id_users_by_userid**](docs/SessionsServiceApi.md#post_sessions_by_id_users_by_userid) | **POST** /Sessions/{Id}/Users/{UserId} | Adds an additional user to a session
*SessionsServiceApi* | [**post_sessions_by_id_viewing**](docs/SessionsServiceApi.md#post_sessions_by_id_viewing) | **POST** /Sessions/{Id}/Viewing | Instructs a session to browse to an item or view
*SessionsServiceApi* | [**post_sessions_capabilities**](docs/SessionsServiceApi.md#post_sessions_capabilities) | **POST** /Sessions/Capabilities | Updates capabilities for a device
*SessionsServiceApi* | [**post_sessions_capabilities_full**](docs/SessionsServiceApi.md#post_sessions_capabilities_full) | **POST** /Sessions/Capabilities/Full | Updates capabilities for a device
*SessionsServiceApi* | [**post_sessions_logout**](docs/SessionsServiceApi.md#post_sessions_logout) | **POST** /Sessions/Logout | Reports that a session has ended
*StudiosServiceApi* | [**get_studios**](docs/StudiosServiceApi.md#get_studios) | **GET** /Studios | Gets all studios from a given item, folder, or the entire library
*StudiosServiceApi* | [**get_studios_by_name**](docs/StudiosServiceApi.md#get_studios_by_name) | **GET** /Studios/{Name} | Gets a studio, by name
*SubtitleServiceApi* | [**delete_videos_by_id_subtitles_by_index**](docs/SubtitleServiceApi.md#delete_videos_by_id_subtitles_by_index) | **DELETE** /Videos/{Id}/Subtitles/{Index} | Deletes an external subtitle file
*SubtitleServiceApi* | [**get_items_by_id_remotesearch_subtitles_by_language**](docs/SubtitleServiceApi.md#get_items_by_id_remotesearch_subtitles_by_language) | **GET** /Items/{Id}/RemoteSearch/Subtitles/{Language} | 
*SubtitleServiceApi* | [**get_providers_subtitles_subtitles_by_id**](docs/SubtitleServiceApi.md#get_providers_subtitles_subtitles_by_id) | **GET** /Providers/Subtitles/Subtitles/{Id} | 
*SubtitleServiceApi* | [**get_videos_by_id_by_mediasourceid_subtitles_by_index_by_format**](docs/SubtitleServiceApi.md#get_videos_by_id_by_mediasourceid_subtitles_by_index_by_format) | **GET** /Videos/{Id}/{MediaSourceId}/Subtitles/{Index}/Stream.{Format} | Gets subtitles in a specified format.
*SubtitleServiceApi* | [**get_videos_by_id_by_mediasourceid_subtitles_by_index_by_startpositionticks_by_format**](docs/SubtitleServiceApi.md#get_videos_by_id_by_mediasourceid_subtitles_by_index_by_startpositionticks_by_format) | **GET** /Videos/{Id}/{MediaSourceId}/Subtitles/{Index}/{StartPositionTicks}/Stream.{Format} | Gets subtitles in a specified format.
*SubtitleServiceApi* | [**post_items_by_id_remotesearch_subtitles_by_subtitleid**](docs/SubtitleServiceApi.md#post_items_by_id_remotesearch_subtitles_by_subtitleid) | **POST** /Items/{Id}/RemoteSearch/Subtitles/{SubtitleId} | 
*SuggestionsServiceApi* | [**get_users_by_userid_suggestions**](docs/SuggestionsServiceApi.md#get_users_by_userid_suggestions) | **GET** /Users/{UserId}/Suggestions | Gets items based on a query.
*SyncServiceApi* | [**delete_sync_by_targetid_items**](docs/SyncServiceApi.md#delete_sync_by_targetid_items) | **DELETE** /Sync/{TargetId}/Items | Cancels items from a sync target
*SyncServiceApi* | [**delete_sync_jobitems_by_id**](docs/SyncServiceApi.md#delete_sync_jobitems_by_id) | **DELETE** /Sync/JobItems/{Id} | Cancels a sync job item
*SyncServiceApi* | [**delete_sync_jobs_by_id**](docs/SyncServiceApi.md#delete_sync_jobs_by_id) | **DELETE** /Sync/Jobs/{Id} | Cancels a sync job.
*SyncServiceApi* | [**get_sync_items_ready**](docs/SyncServiceApi.md#get_sync_items_ready) | **GET** /Sync/Items/Ready | Gets ready to download sync items.
*SyncServiceApi* | [**get_sync_jobitems**](docs/SyncServiceApi.md#get_sync_jobitems) | **GET** /Sync/JobItems | Gets sync job items.
*SyncServiceApi* | [**get_sync_jobitems_by_id_additionalfiles**](docs/SyncServiceApi.md#get_sync_jobitems_by_id_additionalfiles) | **GET** /Sync/JobItems/{Id}/AdditionalFiles | Gets a sync job item file
*SyncServiceApi* | [**get_sync_jobitems_by_id_file**](docs/SyncServiceApi.md#get_sync_jobitems_by_id_file) | **GET** /Sync/JobItems/{Id}/File | Gets a sync job item file
*SyncServiceApi* | [**get_sync_jobs**](docs/SyncServiceApi.md#get_sync_jobs) | **GET** /Sync/Jobs | Gets sync jobs.
*SyncServiceApi* | [**get_sync_jobs_by_id**](docs/SyncServiceApi.md#get_sync_jobs_by_id) | **GET** /Sync/Jobs/{Id} | Gets a sync job.
*SyncServiceApi* | [**get_sync_options**](docs/SyncServiceApi.md#get_sync_options) | **GET** /Sync/Options | Gets a list of available sync targets.
*SyncServiceApi* | [**get_sync_targets**](docs/SyncServiceApi.md#get_sync_targets) | **GET** /Sync/Targets | Gets a list of available sync targets.
*SyncServiceApi* | [**post_sync_by_itemid_status**](docs/SyncServiceApi.md#post_sync_by_itemid_status) | **POST** /Sync/{ItemId}/Status | Gets sync status for an item.
*SyncServiceApi* | [**post_sync_data**](docs/SyncServiceApi.md#post_sync_data) | **POST** /Sync/Data | Syncs data between device and server
*SyncServiceApi* | [**post_sync_items_cancel**](docs/SyncServiceApi.md#post_sync_items_cancel) | **POST** /Sync/Items/Cancel | Cancels items from a sync target
*SyncServiceApi* | [**post_sync_jobitems_by_id_enable**](docs/SyncServiceApi.md#post_sync_jobitems_by_id_enable) | **POST** /Sync/JobItems/{Id}/Enable | Enables a cancelled or queued sync job item
*SyncServiceApi* | [**post_sync_jobitems_by_id_markforremoval**](docs/SyncServiceApi.md#post_sync_jobitems_by_id_markforremoval) | **POST** /Sync/JobItems/{Id}/MarkForRemoval | Marks a job item for removal
*SyncServiceApi* | [**post_sync_jobitems_by_id_transferred**](docs/SyncServiceApi.md#post_sync_jobitems_by_id_transferred) | **POST** /Sync/JobItems/{Id}/Transferred | Reports that a sync job item has successfully been transferred.
*SyncServiceApi* | [**post_sync_jobitems_by_id_unmarkforremoval**](docs/SyncServiceApi.md#post_sync_jobitems_by_id_unmarkforremoval) | **POST** /Sync/JobItems/{Id}/UnmarkForRemoval | Unmarks a job item for removal
*SyncServiceApi* | [**post_sync_jobs**](docs/SyncServiceApi.md#post_sync_jobs) | **POST** /Sync/Jobs | Gets sync jobs.
*SyncServiceApi* | [**post_sync_jobs_by_id**](docs/SyncServiceApi.md#post_sync_jobs_by_id) | **POST** /Sync/Jobs/{Id} | Updates a sync job.
*SyncServiceApi* | [**post_sync_offlineactions**](docs/SyncServiceApi.md#post_sync_offlineactions) | **POST** /Sync/OfflineActions | Reports an action that occurred while offline.
*SystemServiceApi* | [**get_system_endpoint**](docs/SystemServiceApi.md#get_system_endpoint) | **GET** /System/Endpoint | Gets information about the request endpoint
*SystemServiceApi* | [**get_system_info**](docs/SystemServiceApi.md#get_system_info) | **GET** /System/Info | Gets information about the server
*SystemServiceApi* | [**get_system_info_public**](docs/SystemServiceApi.md#get_system_info_public) | **GET** /System/Info/Public | Gets public information about the server
*SystemServiceApi* | [**get_system_logs**](docs/SystemServiceApi.md#get_system_logs) | **GET** /System/Logs | Gets a list of available server log files
*SystemServiceApi* | [**get_system_logs_log**](docs/SystemServiceApi.md#get_system_logs_log) | **GET** /System/Logs/Log | Gets a log file
*SystemServiceApi* | [**get_system_ping**](docs/SystemServiceApi.md#get_system_ping) | **GET** /System/Ping | 
*SystemServiceApi* | [**get_system_wakeonlaninfo**](docs/SystemServiceApi.md#get_system_wakeonlaninfo) | **GET** /System/WakeOnLanInfo | Gets wake on lan information
*SystemServiceApi* | [**post_system_ping**](docs/SystemServiceApi.md#post_system_ping) | **POST** /System/Ping | 
*SystemServiceApi* | [**post_system_restart**](docs/SystemServiceApi.md#post_system_restart) | **POST** /System/Restart | Restarts the application, if needed
*SystemServiceApi* | [**post_system_shutdown**](docs/SystemServiceApi.md#post_system_shutdown) | **POST** /System/Shutdown | Shuts down the application
*TagServiceApi* | [**get_artists_prefixes**](docs/TagServiceApi.md#get_artists_prefixes) | **GET** /Artists/Prefixes | Gets items based on a query.
*TagServiceApi* | [**get_audiocodecs**](docs/TagServiceApi.md#get_audiocodecs) | **GET** /AudioCodecs | Gets items based on a query.
*TagServiceApi* | [**get_containers**](docs/TagServiceApi.md#get_containers) | **GET** /Containers | Gets items based on a query.
*TagServiceApi* | [**get_items_prefixes**](docs/TagServiceApi.md#get_items_prefixes) | **GET** /Items/Prefixes | Gets items based on a query.
*TagServiceApi* | [**get_subtitlecodecs**](docs/TagServiceApi.md#get_subtitlecodecs) | **GET** /SubtitleCodecs | Gets items based on a query.
*TagServiceApi* | [**get_tags**](docs/TagServiceApi.md#get_tags) | **GET** /Tags | Gets items based on a query.
*TagServiceApi* | [**get_videocodecs**](docs/TagServiceApi.md#get_videocodecs) | **GET** /VideoCodecs | Gets items based on a query.
*TagServiceApi* | [**get_years**](docs/TagServiceApi.md#get_years) | **GET** /Years | Gets items based on a query.
*TrailersServiceApi* | [**get_trailers**](docs/TrailersServiceApi.md#get_trailers) | **GET** /Trailers | Finds movies and trailers similar to a given trailer.
*TvShowsServiceApi* | [**get_shows_by_id_episodes**](docs/TvShowsServiceApi.md#get_shows_by_id_episodes) | **GET** /Shows/{Id}/Episodes | Gets episodes for a tv season
*TvShowsServiceApi* | [**get_shows_by_id_seasons**](docs/TvShowsServiceApi.md#get_shows_by_id_seasons) | **GET** /Shows/{Id}/Seasons | Gets seasons for a tv series
*TvShowsServiceApi* | [**get_shows_nextup**](docs/TvShowsServiceApi.md#get_shows_nextup) | **GET** /Shows/NextUp | Gets a list of next up episodes
*TvShowsServiceApi* | [**get_shows_upcoming**](docs/TvShowsServiceApi.md#get_shows_upcoming) | **GET** /Shows/Upcoming | Gets a list of upcoming episodes
*UniversalAudioServiceApi* | [**get_audio_by_id_by_container**](docs/UniversalAudioServiceApi.md#get_audio_by_id_by_container) | **GET** /Audio/{Id}/universal.{Container} | Gets an audio stream
*UniversalAudioServiceApi* | [**get_audio_by_id_universal**](docs/UniversalAudioServiceApi.md#get_audio_by_id_universal) | **GET** /Audio/{Id}/universal | Gets an audio stream
*UniversalAudioServiceApi* | [**head_audio_by_id_by_container**](docs/UniversalAudioServiceApi.md#head_audio_by_id_by_container) | **HEAD** /Audio/{Id}/universal.{Container} | Gets an audio stream
*UniversalAudioServiceApi* | [**head_audio_by_id_universal**](docs/UniversalAudioServiceApi.md#head_audio_by_id_universal) | **HEAD** /Audio/{Id}/universal | Gets an audio stream
*UserActivityAPIApi* | [**get_user_usage_stats_by_breakdowntype_breakdownreport**](docs/UserActivityAPIApi.md#get_user_usage_stats_by_breakdowntype_breakdownreport) | **GET** /user_usage_stats/{BreakdownType}/BreakdownReport | Gets a breakdown of a usage metric
*UserActivityAPIApi* | [**get_user_usage_stats_by_userid_by_date_getitems**](docs/UserActivityAPIApi.md#get_user_usage_stats_by_userid_by_date_getitems) | **GET** /user_usage_stats/{UserID}/{Date}/GetItems | Gets activity for {USER} for {Date} formatted as yyyy-MM-dd
*UserActivityAPIApi* | [**get_user_usage_stats_durationhistogramreport**](docs/UserActivityAPIApi.md#get_user_usage_stats_durationhistogramreport) | **GET** /user_usage_stats/DurationHistogramReport | Gets duration histogram
*UserActivityAPIApi* | [**get_user_usage_stats_hourlyreport**](docs/UserActivityAPIApi.md#get_user_usage_stats_hourlyreport) | **GET** /user_usage_stats/HourlyReport | Gets a report of the available activity per hour
*UserActivityAPIApi* | [**get_user_usage_stats_load_backup**](docs/UserActivityAPIApi.md#get_user_usage_stats_load_backup) | **GET** /user_usage_stats/load_backup | Loads a backup from a file
*UserActivityAPIApi* | [**get_user_usage_stats_moviesreport**](docs/UserActivityAPIApi.md#get_user_usage_stats_moviesreport) | **GET** /user_usage_stats/MoviesReport | Gets Movies counts
*UserActivityAPIApi* | [**get_user_usage_stats_playactivity**](docs/UserActivityAPIApi.md#get_user_usage_stats_playactivity) | **GET** /user_usage_stats/PlayActivity | Gets play activity for number of days
*UserActivityAPIApi* | [**get_user_usage_stats_process_list**](docs/UserActivityAPIApi.md#get_user_usage_stats_process_list) | **GET** /user_usage_stats/process_list | Gets a list of process Info
*UserActivityAPIApi* | [**get_user_usage_stats_resource_usage**](docs/UserActivityAPIApi.md#get_user_usage_stats_resource_usage) | **GET** /user_usage_stats/resource_usage | Gets Resource Usage Info
*UserActivityAPIApi* | [**get_user_usage_stats_save_backup**](docs/UserActivityAPIApi.md#get_user_usage_stats_save_backup) | **GET** /user_usage_stats/save_backup | Saves a backup of the playback report data to the backup path
*UserActivityAPIApi* | [**get_user_usage_stats_session_list**](docs/UserActivityAPIApi.md#get_user_usage_stats_session_list) | **GET** /user_usage_stats/session_list | Gets Session Info
*UserActivityAPIApi* | [**get_user_usage_stats_tvshowsreport**](docs/UserActivityAPIApi.md#get_user_usage_stats_tvshowsreport) | **GET** /user_usage_stats/TvShowsReport | Gets TV Shows counts
*UserActivityAPIApi* | [**get_user_usage_stats_type_filter_list**](docs/UserActivityAPIApi.md#get_user_usage_stats_type_filter_list) | **GET** /user_usage_stats/type_filter_list | Gets types filter list items
*UserActivityAPIApi* | [**get_user_usage_stats_user_activity**](docs/UserActivityAPIApi.md#get_user_usage_stats_user_activity) | **GET** /user_usage_stats/user_activity | Gets a report of the available activity per hour
*UserActivityAPIApi* | [**get_user_usage_stats_user_list**](docs/UserActivityAPIApi.md#get_user_usage_stats_user_list) | **GET** /user_usage_stats/user_list | Get users
*UserActivityAPIApi* | [**get_user_usage_stats_user_manage_by_action_by_id**](docs/UserActivityAPIApi.md#get_user_usage_stats_user_manage_by_action_by_id) | **GET** /user_usage_stats/user_manage/{Action}/{Id} | Get users
*UserActivityAPIApi* | [**get_user_usage_stats_userplaylist**](docs/UserActivityAPIApi.md#get_user_usage_stats_userplaylist) | **GET** /user_usage_stats/UserPlaylist | Gets a report of all played items for a user in a date period
*UserActivityAPIApi* | [**post_user_usage_stats_import_backup**](docs/UserActivityAPIApi.md#post_user_usage_stats_import_backup) | **POST** /user_usage_stats/import_backup | Post a backup for importing
*UserActivityAPIApi* | [**post_user_usage_stats_submit_custom_query**](docs/UserActivityAPIApi.md#post_user_usage_stats_submit_custom_query) | **POST** /user_usage_stats/submit_custom_query | Submit an SQL query
*UserLibraryServiceApi* | [**delete_users_by_userid_favoriteitems_by_id**](docs/UserLibraryServiceApi.md#delete_users_by_userid_favoriteitems_by_id) | **DELETE** /Users/{UserId}/FavoriteItems/{Id} | Unmarks an item as a favorite
*UserLibraryServiceApi* | [**delete_users_by_userid_items_by_id_rating**](docs/UserLibraryServiceApi.md#delete_users_by_userid_items_by_id_rating) | **DELETE** /Users/{UserId}/Items/{Id}/Rating | Deletes a user&#x27;s saved personal rating for an item
*UserLibraryServiceApi* | [**get_livetv_programs_by_id**](docs/UserLibraryServiceApi.md#get_livetv_programs_by_id) | **GET** /LiveTv/Programs/{Id} | Gets a live tv program
*UserLibraryServiceApi* | [**get_users_by_userid_items_by_id**](docs/UserLibraryServiceApi.md#get_users_by_userid_items_by_id) | **GET** /Users/{UserId}/Items/{Id} | Gets an item from a user&#x27;s library
*UserLibraryServiceApi* | [**get_users_by_userid_items_by_id_intros**](docs/UserLibraryServiceApi.md#get_users_by_userid_items_by_id_intros) | **GET** /Users/{UserId}/Items/{Id}/Intros | Gets intros to play before the main media item plays
*UserLibraryServiceApi* | [**get_users_by_userid_items_by_id_localtrailers**](docs/UserLibraryServiceApi.md#get_users_by_userid_items_by_id_localtrailers) | **GET** /Users/{UserId}/Items/{Id}/LocalTrailers | Gets local trailers for an item
*UserLibraryServiceApi* | [**get_users_by_userid_items_by_id_specialfeatures**](docs/UserLibraryServiceApi.md#get_users_by_userid_items_by_id_specialfeatures) | **GET** /Users/{UserId}/Items/{Id}/SpecialFeatures | Gets special features for an item
*UserLibraryServiceApi* | [**get_users_by_userid_items_latest**](docs/UserLibraryServiceApi.md#get_users_by_userid_items_latest) | **GET** /Users/{UserId}/Items/Latest | Gets latest media
*UserLibraryServiceApi* | [**get_users_by_userid_items_root**](docs/UserLibraryServiceApi.md#get_users_by_userid_items_root) | **GET** /Users/{UserId}/Items/Root | Gets the root folder from a user&#x27;s library
*UserLibraryServiceApi* | [**post_users_by_userid_favoriteitems_by_id**](docs/UserLibraryServiceApi.md#post_users_by_userid_favoriteitems_by_id) | **POST** /Users/{UserId}/FavoriteItems/{Id} | Marks an item as a favorite
*UserLibraryServiceApi* | [**post_users_by_userid_items_by_id_rating**](docs/UserLibraryServiceApi.md#post_users_by_userid_items_by_id_rating) | **POST** /Users/{UserId}/Items/{Id}/Rating | Updates a user&#x27;s rating for an item
*UserServiceApi* | [**delete_users_by_id**](docs/UserServiceApi.md#delete_users_by_id) | **DELETE** /Users/{Id} | Deletes a user
*UserServiceApi* | [**get_users**](docs/UserServiceApi.md#get_users) | **GET** /Users | Gets a list of users
*UserServiceApi* | [**get_users_by_id**](docs/UserServiceApi.md#get_users_by_id) | **GET** /Users/{Id} | Gets a user by Id
*UserServiceApi* | [**get_users_public**](docs/UserServiceApi.md#get_users_public) | **GET** /Users/Public | Gets a list of publicly visible users for display on a login screen.
*UserServiceApi* | [**post_users_authenticatebyname**](docs/UserServiceApi.md#post_users_authenticatebyname) | **POST** /Users/AuthenticateByName | Authenticates a user
*UserServiceApi* | [**post_users_by_id**](docs/UserServiceApi.md#post_users_by_id) | **POST** /Users/{Id} | Updates a user
*UserServiceApi* | [**post_users_by_id_authenticate**](docs/UserServiceApi.md#post_users_by_id_authenticate) | **POST** /Users/{Id}/Authenticate | Authenticates a user
*UserServiceApi* | [**post_users_by_id_configuration**](docs/UserServiceApi.md#post_users_by_id_configuration) | **POST** /Users/{Id}/Configuration | Updates a user configuration
*UserServiceApi* | [**post_users_by_id_easypassword**](docs/UserServiceApi.md#post_users_by_id_easypassword) | **POST** /Users/{Id}/EasyPassword | Updates a user&#x27;s easy password
*UserServiceApi* | [**post_users_by_id_password**](docs/UserServiceApi.md#post_users_by_id_password) | **POST** /Users/{Id}/Password | Updates a user&#x27;s password
*UserServiceApi* | [**post_users_by_id_policy**](docs/UserServiceApi.md#post_users_by_id_policy) | **POST** /Users/{Id}/Policy | Updates a user policy
*UserServiceApi* | [**post_users_forgotpassword**](docs/UserServiceApi.md#post_users_forgotpassword) | **POST** /Users/ForgotPassword | Initiates the forgot password process for a local user
*UserServiceApi* | [**post_users_forgotpassword_pin**](docs/UserServiceApi.md#post_users_forgotpassword_pin) | **POST** /Users/ForgotPassword/Pin | Redeems a forgot password pin
*UserServiceApi* | [**post_users_new**](docs/UserServiceApi.md#post_users_new) | **POST** /Users/New | Creates a user
*UserViewsServiceApi* | [**get_users_by_userid_groupingoptions**](docs/UserViewsServiceApi.md#get_users_by_userid_groupingoptions) | **GET** /Users/{UserId}/GroupingOptions | 
*UserViewsServiceApi* | [**get_users_by_userid_views**](docs/UserViewsServiceApi.md#get_users_by_userid_views) | **GET** /Users/{UserId}/Views | 
*VideoHlsServiceApi* | [**get_videos_by_id_live_m3u8**](docs/VideoHlsServiceApi.md#get_videos_by_id_live_m3u8) | **GET** /Videos/{Id}/live.m3u8 | 
*VideoServiceApi* | [**get_items_file**](docs/VideoServiceApi.md#get_items_file) | **GET** /Items/File | Gets the original file of an item
*VideoServiceApi* | [**get_videos_by_id_by_container**](docs/VideoServiceApi.md#get_videos_by_id_by_container) | **GET** /Videos/{Id}/stream.{Container} | Gets a video stream
*VideoServiceApi* | [**get_videos_by_id_stream**](docs/VideoServiceApi.md#get_videos_by_id_stream) | **GET** /Videos/{Id}/stream | Gets a video stream
*VideoServiceApi* | [**head_videos_by_id_by_container**](docs/VideoServiceApi.md#head_videos_by_id_by_container) | **HEAD** /Videos/{Id}/stream.{Container} | Gets a video stream
*VideoServiceApi* | [**head_videos_by_id_stream**](docs/VideoServiceApi.md#head_videos_by_id_stream) | **HEAD** /Videos/{Id}/stream | Gets a video stream
*VideosServiceApi* | [**delete_videos_by_id_alternatesources**](docs/VideosServiceApi.md#delete_videos_by_id_alternatesources) | **DELETE** /Videos/{Id}/AlternateSources | Removes alternate video sources.
*VideosServiceApi* | [**get_videos_by_id_additionalparts**](docs/VideosServiceApi.md#get_videos_by_id_additionalparts) | **GET** /Videos/{Id}/AdditionalParts | Gets additional parts for a video.
*VideosServiceApi* | [**post_videos_mergeversions**](docs/VideosServiceApi.md#post_videos_mergeversions) | **POST** /Videos/MergeVersions | Merges videos into a single record

## Documentation For Models

 - [ActivityLogEntry](docs/ActivityLogEntry.md)
 - [AllThemeMediaResult](docs/AllThemeMediaResult.md)
 - [AuthenticateUser](docs/AuthenticateUser.md)
 - [AuthenticateUserByName](docs/AuthenticateUserByName.md)
 - [AuthenticationAuthenticationResult](docs/AuthenticationAuthenticationResult.md)
 - [BaseItemDto](docs/BaseItemDto.md)
 - [BaseItemPerson](docs/BaseItemPerson.md)
 - [BrandingBrandingOptions](docs/BrandingBrandingOptions.md)
 - [ChapterInfo](docs/ChapterInfo.md)
 - [ClientCapabilities](docs/ClientCapabilities.md)
 - [CollectionsCollectionCreationResult](docs/CollectionsCollectionCreationResult.md)
 - [ConfigurationAccessSchedule](docs/ConfigurationAccessSchedule.md)
 - [ConfigurationCodecConfiguration](docs/ConfigurationCodecConfiguration.md)
 - [ConfigurationImageOption](docs/ConfigurationImageOption.md)
 - [ConfigurationLibraryOptions](docs/ConfigurationLibraryOptions.md)
 - [ConfigurationMediaPathInfo](docs/ConfigurationMediaPathInfo.md)
 - [ConfigurationPathSubstitution](docs/ConfigurationPathSubstitution.md)
 - [ConfigurationServerConfiguration](docs/ConfigurationServerConfiguration.md)
 - [ConfigurationTypeOptions](docs/ConfigurationTypeOptions.md)
 - [ConfigurationUserConfiguration](docs/ConfigurationUserConfiguration.md)
 - [ConnectConnectAuthenticationExchangeResult](docs/ConnectConnectAuthenticationExchangeResult.md)
 - [ConnectUserLinkResult](docs/ConnectUserLinkResult.md)
 - [CreateUserByName](docs/CreateUserByName.md)
 - [DefaultDirectoryBrowserInfo](docs/DefaultDirectoryBrowserInfo.md)
 - [DevicesContentUploadHistory](docs/DevicesContentUploadHistory.md)
 - [DevicesDeviceInfo](docs/DevicesDeviceInfo.md)
 - [DevicesDeviceOptions](docs/DevicesDeviceOptions.md)
 - [DevicesLocalFileInfo](docs/DevicesLocalFileInfo.md)
 - [DisplayPreferences](docs/DisplayPreferences.md)
 - [DlnaCodecProfile](docs/DlnaCodecProfile.md)
 - [DlnaContainerProfile](docs/DlnaContainerProfile.md)
 - [DlnaDeviceIdentification](docs/DlnaDeviceIdentification.md)
 - [DlnaDeviceProfile](docs/DlnaDeviceProfile.md)
 - [DlnaDeviceProfileInfo](docs/DlnaDeviceProfileInfo.md)
 - [DlnaDirectPlayProfile](docs/DlnaDirectPlayProfile.md)
 - [DlnaHttpHeaderInfo](docs/DlnaHttpHeaderInfo.md)
 - [DlnaProfileCondition](docs/DlnaProfileCondition.md)
 - [DlnaResponseProfile](docs/DlnaResponseProfile.md)
 - [DlnaSubtitleProfile](docs/DlnaSubtitleProfile.md)
 - [DlnaTranscodingProfile](docs/DlnaTranscodingProfile.md)
 - [DlnaXmlAttribute](docs/DlnaXmlAttribute.md)
 - [EmbyNotificationsApiNotification](docs/EmbyNotificationsApiNotification.md)
 - [EmbyNotificationsApiNotificationResult](docs/EmbyNotificationsApiNotificationResult.md)
 - [EmbyNotificationsApiNotificationsSummary](docs/EmbyNotificationsApiNotificationsSummary.md)
 - [EmbyReportsApiModelReportGroup](docs/EmbyReportsApiModelReportGroup.md)
 - [EmbyReportsApiModelReportHeader](docs/EmbyReportsApiModelReportHeader.md)
 - [EmbyReportsApiModelReportItem](docs/EmbyReportsApiModelReportItem.md)
 - [EmbyReportsApiModelReportResult](docs/EmbyReportsApiModelReportResult.md)
 - [EmbyReportsApiModelReportRow](docs/EmbyReportsApiModelReportRow.md)
 - [ExternalIdInfo](docs/ExternalIdInfo.md)
 - [ExternalUrl](docs/ExternalUrl.md)
 - [ForgotPassword](docs/ForgotPassword.md)
 - [ForgotPasswordPin](docs/ForgotPasswordPin.md)
 - [GameSystemSummary](docs/GameSystemSummary.md)
 - [GeneralCommand](docs/GeneralCommand.md)
 - [GlobalizationCountryInfo](docs/GlobalizationCountryInfo.md)
 - [GlobalizationCultureDto](docs/GlobalizationCultureDto.md)
 - [GlobalizationLocalizatonOption](docs/GlobalizationLocalizatonOption.md)
 - [IOFileSystemEntryInfo](docs/IOFileSystemEntryInfo.md)
 - [ImageByNameInfo](docs/ImageByNameInfo.md)
 - [ImageInfo](docs/ImageInfo.md)
 - [ImageProviderInfo](docs/ImageProviderInfo.md)
 - [ItemCounts](docs/ItemCounts.md)
 - [LibraryAddMediaPath](docs/LibraryAddMediaPath.md)
 - [LibraryAddVirtualFolder](docs/LibraryAddVirtualFolder.md)
 - [LibraryDeleteInfo](docs/LibraryDeleteInfo.md)
 - [LibraryLibraryOptionInfo](docs/LibraryLibraryOptionInfo.md)
 - [LibraryLibraryOptionsResult](docs/LibraryLibraryOptionsResult.md)
 - [LibraryLibraryTypeOptions](docs/LibraryLibraryTypeOptions.md)
 - [LibraryMediaFolder](docs/LibraryMediaFolder.md)
 - [LibraryMediaUpdateInfo](docs/LibraryMediaUpdateInfo.md)
 - [LibraryPostUpdatedMedia](docs/LibraryPostUpdatedMedia.md)
 - [LibraryRenameVirtualFolder](docs/LibraryRenameVirtualFolder.md)
 - [LibrarySubFolder](docs/LibrarySubFolder.md)
 - [LibraryUpdateLibraryOptions](docs/LibraryUpdateLibraryOptions.md)
 - [LibraryUpdateMediaPath](docs/LibraryUpdateMediaPath.md)
 - [LiveTvGetPrograms](docs/LiveTvGetPrograms.md)
 - [LiveTvGuideInfo](docs/LiveTvGuideInfo.md)
 - [LiveTvListingProviderTypeInfo](docs/LiveTvListingProviderTypeInfo.md)
 - [LiveTvListingsProviderInfo](docs/LiveTvListingsProviderInfo.md)
 - [LiveTvLiveTvInfo](docs/LiveTvLiveTvInfo.md)
 - [LiveTvLiveTvServiceInfo](docs/LiveTvLiveTvServiceInfo.md)
 - [LiveTvSeriesTimerInfoDto](docs/LiveTvSeriesTimerInfoDto.md)
 - [LiveTvSetChannelMapping](docs/LiveTvSetChannelMapping.md)
 - [LiveTvTimerInfoDto](docs/LiveTvTimerInfoDto.md)
 - [LiveTvTunerHostInfo](docs/LiveTvTunerHostInfo.md)
 - [LogFile](docs/LogFile.md)
 - [MediaEncodingCodecsCommonTypesBitRate](docs/MediaEncodingCodecsCommonTypesBitRate.md)
 - [MediaEncodingCodecsCommonTypesLevelInformation](docs/MediaEncodingCodecsCommonTypesLevelInformation.md)
 - [MediaEncodingCodecsCommonTypesProfileInformation](docs/MediaEncodingCodecsCommonTypesProfileInformation.md)
 - [MediaEncodingCodecsCommonTypesProfileLevelInformation](docs/MediaEncodingCodecsCommonTypesProfileLevelInformation.md)
 - [MediaEncodingCodecsCommonTypesResolution](docs/MediaEncodingCodecsCommonTypesResolution.md)
 - [MediaEncodingCodecsCommonTypesResolutionWithRate](docs/MediaEncodingCodecsCommonTypesResolutionWithRate.md)
 - [MediaEncodingCodecsVideoCodecsVideoCodecBase](docs/MediaEncodingCodecsVideoCodecsVideoCodecBase.md)
 - [MediaInfoLiveStreamRequest](docs/MediaInfoLiveStreamRequest.md)
 - [MediaInfoLiveStreamResponse](docs/MediaInfoLiveStreamResponse.md)
 - [MediaInfoPlaybackInfoRequest](docs/MediaInfoPlaybackInfoRequest.md)
 - [MediaInfoPlaybackInfoResponse](docs/MediaInfoPlaybackInfoResponse.md)
 - [MediaSourceInfo](docs/MediaSourceInfo.md)
 - [MediaStream](docs/MediaStream.md)
 - [MediaUrl](docs/MediaUrl.md)
 - [MetadataEditorInfo](docs/MetadataEditorInfo.md)
 - [NameIdPair](docs/NameIdPair.md)
 - [NameLongIdPair](docs/NameLongIdPair.md)
 - [NameValuePair](docs/NameValuePair.md)
 - [NetEndPointInfo](docs/NetEndPointInfo.md)
 - [NewsNewsItem](docs/NewsNewsItem.md)
 - [NotificationsNotificationTypeInfo](docs/NotificationsNotificationTypeInfo.md)
 - [ParentalRating](docs/ParentalRating.md)
 - [PlayRequest](docs/PlayRequest.md)
 - [PlaybackProgressInfo](docs/PlaybackProgressInfo.md)
 - [PlaybackReportingApiCustomQuery](docs/PlaybackReportingApiCustomQuery.md)
 - [PlaybackStartInfo](docs/PlaybackStartInfo.md)
 - [PlaybackStopInfo](docs/PlaybackStopInfo.md)
 - [PlayerStateInfo](docs/PlayerStateInfo.md)
 - [PlaylistsPlaylistCreationResult](docs/PlaylistsPlaylistCreationResult.md)
 - [PlaystateRequest](docs/PlaystateRequest.md)
 - [PluginsPluginInfo](docs/PluginsPluginInfo.md)
 - [ProvidersAlbumInfo](docs/ProvidersAlbumInfo.md)
 - [ProvidersArtistInfo](docs/ProvidersArtistInfo.md)
 - [ProvidersBookInfo](docs/ProvidersBookInfo.md)
 - [ProvidersBoxSetInfo](docs/ProvidersBoxSetInfo.md)
 - [ProvidersGameInfo](docs/ProvidersGameInfo.md)
 - [ProvidersMovieInfo](docs/ProvidersMovieInfo.md)
 - [ProvidersMusicVideoInfo](docs/ProvidersMusicVideoInfo.md)
 - [ProvidersPersonLookupInfo](docs/ProvidersPersonLookupInfo.md)
 - [ProvidersRemoteSearchQueryProvidersAlbumInfo](docs/ProvidersRemoteSearchQueryProvidersAlbumInfo.md)
 - [ProvidersRemoteSearchQueryProvidersArtistInfo](docs/ProvidersRemoteSearchQueryProvidersArtistInfo.md)
 - [ProvidersRemoteSearchQueryProvidersBookInfo](docs/ProvidersRemoteSearchQueryProvidersBookInfo.md)
 - [ProvidersRemoteSearchQueryProvidersBoxSetInfo](docs/ProvidersRemoteSearchQueryProvidersBoxSetInfo.md)
 - [ProvidersRemoteSearchQueryProvidersGameInfo](docs/ProvidersRemoteSearchQueryProvidersGameInfo.md)
 - [ProvidersRemoteSearchQueryProvidersMovieInfo](docs/ProvidersRemoteSearchQueryProvidersMovieInfo.md)
 - [ProvidersRemoteSearchQueryProvidersMusicVideoInfo](docs/ProvidersRemoteSearchQueryProvidersMusicVideoInfo.md)
 - [ProvidersRemoteSearchQueryProvidersPersonLookupInfo](docs/ProvidersRemoteSearchQueryProvidersPersonLookupInfo.md)
 - [ProvidersRemoteSearchQueryProvidersSeriesInfo](docs/ProvidersRemoteSearchQueryProvidersSeriesInfo.md)
 - [ProvidersRemoteSearchQueryProvidersTrailerInfo](docs/ProvidersRemoteSearchQueryProvidersTrailerInfo.md)
 - [ProvidersSeriesInfo](docs/ProvidersSeriesInfo.md)
 - [ProvidersSongInfo](docs/ProvidersSongInfo.md)
 - [ProvidersTrailerInfo](docs/ProvidersTrailerInfo.md)
 - [PublicSystemInfo](docs/PublicSystemInfo.md)
 - [QueryFilters](docs/QueryFilters.md)
 - [QueryFiltersLegacy](docs/QueryFiltersLegacy.md)
 - [QueryResultActivityLogEntry](docs/QueryResultActivityLogEntry.md)
 - [QueryResultBaseItemDto](docs/QueryResultBaseItemDto.md)
 - [QueryResultDevicesDeviceInfo](docs/QueryResultDevicesDeviceInfo.md)
 - [QueryResultLiveTvSeriesTimerInfoDto](docs/QueryResultLiveTvSeriesTimerInfoDto.md)
 - [QueryResultLiveTvTimerInfoDto](docs/QueryResultLiveTvTimerInfoDto.md)
 - [QueryResultNewsNewsItem](docs/QueryResultNewsNewsItem.md)
 - [QueryResultSyncModelSyncJobItem](docs/QueryResultSyncModelSyncJobItem.md)
 - [QueryResultSyncSyncJob](docs/QueryResultSyncSyncJob.md)
 - [QueryResultUserLibraryOfficialRatingItem](docs/QueryResultUserLibraryOfficialRatingItem.md)
 - [QueryResultUserLibraryTagItem](docs/QueryResultUserLibraryTagItem.md)
 - [QueueItem](docs/QueueItem.md)
 - [RecommendationDto](docs/RecommendationDto.md)
 - [RemoteImageInfo](docs/RemoteImageInfo.md)
 - [RemoteImageResult](docs/RemoteImageResult.md)
 - [RemoteSearchResult](docs/RemoteSearchResult.md)
 - [RemoteSubtitleInfo](docs/RemoteSubtitleInfo.md)
 - [RokuMetadataApiThumbnailInfo](docs/RokuMetadataApiThumbnailInfo.md)
 - [RokuMetadataApiThumbnailSetInfo](docs/RokuMetadataApiThumbnailSetInfo.md)
 - [SearchSearchHint](docs/SearchSearchHint.md)
 - [SearchSearchHintResult](docs/SearchSearchHintResult.md)
 - [SessionSessionInfo](docs/SessionSessionInfo.md)
 - [SessionUserInfo](docs/SessionUserInfo.md)
 - [SyncModelItemFileInfo](docs/SyncModelItemFileInfo.md)
 - [SyncModelSyncDataRequest](docs/SyncModelSyncDataRequest.md)
 - [SyncModelSyncDataResponse](docs/SyncModelSyncDataResponse.md)
 - [SyncModelSyncDialogOptions](docs/SyncModelSyncDialogOptions.md)
 - [SyncModelSyncJobCreationResult](docs/SyncModelSyncJobCreationResult.md)
 - [SyncModelSyncJobItem](docs/SyncModelSyncJobItem.md)
 - [SyncModelSyncJobRequest](docs/SyncModelSyncJobRequest.md)
 - [SyncModelSyncProfileOption](docs/SyncModelSyncProfileOption.md)
 - [SyncModelSyncQualityOption](docs/SyncModelSyncQualityOption.md)
 - [SyncModelSyncedItem](docs/SyncModelSyncedItem.md)
 - [SyncModelSyncedItemProgress](docs/SyncModelSyncedItemProgress.md)
 - [SyncSyncJob](docs/SyncSyncJob.md)
 - [SyncSyncTarget](docs/SyncSyncTarget.md)
 - [SystemInfo](docs/SystemInfo.md)
 - [TasksTaskInfo](docs/TasksTaskInfo.md)
 - [TasksTaskResult](docs/TasksTaskResult.md)
 - [TasksTaskTriggerInfo](docs/TasksTaskTriggerInfo.md)
 - [ThemeMediaResult](docs/ThemeMediaResult.md)
 - [TranscodingInfo](docs/TranscodingInfo.md)
 - [TupleDoubleDouble](docs/TupleDoubleDouble.md)
 - [UpdateUserEasyPassword](docs/UpdateUserEasyPassword.md)
 - [UpdateUserPassword](docs/UpdateUserPassword.md)
 - [UpdatesInstallationInfo](docs/UpdatesInstallationInfo.md)
 - [UpdatesPackageInfo](docs/UpdatesPackageInfo.md)
 - [UpdatesPackageVersionInfo](docs/UpdatesPackageVersionInfo.md)
 - [UserDto](docs/UserDto.md)
 - [UserItemDataDto](docs/UserItemDataDto.md)
 - [UserLibraryOfficialRatingItem](docs/UserLibraryOfficialRatingItem.md)
 - [UserLibraryTagItem](docs/UserLibraryTagItem.md)
 - [UsersForgotPasswordResult](docs/UsersForgotPasswordResult.md)
 - [UsersPinRedeemResult](docs/UsersPinRedeemResult.md)
 - [UsersUserAction](docs/UsersUserAction.md)
 - [UsersUserPolicy](docs/UsersUserPolicy.md)
 - [ValidatePath](docs/ValidatePath.md)
 - [VirtualFolderInfo](docs/VirtualFolderInfo.md)
 - [WakeOnLanInfo](docs/WakeOnLanInfo.md)
 - [WebDashboardApiConfigurationPageInfo](docs/WebDashboardApiConfigurationPageInfo.md)

## Documentation For Authorization


## apikeyauth

- **Type**: API key
- **API key parameter name**: api_key
- **Location**: URL query string

## embyauth



## Author


