/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.jira.retrofit;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.qameta.allure.jira.retrofit.ServiceException;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Objects;
import okhttp3.ResponseBody;
import retrofit2.Call;
import retrofit2.CallAdapter;
import retrofit2.Response;
import retrofit2.Retrofit;

public final class DefaultCallAdapterFactory<T>
extends CallAdapter.Factory {
    public CallAdapter<T, ?> get(Type returnType, Annotation[] annotations, Retrofit retrofit) {
        if (returnType.getTypeName().startsWith(Call.class.getName())) {
            return null;
        }
        if (returnType.getTypeName().startsWith(Response.class.getName())) {
            return new ResponseCallAdapter(((ParameterizedType)returnType).getActualTypeArguments()[0]);
        }
        return new InstanceCallAdapter(returnType);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getErrorMessage(Response<?> response) {
        try (ResponseBody errorBody = response.errorBody();){
            String string = Objects.isNull(errorBody) ? response.message() : errorBody.string();
            return string;
        }
        catch (IOException e) {
            throw new ServiceException("could not read error body", e);
        }
    }

    @SuppressFBWarnings(value={"NP_NONNULL_RETURN_VIOLATION"})
    private class InstanceCallAdapter
    implements CallAdapter<T, Object> {
        private static final int NOT_FOUND = 404;
        private final Type returnType;

        InstanceCallAdapter(Type returnType) {
            this.returnType = returnType;
        }

        public Type responseType() {
            return this.returnType;
        }

        public Object adapt(Call<T> call) {
            Response response;
            try {
                response = call.execute();
            }
            catch (IOException e) {
                throw new ServiceException("Could not get request body", e);
            }
            if (!response.isSuccessful()) {
                if (response.code() == 404) {
                    return null;
                }
                throw new ServiceException(DefaultCallAdapterFactory.getErrorMessage(response));
            }
            return response.body();
        }
    }

    private class ResponseCallAdapter
    implements CallAdapter<T, Response<T>> {
        private final Type returnType;

        ResponseCallAdapter(Type returnType) {
            this.returnType = returnType;
        }

        public Type responseType() {
            return this.returnType;
        }

        public Response<T> adapt(Call<T> call) {
            Response response;
            try {
                response = call.execute();
            }
            catch (IOException e) {
                throw new ServiceException("Could not execute request", e);
            }
            if (!response.isSuccessful()) {
                throw new ServiceException(DefaultCallAdapterFactory.getErrorMessage(response));
            }
            return response;
        }
    }
}

