/*
 * Decompiled with CFR 0.152.
 */
package io.qameta.allure.jira;

import io.qameta.allure.core.LaunchResults;
import io.qameta.allure.entity.ExecutorInfo;
import io.qameta.allure.entity.Link;
import io.qameta.allure.entity.Statistic;
import io.qameta.allure.entity.TestResult;
import io.qameta.allure.jira.JiraLaunch;
import io.qameta.allure.jira.JiraTestResult;
import io.qameta.allure.jira.LaunchStatisticExport;
import io.qameta.allure.jira.ResultStatus;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class JiraExportUtils {
    private static final String EXECUTORS_BLOCK_NAME = "executor";

    private JiraExportUtils() {
    }

    public static JiraLaunch getJiraLaunch(ExecutorInfo executor, List<LaunchStatisticExport> statistic) {
        return new JiraLaunch().setExternalId(executor.getBuildName()).setStatistic(statistic).setName(executor.getBuildName()).setUrl(executor.getReportUrl()).setDate(Long.valueOf(System.currentTimeMillis()));
    }

    public static Optional<JiraTestResult> getJiraTestResult(ExecutorInfo executor, TestResult testResult) {
        List issues = testResult.getLinks().stream().filter(JiraExportUtils::isIssueLink).map(Link::getName).collect(Collectors.toList());
        if (issues.isEmpty()) {
            return Optional.empty();
        }
        JiraTestResult jiraTestResult = new JiraTestResult().setExternalId(testResult.getUid()).setTestCaseId(testResult.getUid()).setHistoryKey(testResult.getHistoryId()).setName(testResult.getName()).setUrl(JiraExportUtils.getJiraTestResultUrl(executor.getReportUrl(), testResult.getUid())).setStatus(testResult.getStatus().toString()).setColor(JiraExportUtils.findTestResultsStatusColor(testResult)).setDate(testResult.getTime().getStop()).setLaunchUrl(executor.getReportUrl()).setLaunchName(executor.getBuildName()).setLaunchExternalId(executor.getBuildName());
        return Optional.of(jiraTestResult);
    }

    public static List<TestResult> getTestResults(List<LaunchResults> launchesResults) {
        return launchesResults.stream().map(LaunchResults::getAllResults).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public static ExecutorInfo getExecutor(List<LaunchResults> launchesResults) {
        return launchesResults.stream().map(launchResults -> launchResults.getExtra(EXECUTORS_BLOCK_NAME)).filter(Optional::isPresent).map(Optional::get).filter(ExecutorInfo.class::isInstance).map(ExecutorInfo.class::cast).findFirst().orElse(new ExecutorInfo());
    }

    public static Statistic getStatistic(List<LaunchResults> launchesResults) {
        Statistic statistic = new Statistic();
        launchesResults.stream().map(LaunchResults::getAllResults).flatMap(Collection::stream).forEach(arg_0 -> ((Statistic)statistic).update(arg_0));
        return statistic;
    }

    public static List<LaunchStatisticExport> convertStatistics(Statistic statistic) {
        return Stream.of(ResultStatus.values()).filter(resultStatus -> statistic.get(resultStatus.statusName()) != 0L).map(resultStatus -> new LaunchStatisticExport(resultStatus.statusName().value(), resultStatus.color(), statistic.get(resultStatus.statusName()))).collect(Collectors.toList());
    }

    public static String getJiraTestResultUrl(String reportUrl, String uuid) {
        return Optional.ofNullable(reportUrl).map(url -> url.endsWith("index.html") ? "%s#testresult/%s" : "%s/#testresult/%s").map(pattern -> String.format(pattern, reportUrl, uuid)).orElse(null);
    }

    public static boolean isIssueLink(Link link) {
        return "issue".equals(link.getType());
    }

    public static List<String> splitByComma(String value) {
        return Arrays.asList(value.split(","));
    }

    private static String findTestResultsStatusColor(TestResult testResult) {
        return Stream.of(ResultStatus.values()).filter(resultStatus -> testResult.getStatus() == resultStatus.statusName()).findFirst().orElseThrow(() -> new IllegalArgumentException("There is no such status as " + testResult.getStatus().value())).color();
    }
}

