/*
 * Decompiled with CFR 0.152.
 */
package com.opencsv.bean;

import com.opencsv.CSVReader;
import com.opencsv.bean.AbstractBeanField;
import com.opencsv.bean.AbstractCsvConverter;
import com.opencsv.bean.AbstractMappingStrategy;
import com.opencsv.bean.BeanField;
import com.opencsv.bean.BeanFieldJoinIntegerIndex;
import com.opencsv.bean.BeanFieldSingleValue;
import com.opencsv.bean.BeanFieldSplit;
import com.opencsv.bean.ComplexFieldMapEntry;
import com.opencsv.bean.CsvBindAndJoinByPosition;
import com.opencsv.bean.CsvBindAndSplitByPosition;
import com.opencsv.bean.CsvBindByPosition;
import com.opencsv.bean.CsvConverter;
import com.opencsv.bean.CsvCustomBindByPosition;
import com.opencsv.bean.FieldMap;
import com.opencsv.bean.FieldMapByPosition;
import com.opencsv.bean.FieldMapByPositionEntry;
import com.opencsv.exceptions.CsvBadConverterException;
import com.opencsv.exceptions.CsvRequiredFieldEmptyException;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.ResourceBundle;
import org.apache.commons.collections4.MultiValuedMap;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.reflect.FieldUtils;

public class ColumnPositionMappingStrategy<T>
extends AbstractMappingStrategy<String, Integer, ComplexFieldMapEntry<String, Integer, T>, T> {
    private boolean columnsExplicitlySet = false;
    private FieldMapByPosition<T> fieldMap;
    private Comparator<Integer> writeOrder;
    private Integer[] columnIndexForWriting = null;

    @Override
    public void captureHeader(CSVReader reader) throws IOException {
        if (this.type == null) {
            throw new IllegalStateException(ResourceBundle.getBundle("opencsv", this.errorLocale).getString("type.unset"));
        }
        String[] firstLine = (String[])ObjectUtils.defaultIfNull((Object)reader.peek(), (Object)ArrayUtils.EMPTY_STRING_ARRAY);
        this.fieldMap.setMaxIndex(firstLine.length - 1);
        if (!this.columnsExplicitlySet) {
            this.headerIndex.clear();
            for (FieldMapByPositionEntry<T> entry : this.fieldMap) {
                Field f = entry.getField().getField();
                if (f.getAnnotation(CsvCustomBindByPosition.class) == null && f.getAnnotation(CsvBindAndSplitByPosition.class) == null && f.getAnnotation(CsvBindAndJoinByPosition.class) == null && f.getAnnotation(CsvBindByPosition.class) == null) continue;
                this.headerIndex.put(entry.getPosition(), f.getName().toUpperCase().trim());
            }
        }
    }

    @Override
    protected Object chooseMultivaluedFieldIndexFromHeaderIndex(int index) {
        return index;
    }

    @Override
    public BeanField<T> findField(int col) {
        if (this.columnIndexForWriting != null) {
            return col < this.columnIndexForWriting.length ? this.fieldMap.get(this.columnIndexForWriting[col]) : null;
        }
        return this.fieldMap.get(col);
    }

    @Override
    public String[] generateHeader(T bean) throws CsvRequiredFieldEmptyException {
        String[] h = super.generateHeader(bean);
        this.columnIndexForWriting = new Integer[h.length];
        for (int i = 0; i < this.columnIndexForWriting.length; ++i) {
            this.columnIndexForWriting[i] = i;
        }
        Arrays.sort(this.columnIndexForWriting, this.writeOrder);
        return ArrayUtils.EMPTY_STRING_ARRAY;
    }

    @Override
    public String getColumnName(int col) {
        return this.headerIndex.getByPosition(col);
    }

    public String[] getColumnMapping() {
        return this.headerIndex.getHeaderIndex();
    }

    public void setColumnMapping(String ... columnMapping) {
        if (columnMapping != null) {
            this.headerIndex.initializeHeaderIndex(columnMapping);
        } else {
            this.headerIndex.clear();
        }
        this.columnsExplicitlySet = true;
    }

    @Override
    protected void loadFieldMap() throws CsvBadConverterException {
        this.fieldMap = new FieldMapByPosition(this.errorLocale);
        this.fieldMap.setColumnOrderOnWrite(this.writeOrder);
        for (Field field : this.loadFields(this.getType())) {
            String format;
            String capture;
            String fieldLocale;
            boolean required;
            Object converter;
            Annotation annotation;
            if (field.isAnnotationPresent(CsvCustomBindByPosition.class)) {
                annotation = field.getAnnotation(CsvCustomBindByPosition.class);
                converter = annotation.converter();
                BeanField bean = this.instantiateCustomConverter((Class<? extends AbstractBeanField>)converter);
                bean.setField(field);
                required = annotation.required();
                bean.setRequired(required);
                this.fieldMap.put(annotation.position(), bean);
                continue;
            }
            if (field.isAnnotationPresent(CsvBindAndSplitByPosition.class)) {
                annotation = field.getAnnotation(CsvBindAndSplitByPosition.class);
                required = annotation.required();
                fieldLocale = annotation.locale();
                String splitOn = annotation.splitOn();
                String writeDelimiter = annotation.writeDelimiter();
                Class<? extends Collection> collectionType = annotation.collectionType();
                Class<?> elementType = annotation.elementType();
                Class<? extends AbstractCsvConverter> splitConverter = annotation.converter();
                capture = annotation.capture();
                format = annotation.format();
                CsvConverter converter2 = this.determineConverter(field, elementType, fieldLocale, splitConverter);
                this.fieldMap.put(annotation.position(), new BeanFieldSplit(field, required, this.errorLocale, converter2, splitOn, writeDelimiter, collectionType, capture, format));
                continue;
            }
            if (field.isAnnotationPresent(CsvBindAndJoinByPosition.class)) {
                annotation = field.getAnnotation(CsvBindAndJoinByPosition.class);
                required = annotation.required();
                fieldLocale = annotation.locale();
                Class<?> elementType = annotation.elementType();
                Class<? extends MultiValuedMap> mapType = annotation.mapType();
                Class<? extends AbstractCsvConverter> joinConverter = annotation.converter();
                capture = annotation.capture();
                format = annotation.format();
                CsvConverter converter3 = this.determineConverter(field, elementType, fieldLocale, joinConverter);
                this.fieldMap.putComplex(annotation.position(), new BeanFieldJoinIntegerIndex(field, required, this.errorLocale, converter3, mapType, capture, format));
                continue;
            }
            annotation = field.getAnnotation(CsvBindByPosition.class);
            required = annotation.required();
            fieldLocale = annotation.locale();
            capture = annotation.capture();
            format = annotation.format();
            converter = this.determineConverter(field, field.getType(), fieldLocale, null);
            this.fieldMap.put(annotation.position(), new BeanFieldSingleValue(field, required, this.errorLocale, (CsvConverter)converter, capture, format));
        }
    }

    @Override
    public void verifyLineLength(int numberOfFields) throws CsvRequiredFieldEmptyException {
        if (!this.headerIndex.isEmpty()) {
            StringBuilder sb = null;
            for (int i = numberOfFields; i <= this.headerIndex.findMaxIndex(); ++i) {
                BeanField<T> f = this.findField(i);
                if (f == null || !f.isRequired()) continue;
                if (sb == null) {
                    sb = new StringBuilder(ResourceBundle.getBundle("opencsv", this.errorLocale).getString("multiple.required.field.empty"));
                }
                sb.append(' ');
                sb.append(f.getField().getName());
            }
            if (sb != null) {
                throw new CsvRequiredFieldEmptyException(this.type, sb.toString());
            }
        }
    }

    private List<Field> loadFields(Class<? extends T> cls) {
        LinkedList<Field> fields = new LinkedList<Field>();
        for (Field field : FieldUtils.getAllFields(cls)) {
            if (!field.isAnnotationPresent(CsvBindByPosition.class) && !field.isAnnotationPresent(CsvCustomBindByPosition.class) && !field.isAnnotationPresent(CsvBindAndJoinByPosition.class) && !field.isAnnotationPresent(CsvBindAndSplitByPosition.class)) continue;
            fields.add(field);
        }
        this.setAnnotationDriven(!fields.isEmpty());
        return fields;
    }

    @Override
    public String findHeader(int col) {
        return Integer.toString(col);
    }

    @Override
    protected FieldMap<String, Integer, ? extends ComplexFieldMapEntry<String, Integer, T>, T> getFieldMap() {
        return this.fieldMap;
    }

    public void setColumnOrderOnWrite(Comparator<Integer> writeOrder) {
        this.writeOrder = writeOrder;
        if (this.fieldMap != null) {
            this.fieldMap.setColumnOrderOnWrite(this.writeOrder);
        }
    }
}

