"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
import PyQt6.sip
from PyQt6.QAxContainer import *


class QAxBase(PyQt6.sip.simplewrapper):
    """
    https://doc.qt.io/qt-6/qaxbase.html

    **Detailed Description**

    QAxBase is an abstract class that cannot be used directly, and is
    instantiated through the subclasses **QAxObject**  and **QAxWidget** . This
    class provides the API to access the COM object directly through its
    IUnknown implementation. If the COM object implements the IDispatch
    interface, the properties and methods of that object become available as Qt
    properties and slots.

    connect(buttonBack, SIGNAL(clicked()), webBrowser, SLOT(GoBack()));

    Properties exposed by the object's IDispatch implementation can be read and
    written through the property system provided by the Qt Object Model (both
    subclasses are **QObject** s, so you can use **QObject::setProperty** () and
    **QObject::property** ()). Properties with multiple parameters are not
    supported.

    activeX->setProperty("text", "some text");
        int value =
    activeX->property("value");

    Write-functions for properties and other methods exposed by the object's
    IDispatch implementation can be called directly using **dynamicCall** (), or
    indirectly as slots connected to a signal.

    webBrowser->dynamicCall("GoHome()");

    Outgoing events supported by the COM object are emitted as standard Qt
    signals.

    connect(webBrowser, SIGNAL(TitleChanged(**QString** )),
                this,
    SLOT(setCaption(**QString** )));

    QAxBase transparently converts between COM data types and the equivalent Qt
    data types. Some COM types have no equivalent Qt data structure.

    Supported COM datatypes are listed in the first column of following table.
    The second column is the Qt type that can be used with the **QObject**
    property functions. The third column is the Qt type that is used in the
    prototype of generated signals and slots for in-parameters, and the last
    column is the Qt type that is used in the prototype of signals and slots for
    out-parameters.

    COM typeQt propertyin-parameterout-parameter
    VARIANT_BOOLboolboolbool&
    BSTR**QString** const **QString** &**QString** &
    char, short, int,
    longintintint&
    uchar, ushort, uint, ulonguintuintuint&
    float,
    doubledoubledoubledouble&
    DATE**QDateTime** const **QDateTime**
    &**QDateTime** &
    CYqlonglongqlonglongqlonglong&
    OLE_COLOR**QColor**
    const **QColor** &**QColor** &
    SAFEARRAY(VARIANT)**QList** <**QVariant**
    >const **QList** <**QVariant** >&**QList** <**QVariant** >&
    SAFEARRAY(int), SAFEARRAY(double), SAFEARRAY(Date)**QList** <**QVariant**
    >const **QList** <**QVariant** >&**QList** <**QVariant** >&
    SAFEARRAY(BYTE)**QByteArray** const **QByteArray** &**QByteArray** &
    SAFEARRAY(BSTR)**QStringList** const **QStringList** &**QStringList** &
    VARIANTtype-dependentconst **QVariant** &**QVariant** &
    IFontDisp***QFont** const **QFont** &**QFont** &
    IPictureDisp***QPixmap**
    const **QPixmap** &**QPixmap** &
    IDispatch***QAxObject**
    *`QAxBase::asVariant()`**QAxObject** * (return value)
    IUnknown***QAxObject** *`QAxBase::asVariant()`**QAxObject** * (return value)
    SCODE, DECIMAL **unsupported** **unsupported** **unsupported**
    VARIANT*
    (Since Qt 4.5) **unsupported** **QVariant &** **QVariant &**

    Supported are also enumerations, and typedefs to supported types.

    To call the methods of a COM interface described by the following IDL

    dispinterface IControl
        {
        properties:
            [id(1)] BSTR text;
    [id(2)] IFontDisp *font;

        methods:
            [id(6)] void
    showColumn([in] int i);
            [id(3)] bool addColumn([in] BSTR t);
    [id(4)] int fillList([in, out] SAFEARRAY(VARIANT) *list);
            [id(5)]
    IDispatch *item([in] int i);
        };

    use the QAxBase API like this:

    **QAxObject**  object("<CLSID>");

        **QString**  text =
    object.property("text").toString();
        object.setProperty("font", **QFont**
    ("Times New Roman", 12));

        connect(this, SIGNAL(clicked(int)),
    &object, SLOT(showColumn(int)));
        bool ok =
    object.dynamicCall("addColumn(const QString&)", "Column 1").toBool();
    **QList** <**QVariant** > varlist;
        **QList** <**QVariant** > parameters;
    parameters << **QVariant** (varlist);
        int n =
    object.dynamicCall("fillList(QList<QVariant>&)", parameters).toInt();
    **QAxObject**  *item = object.querySubItem("item(int)", 5);

    Note that the **QList**  the object should fill has to be provided as an
    element in the parameter list of **QVariant** s.

    If you need to access properties or pass parameters of unsupported datatypes
    you must access the COM object directly through its `IDispatch`
    implementation or other interfaces. Those interfaces can be retrieved
    through **queryInterface** ().

    IUnknown *iface = 0;
        activeX->queryInterface(IID_IUnknown,
    (void**)&iface);
        if (iface) {
            // use the interface
    iface->Release();
        }

    To get the definition of the COM interfaces you will have to use the header
    files provided with the component you want to use. Some compilers can also
    import type libraries using the #import compiler directive. See the
    component documentation to find out which type libraries you have to import,
    and how to use them.

    If you need to react to events that pass parameters of unsupported datatypes
    you can use the generic signal that delivers the event data as provided by
    the COM event.

    **See also** **QAxObject** , **QAxWidget** , **QAxScript** , and **ActiveQt
    Framework** .
    """

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qaxbase.html#QAxBase

        **[protected] QAxBase::QAxBase()**

        Creates a QAxBase object.
        """
        ...

    @typing.overload
    def __init__(self, a0: "QAxBase") -> None:
        """
        https://doc.qt.io/qt-6/qaxbase.html#QAxBase

        **[protected] QAxBase::QAxBase()**

        Creates a QAxBase object.
        """
        ...

    def setClassContext(self, classContext: int) -> None:
        """
        https://doc.qt.io/qt-6/qaxbase.html#setClassContext

        **[since 5.13] void QAxBase::setClassContext(ulong classContext )**

        Sets the context the ActiveX control will run in to **classContext**

        Affects the "dwClsContext" argument when calling CoCreateInstance. This
        can be used to control in-proc vs. out-of-proc startup for controls
        supporting both alternatives. Also, it can be used to modify/reduce
        control permissions when used with CLSCTX_ENABLE_CLOAKING and an
        impersonation token.

        Note that this function must be called before setControl() to have any
        effect.

        This function was introduced in Qt 5.13.

        **See also** **classContext** ().
        """
        ...

    def classContext(self) -> int:
        """
        https://doc.qt.io/qt-6/qaxbase.html#classContext

        **[since 5.13] ulong QAxBase::classContext() const**

        Returns the context the ActiveX control will run in (default
        CLSCTX_SERVER).

        This function was introduced in Qt 5.13.

        **See also** **setClassContext** ().
        """
        ...

    def disableEventSink(self) -> None:
        """
        https://doc.qt.io/qt-6/qaxbase.html#disableEventSink

        **void QAxBase::disableEventSink()**

        Disables the event sink implementation for this ActiveX container. If
        you don't intend to listen to the ActiveX control's events use this
        function to speed up the meta object generation.

        Some ActiveX controls might be unstable when connected to an event sink.
        To get OLE events you must use standard COM methods to register your own
        event sink. Use **queryInterface** () to get access to the raw COM
        object.

        Note that this function should be called immediately after construction
        of the object.
        """
        ...

    def disableClassInfo(self) -> None:
        """
        https://doc.qt.io/qt-6/qaxbase.html#disableClassInfo

        **void QAxBase::disableClassInfo()**

        Disables the class info generation for this ActiveX container. If you
        don't require any class information about the ActiveX control use this
        function to speed up the meta object generation.

        Note that this function must be called immediately after construction of
        the object
        """
        ...

    def disableMetaObject(self) -> None:
        """
        https://doc.qt.io/qt-6/qaxbase.html#disableMetaObject

        **void QAxBase::disableMetaObject()**

        Disables the meta object generation for this ActiveX container. This
        also disables the event sink and class info generation. If you don't
        intend to use the Qt meta object implementation call this function to
        speed up instantiation of the control. You will still be able to call
        the object through **dynamicCall** (), but signals, slots and properties
        will not be available with **QObject**  APIs.

        Some ActiveX controls might be unstable when used with OLE automation.
        Use standard COM methods to use those controls through the COM
        interfaces provided by **queryInterface** ().

        Note that this function must be called immediately after construction of
        the object.
        """
        ...

    def setControl(self, a0: str) -> bool:
        """
        https://doc.qt.io/qt-6/qaxbase.html#control

        **QString QAxBase::control() const**

        Returns the ActiveX control.
        """
        ...

    def clear(self) -> None:
        """
        https://doc.qt.io/qt-6/qaxbase.html#clear

        **void QAxBase::clear()**

        Disconnects and destroys the COM object.

        If you reimplement this function you must also reimplement the
        destructor to call clear(), and call this implementation at the end of
        your clear() function.
        """
        ...

    def asVariant(self) -> typing.Any:
        """
        https://doc.qt.io/qt-6/qaxbase.html#asVariant

        **QVariant QAxBase::asVariant() const**

        Returns a **QVariant**  that wraps the COM object. The variant can then
        be used as a parameter in e.g. **dynamicCall** ().
        """
        ...

    def verbs(self) -> typing.List[str]:
        """
        https://doc.qt.io/qt-6/qaxbase.html#verbs

        **QStringList QAxBase::verbs() const**

        Returns the list of verbs that the COM object can execute. If the object
        does not implement IOleObject, or does not support any verbs, then this
        function returns an empty stringlist.

        Note that the OLE default verbs (OLEIVERB_SHOW etc) are not included in
        the list.
        """
        ...

    def isNull(self) -> bool:
        """
        https://doc.qt.io/qt-6/qaxbase.html#isNull

        **bool QAxBase::isNull() const**

        Returns true if there is no COM object loaded by this wrapper; otherwise
        return false.

        **See also** **control** ().
        """
        ...

    def setPropertyWritable(self, a0: str, a1: bool) -> None:
        """
        https://doc.qt.io/qt-6/qaxbase.html#setPropertyWritable

        **[virtual] void QAxBase::setPropertyWritable(const char * prop , bool
        ok )**

        Sets the property **prop** to writable if **ok** is true, otherwise sets
        **prop** to be read-only. By default, all properties are writable.

        **Warning:** Depending on the control implementation this setting might
        be ignored for some properties.

        **See also** **propertyWritable** (), **QAxBaseWidget::propertyChanged**
        (), and **QAxBaseObject::propertyChanged** ().
        """
        ...

    def propertyWritable(self, a0: str) -> bool:
        """
        https://doc.qt.io/qt-6/qaxbase.html#propertyWritable

        **[virtual] bool QAxBase::propertyWritable(const char * prop ) const**

        Returns true if the property **prop** is writable; otherwise returns
        false. By default, all properties are writable.

        **Warning:** Depending on the control implementation this setting might
        be ignored for some properties.

        **See also** **setPropertyWritable** (),
        **QAxBaseWidget::propertyChanged** (), and
        **QAxBaseObject::propertyChanged** ().
        """
        ...

    def generateDocumentation(self) -> str:
        """
        https://doc.qt.io/qt-6/qaxbase.html#generateDocumentation

        **QString QAxBase::generateDocumentation()**

        Returns a rich text string with documentation for the wrapped COM
        object. Dump the string to an HTML-file, or use it in e.g. a
        **QTextBrowser**  widget.
        """
        ...

    def setPropertyBag(self, a0: typing.Dict[str, typing.Any]) -> None:
        """
        https://doc.qt.io/qt-6/qaxbase.html#setPropertyBag

        **void QAxBase::setPropertyBag(const QAxBase::PropertyBag & bag )**

        Sets the properties of the COM object to the corresponding values in
        **bag**.

        **Warning:** You should only set property bags that have been returned
        by the **propertyBag**  function, as it cannot be guaranteed that the
        property bag implementation of the COM object supports the same
        properties that are available through the IDispatch interface.

        **See also** **propertyBag** ().
        """
        ...

    def propertyBag(self) -> typing.Dict[str, typing.Any]:
        """
        https://doc.qt.io/qt-6/qaxbase.html#propertyBag

        **QAxBase::PropertyBag QAxBase::propertyBag() const**

        Returns a name:value map of all the properties exposed by the COM
        object.

        This is more efficient than getting multiple properties individually if
        the COM object supports property bags.

        **Warning:** It is not guaranteed that the property bag implementation
        of the COM object returns all properties, or that the properties
        returned are the same as those available through the IDispatch
        interface.

        **See also** **setPropertyBag** ().
        """
        ...

    @typing.overload
    def querySubObject(self, a0: str, a1: typing.Iterable[typing.Any]) -> "QAxObject":
        """
        https://doc.qt.io/qt-6/qaxbase.html#querySubObject

        **QAxObject *QAxBase::querySubObject(const char * name , const QVariant
        & var1 = QVariant(), const QVariant & var2 = QVariant(), const QVariant
        & var3 = QVariant(), const QVariant & var4 = QVariant(), const QVariant
        & var5 = QVariant(), const QVariant & var6 = QVariant(), const QVariant
        & var7 = QVariant(), const QVariant & var8 = QVariant())**

        Returns a pointer to a **QAxObject**  wrapping the COM object provided
        by the method or property **name** , passing passing the parameters
        **var1** , **var1** , **var2** , **var3** , **var4** , **var5** ,
        **var6** , **var7** and **var8**.

        If **name** is provided by a method the string must include the full
        function prototype.

        If **name** is a property the string must be the name of the property,
        and **var1** , ... **var8** are ignored.

        The returned **QAxObject**  is a child of this object (which is either
        of type **QAxObject**  or **QAxWidget** ), and is deleted when this
        object is deleted. It is however safe to delete the returned object
        yourself, and you should do so when you iterate over lists of
        subobjects.

        COM enabled applications usually have an object model publishing certain
        elements of the application as dispatch interfaces. Use this method to
        navigate the hierarchy of the object model, e.g.

        **QAxWidget**  outlook("Outlook.Application");
            **QAxObject**
        *session = outlook.querySubObject("Session");
            if (session) {
        **QAxObject**  *defFolder = session->querySubObject(
        "GetDefaultFolder(OlDefaultFolders)",
        "olFolderContacts");
                //...
            }
        """
        ...

    @typing.overload
    def querySubObject(
        self,
        a0: str,
        value1: typing.Any = ...,
        value2: typing.Any = ...,
        value3: typing.Any = ...,
        value4: typing.Any = ...,
        value5: typing.Any = ...,
        value6: typing.Any = ...,
        value7: typing.Any = ...,
        value8: typing.Any = ...,
    ) -> "QAxObject":
        """
        https://doc.qt.io/qt-6/qaxbase.html#querySubObject-1

        **QAxObject *QAxBase::querySubObject(const char * name , QList<QVariant>
        & vars )**

        This is an overloaded function.

        The **QVariant**  objects in **vars** are updated when the method has
        out-parameters.
        """
        ...

    @typing.overload
    def dynamicCall(self, a0: str, a1: typing.Iterable[typing.Any]) -> typing.Any:
        """
        https://doc.qt.io/qt-6/qaxbase.html#dynamicCall

        **QVariant QAxBase::dynamicCall(const char * function , const QVariant &
        var1 = QVariant(), const QVariant & var2 = QVariant(), const QVariant &
        var3 = QVariant(), const QVariant & var4 = QVariant(), const QVariant &
        var5 = QVariant(), const QVariant & var6 = QVariant(), const QVariant &
        var7 = QVariant(), const QVariant & var8 = QVariant())**

        Calls the COM object's method **function** , passing the parameters
        **var1** , **var1** , **var2** , **var3** , **var4** , **var5** ,
        **var6** , **var7** and **var8** , and returns the value returned by the
        method, or an invalid **QVariant**  if the method does not return a
        value or when the function call failed.

        If **function** is a method of the object the string must be provided as
        the full prototype, for example as it would be written in a
        **QObject::connect** () call.

        activeX->dynamicCall("Navigate(const QString&)", "www.qt-project.org");

        Alternatively a function can be called passing the parameters embedded
        in the string, e.g. above function can also be invoked using

        activeX->dynamicCall("Navigate(\\"www.qt-project.org\\")");

        All parameters are passed as strings; it depends on the control whether
        they are interpreted correctly, and is slower than using the prototype
        with correctly typed parameters.

        If **function** is a property the string has to be the name of the
        property. The property setter is called when **var1** is a valid
        **QVariant** , otherwise the getter is called.

        activeX->dynamicCall("Value", 5);
            **QString**  text =
        activeX->dynamicCall("Text").toString();

        Note that it is faster to get and set properties using
        **QObject::property** () and **QObject::setProperty** ().

        dynamicCall() can also be used to call objects with a **disabled
        metaobject**  wrapper, which can improve performance significantely,
        esp. when calling many different objects of different types during an
        automation process. ActiveQt will then however not validate parameters.

        It is only possible to call functions through dynamicCall() that have
        parameters or return values of datatypes supported by **QVariant** . See
        the **QAxBase**  class documentation for a list of supported and
        unsupported datatypes. If you want to call functions that have
        unsupported datatypes in the parameter list, use **queryInterface** ()
        to retrieve the appropriate COM interface, and use the function
        directly.

        IWebBrowser2 *webBrowser = 0;
        activeX->queryInterface(IID_IWebBrowser2, (void **)&webBrowser);
            if
        (webBrowser) {
                webBrowser->Navigate2(pvarURL);
        webBrowser->Release();
            }

        This is also more efficient.
        """
        ...

    @typing.overload
    def dynamicCall(
        self,
        a0: str,
        value1: typing.Any = ...,
        value2: typing.Any = ...,
        value3: typing.Any = ...,
        value4: typing.Any = ...,
        value5: typing.Any = ...,
        value6: typing.Any = ...,
        value7: typing.Any = ...,
        value8: typing.Any = ...,
    ) -> typing.Any:
        """
        https://doc.qt.io/qt-6/qaxbase.html#dynamicCall-1

        **QVariant QAxBase::dynamicCall(const char * function , QList<QVariant>
        & vars )**

        This is an overloaded function.

        Calls the COM object's method **function** , passing the parameters in
        **vars** , and returns the value returned by the method. If the method
        does not return a value or when the function call failed this function
        returns an invalid **QVariant**  object.

        The **QVariant**  objects in **vars** are updated when the method has
        out-parameters.
        """
        ...

    def control(self) -> str:
        """
        https://doc.qt.io/qt-6/qaxbase.html#control

        **QString QAxBase::control() const**

        Returns the ActiveX control.
        """
        ...
