"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
from PyQt6.QAxContainer import *


class QAxObject(QAxBaseObject, QAxBase):
    """
    https://doc.qt.io/qt-6/qaxobject.html

    **Detailed Description**

    A QAxObject can be instantiated as an empty object, with the name of the COM
    object it should wrap, or with a pointer to the IUnknown that represents an
    existing COM object. If the COM object implements the `IDispatch` interface,
    the properties, methods and events of that object become available as Qt
    properties, slots and signals. The base class, **QAxBase** , provides an API
    to access the COM object directly through the IUnknown pointer.

    QAxObject is a **QObject**  and can be used as such, e.g. it can be
    organized in an object hierarchy, receive events and connect to signals and
    slots.

    QAxObject also inherits most of its ActiveX-related functionality from
    **QAxBase** , notably **dynamicCall** () and **querySubObject** ().

    **Warning:** You can subclass QAxObject, but you cannot use the **Q_OBJECT**
    macro in the subclass (the generated moc-file will not compile), so you
    cannot add further signals, slots or properties. This limitation is due to
    the metaobject information generated in runtime. To work around this
    problem, aggregate the QAxObject as a member of the **QObject**  subclass.

    **See also** **QAxBase** , **QAxWidget** , **QAxScript** , and **ActiveQt
    Framework** .
    """

    @typing.overload
    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-6/qaxobject.html#QAxObject

        **QAxObject::QAxObject(QObject * parent = nullptr)**

        Creates an empty COM object and propagates **parent** to the **QObject**
        constructor. To initialize the object, call setControl().

        **See also** **setControl()** .
        """
        ...

    @typing.overload
    def __init__(self, a0: str, parent: typing.Optional[QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-6/qaxobject.html#QAxObject-1

        **QAxObject::QAxObject(const QString & c , QObject * parent = nullptr)**

        Creates a QAxObject that wraps the COM object **c**. **parent** is
        propagated to the **QObject**  constructor.

        **See also** **setControl()** .
        """
        ...

    def connectNotify(self, a0: QtCore.QMetaMethod) -> None:
        """
        https://doc.qt.io/qt-6/qaxobject.html#connectNotify

        **[override virtual protected] void QAxObject::connectNotify(const
        QMetaMethod & signal )**

        Reimplements: **QObject::connectNotify** (const QMetaMethod &signal).
        """
        ...

    def doVerb(self, a0: str) -> bool:
        """
        https://doc.qt.io/qt-6/qaxobject.html#doVerb

        **bool QAxObject::doVerb(const QString & verb )**

        Requests the COM object to perform the action **verb**. The possible
        verbs are returned by **verbs** ().

        The function returns true if the object could perform the action,
        otherwise returns false.
        """
        ...

    def clear(self) -> None:
        ...

    def resetControl(self) -> None:
        ...

    def setControl(self, c: str) -> bool:
        ...

    def control(self) -> str:
        ...

    def setClassContext(self, classContext: int) -> None:
        ...

    def classContext(self) -> int:
        ...
