"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
from PyQt6 import QtWidgets
from PyQt6.QAxContainer import *


class QAxWidget(QAxBaseWidget, QAxBase):
    """
    https://doc.qt.io/qt-6/qaxwidget.html

    **Detailed Description**

    A QAxWidget can be instantiated as an empty object, with the name of the
    ActiveX control it should wrap, or with an existing interface pointer to the
    ActiveX control. The ActiveX control's properties, methods and events which
    only use **QAxBase**  supported data types, become available as Qt
    properties, slots and signals. The base class **QAxBase**  provides an API
    to access the ActiveX directly through the `IUnknown` pointer.

    QAxWidget is a **QWidget**  and can mostly be used as such, e.g. it can be
    organized in a widget hierarchy and layouts or act as an event filter.
    Standard widget properties, e.g. **enabled**  are supported, but it depends
    on the ActiveX control to implement support for ambient properties like e.g.
    palette or font. QAxWidget tries to provide the necessary hints.

    However, you cannot reimplement Qt-specific event handlers like
    mousePressEvent or keyPressEvent and expect them to be called reliably. The
    embedded control covers the QAxWidget completely, and usually handles the
    user interface itself. Use control-specific APIs (i.e. listen to the signals
    of the control), or use standard COM techniques like window procedure
    subclassing.

    QAxWidget also inherits most of its ActiveX-related functionality from
    **QAxBase** , notably **dynamicCall** () and **querySubObject** ().

    **Warning:** You can subclass QAxWidget, but you cannot use the `Q_OBJECT`
    macro in the subclass (the generated moc-file will not compile), so you
    cannot add further signals, slots or properties. This limitation is due to
    the metaobject information generated in runtime. To work around this
    problem, aggregate the QAxWidget as a member of the **QObject**  subclass.

    **See also** **QAxBase** , **QAxObject** , **QAxScript** , and **ActiveQt
    Framework** .
    """

    @typing.overload
    def __init__(
        self,
        parent: typing.Optional[QtWidgets.QWidget] = ...,
        flags: QtCore.Qt.WindowType = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qaxwidget.html#QAxWidget

        **QAxWidget::QAxWidget(QWidget * parent = nullptr, Qt::WindowFlags f =
        Qt::WindowFlags())**

        Creates an empty QAxWidget widget and propagates **parent** and **f** to
        the **QWidget**  constructor. To initialize a control, call
        **setControl** ().
        """
        ...

    @typing.overload
    def __init__(
        self,
        a0: str,
        parent: typing.Optional[QtWidgets.QWidget] = ...,
        flags: QtCore.Qt.WindowType = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qaxwidget.html#QAxWidget-1

        **QAxWidget::QAxWidget(const QString & c , QWidget * parent = nullptr,
        Qt::WindowFlags f = Qt::WindowFlags())**

        Creates an QAxWidget widget and initializes the ActiveX control **c**.
        **parent** and **f** are propagated to the **QWidget**  contructor.

        **See also** **setControl** ().
        """
        ...

    def connectNotify(self, a0: QtCore.QMetaMethod) -> None:
        """
        https://doc.qt.io/qt-6/qaxwidget.html#connectNotify

        **[override virtual protected] void QAxWidget::connectNotify(const
        QMetaMethod & signal )**

        Reimplements: **QObject::connectNotify** (const QMetaMethod &signal).
        """
        ...

    def translateKeyEvent(self, a0: int, a1: int) -> bool:
        """
        https://doc.qt.io/qt-6/qaxwidget.html#translateKeyEvent

        **[virtual protected] bool QAxWidget::translateKeyEvent(int message ,
        int keycode ) const**

        Reimplement this function to pass certain key events to the ActiveX
        control. **message** is the Window message identifier specifying the
        message type (ie. WM_KEYDOWN), and **keycode** is the virtual keycode
        (ie. VK_TAB).

        If the function returns true the key event is passed on to the ActiveX
        control, which then either processes the event or passes the event on to
        Qt.

        If the function returns false the processing of the key event is ignored
        by ActiveQt, ie. the ActiveX control might handle it or not.

        The default implementation returns true for the following cases:

        WM_SYSKEYDOWNWM_SYSKEYUPWM_KEYDOWN
        All keycodesVK_MENUVK_TAB,
        VK_DELETE and all non-arrow-keys in combination with VK_SHIFT,
        VK_CONTROL or VK_MENU

        This table is the result of experimenting with popular ActiveX controls,
        ie. Internet Explorer and Microsoft Office applications, but for some
        controls it might require modification.
        """
        ...

    def resizeEvent(self, a0: QtGui.QResizeEvent) -> None:
        """
        https://doc.qt.io/qt-6/qaxwidget.html#resizeEvent

        **[override virtual protected] void QAxWidget::resizeEvent(QResizeEvent
        *)**

        Reimplements: **QWidget::resizeEvent** (QResizeEvent *event).
        """
        ...

    def changeEvent(self, a0: QtCore.QEvent) -> None:
        """
        https://doc.qt.io/qt-6/qaxwidget.html#changeEvent

        **[override virtual protected] void QAxWidget::changeEvent(QEvent * e
        )**

        Reimplements: **QWidget::changeEvent** (QEvent *event).
        """
        ...

    @typing.overload
    def createHostWindow(self, a0: bool) -> bool:
        """
        https://doc.qt.io/qt-6/qaxwidget.html#createHostWindow

        **[virtual protected] bool QAxWidget::createHostWindow(bool initialized
        )**

        Creates the client site for the ActiveX control, and returns true if the
        control could be embedded successfully, otherwise returns false. If
        **initialized** is true the control has already been initialized.

        This function is called by **initialize** (). If you reimplement
        initialize to customize the actual control instantiation, call this
        function in your reimplementation to have the control embedded by the
        default client side. Creates the client site for the ActiveX control,
        and returns true if the control could be embedded successfully,
        otherwise returns false.
        """
        ...

    @typing.overload
    def createHostWindow(self, a0: bool, a1: QtCore.QByteArray) -> bool:
        """
        https://doc.qt.io/qt-6/qaxwidget.html#createHostWindow-1

        **[protected] bool QAxWidget::createHostWindow(bool initialized , const
        QByteArray & data )**

        Creates the client site for the ActiveX control, and returns true if the
        control could be embedded successfully, otherwise returns false. If
        **initialized** is false the control will be initialized using the
        **data**. The control will be initialized through either
        IPersistStreamInit or IPersistStorage interface.

        If the control needs to be initialized using custom data, call this
        function in your reimplementation of **initialize** (). This function is
        not called by the default implementation of **initialize** ().
        """
        ...

    def minimumSizeHint(self) -> QtCore.QSize:
        """
        https://doc.qt.io/qt-6/qaxwidget.html#minimumSizeHint

        **[override virtual] QSize QAxWidget::minimumSizeHint() const**

        Reimplements an access function for property:
        **QWidget::minimumSizeHint** .
        """
        ...

    def sizeHint(self) -> QtCore.QSize:
        """
        https://doc.qt.io/qt-6/qaxwidget.html#sizeHint

        **[override virtual] QSize QAxWidget::sizeHint() const**

        Reimplements an access function for property: **QWidget::sizeHint** .
        """
        ...

    def doVerb(self, a0: str) -> bool:
        """
        https://doc.qt.io/qt-6/qaxwidget.html#doVerb

        **bool QAxWidget::doVerb(const QString & verb )**

        Requests the ActiveX control to perform the action **verb**. The
        possible verbs are returned by **verbs** ().

        The function returns true if the object could perform the action,
        otherwise returns false.
        """
        ...

    def clear(self) -> None:
        """
        https://doc.qt.io/qt-6/qaxwidget.html#clear

        **void QAxWidget::clear()**

        Shuts down the ActiveX control.

        **See also** **resetControl** ().
        """
        ...

    def resetControl(self) -> None:
        """
        https://doc.qt.io/qt-6/qaxwidget.html#resetControl

        **[override virtual] void QAxWidget::resetControl()**

        Reimplements: **QAxObjectInterface::resetControl** ().

        Shuts down the ActiveX control.
        """
        ...

    def setControl(self, c: str) -> bool:
        ...

    def control(self) -> str:
        ...

    def setClassContext(self, classContext: int) -> None:
        ...

    def classContext(self) -> int:
        ...
