"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import enum
import typing
import PyQt6.sip
from PyQt6 import QtCore
from PyQt6.QtBluetooth import *
import enum


class QBluetoothLocalDevice(QtCore.QObject):
    """
    https://doc.qt.io/qt-6/qbluetoothlocaldevice.html

    **Detailed Description**

    QBluetoothLocalDevice provides functions for getting and setting the state
    of local Bluetooth devices.

    On iOS and Windows, this class cannot be used because the platform does not
    expose any data or API which may provide information on the local Bluetooth
    device.
    """

    class Error(enum.Enum):
        NoError: QBluetoothLocalDevice = ...
        PairingError: QBluetoothLocalDevice = ...
        UnknownError: QBluetoothLocalDevice = ...

    class HostMode(enum.Enum):
        HostPoweredOff: QBluetoothLocalDevice = ...
        HostConnectable: QBluetoothLocalDevice = ...
        HostDiscoverable: QBluetoothLocalDevice = ...
        HostDiscoverableLimitedInquiry: QBluetoothLocalDevice = ...

    class Pairing(enum.Enum):
        Unpaired: QBluetoothLocalDevice = ...
        Paired: QBluetoothLocalDevice = ...
        AuthorizedPaired: QBluetoothLocalDevice = ...

    @typing.overload
    def __init__(self, parent: typing.Optional[QtCore.QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-6/qbluetoothlocaldevice.html#QBluetoothLocalDevice

        **QBluetoothLocalDevice::QBluetoothLocalDevice(QObject * parent =
        nullptr)**

        Constructs a QBluetoothLocalDevice with **parent**.
        """
        ...

    @typing.overload
    def __init__(
        self, address: QBluetoothAddress, parent: typing.Optional[QtCore.QObject] = ...
    ) -> None:
        """
        https://doc.qt.io/qt-6/qbluetoothlocaldevice.html#QBluetoothLocalDevice-
        1

        **QBluetoothLocalDevice::QBluetoothLocalDevice(const QBluetoothAddress &
        address , QObject * parent = 0)**

        Construct new QBluetoothLocalDevice for **address**. If **address** is
        default constructed the resulting local device selects the local default
        device.
        """
        ...

    def connectedDevices(self) -> typing.List[QBluetoothAddress]:
        """
        https://doc.qt.io/qt-6/qbluetoothlocaldevice.html#connectedDevices

        **[since 5.3] QList<QBluetoothAddress>
        QBluetoothLocalDevice::connectedDevices() const**

        Returns the list of connected devices. This list is different from the
        list of currently paired devices.

        On Android and macOS, it is not possible to retrieve a list of connected
        devices. It is only possible to listen to (dis)connect changes. For
        convenience, this class monitors all connect and disconnect events since
        its instanciation and returns the current list when calling this
        function. Therefore it is possible that this function returns an empty
        list shortly after creating an instance.

        This function was introduced in Qt 5.3.

        **See also** **deviceConnected** () and **deviceDisconnected** ().
        """
        ...

    @staticmethod
    def allDevices() -> typing.List[QBluetoothHostInfo]:
        """
        https://doc.qt.io/qt-6/qbluetoothlocaldevice.html#allDevices

        **[static] QList<QBluetoothHostInfo>
        QBluetoothLocalDevice::allDevices()**

        Returns a list of all available local Bluetooth devices. On macOS, there
        is only the "default" local device.
        """
        ...

    def address(self) -> QBluetoothAddress:
        """
        https://doc.qt.io/qt-6/qbluetoothlocaldevice.html#address

        **QBluetoothAddress QBluetoothLocalDevice::address() const**

        Returns the MAC address of this Bluetooth device.

        **Note:** On Android, this function always returns the constant value
        `02:00:00:00:00:00` as local address starting with Android 6.0. The
        programmatic access to the device's local MAC address was removed.
        """
        ...

    def name(self) -> str:
        """
        https://doc.qt.io/qt-6/qbluetoothlocaldevice.html#name

        **QString QBluetoothLocalDevice::name() const**

        Returns the name assgined by the user to this Bluetooth device.
        """
        ...

    def powerOn(self) -> None:
        """
        https://doc.qt.io/qt-6/qbluetoothlocaldevice.html#powerOn

        **void QBluetoothLocalDevice::powerOn()**

        Powers on the device after returning it to the **hostMode** () state, if
        it was powered off.

        **Note:** Due to varying security policies on the supported platforms,
        this method may have differing behaviors on the various platforms. For
        example the system may ask the user for confirmation before turning
        Bluetooth on or off. On macOS it is not possible to power on/off
        Bluetooth. Please refer to the platform specific Bluetooth documentation
        for details.
        """
        ...

    def hostMode(self) -> "QBluetoothLocalDevice.HostMode":
        """
        https://doc.qt.io/qt-6/qbluetoothlocaldevice.html#hostMode

        **QBluetoothLocalDevice::HostMode QBluetoothLocalDevice::hostMode()
        const**

        Returns the current host mode of this local Bluetooth device. On macOS,
        it is either **HostPoweredOff**  or **HostConnectable** .

        **See also** **setHostMode** ().
        """
        ...

    def setHostMode(self, mode: "QBluetoothLocalDevice.HostMode") -> None:
        """
        https://doc.qt.io/qt-6/qbluetoothlocaldevice.html#setHostMode

        **void
        QBluetoothLocalDevice::setHostMode(QBluetoothLocalDevice::HostMode mode
        )**

        Sets the host mode of this local Bluetooth device to **mode**.

        Some transitions such as turning the device on or off may take some
        time. Therefore subsequent calls should only be made once the
        **hostModeStateChanged** () signal has concluded the previous request.
        If this is ignored the result of such a series of calls is not well
        defined.

        **Note:** Due to varying security policies on the supported platforms,
        this method may have differing behaviors on the various platforms. For
        example the system may ask the user for confirmation before turning
        Bluetooth on or off and not all host modes may be supported. On macOS,
        it is not possbile to programmatically change the **hostMode** (). A
        user can only switch Bluetooth on/off in the System Preferences. Please
        refer to the platform specific Bluetooth documentation for details.

        **See also** **hostMode** ().
        """
        ...

    def pairingStatus(
        self, address: QBluetoothAddress
    ) -> "QBluetoothLocalDevice.Pairing":
        """
        https://doc.qt.io/qt-6/qbluetoothlocaldevice.html#pairingStatus

        **QBluetoothLocalDevice::Pairing
        QBluetoothLocalDevice::pairingStatus(const QBluetoothAddress & address )
        const**

        Returns the current bluetooth pairing status of **address** , if it's
        unpaired, paired, or paired and authorized.
        """
        ...

    def requestPairing(
        self, address: QBluetoothAddress, pairing: "QBluetoothLocalDevice.Pairing"
    ) -> None:
        """
        https://doc.qt.io/qt-6/qbluetoothlocaldevice.html#requestPairing

        **void QBluetoothLocalDevice::requestPairing(const QBluetoothAddress &
        address , QBluetoothLocalDevice::Pairing pairing )**

        Set the **pairing** status with **address**. The results are returned by
        the signal, **pairingFinished** (). On Android and macOS,
        **AuthorizedPaired**  is not possible and will have the same behavior as
        Paired.

        On macOS, it is not possible to unpair a device. If Unpaired is
        requested, **pairingFinished** () is immediately emitted although the
        device remains paired. It is possible to request the pairing for a
        previously unpaired device. In addition **AuthorizedPaired**  has the
        same behavior as **Paired** .

        Caution: creating a pairing may take minutes, and may require the user
        to acknowledge.
        """
        ...

    def isValid(self) -> bool:
        """
        https://doc.qt.io/qt-6/qbluetoothlocaldevice.html#isValid

        **bool QBluetoothLocalDevice::isValid() const**

        Returns `true` if the **QBluetoothLocalDevice**  represents an available
        local Bluetooth device; otherwise return false.

        If the local Bluetooth adapter represented by an instance of this class
        is removed from the system (e.g. removal of the underlying Bluetooth
        dongle) then this instance will become invalid. An already invalid
        **QBluetoothLocalDevice**  instance remains invalid even if the same
        Bluetooth adapter is returned to the system.

        **See also** **allDevices** ().
        """
        ...

    @property
    def deviceConnected(self) -> PyQt6.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-6/qbluetoothlocaldevice.html#deviceConnected

        **[signal, since 5.3] void QBluetoothLocalDevice::deviceConnected(const
        QBluetoothAddress & address )**

        This signal is emitted when the local device establishes a connection to
        a remote device with **address**.

        This function was introduced in Qt 5.3.

        **See also** **deviceDisconnected** () and **connectedDevices** ().
        """
        ...

    @property
    def deviceDisconnected(self) -> PyQt6.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-6/qbluetoothlocaldevice.html#deviceDisconnected

        **[signal, since 5.3] void
        QBluetoothLocalDevice::deviceDisconnected(const QBluetoothAddress &
        address )**

        This signal is emitted when the local device disconnects from a remote
        Bluetooth device with **address**.

        This function was introduced in Qt 5.3.

        **See also** **deviceConnected** () and **connectedDevices** ().
        """
        ...

    @property
    def errorOccurred(self) -> PyQt6.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-6/qbluetoothlocaldevice.html#errorOccurred

        **[signal, since 6.2] void
        QBluetoothLocalDevice::errorOccurred(QBluetoothLocalDevice::Error error
        )**

        Signal emitted if there's an exceptional **error** while pairing.

        This function was introduced in Qt 6.2.
        """
        ...

    @property
    def hostModeStateChanged(self) -> PyQt6.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-6/qbluetoothlocaldevice.html#hostModeStateChanged

        **[signal] void QBluetoothLocalDevice::hostModeStateChanged(QBluetoothLo
        calDevice::HostMode state )**

        The **state** of the host has transitioned to a different **HostMode** .
        """
        ...

    @property
    def pairingFinished(self) -> PyQt6.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-6/qbluetoothlocaldevice.html#pairingFinished

        **[signal] void QBluetoothLocalDevice::pairingFinished(const
        QBluetoothAddress & address , QBluetoothLocalDevice::Pairing pairing )**

        Pairing or unpairing has completed with **address**. Current pairing
        status is in **pairing**. If the pairing request was not successful,
        this signal will not be emitted. The **errorOccurred** () signal is
        emitted if the pairing request failed. The signal is only ever emitted
        for pairing requests which have previously requested by calling
        **requestPairing** () of the current object instance.
        """
        ...
