"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
import PyQt6.sip
from PyQt6.QtCore import *


class QAbstractEventDispatcher(QObject):
    """
    https://doc.qt.io/qt-6/qabstracteventdispatcher.html

    **Detailed Description**

    An event dispatcher receives events from the window system and other
    sources. It then sends them to the **QCoreApplication**  or **QApplication**
    instance for processing and delivery. QAbstractEventDispatcher provides
    fine-grained control over event delivery.

    For simple control of event processing use
    **QCoreApplication::processEvents** ().

    For finer control of the application's event loop, call **instance** () and
    call functions on the QAbstractEventDispatcher object that is returned. If
    you want to use your own instance of QAbstractEventDispatcher or of a
    QAbstractEventDispatcher subclass, you must install it with
    **QCoreApplication::setEventDispatcher** () or
    **QThread::setEventDispatcher** () **before** a default event dispatcher has
    been installed.

    The main event loop is started by calling **QCoreApplication::exec** (), and
    stopped by calling **QCoreApplication::exit** (). Local event loops can be
    created using **QEventLoop** .

    Programs that perform long operations can call **processEvents** () with a
    bitwise OR combination of various **QEventLoop::ProcessEventsFlag**  values
    to control which events should be delivered.

    QAbstractEventDispatcher also allows the integration of an external event
    loop with the Qt event loop.

    **See also** **QEventLoop** , **QCoreApplication** , and **QThread** .
    """

    class TimerInfo(PyQt6.sip.simplewrapper):
        interval: int = ...
        timerId: int = ...
        timerType: Qt = ...

        @typing.overload
        def __init__(self, id: int, i: int, t: Qt.TimerType) -> None:
            ...

        @typing.overload
        def __init__(self, a0: "QAbstractEventDispatcher.TimerInfo") -> None:
            ...

    def __init__(self, parent: typing.Optional[QObject] = ...) -> None:
        """
        https://doc.qt.io/qt-6/qabstracteventdispatcher.html#QAbstractEventDispa
        tcher

        **QAbstractEventDispatcher::QAbstractEventDispatcher(QObject * parent =
        nullptr)**

        Constructs a new event dispatcher with the given **parent**.
        """
        ...

    def filterNativeEvent(
        self, eventType: "QByteArray", message: PyQt6.sip.voidptr
    ) -> typing.Tuple[bool, PyQt6.sip.voidptr]:
        """
        https://doc.qt.io/qt-6/qabstracteventdispatcher.html#filterNativeEvent

        **[since 5.0] bool QAbstractEventDispatcher::filterNativeEvent(const
        QByteArray & eventType , void * message , qintptr * result )**

        Sends **message** through the event filters that were set by
        **installNativeEventFilter** (). This function returns `true` as soon as
        an event filter returns `true`, and false otherwise to indicate that the
        processing of the event should continue.

        Subclasses of **QAbstractEventDispatcher**  **must** call this function
        for **all** messages received from the system to ensure compatibility
        with any extensions that may be used in the application. The type of
        event **eventType** is specific to the platform plugin chosen at run-
        time, and can be used to cast message to the right type. The **result**
        pointer is only used on Windows, and corresponds to the LRESULT pointer.

        Note that the type of **message** is platform dependent. See
        **QAbstractNativeEventFilter**  for details.

        This function was introduced in Qt 5.0.

        **See also** **installNativeEventFilter** () and
        **QAbstractNativeEventFilter::nativeEventFilter** ().
        """
        ...

    def removeNativeEventFilter(self, filterObj: "QAbstractNativeEventFilter") -> None:
        """
        https://doc.qt.io/qt-6/qabstracteventdispatcher.html#removeNativeEventFi
        lter

        **[since 5.0] void QAbstractEventDispatcher::removeNativeEventFilter(QAb
        stractNativeEventFilter * filter )**

        Removes the event filter **filter** from this object. The request is
        ignored if such an event filter has not been installed.

        All event filters for this object are automatically removed when this
        object is destroyed.

        It is always safe to remove an event filter, even during event filter
        filter activation (that is, even from within the **nativeEventFilter**
        () function).

        This function was introduced in Qt 5.0.

        **See also** **installNativeEventFilter** () and
        **QAbstractNativeEventFilter** .
        """
        ...

    def installNativeEventFilter(self, filterObj: "QAbstractNativeEventFilter") -> None:
        """
        https://doc.qt.io/qt-6/qabstracteventdispatcher.html#installNativeEventF
        ilter

        **[since 5.0] void QAbstractEventDispatcher::installNativeEventFilter(QA
        bstractNativeEventFilter * filterObj )**

        Installs an event filter **filterObj** for all native events received by
        the application.

        The event filter **filterObj** receives events via its
        **nativeEventFilter** () function, which is called for all events
        received by all threads.

        The **nativeEventFilter** () function should return true if the event
        should be filtered, (in this case, stopped). It should return false to
        allow normal Qt processing to continue: the native event can then be
        translated into a **QEvent**  and handled by the standard Qt **event**
        filtering, e.g. **QObject::installEventFilter** ().

        If multiple event filters are installed, the filter that was installed
        last is activated first.

        **Note:** The filter function set here receives native messages, that
        is, MSG or XEvent structs.

        For maximum portability, you should always try to use **QEvent**
        objects and **QObject::installEventFilter** () whenever possible.

        This function was introduced in Qt 5.0.

        **See also** **QObject::installEventFilter** ().
        """
        ...

    def remainingTime(self, timerId: int) -> int:
        """
        https://doc.qt.io/qt-6/qabstracteventdispatcher.html#remainingTime

        **[pure virtual] int QAbstractEventDispatcher::remainingTime(int timerId
        )**

        Returns the remaining time in milliseconds with the given **timerId**.
        If the timer is inactive, the returned value will be -1. If the timer is
        overdue, the returned value will be 0.

        **See also** **Qt::TimerType** .
        """
        ...

    def closingDown(self) -> None:
        ...

    def startingUp(self) -> None:
        ...

    def interrupt(self) -> None:
        """
        https://doc.qt.io/qt-6/qabstracteventdispatcher.html#interrupt

        **[pure virtual] void QAbstractEventDispatcher::interrupt()**

        Interrupts event dispatching. The event dispatcher will return from
        **processEvents** () as soon as possible.
        """
        ...

    def wakeUp(self) -> None:
        """
        https://doc.qt.io/qt-6/qabstracteventdispatcher.html#wakeUp

        **[pure virtual] void QAbstractEventDispatcher::wakeUp()**

        Wakes up the event loop.

        **Note:** This function is **thread-safe** .

        **See also** **awake** ().
        """
        ...

    def registeredTimers(
        self, object: QObject
    ) -> typing.List["QAbstractEventDispatcher.TimerInfo"]:
        """
        https://doc.qt.io/qt-6/qabstracteventdispatcher.html#registeredTimers

        **[pure virtual] QList<QAbstractEventDispatcher::TimerInfo>
        QAbstractEventDispatcher::registeredTimers(QObject * object ) const**

        Returns a list of registered timers for **object**. The **TimerInfo**
        struct has `timerId`, `interval`, and `timerType` members.

        **See also** **Qt::TimerType** .
        """
        ...

    def unregisterTimers(self, object: QObject) -> bool:
        """
        https://doc.qt.io/qt-6/qabstracteventdispatcher.html#unregisterTimers

        **[pure virtual] bool QAbstractEventDispatcher::unregisterTimers(QObject
        * object )**

        Unregisters all the timers associated with the given **object**. Returns
        `true` if all timers were successful removed; otherwise returns `false`.

        **See also** **unregisterTimer** () and **registeredTimers** ().
        """
        ...

    def unregisterTimer(self, timerId: int) -> bool:
        """
        https://doc.qt.io/qt-6/qabstracteventdispatcher.html#unregisterTimer

        **[pure virtual] bool QAbstractEventDispatcher::unregisterTimer(int
        timerId )**

        Unregisters the timer with the given **timerId**. Returns `true` if
        successful; otherwise returns `false`.

        **See also** **registerTimer** () and **unregisterTimers** ().
        """
        ...

    @typing.overload
    def registerTimer(
        self, interval: int, timerType: Qt.TimerType, object: QObject
    ) -> int:
        """
        https://doc.qt.io/qt-6/qabstracteventdispatcher.html#registerTimer

        **int QAbstractEventDispatcher::registerTimer(qint64 interval ,
        Qt::TimerType timerType , QObject * object )**

        Registers a timer with the specified **interval** and **timerType** for
        the given **object** and returns the timer id.
        """
        ...

    @typing.overload
    def registerTimer(
        self, timerId: int, interval: int, timerType: Qt.TimerType, object: QObject
    ) -> None:
        """
        https://doc.qt.io/qt-6/qabstracteventdispatcher.html#registerTimer-1

        **[pure virtual] void QAbstractEventDispatcher::registerTimer(int
        timerId , qint64 interval , Qt::TimerType timerType , QObject * object
        )**

        Register a timer with the specified **timerId** , **interval** , and
        **timerType** for the given **object**.
        """
        ...

    def processEvents(self, flags: "QEventLoop.ProcessEventsFlag") -> bool:
        """
        https://doc.qt.io/qt-6/qabstracteventdispatcher.html#processEvents

        **[pure virtual] bool
        QAbstractEventDispatcher::processEvents(QEventLoop::ProcessEventsFlags
        flags )**

        Processes pending events that match **flags** until there are no more
        events to process. Returns `true` if an event was processed; otherwise
        returns `false`.

        This function is especially useful if you have a long running operation,
        and want to show its progress without allowing user input by using the
        **QEventLoop::ExcludeUserInputEvents**  flag.

        If the **QEventLoop::WaitForMoreEvents**  flag is set in **flags** , the
        behavior of this function is as follows:

        * If events are available, this function returns after processing them.
        * If no events are available, this function will wait until more are
        available and return after processing newly available events.

        If the **QEventLoop::WaitForMoreEvents**  flag is not set in **flags** ,
        and no events are available, this function will return immediately.

        **Note:** This function does not process events continuously; it returns
        after all available events are processed.
        """
        ...

    @staticmethod
    def instance(
        thread: typing.Optional["QThread"] = ...,
    ) -> "QAbstractEventDispatcher":
        """
        https://doc.qt.io/qt-6/qabstracteventdispatcher.html#instance

        **[static] QAbstractEventDispatcher
        *QAbstractEventDispatcher::instance(QThread * thread = nullptr)**

        Returns a pointer to the event dispatcher object for the specified
        **thread**. If **thread** is `nullptr`, the current thread is used. If
        no event dispatcher exists for the specified thread, this function
        returns `nullptr`.

        **Note:** If Qt is built without thread support, the **thread** argument
        is ignored.
        """
        ...

    @property
    def aboutToBlock(self) -> PyQt6.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-6/qabstracteventdispatcher.html#aboutToBlock

        **[signal] void QAbstractEventDispatcher::aboutToBlock()**

        This signal is emitted before the event loop calls a function that could
        block.

        **See also** **awake** ().
        """
        ...

    @property
    def awake(self) -> PyQt6.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-6/qabstracteventdispatcher.html#awake

        **[signal] void QAbstractEventDispatcher::awake()**

        This signal is emitted after the event loop returns from a function that
        could block.

        **See also** **wakeUp** () and **aboutToBlock** ().
        """
        ...
