"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import enum
import typing
import PyQt6.sip
from PyQt6.QtCore import *
import enum


class QCborStreamReader(PyQt6.sip.simplewrapper):
    """
    https://doc.qt.io/qt-6/qcborstreamreader.html

    **Detailed Description**

    This class can be used to decode a stream of CBOR content directly from
    either a **QByteArray**  or a **QIODevice** . CBOR is the Concise Binary
    Object Representation, a very compact form of binary data encoding that is
    compatible with JSON. It was created by the IETF Constrained RESTful
    Environments (CoRE) WG, which has used it in many new RFCs. It is meant to
    be used alongside the **CoAP protocol** .

    QCborStreamReader provides a StAX-like API, similar to that of
    **QXmlStreamReader** . Using it requires a bit of knowledge of CBOR
    encoding. For a simpler API, see **QCborValue**  and especially the decoding
    function **QCborValue::fromCbor** ().

    Typically, one creates a QCborStreamReader by passing the source
    **QByteArray**  or **QIODevice**  as a parameter to the constructor, then
    pop elements off the stream if there were no errors in decoding. There are
    three kinds of CBOR types:

    KindTypesBehavior
    Fixed-widthIntegers, Tags, Simple types, Floating
    pointValue is pre-parsed by QCborStreamReader, so accessor functions are
    `const`. Must call **next** () to advance.
    StringsByte arrays, Text
    stringsLength (if known) is pre-parsed, but the string itself is not. The
    accessor functions are not const and may allocate memory. Once called, the
    accessor functions automatically advance to the next element.
    ContainersArrays, MapsLength (if known) is pre-parsed. To access the
    elements, you must call **enterContainer** (), read all elements, then call
    **leaveContainer** (). That function advances to the next element.

    So a processor function typically looks like this:

    void handleStream(**QCborStreamReader**  &reader)
           {
               switch
    (reader.type())
               case **QCborStreamReader** ::UnsignedInteger:
    case **QCborStreamReader** ::NegativeInteger:
               case
    **QCborStreamReader** ::SimpleType:
               case **QCborStreamReader**
    ::Float16:
               case **QCborStreamReader** ::Float:
               case
    **QCborStreamReader** ::Double:
                   handleFixedWidth(reader);
    reader.next();
                   break;
               case **QCborStreamReader**
    ::ByteArray:
               case **QCborStreamReader** ::String:
    handleString(reader);
                   break;
               case
    **QCborStreamReader** ::Array:
               case **QCborStreamReader** ::Map:
    reader.enterContainer();
                   while (reader.lastError() ==
    **QCborError** ::NoError)
                       handleStream(reader);
    if (reader.lastError() == **QCborError** ::NoError)
    reader.leaveContainer();
               }
           }

    **CBOR support**

    The following table lists the CBOR features that QCborStreamReader supports.

    FeatureSupport
    Unsigned numbersYes (full range)
    Negative numbersYes
    (full range)
    Byte stringsYes
    Text stringsYes
    Chunked stringsYes
    TagsYes (arbitrary)
    BooleansYes
    NullYes
    UndefinedYes
    Arbitrary
    simple valuesYes
    Half-precision float (16-bit)Yes
    Single-precision float
    (32-bit)Yes
    Double-precision float (64-bit)Yes
    Infinities and NaN
    floating pointYes
    Determinate-length arrays and mapsYes
    Indeterminate-
    length arrays and mapsYes
    Map key types other than strings and integersYes
    (arbitrary)

    **Dealing with invalid or incomplete CBOR streams**

    QCborStreamReader is capable of detecting corrupt input on its own. The
    library it uses has been extensively tested against invalid input of any
    kind and is quite able to report errors. If any is detected,
    QCborStreamReader will set **lastError** () to a value besides
    **QCborError::NoError** , indicating which situation was detected.

    Most errors detected by QCborStreamReader during normal item parsing are not
    recoverable. The code using QCborStreamReader may opt to handle the data
    that was properly decoded or it can opt to discard the entire data.

    The only recoverable error is **QCborError::EndOfFile** , which indicates
    that more data is required in order to complete the parsing. This situation
    is useful when data is being read from an asynchronous source, such as a
    pipe (**QProcess** ) or a socket (**QTcpSocket** , **QUdpSocket** ,
    **QNetworkReply** , etc.). When more data arrives, the surrounding code
    needs to call either **addData** (), if parsing from a **QByteArray** , or
    **reparse** (), if it is instead reading directly a the QIDOevice that now
    has more data available (see **setDevice** ()).

    **See also** **QCborStreamWriter** , **QCborValue** , and
    **QXmlStreamReader** .
    """

    class StringResultCode(enum.Enum):
        EndOfString: QCborStreamReader = ...
        Ok: QCborStreamReader = ...
        Error: QCborStreamReader = ...

    class Type(enum.Enum):
        UnsignedInteger: QCborStreamReader = ...
        NegativeInteger: QCborStreamReader = ...
        ByteString: QCborStreamReader = ...
        ByteArray: QCborStreamReader = ...
        TextString: QCborStreamReader = ...
        String: QCborStreamReader = ...
        Array: QCborStreamReader = ...
        Map: QCborStreamReader = ...
        Tag: QCborStreamReader = ...
        SimpleType: QCborStreamReader = ...
        HalfFloat: QCborStreamReader = ...
        Float16: QCborStreamReader = ...
        Float: QCborStreamReader = ...
        Double: QCborStreamReader = ...
        Invalid: QCborStreamReader = ...

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qcborstreamreader.html#QCborStreamReader

        **QCborStreamReader::QCborStreamReader()**

        Creates a QCborStreamReader object with no source data. After
        construction, QCborStreamReader will report an error parsing.

        You can add more data by calling **addData** () or by setting a
        different source device using **setDevice** ().

        **See also** **addData** () and **isValid** ().
        """
        ...

    @typing.overload
    def __init__(self, data: QByteArray) -> None:
        """
        https://doc.qt.io/qt-6/qcborstreamreader.html#QCborStreamReader-1

        **QCborStreamReader::QCborStreamReader(const char * data , qsizetype len
        )**

        This is an overloaded function.

        Creates a QCborStreamReader object with **len** bytes of data starting
        at **data**. The pointer must remain valid until QCborStreamReader is
        destroyed.
        """
        ...

    @typing.overload
    def __init__(self, device: QIODevice) -> None:
        """
        https://doc.qt.io/qt-6/qcborstreamreader.html#QCborStreamReader-2

        **QCborStreamReader::QCborStreamReader(const quint8 * data , qsizetype
        len )**

        This is an overloaded function.

        Creates a QCborStreamReader object with **len** bytes of data starting
        at **data**. The pointer must remain valid until QCborStreamReader is
        destroyed.
        """
        ...

    def toInteger(self) -> int:
        """
        https://doc.qt.io/qt-6/qcborstreamreader.html#toInteger

        **qint64 QCborStreamReader::toInteger() const**

        Returns the integer value of the current element, be it negative,
        positive or zero. If the value is larger than 263 \\- 1 or smaller than
        -263, the returned value will overflow and will have an incorrect sign.
        If handling those values is required, use **toUnsignedInteger** () or
        **toNegativeInteger** () instead.

        This function does not perform any type conversions, including from
        boolean or CBOR tag. Therefore, it may only be called if **isInteger**
        () is true; calling it in any other condition is an error.

        **See also** **isInteger** (), **toUnsignedInteger** (), and
        **toNegativeInteger** ().
        """
        ...

    def toDouble(self) -> float:
        """
        https://doc.qt.io/qt-6/qcborstreamreader.html#toDouble

        **double QCborStreamReader::toDouble() const**

        Returns the 64-bit double-precision floating point value of the current
        element.

        This function does not perform any type conversions, including from
        other floating point types or from integer values. Therefore, it may
        only be called if **isDouble** () is true; calling it in any other
        condition is an error.

        **See also** **isDouble** (), **toFloat16** (), and **toFloat** ().
        """
        ...

    def toSimpleType(self) -> QCborSimpleType:
        """
        https://doc.qt.io/qt-6/qcborstreamreader.html#toSimpleType

        **QCborSimpleType QCborStreamReader::toSimpleType() const**

        Returns value of the current simple type.

        This function does not perform any type conversions, including from
        integer. Therefore, it may only be called if **isSimpleType** () is
        true; calling it in any other condition is an error.

        **See also** **isSimpleType** (), **isTrue** (), **isFalse** (),
        **isBool** (), **isNull** (), and **isUndefined** ().
        """
        ...

    def toUnsignedInteger(self) -> int:
        """
        https://doc.qt.io/qt-6/qcborstreamreader.html#toUnsignedInteger

        **quint64 QCborStreamReader::toUnsignedInteger() const**

        Returns the unsigned integer value of the current element.

        This function does not perform any type conversions, including from
        boolean or CBOR tag. Therefore, it may only be called if
        **isUnsignedInteger** () is true; calling it in any other condition is
        an error.

        This function may be used to obtain numbers beyond the range of the
        return type of **toInteger** ().

        **See also** **type** (), **toInteger** (), **isUnsignedInteger** (),
        and **isNegativeInteger** ().
        """
        ...

    def toBool(self) -> bool:
        """
        https://doc.qt.io/qt-6/qcborstreamreader.html#toBool

        **bool QCborStreamReader::toBool() const**

        Returns the boolean value of the current element.

        This function does not perform any type conversions, including from
        integer. Therefore, it may only be called if **isTrue** (), **isFalse**
        () or **isBool** () returned true; calling it in any other condition is
        an error.

        **See also** **isBool** (), **isTrue** (), **isFalse** (), and
        **toInteger** ().
        """
        ...

    def readByteArray(
        self,
    ) -> typing.Tuple[QByteArray, "QCborStreamReader.StringResultCode"]:
        """
        https://doc.qt.io/qt-6/qcborstreamreader.html#readByteArray

        **StringResult<QByteArray> QCborStreamReader::readByteArray()**

        Decodes one byte array chunk from the CBOR string and returns it. This
        function is used for both regular and chunked contents, so the caller
        must always loop around calling this function, even if **isLengthKnown**
        () has is true. The typical use of this function is as follows:

        QBytearray decodeBytearray(**QCborStreamReader**  &reader)
               {
        QBytearray result;
                   auto r = reader.readBytearray();
        while (r.code == **QCborStreamReader** ::Ok) {
                       result +=
        r.data;
                       r = reader.readByteArray();
                   }
        if (r.code == **QCborStreamReader** ::Error) {
                       // handle
        error condition
                       result.clear();
                   }
        return result;
               }

        This function does not perform any type conversions, including from
        integers or from strings. Therefore, it may only be called if
        **isByteArray** () is true; calling it in any other condition is an
        error.

        **See also** **readString** (), **isByteArray** (), and
        **readStringChunk** ().
        """
        ...

    def readString(self) -> typing.Tuple[str, "QCborStreamReader.StringResultCode"]:
        """
        https://doc.qt.io/qt-6/qcborstreamreader.html#readString

        **StringResult<QString> QCborStreamReader::readString()**

        Decodes one string chunk from the CBOR string and returns it. This
        function is used for both regular and chunked string contents, so the
        caller must always loop around calling this function, even if
        **isLengthKnown** () has is true. The typical use of this function is as
        follows:

        **QString**  decodeString(**QCborStreamReader**  &reader)
               {
        **QString**  result;
                   auto r = reader.readString();
        while (r.code == **QCborStreamReader** ::Ok) {
                       result +=
        r.data;
                       r = reader.readString();
                   }
        if (r.code == **QCborStreamReader** ::Error) {
                       // handle
        error condition
                       result.clear();
                   }
        return result;
               }

        This function does not perform any type conversions, including from
        integers or from byte arrays. Therefore, it may only be called if
        **isString** () returned true; calling it in any other condition is an
        error.

        **See also** **readByteArray** (), **isString** (), and
        **readStringChunk** ().
        """
        ...

    def leaveContainer(self) -> bool:
        """
        https://doc.qt.io/qt-6/qcborstreamreader.html#leaveContainer

        **bool QCborStreamReader::leaveContainer()**

        Leaves the array or map whose items were being processed and positions
        the decoder at the next item after the end of the container. Returns
        true if leaving the container succeeded, false otherwise (usually, a
        parsing error). Each call to **enterContainer** () must be paired with a
        call to leaveContainer().

        This function may only be called if **hasNext** () has returned false
        and **containerDepth** () is not zero. Calling it in any other condition
        is an error.

        **See also** **enterContainer** (), **parentContainerType** (), and
        **containerDepth** ().
        """
        ...

    def enterContainer(self) -> bool:
        """
        https://doc.qt.io/qt-6/qcborstreamreader.html#enterContainer

        **bool QCborStreamReader::enterContainer()**

        Enters the array or map that is the current item and prepares for
        iterating the elements contained in the container. Returns true if
        entering the container succeeded, false otherwise (usually, a parsing
        error). Each call to enterContainer() must be paired with a call to
        **leaveContainer** ().

        This function may only be called if the current item is an array or a
        map (that is, if **isArray** (), **isMap** () or **isContainer** () is
        true). Calling it in any other condition is an error.

        **See also** **leaveContainer** (), **isContainer** (), **isArray** (),
        and **isMap** ().
        """
        ...

    def isContainer(self) -> bool:
        """
        https://doc.qt.io/qt-6/qcborstreamreader.html#isContainer

        **bool QCborStreamReader::isContainer() const**

        Returns true if the current element is a container (that is, an array or
        a map), false if it is anything else. If the current element is a
        container, the **isLengthKnown** () function may be used to find out if
        the container's size is explicit in the stream and, if so, **length** ()
        can be used to get that size.

        More importantly, for a container, the **enterContainer** () function is
        available to begin iterating through the elements contained therein.

        **See also** **type** (), **isArray** (), **isMap** (),
        **isLengthKnown** (), **length** (), **enterContainer** (),
        **leaveContainer** (), and **containerDepth** ().
        """
        ...

    def __len__(self) -> int:
        ...

    def length(self) -> int:
        """
        https://doc.qt.io/qt-6/qcborstreamreader.html#length

        **quint64 QCborStreamReader::length() const**

        Returns the length of the string or byte array, or the number of items
        in an array or the number, of item pairs in a map, if known. This
        function must not be called if the length is unknown (that is, if
        **isLengthKnown** () returned false). It is an error to do that and it
        will cause **QCborStreamReader**  to stop parsing the input stream.

        **See also** **isLengthKnown** (), **QCborStreamWriter::startArray** (),
        and **QCborStreamWriter::startMap** ().
        """
        ...

    def isLengthKnown(self) -> bool:
        """
        https://doc.qt.io/qt-6/qcborstreamreader.html#isLengthKnown

        **bool QCborStreamReader::isLengthKnown() const**

        Returns true if the length of the current array, map, byte array or
        string is known (explicit in the CBOR stream), false otherwise. This
        function should only be called if the element is one of those.

        If the length is known, it may be obtained by calling **length** ().

        If the length of a map or an array is not known, it is implied by the
        number of elements present in the stream. **QCborStreamReader**  has no
        API to calculate the length in that condition.

        Strings and byte arrays may also have indeterminate length (that is,
        they may be transmitted in multiple chunks). Those cannot currently be
        created with **QCborStreamWriter** , but they could be with other
        encoders, so **QCborStreamReader**  supports them.

        **See also** **length** (), **QCborStreamWriter::startArray** (), and
        **QCborStreamWriter::startMap** ().
        """
        ...

    def isUndefined(self) -> bool:
        """
        https://doc.qt.io/qt-6/qcborstreamreader.html#isUndefined

        **bool QCborStreamReader::isUndefined() const**

        Returns true if the current element is the `undefined` value, false if
        it is anything else. Undefined values may be encoded to indicate that
        some conversion failed or was not possible when creating the stream.
        **QCborStreamReader**  never performs any replacement and this function
        will only return true if the stream contains an explicit undefined
        value.

        **See also** **type** (), **isSimpleType** (), and **toSimpleType** ().
        """
        ...

    def isNull(self) -> bool:
        """
        https://doc.qt.io/qt-6/qcborstreamreader.html#isNull

        **bool QCborStreamReader::isNull() const**

        Returns true if the current element is the `null` value, false if it is
        anything else. Null values may be used to indicate the absence of some
        optional data.

        **Note:** This function is not the opposite of **isValid** (). A Null
        value is a valid CBOR value.

        **See also** **type** (), **isSimpleType** (), and **toSimpleType** ().
        """
        ...

    def isBool(self) -> bool:
        """
        https://doc.qt.io/qt-6/qcborstreamreader.html#isBool

        **bool QCborStreamReader::isBool() const**

        Returns true if the current element is a boolean value (`true` or
        `false`), false if it is anything else. If this function returns true,
        you may call **toBool** () to retrieve the value of the boolean. You may
        also call **toSimpleType** () and compare to either
        QCborSimpleValue::True or QCborSimpleValue::False.

        **See also** **type** (), **isFalse** (), **isTrue** (), **toBool** (),
        **isSimpleType** (), and **toSimpleType** ().
        """
        ...

    def isTrue(self) -> bool:
        """
        https://doc.qt.io/qt-6/qcborstreamreader.html#isTrue

        **bool QCborStreamReader::isTrue() const**

        Returns true if the current element is the `true` value, false if it is
        anything else.

        **See also** **type** (), **isFalse** (), **isBool** (), **toBool** (),
        **isSimpleType** (), and **toSimpleType** ().
        """
        ...

    def isFalse(self) -> bool:
        """
        https://doc.qt.io/qt-6/qcborstreamreader.html#isFalse

        **bool QCborStreamReader::isFalse() const**

        Returns true if the current element is the `false` value, false if it is
        anything else.

        **See also** **type** (), **isTrue** (), **isBool** (), **toBool** (),
        **isSimpleType** (), and **toSimpleType** ().
        """
        ...

    def isInvalid(self) -> bool:
        """
        https://doc.qt.io/qt-6/qcborstreamreader.html#isInvalid

        **bool QCborStreamReader::isInvalid() const**

        Returns true if the current element is invalid, false otherwise. The
        current element may be invalid if there was a decoding error or we've
        just parsed the last element in an array or map.

        **Note:** This function is not to be confused with **isNull** (). Null
        is a normal CBOR type that must be handled by the application.

        **See also** **type** () and **isValid** ().
        """
        ...

    def isDouble(self) -> bool:
        """
        https://doc.qt.io/qt-6/qcborstreamreader.html#isDouble

        **bool QCborStreamReader::isDouble() const**

        Returns true if the type of the current element is an IEEE 754 double-
        precision floating point (that is, if **type** () returns
        **QCborStreamReader::Double** ). If this function returns true, you may
        call **toDouble** () to read that data.

        **See also** **type** (), **toDouble** (), **isFloat16** (), and
        **isFloat** ().
        """
        ...

    def isFloat(self) -> bool:
        """
        https://doc.qt.io/qt-6/qcborstreamreader.html#isFloat

        **bool QCborStreamReader::isFloat() const**

        Returns true if the type of the current element is an IEEE 754 single-
        precision floating point (that is, if **type** () returns
        **QCborStreamReader::Float** ). If this function returns true, you may
        call **toFloat** () to read that data.

        **See also** **type** (), **toFloat** (), **isFloat16** (), and
        **isDouble** ().
        """
        ...

    def isFloat16(self) -> bool:
        """
        https://doc.qt.io/qt-6/qcborstreamreader.html#isFloat16

        **bool QCborStreamReader::isFloat16() const**

        Returns true if the type of the current element is an IEEE 754 half-
        precision floating point (that is, if **type** () returns
        **QCborStreamReader::Float16** ). If this function returns true, you may
        call **toFloat16** () to read that data.

        **See also** **type** (), **toFloat16** (), **isFloat** (), and
        **isDouble** ().
        """
        ...

    @typing.overload
    def isSimpleType(self) -> bool:
        """
        https://doc.qt.io/qt-6/qcborstreamreader.html#isSimpleType

        **bool QCborStreamReader::isSimpleType() const**

        Returns true if the type of the current element is any CBOR simple type,
        including a boolean value (true and false) as well as null and
        undefined. To find out which simple type this is, call **toSimpleType**
        (). Alternatively, to test for one specific simple type, call the
        overload that takes a **QCborSimpleType**  parameter.

        CBOR simple types are types that do not carry extra value. There are 255
        possibilities, but there are currently only four values that have
        defined meaning. Code is not expected to cope with unknown simple types
        and may simply discard the stream as invalid if it finds an unknown one.

        **See also** **QCborSimpleType** , **type** (), **isSimpleType**
        (QCborSimpleType), and **toSimpleType** ().
        """
        ...

    @typing.overload
    def isSimpleType(self, st: QCborSimpleType) -> bool:
        """
        https://doc.qt.io/qt-6/qcborstreamreader.html#isSimpleType-1

        **bool QCborStreamReader::isSimpleType(QCborSimpleType st ) const**

        Returns true if the type of the current element is the simple type
        **st** , false otherwise. If this function returns true, then
        **toSimpleType** () will return **st**.

        CBOR simple types are types that do not carry extra value. There are 255
        possibilities, but there are currently only four values that have
        defined meaning. Code is not expected to cope with unknown simple types
        and may simply discard the stream as invalid if it finds an unknown one.

        **See also** **QCborSimpleType** , **type** (), **isSimpleType** (), and
        **toSimpleType** ().
        """
        ...

    def isTag(self) -> bool:
        """
        https://doc.qt.io/qt-6/qcborstreamreader.html#isTag

        **bool QCborStreamReader::isTag() const**

        Returns true if the type of the current element is a CBOR tag (that is,
        if **type** () returns **QCborStreamReader::Tag** ). If this function
        returns true, you may call **toTag** () to read that data.

        **See also** **type** () and **toTag** ().
        """
        ...

    def isMap(self) -> bool:
        """
        https://doc.qt.io/qt-6/qcborstreamreader.html#isMap

        **bool QCborStreamReader::isMap() const**

        Returns true if the type of the current element is a map (that is, if
        **type** () returns **QCborStreamReader::Map** ). If this function
        returns true, you may call **enterContainer** () to begin parsing that
        container.

        When the current element is a map, you may also call **isLengthKnown**
        () to find out if the map's size is explicit in the CBOR stream. If it
        is, that size can be obtained by calling **length** ().

        The following example pre-allocates a QVariantMap given the map's size
        for more efficient decoding:

        QVariantMap populateFromCbor(**QCborStreamReader**  &reader)
               {
        QVariantMap map;
                   if (reader.isLengthKnown())
        map.reserve(reader.length());

                   reader.enterContainer();
        while (reader.lastError() == **QCborError** ::NoError &&
        reader.hasNext()) {
                       **QString**  key =
        readElementAsString(reader);
                       map.insert(key,
        readOneElement(reader));
                   }
                   if (reader.lastError()
        == **QCborError** ::NoError)
                       reader.leaveContainer();
        }

        The example above uses a function called `readElementAsString` to read
        the map's keys and obtain a string. That is because CBOR maps may
        contain any type as keys, not just strings. User code needs to either
        perform this conversion, reject non-string keys, or instead use a
        different container besides **QVariantMap**  and **QVariantHash** . For
        example, if the map is expected to contain integer keys, which is
        recommended as it reduces stream size and parsing, the correct container
        would be `\\l{QMap}<int, QVariant>` or `\\l{QHash}<int, QVariant>`.

        **Note:** The code above does not validate that the length is a sensible
        value. If the input stream reports that the length is 1 billion
        elements, the above function will try to allocate some 24 GB or more of
        RAM, which can lead to a crash.

        **See also** **type** (), **isArray** (), **isLengthKnown** (),
        **length** (), **enterContainer** (), and **leaveContainer** ().
        """
        ...

    def isArray(self) -> bool:
        """
        https://doc.qt.io/qt-6/qcborstreamreader.html#isArray

        **bool QCborStreamReader::isArray() const**

        Returns true if the type of the current element is an array (that is, if
        **type** () returns **QCborStreamReader::Array** ). If this function
        returns true, you may call **enterContainer** () to begin parsing that
        container.

        When the current element is an array, you may also call
        **isLengthKnown** () to find out if the array's size is explicit in the
        CBOR stream. If it is, that size can be obtained by calling **length**
        ().

        The following example pre-allocates a QVariantList given the array's
        size for more efficient decoding:

        QVariantList populateFromCbor(**QCborStreamReader**  &reader)
               {
        QVariantList list;
                   if (reader.isLengthKnown())
        list.reserve(reader.length());

                   reader.enterContainer();
        while (reader.lastError() == **QCborError** ::NoError &&
        reader.hasNext())
                       list.append(readOneElement(reader));
        if (reader.lastError() == **QCborError** ::NoError)
        reader.leaveContainer();
               }

        **Note:** The code above does not validate that the length is a sensible
        value. If the input stream reports that the length is 1 billion
        elements, the above function will try to allocate some 16 GB or more of
        RAM, which can lead to a crash.

        **See also** **type** (), **isMap** (), **isLengthKnown** (), **length**
        (), **enterContainer** (), and **leaveContainer** ().
        """
        ...

    def isString(self) -> bool:
        """
        https://doc.qt.io/qt-6/qcborstreamreader.html#isString

        **bool QCborStreamReader::isString() const**

        Returns true if the type of the current element is a text string (that
        is, if **type** () returns **QCborStreamReader::String** ). If this
        function returns true, you may call **readString** () to read that data.

        **See also** **type** (), **readString** (), and **isByteArray** ().
        """
        ...

    def isByteArray(self) -> bool:
        """
        https://doc.qt.io/qt-6/qcborstreamreader.html#isByteArray

        **bool QCborStreamReader::isByteArray() const**

        Returns true if the type of the current element is a byte array (that
        is, if **type** () returns **QCborStreamReader::ByteArray** ). If this
        function returns true, you may call **readByteArray** () to read that
        data.

        **See also** **type** (), **readByteArray** (), and **isString** ().
        """
        ...

    def isInteger(self) -> bool:
        """
        https://doc.qt.io/qt-6/qcborstreamreader.html#isInteger

        **bool QCborStreamReader::isInteger() const**

        Returns true if the type of the current element is either an unsigned
        integer or a negative one (that is, if **type** () returns
        **QCborStreamReader::UnsignedInteger**  or
        **QCborStreamReader::NegativeInteger** ). If this function returns true,
        you may call **toInteger** () to read that value.

        **See also** **type** (), **toInteger** (), **toUnsignedInteger** (),
        **toNegativeInteger** (), **isUnsignedInteger** (), and
        **isNegativeInteger** ().
        """
        ...

    def isNegativeInteger(self) -> bool:
        """
        https://doc.qt.io/qt-6/qcborstreamreader.html#isNegativeInteger

        **bool QCborStreamReader::isNegativeInteger() const**

        Returns true if the type of the current element is a negative integer
        (that is if **type** () returns **QCborStreamReader::NegativeInteger**
        ). If this function returns true, you may call **toNegativeInteger** ()
        or **toInteger** () to read that value.

        **See also** **type** (), **toNegativeInteger** (), **toInteger** (),
        **isInteger** (), and **isUnsignedInteger** ().
        """
        ...

    def isUnsignedInteger(self) -> bool:
        """
        https://doc.qt.io/qt-6/qcborstreamreader.html#isUnsignedInteger

        **bool QCborStreamReader::isUnsignedInteger() const**

        Returns true if the type of the current element is an unsigned integer
        (that is if **type** () returns **QCborStreamReader::UnsignedInteger**
        ). If this function returns true, you may call **toUnsignedInteger** ()
        or **toInteger** () to read that value.

        **See also** **type** (), **toUnsignedInteger** (), **toInteger** (),
        **isInteger** (), and **isNegativeInteger** ().
        """
        ...

    def type(self) -> "QCborStreamReader.Type":
        """
        https://doc.qt.io/qt-6/qcborstreamreader.html#type

        **QCborStreamReader::Type QCborStreamReader::type() const**

        Returns the type of the current element. It is one of the valid types or
        Invalid.

        **See also** **isValid** (), **isUnsignedInteger** (),
        **isNegativeInteger** (), **isInteger** (), **isByteArray** (),
        **isString** (), **isArray** (), **isMap** (), **isTag** (),
        **isSimpleType** (), **isBool** (), **isFalse** (), **isTrue** (),
        **isNull** (), **isUndefined** (), **isFloat16** (), **isFloat** (), and
        **isDouble** ().
        """
        ...

    def next(self, maxRecursion: int = ...) -> bool:
        """
        https://doc.qt.io/qt-6/qcborstreamreader.html#next

        **bool QCborStreamReader::next(int maxRecursion = 10000)**

        Advance the CBOR stream decoding one element. You should usually call
        this function when parsing fixed-width basic elements (that is,
        integers, simple values, tags and floating point values). But this
        function can be called when the current item is a string, array or map
        too and it will skip over that entire element, including all contained
        elements.

        This function returns true if advancing was successful, false otherwise.
        It may fail if the stream is corrupt, incomplete or if the nesting level
        of arrays and maps exceeds **maxRecursion**. Calling this function when
        **hasNext** () has returned false is also an error. If this function
        returns false, **lastError** () will return the error code detailing
        what the failure was.

        **See also** **lastError** (), **isValid** (), and **hasNext** ().
        """
        ...

    def hasNext(self) -> bool:
        """
        https://doc.qt.io/qt-6/qcborstreamreader.html#hasNext

        **bool QCborStreamReader::hasNext() const**

        Returns true if there are more items to be decoded in the current
        container or false of we've reached its end. If we're parsing the root
        element, hasNext() returning false indicates the parsing is complete;
        otherwise, if the container depth is non-zero, then the outer code needs
        to call **leaveContainer** ().

        **See also** **parentContainerType** (), **containerDepth** (), and
        **leaveContainer** ().
        """
        ...

    def parentContainerType(self) -> "QCborStreamReader.Type":
        """
        https://doc.qt.io/qt-6/qcborstreamreader.html#parentContainerType

        **QCborStreamReader::Type QCborStreamReader::parentContainerType()
        const**

        Returns either **QCborStreamReader::Array**  or
        **QCborStreamReader::Map** , indicating whether the container that
        contains the current item was an array or map, respectively. If we're
        currently parsing the root element, this function returns
        **QCborStreamReader::Invalid** .

        **See also** **containerDepth** () and **enterContainer** ().
        """
        ...

    def containerDepth(self) -> int:
        """
        https://doc.qt.io/qt-6/qcborstreamreader.html#containerDepth

        **int QCborStreamReader::containerDepth() const**

        Returns the number of containers that this stream has entered with
        **enterContainer** () but not yet left.

        **See also** **enterContainer** () and **leaveContainer** ().
        """
        ...

    def isValid(self) -> bool:
        """
        https://doc.qt.io/qt-6/qcborstreamreader.html#isValid

        **bool QCborStreamReader::isValid() const**

        Returns true if the current element is valid, false otherwise. The
        current element may be invalid if there was a decoding error or we've
        just parsed the last element in an array or map.

        **Note:** This function is not the opposite of **isNull** (). Null is a
        normal CBOR type that must be handled by the application.

        **See also** **type** () and **isInvalid** ().
        """
        ...

    def currentOffset(self) -> int:
        """
        https://doc.qt.io/qt-6/qcborstreamreader.html#currentOffset

        **qint64 QCborStreamReader::currentOffset() const**

        Returns the offset in the input stream of the item currently being
        decoded. The current offset is the number of decoded bytes so far only
        if the source data is a **QByteArray**  or it is a **QIODevice**  that
        was positioned at its beginning when decoding started.

        **See also** **reset** (), **clear** (), and **device** ().
        """
        ...

    def lastError(self) -> QCborError:
        """
        https://doc.qt.io/qt-6/qcborstreamreader.html#lastError

        **QCborError QCborStreamReader::lastError()**

        Returns the last error in decoding the stream, if any. If no error was
        encountered, this returns an **QCborError::NoError** .

        **See also** **isValid** ().
        """
        ...

    def reset(self) -> None:
        """
        https://doc.qt.io/qt-6/qcborstreamreader.html#reset

        **void QCborStreamReader::reset()**

        Resets the source back to the beginning and clears the decoder state. If
        the source data was a **QByteArray** , **QCborStreamReader**  will
        restart from the beginning of the array.

        If the source data is a **QIODevice** , this function will call
        **QIODevice::reset** (), which will seek to byte position 0. If the CBOR
        stream is not found at the beginning of the device (e.g., beginning of a
        file), then this function will likely do the wrong thing. Instead,
        position the **QIODevice**  to the right offset and call **setDevice**
        ().

        **See also** **clear** () and **setDevice** ().
        """
        ...

    def clear(self) -> None:
        """
        https://doc.qt.io/qt-6/qcborstreamreader.html#clear

        **void QCborStreamReader::clear()**

        Clears the decoder state and resets the input source data to an empty
        byte array. After this function is called, **QCborStreamReader**  will
        be indicating an error parsing.

        Call **addData** () to add more data to be parsed.

        **See also** **reset** () and **setDevice** ().
        """
        ...

    def reparse(self) -> None:
        """
        https://doc.qt.io/qt-6/qcborstreamreader.html#reparse

        **void QCborStreamReader::reparse()**

        Reparses the current element. This function must be called when more
        data becomes available in the source **QIODevice**  after parsing failed
        due to reaching the end of the input data before the end of the CBOR
        stream.

        When reading from QByteArray(), the **addData** () function
        automatically calls this function. Calling it when the reading had not
        failed is a no-op.
        """
        ...

    def addData(self, data: QByteArray) -> None:
        """
        https://doc.qt.io/qt-6/qcborstreamreader.html#addData

        **void QCborStreamReader::addData(const QByteArray & data )**

        Adds **data** to the CBOR stream and reparses the current element. This
        function is useful if the end of the data was previously reached while
        processing the stream, but now more data is available.
        """
        ...

    def device(self) -> QIODevice:
        """
        https://doc.qt.io/qt-6/qcborstreamreader.html#device

        **QIODevice *QCborStreamReader::device() const**

        Returns the **QIODevice**  that was set with either **setDevice** () or
        the **QCborStreamReader**  constructor. If this object was reading from
        a **QByteArray** , this function returns nullptr instead.

        **See also** **setDevice** ().
        """
        ...

    def setDevice(self, device: QIODevice) -> None:
        """
        https://doc.qt.io/qt-6/qcborstreamreader.html#setDevice

        **void QCborStreamReader::setDevice(QIODevice * device )**

        Sets the source of data to **device** , resetting the decoder to its
        initial state.

        **See also** **device** ().
        """
        ...
