"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
import PyQt6.sip
from PyQt6.QtCore import *


class QCollator(PyQt6.sip.simplewrapper):
    """
    https://doc.qt.io/qt-6/qcollator.html

    **Detailed Description**

    QCollator is initialized with a **QLocale** . It can then be used to compare
    and sort strings in using the ordering appropriate to the locale.

    A QCollator object can be used together with template-based sorting
    algorithms, such as std::sort(), to sort a list with **QString**  entries.

    **QStringList**  sortedStrings(**QStringList**  seq)
        {
    **QCollator**  order;
            std::sort(seq.begin(), seq.end(), order);
    return seq;
        }

    In addition to the locale, several optional flags can be set that influence
    the result of the collation.

    **Note:** On Linux, Qt is normally compiled to use ICU. When it isn't, all
    options are ignored and the only supported locales are the system default
    (that `setlocale(LC_COLLATE, nullptr)` would report) and the "C" locale.
    """

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qcollator.html#QCollator

        **[since 5.13] QCollator::QCollator()**

        Constructs a QCollator using the default locale's collation locale.

        The system locale, when used as default locale, may have a collation
        locale other than itself (e.g. on Unix, if LC_COLLATE is set differently
        to LANG in the environment). All other locales are their own collation
        locales.

        This function was introduced in Qt 5.13.

        **See also** **setLocale** (), **QLocale::collation** (), and
        **QLocale::setDefault** ().
        """
        ...

    @typing.overload
    def __init__(self, locale: "QLocale") -> None:
        """
        https://doc.qt.io/qt-6/qcollator.html#QCollator-1

        **QCollator::QCollator(const QLocale & locale )**

        Constructs a QCollator using the given **locale**.

        **See also** **setLocale** ().
        """
        ...

    @typing.overload
    def __init__(self, a0: "QCollator") -> None:
        """
        https://doc.qt.io/qt-6/qcollator.html#QCollator-2

        **QCollator::QCollator(const QCollator & other )**

        Creates a copy of **other**.
        """
        ...

    def sortKey(self, string: str) -> QCollatorSortKey:
        """
        https://doc.qt.io/qt-6/qcollator.html#sortKey

        **QCollatorSortKey QCollator::sortKey(const QString & string ) const**

        Returns a sortKey for **string**.

        Creating the sort key is usually somewhat slower, than using the
        **compare** () methods directly. But if the string is compared
        repeatedly (e.g. when sorting a whole list of strings), it's usually
        faster to create the sort keys for each string and then sort using the
        keys.

        **Note:** Not supported with the C (a.k.a. POSIX) locale on Darwin.
        """
        ...

    def compare(self, s1: str, s2: str) -> int:
        """
        https://doc.qt.io/qt-6/qcollator.html#compare

        **[since 5.13] int QCollator::compare(QStringView s1 , QStringView s2 )
        const**

        Compares **s1** with **s2**.

        Returns an integer less than, equal to, or greater than zero depending
        on whether **s1** sorts before, with or after **s2**.

        This function was introduced in Qt 5.13.
        """
        ...

    def ignorePunctuation(self) -> bool:
        """
        https://doc.qt.io/qt-6/qcollator.html#ignorePunctuation

        **bool QCollator::ignorePunctuation() const**

        Returns whether punctuation and symbols are ignored when collating.

        When `true`, strings are compared as if all punctuation and symbols were
        removed from each string.

        **See also** **setIgnorePunctuation** ().
        """
        ...

    def setIgnorePunctuation(self, on: bool) -> None:
        """
        https://doc.qt.io/qt-6/qcollator.html#setIgnorePunctuation

        **void QCollator::setIgnorePunctuation(bool on )**

        Ignores punctuation and symbols if **on** is `true`, attends to them if
        `false`.

        **See also** **ignorePunctuation** ().
        """
        ...

    def numericMode(self) -> bool:
        """
        https://doc.qt.io/qt-6/qcollator.html#numericMode

        **bool QCollator::numericMode() const**

        Returns `true` if numeric sorting is enabled, `false` otherwise.

        When `true`, numerals are recognized as numbers and sorted in arithmetic
        order; for example, 100 sortes after 99. When `false`, numbers are
        sorted in lexical order, so that 100 sorts before 99 (because 1 is
        before 9). By default, this option is disabled.

        **See also** **setNumericMode** ().
        """
        ...

    def setNumericMode(self, on: bool) -> None:
        """
        https://doc.qt.io/qt-6/qcollator.html#setNumericMode

        **void QCollator::setNumericMode(bool on )**

        Enables numeric sorting mode when **on** is `true`.

        **See also** **numericMode** ().
        """
        ...

    def setCaseSensitivity(self, cs: Qt.CaseSensitivity) -> None:
        """
        https://doc.qt.io/qt-6/qcollator.html#setCaseSensitivity

        **void QCollator::setCaseSensitivity(Qt::CaseSensitivity cs )**

        Sets the case-sensitivity of the collator to **cs**.

        **See also** **caseSensitivity** ().
        """
        ...

    def caseSensitivity(self) -> Qt.CaseSensitivity:
        """
        https://doc.qt.io/qt-6/qcollator.html#caseSensitivity

        **Qt::CaseSensitivity QCollator::caseSensitivity() const**

        Returns case sensitivity of the collator.

        This defaults to case-sensitive until set.

        **Note:** In the C locale, when case-sensitive, all lower-case letters
        sort after all upper-case letters, where most locales sort each lower-
        case letter either immediately before or immediately after its upper-
        case partner. Thus "Zap" sorts before "ape" in the C locale but after in
        most others.

        **See also** **setCaseSensitivity** ().
        """
        ...

    def locale(self) -> "QLocale":
        """
        https://doc.qt.io/qt-6/qcollator.html#locale

        **QLocale QCollator::locale() const**

        Returns the locale of the collator.

        Unless supplied to the constructor or by calling **setLocale** (), the
        system's default collation locale is used.

        **See also** **setLocale** () and **QLocale::collation** ().
        """
        ...

    def setLocale(self, locale: "QLocale") -> None:
        """
        https://doc.qt.io/qt-6/qcollator.html#setLocale

        **void QCollator::setLocale(const QLocale & locale )**

        Sets the locale of the collator to **locale**.

        **See also** **locale** ().
        """
        ...

    def swap(self, other: "QCollator") -> None:
        """
        https://doc.qt.io/qt-6/qcollator.html#swap

        **void QCollator::swap(QCollator & other )**

        Swaps this collator with **other**. This function is very fast and never
        fails.
        """
        ...
