"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import enum
import typing
import PyQt6.sip
from PyQt6.QtCore import *
import enum


class QEasingCurve(PyQt6.sip.simplewrapper):
    """
    https://doc.qt.io/qt-6/qeasingcurve.html

    **Detailed Description**

    Easing curves describe a function that controls how the speed of the
    interpolation between 0 and 1 should be. Easing curves allow transitions
    from one value to another to appear more natural than a simple constant
    speed would allow. The QEasingCurve class is usually used in conjunction
    with the **QVariantAnimation**  and **QPropertyAnimation**  classes but can
    be used on its own. It is usually used to accelerate the interpolation from
    zero velocity (ease in) or decelerate to zero velocity (ease out). Ease in
    and ease out can also be combined in the same easing curve.

    To calculate the speed of the interpolation, the easing curve provides the
    function **valueForProgress** (), where the **progress** argument specifies
    the progress of the interpolation: 0 is the start value of the
    interpolation, 1 is the end value of the interpolation. The returned value
    is the effective progress of the interpolation. If the returned value is the
    same as the input value for all input values the easing curve is a linear
    curve. This is the default behaviour.

    For example,

    **QEasingCurve**  easing(**QEasingCurve** ::InOutQuad);

            for
    (**qreal**  t = 0.0; t < 1.0; t += 0.1)
                **qWarning** () <<
    "Effective progress" << t << "is"
                           <<
    easing.valueForProgress(t);

    will print the effective progress of the interpolation between 0 and 1.

    When using a **QPropertyAnimation** , the associated easing curve will be
    used to control the progress of the interpolation between startValue and
    endValue:

    **QPropertyAnimation**  animation;
            animation.setStartValue(0);
    animation.setEndValue(1000);
            animation.setDuration(1000);
    animation.setEasingCurve(**QEasingCurve** ::InOutQuad);

    The ability to set an amplitude, overshoot, or period depends on the
    QEasingCurve type. Amplitude access is available to curves that behave as
    springs such as elastic and bounce curves. Changing the amplitude changes
    the height of the curve. Period access is only available to elastic curves
    and setting a higher period slows the rate of bounce. Only curves that have
    "boomerang" behaviors such as the **InBack** , **OutBack** , **InOutBack** ,
    and **OutInBack**  have overshoot settings. These curves will interpolate
    beyond the end points and return to the end point, acting similar to a
    boomerang.

    The **Easing Curves Example**  contains samples of QEasingCurve types and
    lets you change the curve settings.
    """

    class Type(enum.Enum):
        Linear: QEasingCurve = ...
        InQuad: QEasingCurve = ...
        OutQuad: QEasingCurve = ...
        InOutQuad: QEasingCurve = ...
        OutInQuad: QEasingCurve = ...
        InCubic: QEasingCurve = ...
        OutCubic: QEasingCurve = ...
        InOutCubic: QEasingCurve = ...
        OutInCubic: QEasingCurve = ...
        InQuart: QEasingCurve = ...
        OutQuart: QEasingCurve = ...
        InOutQuart: QEasingCurve = ...
        OutInQuart: QEasingCurve = ...
        InQuint: QEasingCurve = ...
        OutQuint: QEasingCurve = ...
        InOutQuint: QEasingCurve = ...
        OutInQuint: QEasingCurve = ...
        InSine: QEasingCurve = ...
        OutSine: QEasingCurve = ...
        InOutSine: QEasingCurve = ...
        OutInSine: QEasingCurve = ...
        InExpo: QEasingCurve = ...
        OutExpo: QEasingCurve = ...
        InOutExpo: QEasingCurve = ...
        OutInExpo: QEasingCurve = ...
        InCirc: QEasingCurve = ...
        OutCirc: QEasingCurve = ...
        InOutCirc: QEasingCurve = ...
        OutInCirc: QEasingCurve = ...
        InElastic: QEasingCurve = ...
        OutElastic: QEasingCurve = ...
        InOutElastic: QEasingCurve = ...
        OutInElastic: QEasingCurve = ...
        InBack: QEasingCurve = ...
        OutBack: QEasingCurve = ...
        InOutBack: QEasingCurve = ...
        OutInBack: QEasingCurve = ...
        InBounce: QEasingCurve = ...
        OutBounce: QEasingCurve = ...
        InOutBounce: QEasingCurve = ...
        OutInBounce: QEasingCurve = ...
        InCurve: QEasingCurve = ...
        OutCurve: QEasingCurve = ...
        SineCurve: QEasingCurve = ...
        CosineCurve: QEasingCurve = ...
        BezierSpline: QEasingCurve = ...
        TCBSpline: QEasingCurve = ...
        Custom: QEasingCurve = ...

    @typing.overload
    def __init__(self, type: "QEasingCurve.Type" = ...) -> None:
        """
        https://doc.qt.io/qt-6/qeasingcurve.html#QEasingCurve

        **QEasingCurve::QEasingCurve(QEasingCurve::Type type = Linear)**

        Constructs an easing curve of the given **type**.
        """
        ...

    @typing.overload
    def __init__(
        self, other: typing.Union["QEasingCurve", "QEasingCurve.Type"]
    ) -> None:
        """
        https://doc.qt.io/qt-6/qeasingcurve.html#QEasingCurve-1

        **QEasingCurve::QEasingCurve(const QEasingCurve & other )**

        Construct a copy of **other**.
        """
        ...

    def toCubicSpline(self) -> typing.List["QPointF"]:
        """
        https://doc.qt.io/qt-6/qeasingcurve.html#toCubicSpline

        **[since 5.0] QList<QPointF> QEasingCurve::toCubicSpline() const**

        Returns the cubicBezierSpline that defines a custom easing curve. If the
        easing curve does not have a custom bezier easing curve the list is
        empty.

        This function was introduced in Qt 5.0.
        """
        ...

    def addTCBSegment(self, nextPoint: "QPointF", t: float, c: float, b: float) -> None:
        """
        https://doc.qt.io/qt-6/qeasingcurve.html#addTCBSegment

        **void QEasingCurve::addTCBSegment(const QPointF & nextPoint , qreal t ,
        qreal c , qreal b )**

        Adds a segment of a TCB bezier spline to define a custom easing curve.
        It is only applicable if **type** () is **QEasingCurve::TCBSpline** .
        The spline has to start explicitly at (0.0, 0.0) and has to end at (1.0,
        1.0) to be a valid easing curve. The tension **t** changes the length of
        the tangent vector. The continuity **c** changes the sharpness in change
        between the tangents. The bias **b** changes the direction of the
        tangent vector. **nextPoint** is the sample position. All three
        parameters are valid between -1 and 1 and define the tangent of the
        control point. If all three parameters are 0 the resulting spline is a
        Catmull-Rom spline. The begin and endpoint always have a bias of -1 and
        1, since the outer tangent is not defined.
        """
        ...

    def addCubicBezierSegment(
        self, c1: "QPointF", c2: "QPointF", endPoint: "QPointF"
    ) -> None:
        """
        https://doc.qt.io/qt-6/qeasingcurve.html#addCubicBezierSegment

        **void QEasingCurve::addCubicBezierSegment(const QPointF & c1 , const
        QPointF & c2 , const QPointF & endPoint )**

        Adds a segment of a cubic bezier spline to define a custom easing curve.
        It is only applicable if **type** () is **QEasingCurve::BezierSpline** .
        Note that the spline implicitly starts at (0.0, 0.0) and has to end at
        (1.0, 1.0) to be a valid easing curve. **c1** and **c2** are the control
        points used for drawing the curve. **endPoint** is the endpoint of the
        curve.
        """
        ...

    def swap(self, other: "QEasingCurve") -> None:
        """
        https://doc.qt.io/qt-6/qeasingcurve.html#swap

        **[since 5.0] void QEasingCurve::swap(QEasingCurve & other )**

        Swaps curve **other** with this curve. This operation is very fast and
        never fails.

        This function was introduced in Qt 5.0.
        """
        ...

    def valueForProgress(self, progress: float) -> float:
        """
        https://doc.qt.io/qt-6/qeasingcurve.html#valueForProgress

        **qreal QEasingCurve::valueForProgress(qreal progress ) const**

        Return the effective progress for the easing curve at **progress**.
        Whereas **progress** must be between 0 and 1, the returned effective
        progress can be outside those bounds. For example,
        **QEasingCurve::InBack**  will return negative values in the beginning
        of the function.
        """
        ...

    def customType(self) -> typing.Callable[[float], float]:
        """
        https://doc.qt.io/qt-6/qeasingcurve.html#customType

        **QEasingCurve::EasingFunction QEasingCurve::customType() const**

        Returns the function pointer to the custom easing curve. If **type** ()
        does not return **QEasingCurve::Custom** , this function will return 0.

        **See also** **setCustomType** ().
        """
        ...

    def setCustomType(self, func: typing.Callable[[float], float]) -> None:
        """
        https://doc.qt.io/qt-6/qeasingcurve.html#setCustomType

        **void QEasingCurve::setCustomType(QEasingCurve::EasingFunction func )**

        Sets a custom easing curve that is defined by the user in the function
        **func**. The signature of the function is qreal myEasingFunction(qreal
        progress), where **progress** and the return value are considered to be
        normalized between 0 and 1. (In some cases the return value can be
        outside that range) After calling this function **type** () will return
        **QEasingCurve::Custom** . **func** cannot be zero.

        **See also** **customType** () and **valueForProgress** ().
        """
        ...

    def setType(self, type: "QEasingCurve.Type") -> None:
        """
        https://doc.qt.io/qt-6/qeasingcurve.html#setType

        **void QEasingCurve::setType(QEasingCurve::Type type )**

        Sets the type of the easing curve to **type**.

        **See also** **type** ().
        """
        ...

    def type(self) -> "QEasingCurve.Type":
        """
        https://doc.qt.io/qt-6/qeasingcurve.html#type

        **QEasingCurve::Type QEasingCurve::type() const**

        Returns the type of the easing curve.

        **See also** **setType** ().
        """
        ...

    def setOvershoot(self, overshoot: float) -> None:
        """
        https://doc.qt.io/qt-6/qeasingcurve.html#setOvershoot

        **void QEasingCurve::setOvershoot(qreal overshoot )**

        Sets the overshoot to **overshoot**.

        0 produces no overshoot, and the default value of 1.70158 produces an
        overshoot of 10 percent.

        **See also** **overshoot** ().
        """
        ...

    def overshoot(self) -> float:
        """
        https://doc.qt.io/qt-6/qeasingcurve.html#overshoot

        **qreal QEasingCurve::overshoot() const**

        Returns the overshoot. This is not applicable for all curve types. It is
        only applicable if **type** () is **QEasingCurve::InBack** ,
        **QEasingCurve::OutBack** , **QEasingCurve::InOutBack**  or
        **QEasingCurve::OutInBack** .

        **See also** **setOvershoot** ().
        """
        ...

    def setPeriod(self, period: float) -> None:
        """
        https://doc.qt.io/qt-6/qeasingcurve.html#setPeriod

        **void QEasingCurve::setPeriod(qreal period )**

        Sets the period to **period**. Setting a small period value will give a
        high frequency of the curve. A large period will give it a small
        frequency.

        **See also** **period** ().
        """
        ...

    def period(self) -> float:
        """
        https://doc.qt.io/qt-6/qeasingcurve.html#period

        **qreal QEasingCurve::period() const**

        Returns the period. This is not applicable for all curve types. It is
        only applicable if **type** () is **QEasingCurve::InElastic** ,
        **QEasingCurve::OutElastic** , **QEasingCurve::InOutElastic**  or
        **QEasingCurve::OutInElastic** .

        **See also** **setPeriod** ().
        """
        ...

    def setAmplitude(self, amplitude: float) -> None:
        """
        https://doc.qt.io/qt-6/qeasingcurve.html#setAmplitude

        **void QEasingCurve::setAmplitude(qreal amplitude )**

        Sets the amplitude to **amplitude**.

        This will set the amplitude of the bounce or the amplitude of the
        elastic "spring" effect. The higher the number, the higher the
        amplitude.

        **See also** **amplitude** ().
        """
        ...

    def amplitude(self) -> float:
        """
        https://doc.qt.io/qt-6/qeasingcurve.html#amplitude

        **qreal QEasingCurve::amplitude() const**

        Returns the amplitude. This is not applicable for all curve types. It is
        only applicable for bounce and elastic curves (curves of **type** ()
        **QEasingCurve::InBounce** , **QEasingCurve::OutBounce** ,
        **QEasingCurve::InOutBounce** , **QEasingCurve::OutInBounce** ,
        **QEasingCurve::InElastic** , **QEasingCurve::OutElastic** ,
        **QEasingCurve::InOutElastic**  or **QEasingCurve::OutInElastic** ).

        **See also** **setAmplitude** ().
        """
        ...
