"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import enum
import typing
import PyQt6.sip
from PyQt6.QtCore import *
import enum


class QEvent(PyQt6.sip.wrapper):
    """
    https://doc.qt.io/qt-6/qevent.html

    **Detailed Description**

    Qt's main event loop (**QCoreApplication::exec** ()) fetches native window
    system events from the event queue, translates them into QEvents, and sends
    the translated events to **QObject** s.

    In general, events come from the underlying window system (**spontaneous**
    () returns `true`), but it is also possible to manually send events using
    **QCoreApplication::sendEvent** () and **QCoreApplication::postEvent** ()
    (**spontaneous** () returns `false`).

    **QObjects**  receive events by having their **QObject::event** () function
    called. The function can be reimplemented in subclasses to customize event
    handling and add additional event types; **QWidget::event** () is a notable
    example. By default, events are dispatched to event handlers like
    **QObject::timerEvent** () and **QWidget::mouseMoveEvent** ().
    **QObject::installEventFilter** () allows an object to intercept events
    destined for another object.

    The basic QEvent contains only an event type parameter and an "accept" flag.
    The accept flag set with **accept** (), and cleared with **ignore** (). It
    is set by default, but don't rely on this as subclasses may choose to clear
    it in their constructor.

    Subclasses of QEvent contain additional parameters that describe the
    particular event.

    **See also** **QObject::event** (), **QObject::installEventFilter** (),
    **QCoreApplication::sendEvent** (), **QCoreApplication::postEvent** (), and
    **QCoreApplication::processEvents** ().
    """

    class Type(enum.IntEnum):
        None_: QEvent = ...
        Timer: QEvent = ...
        MouseButtonPress: QEvent = ...
        MouseButtonRelease: QEvent = ...
        MouseButtonDblClick: QEvent = ...
        MouseMove: QEvent = ...
        KeyPress: QEvent = ...
        KeyRelease: QEvent = ...
        FocusIn: QEvent = ...
        FocusOut: QEvent = ...
        Enter: QEvent = ...
        Leave: QEvent = ...
        Paint: QEvent = ...
        Move: QEvent = ...
        Resize: QEvent = ...
        Show: QEvent = ...
        Hide: QEvent = ...
        Close: QEvent = ...
        ParentChange: QEvent = ...
        ParentAboutToChange: QEvent = ...
        ThreadChange: QEvent = ...
        WindowActivate: QEvent = ...
        WindowDeactivate: QEvent = ...
        ShowToParent: QEvent = ...
        HideToParent: QEvent = ...
        Wheel: QEvent = ...
        WindowTitleChange: QEvent = ...
        WindowIconChange: QEvent = ...
        ApplicationWindowIconChange: QEvent = ...
        ApplicationFontChange: QEvent = ...
        ApplicationLayoutDirectionChange: QEvent = ...
        ApplicationPaletteChange: QEvent = ...
        PaletteChange: QEvent = ...
        Clipboard: QEvent = ...
        MetaCall: QEvent = ...
        SockAct: QEvent = ...
        WinEventAct: QEvent = ...
        DeferredDelete: QEvent = ...
        DragEnter: QEvent = ...
        DragMove: QEvent = ...
        DragLeave: QEvent = ...
        Drop: QEvent = ...
        ChildAdded: QEvent = ...
        ChildPolished: QEvent = ...
        ChildRemoved: QEvent = ...
        PolishRequest: QEvent = ...
        Polish: QEvent = ...
        LayoutRequest: QEvent = ...
        UpdateRequest: QEvent = ...
        UpdateLater: QEvent = ...
        ContextMenu: QEvent = ...
        InputMethod: QEvent = ...
        TabletMove: QEvent = ...
        LocaleChange: QEvent = ...
        LanguageChange: QEvent = ...
        LayoutDirectionChange: QEvent = ...
        TabletPress: QEvent = ...
        TabletRelease: QEvent = ...
        OkRequest: QEvent = ...
        IconDrag: QEvent = ...
        FontChange: QEvent = ...
        EnabledChange: QEvent = ...
        ActivationChange: QEvent = ...
        StyleChange: QEvent = ...
        IconTextChange: QEvent = ...
        ModifiedChange: QEvent = ...
        MouseTrackingChange: QEvent = ...
        WindowBlocked: QEvent = ...
        WindowUnblocked: QEvent = ...
        WindowStateChange: QEvent = ...
        ToolTip: QEvent = ...
        WhatsThis: QEvent = ...
        StatusTip: QEvent = ...
        ActionChanged: QEvent = ...
        ActionAdded: QEvent = ...
        ActionRemoved: QEvent = ...
        FileOpen: QEvent = ...
        Shortcut: QEvent = ...
        ShortcutOverride: QEvent = ...
        WhatsThisClicked: QEvent = ...
        ToolBarChange: QEvent = ...
        ApplicationActivate: QEvent = ...
        ApplicationActivated: QEvent = ...
        ApplicationDeactivate: QEvent = ...
        ApplicationDeactivated: QEvent = ...
        QueryWhatsThis: QEvent = ...
        EnterWhatsThisMode: QEvent = ...
        LeaveWhatsThisMode: QEvent = ...
        ZOrderChange: QEvent = ...
        HoverEnter: QEvent = ...
        HoverLeave: QEvent = ...
        HoverMove: QEvent = ...
        GraphicsSceneMouseMove: QEvent = ...
        GraphicsSceneMousePress: QEvent = ...
        GraphicsSceneMouseRelease: QEvent = ...
        GraphicsSceneMouseDoubleClick: QEvent = ...
        GraphicsSceneContextMenu: QEvent = ...
        GraphicsSceneHoverEnter: QEvent = ...
        GraphicsSceneHoverMove: QEvent = ...
        GraphicsSceneHoverLeave: QEvent = ...
        GraphicsSceneHelp: QEvent = ...
        GraphicsSceneDragEnter: QEvent = ...
        GraphicsSceneDragMove: QEvent = ...
        GraphicsSceneDragLeave: QEvent = ...
        GraphicsSceneDrop: QEvent = ...
        GraphicsSceneWheel: QEvent = ...
        GraphicsSceneResize: QEvent = ...
        GraphicsSceneMove: QEvent = ...
        KeyboardLayoutChange: QEvent = ...
        DynamicPropertyChange: QEvent = ...
        TabletEnterProximity: QEvent = ...
        TabletLeaveProximity: QEvent = ...
        NonClientAreaMouseMove: QEvent = ...
        NonClientAreaMouseButtonPress: QEvent = ...
        NonClientAreaMouseButtonRelease: QEvent = ...
        NonClientAreaMouseButtonDblClick: QEvent = ...
        MacSizeChange: QEvent = ...
        ContentsRectChange: QEvent = ...
        CursorChange: QEvent = ...
        ToolTipChange: QEvent = ...
        GrabMouse: QEvent = ...
        UngrabMouse: QEvent = ...
        GrabKeyboard: QEvent = ...
        UngrabKeyboard: QEvent = ...
        StateMachineSignal: QEvent = ...
        StateMachineWrapped: QEvent = ...
        TouchBegin: QEvent = ...
        TouchUpdate: QEvent = ...
        TouchEnd: QEvent = ...
        RequestSoftwareInputPanel: QEvent = ...
        CloseSoftwareInputPanel: QEvent = ...
        WinIdChange: QEvent = ...
        Gesture: QEvent = ...
        GestureOverride: QEvent = ...
        FocusAboutToChange: QEvent = ...
        ScrollPrepare: QEvent = ...
        Scroll: QEvent = ...
        Expose: QEvent = ...
        InputMethodQuery: QEvent = ...
        OrientationChange: QEvent = ...
        TouchCancel: QEvent = ...
        PlatformPanel: QEvent = ...
        ApplicationStateChange: QEvent = ...
        ReadOnlyChange: QEvent = ...
        PlatformSurface: QEvent = ...
        TabletTrackingChange: QEvent = ...
        GraphicsSceneLeave: QEvent = ...
        User: QEvent = ...
        MaxUser: QEvent = ...

    @typing.overload
    def __init__(self, type: "QEvent.Type") -> None:
        """
        https://doc.qt.io/qt-6/qevent.html#QEvent-2

        **QEvent::QEvent(QEvent::Type type )**

        Constructs an event object of type **type**.
        """
        ...

    @typing.overload
    def __init__(self, type: int) -> None:
        """
        https://doc.qt.io/qt-6/qevent.html#QEvent-2

        **QEvent::QEvent(QEvent::Type type )**

        Constructs an event object of type **type**.
        """
        ...

    def clone(self) -> "QEvent":
        """
        https://doc.qt.io/qt-6/qevent.html#clone

        **[virtual, since 6.0] QEvent *QEvent::clone() const**

        Creates and returns an identical copy of this event.

        This function was introduced in Qt 6.0.
        """
        ...

    def isSinglePointEvent(self) -> bool:
        """
        https://doc.qt.io/qt-6/qevent.html#isSinglePointEvent

        **[since 6.0] bool QEvent::isSinglePointEvent() const**

        Returns `true` if the event object is a subclass of
        **QSinglePointEvent** .

        This function was introduced in Qt 6.0.
        """
        ...

    def isPointerEvent(self) -> bool:
        """
        https://doc.qt.io/qt-6/qevent.html#isPointerEvent

        **[since 6.0] bool QEvent::isPointerEvent() const**

        Returns `true` if the event object is a **QPointerEvent**  or one of its
        subclasses.

        This function was introduced in Qt 6.0.
        """
        ...

    def isInputEvent(self) -> bool:
        """
        https://doc.qt.io/qt-6/qevent.html#isInputEvent

        **[since 6.0] bool QEvent::isInputEvent() const**

        Returns `true` if the event object is a **QInputEvent**  or one of its
        subclasses.

        This function was introduced in Qt 6.0.
        """
        ...

    @staticmethod
    def registerEventType(hint: int = ...) -> int:
        """
        https://doc.qt.io/qt-6/qevent.html#registerEventType

        **[static] int QEvent::registerEventType(int hint = -1)**

        Registers and returns a custom event type. The **hint** provided will be
        used if it is available, otherwise it will return a value between
        **QEvent::User**  and **QEvent::MaxUser**  that has not yet been
        registered. The **hint** is ignored if its value is not between
        **QEvent::User**  and **QEvent::MaxUser** .

        Returns -1 if all available values are already taken or the program is
        shutting down.

        **Note:** This function is **thread-safe** .
        """
        ...

    def ignore(self) -> None:
        """
        https://doc.qt.io/qt-6/qevent.html#ignore

        **void QEvent::ignore()**

        Clears the accept flag parameter of the event object, the equivalent of
        calling **setAccepted** (false).

        Clearing the accept parameter indicates that the event receiver does not
        want the event. Unwanted events might be propagated to the parent
        widget.

        **See also** **accept** ().
        """
        ...

    def accept(self) -> None:
        """
        https://doc.qt.io/qt-6/qevent.html#accept

        **void QEvent::accept()**

        Sets the accept flag of the event object, the equivalent of calling
        **setAccepted** (true).

        Setting the accept parameter indicates that the event receiver wants the
        event. Unwanted events might be propagated to the parent widget.

        **See also** **ignore** ().
        """
        ...

    def isAccepted(self) -> bool:
        ...

    def setAccepted(self, accepted: bool) -> None:
        """
        https://doc.qt.io/qt-6/qevent.html#accepted-prop

        **accepted : bool**

        This property holds the accept flag of the event object.

        Setting the accept parameter indicates that the event receiver wants the
        event. Unwanted events might be propagated to the parent widget. By
        default, isAccepted() is set to true, but don't rely on this as
        subclasses may choose to clear it in their constructor.

        For convenience, the accept flag can also be set with **accept** (), and
        cleared with **ignore** ().

        **Note:** Accepting a **QPointerEvent**  implicitly **accepts**  all the
        **points**  that the event carries.

        **Access functions:**

        bool **isAccepted** () const
        virtual void **setAccepted** (bool
        **accepted** )

        **Member Function Documentation**
        """
        ...

    def spontaneous(self) -> bool:
        """
        https://doc.qt.io/qt-6/qevent.html#spontaneous

        **bool QEvent::spontaneous() const**

        Returns `true` if the event originated outside the application (a system
        event); otherwise returns `false`.
        """
        ...

    def type(self) -> int:
        """
        https://doc.qt.io/qt-6/qevent.html#type

        **QEvent::Type QEvent::type() const**

        Returns the event type.
        """
        ...
