"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
import PyQt6.sip
from PyQt6.QtCore import *


class QEventLoopLocker(PyQt6.sip.simplewrapper):
    """
    https://doc.qt.io/qt-6/qeventlooplocker.html

    **Detailed Description**

    The QEventLoopLocker operates on particular objects - either a
    **QCoreApplication**  instance, a **QEventLoop**  instance or a **QThread**
    instance.

    This makes it possible to, for example, run a batch of jobs with an event
    loop and exit that event loop after the last job is finished. That is
    accomplished by keeping a QEventLoopLocker with each job instance.

    The variant which operates on **QCoreApplication**  makes it possible to
    finish asynchronously running jobs after the last gui window has been
    closed. This can be useful for example for running a job which uploads data
    to a network.

    **See also** **QEventLoop**  and **QCoreApplication** .
    """

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qeventlooplocker.html#QEventLoopLocker

        **QEventLoopLocker::QEventLoopLocker()**

        Creates an event locker operating on the **QCoreApplication** .

        The application will quit when there are no more QEventLoopLockers
        operating on it.

        **See also** **QCoreApplication::quit** () and
        **QCoreApplication::isQuitLockEnabled** ().
        """
        ...

    @typing.overload
    def __init__(self, loop: QEventLoop) -> None:
        """
        https://doc.qt.io/qt-6/qeventlooplocker.html#QEventLoopLocker-1

        **QEventLoopLocker::QEventLoopLocker(QEventLoop * loop )**

        Creates an event locker operating on the **loop**.

        This particular **QEventLoop**  will quit when there are no more
        QEventLoopLockers operating on it.

        **See also** **QEventLoop::quit** ().
        """
        ...

    @typing.overload
    def __init__(self, thread: "QThread") -> None:
        """
        https://doc.qt.io/qt-6/qeventlooplocker.html#QEventLoopLocker-2

        **QEventLoopLocker::QEventLoopLocker(QThread * thread )**

        Creates an event locker operating on the **thread**.

        This particular **QThread**  will quit when there are no more
        QEventLoopLockers operating on it.

        **See also** **QThread::quit** ().
        """
        ...
