"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
import PyQt6.sip
from PyQt6.QtCore import *


class QLine(PyQt6.sip.simplewrapper):
    """
    https://doc.qt.io/qt-6/qline.html

    **Detailed Description**

    A QLine describes a finite length line (or a line segment) on a two-
    dimensional surface. The start and end points of the line are specified
    using integer point accuracy for coordinates. Use the **QLineF**
    constructor to retrieve a floating point copy.

    ![](images/qline-point.png)![](images/qline-coordinates.png)

    The positions of the line's start and end points can be retrieved using the
    **p1** (), **x1** (), **y1** (), **p2** (), **x2** (), and **y2** ()
    functions. The **dx** () and **dy** () functions return the horizontal and
    vertical components of the line. Use **isNull** () to determine whether the
    QLine represents a valid line or a null line.

    Finally, the line can be translated a given offset using the **translate**
    () function.

    **See also** **QLineF** , **QPolygon** , and **QRect** .
    """

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qline.html#QLine

        **QLine::QLine()**

        Constructs a null line.
        """
        ...

    @typing.overload
    def __init__(self, pt1_: "QPoint", pt2_: "QPoint") -> None:
        """
        https://doc.qt.io/qt-6/qline.html#QLine-1

        **QLine::QLine(const QPoint & p1 , const QPoint & p2 )**

        Constructs a line object that represents the line between **p1** and
        **p2**.
        """
        ...

    @typing.overload
    def __init__(self, x1pos: int, y1pos: int, x2pos: int, y2pos: int) -> None:
        """
        https://doc.qt.io/qt-6/qline.html#QLine-2

        **QLine::QLine(int x1 , int y1 , int x2 , int y2 )**

        Constructs a line object that represents the line between ( **x1** ,
        **y1** ) and ( **x2** , **y2** ).
        """
        ...

    @typing.overload
    def __init__(self, a0: "QLine") -> None:
        """
        https://doc.qt.io/qt-6/qline.html#QLine

        **QLine::QLine()**

        Constructs a null line.
        """
        ...

    def center(self) -> "QPoint":
        """
        https://doc.qt.io/qt-6/qline.html#center

        **[since 5.8] QPoint QLine::center() const**

        Returns the center point of this line. This is equivalent to (**p1** ()
        + **p2** ()) / 2, except it will never overflow.

        This function was introduced in Qt 5.8.
        """
        ...

    def setLine(self, aX1: int, aY1: int, aX2: int, aY2: int) -> None:
        """
        https://doc.qt.io/qt-6/qline.html#setLine

        **void QLine::setLine(int x1 , int y1 , int x2 , int y2 )**

        Sets this line to the start in **x1** , **y1** and end in **x2** ,
        **y2**.

        **See also** **setP1** (), **setP2** (), **p1** (), and **p2** ().
        """
        ...

    def setPoints(self, aP1: "QPoint", aP2: "QPoint") -> None:
        """
        https://doc.qt.io/qt-6/qline.html#setPoints

        **void QLine::setPoints(const QPoint & p1 , const QPoint & p2 )**

        Sets the start point of this line to **p1** and the end point of this
        line to **p2**.

        **See also** **setP1** (), **setP2** (), **p1** (), and **p2** ().
        """
        ...

    def setP2(self, aP2: "QPoint") -> None:
        """
        https://doc.qt.io/qt-6/qline.html#setP2

        **void QLine::setP2(const QPoint & p2 )**

        Sets the end point of this line to **p2**.

        **See also** **setP1** () and **p2** ().
        """
        ...

    def setP1(self, aP1: "QPoint") -> None:
        """
        https://doc.qt.io/qt-6/qline.html#setP1

        **void QLine::setP1(const QPoint & p1 )**

        Sets the starting point of this line to **p1**.

        **See also** **setP2** () and **p1** ().
        """
        ...

    @typing.overload
    def translated(self, p: "QPoint") -> "QLine":
        """
        https://doc.qt.io/qt-6/qline.html#translated

        **QLine QLine::translated(const QPoint & offset ) const**

        Returns this line translated by the given **offset**.
        """
        ...

    @typing.overload
    def translated(self, adx: int, ady: int) -> "QLine":
        """
        https://doc.qt.io/qt-6/qline.html#translated-1

        **QLine QLine::translated(int dx , int dy ) const**

        This is an overloaded function.

        Returns this line translated the distance specified by **dx** and
        **dy**.
        """
        ...

    @typing.overload
    def translate(self, point: "QPoint") -> None:
        """
        https://doc.qt.io/qt-6/qline.html#translate

        **void QLine::translate(const QPoint & offset )**

        Translates this line by the given **offset**.
        """
        ...

    @typing.overload
    def translate(self, adx: int, ady: int) -> None:
        """
        https://doc.qt.io/qt-6/qline.html#translate-1

        **void QLine::translate(int dx , int dy )**

        This is an overloaded function.

        Translates this line the distance specified by **dx** and **dy**.
        """
        ...

    def dy(self) -> int:
        """
        https://doc.qt.io/qt-6/qline.html#dy

        **int QLine::dy() const**

        Returns the vertical component of the line's vector.

        **See also** **dx** ().
        """
        ...

    def dx(self) -> int:
        """
        https://doc.qt.io/qt-6/qline.html#dx

        **int QLine::dx() const**

        Returns the horizontal component of the line's vector.

        **See also** **dy** ().
        """
        ...

    def p2(self) -> "QPoint":
        """
        https://doc.qt.io/qt-6/qline.html#p2

        **QPoint QLine::p2() const**

        Returns the line's end point.

        **See also** **setP2** (), **x2** (), **y2** (), and **p1** ().
        """
        ...

    def p1(self) -> "QPoint":
        """
        https://doc.qt.io/qt-6/qline.html#p1

        **QPoint QLine::p1() const**

        Returns the line's start point.

        **See also** **setP1** (), **x1** (), **y1** (), and **p2** ().
        """
        ...

    def y2(self) -> int:
        """
        https://doc.qt.io/qt-6/qline.html#y2

        **int QLine::y2() const**

        Returns the y-coordinate of the line's end point.

        **See also** **p2** ().
        """
        ...

    def x2(self) -> int:
        """
        https://doc.qt.io/qt-6/qline.html#x2

        **int QLine::x2() const**

        Returns the x-coordinate of the line's end point.

        **See also** **p2** ().
        """
        ...

    def y1(self) -> int:
        """
        https://doc.qt.io/qt-6/qline.html#y1

        **int QLine::y1() const**

        Returns the y-coordinate of the line's start point.

        **See also** **p1** ().
        """
        ...

    def x1(self) -> int:
        """
        https://doc.qt.io/qt-6/qline.html#x1

        **int QLine::x1() const**

        Returns the x-coordinate of the line's start point.

        **See also** **p1** ().
        """
        ...

    def __bool__(self) -> int:
        ...

    def isNull(self) -> bool:
        """
        https://doc.qt.io/qt-6/qline.html#isNull

        **bool QLine::isNull() const**

        Returns `true` if the line does not have distinct start and end points;
        otherwise returns `false`.
        """
        ...

    def __repr__(self) -> str:
        ...
