"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import enum
import typing
import PyQt6.sip
from PyQt6.QtCore import *
import enum


class QLineF(PyQt6.sip.simplewrapper):
    """
    https://doc.qt.io/qt-6/qlinef.html

    **Detailed Description**

    A QLineF describes a finite length line (or line segment) on a two-
    dimensional surface. QLineF defines the start and end points of the line
    using floating point accuracy for coordinates. Use the **toLine** ()
    function to retrieve an integer-based copy of this line.

    ![](images/qline-point.png)![](images/qline-coordinates.png)

    The positions of the line's start and end points can be retrieved using the
    **p1** (), **x1** (), **y1** (), **p2** (), **x2** (), and **y2** ()
    functions. The **dx** () and **dy** () functions return the horizontal and
    vertical components of the line, respectively.

    The line's length can be retrieved using the **length** () function, and
    altered using the **setLength** () function. Similarly, **angle** () and
    **setAngle** () are respectively used for retrieving and altering the angle
    of the line. Use the **isNull** () function to determine whether the QLineF
    represents a valid line or a null line.

    The **intersects** () function determines the **IntersectionType**  for this
    line and a given line, while the **angleTo** () function returns the angle
    between the lines. In addition, the **unitVector** () function returns a
    line that has the same starting point as this line, but with a length of
    only 1, while the **normalVector** () function returns a line that is
    perpendicular to this line with the same starting point and length.

    Finally, the line can be translated a given offset using the **translate**
    () function, and can be traversed using the **pointAt** () function.

    **Constraints**

    **QLine**  is limited to the minimum and maximum values for the `int` type.
    Operations on a **QLine**  that could potentially result in values outside
    this range will result in undefined behavior.

    **See also** **QLine** , **QPolygonF** , and **QRectF** .
    """

    class IntersectionType(enum.Enum):
        NoIntersection: QLineF = ...
        BoundedIntersection: QLineF = ...
        UnboundedIntersection: QLineF = ...

    @typing.overload
    def __init__(self, line: QLine) -> None:
        """
        https://doc.qt.io/qt-6/qlinef.html#QLineF

        **QLineF::QLineF()**

        Constructs a null line.
        """
        ...

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qlinef.html#QLineF-1

        **QLineF::QLineF(const QPointF & p1 , const QPointF & p2 )**

        Constructs a line object that represents the line between **p1** and
        **p2**.
        """
        ...

    @typing.overload
    def __init__(self, apt1: "QPointF", apt2: "QPointF") -> None:
        """
        https://doc.qt.io/qt-6/qlinef.html#QLineF-2

        **QLineF::QLineF(qreal x1 , qreal y1 , qreal x2 , qreal y2 )**

        Constructs a line object that represents the line between ( **x1** ,
        **y1** ) and ( **x2** , **y2** ).
        """
        ...

    @typing.overload
    def __init__(self, x1pos: float, y1pos: float, x2pos: float, y2pos: float) -> None:
        """
        https://doc.qt.io/qt-6/qlinef.html#QLineF-3

        **QLineF::QLineF(const QLine & line )**

        Construct a QLineF object from the given integer-based **line**.

        **See also** **toLine** ().
        """
        ...

    @typing.overload
    def __init__(self, a0: "QLineF") -> None:
        """
        https://doc.qt.io/qt-6/qlinef.html#QLineF

        **QLineF::QLineF()**

        Constructs a null line.
        """
        ...

    def center(self) -> "QPointF":
        """
        https://doc.qt.io/qt-6/qlinef.html#center

        **[since 5.8] QPointF QLineF::center() const**

        Returns the center point of this line. This is equivalent to 0.5 *
        **p1** () + 0.5 * **p2** ().

        This function was introduced in Qt 5.8.
        """
        ...

    def setLine(self, aX1: float, aY1: float, aX2: float, aY2: float) -> None:
        """
        https://doc.qt.io/qt-6/qlinef.html#setLine

        **void QLineF::setLine(qreal x1 , qreal y1 , qreal x2 , qreal y2 )**

        Sets this line to the start in **x1** , **y1** and end in **x2** ,
        **y2**.

        **See also** **setP1** (), **setP2** (), **p1** (), and **p2** ().
        """
        ...

    def setPoints(self, aP1: "QPointF", aP2: "QPointF") -> None:
        """
        https://doc.qt.io/qt-6/qlinef.html#setPoints

        **void QLineF::setPoints(const QPointF & p1 , const QPointF & p2 )**

        Sets the start point of this line to **p1** and the end point of this
        line to **p2**.

        **See also** **setP1** (), **setP2** (), **p1** (), and **p2** ().
        """
        ...

    def setP2(self, aP2: "QPointF") -> None:
        """
        https://doc.qt.io/qt-6/qlinef.html#setP2

        **void QLineF::setP2(const QPointF & p2 )**

        Sets the end point of this line to **p2**.

        **See also** **setP1** () and **p2** ().
        """
        ...

    def setP1(self, aP1: "QPointF") -> None:
        """
        https://doc.qt.io/qt-6/qlinef.html#setP1

        **void QLineF::setP1(const QPointF & p1 )**

        Sets the starting point of this line to **p1**.

        **See also** **setP2** () and **p1** ().
        """
        ...

    @typing.overload
    def translated(self, p: "QPointF") -> "QLineF":
        """
        https://doc.qt.io/qt-6/qlinef.html#translated

        **QLineF QLineF::translated(const QPointF & offset ) const**

        Returns this line translated by the given **offset**.
        """
        ...

    @typing.overload
    def translated(self, adx: float, ady: float) -> "QLineF":
        """
        https://doc.qt.io/qt-6/qlinef.html#translated-1

        **QLineF QLineF::translated(qreal dx , qreal dy ) const**

        This is an overloaded function.

        Returns this line translated the distance specified by **dx** and
        **dy**.
        """
        ...

    def angleTo(self, l: "QLineF") -> float:
        """
        https://doc.qt.io/qt-6/qlinef.html#angleTo

        **qreal QLineF::angleTo(const QLineF & line ) const**

        Returns the angle (in degrees) from this line to the given **line** ,
        taking the direction of the lines into account. If the lines do not
        **intersect**  within their range, it is the intersection point of the
        extended lines that serves as origin (see
        **QLineF::UnboundedIntersection** ).

        The returned value represents the number of degrees you need to add to
        this line to make it have the same angle as the given **line** , going
        counter-clockwise.

        **See also** **intersects** ().
        """
        ...

    def setAngle(self, angle: float) -> None:
        """
        https://doc.qt.io/qt-6/qlinef.html#setAngle

        **void QLineF::setAngle(qreal angle )**

        Sets the angle of the line to the given **angle** (in degrees). This
        will change the position of the second point of the line such that the
        line has the given angle.

        Positive values for the angles mean counter-clockwise while negative
        values mean the clockwise direction. Zero degrees is at the 3 o'clock
        position.

        **See also** **angle** ().
        """
        ...

    def angle(self) -> float:
        """
        https://doc.qt.io/qt-6/qlinef.html#angle

        **qreal QLineF::angle() const**

        Returns the angle of the line in degrees.

        The return value will be in the range of values from 0.0 up to but not
        including 360.0. The angles are measured counter-clockwise from a point
        on the x-axis to the right of the origin (x > 0).

        **See also** **setAngle** ().
        """
        ...

    @staticmethod
    def fromPolar(length: float, angle: float) -> "QLineF":
        """
        https://doc.qt.io/qt-6/qlinef.html#fromPolar

        **[static] QLineF QLineF::fromPolar(qreal length , qreal angle )**

        Returns a **QLineF**  with the given **length** and **angle**.

        The first point of the line will be on the origin.

        Positive values for the angles mean counter-clockwise while negative
        values mean the clockwise direction. Zero degrees is at the 3 o'clock
        position.
        """
        ...

    def toLine(self) -> QLine:
        """
        https://doc.qt.io/qt-6/qlinef.html#toLine

        **QLine QLineF::toLine() const**

        Returns an integer-based copy of this line.

        Note that the returned line's start and end points are rounded to the
        nearest integer.

        **See also** **QLineF** ().
        """
        ...

    def pointAt(self, t: float) -> "QPointF":
        """
        https://doc.qt.io/qt-6/qlinef.html#pointAt

        **QPointF QLineF::pointAt(qreal t ) const**

        Returns the point at the position specified by finite parameter **t**.
        The function returns the line's start point if t = 0, and its end point
        if t = 1.

        **See also** **dx** () and **dy** ().
        """
        ...

    def setLength(self, len: float) -> None:
        """
        https://doc.qt.io/qt-6/qlinef.html#setLength

        **void QLineF::setLength(qreal length )**

        Sets the length of the line to the given finite **length**. **QLineF**
        will move the end point - **p2** () - of the line to give the line its
        new length, unless **length** () was previously zero, in which case no
        scaling is attempted.

        **See also** **length** () and **unitVector** ().
        """
        ...

    @typing.overload
    def translate(self, point: "QPointF") -> None:
        """
        https://doc.qt.io/qt-6/qlinef.html#translate

        **void QLineF::translate(const QPointF & offset )**

        Translates this line by the given **offset**.
        """
        ...

    @typing.overload
    def translate(self, adx: float, ady: float) -> None:
        """
        https://doc.qt.io/qt-6/qlinef.html#translate-1

        **void QLineF::translate(qreal dx , qreal dy )**

        This is an overloaded function.

        Translates this line the distance specified by **dx** and **dy**.
        """
        ...

    def normalVector(self) -> "QLineF":
        """
        https://doc.qt.io/qt-6/qlinef.html#normalVector

        **QLineF QLineF::normalVector() const**

        Returns a line that is perpendicular to this line with the same starting
        point and length.

        ![](images/qlinef-normalvector.png)

        **See also** **unitVector** ().
        """
        ...

    def dy(self) -> float:
        """
        https://doc.qt.io/qt-6/qlinef.html#dy

        **qreal QLineF::dy() const**

        Returns the vertical component of the line's vector.

        **See also** **dx** () and **pointAt** ().
        """
        ...

    def dx(self) -> float:
        """
        https://doc.qt.io/qt-6/qlinef.html#dx

        **qreal QLineF::dx() const**

        Returns the horizontal component of the line's vector.

        **See also** **dy** () and **pointAt** ().
        """
        ...

    def p2(self) -> "QPointF":
        """
        https://doc.qt.io/qt-6/qlinef.html#p2

        **QPointF QLineF::p2() const**

        Returns the line's end point.

        **See also** **setP2** (), **x2** (), **y2** (), and **p1** ().
        """
        ...

    def p1(self) -> "QPointF":
        """
        https://doc.qt.io/qt-6/qlinef.html#p1

        **QPointF QLineF::p1() const**

        Returns the line's start point.

        **See also** **setP1** (), **x1** (), **y1** (), and **p2** ().
        """
        ...

    def y2(self) -> float:
        """
        https://doc.qt.io/qt-6/qlinef.html#y2

        **qreal QLineF::y2() const**

        Returns the y-coordinate of the line's end point.

        **See also** **p2** ().
        """
        ...

    def x2(self) -> float:
        """
        https://doc.qt.io/qt-6/qlinef.html#x2

        **qreal QLineF::x2() const**

        Returns the x-coordinate of the line's end point.

        **See also** **p2** ().
        """
        ...

    def y1(self) -> float:
        """
        https://doc.qt.io/qt-6/qlinef.html#y1

        **qreal QLineF::y1() const**

        Returns the y-coordinate of the line's start point.

        **See also** **p1** ().
        """
        ...

    def x1(self) -> float:
        """
        https://doc.qt.io/qt-6/qlinef.html#x1

        **qreal QLineF::x1() const**

        Returns the x-coordinate of the line's start point.

        **See also** **p1** ().
        """
        ...

    def __repr__(self) -> str:
        ...

    def intersects(
        self, l: "QLineF"
    ) -> typing.Tuple["QLineF.IntersectionType", "QPointF"]:
        """
        https://doc.qt.io/qt-6/qlinef.html#intersects

        **[since 5.14] QLineF::IntersectionType QLineF::intersects(const QLineF
        & line , QPointF * intersectionPoint = nullptr) const**

        Returns a value indicating whether or not **this** line intersects with
        the given **line**.

        The actual intersection point is extracted to **intersectionPoint** (if
        the pointer is valid). If the lines are parallel, the intersection point
        is undefined.

        This function was introduced in Qt 5.14.
        """
        ...

    def unitVector(self) -> "QLineF":
        """
        https://doc.qt.io/qt-6/qlinef.html#unitVector

        **QLineF QLineF::unitVector() const**

        Returns the unit vector for this line, i.e a line starting at the same
        point as **this** line with a length of 1.0, provided the line is non-
        null.

        **See also** **normalVector** () and **setLength** ().
        """
        ...

    def length(self) -> float:
        """
        https://doc.qt.io/qt-6/qlinef.html#length

        **qreal QLineF::length() const**

        Returns the length of the line.

        **See also** **setLength** () and **isNull** ().
        """
        ...

    def __bool__(self) -> int:
        ...

    def isNull(self) -> bool:
        """
        https://doc.qt.io/qt-6/qlinef.html#isNull

        **bool QLineF::isNull() const**

        Returns `true` if the line does not have distinct start and end points;
        otherwise returns `false`. The start and end points are considered
        distinct if **qFuzzyCompare** () can distinguish them in at least one
        coordinate.

        **Note:** Due to the use of fuzzy comparison, isNull() may return `true`
        for lines whose **length** () is not zero.

        **See also** **qFuzzyCompare** () and **length** ().
        """
        ...
