"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import enum
import typing
import PyQt6.sip
import datetime
from PyQt6.QtCore import *
import enum


class QLocale(PyQt6.sip.simplewrapper):
    """
    https://doc.qt.io/qt-6/qlocale.html

    **Detailed Description**

    QLocale is constructed for a specified language, optional script and
    territory. It offers various facilities for formatting data as text,
    localized appropriately, and for reading data out of localized text.

    Example:

    **QLocale**  egyptian(**QLocale** ::Arabic, **QLocale** ::Egypt);
    **QString**  s1 = egyptian.toString(1.571429E+07, 'e');
        **QString**  s2
    = egyptian.toString(10);

        double d = egyptian.toDouble(s1);
        int
    i = egyptian.toInt(s2);

    QLocale supports the concept of a default locale, which is determined from
    the system's locale settings at application startup. The default locale can
    be changed by calling the static member **setDefault** (). Setting the
    default locale has the following effects:

    * If a QLocale object is constructed with the default constructor, it will
    use the default locale's settings.
      * **QString::arg** () uses the default
    locale to format a number when its position specifier in the format string
    contains an 'L', e.g. "%L1".

    The following example illustrates how to use QLocale directly:

    bool ok;
        double d;

        **QLocale** ::setDefault(**QLocale** ::C);
    // uses '.' as a decimal point
        **QLocale**  cLocale;
    // default-constructed C locale
        d = cLocale.toDouble("1234,56", &ok); //
    ok == false, d == 0
        d = cLocale.toDouble("1234.56", &ok); // ok == true,
    d == 1234.56

        **QLocale** ::setDefault(**QLocale** ::German); //
    uses ',' as a decimal point
        **QLocale**  german;
    // default-constructed German locale
        d = german.toDouble("1234,56",
    &ok);  // ok == true,  d == 1234.56
        d = german.toDouble("1234.56", &ok);
    // ok == false, d == 0

        **QLocale** ::setDefault(**QLocale**
    ::English);
        // Default locale now uses ',' as a group separator.
    **QString**  str = **QString** ("%1 %L2
    %L3").arg(12345).arg(12345).arg(12345, 0, 16);
        // str == "12345 12,345
    3039"

    An alternative method for constructing a QLocale object is by specifying the
    locale name.

    **QLocale**  korean("ko");
        **QLocale**  swiss("de_CH");

    This constructor reads the language, script and/or territory from the given
    name, accepting either uderscore or dash as separator (and ignoring any
    trailing `.codeset` or `@variant` suffix).

    **Note:** For the current keyboard input locale take a look at
    **QInputMethod::locale** ().

    QLocale's data is based on Common Locale Data Repository v40.

    **Matching combinations of language, script and territory**

    QLocale has data, derived from CLDR, for many combinations of language,
    script and territory, but not all. If it is constructed with all three of
    these key values specified (treating `AnyLanguage`, `AnyScript` or
    `AnyTerritory` as unspecified) and QLocale has data for the given
    combination, this data is used. Otherwise, QLocale does its best to find a
    sensible combination of language, script and territory, for which it does
    have data, that matches those that were specified.

    The CLDR provides tables of likely combinations, which are used to fill in
    any unspecified key or keys; if QLocale has data for the result of such a
    likely combination, that is used. If no language is specified, and none can
    be determined from script and territory, or if QLocale has no data for the
    language, the "C" locale (when reading the keys from a string) or default
    locale (otherwise) is used.

    When QLocale has no data for the keys specified, with likely keys filled in
    where unspecified, but does have data for the resulting language, a fall-
    back is sought, based on ignoring either territory, script or both (in that
    order). This results in a QLocale which may not match what was asked for,
    but provides localization that's as suitable as the available data permits,
    for the keys specified.

    Use **language** (), **script** () and **territory** () to determine the
    actual keys used.

    **See also** **QString::arg** () and **QInputMethod::locale** ().
    """

    class DataSizeFormat(enum.Flag):
        DataSizeIecFormat: QLocale = ...
        DataSizeTraditionalFormat: QLocale = ...
        DataSizeSIFormat: QLocale = ...

    class FloatingPointPrecisionOption(enum.Enum):
        FloatingPointShortest: QLocale = ...

    class QuotationStyle(enum.Enum):
        StandardQuotation: QLocale = ...
        AlternateQuotation: QLocale = ...

    class CurrencySymbolFormat(enum.Enum):
        CurrencyIsoCode: QLocale = ...
        CurrencySymbol: QLocale = ...
        CurrencyDisplayName: QLocale = ...

    class Script(enum.Enum):
        AnyScript: QLocale = ...
        ArabicScript: QLocale = ...
        CyrillicScript: QLocale = ...
        DeseretScript: QLocale = ...
        GurmukhiScript: QLocale = ...
        SimplifiedHanScript: QLocale = ...
        TraditionalHanScript: QLocale = ...
        LatinScript: QLocale = ...
        MongolianScript: QLocale = ...
        TifinaghScript: QLocale = ...
        SimplifiedChineseScript: QLocale = ...
        TraditionalChineseScript: QLocale = ...
        ArmenianScript: QLocale = ...
        BengaliScript: QLocale = ...
        CherokeeScript: QLocale = ...
        DevanagariScript: QLocale = ...
        EthiopicScript: QLocale = ...
        GeorgianScript: QLocale = ...
        GreekScript: QLocale = ...
        GujaratiScript: QLocale = ...
        HebrewScript: QLocale = ...
        JapaneseScript: QLocale = ...
        KhmerScript: QLocale = ...
        KannadaScript: QLocale = ...
        KoreanScript: QLocale = ...
        LaoScript: QLocale = ...
        MalayalamScript: QLocale = ...
        MyanmarScript: QLocale = ...
        OriyaScript: QLocale = ...
        TamilScript: QLocale = ...
        TeluguScript: QLocale = ...
        ThaanaScript: QLocale = ...
        ThaiScript: QLocale = ...
        TibetanScript: QLocale = ...
        SinhalaScript: QLocale = ...
        SyriacScript: QLocale = ...
        YiScript: QLocale = ...
        VaiScript: QLocale = ...
        AvestanScript: QLocale = ...
        BalineseScript: QLocale = ...
        BamumScript: QLocale = ...
        BatakScript: QLocale = ...
        BopomofoScript: QLocale = ...
        BrahmiScript: QLocale = ...
        BugineseScript: QLocale = ...
        BuhidScript: QLocale = ...
        CanadianAboriginalScript: QLocale = ...
        CarianScript: QLocale = ...
        ChakmaScript: QLocale = ...
        ChamScript: QLocale = ...
        CopticScript: QLocale = ...
        CypriotScript: QLocale = ...
        EgyptianHieroglyphsScript: QLocale = ...
        FraserScript: QLocale = ...
        GlagoliticScript: QLocale = ...
        GothicScript: QLocale = ...
        HanScript: QLocale = ...
        HangulScript: QLocale = ...
        HanunooScript: QLocale = ...
        ImperialAramaicScript: QLocale = ...
        InscriptionalPahlaviScript: QLocale = ...
        InscriptionalParthianScript: QLocale = ...
        JavaneseScript: QLocale = ...
        KaithiScript: QLocale = ...
        KatakanaScript: QLocale = ...
        KayahLiScript: QLocale = ...
        KharoshthiScript: QLocale = ...
        LannaScript: QLocale = ...
        LepchaScript: QLocale = ...
        LimbuScript: QLocale = ...
        LinearBScript: QLocale = ...
        LycianScript: QLocale = ...
        LydianScript: QLocale = ...
        MandaeanScript: QLocale = ...
        MeiteiMayekScript: QLocale = ...
        MeroiticScript: QLocale = ...
        MeroiticCursiveScript: QLocale = ...
        NkoScript: QLocale = ...
        NewTaiLueScript: QLocale = ...
        OghamScript: QLocale = ...
        OlChikiScript: QLocale = ...
        OldItalicScript: QLocale = ...
        OldPersianScript: QLocale = ...
        OldSouthArabianScript: QLocale = ...
        OrkhonScript: QLocale = ...
        OsmanyaScript: QLocale = ...
        PhagsPaScript: QLocale = ...
        PhoenicianScript: QLocale = ...
        PollardPhoneticScript: QLocale = ...
        RejangScript: QLocale = ...
        RunicScript: QLocale = ...
        SamaritanScript: QLocale = ...
        SaurashtraScript: QLocale = ...
        SharadaScript: QLocale = ...
        ShavianScript: QLocale = ...
        SoraSompengScript: QLocale = ...
        CuneiformScript: QLocale = ...
        SundaneseScript: QLocale = ...
        SylotiNagriScript: QLocale = ...
        TagalogScript: QLocale = ...
        TagbanwaScript: QLocale = ...
        TaiLeScript: QLocale = ...
        TaiVietScript: QLocale = ...
        TakriScript: QLocale = ...
        UgariticScript: QLocale = ...
        BrailleScript: QLocale = ...
        HiraganaScript: QLocale = ...
        CaucasianAlbanianScript: QLocale = ...
        BassaVahScript: QLocale = ...
        DuployanScript: QLocale = ...
        ElbasanScript: QLocale = ...
        GranthaScript: QLocale = ...
        PahawhHmongScript: QLocale = ...
        KhojkiScript: QLocale = ...
        LinearAScript: QLocale = ...
        MahajaniScript: QLocale = ...
        ManichaeanScript: QLocale = ...
        MendeKikakuiScript: QLocale = ...
        ModiScript: QLocale = ...
        MroScript: QLocale = ...
        OldNorthArabianScript: QLocale = ...
        NabataeanScript: QLocale = ...
        PalmyreneScript: QLocale = ...
        PauCinHauScript: QLocale = ...
        OldPermicScript: QLocale = ...
        PsalterPahlaviScript: QLocale = ...
        SiddhamScript: QLocale = ...
        KhudawadiScript: QLocale = ...
        TirhutaScript: QLocale = ...
        VarangKshitiScript: QLocale = ...
        AhomScript: QLocale = ...
        AnatolianHieroglyphsScript: QLocale = ...
        HatranScript: QLocale = ...
        MultaniScript: QLocale = ...
        OldHungarianScript: QLocale = ...
        SignWritingScript: QLocale = ...
        AdlamScript: QLocale = ...
        BhaiksukiScript: QLocale = ...
        MarchenScript: QLocale = ...
        NewaScript: QLocale = ...
        OsageScript: QLocale = ...
        TangutScript: QLocale = ...
        HanWithBopomofoScript: QLocale = ...
        JamoScript: QLocale = ...
        BanglaScript: QLocale = ...
        MendeScript: QLocale = ...
        OdiaScript: QLocale = ...

    class MeasurementSystem(enum.Enum):
        MetricSystem: QLocale = ...
        ImperialSystem: QLocale = ...
        ImperialUSSystem: QLocale = ...
        ImperialUKSystem: QLocale = ...

    class FormatType(enum.Enum):
        LongFormat: QLocale = ...
        ShortFormat: QLocale = ...
        NarrowFormat: QLocale = ...

    class NumberOption(enum.Flag):
        OmitGroupSeparator: QLocale = ...
        RejectGroupSeparator: QLocale = ...
        DefaultNumberOptions: QLocale = ...
        OmitLeadingZeroInExponent: QLocale = ...
        RejectLeadingZeroInExponent: QLocale = ...
        IncludeTrailingZeroesAfterDot: QLocale = ...
        RejectTrailingZeroesAfterDot: QLocale = ...

    class Country(enum.Enum):
        AnyCountry: QLocale = ...
        AnyTerritory: QLocale = ...
        Afghanistan: QLocale = ...
        Albania: QLocale = ...
        Algeria: QLocale = ...
        AmericanSamoa: QLocale = ...
        Andorra: QLocale = ...
        Angola: QLocale = ...
        Anguilla: QLocale = ...
        Antarctica: QLocale = ...
        AntiguaAndBarbuda: QLocale = ...
        Argentina: QLocale = ...
        Armenia: QLocale = ...
        Aruba: QLocale = ...
        Australia: QLocale = ...
        Austria: QLocale = ...
        Azerbaijan: QLocale = ...
        Bahamas: QLocale = ...
        Bahrain: QLocale = ...
        Bangladesh: QLocale = ...
        Barbados: QLocale = ...
        Belarus: QLocale = ...
        Belgium: QLocale = ...
        Belize: QLocale = ...
        Benin: QLocale = ...
        Bermuda: QLocale = ...
        Bhutan: QLocale = ...
        Bolivia: QLocale = ...
        BosniaAndHerzegowina: QLocale = ...
        Botswana: QLocale = ...
        BouvetIsland: QLocale = ...
        Brazil: QLocale = ...
        BritishIndianOceanTerritory: QLocale = ...
        Bulgaria: QLocale = ...
        BurkinaFaso: QLocale = ...
        Burundi: QLocale = ...
        Cambodia: QLocale = ...
        Cameroon: QLocale = ...
        Canada: QLocale = ...
        CapeVerde: QLocale = ...
        CaymanIslands: QLocale = ...
        CentralAfricanRepublic: QLocale = ...
        Chad: QLocale = ...
        Chile: QLocale = ...
        China: QLocale = ...
        ChristmasIsland: QLocale = ...
        CocosIslands: QLocale = ...
        Colombia: QLocale = ...
        Comoros: QLocale = ...
        DemocraticRepublicOfCongo: QLocale = ...
        PeoplesRepublicOfCongo: QLocale = ...
        CookIslands: QLocale = ...
        CostaRica: QLocale = ...
        IvoryCoast: QLocale = ...
        Croatia: QLocale = ...
        Cuba: QLocale = ...
        Cyprus: QLocale = ...
        CzechRepublic: QLocale = ...
        Denmark: QLocale = ...
        Djibouti: QLocale = ...
        Dominica: QLocale = ...
        DominicanRepublic: QLocale = ...
        EastTimor: QLocale = ...
        Ecuador: QLocale = ...
        Egypt: QLocale = ...
        ElSalvador: QLocale = ...
        EquatorialGuinea: QLocale = ...
        Eritrea: QLocale = ...
        Estonia: QLocale = ...
        Ethiopia: QLocale = ...
        FalklandIslands: QLocale = ...
        FaroeIslands: QLocale = ...
        Finland: QLocale = ...
        France: QLocale = ...
        FrenchGuiana: QLocale = ...
        FrenchPolynesia: QLocale = ...
        FrenchSouthernTerritories: QLocale = ...
        Gabon: QLocale = ...
        Gambia: QLocale = ...
        Georgia: QLocale = ...
        Germany: QLocale = ...
        Ghana: QLocale = ...
        Gibraltar: QLocale = ...
        Greece: QLocale = ...
        Greenland: QLocale = ...
        Grenada: QLocale = ...
        Guadeloupe: QLocale = ...
        Guam: QLocale = ...
        Guatemala: QLocale = ...
        Guinea: QLocale = ...
        GuineaBissau: QLocale = ...
        Guyana: QLocale = ...
        Haiti: QLocale = ...
        HeardAndMcDonaldIslands: QLocale = ...
        Honduras: QLocale = ...
        HongKong: QLocale = ...
        Hungary: QLocale = ...
        Iceland: QLocale = ...
        India: QLocale = ...
        Indonesia: QLocale = ...
        Iran: QLocale = ...
        Iraq: QLocale = ...
        Ireland: QLocale = ...
        Israel: QLocale = ...
        Italy: QLocale = ...
        Jamaica: QLocale = ...
        Japan: QLocale = ...
        Jordan: QLocale = ...
        Kazakhstan: QLocale = ...
        Kenya: QLocale = ...
        Kiribati: QLocale = ...
        DemocraticRepublicOfKorea: QLocale = ...
        RepublicOfKorea: QLocale = ...
        Kuwait: QLocale = ...
        Kyrgyzstan: QLocale = ...
        Latvia: QLocale = ...
        Lebanon: QLocale = ...
        Lesotho: QLocale = ...
        Liberia: QLocale = ...
        Liechtenstein: QLocale = ...
        Lithuania: QLocale = ...
        Luxembourg: QLocale = ...
        Macau: QLocale = ...
        Macedonia: QLocale = ...
        Madagascar: QLocale = ...
        Malawi: QLocale = ...
        Malaysia: QLocale = ...
        Maldives: QLocale = ...
        Mali: QLocale = ...
        Malta: QLocale = ...
        MarshallIslands: QLocale = ...
        Martinique: QLocale = ...
        Mauritania: QLocale = ...
        Mauritius: QLocale = ...
        Mayotte: QLocale = ...
        Mexico: QLocale = ...
        Micronesia: QLocale = ...
        Moldova: QLocale = ...
        Monaco: QLocale = ...
        Mongolia: QLocale = ...
        Montserrat: QLocale = ...
        Morocco: QLocale = ...
        Mozambique: QLocale = ...
        Myanmar: QLocale = ...
        Namibia: QLocale = ...
        NauruCountry: QLocale = ...
        Nepal: QLocale = ...
        Netherlands: QLocale = ...
        NewCaledonia: QLocale = ...
        NewZealand: QLocale = ...
        Nicaragua: QLocale = ...
        Niger: QLocale = ...
        Nigeria: QLocale = ...
        Niue: QLocale = ...
        NorfolkIsland: QLocale = ...
        NorthernMarianaIslands: QLocale = ...
        Norway: QLocale = ...
        Oman: QLocale = ...
        Pakistan: QLocale = ...
        Palau: QLocale = ...
        Panama: QLocale = ...
        PapuaNewGuinea: QLocale = ...
        Paraguay: QLocale = ...
        Peru: QLocale = ...
        Philippines: QLocale = ...
        Pitcairn: QLocale = ...
        Poland: QLocale = ...
        Portugal: QLocale = ...
        PuertoRico: QLocale = ...
        Qatar: QLocale = ...
        Reunion: QLocale = ...
        Romania: QLocale = ...
        RussianFederation: QLocale = ...
        Rwanda: QLocale = ...
        SaintKittsAndNevis: QLocale = ...
        Samoa: QLocale = ...
        SanMarino: QLocale = ...
        SaoTomeAndPrincipe: QLocale = ...
        SaudiArabia: QLocale = ...
        Senegal: QLocale = ...
        Seychelles: QLocale = ...
        SierraLeone: QLocale = ...
        Singapore: QLocale = ...
        Slovakia: QLocale = ...
        Slovenia: QLocale = ...
        SolomonIslands: QLocale = ...
        Somalia: QLocale = ...
        SouthAfrica: QLocale = ...
        SouthGeorgiaAndTheSouthSandwichIslands: QLocale = ...
        Spain: QLocale = ...
        SriLanka: QLocale = ...
        Sudan: QLocale = ...
        Suriname: QLocale = ...
        SvalbardAndJanMayenIslands: QLocale = ...
        Swaziland: QLocale = ...
        Sweden: QLocale = ...
        Switzerland: QLocale = ...
        SyrianArabRepublic: QLocale = ...
        Taiwan: QLocale = ...
        Tajikistan: QLocale = ...
        Tanzania: QLocale = ...
        Thailand: QLocale = ...
        Togo: QLocale = ...
        TrinidadAndTobago: QLocale = ...
        Tunisia: QLocale = ...
        Turkey: QLocale = ...
        Turkmenistan: QLocale = ...
        TurksAndCaicosIslands: QLocale = ...
        Uganda: QLocale = ...
        Ukraine: QLocale = ...
        UnitedArabEmirates: QLocale = ...
        UnitedKingdom: QLocale = ...
        UnitedStates: QLocale = ...
        UnitedStatesMinorOutlyingIslands: QLocale = ...
        Uruguay: QLocale = ...
        Uzbekistan: QLocale = ...
        Vanuatu: QLocale = ...
        VaticanCityState: QLocale = ...
        Venezuela: QLocale = ...
        BritishVirginIslands: QLocale = ...
        WallisAndFutunaIslands: QLocale = ...
        WesternSahara: QLocale = ...
        Yemen: QLocale = ...
        Zambia: QLocale = ...
        Zimbabwe: QLocale = ...
        Montenegro: QLocale = ...
        Serbia: QLocale = ...
        SaintBarthelemy: QLocale = ...
        SaintMartin: QLocale = ...
        LatinAmericaAndTheCaribbean: QLocale = ...
        LastCountry: QLocale = ...
        Brunei: QLocale = ...
        CongoKinshasa: QLocale = ...
        CongoBrazzaville: QLocale = ...
        Fiji: QLocale = ...
        Guernsey: QLocale = ...
        NorthKorea: QLocale = ...
        SouthKorea: QLocale = ...
        Laos: QLocale = ...
        Libya: QLocale = ...
        CuraSao: QLocale = ...
        PalestinianTerritories: QLocale = ...
        Russia: QLocale = ...
        SaintLucia: QLocale = ...
        SaintVincentAndTheGrenadines: QLocale = ...
        SaintHelena: QLocale = ...
        SaintPierreAndMiquelon: QLocale = ...
        Syria: QLocale = ...
        Tonga: QLocale = ...
        Vietnam: QLocale = ...
        UnitedStatesVirginIslands: QLocale = ...
        CanaryIslands: QLocale = ...
        ClippertonIsland: QLocale = ...
        AscensionIsland: QLocale = ...
        AlandIslands: QLocale = ...
        DiegoGarcia: QLocale = ...
        CeutaAndMelilla: QLocale = ...
        IsleOfMan: QLocale = ...
        Jersey: QLocale = ...
        TristanDaCunha: QLocale = ...
        SouthSudan: QLocale = ...
        Bonaire: QLocale = ...
        SintMaarten: QLocale = ...
        Kosovo: QLocale = ...
        TokelauCountry: QLocale = ...
        TuvaluCountry: QLocale = ...
        EuropeanUnion: QLocale = ...
        OutlyingOceania: QLocale = ...
        LatinAmerica: QLocale = ...
        World: QLocale = ...
        Europe: QLocale = ...
        BosniaAndHerzegovina: QLocale = ...
        CaribbeanNetherlands: QLocale = ...
        Curacao: QLocale = ...
        Czechia: QLocale = ...
        Eswatini: QLocale = ...
        Macao: QLocale = ...
        SaintVincentAndGrenadines: QLocale = ...
        SouthGeorgiaAndSouthSandwichIslands: QLocale = ...
        SvalbardAndJanMayen: QLocale = ...
        TimorLeste: QLocale = ...
        UnitedStatesOutlyingIslands: QLocale = ...
        VaticanCity: QLocale = ...
        WallisAndFutuna: QLocale = ...
        NauruTerritory: QLocale = ...
        TokelauTerritory: QLocale = ...
        TuvaluTerritory: QLocale = ...

    class Language(enum.Enum):
        C: QLocale = ...
        Abkhazian: QLocale = ...
        Afan: QLocale = ...
        Afar: QLocale = ...
        Afrikaans: QLocale = ...
        Albanian: QLocale = ...
        Amharic: QLocale = ...
        Arabic: QLocale = ...
        Armenian: QLocale = ...
        Assamese: QLocale = ...
        Aymara: QLocale = ...
        Azerbaijani: QLocale = ...
        Bashkir: QLocale = ...
        Basque: QLocale = ...
        Bengali: QLocale = ...
        Bhutani: QLocale = ...
        Bislama: QLocale = ...
        Breton: QLocale = ...
        Bulgarian: QLocale = ...
        Burmese: QLocale = ...
        Byelorussian: QLocale = ...
        Cambodian: QLocale = ...
        Catalan: QLocale = ...
        Chinese: QLocale = ...
        Corsican: QLocale = ...
        Croatian: QLocale = ...
        Czech: QLocale = ...
        Danish: QLocale = ...
        Dutch: QLocale = ...
        English: QLocale = ...
        Esperanto: QLocale = ...
        Estonian: QLocale = ...
        Faroese: QLocale = ...
        Finnish: QLocale = ...
        French: QLocale = ...
        Frisian: QLocale = ...
        Gaelic: QLocale = ...
        Galician: QLocale = ...
        Georgian: QLocale = ...
        German: QLocale = ...
        Greek: QLocale = ...
        Greenlandic: QLocale = ...
        Guarani: QLocale = ...
        Gujarati: QLocale = ...
        Hausa: QLocale = ...
        Hebrew: QLocale = ...
        Hindi: QLocale = ...
        Hungarian: QLocale = ...
        Icelandic: QLocale = ...
        Indonesian: QLocale = ...
        Interlingua: QLocale = ...
        Interlingue: QLocale = ...
        Inuktitut: QLocale = ...
        Inupiak: QLocale = ...
        Irish: QLocale = ...
        Italian: QLocale = ...
        Japanese: QLocale = ...
        Javanese: QLocale = ...
        Kannada: QLocale = ...
        Kashmiri: QLocale = ...
        Kazakh: QLocale = ...
        Kinyarwanda: QLocale = ...
        Kirghiz: QLocale = ...
        Korean: QLocale = ...
        Kurdish: QLocale = ...
        Kurundi: QLocale = ...
        Latin: QLocale = ...
        Latvian: QLocale = ...
        Lingala: QLocale = ...
        Lithuanian: QLocale = ...
        Macedonian: QLocale = ...
        Malagasy: QLocale = ...
        Malay: QLocale = ...
        Malayalam: QLocale = ...
        Maltese: QLocale = ...
        Maori: QLocale = ...
        Marathi: QLocale = ...
        Mongolian: QLocale = ...
        NauruLanguage: QLocale = ...
        Nepali: QLocale = ...
        Occitan: QLocale = ...
        Oriya: QLocale = ...
        Pashto: QLocale = ...
        Persian: QLocale = ...
        Polish: QLocale = ...
        Portuguese: QLocale = ...
        Punjabi: QLocale = ...
        Quechua: QLocale = ...
        RhaetoRomance: QLocale = ...
        Romanian: QLocale = ...
        Russian: QLocale = ...
        Samoan: QLocale = ...
        Sanskrit: QLocale = ...
        Serbian: QLocale = ...
        Shona: QLocale = ...
        Sindhi: QLocale = ...
        Slovak: QLocale = ...
        Slovenian: QLocale = ...
        Somali: QLocale = ...
        Spanish: QLocale = ...
        Sundanese: QLocale = ...
        Swahili: QLocale = ...
        Swedish: QLocale = ...
        Tajik: QLocale = ...
        Tamil: QLocale = ...
        Tatar: QLocale = ...
        Telugu: QLocale = ...
        Thai: QLocale = ...
        Tibetan: QLocale = ...
        Tigrinya: QLocale = ...
        Tsonga: QLocale = ...
        Turkish: QLocale = ...
        Turkmen: QLocale = ...
        Uigur: QLocale = ...
        Ukrainian: QLocale = ...
        Urdu: QLocale = ...
        Uzbek: QLocale = ...
        Vietnamese: QLocale = ...
        Volapuk: QLocale = ...
        Welsh: QLocale = ...
        Wolof: QLocale = ...
        Xhosa: QLocale = ...
        Yiddish: QLocale = ...
        Yoruba: QLocale = ...
        Zhuang: QLocale = ...
        Zulu: QLocale = ...
        Bosnian: QLocale = ...
        Divehi: QLocale = ...
        Manx: QLocale = ...
        Cornish: QLocale = ...
        LastLanguage: QLocale = ...
        NorwegianBokmal: QLocale = ...
        NorwegianNynorsk: QLocale = ...
        Akan: QLocale = ...
        Konkani: QLocale = ...
        Ga: QLocale = ...
        Igbo: QLocale = ...
        Kamba: QLocale = ...
        Syriac: QLocale = ...
        Blin: QLocale = ...
        Geez: QLocale = ...
        Koro: QLocale = ...
        Sidamo: QLocale = ...
        Atsam: QLocale = ...
        Tigre: QLocale = ...
        Jju: QLocale = ...
        Friulian: QLocale = ...
        Venda: QLocale = ...
        Ewe: QLocale = ...
        Walamo: QLocale = ...
        Hawaiian: QLocale = ...
        Tyap: QLocale = ...
        Chewa: QLocale = ...
        Filipino: QLocale = ...
        SwissGerman: QLocale = ...
        SichuanYi: QLocale = ...
        Kpelle: QLocale = ...
        LowGerman: QLocale = ...
        SouthNdebele: QLocale = ...
        NorthernSotho: QLocale = ...
        NorthernSami: QLocale = ...
        Taroko: QLocale = ...
        Gusii: QLocale = ...
        Taita: QLocale = ...
        Fulah: QLocale = ...
        Kikuyu: QLocale = ...
        Samburu: QLocale = ...
        Sena: QLocale = ...
        NorthNdebele: QLocale = ...
        Rombo: QLocale = ...
        Tachelhit: QLocale = ...
        Kabyle: QLocale = ...
        Nyankole: QLocale = ...
        Bena: QLocale = ...
        Vunjo: QLocale = ...
        Bambara: QLocale = ...
        Embu: QLocale = ...
        Cherokee: QLocale = ...
        Morisyen: QLocale = ...
        Makonde: QLocale = ...
        Langi: QLocale = ...
        Ganda: QLocale = ...
        Bemba: QLocale = ...
        Kabuverdianu: QLocale = ...
        Meru: QLocale = ...
        Kalenjin: QLocale = ...
        Nama: QLocale = ...
        Machame: QLocale = ...
        Colognian: QLocale = ...
        Masai: QLocale = ...
        Soga: QLocale = ...
        Luyia: QLocale = ...
        Asu: QLocale = ...
        Teso: QLocale = ...
        Saho: QLocale = ...
        KoyraChiini: QLocale = ...
        Rwa: QLocale = ...
        Luo: QLocale = ...
        Chiga: QLocale = ...
        CentralMoroccoTamazight: QLocale = ...
        KoyraboroSenni: QLocale = ...
        Shambala: QLocale = ...
        AnyLanguage: QLocale = ...
        Rundi: QLocale = ...
        Bodo: QLocale = ...
        Aghem: QLocale = ...
        Basaa: QLocale = ...
        Zarma: QLocale = ...
        Duala: QLocale = ...
        JolaFonyi: QLocale = ...
        Ewondo: QLocale = ...
        Bafia: QLocale = ...
        LubaKatanga: QLocale = ...
        MakhuwaMeetto: QLocale = ...
        Mundang: QLocale = ...
        Kwasio: QLocale = ...
        Nuer: QLocale = ...
        Sakha: QLocale = ...
        Sangu: QLocale = ...
        Tasawaq: QLocale = ...
        Vai: QLocale = ...
        Walser: QLocale = ...
        Yangben: QLocale = ...
        Oromo: QLocale = ...
        Dzongkha: QLocale = ...
        Belarusian: QLocale = ...
        Khmer: QLocale = ...
        Fijian: QLocale = ...
        WesternFrisian: QLocale = ...
        Lao: QLocale = ...
        Marshallese: QLocale = ...
        Romansh: QLocale = ...
        Sango: QLocale = ...
        Ossetic: QLocale = ...
        SouthernSotho: QLocale = ...
        Tswana: QLocale = ...
        Sinhala: QLocale = ...
        Swati: QLocale = ...
        Sardinian: QLocale = ...
        Tongan: QLocale = ...
        Tahitian: QLocale = ...
        Nyanja: QLocale = ...
        Avaric: QLocale = ...
        Chamorro: QLocale = ...
        Chechen: QLocale = ...
        Church: QLocale = ...
        Chuvash: QLocale = ...
        Cree: QLocale = ...
        Haitian: QLocale = ...
        Herero: QLocale = ...
        HiriMotu: QLocale = ...
        Kanuri: QLocale = ...
        Komi: QLocale = ...
        Kongo: QLocale = ...
        Kwanyama: QLocale = ...
        Limburgish: QLocale = ...
        Luxembourgish: QLocale = ...
        Navaho: QLocale = ...
        Ndonga: QLocale = ...
        Ojibwa: QLocale = ...
        Pali: QLocale = ...
        Walloon: QLocale = ...
        Avestan: QLocale = ...
        Asturian: QLocale = ...
        Ngomba: QLocale = ...
        Kako: QLocale = ...
        Meta: QLocale = ...
        Ngiemboon: QLocale = ...
        Uighur: QLocale = ...
        Aragonese: QLocale = ...
        Akkadian: QLocale = ...
        AncientEgyptian: QLocale = ...
        AncientGreek: QLocale = ...
        Aramaic: QLocale = ...
        Balinese: QLocale = ...
        Bamun: QLocale = ...
        BatakToba: QLocale = ...
        Buginese: QLocale = ...
        Chakma: QLocale = ...
        Coptic: QLocale = ...
        Dogri: QLocale = ...
        Gothic: QLocale = ...
        Ingush: QLocale = ...
        Mandingo: QLocale = ...
        Manipuri: QLocale = ...
        OldIrish: QLocale = ...
        OldNorse: QLocale = ...
        OldPersian: QLocale = ...
        Pahlavi: QLocale = ...
        Phoenician: QLocale = ...
        Santali: QLocale = ...
        Saurashtra: QLocale = ...
        TaiDam: QLocale = ...
        Ugaritic: QLocale = ...
        Akoose: QLocale = ...
        Lakota: QLocale = ...
        StandardMoroccanTamazight: QLocale = ...
        Mapuche: QLocale = ...
        CentralKurdish: QLocale = ...
        LowerSorbian: QLocale = ...
        UpperSorbian: QLocale = ...
        Kenyang: QLocale = ...
        Mohawk: QLocale = ...
        Nko: QLocale = ...
        Prussian: QLocale = ...
        Kiche: QLocale = ...
        SouthernSami: QLocale = ...
        LuleSami: QLocale = ...
        InariSami: QLocale = ...
        SkoltSami: QLocale = ...
        Warlpiri: QLocale = ...
        Mende: QLocale = ...
        Lezghian: QLocale = ...
        Maithili: QLocale = ...
        AmericanSignLanguage: QLocale = ...
        Bhojpuri: QLocale = ...
        LiteraryChinese: QLocale = ...
        Mazanderani: QLocale = ...
        Newari: QLocale = ...
        NorthernLuri: QLocale = ...
        Palauan: QLocale = ...
        Papiamento: QLocale = ...
        TokelauLanguage: QLocale = ...
        TokPisin: QLocale = ...
        TuvaluLanguage: QLocale = ...
        Cantonese: QLocale = ...
        Osage: QLocale = ...
        Ido: QLocale = ...
        Lojban: QLocale = ...
        Sicilian: QLocale = ...
        SouthernKurdish: QLocale = ...
        WesternBalochi: QLocale = ...
        Cebuano: QLocale = ...
        Erzya: QLocale = ...
        Chickasaw: QLocale = ...
        Muscogee: QLocale = ...
        Silesian: QLocale = ...
        NigerianPidgin: QLocale = ...
        Bangla: QLocale = ...
        CentralAtlasTamazight: QLocale = ...
        Inupiaq: QLocale = ...
        Kalaallisut: QLocale = ...
        Kuanyama: QLocale = ...
        Kyrgyz: QLocale = ...
        Navajo: QLocale = ...
        Odia: QLocale = ...
        Uyghur: QLocale = ...
        Wolaytta: QLocale = ...

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qlocale.html#QLocale

        **QLocale::QLocale()**

        Constructs a QLocale object initialized with the default locale.

        If no default locale was set using **setDefault** (), this locale will
        be the same as the one returned by **system** ().

        **See also** **setDefault** ().
        """
        ...

    @typing.overload
    def __init__(self, name: str) -> None:
        """
        https://doc.qt.io/qt-6/qlocale.html#QLocale-1

        **QLocale::QLocale(const QString & name )**

        Constructs a QLocale object with the specified **name** , which has the
        format "language[_script][_territory][.codeset][@modifier]" or "C",
        where:

        * language is a lowercase, two-letter, ISO 639 language code (some
        three-letter codes are also recognized),
          * script is a capitalized,
        four-letter, ISO 15924 script code,
          * territory is an uppercase, two-
        letter, ISO 3166 territory code (some numeric codes are also
        recognized), and
          * codeset and modifier are ignored.

        The separator can be either underscore `'_'` (U+005F, "low line") or a
        dash `'-'` (U+002D, "hyphen-minus"). If QLocale has no data for the
        specified combination of language, script, and territory, then it uses
        the most suitable match it can find instead. If the string violates the
        locale format, or no suitable data can be found for the specified keys,
        the "C" locale is used instead.

        This constructor is much slower than QLocale(Language, Script,
        Territory) or QLocale(Language, Territory).

        **See also** **bcp47Name** () and **Matching combinations of language,
        script and territory** .
        """
        ...

    @typing.overload
    def __init__(
        self, language: "QLocale.Language", country: "QLocale.Country" = ...
    ) -> None:
        """
        https://doc.qt.io/qt-6/qlocale.html#QLocale-2

        **QLocale::QLocale(QLocale::Language language , QLocale::Territory
        territory )**

        Constructs a QLocale object for the specified **language** and
        **territory**.

        If there is more than one script in use for this combination, a likely
        script will be selected. If QLocale has no data for the specified
        **language** , the default locale is used. If QLocale has no data for
        the specified combination of **language** and **territory** , an
        alternative territory may be used instead.

        **See also** **setDefault** () and **Matching combinations of language,
        script and territory** .
        """
        ...

    @typing.overload
    def __init__(
        self,
        language: "QLocale.Language",
        script: "QLocale.Script",
        country: "QLocale.Country",
    ) -> None:
        """
        https://doc.qt.io/qt-6/qlocale.html#QLocale-3

        **QLocale::QLocale(QLocale::Language language , QLocale::Script script =
        AnyScript, QLocale::Territory territory = AnyTerritory)**

        Constructs a QLocale object for the specified **language** , **script**
        and **territory**.

        If QLocale does not have data for the given combination, it will find
        data for as good a match as it can. It falls back on the default locale
        if

        * **language** is `AnyLanguage` and no language can be inferred from
        **script** and **territory**
          * QLocale has no data for the language,
        either given as **language** or inferred as above.

        **See also** **setDefault** () and **Matching combinations of language,
        script and territory** .
        """
        ...

    @typing.overload
    def __init__(self, other: "QLocale") -> None:
        """
        https://doc.qt.io/qt-6/qlocale.html#QLocale-4

        **QLocale::QLocale(const QLocale & other )**

        Constructs a QLocale object as a copy of **other**.
        """
        ...

    @staticmethod
    def territoryToString(territory: "QLocale.Country") -> str:
        """
        https://doc.qt.io/qt-6/qlocale.html#territoryToString

        **[static, since 6.2] QString
        QLocale::territoryToString(QLocale::Territory territory )**

        Returns a **QString**  containing the name of **territory**.

        This function was introduced in Qt 6.2.

        **See also** **languageToString** (), **scriptToString** (),
        **territory** (), and **bcp47Name** ().
        """
        ...

    @staticmethod
    def codeToTerritory(territoryCode: str) -> "QLocale.Country":
        """
        https://doc.qt.io/qt-6/qlocale.html#codeToTerritory

        **[static, since 6.2] QLocale::Territory
        QLocale::codeToTerritory(QStringView territoryCode )**

        Returns the QLocale::Territory enum corresponding to the two-letter or
        three-digit **territoryCode** , as defined in the ISO 3166 standard.

        If the code is invalid or not known **QLocale::AnyTerritory**  is
        returned.

        This function was introduced in Qt 6.2.

        **See also** **territoryToCode** (), **codeToLanguage** (), and
        **codeToScript** ().
        """
        ...

    @staticmethod
    def territoryToCode(territory: "QLocale.Country") -> str:
        """
        https://doc.qt.io/qt-6/qlocale.html#territoryToCode

        **[static, since 6.2] QString
        QLocale::territoryToCode(QLocale::Territory territory )**

        Returns the two-letter territory code for **territory** , as defined in
        the ISO 3166 standard.

        **Note:** For `QLocale::AnyTerritory` an empty string is returned.

        This function was introduced in Qt 6.2.

        **See also** **codeToTerritory** (), **territory** (), **name** (),
        **bcp47Name** (), **languageToCode** (), and **scriptToCode** ().
        """
        ...

    def nativeTerritoryName(self) -> str:
        """
        https://doc.qt.io/qt-6/qlocale.html#nativeTerritoryName

        **[since 6.2] QString QLocale::nativeTerritoryName() const**

        Returns a native name of the territory for the locale. For example
        "España" for Spanish/Spain locale.

        This function was introduced in Qt 6.2.

        **See also** **nativeLanguageName** () and **territoryToString** ().
        """
        ...

    def territory(self) -> "QLocale.Country":
        """
        https://doc.qt.io/qt-6/qlocale.html#territory

        **[since 6.2] QLocale::Territory QLocale::territory() const**

        Returns the territory of this locale.

        This function was introduced in Qt 6.2.

        **See also** **language** (), **script** (), **territoryToString** (),
        and **bcp47Name** ().
        """
        ...

    @staticmethod
    def codeToScript(scriptCode: str) -> "QLocale.Script":
        """
        https://doc.qt.io/qt-6/qlocale.html#codeToScript

        **[static, since 6.1] QLocale::Script QLocale::codeToScript(QStringView
        scriptCode )**

        Returns the **QLocale::Script**  enum corresponding to the four-letter
        script **scriptCode** , as defined in the ISO 15924 standard.

        If the code is invalid or not known **QLocale::AnyScript**  is returned.

        This function was introduced in Qt 6.1.

        **See also** **scriptToCode** (), **codeToLanguage** (), and
        **codeToTerritory** ().
        """
        ...

    @staticmethod
    def scriptToCode(script: "QLocale.Script") -> str:
        """
        https://doc.qt.io/qt-6/qlocale.html#scriptToCode

        **[static, since 6.1] QString QLocale::scriptToCode(QLocale::Script
        script )**

        Returns the four-letter script code for **script** , as defined in the
        ISO 15924 standard.

        **Note:** For `QLocale::AnyScript` an empty string is returned.

        This function was introduced in Qt 6.1.

        **See also** **script** (), **name** (), **bcp47Name** (),
        **languageToCode** (), and **territoryToCode** ().
        """
        ...

    @staticmethod
    def codeToCountry(countryCode: str) -> "QLocale.Country":
        ...

    @staticmethod
    def countryToCode(country: "QLocale.Country") -> str:
        ...

    @staticmethod
    def codeToLanguage(languageCode: str) -> "QLocale.Language":
        """
        https://doc.qt.io/qt-6/qlocale.html#codeToLanguage

        **[static, since 6.1] QLocale::Language
        QLocale::codeToLanguage(QStringView languageCode )**

        Returns the **QLocale::Language**  enum corresponding to the two- or
        three-letter **languageCode** , as defined in the ISO 639 standards.

        If the code is invalid or not known **QLocale::AnyLanguage**  is
        returned.

        This function was introduced in Qt 6.1.

        **See also** **languageToCode** (), **codeToTerritory** (), and
        **codeToScript** ().
        """
        ...

    @staticmethod
    def languageToCode(language: "QLocale.Language") -> str:
        """
        https://doc.qt.io/qt-6/qlocale.html#languageToCode

        **[static, since 6.1] QString QLocale::languageToCode(QLocale::Language
        language )**

        Returns the two- or three-letter language code for **language** , as
        defined in the ISO 639 standards.

        **Note:** For `QLocale::C` the function returns `"C"`. For
        `QLocale::AnyLanguage` an empty string is returned.

        This function was introduced in Qt 6.1.

        **See also** **codeToLanguage** (), **language** (), **name** (),
        **bcp47Name** (), **territoryToCode** (), and **scriptToCode** ().
        """
        ...

    def collation(self) -> "QLocale":
        """
        https://doc.qt.io/qt-6/qlocale.html#collation

        **[since 5.13] QLocale QLocale::collation() const**

        Returns the locale to use for collation.

        The result is usually this locale; however, the system locale (which is
        commonly the default locale) will return the system collation locale.
        The result is suitable for passing to **QCollator** 's constructor.

        This function was introduced in Qt 5.13.

        **See also** **QCollator** .
        """
        ...

    def toULong(self, s: str) -> typing.Tuple[int, bool]:
        """
        https://doc.qt.io/qt-6/qlocale.html#toULong

        **[since 5.13] ulong QLocale::toULong(const QString & s , bool * ok =
        nullptr) const**

        Returns the unsigned long int represented by the localized string **s**.

        If the conversion fails the function returns 0.

        If **ok** is not `nullptr`, failure is reported by setting * **ok** to
        `false`, and success by setting * **ok** to `true`.

        This function ignores leading and trailing whitespace.

        This function was introduced in Qt 5.13.

        **See also** **toLong** (), **toInt** (), **toDouble** (), and
        **toString** ().
        """
        ...

    def toLong(self, s: str) -> typing.Tuple[int, bool]:
        """
        https://doc.qt.io/qt-6/qlocale.html#toLong

        **[since 5.13] long QLocale::toLong(const QString & s , bool * ok =
        nullptr) const**

        Returns the long int represented by the localized string **s**.

        If the conversion fails the function returns 0.

        If **ok** is not `nullptr`, failure is reported by setting * **ok** to
        `false`, and success by setting * **ok** to `true`.

        This function ignores leading and trailing whitespace.

        This function was introduced in Qt 5.13.

        **See also** **toInt** (), **toULong** (), **toDouble** (), and
        **toString** ().
        """
        ...

    def formattedDataSize(
        self, bytes: int, precision: int = ..., format: "QLocale.DataSizeFormat" = ...
    ) -> str:
        """
        https://doc.qt.io/qt-6/qlocale.html#formattedDataSize

        **[since 5.10] QString QLocale::formattedDataSize(qint64 bytes , int
        precision = 2, QLocale::DataSizeFormats format = DataSizeIecFormat)
        const**

        Converts a size in bytes to a human-readable localized string,
        comprising a number and a quantified unit. The quantifier is chosen such
        that the number is at least one, and as small as possible. For example
        if **bytes** is 16384, **precision** is 2, and **format** is
        **DataSizeIecFormat**  (the default), this function returns "16.00 KiB";
        for 1330409069609 bytes it returns "1.21 GiB"; and so on. If **format**
        is **DataSizeIecFormat**  or **DataSizeTraditionalFormat** , the given
        number of bytes is divided by a power of 1024, with result less than
        1024; for **DataSizeSIFormat** , it is divided by a power of 1000, with
        result less than 1000. `DataSizeIecFormat` uses the new IEC standard
        quantifiers Ki, Mi and so on, whereas `DataSizeSIFormat` uses the older
        SI quantifiers k, M, etc., and `DataSizeTraditionalFormat` abuses them.

        This function was introduced in Qt 5.10.
        """
        ...

    def swap(self, other: "QLocale") -> None:
        """
        https://doc.qt.io/qt-6/qlocale.html#swap

        **[since 5.6] void QLocale::swap(QLocale & other )**

        Swaps locale **other** with this locale. This operation is very fast and
        never fails.

        This function was introduced in Qt 5.6.
        """
        ...

    def __hash__(self) -> int:
        ...

    def createSeparatedList(self, list: typing.Iterable[str]) -> str:
        """
        https://doc.qt.io/qt-6/qlocale.html#createSeparatedList

        **QString QLocale::createSeparatedList(const QStringList & list )
        const**

        Returns a string that represents a join of a given **list** of strings
        with a separator defined by the locale.
        """
        ...

    def quoteString(self, str: str, style: "QLocale.QuotationStyle" = ...) -> str:
        """
        https://doc.qt.io/qt-6/qlocale.html#quoteString

        **QString QLocale::quoteString(const QString & str ,
        QLocale::QuotationStyle style = StandardQuotation) const**

        Returns **str** quoted according to the current locale using the given
        quotation **style**.
        """
        ...

    @staticmethod
    def matchingLocales(
        language: "QLocale.Language",
        script: "QLocale.Script",
        territory: "QLocale.Country",
    ) -> typing.List["QLocale"]:
        """
        https://doc.qt.io/qt-6/qlocale.html#matchingLocales

        **[static] QList<QLocale> QLocale::matchingLocales(QLocale::Language
        language , QLocale::Script script , QLocale::Territory territory )**

        Returns a list of valid locale objects that match the given **language**
        , **script** and **territory**.

        Getting a list of all locales: **QList** <**QLocale** > allLocales =
        QLocale::matchingLocales(**QLocale::AnyLanguage** ,
        **QLocale::AnyScript** , **QLocale::AnyTerritory** );

        Getting a list of locales suitable for Russia: **QList** <**QLocale** >
        locales = QLocale::matchingLocales(**QLocale::AnyLanguage** ,
        **QLocale::AnyScript** , **QLocale::Russia** );
        """
        ...

    @staticmethod
    def scriptToString(script: "QLocale.Script") -> str:
        """
        https://doc.qt.io/qt-6/qlocale.html#scriptToString

        **[static] QString QLocale::scriptToString(QLocale::Script script )**

        Returns a **QString**  containing the name of **script**.

        **See also** **languageToString** (), **territoryToString** (),
        **script** (), and **bcp47Name** ().
        """
        ...

    def uiLanguages(self) -> typing.List[str]:
        """
        https://doc.qt.io/qt-6/qlocale.html#uiLanguages

        **QStringList QLocale::uiLanguages() const**

        Returns an ordered list of locale names for translation purposes in
        preference order (like "en-Latn-US", "en-US", "en").

        The return value represents locale names that the user expects to see
        the UI translation in.

        Most like you do not need to use this function directly, but just pass
        the **QLocale**  object to the **QTranslator::load** () function.

        The first item in the list is the most preferred one.

        **See also** **QTranslator**  and **bcp47Name** ().
        """
        ...

    @typing.overload
    def toCurrencyString(
        self, a0: float, symbol: str = ..., precision: int = ...
    ) -> str:
        """
        https://doc.qt.io/qt-6/qlocale.html#toCurrencyString

        **QString QLocale::toCurrencyString(qlonglong value , const QString &
        symbol = QString()) const**

        Returns a localized string representation of **value** as a currency. If
        the **symbol** is provided it is used instead of the default currency
        symbol.

        **See also** **currencySymbol** ().
        """
        ...

    @typing.overload
    def toCurrencyString(self, value: int, symbol: str = ...) -> str:
        """
        https://doc.qt.io/qt-6/qlocale.html#toCurrencyString-1

        **QString QLocale::toCurrencyString(qulonglong value , const QString &
        symbol = QString()) const**

        This is an overloaded function.
        """
        ...

    def currencySymbol(self, format: "QLocale.CurrencySymbolFormat" = ...) -> str:
        """
        https://doc.qt.io/qt-6/qlocale.html#currencySymbol

        **QString QLocale::currencySymbol(QLocale::CurrencySymbolFormat format =
        CurrencySymbol) const**

        Returns a currency symbol according to the **format**.
        """
        ...

    def toLower(self, str: str) -> str:
        """
        https://doc.qt.io/qt-6/qlocale.html#toLower

        **QString QLocale::toLower(const QString & str ) const**

        Returns a lowercase copy of **str**.

        If Qt Core is using the ICU libraries, they will be used to perform the
        transformation according to the rules of the current locale. Otherwise
        the conversion may be done in a platform-dependent manner, with
        **QString::toLower** () as a generic fallback.

        **See also** **QString::toLower** ().
        """
        ...

    def toUpper(self, str: str) -> str:
        """
        https://doc.qt.io/qt-6/qlocale.html#toUpper

        **QString QLocale::toUpper(const QString & str ) const**

        Returns an uppercase copy of **str**.

        If Qt Core is using the ICU libraries, they will be used to perform the
        transformation according to the rules of the current locale. Otherwise
        the conversion may be done in a platform-dependent manner, with
        **QString::toUpper** () as a generic fallback.

        **See also** **QString::toUpper** ().
        """
        ...

    def weekdays(self) -> typing.List[Qt.DayOfWeek]:
        """
        https://doc.qt.io/qt-6/qlocale.html#weekdays

        **QList<Qt::DayOfWeek> QLocale::weekdays() const**

        Returns a list of days that are considered weekdays according to the
        current locale.
        """
        ...

    def firstDayOfWeek(self) -> Qt.DayOfWeek:
        """
        https://doc.qt.io/qt-6/qlocale.html#firstDayOfWeek

        **Qt::DayOfWeek QLocale::firstDayOfWeek() const**

        Returns the first day of the week according to the current locale.
        """
        ...

    def nativeCountryName(self) -> str:
        ...

    def nativeLanguageName(self) -> str:
        """
        https://doc.qt.io/qt-6/qlocale.html#nativeLanguageName

        **QString QLocale::nativeLanguageName() const**

        Returns a native name of the language for the locale. For example
        "Schwiizertüütsch" for Swiss-German locale.

        **See also** **nativeTerritoryName** () and **languageToString** ().
        """
        ...

    def bcp47Name(self) -> str:
        """
        https://doc.qt.io/qt-6/qlocale.html#bcp47Name

        **QString QLocale::bcp47Name() const**

        Returns the dash-separated language, script and country (and possibly
        other BCP47 fields) of this locale as a string.

        Unlike the **uiLanguages** () the returned value of the bcp47Name()
        represents the locale name of the **QLocale**  data but not the language
        the user-interface should be in.

        This function tries to conform the locale name to BCP47.

        **See also** **language** (), **territory** (), **script** (), and
        **uiLanguages** ().
        """
        ...

    def script(self) -> "QLocale.Script":
        """
        https://doc.qt.io/qt-6/qlocale.html#script

        **QLocale::Script QLocale::script() const**

        Returns the script of this locale.

        **See also** **language** (), **territory** (), **languageToString** (),
        **scriptToString** (), and **bcp47Name** ().
        """
        ...

    def textDirection(self) -> Qt.LayoutDirection:
        """
        https://doc.qt.io/qt-6/qlocale.html#textDirection

        **Qt::LayoutDirection QLocale::textDirection() const**

        Returns the text direction of the language.
        """
        ...

    def pmText(self) -> str:
        """
        https://doc.qt.io/qt-6/qlocale.html#pmText

        **QString QLocale::pmText() const**

        Returns the localized name of the "PM" suffix for times specified using
        the conventions of the 12-hour clock.

        **See also** **amText** ().
        """
        ...

    def amText(self) -> str:
        """
        https://doc.qt.io/qt-6/qlocale.html#amText

        **QString QLocale::amText() const**

        Returns the localized name of the "AM" suffix for times specified using
        the conventions of the 12-hour clock.

        **See also** **pmText** ().
        """
        ...

    def standaloneDayName(self, a0: int, format: "QLocale.FormatType" = ...) -> str:
        """
        https://doc.qt.io/qt-6/qlocale.html#standaloneDayName

        **QString QLocale::standaloneDayName(int day , QLocale::FormatType type
        = LongFormat) const**

        Returns the localized name of the **day** (where 1 represents Monday, 2
        represents Tuesday and so on) that is used as a standalone text, in the
        format specified by **type**.

        If the locale information does not specify the standalone day name then
        return value is the same as in **dayName** ().

        **See also** **dayName** () and **standaloneMonthName** ().
        """
        ...

    def standaloneMonthName(self, a0: int, format: "QLocale.FormatType" = ...) -> str:
        """
        https://doc.qt.io/qt-6/qlocale.html#standaloneMonthName

        **QString QLocale::standaloneMonthName(int month , QLocale::FormatType
        type = LongFormat) const**

        Returns the localized name of **month** that is used as a standalone
        text, in the format specified by **type**.

        If the locale information doesn't specify the standalone month name then
        return value is the same as in **monthName** ().

        **See also** **monthName** () and **standaloneDayName** ().
        """
        ...

    def positiveSign(self) -> str:
        """
        https://doc.qt.io/qt-6/qlocale.html#positiveSign

        **QString QLocale::positiveSign() const**

        Returns the positive sign character of this locale.

        **See also** **negativeSign** () and **toString** ().
        """
        ...

    def measurementSystem(self) -> "QLocale.MeasurementSystem":
        """
        https://doc.qt.io/qt-6/qlocale.html#measurementSystem

        **QLocale::MeasurementSystem QLocale::measurementSystem() const**

        Returns the measurement system for the locale.
        """
        ...

    def numberOptions(self) -> "QLocale.NumberOption":
        """
        https://doc.qt.io/qt-6/qlocale.html#numberOptions

        **QLocale::NumberOptions QLocale::numberOptions() const**

        Returns the options related to number conversions for this **QLocale**
        instance.

        By default, no options are set for the standard locales, except for the
        "C" locale, which has **OmitGroupSeparator**  set by default.

        **See also** **setNumberOptions** (), **toString** (),
        **groupSeparator** (), and **FloatingPointPrecisionOption** .
        """
        ...

    def setNumberOptions(self, options: "QLocale.NumberOption") -> None:
        """
        https://doc.qt.io/qt-6/qlocale.html#setNumberOptions

        **void QLocale::setNumberOptions(QLocale::NumberOptions options )**

        Sets the **options** related to number conversions for this **QLocale**
        instance.

        **See also** **numberOptions** () and **FloatingPointPrecisionOption** .
        """
        ...

    def dayName(self, a0: int, format: "QLocale.FormatType" = ...) -> str:
        """
        https://doc.qt.io/qt-6/qlocale.html#dayName

        **QString QLocale::dayName(int day , QLocale::FormatType type =
        LongFormat) const**

        Returns the localized name of the **day** (where 1 represents Monday, 2
        represents Tuesday and so on), in the format specified by **type**.

        For example, if the locale is `en_US` and **day** is 1, **LongFormat**
        will return `Monday`, **ShortFormat**  `Mon`, and **NarrowFormat**  `M`.

        **See also** **monthName** () and **standaloneDayName** ().
        """
        ...

    def monthName(self, a0: int, format: "QLocale.FormatType" = ...) -> str:
        """
        https://doc.qt.io/qt-6/qlocale.html#monthName

        **QString QLocale::monthName(int month , QLocale::FormatType type =
        LongFormat) const**

        Returns the localized name of **month** , in the format specified by
        **type**.

        For example, if the locale is `en_US` and **month** is 1, **LongFormat**
        will return `January`. **ShortFormat**  `Jan`, and **NarrowFormat**
        `J`.

        **See also** **dayName** () and **standaloneMonthName** ().
        """
        ...

    def exponential(self) -> str:
        """
        https://doc.qt.io/qt-6/qlocale.html#exponential

        **QString QLocale::exponential() const**

        Returns the exponential character of this locale, used to separate
        exponent from mantissa in some floating-point numeric representations.

        **See also** **toString** (double, char, int).
        """
        ...

    def negativeSign(self) -> str:
        """
        https://doc.qt.io/qt-6/qlocale.html#negativeSign

        **QString QLocale::negativeSign() const**

        Returns the negative sign character of this locale.

        **See also** **positiveSign** () and **toString** ().
        """
        ...

    def zeroDigit(self) -> str:
        """
        https://doc.qt.io/qt-6/qlocale.html#zeroDigit

        **QString QLocale::zeroDigit() const**

        Returns the zero digit character of this locale.

        **See also** **toString** ().
        """
        ...

    def percent(self) -> str:
        """
        https://doc.qt.io/qt-6/qlocale.html#percent

        **QString QLocale::percent() const**

        Returns the percent character of this locale.

        **See also** **toString** ().
        """
        ...

    def groupSeparator(self) -> str:
        """
        https://doc.qt.io/qt-6/qlocale.html#groupSeparator

        **QString QLocale::groupSeparator() const**

        Returns the group separator character of this locale.

        **See also** **decimalPoint** () and **toString** ().
        """
        ...

    def decimalPoint(self) -> str:
        """
        https://doc.qt.io/qt-6/qlocale.html#decimalPoint

        **QString QLocale::decimalPoint() const**

        Returns the decimal point character of this locale.

        **See also** **groupSeparator** () and **toString** ().
        """
        ...

    @typing.overload
    def toDateTime(self, string: str, format: "QLocale.FormatType" = ...) -> QDateTime:
        """
        https://doc.qt.io/qt-6/qlocale.html#toDateTime

        **QDateTime QLocale::toDateTime(const QString & string ,
        QLocale::FormatType format = LongFormat) const**

        Parses the date/time string given in **string** and returns the time.
        The format of the date/time string is chosen according to the **format**
        parameter (see **dateTimeFormat** ()).

        If the string could not be parsed, returns an invalid **QDateTime** .

        **See also** **dateTimeFormat** (), **toTime** (), **toDate** (), and
        **QDateTime::fromString** ().
        """
        ...

    @typing.overload
    def toDateTime(self, string: str, format: str) -> QDateTime:
        """
        https://doc.qt.io/qt-6/qlocale.html#toDateTime-1

        **QDateTime QLocale::toDateTime(const QString & string , const QString &
        format ) const**

        Parses the date/time string given in **string** and returns the time.
        See **QDateTime::fromString** () for information on the expressions that
        can be used with this function.

        **Note:** The month and day names used must be given in the user's local
        language.

        If the string could not be parsed, returns an invalid **QDateTime** . If
        the string can be parsed and represents an invalid date-time (e.g. in a
        gap skipped by a time-zone transition), an invalid **QDateTime**  is
        returned, whose toMSecsSinceEpoch() represents a near-by date-time that
        is valid. Passing that to fromMSecsSinceEpoch() will produce a valid
        date-time that isn't faithfully represented by the string parsed.

        **See also** **dateTimeFormat** (), **toTime** (), **toDate** (), and
        **QDateTime::fromString** ().
        """
        ...

    @typing.overload
    def toDateTime(
        self, string: str, format: "QLocale.FormatType", cal: QCalendar
    ) -> QDateTime:
        """
        https://doc.qt.io/qt-6/qlocale.html#toDateTime-2

        **[since 5.14] QDateTime QLocale::toDateTime(const QString & string ,
        QLocale::FormatType format , QCalendar cal ) const**

        This is an overloaded function.

        This function was introduced in Qt 5.14.
        """
        ...

    @typing.overload
    def toDateTime(self, string: str, format: str, cal: QCalendar) -> QDateTime:
        """
        https://doc.qt.io/qt-6/qlocale.html#toDateTime-3

        **[since 5.14] QDateTime QLocale::toDateTime(const QString & string ,
        const QString & format , QCalendar cal ) const**

        This is an overloaded function.

        This function was introduced in Qt 5.14.
        """
        ...

    @typing.overload
    def toTime(self, string: str, format: "QLocale.FormatType" = ...) -> QTime:
        """
        https://doc.qt.io/qt-6/qlocale.html#toTime

        **QTime QLocale::toTime(const QString & string , QLocale::FormatType
        format = LongFormat) const**

        Parses the time string given in **string** and returns the time. The
        format of the time string is chosen according to the **format**
        parameter (see **timeFormat** ()).

        If the time could not be parsed, returns an invalid time.

        **See also** **timeFormat** (), **toDate** (), **toDateTime** (), and
        **QTime::fromString** ().
        """
        ...

    @typing.overload
    def toTime(self, string: str, format: str) -> QTime:
        """
        https://doc.qt.io/qt-6/qlocale.html#toTime-1

        **QTime QLocale::toTime(const QString & string , const QString & format
        ) const**

        Parses the time string given in **string** and returns the time. See
        **QTime::fromString** () for information on what is a valid format
        string.

        If the time could not be parsed, returns an invalid time.

        **See also** **timeFormat** (), **toDate** (), **toDateTime** (), and
        **QTime::fromString** ().
        """
        ...

    @typing.overload
    def toDate(self, string: str, format: "QLocale.FormatType" = ...) -> QDate:
        """
        https://doc.qt.io/qt-6/qlocale.html#toDate

        **QDate QLocale::toDate(const QString & string , QLocale::FormatType
        format = LongFormat) const**

        Parses the date string given in **string** and returns the date. The
        format of the date string is chosen according to the **format**
        parameter (see **dateFormat** ()).

        If the date could not be parsed, returns an invalid date.

        **See also** **dateFormat** (), **toTime** (), **toDateTime** (), and
        **QDate::fromString** ().
        """
        ...

    @typing.overload
    def toDate(self, string: str, format: str) -> QDate:
        """
        https://doc.qt.io/qt-6/qlocale.html#toDate-1

        **QDate QLocale::toDate(const QString & string , const QString & format
        ) const**

        Parses the date string given in **string** and returns the date. See
        **QDate::fromString** () for information on the expressions that can be
        used with this function.

        This function searches month names and the names of the days of the week
        in the current locale.

        If the date could not be parsed, returns an invalid date.

        **See also** **dateFormat** (), **toTime** (), **toDateTime** (), and
        **QDate::fromString** ().
        """
        ...

    @typing.overload
    def toDate(
        self, string: str, format: "QLocale.FormatType", cal: QCalendar
    ) -> QDate:
        """
        https://doc.qt.io/qt-6/qlocale.html#toDate-2

        **[since 5.14] QDate QLocale::toDate(const QString & string ,
        QLocale::FormatType format , QCalendar cal ) const**

        This is an overloaded function.

        This function was introduced in Qt 5.14.
        """
        ...

    @typing.overload
    def toDate(self, string: str, format: str, cal: QCalendar) -> QDate:
        """
        https://doc.qt.io/qt-6/qlocale.html#toDate-3

        **[since 5.14] QDate QLocale::toDate(const QString & string , const
        QString & format , QCalendar cal ) const**

        This is an overloaded function.

        This function was introduced in Qt 5.14.
        """
        ...

    def dateTimeFormat(self, format: "QLocale.FormatType" = ...) -> str:
        """
        https://doc.qt.io/qt-6/qlocale.html#dateTimeFormat

        **QString QLocale::dateTimeFormat(QLocale::FormatType format =
        LongFormat) const**

        Returns the date time format used for the current locale.

        If **format** is **LongFormat** , the format will be elaborate,
        otherwise it will be short. For example, **LongFormat**  for the `en_US`
        locale is `dddd, MMMM d, yyyy h:mm:ss AP t`, **ShortFormat**  is `M/d/yy
        h:mm AP`.

        **See also** **QDateTime::toString** () and **QDateTime::fromString**
        ().
        """
        ...

    def timeFormat(self, format: "QLocale.FormatType" = ...) -> str:
        """
        https://doc.qt.io/qt-6/qlocale.html#timeFormat

        **QString QLocale::timeFormat(QLocale::FormatType format = LongFormat)
        const**

        Returns the time format used for the current locale.

        If **format** is **LongFormat** , the format will be elaborate,
        otherwise it will be short. For example, **LongFormat**  for the `en_US`
        locale is `h:mm:ss AP t`, **ShortFormat**  is `h:mm AP`.

        **See also** **QTime::toString** () and **QTime::fromString** ().
        """
        ...

    def dateFormat(self, format: "QLocale.FormatType" = ...) -> str:
        """
        https://doc.qt.io/qt-6/qlocale.html#dateFormat

        **QString QLocale::dateFormat(QLocale::FormatType format = LongFormat)
        const**

        Returns the date format used for the current locale.

        If **format** is **LongFormat** , the format will be elaborate,
        otherwise it will be short. For example, **LongFormat**  for the `en_US`
        locale is `dddd, MMMM d, yyyy`, **ShortFormat**  is `M/d/yy`.

        **See also** **QDate::toString** () and **QDate::fromString** ().
        """
        ...

    @staticmethod
    def system() -> "QLocale":
        """
        https://doc.qt.io/qt-6/qlocale.html#system

        **[static] QLocale QLocale::system()**

        Returns a **QLocale**  object initialized to the system locale.

        The system locale may use system-specific sources for locale data, where
        available, otherwise falling back on **QLocale** 's built-in database
        entry for the language, script and territory the system reports.

        For example, on Windows and Mac, this locale will use the
        decimal/grouping characters and date/time formats specified in the
        system configuration panel.

        **See also** **c** ().
        """
        ...

    @staticmethod
    def c() -> "QLocale":
        """
        https://doc.qt.io/qt-6/qlocale.html#c

        **[static] QLocale QLocale::c()**

        Returns a **QLocale**  object initialized to the "C" locale.

        This locale is based on en_US but with various quirks of its own, such
        as simplified number formatting and its own date formatting. It
        implements the POSIX standards that describe the behavior of standard
        library functions of the "C" programming language.

        Among other things, this means its collation order is based on the ASCII
        values of letters, so that (for case-sensitive sorting) all upper-case
        letters sort before any lower-case one (rather than each letter's upper-
        and lower-case forms sorting adjacent to one another, before the next
        letter's two forms).

        **See also** **system** ().
        """
        ...

    @staticmethod
    def setDefault(locale: "QLocale") -> None:
        """
        https://doc.qt.io/qt-6/qlocale.html#setDefault

        **[static] void QLocale::setDefault(const QLocale & locale )**

        Sets the global default locale to **locale**. These values are used when
        a **QLocale**  object is constructed with no arguments. If this function
        is not called, the system's locale is used.

        **Warning:** In a multithreaded application, the default locale should
        be set at application startup, before any non-GUI threads are created.

        **Warning:** This function is not **reentrant** .

        **See also** **system** () and **c** ().
        """
        ...

    @staticmethod
    def countryToString(country: "QLocale.Country") -> str:
        ...

    @staticmethod
    def languageToString(language: "QLocale.Language") -> str:
        """
        https://doc.qt.io/qt-6/qlocale.html#languageToString

        **[static] QString QLocale::languageToString(QLocale::Language language
        )**

        Returns a **QString**  containing the name of **language**.

        **See also** **territoryToString** (), **scriptToString** (), and
        **bcp47Name** ().
        """
        ...

    @typing.overload
    def toString(
        self,
        date: typing.Union[QDate, datetime.date],
        format: "QLocale.FormatType",
        cal: QCalendar,
    ) -> str:
        """
        https://doc.qt.io/qt-6/qlocale.html#toString

        **QString QLocale::toString(qlonglong i ) const**

        Returns a localized string representation of **i**.

        **See also** **toLongLong** (), **numberOptions** (), **zeroDigit** (),
        and **positiveSign** ().
        """
        ...

    @typing.overload
    def toString(
        self, date: typing.Union[QDate, datetime.date], formatStr: str, cal: QCalendar
    ) -> str:
        """
        https://doc.qt.io/qt-6/qlocale.html#toString-1

        **QString QLocale::toString(qulonglong i ) const**

        This is an overloaded function.

        **See also** **toULongLong** (), **numberOptions** (), **zeroDigit** (),
        and **positiveSign** ().
        """
        ...

    @typing.overload
    def toString(
        self,
        date: typing.Union[QDate, datetime.date],
        format: "QLocale.FormatType" = ...,
    ) -> str:
        """
        https://doc.qt.io/qt-6/qlocale.html#toString-2

        **QString QLocale::toString(long i ) const**

        This is an overloaded function.

        **See also** **toLong** ().
        """
        ...

    @typing.overload
    def toString(self, date: typing.Union[QDate, datetime.date], formatStr: str) -> str:
        """
        https://doc.qt.io/qt-6/qlocale.html#toString-3

        **QString QLocale::toString(ulong i ) const**

        This is an overloaded function.

        **See also** **toULong** ().
        """
        ...

    @typing.overload
    def toString(
        self,
        time: typing.Union[QTime, datetime.time],
        format: "QLocale.FormatType" = ...,
    ) -> str:
        """
        https://doc.qt.io/qt-6/qlocale.html#toString-4

        **QString QLocale::toString(short i ) const**

        This is an overloaded function.

        **See also** **toShort** ().
        """
        ...

    @typing.overload
    def toString(self, time: typing.Union[QTime, datetime.time], formatStr: str) -> str:
        """
        https://doc.qt.io/qt-6/qlocale.html#toString-5

        **QString QLocale::toString(ushort i ) const**

        This is an overloaded function.

        **See also** **toUShort** ().
        """
        ...

    @typing.overload
    def toString(self, i: float, format: str = ..., precision: int = ...) -> str:
        """
        https://doc.qt.io/qt-6/qlocale.html#toString-6

        **QString QLocale::toString(int i ) const**

        This is an overloaded function.

        **See also** **toInt** ().
        """
        ...

    @typing.overload
    def toString(
        self,
        dateTime: typing.Union[QDateTime, datetime.datetime],
        format: "QLocale.FormatType",
        cal: QCalendar,
    ) -> str:
        """
        https://doc.qt.io/qt-6/qlocale.html#toString-7

        **QString QLocale::toString(uint i ) const**

        This is an overloaded function.

        **See also** **toUInt** ().
        """
        ...

    @typing.overload
    def toString(
        self, dateTime: typing.Union[QDateTime, datetime.datetime], format: str
    ) -> str:
        """
        https://doc.qt.io/qt-6/qlocale.html#toString-8

        **QString QLocale::toString(double f , char format = 'g', int precision
        = 6) const**

        This is an overloaded function.

        Returns a string representing the floating-point number **f**.

        The form of the representation is controlled by the **format** and
        **precision** parameters.

        The **format** defaults to `'g'`. It can be any of the following:

        FormatMeaning
        `'e'`format as [-]9.9e[+|-]999
        `'E'`format as
        [-]9.9E[+|-]999
        `'f'`format as [-]9.9
        `'g'`use `'e'` or `'f'`
        format, whichever is more concise
        `'G'`use `'E'` or `'f'` format,
        whichever is more concise

        For the `'e'`, `'E'`, and `'f'` formats, the **precision** represents
        the number of digits **after** the decimal point. For the `'g'` and
        `'G'` formats, the **precision** represents the maximum number of
        significant digits (trailing zeroes are omitted). The special
        **precision** value **QLocale::FloatingPointShortest**  selects the
        shortest representation that, when read as a number, gets back the
        original floating-point value. Aside from that, any negative
        **precision** is ignored in favor of the default, 6.

        For the `'e'`, `'f'` and `'g'` formats, positive infinity is represented
        as "inf", negative infinity as "-inf" and floating-point NaN (not-a-
        number) values are represented as "nan". For the `'E'` and `'G'`
        formats, "INF" and "NAN" are used instead. This does not vary with
        locale.

        **See also** **toDouble** (), **numberOptions** (), **exponential** (),
        **decimalPoint** (), **zeroDigit** (), **positiveSign** (), **percent**
        (), **toCurrencyString** (), **formattedDataSize** (), and
        **QLocale::FloatingPointPrecisionOption** .
        """
        ...

    @typing.overload
    def toString(
        self,
        dateTime: typing.Union[QDateTime, datetime.datetime],
        formatStr: str,
        cal: QCalendar,
    ) -> str:
        """
        https://doc.qt.io/qt-6/qlocale.html#toString-9

        **QString QLocale::toString(float f , char format = 'g', int precision =
        6) const**

        This is an overloaded function.

        Returns a string representing the floating-point number **f**.

        The **format** and **precision** have the same meanings as described in
        **toString** (double, char, int).

        **See also** **toFloat** (), **toDouble** (), **numberOptions** (),
        **exponential** (), **decimalPoint** (), **zeroDigit** (),
        **positiveSign** (), **percent** (), **toCurrencyString** (),
        **formattedDataSize** (), and **QLocale::FloatingPointPrecisionOption**
        .
        """
        ...

    @typing.overload
    def toString(
        self,
        dateTime: typing.Union[QDateTime, datetime.datetime],
        format: "QLocale.FormatType" = ...,
    ) -> str:
        """
        https://doc.qt.io/qt-6/qlocale.html#toString-10

        **QString QLocale::toString(QDate date , const QString & format )
        const**

        Returns a localized string representation of the given **date** in the
        specified **format**. If **format** is an empty string, an empty string
        is returned.

        **See also** **QDate::toString** ().
        """
        ...

    @typing.overload
    def toString(self, i: int) -> str:
        """
        https://doc.qt.io/qt-6/qlocale.html#toString

        **QString QLocale::toString(qlonglong i ) const**

        Returns a localized string representation of **i**.

        **See also** **toLongLong** (), **numberOptions** (), **zeroDigit** (),
        and **positiveSign** ().
        """
        ...

    def toDouble(self, s: str) -> typing.Tuple[float, bool]:
        """
        https://doc.qt.io/qt-6/qlocale.html#toDouble

        **double QLocale::toDouble(const QString & s , bool * ok = nullptr)
        const**

        Returns the double represented by the localized string **s**.

        Returns an infinity if the conversion overflows or 0.0 if the conversion
        fails for any other reason (e.g. underflow).

        If **ok** is not `nullptr`, failure is reported by setting * **ok** to
        `false`, and success by setting * **ok** to `true`.

        This function does not fall back to the 'C' locale if the string cannot
        be interpreted in this locale.

        bool ok;
            double d;

            **QLocale**  c(**QLocale** ::C);
            d =
        c.toDouble("1234.56", &ok);  // ok == true,  d == 1234.56
            d =
        c.toDouble("1,234.56", &ok); // ok == true,  d == 1234.56
            d =
        c.toDouble("1234,56", &ok);  // ok == false, d == 0

            **QLocale**
        german(**QLocale** ::German);
            d = german.toDouble("1234,56", &ok);
        // ok == true,  d == 1234.56
            d = german.toDouble("1.234,56", &ok);
        // ok == true,  d == 1234.56
            d = german.toDouble("1234.56", &ok);
        // ok == false, d == 0

            d = german.toDouble("1.234", &ok);    //
        ok == true,  d == 1234.0

        Notice that the last conversion returns 1234.0, because '.' is the
        thousands group separator in the German locale.

        This function ignores leading and trailing whitespace.

        **See also** **toFloat** (), **toInt** (), and **toString** ().
        """
        ...

    def toFloat(self, s: str) -> typing.Tuple[float, bool]:
        """
        https://doc.qt.io/qt-6/qlocale.html#toFloat

        **float QLocale::toFloat(const QString & s , bool * ok = nullptr)
        const**

        Returns the float represented by the localized string **s**.

        Returns an infinity if the conversion overflows or 0.0 if the conversion
        fails for any other reason (e.g. underflow).

        If **ok** is not `nullptr`, failure is reported by setting * **ok** to
        `false`, and success by setting * **ok** to `true`.

        This function does not fall back to the 'C' locale if the string cannot
        be interpreted in this locale.

        This function ignores leading and trailing whitespace.

        **See also** **toDouble** (), **toInt** (), and **toString** ().
        """
        ...

    def toULongLong(self, s: str) -> typing.Tuple[int, bool]:
        """
        https://doc.qt.io/qt-6/qlocale.html#toULongLong

        **qulonglong QLocale::toULongLong(const QString & s , bool * ok =
        nullptr) const**

        Returns the unsigned long long int represented by the localized string
        **s**.

        If the conversion fails the function returns 0.

        If **ok** is not `nullptr`, failure is reported by setting * **ok** to
        `false`, and success by setting * **ok** to `true`.

        This function ignores leading and trailing whitespace.

        **See also** **toLongLong** (), **toInt** (), **toDouble** (), and
        **toString** ().
        """
        ...

    def toLongLong(self, s: str) -> typing.Tuple[int, bool]:
        """
        https://doc.qt.io/qt-6/qlocale.html#toLongLong

        **qlonglong QLocale::toLongLong(const QString & s , bool * ok = nullptr)
        const**

        Returns the long long int represented by the localized string **s**.

        If the conversion fails the function returns 0.

        If **ok** is not `nullptr`, failure is reported by setting * **ok** to
        `false`, and success by setting * **ok** to `true`.

        This function ignores leading and trailing whitespace.

        **See also** **toInt** (), **toULongLong** (), **toDouble** (), and
        **toString** ().
        """
        ...

    def toUInt(self, s: str) -> typing.Tuple[int, bool]:
        """
        https://doc.qt.io/qt-6/qlocale.html#toUInt

        **uint QLocale::toUInt(const QString & s , bool * ok = nullptr) const**

        Returns the unsigned int represented by the localized string **s**.

        If the conversion fails the function returns 0.

        If **ok** is not `nullptr`, failure is reported by setting * **ok** to
        `false`, and success by setting * **ok** to `true`.

        This function ignores leading and trailing whitespace.

        **See also** **toInt** () and **toString** ().
        """
        ...

    def toInt(self, s: str) -> typing.Tuple[int, bool]:
        """
        https://doc.qt.io/qt-6/qlocale.html#toInt

        **int QLocale::toInt(const QString & s , bool * ok = nullptr) const**

        Returns the int represented by the localized string **s**.

        If the conversion fails the function returns 0.

        If **ok** is not `nullptr`, failure is reported by setting * **ok** to
        `false`, and success by setting * **ok** to `true`.

        This function ignores leading and trailing whitespace.

        **See also** **toUInt** () and **toString** ().
        """
        ...

    def toUShort(self, s: str) -> typing.Tuple[int, bool]:
        """
        https://doc.qt.io/qt-6/qlocale.html#toUShort

        **ushort QLocale::toUShort(const QString & s , bool * ok = nullptr)
        const**

        Returns the unsigned short int represented by the localized string
        **s**.

        If the conversion fails the function returns 0.

        If **ok** is not `nullptr`, failure is reported by setting * **ok** to
        `false`, and success by setting * **ok** to `true`.

        This function ignores leading and trailing whitespace.

        **See also** **toShort** () and **toString** ().
        """
        ...

    def toShort(self, s: str) -> typing.Tuple[int, bool]:
        """
        https://doc.qt.io/qt-6/qlocale.html#toShort

        **short QLocale::toShort(const QString & s , bool * ok = nullptr)
        const**

        Returns the short int represented by the localized string **s**.

        If the conversion fails the function returns 0.

        If **ok** is not `nullptr`, failure is reported by setting * **ok** to
        `false`, and success by setting * **ok** to `true`.

        This function ignores leading and trailing whitespace.

        **See also** **toUShort** () and **toString** ().
        """
        ...

    def name(self) -> str:
        """
        https://doc.qt.io/qt-6/qlocale.html#name

        **QString QLocale::name() const**

        Returns the language and country of this locale as a string of the form
        "language_country", where language is a lowercase, two-letter ISO 639
        language code, and country is an uppercase, two- or three-letter ISO
        3166 country code.

        Note that even if **QLocale**  object was constructed with an explicit
        script, name() will not contain it for compatibility reasons. Use
        **bcp47Name** () instead if you need a full locale name.

        **See also** **QLocale** (), **language** (), **script** (),
        **territory** (), and **bcp47Name** ().
        """
        ...

    def country(self) -> "QLocale.Country":
        ...

    def language(self) -> "QLocale.Language":
        """
        https://doc.qt.io/qt-6/qlocale.html#language

        **QLocale::Language QLocale::language() const**

        Returns the language of this locale.

        **See also** **script** (), **territory** (), **languageToString** (),
        and **bcp47Name** ().
        """
        ...
