"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import enum
import typing
import PyQt6.sip
from PyQt6.QtCore import *
import enum


class QLockFile(PyQt6.sip.simplewrapper):
    """
    https://doc.qt.io/qt-6/qlockfile.html

    **Detailed Description**

    A lock file can be used to prevent multiple processes from accessing
    concurrently the same resource. For instance, a configuration file on disk,
    or a socket, a port, a region of shared memory...

    Serialization is only guaranteed if all processes that access the shared
    resource use QLockFile, with the same file path.

    QLockFile supports two use cases: to protect a resource for a short-term
    operation (e.g. verifying if a configuration file has changed before saving
    new settings), and for long-lived protection of a resource (e.g. a document
    opened by a user in an editor) for an indefinite amount of time.

    When protecting for a short-term operation, it is acceptable to call
    **lock** () and wait until any running operation finishes. When protecting a
    resource over a long time, however, the application should always call
    **setStaleLockTime** (0) and then **tryLock** () with a short timeout, in
    order to warn the user that the resource is locked.

    If the process holding the lock crashes, the lock file stays on disk and can
    prevent any other process from accessing the shared resource, ever. For this
    reason, QLockFile tries to detect such a "stale" lock file, based on the
    process ID written into the file. To cover the situation that the process ID
    got reused meanwhile, the current process name is compared to the name of
    the process that corresponds to the process ID from the lock file. If the
    process names differ, the lock file is considered stale. Additionally, the
    last modification time of the lock file (30s by default, for the use case of
    a short-lived operation) is taken into account. If the lock file is found to
    be stale, it will be deleted.

    For the use case of protecting a resource over a long time, you should
    therefore call **setStaleLockTime** (0), and when **tryLock** () returns
    **LockFailedError** , inform the user that the document is locked, possibly
    using **getLockInfo** () for more details.

    **Note:** On Windows, this class has problems detecting a stale lock if the
    machine's hostname contains characters outside the US-ASCII character set.
    """

    class LockError(enum.Enum):
        NoError: QLockFile = ...
        LockFailedError: QLockFile = ...
        PermissionError: QLockFile = ...
        UnknownError: QLockFile = ...

    def __init__(self, fileName: str) -> None:
        """
        https://doc.qt.io/qt-6/qlockfile.html#QLockFile

        **QLockFile::QLockFile(const QString & fileName )**

        Constructs a new lock file object. The object is created in an unlocked
        state. When calling **lock** () or **tryLock** (), a lock file named
        **fileName** will be created, if it doesn't already exist.

        **See also** **lock** () and **unlock** ().
        """
        ...

    def fileName(self) -> str:
        """
        https://doc.qt.io/qt-6/qlockfile.html#fileName

        **QString QLockFile::fileName() const**

        Returns the file name of the lock file
        """
        ...

    def error(self) -> "QLockFile.LockError":
        """
        https://doc.qt.io/qt-6/qlockfile.html#error

        **QLockFile::LockError QLockFile::error() const**

        Returns the lock file error status.

        If **tryLock** () returns `false`, this function can be called to find
        out the reason why the locking failed.
        """
        ...

    def removeStaleLockFile(self) -> bool:
        """
        https://doc.qt.io/qt-6/qlockfile.html#removeStaleLockFile

        **bool QLockFile::removeStaleLockFile()**

        Attempts to forcefully remove an existing lock file.

        Calling this is not recommended when protecting a short-lived operation:
        **QLockFile**  already takes care of removing lock files after they are
        older than **staleLockTime** ().

        This method should only be called when protecting a resource for a long
        time, i.e. with **staleLockTime** (0), and after **tryLock** () returned
        **LockFailedError** , and the user agreed on removing the lock file.

        Returns `true` on success, false if the lock file couldn't be removed.
        This happens on Windows, when the application owning the lock is still
        running.
        """
        ...

    def getLockInfo(self) -> typing.Tuple[bool, int, str, str]:
        """
        https://doc.qt.io/qt-6/qlockfile.html#getLockInfo

        **bool QLockFile::getLockInfo(qint64 * pid , QString * hostname ,
        QString * appname ) const**

        Retrieves information about the current owner of the lock file.

        If **tryLock** () returns `false`, and **error** () returns
        **LockFailedError** , this function can be called to find out more
        information about the existing lock file:

        * the PID of the application (returned in **pid** )
          * the **hostname**
        it's running on (useful in case of networked filesystems),
          * the name
        of the application which created it (returned in **appname** ),

        Note that **tryLock** () automatically deleted the file if there is no
        running application with this PID, so **LockFailedError**  can only
        happen if there is an application with this PID (it could be unrelated
        though).

        This can be used to inform users about the existing lock file and give
        them the choice to delete it. After removing the file using
        **removeStaleLockFile** (), the application can call **tryLock** ()
        again.

        This function returns `true` if the information could be successfully
        retrieved, false if the lock file doesn't exist or doesn't contain the
        expected data. This can happen if the lock file was deleted between the
        time where **tryLock** () failed and the call to this function. Simply
        call **tryLock** () again if this happens.
        """
        ...

    def isLocked(self) -> bool:
        """
        https://doc.qt.io/qt-6/qlockfile.html#isLocked

        **bool QLockFile::isLocked() const**

        Returns `true` if the lock was acquired by this **QLockFile**  instance,
        otherwise returns `false`.

        **See also** **lock** (), **unlock** (), and **tryLock** ().
        """
        ...

    def staleLockTime(self) -> int:
        """
        https://doc.qt.io/qt-6/qlockfile.html#staleLockTime

        **int QLockFile::staleLockTime() const**

        Returns the time in milliseconds after which a lock file is considered
        stale.

        **See also** **setStaleLockTime** ().
        """
        ...

    def setStaleLockTime(self, a0: int) -> None:
        """
        https://doc.qt.io/qt-6/qlockfile.html#setStaleLockTime

        **void QLockFile::setStaleLockTime(int staleLockTime )**

        Sets **staleLockTime** to be the time in milliseconds after which a lock
        file is considered stale. The default value is 30000, i.e. 30 seconds.
        If your application typically keeps the file locked for more than 30
        seconds (for instance while saving megabytes of data for 2 minutes), you
        should set a bigger value using setStaleLockTime().

        The value of **staleLockTime** is used by **lock** () and **tryLock** ()
        in order to determine when an existing lock file is considered stale,
        i.e. left over by a crashed process. This is useful for the case where
        the PID got reused meanwhile, so one way to detect a stale lock file is
        by the fact that it has been around for a long time.

        **See also** **staleLockTime** ().
        """
        ...

    def unlock(self) -> None:
        """
        https://doc.qt.io/qt-6/qlockfile.html#unlock

        **void QLockFile::unlock()**

        Releases the lock, by deleting the lock file.

        Calling unlock() without locking the file first, does nothing.

        **See also** **lock** () and **tryLock** ().
        """
        ...

    def tryLock(self, timeout: int = ...) -> bool:
        """
        https://doc.qt.io/qt-6/qlockfile.html#tryLock

        **bool QLockFile::tryLock(int timeout = 0)**

        Attempts to create the lock file. This function returns `true` if the
        lock was obtained; otherwise it returns `false`. If another process (or
        another thread) has created the lock file already, this function will
        wait for at most **timeout** milliseconds for the lock file to become
        available.

        Note: Passing a negative number as the **timeout** is equivalent to
        calling **lock** (), i.e. this function will wait forever until the lock
        file can be locked if **timeout** is negative.

        If the lock was obtained, it must be released with **unlock** () before
        another process (or thread) can successfully lock it.

        Calling this function multiple times on the same lock from the same
        thread without unlocking first is not allowed, this function will
        **always** return false when attempting to lock the file recursively.

        **See also** **lock** () and **unlock** ().
        """
        ...

    def lock(self) -> bool:
        """
        https://doc.qt.io/qt-6/qlockfile.html#lock

        **bool QLockFile::lock()**

        Creates the lock file.

        If another process (or another thread) has created the lock file
        already, this function will block until that process (or thread)
        releases it.

        Calling this function multiple times on the same lock from the same
        thread without unlocking first is not allowed. This function will
        **dead-lock** when the file is locked recursively.

        Returns `true` if the lock was acquired, false if it could not be
        acquired due to an unrecoverable error, such as no permissions in the
        parent directory.

        **See also** **unlock** () and **tryLock** ().
        """
        ...
