"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import PyQt6.sip
from PyQt6.QtCore import *


class QLoggingCategory(PyQt6.sip.simplewrapper):
    """
    https://doc.qt.io/qt-6/qloggingcategory.html

    **Detailed Description**

    QLoggingCategory represents a certain logging category - identified by a
    string - at runtime. A category can be configured to enable or disable
    logging of messages per message type.

    To check whether a message type is enabled or not, use one of these methods:
    **isDebugEnabled** (), **isInfoEnabled** (), **isWarningEnabled** (), and
    **isCriticalEnabled** ().

    All objects are meant to be configured by a common registry, as described in
    **Configuring Categories** . Different objects can also represent the same
    category. Therefore, it's **not** recommended to export objects across
    module boundaries, to manipulate the objects directly, or to inherit from
    QLoggingCategory.

    **Creating Category Objects**

    The **Q_DECLARE_LOGGING_CATEGORY** () and **Q_LOGGING_CATEGORY** () macros
    conveniently declare and create QLoggingCategory objects:

    // in a header
        Q_DECLARE_LOGGING_CATEGORY(driverUsb)

        // in one
    source file
        Q_LOGGING_CATEGORY(driverUsb, "driver.usb")

    Category names are free text; to configure categories using **Logging
    Rules** , their names should follow this convention:

    * Use letters and numbers only.
      * Use dots to further structure categories
    into common areas.
      * Avoid the category names: `debug`, `info`, `warning`,
    and `critical`.
      * Category names with the `qt` prefix are solely reserved
    for Qt modules.

    QLoggingCategory objects that are implicitly defined by
    **Q_LOGGING_CATEGORY** () are created on first use, in a thread-safe manner.

    **Checking Category Configuration**

    QLoggingCategory provides **isDebugEnabled** (), **isInfoEnabled** (),
    **isWarningEnabled** (), **isCriticalEnabled** (), as well as **isEnabled**
    () to check whether messages for the given message type should be logged.

    The **qCDebug** (), **qCWarning** (), and **qCCritical** () macros prevent
    arguments from being evaluated if the respective message types are not
    enabled for the category, so explicit checking is not needed:

    // usbEntries() will only be called if driverUsb category is enabled
    qCDebug(driverUsb) << "devices: " << usbEntries();

    **Default Category Configuration**

    Both the QLoggingCategory constructor and the **Q_LOGGING_CATEGORY** ()
    macro accept an optional **QtMsgType**  argument, which disables all message
    types with a lower severity. That is, a category declared with

    Q_LOGGING_CATEGORY(driverUsbEvents, "driver.usb.events", **QtWarningMsg** )

    logs messages of type `QtWarningMsg`, `QtCriticalMsg`, `QtFatalMsg`, but
    ignores messages of type `QtDebugMsg` and `QtInfoMsg`.

    If no argument is passed, all messages are logged. Only Qt internal
    categories which start with `qt` are handled differently: For these, only
    messages of type `QtInfoMsg`, `QtWarningMsg`, and `QtCriticalMsg` are logged
    by default.

    **Note:** Logging categories are not affected by your C++ build
    configuration. That is, whether messages are printed does not change
    depending on whether the code is compiled with debug symbols ('Debug
    Build'), optimizations ('Release Build'), or some other combination.

    **Configuring Categories**

    You can override the default configuration for categories either by setting
    logging rules, or by installing a custom filter.

    **Logging Rules**

    Logging rules let you enable or disable logging for categories in a flexible
    way. Rules are specified in text, where every line must have the format:

    <category>[.<type>] = true|false

    `<category>` is the name of the category, potentially with `*` as a wildcard
    symbol for the first or last character; or at both positions. The optional
    `<type>` must be `debug`, `info`, `warning`, or `critical`. Lines that don't
    fit this scheme are ignored.

    Rules are evaluated in text order, from first to last. That is, if two rules
    apply to a category/type, the rule that comes later is applied.

    Rules can be set via **setFilterRules** ():

    QLoggingCategory::setFilterRules("*.debug=false\\n"
    "driver.usb.debug=true");

    Logging rules are automatically loaded from the `[Rules]` section in a
    logging configuration file. These configuration files are looked up in the
    QtProject configuration directory, or explicitly set in a `QT_LOGGING_CONF`
    environment variable:

    [Rules]
            *.debug=false
            driver.usb.debug=true

    Logging rules can also be specified in a `QT_LOGGING_RULES` environment
    variable; multiple rules can also be separated by semicolons:

    QT_LOGGING_RULES="*.debug=false;driver.usb.debug=true"

    Rules set by **setFilterRules** () take precedence over rules specified in
    the QtProject configuration directory. In turn, these rules can be
    overwritten by those from the configuration file specified by
    `QT_LOGGING_CONF`, and those set by `QT_LOGGING_RULES`.

    The order of evaluation is as follows:

    1. [**QLibraryInfo::DataPath** ]/qtlogging.ini
      2. QtProject/qtlogging.ini
    3. **setFilterRules** ()
      4. `QT_LOGGING_CONF`
      5. `QT_LOGGING_RULES`

    The `QtProject/qtlogging.ini` file is looked up in all directories returned
    by **QStandardPaths::GenericConfigLocation** .

    Set the `QT_LOGGING_DEBUG` environment variable to find out where your
    logging rules are loaded from.

    **Installing a Custom Filter**

    As a lower-level alternative to the text rules, you can also implement a
    custom filter via **installFilter** (). All filter rules are ignored in this
    case.

    **Printing the Category**

    Use the `%{category}` placeholder to print the category in the default
    message handler:

    **qSetMessagePattern** ("%{category} %{message}");
    """

    def __init__(self, category: str, severityLevel: QtMsgType = ...) -> None:
        """
        https://doc.qt.io/qt-6/qloggingcategory.html#QLoggingCategory-1

        **[since 5.4] QLoggingCategory::QLoggingCategory(const char * category ,
        QtMsgType enableForLevel = QtDebugMsg)**

        Constructs a QLoggingCategory object with the provided **category**
        name, and enables all messages with types at least as verbose as
        **enableForLevel** , which defaults to **QtDebugMsg**  (which enables
        all categories).

        If **category** is `nullptr`, the category name `"default"` is used.

        **Note:** **category** must be kept valid during the lifetime of this
        object. Using a string literal for it is the usual way to achieve this.

        This function was introduced in Qt 5.4.
        """
        ...

    @staticmethod
    def setFilterRules(rules: str) -> None:
        """
        https://doc.qt.io/qt-6/qloggingcategory.html#setFilterRules

        **[static] void QLoggingCategory::setFilterRules(const QString & rules
        )**

        Configures which categories and message types should be enabled through
        a set of **rules**.

        Example:

        QLoggingCategory::setFilterRules(**QStringLiteral**
        ("driver.usb.debug=true"));

        **Note:** The rules might be ignored if a custom category filter is
        installed with **installFilter** (), or if the user has defined the
        `QT_LOGGING_CONF` or the `QT_LOGGING_RULES` environment variable.
        """
        ...

    @staticmethod
    def defaultCategory() -> "QLoggingCategory":
        """
        https://doc.qt.io/qt-6/qloggingcategory.html#defaultCategory

        **[static] QLoggingCategory *QLoggingCategory::defaultCategory()**

        Returns a pointer to the global category `"default"` that is used, for
        example, by **qDebug** (), **qInfo** (), **qWarning** (), **qCritical**
        (), or **qFatal** ().

        **Note:** The pointer returned may be null during destruction of static
        objects. Also, don't `delete` this pointer, as ownership of the category
        isn't transferred.
        """
        ...

    def __call__(self) -> "QLoggingCategory":
        ...

    def categoryName(self) -> str:
        """
        https://doc.qt.io/qt-6/qloggingcategory.html#categoryName

        **const char *QLoggingCategory::categoryName() const**

        Returns the name of the category.
        """
        ...

    def isCriticalEnabled(self) -> bool:
        """
        https://doc.qt.io/qt-6/qloggingcategory.html#isCriticalEnabled

        **bool QLoggingCategory::isCriticalEnabled() const**

        Returns `true` if critical messages should be shown for this category;
        `false` otherwise.

        **Note:** The **qCCritical** () macro already does this check before
        executing any code. However, calling this method may be useful to avoid
        the expensive generation of data for debug output only.
        """
        ...

    def isWarningEnabled(self) -> bool:
        """
        https://doc.qt.io/qt-6/qloggingcategory.html#isWarningEnabled

        **bool QLoggingCategory::isWarningEnabled() const**

        Returns `true` if warning messages should be shown for this category;
        `false` otherwise.

        **Note:** The **qCWarning** () macro already does this check before
        executing any code. However, calling this method may be useful to avoid
        the expensive generation of data for debug output only.
        """
        ...

    def isInfoEnabled(self) -> bool:
        """
        https://doc.qt.io/qt-6/qloggingcategory.html#isInfoEnabled

        **[since 5.5] bool QLoggingCategory::isInfoEnabled() const**

        Returns `true` if informational messages should be shown for this
        category; `false` otherwise.

        **Note:** The **qCInfo** () macro already does this check before
        executing any code. However, calling this method may be useful to avoid
        the expensive generation of data for debug output only.

        This function was introduced in Qt 5.5.
        """
        ...

    def isDebugEnabled(self) -> bool:
        """
        https://doc.qt.io/qt-6/qloggingcategory.html#isDebugEnabled

        **bool QLoggingCategory::isDebugEnabled() const**

        Returns `true` if debug messages should be shown for this category;
        `false` otherwise.

        **Note:** The **qCDebug** () macro already does this check before
        running any code. However, calling this method may be useful to avoid
        the expensive generation of data for debug output only.
        """
        ...

    def setEnabled(self, type: QtMsgType, enable: bool) -> None:
        """
        https://doc.qt.io/qt-6/qloggingcategory.html#setEnabled

        **void QLoggingCategory::setEnabled(QtMsgType type , bool enable )**

        Changes the message type **type** for the category to **enable**.

        This method is meant for use only from inside a filter installed with
        **installFilter** (). For an overview on how to configure categories
        globally, see **Configuring Categories** .

        **Note:**`QtFatalMsg` cannot be changed; it will always remain `true`.

        **See also** **isEnabled** ().
        """
        ...

    def isEnabled(self, type: QtMsgType) -> bool:
        """
        https://doc.qt.io/qt-6/qloggingcategory.html#isEnabled

        **bool QLoggingCategory::isEnabled(QtMsgType msgtype ) const**

        Returns `true` if a message of type **msgtype** for the category should
        be shown; `false` otherwise.
        """
        ...
