"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import enum
import typing
import PyQt6.sip
from PyQt6.QtCore import *
import enum


class QMetaType(PyQt6.sip.simplewrapper):
    """
    https://doc.qt.io/qt-6/qmetatype.html

    **Detailed Description**

    The class is used as a helper to marshall types in **QVariant**  and in
    queued signals and slots connections. It associates a type name to a type so
    that it can be created and destructed dynamically at run-time. Declare new
    types with **Q_DECLARE_METATYPE** () to make them available to **QVariant**
    and other template-based functions. Call **qRegisterMetaType** () to make
    types available to non-template based functions, such as the queued signal
    and slot connections.

    Any class or struct that has a public default constructor, a public copy
    constructor, and a public destructor can be registered.

    The following code allocates and destructs an instance of `MyClass`:

    int id = **QMetaType** ::type("MyClass");
        if (id != **QMetaType**
    ::UnknownType) {
            void *myClassPtr = **QMetaType** ::create(id);
    ...
            **QMetaType** ::destroy(id, myClassPtr);
            myClassPtr = 0;
    }

    If we want the stream operators `operator<<()` and `operator>>()` to work on
    **QVariant**  objects that store custom types, the custom type must provide
    `operator<<()` and `operator>>()` operators.

    **See also** **Q_DECLARE_METATYPE** (), **QVariant::setValue** (),
    **QVariant::value** (), and **QVariant::fromValue** ().
    """

    class TypeFlag(enum.Flag):
        NeedsConstruction: QMetaType = ...
        NeedsDestruction: QMetaType = ...
        PointerToQObject: QMetaType = ...
        IsEnumeration: QMetaType = ...
        IsUnsignedEnumeration: QMetaType = ...
        IsPointer: QMetaType = ...
        RelocatableType: QMetaType = ...
        IsQmlList: QMetaType = ...
        IsConst: QMetaType = ...

    class Type(enum.Enum):
        UnknownType: QMetaType = ...
        Void: QMetaType = ...
        Bool: QMetaType = ...
        Int: QMetaType = ...
        UInt: QMetaType = ...
        LongLong: QMetaType = ...
        ULongLong: QMetaType = ...
        Double: QMetaType = ...
        QChar: QMetaType = ...
        QVariantMap: QMetaType = ...
        QVariantList: QMetaType = ...
        QVariantHash: QMetaType = ...
        QString: QMetaType = ...
        QStringList: QMetaType = ...
        QByteArray: QMetaType = ...
        QBitArray: QMetaType = ...
        QDate: QMetaType = ...
        QTime: QMetaType = ...
        QDateTime: QMetaType = ...
        QUrl: QMetaType = ...
        QLocale: QMetaType = ...
        QRect: QMetaType = ...
        QRectF: QMetaType = ...
        QSize: QMetaType = ...
        QSizeF: QMetaType = ...
        QLine: QMetaType = ...
        QLineF: QMetaType = ...
        QPoint: QMetaType = ...
        QPointF: QMetaType = ...
        LastCoreType: QMetaType = ...
        FirstGuiType: QMetaType = ...
        QFont: QMetaType = ...
        QPixmap: QMetaType = ...
        QBrush: QMetaType = ...
        QColor: QMetaType = ...
        QPalette: QMetaType = ...
        QIcon: QMetaType = ...
        QImage: QMetaType = ...
        QPolygon: QMetaType = ...
        QRegion: QMetaType = ...
        QBitmap: QMetaType = ...
        QCursor: QMetaType = ...
        QSizePolicy: QMetaType = ...
        QKeySequence: QMetaType = ...
        QPen: QMetaType = ...
        QTextLength: QMetaType = ...
        QTextFormat: QMetaType = ...
        QTransform: QMetaType = ...
        VoidStar: QMetaType = ...
        Long: QMetaType = ...
        Short: QMetaType = ...
        Char: QMetaType = ...
        Char16: QMetaType = ...
        Char32: QMetaType = ...
        ULong: QMetaType = ...
        UShort: QMetaType = ...
        UChar: QMetaType = ...
        Float: QMetaType = ...
        QObjectStar: QMetaType = ...
        QMatrix4x4: QMetaType = ...
        QVector2D: QMetaType = ...
        QVector3D: QMetaType = ...
        QVector4D: QMetaType = ...
        QQuaternion: QMetaType = ...
        QEasingCurve: QMetaType = ...
        QVariant: QMetaType = ...
        QUuid: QMetaType = ...
        QModelIndex: QMetaType = ...
        QPolygonF: QMetaType = ...
        SChar: QMetaType = ...
        QRegularExpression: QMetaType = ...
        QJsonValue: QMetaType = ...
        QJsonObject: QMetaType = ...
        QJsonArray: QMetaType = ...
        QJsonDocument: QMetaType = ...
        QByteArrayList: QMetaType = ...
        QPersistentModelIndex: QMetaType = ...
        QCborSimpleType: QMetaType = ...
        QCborValue: QMetaType = ...
        QCborArray: QMetaType = ...
        QCborMap: QMetaType = ...
        QColorSpace: QMetaType = ...
        QVariantPair: QMetaType = ...
        User: QMetaType = ...

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qmetatype.html#QMetaType

        **[since 5.0] QMetaType::QMetaType(int typeId )**

        Constructs a QMetaType object that contains all information about type
        **typeId**.

        This function was introduced in Qt 5.0.
        """
        ...

    @typing.overload
    def __init__(self, type: int) -> None:
        """
        https://doc.qt.io/qt-6/qmetatype.html#QMetaType

        **[since 5.0] QMetaType::QMetaType(int typeId )**

        Constructs a QMetaType object that contains all information about type
        **typeId**.

        This function was introduced in Qt 5.0.
        """
        ...

    @staticmethod
    def canView(fromType: "QMetaType", toType: "QMetaType") -> bool:
        """
        https://doc.qt.io/qt-6/qmetatype.html#canView

        **[static] bool QMetaType::canView(QMetaType fromType , QMetaType toType
        )**

        Returns `true` if **QMetaType::view**  can create a mutable view of type
        **toType** on type **fromType**.

        Converting between pointers of types derived from **QObject**  will
        return true for this function if a **qobject_cast**  from the type
        described by **fromType** to the type described by **toType** would
        succeed.

        You can create a mutable view of type **QSequentialIterable**  on any
        container registered with **Q_DECLARE_SEQUENTIAL_CONTAINER_METATYPE**
        ().

        Similarly you can create a mutable view of type **QAssociativeIterable**
        on any container registered with
        **Q_DECLARE_ASSOCIATIVE_CONTAINER_METATYPE** ().

        **See also** **convert** (), **QSequentialIterable** ,
        **Q_DECLARE_SEQUENTIAL_CONTAINER_METATYPE** (), **QAssociativeIterable**
        , and **Q_DECLARE_ASSOCIATIVE_CONTAINER_METATYPE** ().
        """
        ...

    @staticmethod
    def canConvert(fromType: "QMetaType", toType: "QMetaType") -> bool:
        """
        https://doc.qt.io/qt-6/qmetatype.html#canConvert

        **[static] bool QMetaType::canConvert(QMetaType fromType , QMetaType
        toType )**

        Returns `true` if **QMetaType::convert**  can convert from **fromType**
        to **toType**.

        The following conversions are supported by Qt:

        TypeAutomatically Cast To
        **QMetaType::Bool** **QMetaType::QChar** ,
        **QMetaType::Double** , **QMetaType::Int** , **QMetaType::LongLong** ,
        **QMetaType::QString** , **QMetaType::UInt** , **QMetaType::ULongLong**
        **QMetaType::QByteArray** **QMetaType::Double** , **QMetaType::Int** ,
        **QMetaType::LongLong** , **QMetaType::QString** , **QMetaType::UInt** ,
        **QMetaType::ULongLong** , **QMetaType::QUuid**
        **QMetaType::QChar**
        **QMetaType::Bool** , **QMetaType::Int** , **QMetaType::UInt** ,
        **QMetaType::LongLong** , **QMetaType::ULongLong**
        **QMetaType::QColor** **QMetaType::QString**
        **QMetaType::QDate**
        **QMetaType::QDateTime** , **QMetaType::QString**
        **QMetaType::QDateTime** **QMetaType::QDate** , **QMetaType::QString** ,
        **QMetaType::QTime**
        **QMetaType::Double** **QMetaType::Bool** ,
        **QMetaType::Int** , **QMetaType::LongLong** , **QMetaType::QString** ,
        **QMetaType::UInt** , **QMetaType::ULongLong**
        **QMetaType::QFont**
        **QMetaType::QString**
        **QMetaType::Int** **QMetaType::Bool** ,
        **QMetaType::QChar** , **QMetaType::Double** , **QMetaType::LongLong** ,
        **QMetaType::QString** , **QMetaType::UInt** , **QMetaType::ULongLong**
        **QMetaType::QKeySequence** **QMetaType::Int** , **QMetaType::QString**
        **QMetaType::QVariantList** **QMetaType::QStringList**  (if the list's
        items can be converted to QStrings)
        **QMetaType::LongLong**
        **QMetaType::Bool** , **QMetaType::QByteArray** , **QMetaType::QChar** ,
        **QMetaType::Double** , **QMetaType::Int** , **QMetaType::QString** ,
        **QMetaType::UInt** , **QMetaType::ULongLong**
        **QMetaType::QPoint**
        **QMetaType::QPointF**
        **QMetaType::QRect** **QMetaType::QRectF**
        **QMetaType::QString** **QMetaType::Bool** , **QMetaType::QByteArray** ,
        **QMetaType::QChar** , **QMetaType::QColor** , **QMetaType::QDate** ,
        **QMetaType::QDateTime** , **QMetaType::Double** , **QMetaType::QFont**
        , **QMetaType::Int** , **QMetaType::QKeySequence** ,
        **QMetaType::LongLong** , **QMetaType::QStringList** ,
        **QMetaType::QTime** , **QMetaType::UInt** , **QMetaType::ULongLong** ,
        **QMetaType::QUuid**
        **QMetaType::QStringList**
        **QMetaType::QVariantList** , **QMetaType::QString**  (if the list
        contains exactly one item)
        **QMetaType::QTime** **QMetaType::QString**
        **QMetaType::UInt** **QMetaType::Bool** , **QMetaType::QChar** ,
        **QMetaType::Double** , **QMetaType::Int** , **QMetaType::LongLong** ,
        **QMetaType::QString** , **QMetaType::ULongLong**
        **QMetaType::ULongLong** **QMetaType::Bool** , **QMetaType::QChar** ,
        **QMetaType::Double** , **QMetaType::Int** , **QMetaType::LongLong** ,
        **QMetaType::QString** , **QMetaType::UInt**
        **QMetaType::QUuid**
        **QMetaType::QByteArray** , **QMetaType::QString**

        Casting between primitive type (int, float, bool etc.) is supported.

        Converting between pointers of types derived from **QObject**  will also
        return true for this function if a **qobject_cast**  from the type
        described by **fromType** to the type described by **toType** would
        succeed.

        A cast from a sequential container will also return true for this
        function if the **toType** is **QVariantList** .

        Similarly, a cast from an associative container will also return true
        for this function the **toType** is **QVariantHash**  or **QVariantMap**
        .

        **See also** **convert** (), **QSequentialIterable** ,
        **Q_DECLARE_SEQUENTIAL_CONTAINER_METATYPE** (), **QAssociativeIterable**
        , and **Q_DECLARE_ASSOCIATIVE_CONTAINER_METATYPE** ().
        """
        ...

    @staticmethod
    def fromName(
        name: typing.Union[QByteArray, bytes, bytearray, memoryview]
    ) -> "QMetaType":
        """
        https://doc.qt.io/qt-6/qmetatype.html#fromName

        **[static] QMetaType QMetaType::fromName(QByteArrayView typeName )**

        Returns a **QMetaType**  matching **typeName**. The returned object is
        not valid if the typeName is not known to **QMetaType**
        """
        ...

    def isOrdered(self) -> bool:
        """
        https://doc.qt.io/qt-6/qmetatype.html#isOrdered

        **bool QMetaType::isOrdered() const**

        Returns `true` if a less than operator for the type described by this
        metatype was visible to the metatype declaration, otherwise `false`.

        **See also** **compare** () and **isEqualityComparable** ().
        """
        ...

    def isEqualityComparable(self) -> bool:
        """
        https://doc.qt.io/qt-6/qmetatype.html#isEqualityComparable

        **bool QMetaType::isEqualityComparable() const**

        Returns `true` if a less than or equality operator for the type
        described by this metatype was visible to the metatype declaration,
        otherwise `false`.

        **See also** **equals** () and **isOrdered** ().
        """
        ...

    def alignOf(self) -> int:
        """
        https://doc.qt.io/qt-6/qmetatype.html#alignOf

        **[since 6.0] qsizetype QMetaType::alignOf() const**

        Returns the alignment of the type in bytes (i.e. alignof(T), where T is
        the actual type for which this **QMetaType**  instance was constructed
        for).

        This function is typically used together with construct() to perform
        low-level management of the memory used by a type.

        This function was introduced in Qt 6.0.

        **See also** **QMetaType::construct** () and **QMetaType::sizeOf** ().
        """
        ...

    def name(self) -> bytes:
        """
        https://doc.qt.io/qt-6/qmetatype.html#name

        **[since 5.15] const char *QMetaType::name() const**

        Returns the type name associated with this **QMetaType** , or a null
        pointer if no matching type was found. The returned pointer must not be
        deleted.

        This function was introduced in Qt 5.15.

        **See also** **typeName** ().
        """
        ...

    def hasRegisteredDebugStreamOperator(self) -> bool:
        """
        https://doc.qt.io/qt-6/qmetatype.html#hasRegisteredDebugStreamOperator

        **[since 6.0] bool QMetaType::hasRegisteredDebugStreamOperator() const**

        Returns `true`, if the meta type system has a registered debug stream
        operator for this meta type.

        This function was introduced in Qt 6.0.
        """
        ...

    def hasRegisteredDataStreamOperators(self) -> bool:
        """
        https://doc.qt.io/qt-6/qmetatype.html#hasRegisteredDataStreamOperators

        **[since 6.1] bool QMetaType::hasRegisteredDataStreamOperators() const**

        Returns `true`, if the meta type system has registered data stream
        operators for this meta type.

        This function was introduced in Qt 6.1.
        """
        ...

    def id(self) -> int:
        """
        https://doc.qt.io/qt-6/qmetatype.html#id

        **[since 5.13] int QMetaType::id() const**

        Returns id type hold by this QMetatype instance.

        This function was introduced in Qt 5.13.
        """
        ...

    def isValid(self) -> bool:
        """
        https://doc.qt.io/qt-6/qmetatype.html#isValid

        **[since 5.0] bool QMetaType::isValid() const**

        Returns `true` if this **QMetaType**  object contains valid information
        about a type, false otherwise.

        This function was introduced in Qt 5.0.
        """
        ...

    def flags(self) -> "QMetaType.TypeFlag":
        """
        https://doc.qt.io/qt-6/qmetatype.html#flags

        **[since 5.0] QMetaType::TypeFlags QMetaType::flags() const**

        Returns flags of the type for which this **QMetaType**  instance was
        constructed.

        This function was introduced in Qt 5.0.

        **See also** **QMetaType::TypeFlags**  and QMetaType::flags().
        """
        ...

    def sizeOf(self) -> int:
        """
        https://doc.qt.io/qt-6/qmetatype.html#sizeOf-1

        **[since 5.0] qsizetype QMetaType::sizeOf() const**

        Returns the size of the type in bytes (i.e. sizeof(T), where T is the
        actual type for which this **QMetaType**  instance was constructed for).

        This function is typically used together with construct() to perform
        low-level management of the memory used by a type.

        This function was introduced in Qt 5.0.

        **See also** **QMetaType::construct** (), QMetaType::sizeOf(), and
        **QMetaType::alignOf** ().
        """
        ...

    @typing.overload
    @staticmethod
    def isRegistered(type: int) -> bool:
        """
        https://doc.qt.io/qt-6/qmetatype.html#isRegistered

        **[static] bool QMetaType::isRegistered(int type )**

        Returns `true` if the datatype with ID **type** is registered; otherwise
        returns `false`.

        **See also** **type** (), **typeName** (), and **Type** .
        """
        ...

    @typing.overload
    def isRegistered(self) -> bool:
        """
        https://doc.qt.io/qt-6/qmetatype.html#isRegistered-1

        **[since 5.0] bool QMetaType::isRegistered() const**

        Returns `true` if this **QMetaType**  object contains valid information
        about a type, false otherwise.

        This function was introduced in Qt 5.0.
        """
        ...
