"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
import PyQt6.sip


class QModelRoleData(PyQt6.sip.simplewrapper):
    """
    https://doc.qt.io/qt-6/qmodelroledata.html

    **Detailed Description**

    QModelRoleData objects store an item role (which is a value from the
    **Qt::ItemDataRole**  enumeration, or an arbitrary integer for a custom
    role) as well as the data associated with that role.

    A QModelRoleData object is typically created by views or delegates, setting
    which role they want to fetch the data for. The object is then passed to
    models (see **QAbstractItemModel::multiData** ()), which populate the data
    corresponding to the role stored. Finally, the view visualizes the data
    retrieved from the model.

    **See also** **Model/View Programming**  and **QModelRoleDataSpan** .
    """

    @typing.overload
    def __init__(self, role: int) -> None:
        """
        https://doc.qt.io/qt-6/qmodelroledata.html#QModelRoleData

        **QModelRoleData::QModelRoleData(int role )**

        Constructs a QModelRoleData object for the given **role**.

        **See also** **Qt::ItemDataRole** .
        """
        ...

    @typing.overload
    def __init__(self, a0: "QModelRoleData") -> None:
        """
        https://doc.qt.io/qt-6/qmodelroledata.html#QModelRoleData

        **QModelRoleData::QModelRoleData(int role )**

        Constructs a QModelRoleData object for the given **role**.

        **See also** **Qt::ItemDataRole** .
        """
        ...

    def clearData(self) -> None:
        """
        https://doc.qt.io/qt-6/qmodelroledata.html#clearData

        **void QModelRoleData::clearData()**

        Clears the data held by this object. Note that the role is unchanged;
        only the data is cleared.

        **See also** **data** ().
        """
        ...

    def setData(self, data: typing.Any) -> None:
        """
        https://doc.qt.io/qt-6/qmodelroledata.html#setData

        **template <typename T> void QModelRoleData::setData(T && value )**

        Sets the data held by this object to **value**. **value** must be of a
        datatype which can be stored in a **QVariant** .

        **See also** **data** (), **clearData** (), and **Q_DECLARE_METATYPE** .
        """
        ...

    def data(self) -> typing.Any:
        """
        https://doc.qt.io/qt-6/qmodelroledata.html#data

        **QVariant &QModelRoleData::data()**

        Returns the data held by this object as a modifiable reference.

        **See also** **setData** ().
        """
        ...

    def role(self) -> int:
        """
        https://doc.qt.io/qt-6/qmodelroledata.html#role

        **int QModelRoleData::role() const**

        Returns the role held by this object.

        **See also** **Qt::ItemDataRole** .
        """
        ...
