"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
import PyQt6.sip


class QProcessEnvironment(PyQt6.sip.simplewrapper):
    """
    https://doc.qt.io/qt-6/qprocessenvironment.html

    **Detailed Description**

    A process's environment is composed of a set of key=value pairs known as
    environment variables. The QProcessEnvironment class wraps that concept and
    allows easy manipulation of those variables. It's meant to be used along
    with **QProcess** , to set the environment for child processes. It cannot be
    used to change the current process's environment.

    The environment of the calling process can be obtained using
    **QProcessEnvironment::systemEnvironment** ().

    On Unix systems, the variable names are case-sensitive. Note that the Unix
    environment allows both variable names and contents to contain arbitrary
    binary data (except for the NUL character). QProcessEnvironment will
    preserve such variables, but does not support manipulating variables whose
    names or values cannot be encoded by the current locale settings (see
    **QString::toLocal8Bit** ).

    On Windows, the variable names are case-insensitive, but case-preserving.
    QProcessEnvironment behaves accordingly.

    **See also** **QProcess** , **QProcess::systemEnvironment** (), and
    **QProcess::setProcessEnvironment** ().
    """

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qprocessenvironment.html#QProcessEnvironment

        **QProcessEnvironment::QProcessEnvironment()**

        Creates a new QProcessEnvironment object. This constructor creates an
        empty environment. If set on a **QProcess** , this will cause the
        current environment variables to be removed.
        """
        ...

    @typing.overload
    def __init__(self, other: "QProcessEnvironment") -> None:
        """
        https://doc.qt.io/qt-6/qprocessenvironment.html#QProcessEnvironment-1

        **QProcessEnvironment::QProcessEnvironment(const QProcessEnvironment &
        other )**

        Creates a QProcessEnvironment object that is a copy of **other**.
        """
        ...

    def swap(self, other: "QProcessEnvironment") -> None:
        """
        https://doc.qt.io/qt-6/qprocessenvironment.html#swap

        **[since 5.0] void QProcessEnvironment::swap(QProcessEnvironment & other
        )**

        Swaps this process environment instance with **other**. This function is
        very fast and never fails.

        This function was introduced in Qt 5.0.
        """
        ...

    def keys(self) -> typing.List[str]:
        """
        https://doc.qt.io/qt-6/qprocessenvironment.html#keys

        **QStringList QProcessEnvironment::keys() const**

        Returns a list containing all the variable names in this
        **QProcessEnvironment**  object.
        """
        ...

    @staticmethod
    def systemEnvironment() -> "QProcessEnvironment":
        """
        https://doc.qt.io/qt-6/qprocessenvironment.html#systemEnvironment

        **[static] QProcessEnvironment
        QProcessEnvironment::systemEnvironment()**

        The systemEnvironment function returns the environment of the calling
        process.

        It is returned as a **QProcessEnvironment** . This function does not
        cache the system environment. Therefore, it's possible to obtain an
        updated version of the environment if low-level C library functions like
        `setenv` or `putenv` have been called.

        However, note that repeated calls to this function will recreate the
        **QProcessEnvironment**  object, which is a non-trivial operation.

        **See also** **QProcess::systemEnvironment** ().
        """
        ...

    def toStringList(self) -> typing.List[str]:
        """
        https://doc.qt.io/qt-6/qprocessenvironment.html#toStringList

        **QStringList QProcessEnvironment::toStringList() const**

        Converts this **QProcessEnvironment**  object into a list of strings,
        one for each environment variable that is set. The environment
        variable's name and its value are separated by an equal character ('=').

        The **QStringList**  contents returned by this function are suitable for
        presentation. Use with the QProcess::setEnvironment function is not
        recommended due to potential encoding problems under Unix, and worse
        performance.

        **See also** **systemEnvironment** (), **QProcess::systemEnvironment**
        (), and **QProcess::setProcessEnvironment** ().
        """
        ...

    def value(self, name: str, defaultValue: str = ...) -> str:
        """
        https://doc.qt.io/qt-6/qprocessenvironment.html#value

        **QString QProcessEnvironment::value(const QString & name , const
        QString & defaultValue = QString()) const**

        Searches this **QProcessEnvironment**  object for a variable identified
        by **name** and returns its value. If the variable is not found in this
        object, then **defaultValue** is returned instead.

        **See also** **contains** (), **insert** (), and **remove** ().
        """
        ...

    def remove(self, name: str) -> None:
        """
        https://doc.qt.io/qt-6/qprocessenvironment.html#remove

        **void QProcessEnvironment::remove(const QString & name )**

        Removes the environment variable identified by **name** from this
        **QProcessEnvironment**  object. If that variable did not exist before,
        nothing happens.

        **See also** **contains** (), **insert** (), and **value** ().
        """
        ...

    @typing.overload
    def insert(self, name: str, value: str) -> None:
        """
        https://doc.qt.io/qt-6/qprocessenvironment.html#insert

        **void QProcessEnvironment::insert(const QString & name , const QString
        & value )**

        Inserts the environment variable of name **name** and contents **value**
        into this **QProcessEnvironment**  object. If that variable already
        existed, it is replaced by the new value.

        On most systems, inserting a variable with no contents will have the
        same effect for applications as if the variable had not been set at all.
        However, to guarantee that there are no incompatibilities, to remove a
        variable, please use the **remove** () function.

        **See also** **contains** (), **remove** (), and **value** ().
        """
        ...

    @typing.overload
    def insert(self, e: "QProcessEnvironment") -> None:
        """
        https://doc.qt.io/qt-6/qprocessenvironment.html#insert-1

        **void QProcessEnvironment::insert(const QProcessEnvironment & e )**

        This is an overloaded function.

        Inserts the contents of **e** in this **QProcessEnvironment**  object.
        Variables in this object that also exist in **e** will be overwritten.
        """
        ...

    def contains(self, name: str) -> bool:
        """
        https://doc.qt.io/qt-6/qprocessenvironment.html#contains

        **bool QProcessEnvironment::contains(const QString & name ) const**

        Returns `true` if the environment variable of name **name** is found in
        this **QProcessEnvironment**  object.

        **See also** **insert** () and **value** ().
        """
        ...

    def clear(self) -> None:
        """
        https://doc.qt.io/qt-6/qprocessenvironment.html#clear

        **void QProcessEnvironment::clear()**

        Removes all key=value pairs from this **QProcessEnvironment**  object,
        making it empty.

        **See also** **isEmpty** () and **systemEnvironment** ().
        """
        ...

    def isEmpty(self) -> bool:
        """
        https://doc.qt.io/qt-6/qprocessenvironment.html#isEmpty

        **bool QProcessEnvironment::isEmpty() const**

        Returns `true` if this **QProcessEnvironment**  object is empty: that is
        there are no key=value pairs set.

        **See also** **clear** (), **systemEnvironment** (), and **insert** ().
        """
        ...
