"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
import PyQt6.sip
from PyQt6.QtCore import *


class QReadLocker(PyQt6.sip.simplewrapper):
    """
    https://doc.qt.io/qt-6/qreadlocker.html

    **Detailed Description**

    The purpose of QReadLocker (and **QWriteLocker** ) is to simplify
    **QReadWriteLock**  locking and unlocking. Locking and unlocking statements
    or in exception handling code is error-prone and difficult to debug.
    QReadLocker can be used in such situations to ensure that the state of the
    lock is always well-defined.

    Here's an example that uses QReadLocker to lock and unlock a read-write lock
    for reading:

    **QReadWriteLock**  lock;

        **QByteArray**  readData()
        {
    **QReadLocker**  locker(&lock);
            ...
            return data;
        }

    It is equivalent to the following code:

    **QReadWriteLock**  lock;

        **QByteArray**  readData()
        {
    lock.lockForRead();
            ...
            lock.unlock();
            return data;
    }

    The **QMutexLocker**  documentation shows examples where the use of a locker
    object greatly simplifies programming.

    **See also** **QWriteLocker**  and **QReadWriteLock** .
    """

    def __init__(self, areadWriteLock: QReadWriteLock) -> None:
        """
        https://doc.qt.io/qt-6/qreadlocker.html#QReadLocker

        **QReadLocker::QReadLocker(QReadWriteLock * lock )**

        Constructs a QReadLocker and locks **lock** for reading. The lock will
        be unlocked when the QReadLocker is destroyed. If `lock` is zero,
        QReadLocker does nothing.

        **See also** **QReadWriteLock::lockForRead** ().
        """
        ...

    def __exit__(
        self, type: typing.Any, value: typing.Any, traceback: typing.Any
    ) -> None:
        ...

    def __enter__(self) -> typing.Any:
        ...

    def readWriteLock(self) -> QReadWriteLock:
        """
        https://doc.qt.io/qt-6/qreadlocker.html#readWriteLock

        **QReadWriteLock *QReadLocker::readWriteLock() const**

        Returns a pointer to the read-write lock that was passed to the
        constructor.
        """
        ...

    def relock(self) -> None:
        """
        https://doc.qt.io/qt-6/qreadlocker.html#relock

        **void QReadLocker::relock()**

        Relocks an unlocked lock.

        **See also** **unlock** ().
        """
        ...

    def unlock(self) -> None:
        """
        https://doc.qt.io/qt-6/qreadlocker.html#unlock

        **void QReadLocker::unlock()**

        Unlocks the lock associated with this locker.

        **See also** **QReadWriteLock::unlock** ().
        """
        ...
