"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
from PyQt6.QtCore import *


class QStringDecoder(QStringConverter):
    """
    https://doc.qt.io/qt-6/qstringdecoder.html

    **Detailed Description**

    A text decoder converts text an encoded text format that uses a specific
    encoding into Qt's internal representation.

    Converting encoded data into a **QString**  can be achieved using the
    following code:

    **QByteArray**  encodedString = "...";
        auto toUtf16 =
    QStringDecoder(QStringDecoder::Utf8);
        **QString**  string =
    toUtf16(encodedString);

    The decoder remembers any state that is required between calls, so
    converting data received in chunks, for example, when receiving it over a
    network, is just as easy, by calling the decoder whenever new data is
    available:

    auto toUtf16 = QStringDecoder(QStringDecoder::Utf8);

        **QString**
    string;
        while (new_data_available()) {
            **QByteArray**  chunk =
    get_new_data();
            string += toUtf16(chunk);
        }

    The QStringDecoder object maintains state between chunks and therefore works
    correctly even if chunks are split in the middle of a multi-byte character
    sequence.

    QStringDecoder objects can't be copied because of their internal state, but
    can be moved.

    **See also** **QStringConverter**  and **QStringEncoder** .
    """

    @typing.overload
    def __init__(
        self,
        encoding: QStringConverter.Encoding,
        flags: QStringConverterBase.Flag = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qstringdecoder.html#QStringDecoder-1

        **QStringDecoder::QStringDecoder(QStringConverter::Encoding encoding ,
        QStringConverter::Flags flags = Flag::Default)**

        Creates an decoder object using **encoding** and **flags**.
        """
        ...

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qstringdecoder.html#QStringDecoder-2

        **QStringDecoder::QStringDecoder()**

        Default constructs an decoder. The default decoder is not valid, and
        can't be used for converting text.
        """
        ...

    @typing.overload
    def __init__(self, name: str, flags: QStringConverterBase.Flag = ...) -> None:
        """
        https://doc.qt.io/qt-6/qstringdecoder.html#QStringDecoder-3

        **QStringDecoder::QStringDecoder(const char * name ,
        QStringConverter::Flags flags = Flag::Default)**

        Creates an decoder object using **name** and **flags**. If **name** is
        not the name of a known encoding an invalid converter will get created.

        **See also** **isValid** ().
        """
        ...

    def decode(self, ba: typing.Union[QByteArray, bytes, bytearray, memoryview]) -> str:
        ...

    def __call__(
        self, ba: typing.Union[QByteArray, bytes, bytearray, memoryview]
    ) -> str:
        ...
