"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
from PyQt6.QtCore import *


class QStringEncoder(QStringConverter):
    """
    https://doc.qt.io/qt-6/qstringencoder.html

    **Detailed Description**

    A text encoder converts text from Qt's internal representation into an
    encoded text format using a specific encoding.

    Converting a string from Unicode to the local encoding can be achieved using
    the following code:

    **QString**  string = "...";
        auto fromUtf16 =
    QStringEncoder(QStringEncoder::Utf8);
        **QByteArray**  encodedString =
    fromUtf16(string);

    The encoder remembers any state that is required between calls, so
    converting data received in chunks, for example, when receiving it over a
    network, is just as easy, by calling the encoder whenever new data is
    available:

    auto fromUtf16 = QStringEncoder(QStringEncoder::Utf8);
    **QByteArray**  encoded;
        while (new_data_available()) {
    **QString**  chunk = get_new_data();
            encoded += fromUtf16(chunk);
    }

    The QStringEncoder object maintains state between chunks and therefore works
    correctly even if a UTF-16 surrogate character is split between chunks.

    QStringEncoder objects can't be copied because of their internal state, but
    can be moved.

    **See also** **QStringConverter**  and **QStringDecoder** .
    """

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qstringencoder.html#QStringEncoder-1

        **QStringEncoder::QStringEncoder()**

        Default constructs an encoder. The default encoder is not valid, and
        can't be used for converting text.
        """
        ...

    @typing.overload
    def __init__(
        self,
        encoding: QStringConverter.Encoding,
        flags: QStringConverterBase.Flag = ...,
    ) -> None:
        """
        https://doc.qt.io/qt-6/qstringencoder.html#QStringEncoder-2

        **QStringEncoder::QStringEncoder(QStringConverter::Encoding encoding ,
        QStringConverter::Flags flags = Flag::Default)**

        Creates an encoder object using **encoding** and **flags**.
        """
        ...

    @typing.overload
    def __init__(self, name: str, flags: QStringConverterBase.Flag = ...) -> None:
        """
        https://doc.qt.io/qt-6/qstringencoder.html#QStringEncoder-3

        **QStringEncoder::QStringEncoder(const char * name ,
        QStringConverter::Flags flags = Flag::Default)**

        Creates an encoder object using **name** and **flags**. If **name** is
        not the name of a known encoding an invalid converter will get created.

        **See also** **isValid** ().
        """
        ...

    def encode(self, in_: str) -> QByteArray:
        ...

    def __call__(self, in_: str) -> QByteArray:
        ...
