"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import enum
import typing
import PyQt6.sip
from PyQt6.QtCore import *
import enum


class QTextBoundaryFinder(PyQt6.sip.simplewrapper):
    """
    https://doc.qt.io/qt-6/qtextboundaryfinder.html

    **Detailed Description**

    QTextBoundaryFinder allows to find Unicode text boundaries in a string,
    accordingly to the Unicode text boundary specification (see **Unicode
    Standard Annex #14**  and **Unicode Standard Annex #29** ).

    QTextBoundaryFinder can operate on a **QString**  in four possible modes
    depending on the value of **BoundaryType**.

    Units of Unicode characters that make up what the user thinks of as a
    character or basic unit of the language are here called Grapheme clusters.
    The two unicode characters 'A' + diaeresis do for example form one grapheme
    cluster as the user thinks of them as one character, yet it is in this case
    represented by two unicode code points (see
    <https://www.unicode.org/reports/tr29/#Grapheme_Cluster_Boundaries>).

    Word boundaries are there to locate the start and end of what a language
    considers to be a word (see
    <https://www.unicode.org/reports/tr29/#Word_Boundaries>).

    Line break boundaries give possible places where a line break might happen
    and sentence boundaries will show the beginning and end of whole sentences
    (see <https://www.unicode.org/reports/tr29/#Sentence_Boundaries> and
    <https://www.unicode.org/reports/tr14/>).

    The first position in a string is always a valid boundary and refers to the
    position before the first character. The last position at the length of the
    string is also valid and refers to the position after the last character.
    """

    class BoundaryType(enum.Enum):
        Grapheme: QTextBoundaryFinder = ...
        Word: QTextBoundaryFinder = ...
        Line: QTextBoundaryFinder = ...
        Sentence: QTextBoundaryFinder = ...

    class BoundaryReason(enum.Flag):
        NotAtBoundary: QTextBoundaryFinder = ...
        SoftHyphen: QTextBoundaryFinder = ...
        BreakOpportunity: QTextBoundaryFinder = ...
        StartOfItem: QTextBoundaryFinder = ...
        EndOfItem: QTextBoundaryFinder = ...
        MandatoryBreak: QTextBoundaryFinder = ...

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qtextboundaryfinder.html#QTextBoundaryFinder

        **QTextBoundaryFinder::QTextBoundaryFinder()**

        Constructs an invalid QTextBoundaryFinder object.
        """
        ...

    @typing.overload
    def __init__(self, other: "QTextBoundaryFinder") -> None:
        """
        https://doc.qt.io/qt-6/qtextboundaryfinder.html#QTextBoundaryFinder-1

        **QTextBoundaryFinder::QTextBoundaryFinder(const QTextBoundaryFinder &
        other )**

        Copies the QTextBoundaryFinder object, **other**.
        """
        ...

    @typing.overload
    def __init__(self, type: "QTextBoundaryFinder.BoundaryType", string: str) -> None:
        """
        https://doc.qt.io/qt-6/qtextboundaryfinder.html#QTextBoundaryFinder-2

        **QTextBoundaryFinder::QTextBoundaryFinder(QTextBoundaryFinder::Boundary
        Type type , const QString & string )**

        Creates a QTextBoundaryFinder object of **type** operating on
        **string**.
        """
        ...

    def boundaryReasons(self) -> "QTextBoundaryFinder.BoundaryReason":
        """
        https://doc.qt.io/qt-6/qtextboundaryfinder.html#boundaryReasons

        **QTextBoundaryFinder::BoundaryReasons
        QTextBoundaryFinder::boundaryReasons() const**

        Returns the reasons for the boundary finder to have chosen the current
        position as a boundary.
        """
        ...

    def isAtBoundary(self) -> bool:
        """
        https://doc.qt.io/qt-6/qtextboundaryfinder.html#isAtBoundary

        **bool QTextBoundaryFinder::isAtBoundary() const**

        Returns `true` if the object's **position** () is currently at a valid
        text boundary.
        """
        ...

    def toPreviousBoundary(self) -> int:
        """
        https://doc.qt.io/qt-6/qtextboundaryfinder.html#toPreviousBoundary

        **qsizetype QTextBoundaryFinder::toPreviousBoundary()**

        Moves the **QTextBoundaryFinder**  to the previous boundary position and
        returns that position.

        Returns -1 if there is no previous boundary.
        """
        ...

    def toNextBoundary(self) -> int:
        """
        https://doc.qt.io/qt-6/qtextboundaryfinder.html#toNextBoundary

        **qsizetype QTextBoundaryFinder::toNextBoundary()**

        Moves the **QTextBoundaryFinder**  to the next boundary position and
        returns that position.

        Returns -1 if there is no next boundary.
        """
        ...

    def setPosition(self, position: int) -> None:
        """
        https://doc.qt.io/qt-6/qtextboundaryfinder.html#setPosition

        **void QTextBoundaryFinder::setPosition(qsizetype position )**

        Sets the current position of the **QTextBoundaryFinder**  to
        **position**.

        If **position** is out of bounds, it will be bound to only valid
        positions. In this case, valid positions are from 0 to the length of the
        string inclusive.

        **See also** **position** ().
        """
        ...

    def position(self) -> int:
        """
        https://doc.qt.io/qt-6/qtextboundaryfinder.html#position

        **qsizetype QTextBoundaryFinder::position() const**

        Returns the current position of the **QTextBoundaryFinder** .

        The range is from 0 (the beginning of the string) to the length of the
        string inclusive.

        **See also** **setPosition** ().
        """
        ...

    def toEnd(self) -> None:
        """
        https://doc.qt.io/qt-6/qtextboundaryfinder.html#toEnd

        **void QTextBoundaryFinder::toEnd()**

        Moves the finder to the end of the string. This is equivalent to
        **setPosition** (string.length()).

        **See also** **setPosition** () and **position** ().
        """
        ...

    def toStart(self) -> None:
        """
        https://doc.qt.io/qt-6/qtextboundaryfinder.html#toStart

        **void QTextBoundaryFinder::toStart()**

        Moves the finder to the start of the string. This is equivalent to
        **setPosition** (0).

        **See also** **setPosition** () and **position** ().
        """
        ...

    def string(self) -> str:
        """
        https://doc.qt.io/qt-6/qtextboundaryfinder.html#string

        **QString QTextBoundaryFinder::string() const**

        Returns the string the **QTextBoundaryFinder**  object operates on.
        """
        ...

    def type(self) -> "QTextBoundaryFinder.BoundaryType":
        """
        https://doc.qt.io/qt-6/qtextboundaryfinder.html#type

        **QTextBoundaryFinder::BoundaryType QTextBoundaryFinder::type() const**

        Returns the type of the **QTextBoundaryFinder** .
        """
        ...

    def isValid(self) -> bool:
        """
        https://doc.qt.io/qt-6/qtextboundaryfinder.html#isValid

        **bool QTextBoundaryFinder::isValid() const**

        Returns `true` if the text boundary finder is valid; otherwise returns
        `false`. A default **QTextBoundaryFinder**  is invalid.
        """
        ...
