"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
from PyQt6 import QtCore


class QDBusAbstractAdaptor(QtCore.QObject):
    """
    https://doc.qt.io/qt-6/qdbusabstractadaptor.html

    **Detailed Description**

    The QDBusAbstractAdaptor class is the starting point for all objects
    intending to provide interfaces to the external world using D-Bus. This is
    accomplished by attaching a one or more classes derived from
    QDBusAbstractAdaptor to a normal **QObject**  and then registering that
    **QObject**  with **QDBusConnection::registerObject** . QDBusAbstractAdaptor
    objects are intended to be light-weight wrappers, mostly just relaying calls
    into the real object (its parent) and the signals from it.

    Each QDBusAbstractAdaptor-derived class should define the D-Bus interface it
    is implementing using the **Q_CLASSINFO**  macro in the class definition.
    Note that only one interface can be exposed in this way.

    QDBusAbstractAdaptor uses the standard **QObject**  mechanism of signals,
    slots and properties to determine what signals, methods and properties to
    export to the bus. Any signal emitted by QDBusAbstractAdaptor-derived
    classes will be automatically be relayed through any D-Bus connections the
    object is registered on.

    Classes derived from QDBusAbstractAdaptor must be created on the heap using
    the **new** operator and must not be deleted by the user (they will be
    deleted automatically when the object they are connected to is also
    deleted).

    **See also** **Using adaptors**  and **QDBusConnection** .
    """

    def __init__(self, parent: QtCore.QObject) -> None:
        """
        https://doc.qt.io/qt-6/qdbusabstractadaptor.html#QDBusAbstractAdaptor

        **[protected] QDBusAbstractAdaptor::QDBusAbstractAdaptor(QObject * obj
        )**

        Constructs a QDBusAbstractAdaptor with **obj** as the parent object.
        """
        ...

    def autoRelaySignals(self) -> bool:
        """
        https://doc.qt.io/qt-6/qdbusabstractadaptor.html#autoRelaySignals

        **[protected] bool QDBusAbstractAdaptor::autoRelaySignals() const**

        Returns `true` if automatic signal relaying from the real object (see
        object()) is enabled, otherwiser returns `false`.

        **See also** **setAutoRelaySignals** ().
        """
        ...

    def setAutoRelaySignals(self, enable: bool) -> None:
        """
        https://doc.qt.io/qt-6/qdbusabstractadaptor.html#setAutoRelaySignals

        **[protected] void QDBusAbstractAdaptor::setAutoRelaySignals(bool enable
        )**

        Toggles automatic signal relaying from the real object (see object()).

        Automatic signal relaying consists of signal-to-signal connection of the
        signals on the parent that have the exact same method signature in both
        classes.

        If **enable** is set to true, connect the signals; if set to false,
        disconnect all signals.

        **See also** **autoRelaySignals** ().
        """
        ...
