"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
from PyQt6 import QtCore
from PyQt6.QtDBus import *


class QDBusAbstractInterface(QtCore.QObject):
    """
    https://doc.qt.io/qt-6/qdbusabstractinterface.html

    **Detailed Description**

    Generated-code classes also derive from QDBusAbstractInterface, all methods
    described here are also valid for generated-code classes. In addition to
    those described here, generated-code classes provide member functions for
    the remote methods, which allow for compile-time checking of the correct
    parameters and return values, as well as property type-matching and signal
    parameter-matching.

    **See also** **The QDBus compiler**  and **QDBusInterface** .
    """

    def __init__(
        self,
        service: str,
        path: str,
        interface: str,
        connection: "QDBusConnection",
        parent: QtCore.QObject,
    ) -> None:
        ...

    def disconnectNotify(self, signal: QtCore.QMetaMethod) -> None:
        ...

    def connectNotify(self, signal: QtCore.QMetaMethod) -> None:
        ...

    def asyncCallWithArgumentList(
        self, method: str, args: typing.Iterable[typing.Any]
    ) -> "QDBusPendingCall":
        """
        https://doc.qt.io/qt-6/qdbusabstractinterface.html#asyncCallWithArgument
        List

        **QDBusPendingCall
        QDBusAbstractInterface::asyncCallWithArgumentList(const QString & method
        , const QList<QVariant> & args )**

        Places a call to the remote method specified by **method** on this
        interface, using **args** as arguments. This function returns a
        **QDBusPendingCall**  object that can be used to track the status of the
        reply and access its contents once it has arrived.

        Normally, you should place calls using **asyncCall** ().

        **Note:** This function is **thread-safe** .
        """
        ...

    def asyncCall(self, method: str, *a1) -> "QDBusPendingCall":
        """
        https://doc.qt.io/qt-6/qdbusabstractinterface.html#asyncCall-1

        **template <typename Args> QDBusPendingCall
        QDBusAbstractInterface::asyncCall(const QString & method , Args &&...
        args )**

        Calls the method **method** on this interface and passes **args** to the
        method. All **args** must be convertible to **QVariant** .

        The parameters to `call` are passed on to the remote function via D-Bus
        as input arguments. The returned **QDBusPendingCall**  object can be
        used to find out information about the reply.

        It can be used the following way:

        **QString**  value = retrieveValue();
            **QDBusPendingCall**  pcall =
        interface->asyncCall(QLatin1String("Process"), value);
        **QDBusPendingCallWatcher**  *watcher = new **QDBusPendingCallWatcher**
        (pcall);

            **QObject** ::connect(watcher,
        SIGNAL(finished(**QDBusPendingCallWatcher** *)),
        this, SLOT(callFinishedSlot(**QDBusPendingCallWatcher** *)));

        This example illustrates function calling with 0, 1 and 2 parameters and
        illustrates different parameter types passed in each (the first call to
        `"ProcessWorkUnicode"` will contain one Unicode string, the second call
        to `"ProcessWork"` will contain one string and one byte array).

        **Note:** Before Qt 5.14, this function accepted a maximum of just eight
        (8) arguments.

        **See also** **asyncCallWithArgumentList** ().
        """
        ...

    @typing.overload
    def callWithCallback(
        self,
        method: str,
        args: typing.Iterable[typing.Any],
        returnMethod: PYQT_SLOT,
        errorMethod: PYQT_SLOT,
    ) -> bool:
        """
        https://doc.qt.io/qt-6/qdbusabstractinterface.html#callWithCallback

        **bool QDBusAbstractInterface::callWithCallback(const QString & method ,
        const QList<QVariant> & args , QObject * receiver , const char *
        returnMethod , const char * errorMethod )**

        Places a call to the remote method specified by **method** on this
        interface, using **args** as arguments. This function returns
        immediately after queueing the call. The reply from the remote function
        is delivered to the **returnMethod** on object **receiver**. If an error
        occurs, the **errorMethod** on object **receiver** is called instead.

        This function returns `true` if the queueing succeeds. It does not
        indicate that the executed call succeeded. If it fails, the
        **errorMethod** is called. If the queueing failed, this function returns
        `false` and no slot will be called.

        The **returnMethod** must have as its parameters the types returned by
        the function call. Optionally, it may have a **QDBusMessage**  parameter
        as its last or only parameter. The **errorMethod** must have a
        **QDBusError**  as its only parameter.

        **See also** **QDBusError**  and **QDBusMessage** .
        """
        ...

    @typing.overload
    def callWithCallback(
        self, method: str, args: typing.Iterable[typing.Any], slot: PYQT_SLOT
    ) -> bool:
        """
        https://doc.qt.io/qt-6/qdbusabstractinterface.html#callWithCallback-1

        **bool QDBusAbstractInterface::callWithCallback(const QString & method ,
        const QList<QVariant> & args , QObject * receiver , const char * slot
        )**

        This is an overloaded function.

        This function is deprecated. Please use the overloaded version.

        Places a call to the remote method specified by **method** on this
        interface, using **args** as arguments. This function returns
        immediately after queueing the call. The reply from the remote function
        or any errors emitted by it are delivered to the **slot** slot on object
        **receiver**.

        This function returns `true` if the queueing succeeded: it does not
        indicate that the call succeeded. If it failed, the slot will be called
        with an error message. **lastError** () will not be set under those
        circumstances.

        **See also** **QDBusError**  and **QDBusMessage** .
        """
        ...

    def callWithArgumentList(
        self, mode: "QDBus.CallMode", method: str, args: typing.Iterable[typing.Any]
    ) -> "QDBusMessage":
        """
        https://doc.qt.io/qt-6/qdbusabstractinterface.html#callWithArgumentList

        **QDBusMessage
        QDBusAbstractInterface::callWithArgumentList(QDBus::CallMode mode ,
        const QString & method , const QList<QVariant> & args )**

        Places a call to the remote method specified by **method** on this
        interface, using **args** as arguments. This function returns the
        message that was received as a reply, which can be a normal
        **QDBusMessage::ReplyMessage**  (indicating success) or
        **QDBusMessage::ErrorMessage**  (if the call failed). The **mode**
        parameter specifies how this call should be placed.

        If the call succeeds, **lastError** () will be cleared; otherwise, it
        will contain the error this call produced.

        Normally, you should place calls using **call** ().

        **Warning:** If you use `UseEventLoop`, your code must be prepared to
        deal with any reentrancy: other method calls and signals may be
        delivered before this function returns, as well as other Qt queued
        signals and events.

        **Note:** This function is **thread-safe** .
        """
        ...

    @typing.overload
    def call(self, method: str, *a1) -> "QDBusMessage":
        """
        https://doc.qt.io/qt-6/qdbusabstractinterface.html#call-1

        **template <typename Args> QDBusMessage
        QDBusAbstractInterface::call(const QString & method , Args &&... args
        )**

        Calls the method **method** on this interface and passes **args** to the
        method. All **args** must be convertible to **QVariant** .

        The parameters to `call` are passed on to the remote function via D-Bus
        as input arguments. Output arguments are returned in the
        **QDBusMessage**  reply. If the reply is an error reply, **lastError**
        () will also be set to the contents of the error message.

        It can be used the following way:

        **QString**  value = retrieveValue();
            **QDBusMessage**  reply;
        **QDBusReply** <int> api =
        interface->call(QLatin1String("GetAPIVersion"));
            if (api >= 14)
        reply = interface->call(QLatin1String("ProcessWorkUnicode"), value);
        else
              reply = interface->call(QLatin1String("ProcessWork"),
        QLatin1String("UTF-8"), value.toUtf8());

        This example illustrates function calling with 0, 1 and 2 parameters and
        illustrates different parameter types passed in each (the first call to
        `"ProcessWorkUnicode"` will contain one Unicode string, the second call
        to `"ProcessWork"` will contain one string and one byte array).

        **Note:** Before Qt 5.14, this function accepted a maximum of just eight
        (8) arguments.

        **See also** **callWithArgumentList** ().
        """
        ...

    @typing.overload
    def call(self, mode: "QDBus.CallMode", method: str, *a2) -> "QDBusMessage":
        """
        https://doc.qt.io/qt-6/qdbusabstractinterface.html#call-3

        **template <typename Args> QDBusMessage
        QDBusAbstractInterface::call(QDBus::CallMode mode , const QString &
        method , Args &&... args )**

        This is an overloaded function.

        Calls the method **method** on this interface and passes **args** to the
        method. All **args** must be convertible to **QVariant** .

        If **mode** is `NoWaitForReply`, then this function will return
        immediately after placing the call, without waiting for a reply from the
        remote method. Otherwise, **mode** indicates whether this function
        should activate the Qt Event Loop while waiting for the reply to arrive.

        If this function reenters the Qt event loop in order to wait for the
        reply, it will exclude user input. During the wait, it may deliver
        signals and other method calls to your application. Therefore, it must
        be prepared to handle a reentrancy whenever a call is placed with
        call().

        **Note:** Before Qt 5.14, this function accepted a maximum of just eight
        (8) arguments.

        **See also** **callWithArgumentList** ().
        """
        ...

    def timeout(self) -> int:
        """
        https://doc.qt.io/qt-6/qdbusabstractinterface.html#timeout

        **int QDBusAbstractInterface::timeout() const**

        Returns the current value of the timeout in milliseconds. -1 means the
        default DBus timeout (usually 25 seconds).

        **See also** **setTimeout** ().
        """
        ...

    def setTimeout(self, timeout: int) -> None:
        """
        https://doc.qt.io/qt-6/qdbusabstractinterface.html#setTimeout

        **void QDBusAbstractInterface::setTimeout(int timeout )**

        Sets the timeout in milliseconds for all future DBus calls to
        **timeout**. -1 means the default DBus timeout (usually 25 seconds).

        **See also** **timeout** ().
        """
        ...

    def lastError(self) -> "QDBusError":
        """
        https://doc.qt.io/qt-6/qdbusabstractinterface.html#lastError

        **QDBusError QDBusAbstractInterface::lastError() const**

        Returns the error the last operation produced, or an invalid error if
        the last operation did not produce an error.
        """
        ...

    def interface(self) -> str:
        """
        https://doc.qt.io/qt-6/qdbusabstractinterface.html#interface

        **QString QDBusAbstractInterface::interface() const**

        Returns the name of this interface.
        """
        ...

    def path(self) -> str:
        """
        https://doc.qt.io/qt-6/qdbusabstractinterface.html#path

        **QString QDBusAbstractInterface::path() const**

        Returns the object path that this interface is associated with.
        """
        ...

    def service(self) -> str:
        """
        https://doc.qt.io/qt-6/qdbusabstractinterface.html#service

        **QString QDBusAbstractInterface::service() const**

        Returns the name of the service this interface is associated with.
        """
        ...

    def connection(self) -> "QDBusConnection":
        """
        https://doc.qt.io/qt-6/qdbusabstractinterface.html#connection

        **QDBusConnection QDBusAbstractInterface::connection() const**

        Returns the connection this interface is associated with.
        """
        ...

    def isValid(self) -> bool:
        """
        https://doc.qt.io/qt-6/qdbusabstractinterface.html#isValid

        **bool QDBusAbstractInterface::isValid() const**

        Returns `true` if this is a valid reference to a remote object. It
        returns `false` if there was an error during the creation of this
        interface (for instance, if the remote application does not exist).

        Note: when dealing with remote objects, it is not always possible to
        determine if it exists when creating a **QDBusInterface** .
        """
        ...
