"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import enum
import PyQt6.sip
from PyQt6 import QtCore
from PyQt6.QtDBus import *
import enum


class QDBusConnectionInterface(QDBusAbstractInterface):
    """
    https://doc.qt.io/qt-6/qdbusconnectioninterface.html

    **Detailed Description**

    The D-Bus bus server daemon provides one special interface
    `org.freedesktop.DBus` that allows clients to access certain properties of
    the bus, such as the current list of clients connected. The
    QDBusConnectionInterface class provides access to that interface.

    The most common uses of this class are to register and unregister service
    names on the bus using the **registerService** () and **unregisterService**
    () functions, query about existing names using the **isServiceRegistered**
    (), **registeredServiceNames** () and **serviceOwner** () functions, and to
    receive notification that a client has registered or de-registered through
    the **serviceRegistered** (), **serviceUnregistered** () and
    serviceOwnerChanged() signals.
    """

    class RegisterServiceReply(enum.Enum):
        ServiceNotRegistered: QDBusConnectionInterface = ...
        ServiceRegistered: QDBusConnectionInterface = ...
        ServiceQueued: QDBusConnectionInterface = ...

    class ServiceReplacementOptions(enum.Enum):
        DontAllowReplacement: QDBusConnectionInterface = ...
        AllowReplacement: QDBusConnectionInterface = ...

    class ServiceQueueOptions(enum.Enum):
        DontQueueService: QDBusConnectionInterface = ...
        QueueService: QDBusConnectionInterface = ...
        ReplaceExistingService: QDBusConnectionInterface = ...

    def disconnectNotify(self, a0: QtCore.QMetaMethod) -> None:
        ...

    def connectNotify(self, a0: QtCore.QMetaMethod) -> None:
        ...

    def serviceOwnerChanged(self, name: str, oldOwner: str, newOwner: str) -> None:
        ...

    def startService(self, name: str) -> QDBusReply:
        """
        https://doc.qt.io/qt-6/qdbusconnectioninterface.html#startService

        **[slot] QDBusReply<void> QDBusConnectionInterface::startService(const
        QString & name )**

        Requests that the bus start the service given by the name **name**.
        """
        ...

    def serviceUid(self, serviceName: str) -> QDBusReply:
        """
        https://doc.qt.io/qt-6/qdbusconnectioninterface.html#serviceUid

        **[slot] QDBusReply<uint> QDBusConnectionInterface::serviceUid(const
        QString & serviceName ) const**

        Returns the Unix User ID (UID) for the process currently holding the bus
        service **serviceName**.
        """
        ...

    def servicePid(self, serviceName: str) -> QDBusReply:
        """
        https://doc.qt.io/qt-6/qdbusconnectioninterface.html#servicePid

        **[slot] QDBusReply<uint> QDBusConnectionInterface::servicePid(const
        QString & serviceName ) const**

        Returns the Unix Process ID (PID) for the process currently holding the
        bus service **serviceName**.
        """
        ...

    def registerService(
        self,
        serviceName: str,
        qoption: "QDBusConnectionInterface.ServiceQueueOptions" = ...,
        roption: "QDBusConnectionInterface.ServiceReplacementOptions" = ...,
    ) -> QDBusReply:
        """
        https://doc.qt.io/qt-6/qdbusconnectioninterface.html#registerService

        **[slot] QDBusReply<QDBusConnectionInterface::RegisterServiceReply>
        QDBusConnectionInterface::registerService(const QString & serviceName ,
        QDBusConnectionInterface::ServiceQueueOptions qoption =
        DontQueueService, QDBusConnectionInterface::ServiceReplacementOptions
        roption = DontAllowReplacement)**

        Requests to register the service name **serviceName** on the bus. The
        **qoption** flag specifies how the D-Bus server should behave if
        **serviceName** is already registered. The **roption** flag specifies if
        the server should allow another application to replace our registered
        name.

        If the service registration succeeds, the **serviceRegistered** ()
        signal will be emitted. If we are placed in queue, the signal will be
        emitted when we obtain the name. If **roption** is **AllowReplacement**
        , the **serviceUnregistered** () signal will be emitted if another
        application replaces this one.

        **See also** **unregisterService** ().
        """
        ...

    def unregisterService(self, serviceName: str) -> QDBusReply:
        """
        https://doc.qt.io/qt-6/qdbusconnectioninterface.html#unregisterService

        **[slot] QDBusReply<bool>
        QDBusConnectionInterface::unregisterService(const QString & serviceName
        )**

        Releases the claim on the bus service name **serviceName** , that had
        been previously registered with **registerService** (). If this
        application had ownership of the name, it will be released for other
        applications to claim. If it only had the name queued, it gives up its
        position in the queue.
        """
        ...

    def serviceOwner(self, name: str) -> QDBusReply:
        """
        https://doc.qt.io/qt-6/qdbusconnectioninterface.html#serviceOwner

        **[slot] QDBusReply<QString>
        QDBusConnectionInterface::serviceOwner(const QString & name ) const**

        Returns the unique connection name of the primary owner of the name
        **name**. If the requested name doesn't have an owner, returns a
        `org.freedesktop.DBus.Error.NameHasNoOwner` error.
        """
        ...

    def isServiceRegistered(self, serviceName: str) -> QDBusReply:
        """
        https://doc.qt.io/qt-6/qdbusconnectioninterface.html#isServiceRegistered

        **[slot] QDBusReply<bool>
        QDBusConnectionInterface::isServiceRegistered(const QString &
        serviceName ) const**

        Returns `true` if the service name **serviceName** has is currently
        registered.
        """
        ...

    def activatableServiceNames(self) -> QDBusReply:
        """
        https://doc.qt.io/qt-6/qdbusconnectioninterface.html#activatableServiceN
        ames-prop

        **[read-only, since 5.14] activatableServiceNames : const
        QDBusReply<QStringList>**

        holds the activatable service names

        Lists all names that can be activated on the bus.

        This property was introduced in Qt 5.14.

        **Access functions:**

        QDBusReply<QStringList> **activatableServiceNames** () const
        """
        ...

    def registeredServiceNames(self) -> QDBusReply:
        """
        https://doc.qt.io/qt-6/qdbusconnectioninterface.html#registeredServiceNa
        mes-prop

        **[read-only] registeredServiceNames : const QDBusReply<QStringList>**

        holds the registered service names

        Lists all names currently registered on the bus.

        **Access functions:**

        QDBusReply<QStringList> **registeredServiceNames** () const

        **Member Function Documentation**
        """
        ...

    @property
    def callWithCallbackFailed(self) -> PyQt6.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-6/qdbusconnectioninterface.html#callWithCallbackFai
        led

        **[signal] void QDBusConnectionInterface::callWithCallbackFailed(const
        QDBusError & error , const QDBusMessage & call )**

        This signal is emitted when there is an error during a
        **QDBusConnection::callWithCallback** (). **error** specifies the error.
        **call** is the message that couldn't be delivered.

        **See also** **QDBusConnection::callWithCallback** ().
        """
        ...

    @property
    def serviceRegistered(self) -> PyQt6.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-6/qdbusconnectioninterface.html#serviceRegistered

        **[signal] void QDBusConnectionInterface::serviceRegistered(const
        QString & service )**

        This signal is emitted by the D-Bus server when the bus service name
        (unique connection name or well-known service name) given by **service**
        is acquired by this application.

        Acquisition happens after this application has requested a name using
        **registerService** ().
        """
        ...

    @property
    def serviceUnregistered(self) -> PyQt6.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-6/qdbusconnectioninterface.html#serviceUnregistered

        **[signal] void QDBusConnectionInterface::serviceUnregistered(const
        QString & service )**

        This signal is emitted by the D-Bus server when this application loses
        ownership of the bus service name given by **service**.
        """
        ...
