"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import enum
import PyQt6.sip
from PyQt6.QtDBus import *
import enum


class QDBusError(PyQt6.sip.simplewrapper):
    """
    https://doc.qt.io/qt-6/qdbuserror.html

    **Detailed Description**

    When dealing with the D-Bus bus service or with remote applications over
    D-Bus, a number of error conditions can happen. This error conditions are
    sometimes signalled by a returned error value or by a QDBusError.

    C++ and Java exceptions are a valid analogy for D-Bus errors: instead of
    returning normally with a return value, remote applications and the bus may
    decide to throw an error condition. However, the Qt D-Bus implementation
    does not use the C++ exception-throwing mechanism, so you will receive
    QDBusErrors in the return reply (see **QDBusReply::error** ()).

    QDBusError objects are used to inspect the error name and message as
    received from the bus and remote applications. You should not create such
    objects yourself to signal error conditions when called from D-Bus: instead,
    use **QDBusMessage::createError** () and **QDBusConnection::send** ().

    **See also** **QDBusConnection::send** (), **QDBusMessage** , and
    **QDBusReply** .
    """

    class ErrorType(enum.Enum):
        NoError: QDBusError = ...
        Other: QDBusError = ...
        Failed: QDBusError = ...
        NoMemory: QDBusError = ...
        ServiceUnknown: QDBusError = ...
        NoReply: QDBusError = ...
        BadAddress: QDBusError = ...
        NotSupported: QDBusError = ...
        LimitsExceeded: QDBusError = ...
        AccessDenied: QDBusError = ...
        NoServer: QDBusError = ...
        Timeout: QDBusError = ...
        NoNetwork: QDBusError = ...
        AddressInUse: QDBusError = ...
        Disconnected: QDBusError = ...
        InvalidArgs: QDBusError = ...
        UnknownMethod: QDBusError = ...
        TimedOut: QDBusError = ...
        InvalidSignature: QDBusError = ...
        UnknownInterface: QDBusError = ...
        InternalError: QDBusError = ...
        UnknownObject: QDBusError = ...
        InvalidService: QDBusError = ...
        InvalidObjectPath: QDBusError = ...
        InvalidInterface: QDBusError = ...
        InvalidMember: QDBusError = ...
        UnknownProperty: QDBusError = ...
        PropertyReadOnly: QDBusError = ...

    def __init__(self, other: "QDBusError") -> None:
        ...

    def swap(self, other: "QDBusError") -> None:
        """
        https://doc.qt.io/qt-6/qdbuserror.html#swap

        **void QDBusError::swap(QDBusError & other )**

        Swaps this **QDBusError**  instance with **other**.
        """
        ...

    @staticmethod
    def errorString(error: "QDBusError.ErrorType") -> str:
        """
        https://doc.qt.io/qt-6/qdbuserror.html#errorString

        **[static] QString QDBusError::errorString(QDBusError::ErrorType error
        )**

        Returns the error name associated with error condition **error**.
        """
        ...

    def isValid(self) -> bool:
        """
        https://doc.qt.io/qt-6/qdbuserror.html#isValid

        **bool QDBusError::isValid() const**

        Returns `true` if this is a valid error condition (i.e., if there was an
        error), otherwise false.
        """
        ...

    def message(self) -> str:
        """
        https://doc.qt.io/qt-6/qdbuserror.html#message

        **QString QDBusError::message() const**

        Returns the message that the callee associated with this error. Error
        messages are implementation defined and usually contain a human-readable
        error code, though this does not mean it is suitable for your end-users.
        """
        ...

    def name(self) -> str:
        """
        https://doc.qt.io/qt-6/qdbuserror.html#name

        **QString QDBusError::name() const**

        Returns this error's name. Error names are similar to D-Bus Interface
        names, like `org.freedesktop.DBus.InvalidArgs`.

        **See also** **type** ().
        """
        ...

    def type(self) -> "QDBusError.ErrorType":
        """
        https://doc.qt.io/qt-6/qdbuserror.html#type

        **QDBusError::ErrorType QDBusError::type() const**

        Returns this error's **ErrorType** .

        **See also** **ErrorType** .
        """
        ...
