"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import enum
import typing
import PyQt6.sip
from PyQt6.QtDBus import *
import enum


class QDBusMessage(PyQt6.sip.simplewrapper):
    """
    https://doc.qt.io/qt-6/qdbusmessage.html

    **Detailed Description**

    This object can represent any of the four different types of messages
    (**MessageType** ) that can occur on the bus:

    * Method calls
      * Method return values
      * Signal emissions
      * Error codes

    Objects of this type are created with the static **createError** (),
    **createMethodCall** () and **createSignal** () functions. Use the
    **QDBusConnection::send** () function to send the messages.
    """

    class MessageType(enum.Enum):
        InvalidMessage: QDBusMessage = ...
        MethodCallMessage: QDBusMessage = ...
        ReplyMessage: QDBusMessage = ...
        ErrorMessage: QDBusMessage = ...
        SignalMessage: QDBusMessage = ...

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qdbusmessage.html#QDBusMessage

        **QDBusMessage::QDBusMessage()**

        Constructs an empty, invalid QDBusMessage object.

        **See also** **createError** (), **createMethodCall** (), and
        **createSignal** ().
        """
        ...

    @typing.overload
    def __init__(self, other: "QDBusMessage") -> None:
        """
        https://doc.qt.io/qt-6/qdbusmessage.html#QDBusMessage-1

        **QDBusMessage::QDBusMessage(const QDBusMessage & other )**

        Constructs a copy of the object given by **other**.

        Note: QDBusMessage objects are shared. Modifications made to the copy
        will affect the original one as well. See **setDelayedReply** () for
        more information.
        """
        ...

    def isInteractiveAuthorizationAllowed(self) -> bool:
        """
        https://doc.qt.io/qt-6/qdbusmessage.html#isInteractiveAuthorizationAllow
        ed

        **[since 5.12] bool QDBusMessage::isInteractiveAuthorizationAllowed()
        const**

        Returns the interactive authorization allowed flag, as set by
        **setInteractiveAuthorizationAllowed** (). By default this flag is false
        and the other end is expected to make any authorization decisions non-
        interactively and promptly.

        This function was introduced in Qt 5.12.

        **See also** **setInteractiveAuthorizationAllowed** ().
        """
        ...

    def setInteractiveAuthorizationAllowed(self, enable: bool) -> None:
        """
        https://doc.qt.io/qt-6/qdbusmessage.html#setInteractiveAuthorizationAllo
        wed

        **[since 5.12] void
        QDBusMessage::setInteractiveAuthorizationAllowed(bool enable )**

        Sets the interactive authorization flag to **enable**. This flag only
        makes sense for method call messages, where it tells the D-Bus server
        that the caller of the method is prepared to wait for interactive
        authorization to take place (for instance via Polkit) before the actual
        method is processed.

        By default this flag is false and the other end is expected to make any
        authorization decisions non-interactively and promptly.

        The `org.freedesktop.DBus.Error.InteractiveAuthorizationRequired` error
        indicates that authorization failed, but could have succeeded if this
        flag had been set.

        This function was introduced in Qt 5.12.

        **See also** **isInteractiveAuthorizationAllowed** ().
        """
        ...

    @staticmethod
    def createTargetedSignal(
        service: str, path: str, interface: str, name: str
    ) -> "QDBusMessage":
        """
        https://doc.qt.io/qt-6/qdbusmessage.html#createTargetedSignal

        **[static, since 5.6] QDBusMessage
        QDBusMessage::createTargetedSignal(const QString & service , const
        QString & path , const QString & interface , const QString & name )**

        Constructs a new DBus message with the given **path** , **interface**
        and **name** , representing a signal emission to a specific destination.

        A DBus signal is emitted from one application and is received only by
        the application owning the destination **service** name.

        The **QDBusMessage**  object that is returned can be sent using the
        **QDBusConnection::send** () function.

        This function was introduced in Qt 5.6.
        """
        ...

    def swap(self, other: "QDBusMessage") -> None:
        """
        https://doc.qt.io/qt-6/qdbusmessage.html#swap

        **void QDBusMessage::swap(QDBusMessage & other )**

        Swaps this **QDBusMessage**  instance with **other**.
        """
        ...

    def arguments(self) -> typing.List[typing.Any]:
        """
        https://doc.qt.io/qt-6/qdbusmessage.html#arguments

        **QList<QVariant> QDBusMessage::arguments() const**

        Returns the list of arguments that are going to be sent or were received
        from D-Bus.

        **See also** **setArguments** ().
        """
        ...

    def setArguments(self, arguments: typing.Iterable[typing.Any]) -> None:
        """
        https://doc.qt.io/qt-6/qdbusmessage.html#setArguments

        **void QDBusMessage::setArguments(const QList<QVariant> & arguments )**

        Sets the arguments that are going to be sent over D-Bus to
        **arguments**. Those will be the arguments to a method call or the
        parameters in the signal.

        **See also** **arguments** ().
        """
        ...

    def autoStartService(self) -> bool:
        """
        https://doc.qt.io/qt-6/qdbusmessage.html#autoStartService

        **bool QDBusMessage::autoStartService() const**

        Returns the auto start flag, as set by **setAutoStartService** (). By
        default, this flag is true, which means Qt D-Bus will auto start a
        service, if it is not running already.

        **See also** **setAutoStartService** ().
        """
        ...

    def setAutoStartService(self, enable: bool) -> None:
        """
        https://doc.qt.io/qt-6/qdbusmessage.html#setAutoStartService

        **void QDBusMessage::setAutoStartService(bool enable )**

        Sets the auto start flag to **enable**. This flag only makes sense for
        method call messages, where it tells the D-Bus server to either auto
        start the service responsible for the service name, or not to auto start
        it.

        By default this flag is true, i.e. a service is autostarted. This means:

        When the service that this method call is sent to is already running,
        the method call is sent to it. If the service is not running yet, the
        D-Bus daemon is requested to autostart the service that is assigned to
        this service name. This is handled by .service files that are placed in
        a directory known to the D-Bus server. These files then each contain a
        service name and the path to a program that should be executed when this
        service name is requested.

        **See also** **autoStartService** ().
        """
        ...

    def isDelayedReply(self) -> bool:
        """
        https://doc.qt.io/qt-6/qdbusmessage.html#isDelayedReply

        **bool QDBusMessage::isDelayedReply() const**

        Returns the delayed reply flag, as set by **setDelayedReply** (). By
        default, this flag is false, which means Qt D-Bus will generate
        automatic replies when necessary.
        """
        ...

    def setDelayedReply(self, enable: bool) -> None:
        """
        https://doc.qt.io/qt-6/qdbusmessage.html#setDelayedReply

        **void QDBusMessage::setDelayedReply(bool enable ) const**

        Sets whether the message will be replied later (if **enable** is true)
        or if an automatic reply should be generated by Qt D-Bus (if **enable**
        is false).

        In D-Bus, all method calls must generate a reply to the caller, unless
        the caller explicitly indicates otherwise (see **isReplyRequired** ()).
        **QtDBus**  automatically generates such replies for any slots being
        called, but it also allows slots to indicate whether they will take
        responsibility of sending the reply at a later time, after the function
        has finished processing.

        **See also** **isDelayedReply** () and **Delayed Replies** .
        """
        ...

    def isReplyRequired(self) -> bool:
        """
        https://doc.qt.io/qt-6/qdbusmessage.html#isReplyRequired

        **bool QDBusMessage::isReplyRequired() const**

        Returns the flag that indicates if this message should see a reply or
        not. This is only meaningful for **method call messages** : any other
        kind of message cannot have replies and this function will always return
        false for them.
        """
        ...

    def signature(self) -> str:
        """
        https://doc.qt.io/qt-6/qdbusmessage.html#signature

        **QString QDBusMessage::signature() const**

        Returns the signature of the signal that was received or for the output
        arguments of a method call.
        """
        ...

    def type(self) -> "QDBusMessage.MessageType":
        """
        https://doc.qt.io/qt-6/qdbusmessage.html#type

        **QDBusMessage::MessageType QDBusMessage::type() const**

        Returns the message type.
        """
        ...

    def errorMessage(self) -> str:
        """
        https://doc.qt.io/qt-6/qdbusmessage.html#errorMessage

        **QString QDBusMessage::errorMessage() const**

        Returns the human-readable message associated with the error that was
        received.
        """
        ...

    def errorName(self) -> str:
        """
        https://doc.qt.io/qt-6/qdbusmessage.html#errorName

        **QString QDBusMessage::errorName() const**

        Returns the name of the error that was received.
        """
        ...

    def member(self) -> str:
        """
        https://doc.qt.io/qt-6/qdbusmessage.html#member

        **QString QDBusMessage::member() const**

        Returns the name of the signal that was emitted or the name of the
        method that was called.
        """
        ...

    def interface(self) -> str:
        """
        https://doc.qt.io/qt-6/qdbusmessage.html#interface

        **QString QDBusMessage::interface() const**

        Returns the interface of the method being called (in the case of a
        method call) or of the signal being received from.
        """
        ...

    def path(self) -> str:
        """
        https://doc.qt.io/qt-6/qdbusmessage.html#path

        **QString QDBusMessage::path() const**

        Returns the path of the object that this message is being sent to (in
        the case of a method call) or being received from (for a signal).
        """
        ...

    def service(self) -> str:
        """
        https://doc.qt.io/qt-6/qdbusmessage.html#service

        **QString QDBusMessage::service() const**

        Returns the name of the service or the bus address of the remote method
        call.
        """
        ...

    @typing.overload
    def createErrorReply(self, name: str, msg: str) -> "QDBusMessage":
        """
        https://doc.qt.io/qt-6/qdbusmessage.html#createErrorReply

        **QDBusMessage QDBusMessage::createErrorReply(const QString & name ,
        const QString & msg ) const**

        Constructs a new DBus message representing an error reply message, with
        the given **name** and **msg**.
        """
        ...

    @typing.overload
    def createErrorReply(self, error: QDBusError) -> "QDBusMessage":
        """
        https://doc.qt.io/qt-6/qdbusmessage.html#createErrorReply-1

        **QDBusMessage QDBusMessage::createErrorReply(const QDBusError & error )
        const**

        Constructs a new DBus message representing an error reply message, from
        the given **error** object.
        """
        ...

    @typing.overload
    def createErrorReply(self, type: QDBusError.ErrorType, msg: str) -> "QDBusMessage":
        """
        https://doc.qt.io/qt-6/qdbusmessage.html#createErrorReply-2

        **QDBusMessage QDBusMessage::createErrorReply(QDBusError::ErrorType type
        , const QString & msg ) const**

        Constructs a new DBus reply message for the error type **type** using
        the message **msg**. Returns the DBus message.
        """
        ...

    @typing.overload
    def createReply(
        self, arguments: typing.Iterable[typing.Any] = ...
    ) -> "QDBusMessage":
        """
        https://doc.qt.io/qt-6/qdbusmessage.html#createReply

        **QDBusMessage QDBusMessage::createReply(const QList<QVariant> &
        arguments = QList<QVariant>()) const**

        Constructs a new DBus message representing a reply, with the given
        **arguments**.
        """
        ...

    @typing.overload
    def createReply(self, argument: typing.Any) -> "QDBusMessage":
        """
        https://doc.qt.io/qt-6/qdbusmessage.html#createReply-1

        **QDBusMessage QDBusMessage::createReply(const QVariant & argument )
        const**

        Constructs a new DBus message representing a reply, with the given
        **argument**.
        """
        ...

    @typing.overload
    @staticmethod
    def createError(name: str, msg: str) -> "QDBusMessage":
        """
        https://doc.qt.io/qt-6/qdbusmessage.html#createError

        **[static] QDBusMessage QDBusMessage::createError(const QString & name ,
        const QString & msg )**

        Constructs a new DBus message representing an error, with the given
        **name** and **msg**.
        """
        ...

    @typing.overload
    @staticmethod
    def createError(error: QDBusError) -> "QDBusMessage":
        """
        https://doc.qt.io/qt-6/qdbusmessage.html#createError-1

        **[static] QDBusMessage QDBusMessage::createError(const QDBusError &
        error )**

        Constructs a new DBus message representing the given **error**.
        """
        ...

    @typing.overload
    @staticmethod
    def createError(type: QDBusError.ErrorType, msg: str) -> "QDBusMessage":
        """
        https://doc.qt.io/qt-6/qdbusmessage.html#createError-2

        **[static] QDBusMessage QDBusMessage::createError(QDBusError::ErrorType
        type , const QString & msg )**

        Constructs a new DBus message for the error type **type** using the
        message **msg**. Returns the DBus message.
        """
        ...

    @staticmethod
    def createMethodCall(
        service: str, path: str, interface: str, method: str
    ) -> "QDBusMessage":
        """
        https://doc.qt.io/qt-6/qdbusmessage.html#createMethodCall

        **[static] QDBusMessage QDBusMessage::createMethodCall(const QString &
        service , const QString & path , const QString & interface , const
        QString & method )**

        Constructs a new DBus message representing a method call. A method call
        always informs its destination address ( **service** , **path** ,
        **interface** and **method** ).

        The DBus bus allows calling a method on a given remote object without
        specifying the destination interface, if the method name is unique.
        However, if two interfaces on the remote object export the same method
        name, the result is undefined (one of the two may be called or an error
        may be returned).

        When using DBus in a peer-to-peer context (i.e., not on a bus), the
        **service** parameter is optional.

        The **QDBusInterface**  class provides a simpler abstraction to
        synchronous method calling.

        This function returns a **QDBusMessage**  object that can be sent with
        **QDBusConnection::call** ().
        """
        ...

    @staticmethod
    def createSignal(path: str, interface: str, name: str) -> "QDBusMessage":
        """
        https://doc.qt.io/qt-6/qdbusmessage.html#createSignal

        **[static] QDBusMessage QDBusMessage::createSignal(const QString & path
        , const QString & interface , const QString & name )**

        Constructs a new DBus message with the given **path** , **interface**
        and **name** , representing a signal emission.

        A DBus signal is emitted from one application and is received by all
        applications that are listening for that signal from that interface.

        The **QDBusMessage**  object that is returned can be sent using the
        **QDBusConnection::send** () function.
        """
        ...
