"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
import PyQt6.sip
from PyQt6 import QtCore
from PyQt6.QtDBus import *


class QDBusPendingCallWatcher(QtCore.QObject, QDBusPendingCall):
    """
    https://doc.qt.io/qt-6/qdbuspendingcallwatcher.html

    **Detailed Description**

    The QDBusPendingCallWatcher provides the **finished** () signal that will be
    emitted when a reply arrives.

    It is usually used like the following example:

    **QDBusPendingCall**  async = iface->asyncCall("RemoteMethod", value1,
    value2);
            **QDBusPendingCallWatcher**  *watcher = new
    **QDBusPendingCallWatcher** (async, this);

            **QObject**
    ::connect(watcher, SIGNAL(finished(**QDBusPendingCallWatcher** *)),
    this, SLOT(callFinishedSlot(**QDBusPendingCallWatcher** *)));

    Note that it is not necessary to keep the original **QDBusPendingCall**
    object around since QDBusPendingCallWatcher inherits from that class too.

    The slot connected to by the above code could be something similar to the
    following:

    void
    DBus_PendingCall_Interface::callFinishedSlot(**QDBusPendingCallWatcher**
    *call)
        {
            **QDBusPendingReply** <**QString** , **QByteArray** >
    reply = *call;
            if (reply.isError()) {
                showError();
    } else {
                **QString**  text = reply.argumentAt<0>();
    **QByteArray**  data = reply.argumentAt<1>();
                showReply(text,
    data);
            }
            call->deleteLater();
        }

    Note the use of **QDBusPendingReply**  to validate the argument types in the
    reply. If the reply did not contain exactly two arguments (one string and
    one **QByteArray** ), **QDBusPendingReply::isError** () will return true.

    **See also** **QDBusPendingReply** .
    """

    def __init__(
        self, call: QDBusPendingCall, parent: typing.Optional[QtCore.QObject] = ...
    ) -> None:
        """
        https://doc.qt.io/qt-6/qdbuspendingcallwatcher.html#QDBusPendingCallWatc
        her

        **QDBusPendingCallWatcher::QDBusPendingCallWatcher(const
        QDBusPendingCall & call , QObject * parent = nullptr)**

        Creates a QDBusPendingCallWatcher object to watch for replies on the
        asynchronous pending call **call** and sets this object's parent to
        **parent**.
        """
        ...

    def waitForFinished(self) -> None:
        """
        https://doc.qt.io/qt-6/qdbuspendingcallwatcher.html#waitForFinished

        **void QDBusPendingCallWatcher::waitForFinished()**

        Suspends the execution of the calling thread until the reply is received
        and processed. After this function returns, **isFinished** () should
        return true, indicating the reply's contents are ready to be processed.

        **See also** **QDBusPendingReply::waitForFinished** ().
        """
        ...

    def isFinished(self) -> bool:
        """
        https://doc.qt.io/qt-6/qdbuspendingcallwatcher.html#isFinished

        **bool QDBusPendingCallWatcher::isFinished() const**

        Returns `true` if the pending call has finished processing and the reply
        has been received.

        Note that this function only changes state if you call
        **waitForFinished** () or if an external D-Bus event happens, which in
        general only happens if you return to the event loop execution.

        **See also** **QDBusPendingReply::isFinished** ().
        """
        ...

    @property
    def finished(self) -> PyQt6.QtCore.pyqtBoundSignal:
        """
        https://doc.qt.io/qt-6/qdbuspendingcallwatcher.html#finished

        **[signal] void
        QDBusPendingCallWatcher::finished(QDBusPendingCallWatcher * self =
        nullptr)**

        This signal is emitted when the pending call has finished and its reply
        is available. The **self** parameter is a pointer to the object itself,
        passed for convenience so that the slot can access the properties and
        determine the contents of the reply.
        """
        ...
