"""
PySide stub files generated by **IceSpringPySideStubs**

Home: https://baijifeilong.github.io/2022/01/06/ice-spring-pyside-stubs/index.html

Github: https://github.com/baijifeilong/IceSpringPySideStubs

PyPI(PySide2): https://pypi.org/project/IceSpringPySideStubs-PySide2

PyPI(PySide6): https://pypi.org/project/IceSpringPySideStubs-PySide6

PyPI(PyQt5): https://pypi.org/project/IceSpringPySideStubs-PyQt5

PyPI(PyQt6): https://pypi.org/project/IceSpringPySideStubs-PyQt6

Generated by BaiJiFeiLong@gmail.com

Licence: MIT
"""
import typing
from PyQt6.QtDBus import *


class QDBusPendingReply(QDBusPendingCall):
    """
    https://doc.qt.io/qt-6/qdbuspendingreply.html

    **Detailed Description**

    The QDBusPendingReply is a variadic template class. The template parameters
    are the types that will be used to extract the contents of the reply's data.

    This class is similar in functionality to **QDBusReply** , but with two
    important differences:

    * **QDBusReply**  accepts exactly one return type, whereas QDBusPendingReply
    can have any number of types
      * **QDBusReply**  only works on already
    completed replies, whereas QDBusPendingReply allows one to wait for replies
    from pending calls

    Where with **QDBusReply**  you would write:

    **QDBusReply** <**QString** > reply = interface->call("RemoteMethod");
    if (reply.isValid())
            // use the returned value
    useValue(reply.value());
        else
            // call failed. Show an error
    condition.
            showError(reply.error());

    with QDBusPendingReply, the equivalent code (including the blocking wait for
    the reply) would be:

    **QDBusPendingReply** <**QString** > reply =
    iface->asyncCall("RemoteMethod");
            reply.waitForFinished();
    if (reply.isError())
                // call failed. Show an error condition.
    showErrorD(reply.error());
            else
                // use the returned
    value
                useValue(reply.value());

    For method calls that have more than one output argument, with
    **QDBusReply** , you would write:

    reply = interface->call("RemoteMethod");

    whereas with QDBusPendingReply, all of the output arguments should be
    template parameters:

    **QDBusPendingReply** <bool, **QString** > reply =
    iface->asyncCall("RemoteMethod");
            reply.waitForFinished();
    if (!reply.isError()) {
                if (reply.argumentAt<0>())
    showSuccess(reply.argumentAt<1>());
                else
    showFailure(reply.argumentAt<1>());
            }

    QDBusPendingReply objects can be associated with **QDBusPendingCallWatcher**
    objects, which emit signals when the reply arrives.

    **See also** **QDBusPendingCallWatcher**  and **QDBusReply** .
    """

    @typing.overload
    def __init__(self) -> None:
        """
        https://doc.qt.io/qt-6/qdbuspendingreply.html#QDBusPendingReply

        **QDBusPendingReply::QDBusPendingReply()**

        Creates an empty QDBusPendingReply object. Without assigning a
        **QDBusPendingCall**  object to this reply, QDBusPendingReply cannot do
        anything. All functions return their failure values.
        """
        ...

    @typing.overload
    def __init__(self, other: "QDBusPendingReply") -> None:
        """
        https://doc.qt.io/qt-6/qdbuspendingreply.html#QDBusPendingReply-1

        **QDBusPendingReply::QDBusPendingReply(const QDBusPendingReply<Types...>
        & other )**

        Creates a copy of the **other** QDBusPendingReply object. Just like
        **QDBusPendingCall**  and **QDBusPendingCallWatcher** , this
        QDBusPendingReply object will share the same pending call reference. All
        copies share the same return values.
        """
        ...

    @typing.overload
    def __init__(self, call: QDBusPendingCall) -> None:
        """
        https://doc.qt.io/qt-6/qdbuspendingreply.html#QDBusPendingReply-2

        **QDBusPendingReply::QDBusPendingReply(const QDBusPendingCall & call )**

        Creates a QDBusPendingReply object that will take its contents from the
        **call** pending asynchronous call. This QDBusPendingReply object will
        share the same pending call reference as **call**.
        """
        ...

    @typing.overload
    def __init__(self, reply: QDBusMessage) -> None:
        """
        https://doc.qt.io/qt-6/qdbuspendingreply.html#QDBusPendingReply-3

        **QDBusPendingReply::QDBusPendingReply(const QDBusMessage & message )**

        Creates a QDBusPendingReply object that will take its contents from the
        message **message**. In this case, this object will be already in its
        finished state and the reply's contents will be accessible.

        **See also** **isFinished** ().
        """
        ...

    def value(self, type: typing.Any = ...) -> typing.Any:
        """
        https://doc.qt.io/qt-6/qdbuspendingreply.html#value

        **typename Select<0>::Type QDBusPendingReply::value() const**

        Returns the first argument in this reply, cast to type `Types[0]` (the
        first template parameter of this class). This is equivalent to calling
        **argumentAt** <0>().

        This function is provided as a convenience, matching the
        **QDBusReply::value** () function.

        Note that, if the reply hasn't arrived, this function causes the calling
        thread to block until the reply is processed.

        If the reply is an error reply, this function returns a default-
        constructed `Types[0]` object, which may be indistinguishable from a
        valid value. To reliably determine whether the message was an error, use
        **isError** ().
        """
        ...

    def waitForFinished(self) -> None:
        """
        https://doc.qt.io/qt-6/qdbuspendingreply.html#waitForFinished

        **void QDBusPendingReply::waitForFinished()**

        Suspends the execution of the calling thread until the reply is received
        and processed. After this function returns, **isFinished** () should
        return true, indicating the reply's contents are ready to be processed.

        **See also** **QDBusPendingCallWatcher::waitForFinished** ().
        """
        ...

    def reply(self) -> QDBusMessage:
        """
        https://doc.qt.io/qt-6/qdbuspendingreply.html#reply

        **QDBusMessage QDBusPendingReply::reply() const**

        Retrieves the reply message received for the asynchronous call that was
        sent, if it has finished processing. If the pending call is not
        finished, this function returns a **QDBusMessage**  of type
        **QDBusMessage::InvalidMessage** .

        After it has finished processing, the message type will either be an
        error message or a normal method reply message.
        """
        ...

    def isValid(self) -> bool:
        """
        https://doc.qt.io/qt-6/qdbuspendingreply.html#isValid

        **bool QDBusPendingReply::isValid() const**

        Returns `true` if the reply contains a normal reply message, false if it
        contains anything else.

        If the pending call has not finished processing, this function return
        false.
        """
        ...

    def isFinished(self) -> bool:
        """
        https://doc.qt.io/qt-6/qdbuspendingreply.html#isFinished

        **bool QDBusPendingReply::isFinished() const**

        Returns `true` if the pending call has finished processing and the reply
        has been received. If this function returns `true`, the **isError** (),
        **error** () and **reply** () methods should return valid information.

        Note that this function only changes state if you call
        **waitForFinished** () or if an external D-Bus event happens, which in
        general only happens if you return to the event loop execution.

        **See also** **QDBusPendingCallWatcher::isFinished** ().
        """
        ...

    def isError(self) -> bool:
        """
        https://doc.qt.io/qt-6/qdbuspendingreply.html#isError

        **bool QDBusPendingReply::isError() const**

        Returns `true` if the reply contains an error message, false if it
        contains a normal method reply.

        If the pending call has not finished processing, this function also
        returns `true`.
        """
        ...

    def error(self) -> QDBusError:
        """
        https://doc.qt.io/qt-6/qdbuspendingreply.html#error

        **QDBusError QDBusPendingReply::error() const**

        Retrieves the error content of the reply message, if it has finished
        processing. If the reply message has not finished processing or if it
        contains a normal reply message (non-error), this function returns an
        invalid **QDBusError** .
        """
        ...

    def argumentAt(self, index: int) -> typing.Any:
        """
        https://doc.qt.io/qt-6/qdbuspendingreply.html#argumentAt-1

        **QVariant QDBusPendingReply::argumentAt(int index ) const**

        Returns the argument at position **index** in the reply's contents. If
        the reply doesn't have that many elements, this function's return value
        is undefined (will probably cause an assertion failure), so it is
        important to verify that the processing is finished and the reply is
        valid.

        If the reply does not contain an argument at position **index** or if
        the reply was an error, this function returns an invalid **QVariant** .
        Since D-Bus messages can never contain invalid QVariants, this return
        can be used to detect an error condition.
        """
        ...
